#!/usr/bin/python
# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

# pylint: disable=consider-using-with
# pylint: disable=unspecified-encoding

import contextlib
import fcntl
import os


def setup_lock(lockfile_path):
    lock_file_dir = os.path.dirname(lockfile_path)
    if lock_file_dir and not os.path.exists(lock_file_dir):
        os.makedirs(lock_file_dir)

    fd = open(lockfile_path, 'a+')

    # waiting till lock is acquired
    fcntl.flock(fd, fcntl.LOCK_EX)

    fd.seek(0, 0)
    fd.truncate()
    fd.write(str(os.getpid()))
    fd.flush()

    return fd


def release_lock(fd):
    fcntl.flock(fd.fileno(), fcntl.LOCK_UN)
    fd.close()


@contextlib.contextmanager
def acquire_lock(lockfile_path):
    """
    Usage:
    with acquire_lock():
       ... do something ...
    """
    fd = setup_lock(lockfile_path)
    try:
        yield
    finally:
        release_lock(fd)
