# -*- coding: utf-8 -*-
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
#
from .helpers import hook_method

__author__ = "Aleksandr Shyshatsky"


class ModifyDomainHook:
    """
    This hook provides bunch of events related
    to domain manipulations like create, rename, transit, etc.
    """
    HOOK_VERSION = 1

    @hook_method
    def post_create_domain(self, username, domain):
        """
        Called when domain is created in control panel.
        :param username: owner of the domain
        :param domain: name before rename
        """
        pass

    @hook_method
    def post_modify_domain(self, username, domain, new_domain=None, include_subdomains=None, **kwargs):
        """
        Called when domain is renamed in control panel.
        Also called when the whole site is transferred to new domain.
        :param username: owner of the domain
        :param domain: name before rename
        :param new_domain: name after rename [optional]
        :param include_subdomains: whether subdomains are renamed too [optional]
        :param kwargs: any other args
        """
        pass

    @hook_method
    def post_delete_domain(self, username, domain):
        """
        Called when domain is completely removed from control
        panel, but domain owner still exists as unix user.
        :param username: owner of the domain
        :param domain: name before rename
        """
        pass
