#!/opt/cloudlinux/venv/bin/python3 -bb
# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2022 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
#
"""
Package POST modification hook.
This script must be called AFTER different package-related
changes in control panel. See --help and docs for detailed
description of actions and parameters.
"""
import argparse

from clcommon.public_hooks.lib import ModifyPackageHook
from clcommon.public_hooks import setup_logger_and_sentry


if __name__ == '__main__':
    setup_logger_and_sentry()

    parser = argparse.ArgumentParser(description=__doc__)
    subparsers = parser.add_subparsers(dest='command')

    rename = subparsers.add_parser('rename')
    rename.add_argument('--name', required=True,
                        help='Name of the package')
    rename.add_argument('--new-name', required=False,
                        help='Package after rename')

    args = parser.parse_args()
    listener = ModifyPackageHook()
    if args.command == 'rename':
        listener.post_modify_package(
            args.name,
            new_name=args.new_name,
        )
    else:
        raise NotImplementedError
