#!/opt/cloudlinux/venv/bin/python3 -bb
# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
#
"""
Admin account POST modification hook.
This script must be called AFTER different admin-related
changes in control panel. See --help and docs for detailed
description of actions and parameters.
"""
import argparse

from clcommon.public_hooks.lib import ModifyAdminHook
from clcommon.public_hooks import setup_logger_and_sentry


if __name__ == '__main__':
    setup_logger_and_sentry()

    parser = argparse.ArgumentParser(description=__doc__)
    subparsers = parser.add_subparsers(dest='command')

    create = subparsers.add_parser('create')
    create.add_argument('--name', '-n', required=True,
                        help='Name of newly created admin account')

    delete = subparsers.add_parser('delete')
    delete.add_argument('--name', '-n', required=True,
                        help='Name of deleted admin account')

    args = parser.parse_args()
    listener = ModifyAdminHook()
    if args.command == 'create':
        listener.post_create_admin(args.name)
    elif args.command == 'delete':
        listener.post_delete_admin(args.name)
    else:
        raise NotImplementedError
