# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2020 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENCE.TXT
#

import socket


def get_hostname():
    try:
        return socket.gethostname()
    except Exception:
        return None


def get_ip_addr(hostname):
    try:
        return socket.gethostbyname(hostname)
    except socket.error:
        return None
