# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2020 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENCE.TXT
#

import os

from clcommon.lib.config import Config

CLN_JWT_TOKEN_PATH = '/etc/sysconfig/rhn/jwt.token'
CL_EDITION_FILE_FOR_USERS = '/opt/cloudlinux/cl_edition'

c = Config()
DEFAULT_JWT_ES_TOKEN_PATH = c.get_value(
    'jwt_token_file',
    CLN_JWT_TOKEN_PATH
)
PUSHGATEWAY_ADDRESS = c.get_value(
    'pushgateway_address',
    'https://cm.cloudlinux.com'
)
DEFAULT_PUSHGATEWAY_URL = f'{PUSHGATEWAY_ADDRESS}/pushgateway/store'
DEFAULT_PUSHGATEWAY_CHECK_URL = f'{PUSHGATEWAY_ADDRESS}/pushgateway/check'

DISABLE_CMT_DIR = "/etc/cl_plus"
DISABLE_CMT_FILE = os.path.join(DISABLE_CMT_DIR, ".disabled")

ACCELERATE_WP_INSTALLED_FROM_CM = os.path.join('/var/clwpos/admin', "awp_from_cm_installed.flag")
ACCELERATE_WP_PREMIUM_INSTALLED_FROM_CM = os.path.join('/var/clwpos/admin', "awp_premium_from_cm_installed.flag")
