# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2020 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENCE.TXT
#

import yaml
import os


class Config:

    CONFIG_PATH = '/etc/sysconfig/endservertools.yml'

    def __init__(self, config=CONFIG_PATH):
        self._config_path = config

    def _load(self):
        if not os.path.exists(self._config_path):
            return None
        try:
            with open(self._config_path, encoding='utf-8') as f:
                data = yaml.load(f, yaml.SafeLoader)
        except yaml.YAMLError:
            return None
        return data

    def get_value(self, parameter, default=None):
        data = self._load()
        if data is None:
            return default
        return data.get(parameter, default)
