# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from clcommon.clexception import FormattedException
from .const import CLCPAPI_NAME


class CPAPIException(FormattedException):
    def __init__(self, exc_message):
        super().__init__(exc_message)
        self.message = f'{CLCPAPI_NAME}: {self.message}'


class NotSupported(CPAPIException):
    pass


class NoDBAccessData(CPAPIException):
    pass


class NoPanelUser(CPAPIException):
    pass


class NoPanelPackage(CPAPIException):
    pass


class NoPackage(CPAPIException):
    pass


class PluginImportError(CPAPIException):
    pass


class NoDomain(CPAPIException):
    pass


class DuplicateData(CPAPIException):
    pass


class ReadFileError(CPAPIException):
    pass


class CPAPIExternalProgramFailed(CPAPIException):
    pass


class ParsingError(CPAPIException):
    pass


class IncorrectData(CPAPIException):
    pass


class EncodingError(CPAPIException):
    def __init__(self, message, **context):
        exc_message = {
            'message': message,
            'context': context}
        super().__init__(exc_message)


class CpApiTypeError(CPAPIException):
    def __init__(self, funcname=None, supportedtypes=None, received_type=None):
        exc_message = {
            'message': "in function %(funcname)s argument must be %(supportedtypes)s, not '%(received_type)s'",
            'context': {
                'funcname': funcname or '<api function>',
                'supportedtypes': supportedtypes or '<supported types>',
                'received_type': received_type or '<received type>'
            }}
        super().__init__(exc_message)
