# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2024 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
BASEDIR = '/var/cagefs'

CL_ALT_NAME = 'cl.selector'
CL_ALT_CAGEFS_NAME = 'cl.selector.conf.d'

CL_PHP_DIR_NAME = 'cl.php.d'

ETC_CL_ALT_PATH = f'/etc/{CL_ALT_NAME}'
ETC_CL_ALT_CAGEFS_PATH = f'/etc/{CL_ALT_CAGEFS_NAME}'

ETC_CL_PHP_PATH = f'/etc/{CL_PHP_DIR_NAME}'

CL_ALT_CONF = f'{ETC_CL_ALT_PATH}/selector.conf'
CL_ALT_CAGEFS_CONF = f'{ETC_CL_ALT_CAGEFS_PATH}/selector.conf'

SYMLINKS = {
    '%s/etc/cl.selector/ea-php': ('php', '/opt/cpanel/%s/root/usr/bin/php-cgi.cagefs'),
    '%s/etc/cl.selector/ea-php-cli': ('php-cli', '/opt/cpanel/%s/root/usr/bin/php.cagefs'),
    '%s/etc/cl.selector/ea-php.ini': ('php.ini', '/opt/cpanel/%s/root/etc/php.ini.cagefs'),
    '%s/etc/cl.selector/ea-lsphp': ('lsphp', '/opt/cpanel/%s/root/usr/bin/lsphp.cagefs'),
}
