# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2024 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
import functools
import os

from clcagefslib.const import CL_ALT_CONF, CL_ALT_CAGEFS_CONF
from clcagefslib.io import read_file_cached
from clcommon import clcagefs


# Reads config file and returns paths to alternative binaries (as dictionary)
def get_alt_paths(php_state=None):
    cl_alt_conf = CL_ALT_CAGEFS_CONF if clcagefs.in_cagefs() else CL_ALT_CONF
    alt_paths = {}
    if os.path.isfile(cl_alt_conf):
        lines = read_file_cached(cl_alt_conf)
        for line in lines:
            line = line.rstrip()
            if line != "":
                ar = line.split()
                if len(ar) == 4:
                    vers = ar[1]
                    if (php_state is None) or (vers not in php_state) or (php_state[vers]):
                        path = ar[3]
                        alt_paths[path] = 1
    return alt_paths


# Returns list of dirnames like ['php51', 'php52']
@functools.cache
def get_alt_dirs():
    alt_paths = get_alt_paths()
    alt_dirs = {}
    for path in alt_paths:
        # Split string like "/opt/alt/php51/usr/bin/php"
        ar = path.split('/')
        dirname = ar[3]
        if dirname.startswith('php') and dirname[len('php'):].isnumeric():
            alt_dirs[dirname] = 1
    return list(alt_dirs.keys())
