/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => {
    // webpackBootstrap
    /******/ var __webpack_modules__ = {
        /***/ "./webpack/restore-database.js":
            /*!*************************************!*\
  !*** ./webpack/restore-database.js ***!
  \*************************************/
            /***/ () => {
                eval(
                    "{/**\n * Restore Database Application Logic\n * Handles the database restoration workflow\n */\n\n$(document).ready(function() {\n    // Initialize file input\n    initializeFileInput();\n    \n    // Bind form submission\n    $('#restoredatabase').on('submit', function(event) {\n        event.preventDefault();\n        handleRestoreSubmit($(this));\n        return false;\n    });\n});\n\n/**\n * Initialize the file input with drag-drop support\n */\nfunction initializeFileInput() {\n    const $dropzone = $('#dropzone');\n    const $fileInput = $('#restoreFile');\n    const $fileInfo = $('#fileInfo');\n    const $fileName = $('#fileName');\n    const $fileSize = $('#fileSize');\n\n    // Click to select file - use native click to avoid event bubbling issues\n    $dropzone.on('click', function(e) {\n        // Prevent triggering if clicking on the input itself\n        if (e.target === $fileInput[0]) {\n            return;\n        }\n        $fileInput[0].click();\n    });\n\n    // Handle file selection\n    $fileInput.on('change', function() {\n        const file = this.files[0];\n        if (file) {\n            displayFileInfo(file);\n        }\n    });\n\n    // Prevent click events from file input from bubbling to dropzone\n    $fileInput.on('click', function(e) {\n        e.stopPropagation();\n    });\n\n    // Drag and drop handlers\n    $dropzone.on('dragover dragenter', function(e) {\n        e.preventDefault();\n        e.stopPropagation();\n        $(this).addClass('dragover');\n    });\n\n    $dropzone.on('dragleave dragend', function(e) {\n        e.preventDefault();\n        e.stopPropagation();\n        $(this).removeClass('dragover');\n    });\n\n    $dropzone.on('drop', function(e) {\n        e.preventDefault();\n        e.stopPropagation();\n        $(this).removeClass('dragover');\n        \n        const files = e.originalEvent.dataTransfer.files;\n        if (files.length > 0) {\n            $fileInput[0].files = files;\n            displayFileInfo(files[0]);\n        }\n    });\n\n    /**\n     * Display selected file information\n     * @param {File} file - The selected file\n     */\n    function displayFileInfo(file) {\n        $fileName.text(file.name);\n        $fileSize.text(formatFileSize(file.size));\n        $fileInfo.removeClass('d-none');\n        $dropzone.addClass('has-file');\n    }\n}\n\n/**\n * Format file size in human-readable format\n * @param {number} bytes - File size in bytes\n * @returns {string} Formatted file size\n */\nfunction formatFileSize(bytes) {\n    if (bytes === 0) return '0 Bytes';\n    const k = 1024;\n    const sizes = ['Bytes', 'KB', 'MB', 'GB'];\n    const i = Math.floor(Math.log(bytes) / Math.log(k));\n    return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];\n}\n\n/**\n * Handle restore form submission\n * @param {jQuery} $form - The form element\n */\nfunction handleRestoreSubmit($form) {\n    var formData = new FormData($form[0]);\n    var file = document.getElementById('restoreFile').files[0];\n    \n    // Validate file is selected\n    if (!file) {\n        window.CRM.notify(i18next.t('Please select a backup file to restore'), {\n            type: 'error',\n            delay: 3000\n        });\n        return;\n    }\n    \n    // Validate file size if browser supports FileReader\n    if (window.FileReader && file.size > window.CRM.maxUploadSizeBytes) {\n        window.CRM.DisplayErrorMessage(\"/api/database/restore\", {\n            message: i18next.t('The selected file exceeds this servers maximum upload size of') + ': ' + window.CRM.maxUploadSize\n        });\n        return;\n    }\n\n    // Update UI to show restore is running\n    setRestoreStatus('running');\n\n    $.ajax({\n        url: window.CRM.root + '/api/database/restore',\n        type: 'POST',\n        data: formData,\n        cache: false,\n        contentType: false,\n        enctype: 'multipart/form-data',\n        processData: false,\n        dataType: 'json'\n    })\n    .done(function(data) {\n        // Show any messages from the restore process in the modal\n        if (data.Messages && data.Messages.length > 0) {\n            var $messages = $('#restoreModalMessages');\n            $messages.empty();\n            $.each(data.Messages, function(index, value) {\n                $('<div>')\n                    .addClass('alert alert-warning mt-2')\n                    .html('<i class=\"fa-solid fa-exclamation-triangle mr-2\"></i>' + value)\n                    .appendTo($messages);\n            });\n        }\n        \n        // Hide the running status\n        setRestoreStatus('idle');\n        \n        // Show success modal overlay\n        $('#restoreSuccessModal').modal('show');\n        \n        // Log out the user via API\n        $.ajax({\n            url: window.CRM.root + '/session/end',\n            type: 'GET'\n        });\n        \n        // Start countdown and redirect\n        var countdown = 5;\n        var countdownInterval = setInterval(function() {\n            countdown--;\n            $('#redirectCountdown strong').text(countdown);\n            \n            if (countdown <= 0) {\n                clearInterval(countdownInterval);\n                window.location.href = window.CRM.root + '/';\n            }\n        }, 1000);\n    })\n    .fail(function(xhr, status, error) {\n        let errorMessage = i18next.t('Restore failed. Please check the backup file and try again.');\n        \n        if (xhr.responseJSON && xhr.responseJSON.message) {\n            errorMessage = xhr.responseJSON.message;\n        }\n        \n        setRestoreStatus('error', errorMessage);\n    });\n}\n\n/**\n * Set the restore status display\n * @param {string} status - One of: 'idle', 'running', 'complete', 'error'\n * @param {string} [errorMessage] - Optional error message for error status\n */\nfunction setRestoreStatus(status, errorMessage) {\n    $('#statusIdle, #statusRunning, #statusComplete, #statusError').addClass('d-none');\n    $('#statusCard').removeClass('card-primary card-success card-danger card-warning');\n    \n    switch(status) {\n        case 'idle':\n            $('#statusIdle').removeClass('d-none');\n            break;\n        case 'running':\n            $('#statusRunning').removeClass('d-none');\n            $('#statusCard').addClass('card-warning');\n            break;\n        case 'complete':\n            $('#statusComplete').removeClass('d-none');\n            $('#statusCard').addClass('card-success');\n            break;\n        case 'error':\n            if (errorMessage) {\n                $('#errorMessage').text(errorMessage);\n            }\n            $('#statusError').removeClass('d-none');\n            $('#statusCard').addClass('card-danger');\n            break;\n    }\n}\n\n// Export functions to global scope\nwindow.RestoreDatabase = {\n    setRestoreStatus,\n    formatFileSize\n};\n\n\n//# sourceURL=webpack://churchcrm/./webpack/restore-database.js?\n}",
                );

                /***/
            },

        /***/ "./webpack/restore.js":
            /*!****************************!*\
  !*** ./webpack/restore.js ***!
  \****************************/
            /***/ (__unused_webpack_module, __webpack_exports__, __webpack_require__) => {
                "use strict";
                eval(
                    '{__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _restore_database_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./restore-database.js */ "./webpack/restore-database.js");\n/* harmony import */ var _restore_database_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_restore_database_js__WEBPACK_IMPORTED_MODULE_0__);\n// Restore Database webpack entry point\n\n\n\n//# sourceURL=webpack://churchcrm/./webpack/restore.js?\n}',
                );

                /***/
            },

        /******/
    };
    /************************************************************************/
    /******/ // The module cache
    /******/ var __webpack_module_cache__ = {};
    /******/
    /******/ // The require function
    /******/ function __webpack_require__(moduleId) {
        /******/ // Check if module is in cache
        /******/ var cachedModule = __webpack_module_cache__[moduleId];
        /******/ if (cachedModule !== undefined) {
            /******/ return cachedModule.exports;
            /******/
        }
        /******/ // Create a new module (and put it into the cache)
        /******/ var module = (__webpack_module_cache__[moduleId] = {
            /******/ // no module.id needed
            /******/ // no module.loaded needed
            /******/ exports: {},
            /******/
        });
        /******/
        /******/ // Execute the module function
        /******/ __webpack_modules__[moduleId](module, module.exports, __webpack_require__);
        /******/
        /******/ // Return the exports of the module
        /******/ return module.exports;
        /******/
    }
    /******/
    /************************************************************************/
    /******/ /* webpack/runtime/compat get default export */
    /******/ (() => {
        /******/ // getDefaultExport function for compatibility with non-harmony modules
        /******/ __webpack_require__.n = (module) => {
            /******/ var getter =
                module && module.__esModule ? /******/ () => module["default"] : /******/ () => module;
            /******/ __webpack_require__.d(getter, { a: getter });
            /******/ return getter;
            /******/
        };
        /******/
    })();
    /******/
    /******/ /* webpack/runtime/define property getters */
    /******/ (() => {
        /******/ // define getter functions for harmony exports
        /******/ __webpack_require__.d = (exports, definition) => {
            /******/ for (var key in definition) {
                /******/ if (__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
                    /******/ Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
                    /******/
                }
                /******/
            }
            /******/
        };
        /******/
    })();
    /******/
    /******/ /* webpack/runtime/hasOwnProperty shorthand */
    /******/ (() => {
        /******/ __webpack_require__.o = (obj, prop) => Object.prototype.hasOwnProperty.call(obj, prop);
        /******/
    })();
    /******/
    /******/ /* webpack/runtime/make namespace object */
    /******/ (() => {
        /******/ // define __esModule on exports
        /******/ __webpack_require__.r = (exports) => {
            /******/ if (typeof Symbol !== "undefined" && Symbol.toStringTag) {
                /******/ Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
                /******/
            }
            /******/ Object.defineProperty(exports, "__esModule", { value: true });
            /******/
        };
        /******/
    })();
    /******/
    /************************************************************************/
    /******/
    /******/ // startup
    /******/ // Load entry module and return exports
    /******/ // This entry module can't be inlined because the eval devtool is used.
    /******/ var __webpack_exports__ = __webpack_require__("./webpack/restore.js");
    /******/
    /******/
})();
