<?php

require_once '../Include/LoadConfig.php';

// This file is generated by Composer
require_once __DIR__ . '/../vendor/autoload.php';

use ChurchCRM\dto\SystemConfig;
use ChurchCRM\model\ChurchCRM\KioskDevice;
use ChurchCRM\model\ChurchCRM\KioskDeviceQuery;
use ChurchCRM\Slim\Middleware\AuthMiddleware;
use ChurchCRM\Slim\Middleware\CorsMiddleware;
use ChurchCRM\Slim\Middleware\VersionMiddleware;
use ChurchCRM\Slim\SlimUtils;
use Slim\Factory\AppFactory;
use Symfony\Component\DependencyInjection\ContainerBuilder;

// Get base path by combining $sRootPath from Config.php with /kiosk endpoint
// Examples: '' + '/kiosk' = '/kiosk' (root install)
//           '/churchcrm' + '/kiosk' = '/churchcrm/kiosk' (subdirectory install)
$basePath = SlimUtils::getBasePath('/kiosk');

$container = new ContainerBuilder();

// Initialize kiosk device
$windowOpen = new \DateTimeImmutable(SystemConfig::getValue('sKioskVisibilityTimestamp')) > new \DateTimeImmutable();
$Kiosk = null;

if (isset($_COOKIE['kioskCookie'])) {
    $g = hash('sha256', $_COOKIE['kioskCookie']);
    $Kiosk = KioskDeviceQuery::create()
          ->findOneByGUIDHash($g);

    if ($Kiosk === null) {
        setcookie('kioskCookie', '', ['expires' => time() - 3600]);
        header('Location: ' . $_SERVER['REQUEST_URI']);
    }
} else {
    if ($windowOpen) {
        $guid = uniqid();
        setcookie('kioskCookie', $guid, ['expires' => 2_147_483_647]);
        $Kiosk = new KioskDevice();
        $Kiosk->setGUIDHash(hash('sha256', $guid));
        $Kiosk->setAccepted(false);
        $Kiosk->save();
    } else {
        header('HTTP/1.1 401 Unauthorized');
        exit;
    }
}

// Store kiosk in container before compiling
if ($Kiosk !== null) {
    $container->set('kiosk', $Kiosk);
}

// Compile container and create app
$container->compile();
AppFactory::setContainer($container);
$app = AppFactory::create();
$app->setBasePath($basePath);

// Add Slim error middleware for proper error handling and logging
$errorMiddleware = $app->addErrorMiddleware(true, true, true);
SlimUtils::setupErrorLogger($errorMiddleware);
SlimUtils::registerDefaultJsonErrorHandler($errorMiddleware);

$app->addBodyParsingMiddleware();
$app->addRoutingMiddleware();

$app->add(new CorsMiddleware());
$app->add(AuthMiddleware::class);
$app->add(VersionMiddleware::class);

// routes
require __DIR__ . '/routes/kiosk.php';

// Run app
$app->run();
