<?php

declare (strict_types=1);
/*
 * This file is part of PHP CS Fixer.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *     Dariusz Rumiński <dariusz.ruminski@gmail.com>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */
namespace PhpCsFixer\RuleSet\Sets;

use PhpCsFixer\RuleSet\AbstractMigrationSetDefinition;
/**
 * @internal
 *
 * @no-named-arguments Parameter names are not covered by the backward compatibility promise.
 */
final class PHP8x4MigrationSet extends AbstractMigrationSetDefinition
{
    public function getRules() : array
    {
        return ['@PHP8x3Migration' => \true, 'new_expression_parentheses' => \true, 'nullable_type_declaration_for_default_null_value' => \true];
    }
}
