DROP TABLE IF EXISTS `%table_prefix%images`;
CREATE TABLE `%table_prefix%images` (
  `image_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `image_name` VARCHAR(255) NOT NULL,
  `image_extension` VARCHAR(255) NOT NULL,
  `image_size` BIGINT UNSIGNED NOT NULL,
  `image_width` INT UNSIGNED NOT NULL,
  `image_height` INT UNSIGNED NOT NULL,
  `image_date` DATETIME NOT NULL,
  `image_date_gmt` DATETIME NOT NULL,
  `image_title` VARCHAR(100) DEFAULT NULL,
  `image_description` TEXT,
  `image_nsfw` TINYINT UNSIGNED NOT NULL DEFAULT '0',
  `image_user_id` INT UNSIGNED DEFAULT NULL,
  `image_album_id` INT UNSIGNED DEFAULT NULL,
  `image_uploader_ip` VARCHAR(255) NOT NULL,
  `image_storage_mode` ENUM('datefolder','direct','old','path') NOT NULL DEFAULT 'datefolder',
  `image_path` VARCHAR(4096) DEFAULT NULL,
  `image_storage_id` INT UNSIGNED DEFAULT NULL,
  `image_checksum` VARCHAR(32) NOT NULL,
  `image_source_checksum` VARCHAR(32) DEFAULT NULL,
  `image_original_filename` VARCHAR(255) NOT NULL,
  `image_original_exifdata` MEDIUMTEXT,
  `image_views` INT UNSIGNED NOT NULL DEFAULT '0',
  `image_category_id` INT UNSIGNED DEFAULT NULL,
  `image_chain` TINYINT UNSIGNED NOT NULL,
  `image_thumb_size` INT UNSIGNED NOT NULL,
  `image_medium_size` INT UNSIGNED NOT NULL DEFAULT '0',
  `image_frame_size` INT UNSIGNED NOT NULL DEFAULT '0',
  `image_expiration_date_gmt` DATETIME DEFAULT NULL,
  `image_likes` INT UNSIGNED NOT NULL DEFAULT '0',
  `image_is_animated` TINYINT UNSIGNED NOT NULL DEFAULT '0',
  `image_is_approved` TINYINT UNSIGNED NOT NULL DEFAULT '1',
  `image_is_360` TINYINT UNSIGNED NOT NULL DEFAULT '0',
  `image_duration` INT UNSIGNED NOT NULL DEFAULT '0',
  `image_type` TINYINT UNSIGNED as (case
    when `image_extension` in ('pdf','doc','md') then 4
    when `image_extension` in ('mp3','m4a','wav') then 3
    when `image_extension` in ('mp4','webm','mov') then 2
    when `image_extension` in ('avif','jpg','jpeg','gif','png','webp') then 1
    else 0 end) stored,
  `image_delete_hash` VARCHAR(255) NULL,
  PRIMARY KEY (`image_id`),
  KEY `image_name` (`image_name`),
  KEY `image_extension` (`image_extension`),
  KEY `image_size` (`image_size`),
  KEY `image_width` (`image_width`),
  KEY `image_height` (`image_height`),
  KEY `image_date_gmt` (`image_date_gmt`),
  KEY `image_nsfw` (`image_nsfw`),
  KEY `image_user_id` (`image_user_id`),
  KEY `image_album_id` (`image_album_id`),
  KEY `image_uploader_ip` (`image_uploader_ip`),
  KEY `image_storage_mode` (`image_storage_mode`),
  KEY `image_path` (`image_path`(255)),
  KEY `image_storage_id` (`image_storage_id`),
  KEY `image_checksum` (`image_checksum`),
  KEY `image_source_checksum` (`image_source_checksum`),
  KEY `image_views` (`image_views`),
  KEY `image_category_id` (`image_category_id`),
  KEY `image_chain` (`image_chain`),
  KEY `image_expiration_date_gmt` (`image_expiration_date_gmt`),
  KEY `image_likes` (`image_likes`),
  KEY `image_is_animated` (`image_is_animated`),
  KEY `image_is_approved` (`image_is_approved`),
  KEY `image_is_360` (`image_is_360`),
  KEY `image_album_id_image_id` (`image_album_id`, `image_id`),
  KEY `image_duration` (`image_duration`),
  KEY `image_type` (`image_type`),
  FULLTEXT KEY `searchindex` (`image_name`,`image_title`,`image_description`,`image_original_filename`),
  KEY `image_uploader_ip_date_gmt_checksum_source_checksum` (`image_uploader_ip`, `image_date_gmt`, `image_checksum`, `image_source_checksum`)
) ENGINE=%table_engine% DEFAULT CHARSET=utf8mb4;
