<?php

declare(strict_types=1);

namespace PHPIcons;

class Icons
{
    /**
     * @var array<string, string>
     */
    public const DATA = [
  'ri:check-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="m10 15.17l9.192-9.191l1.414 1.414L10 17.999l-6.364-6.364l1.414-1.414z"/></svg>',
  'ri:close-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="m12 10.587l4.95-4.95l1.414 1.414l-4.95 4.95l4.95 4.95l-1.415 1.414l-4.95-4.95l-4.949 4.95l-1.414-1.415l4.95-4.95l-4.95-4.95L7.05 5.638z"/></svg>',
  'ri:alert-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="m12.866 3l9.526 16.5a1 1 0 0 1-.866 1.5H2.474a1 1 0 0 1-.866-1.5L11.134 3a1 1 0 0 1 1.732 0M11 16v2h2v-2zm0-7v5h2V9z"/></svg>',
  'ri:error-warning-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10s-4.477 10-10 10m-1-7v2h2v-2zm0-8v6h2V7z"/></svg>',
  'ri:arrow-right-s-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="m16 12l-6 6V6z"/></svg>',
  'ri:markdown-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M3 3h18a1 1 0 0 1 1 1v16a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V4a1 1 0 0 1 1-1m4 12.5v-4l2 2l2-2v4h2v-7h-2l-2 2l-2-2H5v7zm11-3v-4h-2v4h-2l3 3l3-3z"/></svg>',
  'ri:heading' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M17 11V4h2v17h-2v-8H7v8H5V4h2v7z"/></svg>',
  'ri:bold' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M8 11h4.5a2.5 2.5 0 0 0 0-5H8zm10 4.5a4.5 4.5 0 0 1-4.5 4.5H6V4h6.5a4.5 4.5 0 0 1 3.256 7.606A4.5 4.5 0 0 1 18 15.5M8 13v5h5.5a2.5 2.5 0 0 0 0-5z"/></svg>',
  'ri:italic' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M15 20H7v-2h2.927l2.116-12H9V4h8v2h-2.927l-2.116 12H15z"/></svg>',
  'ri:list-unordered' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M8 4h13v2H8zM4.5 6.5a1.5 1.5 0 1 1 0-3a1.5 1.5 0 0 1 0 3m0 7a1.5 1.5 0 1 1 0-3a1.5 1.5 0 0 1 0 3m0 6.9a1.5 1.5 0 1 1 0-3a1.5 1.5 0 0 1 0 3M8 11h13v2H8zm0 7h13v2H8z"/></svg>',
  'ri:list-ordered-2' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M5.75 3.5H4.717l-1.467.393v1.553l1-.268V8.5H3V10h4V8.5H5.75zM10 4h11v2H10zm0 7h11v2H10zm0 7h11v2H10zm-7.125-2.375a2.125 2.125 0 1 1 3.812 1.292l-.004.006L5.316 18.5H7V20H3v-1.121l2.472-2.844a.625.625 0 1 0-1.094-.466l-.013.306h-1.49z"/></svg>',
  'ri:link' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M18.364 15.536L16.95 14.12l1.414-1.414a5 5 0 0 0-7.071-7.071L9.878 7.05L8.464 5.636l1.414-1.414a7 7 0 0 1 9.9 9.9zm-2.829 2.828l-1.414 1.414a7 7 0 0 1-9.9-9.9l1.415-1.414L7.05 9.88l-1.414 1.414a5 5 0 0 0 7.07 7.071l1.415-1.414zm-.707-10.607l1.415 1.415l-7.072 7.07l-1.414-1.414z"/></svg>',
  'ri:image-add-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M21 15v3h3v2h-3v3h-2v-3h-3v-2h3v-3zm.008-12c.548 0 .992.445.992.993v9.349A6 6 0 0 0 20 13V5H4l.001 14l9.292-9.293a1 1 0 0 1 1.32-.084l.094.085l3.545 3.55a6.003 6.003 0 0 0-3.91 7.743L2.992 21A.993.993 0 0 1 2 20.007V3.993A1 1 0 0 1 2.992 3zM8 7a2 2 0 1 1 0 4a2 2 0 0 1 0-4"/></svg>',
  'ri:file-copy-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M7 6V3a1 1 0 0 1 1-1h12a1 1 0 0 1 1 1v14a1 1 0 0 1-1 1h-3v3c0 .552-.45 1-1.007 1H4.007A1 1 0 0 1 3 21l.003-14c0-.552.45-1 1.006-1zm2 0h8v10h2V4H9z"/></svg>',
  'ri:question-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10s-4.477 10-10 10m-1-7v2h2v-2zm2-1.645A3.502 3.502 0 0 0 12 6.5a3.5 3.5 0 0 0-3.433 2.813l1.962.393A1.5 1.5 0 1 1 12 11.5a1 1 0 0 0-1 1V14h2z"/></svg>',
  'ri:upload-cloud-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M7 20.981a6.5 6.5 0 0 1-2.936-12a8.001 8.001 0 0 1 15.872 0a6.5 6.5 0 0 1-2.936 12V21H7zM13 13h3l-4-5l-4 5h3v4h2z"/></svg>',
  'ri:cloud-off-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="m3.515 2.1l19.092 19.092l-1.415 1.415l-2.014-2.015A6 6 0 0 1 17 21H7A6 6 0 0 1 5.008 9.339a7 7 0 0 1 .353-2.563L2.1 3.514zM17 9a6.003 6.003 0 0 1 5.204 8.989L14.01 9.796C14.89 9.29 15.91 9 17 9m-5-7a7 7 0 0 1 6.765 5.195a8.03 8.03 0 0 0-6.206 1.15L7.694 3.48A6.97 6.97 0 0 1 12 2"/></svg>',
  'ri:map-pin-2-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M18.364 17.364L12 23.728l-6.364-6.364a9 9 0 1 1 12.728 0M12 13a2 2 0 1 0 0-4a2 2 0 0 0 0 4"/></svg>',
  'ri:arrow-right-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M12 13H4v-2h8V4l8 8l-8 8z"/></svg>',
  'ri:external-link-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M10 6v2H5v11h11v-5h2v6a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V7a1 1 0 0 1 1-1zm11-3v9l-3.794-3.793l-5.999 6l-1.414-1.414l5.999-6L12 3z"/></svg>',
  'ri:notification-2-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M22 20H2v-2h1v-6.969C3 6.043 7.03 2 12 2s9 4.043 9 9.031V18h1zM9.5 21h5a2.5 2.5 0 0 1-5 0"/></svg>',
  'ri:account-circle-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M12 2c5.52 0 10 4.48 10 10s-4.48 10-10 10S2 17.52 2 12S6.48 2 12 2M6.023 15.416C7.491 17.606 9.695 19 12.16 19s4.669-1.393 6.136-3.584A8.97 8.97 0 0 0 12.16 13a8.97 8.97 0 0 0-6.137 2.416M12 11a3 3 0 1 0 0-6a3 3 0 0 0 0 6"/></svg>',
  'ri:arrow-drop-down-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="m12 14l-4-4h8z"/></svg>',
  'ri:lock-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M19 10h1a1 1 0 0 1 1 1v10a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V11a1 1 0 0 1 1-1h1V9a7 7 0 0 1 14 0zm-2 0V9A5 5 0 0 0 7 9v1zm-6 4v4h2v-4z"/></svg>',
  'ri:exchange-dollar-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M5.378 4.513a9.96 9.96 0 0 1 6.627-2.51c5.523 0 10 4.477 10 10a9.95 9.95 0 0 1-1.793 5.715l-2.707-5.715h2.5A8 8 0 0 0 6.279 6.415zm13.253 14.98a9.96 9.96 0 0 1-6.626 2.51c-5.523 0-10-4.477-10-10c0-2.125.663-4.095 1.793-5.715l2.707 5.715h-2.5A8 8 0 0 0 17.73 17.59zm-10.126-5.49h5.5a.5.5 0 1 0 0-1h-4a2.5 2.5 0 1 1 0-5h1v-1h2v1h2.5v2h-5.5a.5.5 0 0 0 0 1h4a2.5 2.5 0 0 1 0 5h-1v1h-2v-1h-2.5z"/></svg>',
  'ri:arrow-left-line' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M7.828 11H20v2H7.828l5.364 5.364l-1.414 1.414L4 12l7.778-7.778l1.414 1.414z"/></svg>',
  'ri:send-plane-2-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M3 13h6v-2H3V1.846a.5.5 0 0 1 .741-.439l18.462 10.155a.5.5 0 0 1 0 .876L3.741 22.592A.5.5 0 0 1 3 22.154z"/></svg>',
  'ri:chat-4-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M6.455 19L2 22.5V4a1 1 0 0 1 1-1h18a1 1 0 0 1 1 1v14a1 1 0 0 1-1 1z"/></svg>',
  'ri:repeat-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M6 4h15a1 1 0 0 1 1 1v7h-2V6H6v3L1 5l5-4zm12 16H3a1 1 0 0 1-1-1v-7h2v6h14v-3l5 4l-5 4z"/></svg>',
  'ri:heart-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M12.001 4.529a6 6 0 0 1 8.242.228a6 6 0 0 1 .236 8.236l-8.48 8.492l-8.478-8.492a6 6 0 0 1 8.48-8.464"/></svg>',
  'ri:more-2-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M12 3c-1.1 0-2 .9-2 2s.9 2 2 2s2-.9 2-2s-.9-2-2-2m0 14c-1.1 0-2 .9-2 2s.9 2 2 2s2-.9 2-2s-.9-2-2-2m0-7c-1.1 0-2 .9-2 2s.9 2 2 2s2-.9 2-2s-.9-2-2-2"/></svg>',
  'ri:earth-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M12 2c5.523 0 10 4.477 10 10s-4.477 10-10 10S2 17.523 2 12S6.477 2 12 2m4.004 10.878c-.345-.525-.594-.903-1.542-.753c-1.79.284-1.989.597-2.074 1.113l-.024.156l-.025.166c-.097.683-.094.941.22 1.27c1.265 1.328 2.023 2.285 2.253 2.845c.112.273.4 1.1.202 1.918a8.2 8.2 0 0 0 3.151-2.237c.11-.374.19-.84.19-1.404v-.105c0-.922 0-1.343-.652-1.716a7 7 0 0 0-.645-.325c-.367-.167-.61-.276-.938-.756q-.06-.085-.116-.172M12 3.833c-2.317 0-4.41.966-5.896 2.516c.177.123.331.296.437.534c.204.457.204.928.204 1.345c0 .328 0 .64.105.865c.144.308.766.44 1.315.554c.197.042.399.084.583.135c.506.14.898.595 1.211.96c.13.151.323.374.42.43c.05-.036.211-.211.29-.498c.062-.22.044-.414-.045-.52c-.56-.66-.529-1.93-.356-2.399c.272-.739 1.122-.684 1.744-.644c.232.015.45.03.614.009c.622-.078.814-1.025.949-1.21c.292-.4 1.186-1.003 1.74-1.375A8.1 8.1 0 0 0 12 3.833"/></svg>',
  'ri:play-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M19.376 12.416L8.777 19.482A.5.5 0 0 1 8 19.066V4.934a.5.5 0 0 1 .777-.416l10.599 7.066a.5.5 0 0 1 0 .832"/></svg>',
  'ri:eye-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M1.182 12C2.122 6.88 6.608 3 12 3s9.878 3.88 10.819 9c-.94 5.12-5.427 9-10.819 9s-9.878-3.88-10.818-9M12 17a5 5 0 1 0 0-10a5 5 0 0 0 0 10m0-2a3 3 0 1 1 0-6a3 3 0 0 1 0 6"/></svg>',
  'ri:download-2-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M4 19h16v-7h2v8a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1v-8h2zM14 9h5l-7 7l-7-7h5V3h4z"/></svg>',
  'ri:menu-2-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M3 4h18v2H3zm0 7h12v2H3zm0 7h18v2H3z"/></svg>',
  'ri:rss-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M3 3c9.941 0 18 8.059 18 18h-3c0-8.284-6.716-15-15-15zm0 7c6.075 0 11 4.925 11 11h-3a8 8 0 0 0-8-8zm0 7a4 4 0 0 1 4 4H3z"/></svg>',
  'ri:lock-unlock-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M7 10h13a1 1 0 0 1 1 1v10a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V11a1 1 0 0 1 1-1h1V9a7 7 0 0 1 13.262-3.131l-1.789.894A5 5 0 0 0 7 9zm3 5v2h4v-2z"/></svg>',
  'ri:import-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M21 3H3a1 1 0 0 0-1 1v16a1 1 0 0 0 1 1h18a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1m-9 13a3 3 0 0 1-3-3H4V5h16v8h-5a3 3 0 0 1-3 3m4-7h-3V6h-2v3H8l4 4.5z"/></svg>',
  'ri:dashboard-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M3 12a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1H4a1 1 0 0 0-1 1zm0 8a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1H4a1 1 0 0 0-1 1zm10 0a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1v-8a1 1 0 0 0-1-1h-6a1 1 0 0 0-1 1zm1-17a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1z"/></svg>',
  'ri:mic-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M12 1a5 5 0 0 1 5 5v4a5 5 0 0 1-10 0V6a5 5 0 0 1 5-5M3.055 11H5.07a7.002 7.002 0 0 0 13.858 0h2.016A9.004 9.004 0 0 1 13 18.945V23h-2v-4.055A9.004 9.004 0 0 1 3.055 11"/></svg>',
  'ri:folder-user-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M12.414 5H21a1 1 0 0 1 1 1v14a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V4a1 1 0 0 1 1-1h7.414zM12 13a2.5 2.5 0 1 0 0-5a2.5 2.5 0 0 0 0 5m-4 5h8a4 4 0 0 0-8 0"/></svg>',
  'ri:rocket-2-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M8.498 20.005h7.004A6.52 6.52 0 0 1 12 23.507a6.52 6.52 0 0 1-3.502-3.502M18 14.81l2 2.268v1.927H4v-1.927l2-2.268V9.005c0-3.483 2.504-6.447 6-7.545c3.496 1.098 6 4.062 6 7.545zm-6-3.805a2 2 0 1 0 0-4a2 2 0 0 0 0 4"/></svg>',
  'ri:group-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M2 22a8 8 0 1 1 16 0zm8-9c-3.315 0-6-2.685-6-6s2.685-6 6-6s6 2.685 6 6s-2.685 6-6 6m7.363 2.233A7.505 7.505 0 0 1 22.983 22H20c0-2.61-1-4.986-2.637-6.767m-2.023-2.276A7.98 7.98 0 0 0 18 7a7.96 7.96 0 0 0-1.015-3.903A5 5 0 0 1 21 8a5 5 0 0 1-5.66 4.957"/></svg>',
  'ri:pages-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M20 22H4a1 1 0 0 1-1-1V8h18v13a1 1 0 0 1-1 1m1-16H3V3a1 1 0 0 1 1-1h16a1 1 0 0 1 1 1zM7 11v4h4v-4zm0 6v2h10v-2zm6-5v2h4v-2z"/></svg>',
  'ri:settings-3-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M9.954 2.21a10 10 0 0 1 4.09-.002A4 4 0 0 0 16 5.07a4 4 0 0 0 3.457.261A10 10 0 0 1 21.5 8.877a4 4 0 0 0-1.5 3.122c0 1.264.586 2.391 1.501 3.124a10 10 0 0 1-2.045 3.543a4 4 0 0 0-3.456.261a4 4 0 0 0-1.955 2.86a10 10 0 0 1-4.09.004A4 4 0 0 0 8 18.927a4 4 0 0 0-3.457-.26A10 10 0 0 1 2.5 15.121A4 4 0 0 0 4 11.999c0-1.264-.587-2.39-1.502-3.124a10 10 0 0 1 2.045-3.542A4 4 0 0 0 8 5.07a4 4 0 0 0 1.954-2.86M12 15a3 3 0 1 0 0-6a3 3 0 0 0 0 6"/></svg>',
  'ri:database-2-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M21 9.5v3c0 2.485-4.03 4.5-9 4.5s-9-2.015-9-4.5v-3c0 2.485 4.03 4.5 9 4.5s9-2.015 9-4.5m-18 5c0 2.485 4.03 4.5 9 4.5s9-2.015 9-4.5v3c0 2.485-4.03 4.5-9 4.5s-9-2.015-9-4.5zm9-2.5c-4.97 0-9-2.015-9-4.5S7.03 3 12 3s9 2.015 9 4.5s-4.03 4.5-9 4.5"/></svg>',
  'ri:add-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M11 11V5h2v6h6v2h-6v6h-2v-6H5v-2z"/></svg>',
  'ri:refresh-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10s-4.477 10-10 10m4.82-4.924A7 7 0 0 0 9.032 5.658l.975 1.755A5 5 0 0 1 17 12h-3zm-1.852 1.266l-.975-1.755A5 5 0 0 1 7 12h3L7.18 6.924a7 7 0 0 0 7.788 11.418"/></svg>',
  'ri:delete-bin-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M17 6h5v2h-2v13a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V8H2V6h5V3a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1zm-8 5v6h2v-6zm4 0v6h2v-6zM9 4v2h6V4z"/></svg>',
  'ri:home-gear-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M20 20a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-9H1l10.327-9.388a1 1 0 0 1 1.346 0L23 11h-3zM8.592 13.808l-.991.572l1 1.733l.993-.573c.394.372.873.653 1.405.811v1.145h2.002V16.35a3.5 3.5 0 0 0 1.405-.81l.992.572L16.4 14.38l-.991-.572a3.5 3.5 0 0 0 0-1.62l.991-.573l-1-1.733l-.993.573A3.5 3.5 0 0 0 13 9.645V8.5h-2.002v1.144a3.5 3.5 0 0 0-1.405.811l-.992-.573L7.6 11.616l.991.572a3.5 3.5 0 0 0 0 1.62m3.408.69a1.5 1.5 0 1 1-.002-3.001a1.5 1.5 0 0 1 .002 3"/></svg>',
  'ri:shield-user-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M3.783 2.826L12 1l8.217 1.826a1 1 0 0 1 .783.976v9.987a6 6 0 0 1-2.672 4.992L12 23l-6.328-4.219A6 6 0 0 1 3 13.79V3.802a1 1 0 0 1 .783-.976M12 11a2.5 2.5 0 1 0 0-5a2.5 2.5 0 0 0 0 5m-4.473 5h8.946a4.5 4.5 0 0 0-8.946 0"/></svg>',
  'ri:pencil-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="m12.9 6.855l4.242 4.242l-9.9 9.9H3v-4.243zm1.414-1.415l2.121-2.121a1 1 0 0 1 1.414 0l2.829 2.828a1 1 0 0 1 0 1.415l-2.122 2.121z"/></svg>',
  'ri:forbid-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10s-4.477 10-10 10M8.523 7.109A6 6 0 0 0 7.11 8.523l8.368 8.368a6 6 0 0 0 1.414-1.414z"/></svg>',
  'ri:clapperboard-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="m17.998 7l2.31-4h.7c.548 0 .992.445.992.993v16.014a1 1 0 0 1-.992.993H2.992A.993.993 0 0 1 2 20.007V3.993A1 1 0 0 1 2.992 3h3.006l-2.31 4h2.31l2.31-4h3.69l-2.31 4h2.31l2.31-4h3.69l-2.31 4z"/></svg>',
  'ri:file-download-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="m16 2l5 5v14.008a.993.993 0 0 1-.993.992H3.993A1 1 0 0 1 3 21.008V2.992C3 2.444 3.445 2 3.993 2zm-3 10V8h-2v4H8l4 4l4-4z"/></svg>',
  'ri:search-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="m18.031 16.617l4.283 4.282l-1.415 1.415l-4.282-4.283A8.96 8.96 0 0 1 11 20c-4.968 0-9-4.032-9-9s4.032-9 9-9s9 4.032 9 9a8.96 8.96 0 0 1-1.969 5.617"/></svg>',
  'ri:timer-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="m17.618 5.968l1.453-1.453l1.414 1.414l-1.453 1.453A9 9 0 1 1 12 4c2.125 0 4.078.736 5.618 1.968M11 8v6h2V8zM8 1h8v2H8z"/></svg>',
  'ri:pause-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M6 5h2v14H6zm10 0h2v14h-2z"/></svg>',
  'ri:loader-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M12 2a1 1 0 0 1 1 1v3a1 1 0 1 1-2 0V3a1 1 0 0 1 1-1m0 15a1 1 0 0 1 1 1v3a1 1 0 1 1-2 0v-3a1 1 0 0 1 1-1m8.66-10a1 1 0 0 1-.366 1.366l-2.598 1.5a1 1 0 1 1-1-1.732l2.598-1.5A1 1 0 0 1 20.66 7M7.67 14.5a1 1 0 0 1-.367 1.366l-2.598 1.5a1 1 0 1 1-1-1.732l2.598-1.5a1 1 0 0 1 1.366.366M20.66 17a1 1 0 0 1-1.366.366l-2.598-1.5a1 1 0 0 1 1-1.732l2.598 1.5A1 1 0 0 1 20.66 17M7.67 9.5a1 1 0 0 1-1.367.366l-2.598-1.5a1 1 0 1 1 1-1.732l2.598 1.5A1 1 0 0 1 7.67 9.5"/></svg>',
  'ri:calendar-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M2 11h20v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1zm15-8h4a1 1 0 0 1 1 1v5H2V4a1 1 0 0 1 1-1h4V1h2v2h6V1h2z"/></svg>',
  'ri:history-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M12 2c5.523 0 10 4.477 10 10s-4.477 10-10 10S2 17.523 2 12h2a8 8 0 1 0 1.865-5.135L8 9H2V3l2.447 2.446A9.98 9.98 0 0 1 12 2m1 5v4.585l3.243 3.243l-1.415 1.415L11 12.413V7z"/></svg>',
  'ri:play-circle-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10s-4.477 10-10 10M10.622 8.415a.4.4 0 0 0-.622.332v6.506a.4.4 0 0 0 .622.332l4.879-3.252a.4.4 0 0 0 0-.666z"/></svg>',
  'ri:line-chart-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M5 3v16h16v2H3V3zm14.94 2.94l2.12 2.12L16 14.122l-3-3l-3.94 3.94l-2.12-2.122L13 6.88l3 3z"/></svg>',
  'ri:broadcast-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="m4.929 2.929l1.414 1.414A7.98 7.98 0 0 0 4 10c0 2.21.895 4.21 2.343 5.657L4.93 17.07A9.97 9.97 0 0 1 2 10a9.97 9.97 0 0 1 2.929-7.071m14.142 0A9.97 9.97 0 0 1 22 10a9.97 9.97 0 0 1-2.929 7.071l-1.414-1.414A7.98 7.98 0 0 0 20 10c0-2.21-.895-4.21-2.343-5.657zM7.757 5.757l1.415 1.415A4 4 0 0 0 8 10c0 1.105.448 2.105 1.172 2.829l-1.415 1.414A5.98 5.98 0 0 1 6 10c0-1.657.672-3.157 1.757-4.243m8.486 0A5.98 5.98 0 0 1 18 10a5.98 5.98 0 0 1-1.757 4.243l-1.415-1.415A4 4 0 0 0 16 10a4 4 0 0 0-1.172-2.828zM12 12a2 2 0 1 1 0-4a2 2 0 0 1 0 4m0 2c.58 0 1.077.413 1.184.983L14.5 22h-5l1.316-7.017c.107-.57.604-.983 1.184-.983"/></svg>',
  'ri:money-dollar-circle-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M12.005 22.003c-5.523 0-10-4.477-10-10s4.477-10 10-10s10 4.477 10 10s-4.477 10-10 10m-3.5-8v2h2.5v2h2v-2h1a2.5 2.5 0 1 0 0-5h-4a.5.5 0 1 1 0-1h5.5v-2h-2.5v-2h-2v2h-1a2.5 2.5 0 1 0 0 5h4a.5.5 0 0 1 0 1z"/></svg>',
  'ri:at-line' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M20 12a8 8 0 1 0-3.562 6.657l1.11 1.664A9.95 9.95 0 0 1 12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10v1.5a3.5 3.5 0 0 1-6.396 1.966A5 5 0 1 1 15 8h2v5.5a1.5 1.5 0 0 0 3 0zm-8-3a3 3 0 1 0 0 6a3 3 0 0 0 0-6"/></svg>',
  'ri:user-follow-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M13 14.062V22H4a8 8 0 0 1 9-7.938M12 13c-3.315 0-6-2.685-6-6s2.685-6 6-6s6 2.685 6 6s-2.685 6-6 6m5.793 6.914l3.535-3.535l1.415 1.414l-4.95 4.95l-3.536-3.536l1.415-1.414z"/></svg>',
  'ri:user-add-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M14 14.252V22H4a8 8 0 0 1 10-7.748M12 13c-3.315 0-6-2.685-6-6s2.685-6 6-6s6 2.685 6 6s-2.685 6-6 6m6 4v-3h2v3h3v2h-3v3h-2v-3h-3v-2z"/></svg>',
  'ri:scales-3-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="m12.999 2l-.001 1.278l5 1.668l3.633-1.21l.632 1.896l-3.031 1.011l3.095 8.512A5.98 5.98 0 0 1 17.998 17a5.98 5.98 0 0 1-4.328-1.845l3.094-8.512l-3.766-1.256V19h4v2h-10v-2h4V5.387L7.232 6.643l3.095 8.512A5.98 5.98 0 0 1 6 17a5.98 5.98 0 0 1-4.33-1.845l3.095-8.512l-3.03-1.01l.632-1.898L6 4.945l4.999-1.667V2zm5 7.103L16.58 13h2.835zm-12 0L4.58 13h2.835z"/></svg>',
  'ri:loop-left-fill' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M12 4a7.99 7.99 0 0 0-6.357 3.143L8 9.5H2v-6l2.219 2.219A9.98 9.98 0 0 1 12 2c5.523 0 10 4.477 10 10h-2a8 8 0 0 0-8-8m-8 8a8 8 0 0 0 14.357 4.857L16 14.5h6v6l-2.219-2.219A9.98 9.98 0 0 1 12 22C6.477 22 2 17.523 2 12z"/></svg>',
  'custom:repeat-off' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path d="m23 19-5 4v-3H8.02l2-2H18v-3l5 4ZM6 4h12.586l2.606-2.606 1.414 1.414L2.414 23 1 21.586l1.65-1.65A1 1 0 0 1 2 19v-7h2v6h.586l12-12H6v3L1 5l5-4v3Zm16 8h-2V8.02l2-2V12Z"/></svg>',
  'social:bluesky' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path d="M12 11.3884C11.0942 9.62673 8.62833 6.34423 6.335 4.7259C4.13833 3.17506 3.30083 3.4434 2.75167 3.69256C2.11583 3.9784 2 4.95506 2 5.52839C2 6.10339 2.315 10.2367 2.52 10.9276C3.19917 13.2076 5.61417 13.9776 7.83917 13.7309C4.57917 14.2142 1.68333 15.4017 5.48083 19.6292C9.65833 23.9542 11.2058 18.7017 12 16.0392C12.7942 18.7017 13.7083 23.7651 18.4442 19.6292C22 16.0392 19.4208 14.2142 16.1608 13.7309C18.3858 13.9784 20.8008 13.2076 21.48 10.9276C21.685 10.2376 22 6.10256 22 5.52923C22 4.95423 21.8842 3.97839 21.2483 3.6909C20.6992 3.44256 19.8617 3.17423 17.665 4.72423C15.3717 6.34506 12.9058 9.62756 12 11.3884Z"/></svg>',
  'social:discord' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0Z"/><path d="M18.93 5.26A16.5 16.5 0 0 0 14.86 4c-.03 0-.05 0-.07.03a11 11 0 0 0-.5 1.04 15.23 15.23 0 0 0-4.57 0 11.2 11.2 0 0 0-.52-1.04.06.06 0 0 0-.06-.03 16.45 16.45 0 0 0-4.1 1.29A16.88 16.88 0 0 0 2.1 16.72a16.58 16.58 0 0 0 5 2.52c.02.01.05 0 .06-.02.39-.53.73-1.08 1.02-1.66a.06.06 0 0 0-.03-.1c-.54-.2-1.06-.45-1.56-.73a.06.06 0 0 1 0-.11l.3-.24a.06.06 0 0 1 .07-.01c3.27 1.5 6.81 1.5 10.05 0h.06l.32.25c.03.03.03.08-.01.1-.5.3-1.02.54-1.56.75a.06.06 0 0 0-.04.09c.3.58.65 1.13 1.03 1.66.01.02.04.03.07.02a16.53 16.53 0 0 0 5.02-2.57 16.77 16.77 0 0 0-2.98-11.4ZM8.68 14.4c-.98 0-1.8-.9-1.8-2.02 0-1.1.8-2.01 1.8-2.01 1.01 0 1.82.9 1.8 2.01 0 1.11-.8 2.02-1.8 2.02Zm6.65 0c-.99 0-1.8-.9-1.8-2.02 0-1.1.8-2.01 1.8-2.01s1.81.9 1.8 2.01c0 1.11-.8 2.02-1.8 2.02Z"/></svg>',
  'social:discourse' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path d="M12.0846 2C6.61 2 2 6.39692 2 11.8254L2.00462 22L12.0838 21.9908C17.5615 21.9908 22 17.4238 22 11.9954C22 6.56692 17.5615 2 12.0846 2ZM12 5.84615C13.6321 5.84615 15.1974 6.4945 16.3514 7.64857C17.5055 8.80264 18.1538 10.3679 18.1538 12C18.1538 13.6321 17.5055 15.1974 16.3514 16.3514C15.1974 17.5055 13.6321 18.1538 12 18.1538C10.947 18.1544 9.91156 17.8834 8.99385 17.3669L5.84615 18.1538L6.70846 15.1308C6.14413 14.184 5.84619 13.1022 5.84615 12C5.84615 10.3679 6.4945 8.80264 7.64857 7.64857C8.80264 6.4945 10.3679 5.84615 12 5.84615Z"/></svg>',
  'social:facebook' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M12,2.06a10,10,0,0,0-1.56,19.88V15H7.9V12.06h2.54V9.86A3.53,3.53,0,0,1,14.22,6a15.68,15.68,0,0,1,2.23.19V8.62H15.19a1.45,1.45,0,0,0-1.63,1.56v1.88h2.78L15.89,15H13.56v7A10,10,0,0,0,12,2.06Z"/></svg>',
  'social:funkwhale' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M6.27,3c-.33,0-.66,0-1,0A2.44,2.44,0,0,0,5.7,5.13a4.89,4.89,0,0,0,1.8,1.4c.67.35,1.39.41,2,.79a2.65,2.65,0,0,1,1,.93,2.68,2.68,0,0,1,.39,1.39l0,.85s.33.85,1.05.85,1-.85,1-.85l.05-.85a2.7,2.7,0,0,1,.39-1.39,2.36,2.36,0,0,1,.95-.93c.64-.38,1.37-.44,2-.79a4.77,4.77,0,0,0,1.75-1.4A2.43,2.43,0,0,0,18.62,3a7.71,7.71,0,0,0-3.86.69c-1.56.83-2.51.54-2.79,1.78h0c-.29-1.25-1.22-1-2.8-1.78A6.75,6.75,0,0,0,6.27,3Zm2.45,7.88a.18.18,0,0,0-.18.18,3.46,3.46,0,1,0,6.92,0,.18.18,0,0,0-.18-.18H14a.19.19,0,0,0-.18.18,1.79,1.79,0,0,1-3.58,0,.19.19,0,0,0-.18-.18Zm-6.54,0A.19.19,0,0,0,2,11a10,10,0,0,0,20,0,.19.19,0,0,0-.18-.18H20.51a.18.18,0,0,0-.18.18A8.34,8.34,0,0,1,3.65,11a.19.19,0,0,0-.18-.18Zm3.28,0a.19.19,0,0,0-.18.18,6.72,6.72,0,0,0,13.44,0,.19.19,0,0,0-.18-.18H17.23a.19.19,0,0,0-.18.18A5.06,5.06,0,1,1,6.93,11a.19.19,0,0,0-.18-.18Z"/></svg>',
  'social:instagram' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M12,2c2.72,0,3.06,0,4.12.06a7.3,7.3,0,0,1,2.43.47,4.7,4.7,0,0,1,1.77,1.15,4.84,4.84,0,0,1,1.15,1.77,7.3,7.3,0,0,1,.47,2.43C22,8.94,22,9.28,22,12s0,3.06-.06,4.12a7.3,7.3,0,0,1-.47,2.43,5.08,5.08,0,0,1-2.92,2.92,7.3,7.3,0,0,1-2.43.47c-1.06,0-1.4.06-4.12.06s-3.06,0-4.12-.06a7.3,7.3,0,0,1-2.43-.47,4.84,4.84,0,0,1-1.77-1.15,4.84,4.84,0,0,1-1.15-1.77,7.3,7.3,0,0,1-.47-2.43C2,15.06,2,14.72,2,12s0-3.06.06-4.12a7.3,7.3,0,0,1,.47-2.43A4.84,4.84,0,0,1,3.68,3.68,4.84,4.84,0,0,1,5.45,2.53a7.3,7.3,0,0,1,2.43-.47C8.94,2,9.28,2,12,2Zm0,5a5,5,0,1,0,5,5A5,5,0,0,0,12,7Zm6.5-.25A1.25,1.25,0,1,0,17.25,8,1.25,1.25,0,0,0,18.5,6.75ZM12,9a3,3,0,1,1-3,3A3,3,0,0,1,12,9Z"/></svg>',
  'social:linkedin' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M18.33,18.34H15.67V14.16c0-1,0-2.28-1.39-2.28s-1.6,1.09-1.6,2.21v4.25H10V9.75h2.56v1.17h0a2.83,2.83,0,0,1,2.53-1.39c2.7,0,3.2,1.78,3.2,4.09v4.72ZM7,8.57A1.55,1.55,0,0,1,5.45,7h0a1.55,1.55,0,0,1,3.1,0A1.54,1.54,0,0,1,7,8.57Zm1.34,9.77H5.67V9.75H8.34v8.59ZM19.67,3H4.33A1.31,1.31,0,0,0,3,4.3V19.7A1.31,1.31,0,0,0,4.33,21H19.67A1.32,1.32,0,0,0,21,19.7V4.3A1.32,1.32,0,0,0,19.67,3Z"/></svg>',
  'social:mastodon' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M21.26,14c-.28,1.41-2.46,3-5,3.25a23.66,23.66,0,0,1-4,.24,22.68,22.68,0,0,1-4-.54,4,4,0,0,0,0,.62c.29,2.22,2.19,2.35,4,2.41a11.23,11.23,0,0,0,3.44-.45l.07,1.65a9.21,9.21,0,0,1-3.54.81,14.73,14.73,0,0,1-4.61-.51C3.8,20.43,3.12,16.25,3,12c0-1.26,0-2.45,0-3.44C3,4.23,5.85,3,5.85,3A17.64,17.64,0,0,1,12.3,2h.06a17.64,17.64,0,0,1,6.45,1s2.85,1.27,2.85,5.61A33.59,33.59,0,0,1,21.26,14Zm-3-5.09a3.78,3.78,0,0,0-.82-2.56,2.87,2.87,0,0,0-2.23-1,2.68,2.68,0,0,0-2.4,1.23l-.52.87-.52-.87A2.68,2.68,0,0,0,9.4,5.39a2.83,2.83,0,0,0-2.22,1A3.79,3.79,0,0,0,6.35,8.9v5.26H8.43V9.06c0-1.08.46-1.62,1.36-1.62s1.5.64,1.5,1.92v2.79h2.07V9.36q0-1.92,1.5-1.92c.91,0,1.36.54,1.36,1.62v5.1H18.3V8.9Z"/></svg>',
  'social:matrix' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0Z"/><path d="M20.75 3.25v17.5h-1.88V22H22V2h-3.13v1.25h1.88ZM8.22 8.62v.97h.03a2.52 2.52 0 0 1 2.17-1.16c.45 0 .86.09 1.23.26.38.18.66.48.85.92.21-.3.5-.58.86-.82s.8-.36 1.29-.36c.38 0 .72.04 1.05.14a1.98 1.98 0 0 1 1.36 1.23c.13.33.2.72.2 1.18v4.77H15.3v-4.04c0-.24-.01-.46-.03-.68a1.33 1.33 0 0 0-.15-.55.92.92 0 0 0-.37-.37c-.16-.1-.38-.14-.65-.14-.28 0-.5.06-.67.16-.17.1-.3.24-.4.41-.1.18-.16.38-.19.58-.03.22-.05.44-.05.66v3.97h-1.95v-4c0-.21 0-.42-.02-.63 0-.2-.04-.39-.11-.57a.88.88 0 0 0-.35-.42 1.45 1.45 0 0 0-1.07-.1c-.16.05-.31.13-.44.24-.15.11-.27.28-.37.5a2 2 0 0 0-.15.84v4.14H6.37V8.62h1.85ZM3.25 3.25v17.5h1.88V22H2V2h3.13v1.25H3.25Z"/></svg>',
  'social:misskey' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M9.43 16.04c-.87 0-1.61-.52-1.96-1.13-.2-.26-.56-.35-.57 0v1.67c0 .66-.24 1.24-.73 1.73-.47.47-1.05.7-1.73.7a2.4 2.4 0 0 1-1.73-.7A2.4 2.4 0 0 1 2 16.58V7.44c0-.51.15-.98.44-1.4a2.38 2.38 0 0 1 2-1.04c.75 0 1.38.3 1.88.88l2.5 2.9c.05.04.21.36.6.36.4 0 .58-.32.64-.37l2.47-2.9a2.43 2.43 0 0 1 2.74-.72c.47.16.85.46 1.14.9.3.41.46.88.46 1.39v9.14c0 .66-.24 1.24-.73 1.73-.47.47-1.05.7-1.73.7a2.4 2.4 0 0 1-2.44-2.43v-1.66c-.04-.46-.44-.17-.58 0-.38.69-1.1 1.12-1.96 1.12Zm10.44-6.83c-.58 0-1.08-.2-1.5-.6-.4-.42-.6-.92-.6-1.5 0-.59.2-1.08.6-1.48.42-.42.92-.63 1.5-.63.59 0 1.09.2 1.5.63.42.4.63.9.63 1.48s-.2 1.08-.63 1.5c-.41.4-.91.6-1.5.6Zm.02.42c.59 0 1.08.2 1.48.63.42.41.63.91.63 1.5v5.15c0 .58-.2 1.08-.63 1.5-.4.4-.9.6-1.48.6a2.08 2.08 0 0 1-2.12-2.1v-5.15c0-.59.2-1.09.62-1.5.42-.42.92-.63 1.5-.63Z"/></svg>',
  'social:mobilizon' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M16,8.17a5.11,5.11,0,0,0-4.11-1.44,4.57,4.57,0,0,0-2.48.42A6.23,6.23,0,0,0,6,11.86a14.48,14.48,0,0,0,.33,5.52,5.8,5.8,0,0,0,4.43,3.83h0a6.17,6.17,0,0,0,5.14-1.35A5.77,5.77,0,0,0,17.8,16.6C18.61,13.41,17.88,10,16,8.17Zm-1.6,8.65a3,3,0,0,1-1.33,2.23,2.09,2.09,0,0,1-2.28,0c-.91-.52-1.35-1.7-1.45-3.86A7.94,7.94,0,0,1,10,11.25,1.85,1.85,0,0,1,11.8,10c1.54-.1,2.2.55,2.63,2.6A10.2,10.2,0,0,1,14.42,16.82ZM10.78,4.73c-.56-.16-.74-.54-.74-1.62s.16-1.42.83-1.63a4.68,4.68,0,0,1,2.52,0c.58.2.8.64.8,1.63s-.22,1.42-.8,1.62a5.48,5.48,0,0,1-2.61,0Z"/></svg>',
  'social:peertube' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M6.1,2V12l7.5-5Zm7.5,5V17l7.5-5Zm0,10L6.1,12V22Z"/></svg>',
  'social:pixelfed' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M12,2A10,10,0,1,1,2,12,10,10,0,0,1,12,2Zm1,6.1H10.41A1.76,1.76,0,0,0,8.62,9.83v6.75l2.59-2.47H13a3,3,0,1,0,0-6Z"/></svg>',
  'social:pleroma' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0Z"/><path d="M7.56 2A1.56 1.56 0 0 0 6 3.56V22h4.97V2H7.56Zm5.93 0v10h3.47a1.56 1.56 0 0 0 1.56-1.56V2h-5.03Zm0 15.03V22h3.47a1.56 1.56 0 0 0 1.56-1.56v-3.41h-5.03Z"/></svg>',
  'social:plume' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M2.09,21.87c-.12-.15-.12-.46,0-.92a10.48,10.48,0,0,1,1.26-2.42,18.94,18.94,0,0,0,1.06-2.05C6,12.16,7.64,9.27,10,6.92a10.18,10.18,0,0,1,2.51-2c.15,0,.14.43.09.6s.28-.27.49-.49c1.3-1.39,3.18-2.12,7.18-2.82C21.61,2,21.88,2,22,2.14s0,.23-.32.56A4.51,4.51,0,0,0,20.42,5a6.74,6.74,0,0,1-1.14,2.31l-.72.77.83-.19c.18.17,0,.4-.32,1.06-.93,2.26-4.58,5.76-8.47,7.7A17.29,17.29,0,0,1,7,18l-.44.09L5,19.67C3.24,21.62,2.83,22,2.4,22a.42.42,0,0,1-.31-.11Z"/></svg>',
  'social:slack' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M6.53,14.51a2,2,0,1,1-2-2h2v2Zm1,0a2,2,0,0,1,3.93,0v4.93a2,2,0,1,1-3.93,0Zm2-8a2,2,0,1,1,2-2v2Zm0,1a2,2,0,0,1,0,3.93H4.56a2,2,0,1,1,0-3.93Zm8,2a2,2,0,1,1,2,2h-2Zm-1,0a2,2,0,0,1-3.93,0V4.56a2,2,0,1,1,3.93,0V9.49Zm-2,8a2,2,0,1,1-2,2v-2Zm0-1a2,2,0,0,1,0-3.93h4.93a2,2,0,1,1,0,3.93Z"/></svg>',
  'social:telegram' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="currentColor" d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10s10-4.48 10-10S17.52 2 12 2m4.64 6.8c-.15 1.58-.8 5.42-1.13 7.19c-.14.75-.42 1-.68 1.03c-.58.05-1.02-.38-1.58-.75c-.88-.58-1.38-.94-2.23-1.5c-.99-.65-.35-1.01.22-1.59c.15-.15 2.71-2.48 2.76-2.69a.2.2 0 0 0-.05-.18c-.06-.05-.14-.03-.21-.02c-.09.02-1.49.95-4.22 2.79c-.4.27-.76.41-1.08.4c-.36-.01-1.04-.2-1.55-.37c-.63-.2-1.12-.31-1.08-.66c.02-.18.27-.36.74-.55c2.92-1.27 4.86-2.11 5.83-2.51c2.78-1.16 3.35-1.36 3.73-1.36c.08 0 .27.02.39.12c.1.08.13.19.14.27c-.01.06.01.24 0 .38"/></svg>',
  'social:threads' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="currentColor" d="M16.7051 11.1081C16.543 8.12137 14.911 6.41148 12.1708 6.39398C10.5193 6.3838 9.13771 7.08389 8.29233 8.36664L9.79941 9.40046C10.4334 8.43852 11.4342 8.24015 12.1593 8.24685C13.0616 8.2526 13.7425 8.51494 14.1832 9.02653C14.5038 9.39899 14.7183 9.91367 14.8245 10.5632C14.0246 10.4273 13.1594 10.3855 12.2345 10.4385C9.62919 10.5886 7.95426 12.1081 8.06675 14.2194C8.12384 15.2904 8.65739 16.2118 9.56906 16.8137C10.3399 17.3225 11.3326 17.5713 12.3644 17.515C13.727 17.4403 14.7959 16.9205 15.5416 15.9699C16.1079 15.248 16.4661 14.3125 16.6243 13.1338C17.2737 13.5257 17.7549 14.0414 18.0207 14.6613C18.4726 15.7151 18.499 17.4469 17.086 18.8587C15.848 20.0955 14.3598 20.6306 12.1108 20.6471C9.61601 20.6286 7.72924 19.8285 6.50253 18.269C5.35381 16.8088 4.76014 14.6996 4.73799 12C4.76014 9.30038 5.35381 7.19117 6.50253 5.73092C7.72924 4.17147 9.61597 3.37141 12.1107 3.35287C14.6236 3.37155 16.5433 4.17547 17.8169 5.74244C18.4415 6.51086 18.9123 7.47721 19.2227 8.60394L20.9888 8.13274C20.6125 6.74587 20.0205 5.55078 19.2148 4.55966C17.582 2.55073 15.1816 1.52134 12.1046 1.5C9.03385 1.52127 6.6725 2.55457 5.08614 4.57117C3.67451 6.3657 2.94634 8.87742 2.92188 12.0074C2.94634 15.1373 3.67451 17.6343 5.08614 19.4289C6.6725 21.4454 9.04616 22.4788 12.1169 22.5C14.847 22.4811 16.7713 21.7663 18.3566 20.1825C20.4307 18.1103 20.3682 15.513 19.6846 13.9185C19.1595 12.6943 18.1141 11.7129 16.7051 11.1081ZM12.2669 15.6648C11.125 15.7291 9.93869 15.2166 9.88019 14.1188C9.83684 13.3048 10.4595 12.3966 12.3369 12.2884C13.2594 12.2352 14.1138 12.2976 14.8701 12.463C14.6538 15.1648 13.3848 15.6035 12.2669 15.6648Z"/></svg>',
  'social:tiktok' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path fill-rule="evenodd" d="M16.57,2c.33,2.84,1.91,4.53,4.67,4.71V9.9a7.22,7.22,0,0,1-4.62-1.35v6c0,7.59-8.27,10-11.6,4.52-2.13-3.5-.82-9.64,6-9.88v3.36a11.17,11.17,0,0,0-1.59.39c-1.53.52-2.39,1.49-2.15,3.19.46,3.26,6.45,4.23,6-2.15V2h3.31Z"/></svg>',
  'social:twitch' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M21,3V14.74l-4.7,4.69H12.39L10,21.78h-3V19.43H3V6.13L4.23,3ZM19.43,4.57H6.13V16.31H9.26v2.34l2.35-2.35H16.3l3.13-3.13V4.57ZM16.31,7.7v4.69H14.74V7.7h1.57Zm-3.92,0v4.69H10.83V7.7Z"/></svg>',
  'social:writefreely' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M6.35,18.83a2.69,2.69,0,0,1-1.47-1.49,4.7,4.7,0,0,1-.23-1.92A26.66,26.66,0,0,1,5,11c.18-1.65.34-3.2.34-3.45,0-1.12-.65-1.51-1.43-.86a4.71,4.71,0,0,0-1,1.82L2.69,9l-.3,0A.91.91,0,0,1,2,8.78,4.69,4.69,0,0,1,2.61,7,4.32,4.32,0,0,1,4.26,5.26a2.39,2.39,0,0,1,2.57.32c.52.52.66,1,.65,2.36,0,.62-.1,2-.22,3.09C6.83,15,6.8,15.32,6.8,15.87c0,.76.12,1.12.46,1.42a.84.84,0,0,0,.65.26c2,0,3.66-2.31,4.41-6a13.11,13.11,0,0,0,.2-3.29c0-1.29,0-2.46-.06-2.61l-.06-.27h2.32l.06.56a31.23,31.23,0,0,1-.56,6.49,13.12,13.12,0,0,0-.17,4.15,1.76,1.76,0,0,0,.4.67c.29.27.3.28,1.06.28a2.26,2.26,0,0,0,1.43-.33C19.29,16,21,12.55,20.79,9.45A3.09,3.09,0,0,0,20,7.12c-.35-.31-.42-.32-.54-.09a1.33,1.33,0,0,1-1.56.29,1.14,1.14,0,0,1-.51-1.07,1.22,1.22,0,0,1,.66-1,1.69,1.69,0,0,1,1-.16,1.91,1.91,0,0,1,1.13.22,3.78,3.78,0,0,1,1.75,2.46,16.69,16.69,0,0,1,0,4.12c-.73,3.46-3.21,6.37-6,7a3.41,3.41,0,0,1-3.12-.61,4.19,4.19,0,0,1-.8-2.78c0-.28,0-.5,0-.5s-.15.29-.32.64c-1,2-2.7,3.38-4.38,3.36a3.91,3.91,0,0,1-1-.13Z"/></svg>',
  'social:x' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path d="M18.2048 2.25H21.5128L14.2858 10.51L22.7878 21.75H16.1308L10.9168 14.933L4.95084 21.75H1.64084L9.37084 12.915L1.21484 2.25H8.04084L12.7538 8.481L18.2048 2.25ZM17.0438 19.77H18.8768L7.04484 4.126H5.07784L17.0438 19.77Z"/></svg>',
  'social:youtube' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M21.54,6.5A30.83,30.83,0,0,1,22,12a30.83,30.83,0,0,1-.46,5.5,2.78,2.78,0,0,1-1.94,2C17.9,20,12,20,12,20s-5.89,0-7.61-.48a2.8,2.8,0,0,1-1.93-2A30.83,30.83,0,0,1,2,12a30.83,30.83,0,0,1,.46-5.5,2.78,2.78,0,0,1,1.93-2C6.11,4,12,4,12,4s5.9,0,7.6.48A2.79,2.79,0,0,1,21.54,6.5ZM10,15.5,16,12,10,8.5Z"/></svg>',
  'social:castopod' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M17.13,11.69a1.28,1.28,0,0,1-.26.8,2.91,2.91,0,0,0-1.09-.3,2.12,2.12,0,0,0-1.15.35,1.36,1.36,0,0,1-.29-.85,1.4,1.4,0,1,1,2.79,0ZM8.26,10.28a1.39,1.39,0,0,0-1.14,2.2,2.84,2.84,0,0,1,1.09-.3,2.12,2.12,0,0,1,1.15.35,1.36,1.36,0,0,0,.29-.85A1.39,1.39,0,0,0,8.26,10.28ZM22,7.19V17.8a1.34,1.34,0,0,1-1.34,1.35H17.17s-.36-.65-.49-.86a.57.57,0,0,0-.45-.19H7.75a.54.54,0,0,0-.46.19c-.17.23-.5.86-.5.86H3.35A1.35,1.35,0,0,1,2,17.81V7.2A1.35,1.35,0,0,1,3.34,5.85H20.65A1.35,1.35,0,0,1,22,7.19Zm-2.6,4.39a2.82,2.82,0,0,0-2.84-2.86H7.43a2.85,2.85,0,0,0,0,5.7h9.13A2.84,2.84,0,0,0,19.4,11.58Z"/></svg>',
  'social:default' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0z"/><path d="M12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10-4.477 10-10 10zm-2.29-2.333A17.9 17.9 0 0 1 8.027 13H4.062a8.008 8.008 0 0 0 5.648 6.667zM10.03 13c.151 2.439.848 4.73 1.97 6.752A15.905 15.905 0 0 0 13.97 13h-3.94zm9.908 0h-3.965a17.9 17.9 0 0 1-1.683 6.667A8.008 8.008 0 0 0 19.938 13zM4.062 11h3.965A17.9 17.9 0 0 1 9.71 4.333 8.008 8.008 0 0 0 4.062 11zm5.969 0h3.938A15.905 15.905 0 0 0 12 4.248 15.905 15.905 0 0 0 10.03 11zm4.259-6.667A17.9 17.9 0 0 1 15.973 11h3.965a8.008 8.008 0 0 0-5.648-6.667z"/></svg>',
  'podcasting:amazon' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path d="M22,18.23a4.28,4.28,0,0,1-1.32,2.9c-.18.14-.36.06-.28-.15.26-.65.87-2.14.58-2.49s-1-.24-1.73-.18c-.33,0-.61.06-.83.1s-.25-.16,0-.3a3.36,3.36,0,0,1,.87-.43,3.87,3.87,0,0,1,2.67.09.84.84,0,0,1,.08.46Zm-1.92,1.29a7,7,0,0,1-.83.55A14.69,14.69,0,0,1,12,22,14.57,14.57,0,0,1,2.1,18.23c-.22-.18,0-.45.22-.3a19.85,19.85,0,0,0,9.89,2.63,19.55,19.55,0,0,0,7-1.34l.5-.2C20.12,18.85,20.44,19.26,20.08,19.52Zm-6.17-11a3.85,3.85,0,0,0-.31-2.18A1.7,1.7,0,0,0,12,5.66a2,2,0,0,0-1.87,1.53.55.55,0,0,1-.44.48L7.29,7.36a.4.4,0,0,1-.35-.52C7.46,4.09,9.81,3.13,12,3h.53a5.89,5.89,0,0,1,3.79,1.26c1.21,1.14,1.08,2.67,1.08,4.32v3.93a3.24,3.24,0,0,0,1,2.31.48.48,0,0,1,0,.66c-.48.43-1.4,1.22-1.92,1.65a.57.57,0,0,1-.61.05,6.86,6.86,0,0,1-1.43-1.66A5.45,5.45,0,0,1,12,17.13a7.11,7.11,0,0,1-1.78.22A3.56,3.56,0,0,1,6.5,13.47a4.2,4.2,0,0,1,2.7-4.1,15.59,15.59,0,0,1,4.7-.88Zm-.48,5.2c.52-.88.47-1.59.47-3.19a8.6,8.6,0,0,0-1.87.18A2.29,2.29,0,0,0,10.16,13c0,1.09.57,1.84,1.52,1.84a1.18,1.18,0,0,0,.35,0A2,2,0,0,0,13.43,13.69Z"/><path fill="none" d="M0,0H24V24H0Z"/></svg>',
  'podcasting:antennapod' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path fill-opacity="0.88" d="M12.06,2.52A8.55,8.55,0,0,0,4.82,6.4,9.93,9.93,0,0,0,3.69,9a8.64,8.64,0,0,0,2.69,8.59,10.55,10.55,0,0,0,1,.73,3.82,3.82,0,0,0,.24-.61c.12-.34.21-.64.21-.66a1.08,1.08,0,0,0-.21-.19,8.14,8.14,0,0,1-1.2-1.16,7.2,7.2,0,0,1-1.62-4.61A7,7,0,0,1,5.5,7.88a7.23,7.23,0,0,1,5.49-4,8.62,8.62,0,0,1,2,0,7.27,7.27,0,0,1,6.17,6.17,9.1,9.1,0,0,1,0,1.88,7.35,7.35,0,0,1-1.62,3.76,9.94,9.94,0,0,1-1.14,1.11,1.31,1.31,0,0,0-.23.21s.1.31.22.64l.22.61.26-.17a8.18,8.18,0,0,0,1.14-1,8,8,0,0,0,1.62-2.25,8.58,8.58,0,0,0,.69-5.71A8.4,8.4,0,0,0,18.12,5.1a8.39,8.39,0,0,0-6.06-2.58ZM12,5.83a4.59,4.59,0,0,0-1.64.25A5.52,5.52,0,0,0,7.54,8.26a6.34,6.34,0,0,0-.74,1.93,7.2,7.2,0,0,0,0,1.67,5.44,5.44,0,0,0,1,2.39,5.31,5.31,0,0,0,.71.77,6.13,6.13,0,0,0,.26-.65c.12-.36.23-.67.23-.69a1.41,1.41,0,0,0-.17-.26,3.84,3.84,0,0,1-.75-2.36,3.68,3.68,0,0,1,.52-2,3.95,3.95,0,0,1,7,3.7,3.51,3.51,0,0,1-.36.61l-.19.26.17.44c.09.24.19.54.24.67a.74.74,0,0,0,.1.23,6.13,6.13,0,0,0,.8-.89,5.44,5.44,0,0,0,.85-2,5.14,5.14,0,0,0-.4-3.33,4.74,4.74,0,0,0-1-1.47,5.07,5.07,0,0,0-2.08-1.29A4.51,4.51,0,0,0,12,5.83Zm0,3.28a1.93,1.93,0,0,0-1.38.59A1.84,1.84,0,0,0,10,11.2a1.92,1.92,0,0,0,.44,1.14l.15.19-.11.3c0,.16-.49,1.4-1,2.75S8.36,18.92,8,20s-.64,1.8-.7,1.95a12.15,12.15,0,0,0,1.57.55L9,22c.1-.27.34-1,.55-1.55l.37-1H10l.55.1a6.71,6.71,0,0,0,1.43.08,6.43,6.43,0,0,0,1.41-.08l.54-.1.1,0L14.62,21c.27.78.5,1.44.53,1.54A12.34,12.34,0,0,0,16.73,22h0S16,19.89,15.1,17.39l-1.66-4.7-.06-.16.17-.22a2,2,0,0,0,.22-2.12,2.32,2.32,0,0,0-.87-.86A2,2,0,0,0,12,9.11Zm0,4.51s1.5,4.12,1.51,4.21a7.6,7.6,0,0,1-2.09.16,5.39,5.39,0,0,1-.9-.15S12,13.67,12,13.62Z"/></svg>',
  'podcasting:anytime' => '<svg fill="currentColor" version="1.1" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path stroke-width=".051688" d="m12.337 21.992c.42642-.01097.99628-.05612 1.2663-.10039.27007-.04426.712-.13869.98207-.20991.27007-.07117.68874-.20166.93038-.28989.24164-.08822.68357-.28266.98207-.43208.2985-.14942.75206-.40976 1.0079-.57854.25586-.16877.64135-.44892.85667-.62258.21531-.17366.60072-.53461.85642-.8021.25572-.26749.61932-.69339.80798-.94641.18868-.25304.46958-.6814.62424-.95193.15464-.27052.38855-.74327.51982-1.0506.13124-.30728.30922-.79538.39551-1.0846.08633-.28927.2038-.7934.26114-1.1203.05732-.32692.11734-.95493.13336-1.3956.01744-.47949.004-1.0295-.0323-1.3697-.03379-.31272-.10867-.78954-.16645-1.0596-.057813-.27007-.1867-.74688-.2865-1.0596-.099802-.31271-.31667-.85274-.48192-1.2001-.16526-.34732-.43355-.83579-.59622-1.0854-.16266-.24968-.4025-.59348-.53295-.76405-.13048-.17058-.44711-.52888-.70363-.7962-.2565-.26734-.6906-.66558-.96465-.88494-.27405-.21939-.70585-.52732-.95958-.68425-.25373-.15695-.60382-.35728-.7779-.44517-.17412-.08792-.5496-.25265-.83445-.36611-.28481-.11348-.78048-.27604-1.1015-.36125-.32098-.085229-.8162-.19423-1.1005-.24225-.35751-.060408-.81967-.087621-1.4989-.088319-.69443-.0006978-1.1335.024921-1.4989.087422-.28428.048645-.73785.14667-1.0079.21794-.27007.071273-.68875.20173-.93039.28994-.24164.088219-.67194.27623-.95623.41782-.28428.14159-.71458.38579-.95623.54272-.24164.1569-.57891.39233-.74947.52318-.17057.13084-.49405.41259-.71887.6261-.2248.21348-.57891.59183-.78689.84075-.208.24893-.49386.62402-.63525.83357-.14137.20951-.37322.59896-.51521.86541-.142.26646-.35274.72781-.4683 1.0252-.11556.29742-.25791.71107-.3163.91921-.058414.20815-.15254.60445-.2092.88067-.071871.35068-.11204.8088-.13299 1.5184-.019338.6554-.00797 1.1968.031699 1.5248.033892.27973.11895.75283.18899 1.0513.069977.2985.18767.7288.26142.95622.073765.22743.28075.72109.45998 1.0971.17924.37597.45885.88768.62134 1.1371.16249.24944.40225.59312.53275.76369.13047.17057.4471.52887.70362.7962.25653.26733.6906.66559.96465.88495.27405.21939.70585.52732.95958.68424.25374.15696.60382.35729.7779.44518.17412.08792.55637.25536.8495.37214.2931.11679.83527.2893 1.2048.38336.36956.0941.88127.19686 1.1371.22845.25586.0316.5466.06679.6461.07815.09948.01136.52979.01166.95622.000707zm-.10338-1.284c-.59699.008-1.2295-.008-1.4057-.03509-.17614-.02681-.58675-.1161-.91244-.19835-.3257-.082237-.83284-.24588-1.127-.36359-.29415-.11772-.75577-.33899-1.0258-.49172-.27007-.15273-.68875-.42359-.93039-.6019-.24164-.17832-.6952-.58149-1.0079-.89596-.3127-.31445-.72528-.79259-.91678-1.0625-.19154-.26997-.49705-.78272-.67893-1.1395-.18187-.35676-.41321-.90397-.51411-1.2161-.10089-.3121-.23258-.7994-.29264-1.0829-.072469-.34214-.11956-.80432-.13999-1.3744-.024024-.67148-.011065-.99861.05961-1.4989.049742-.352.16773-.90955.26222-1.239.094499-.32945.27391-.83103.39871-1.1146.12481-.2836.35177-.72229.50435-.97494.15259-.25262.46048-.68688.68419-.96502.22373-.27813.59731-.68124.83022-.8958.23288-.21456.63276-.53973.88861-.7226.25586-.18289.70942-.45887 1.0079-.61328.29849-.15443.76369-.36244 1.0338-.46224.27006-.099802.77015-.24531 1.1113-.32334.51947-.11884.77625-.14579 1.5806-.16587.58237-.014554 1.1385-.0002591 1.4129.036285.24895.033095.71587.12672 1.0376.20797.32173.081241.82561.24405 1.1198.36176.29415.11772.75578.33899 1.0259.49172s.68874.42359.93038.6019c.24164.17832.69521.58149 1.0079.89596.31271.31445.72466.79259.9154 1.0625.19077.26997.4733.73506.62785 1.0335.15456.2985.36266.76369.46247 1.0338.0998.27007.24192.76203.31581 1.0933.07386.33126.16164.90893.19497 1.2838.04645.52288.04635.84588-.000588 1.3877-.03369.38842-.11726.95043-.18579 1.2489-.06848.2985-.19906.75206-.29008 1.0079-.09101.25586-.28196.69727-.42433.98099-.14236.28372-.37584.6907-.51884.90454-.14299.21383-.41887.5788-.61297.81108-.19412.23228-.52448.57772-.73417.76757-.20966.1899-.588.4933-.8408.67422-.25278.18092-.70379.4553-1.0023.60976-.2985.15443-.76369.36244-1.0338.46224-.27007.0998-.77015.24562-1.1113.32404-.55492.12755-.73453.14401-1.7057.15625zm-3.9283-1.1038c.056819-.01236.32434-.14794.59441-.30132.27007-.15338 1.34-.78581 2.3776-1.4054 1.7636-1.053 1.8849-1.1348 1.8608-1.2538-.01426-.06998-.02582-1.2321-.02582-2.5825 0-1.9002.01595-2.5194.07048-2.7395.03878-.15636.14268-.43547.23088-.62026.10503-.22004.2769-.45215.49806-.67262.18573-.18516.45572-.39955.59999-.47641.14427-.076855.3992-.1754.5665-.21898.16731-.043561.50299-.079248.74596-.079248.24297 0 .52147.022827.61891.050838.09739.027911.18502.042863.19466.033294.01-.00997-1.838-1.1278-4.1058-2.4848-2.907-1.7395-4.1702-2.4689-4.2823-2.4726-.087422-.0029905-.23169.024821-.32053.061604-.088817.036783-.20336.12852-.2545.20382-.086126.12679-.094001.33572-.10674 2.8247l-.013756 2.6878.24637-.26465c.1355-.14557.37693-.34776.53652-.44935.15959-.10158.43869-.23559.62026-.2978.25338-.086824.45024-.1131.847-.11307.38482 1.99e-5.60367.028011.85657.10941.18684.060208.47777.19864.64651.30771.16875.10906.4017.30609.51765.43782.11595.13172.28381.37644.37302.54381.08922.16737.19732.45333.24026.63545.05901.2506.07825.66026.07885 1.684l.000767 1.3528-.13381.15902c-.11142.13242-.17122.15902-.35722.15902-.18601 0-.2458-.02661-.35722-.15902-.10504-.12483-.13381-.21479-.13381-.4183v-.25926l-.27136.24528c-.14926.1349-.41672.31368-.59442.3973-.17766.08363-.48584.17724-.68486.20805-.25983.04017-.46384.04017-.72369 0-.19901-.030801-.51476-.12757-.70166-.21504-.22629-.10589-.45079-.26999-.67195-.49111l-.33207-.33208v2.7799c0 1.5289.014853 2.854.032895 2.9446.018142.09051.099792.23149.1815.31321.08174.08174.21228.15794.29013.16938.077852.01146.18806.01067.24492-.002zm5.8588-3.4324c.02412-.01.62832-.36475 1.3426-.78948.71433-.42476 1.2928-.77816 1.2856-.7854-.007-.007-.1055.008-.21842.03449-.11291.02622-.36971.04815-.57063.04884-.20094.000678-.49168-.03618-.64609-.08204-.15441-.04575-.3671-.12722-.47264-.18097-.10554-.05373-.32069-.20264-.47811-.33087l-.28622-.23311v1.1679c0 .64232.01974 1.1601.04386 1.1507zm3.5743-2.1153c.07107-.04486.69964-.42025 1.3968-.83408.87176-.5175 1.2906-.79548 1.3413-.89017.04057-.07576.07366-.21643.07366-.31263 0-.09619-.0327-.23594-.07257-.31052-.04875-.09101-.47283-.37544-1.2896-.86489-.66936-.4011-1.2732-.76524-1.3417-.80923-.10198-.065392-.08961-.03389.06798.17249.10598.13883.2495.36456.31895.5016.06948.13705.16097.38239.20337.5452.04237.16281.07675.48301.07636.71158-.000408.22856-.03589.56459-.07885.74674-.04296.18213-.15105.4681-.24026.63545-.08922.16737-.25726.41361-.37345.54722-.15643.17988-.17772.22172-.08204.16127zm-1.86-.26868c.33029-.01176.50141-.04536.6859-.13467.13519-.06549.34771-.2209.47226-.34545.12455-.12454.27628-.32936.33717-.45513.06091-.12577.13739-.3722.17001-.54759.04376-.23542.04446-.40585.002-.65096-.0313-.18262-.1102-.44255-.17537-.57766-.06519-.13508-.22982-.35431-.36587-.48718-.15634-.15267-.35696-.2829-.54515-.35385-.2435-.09181-.37793-.10856-.73717-.09191-.36306.01685-.48694.04635-.7135.16974-.15078.08214-.35696.24105-.4582.35312-.10125.11206-.24537.33446-.32028.49424-.11876.25328-.13621.35681-.13621.80845 0 .48111.01206.54251.16988.86303.10496.2132.26016.42455.4061.55301.12991.11436.35584.25529.50205.31318.21015.08324.35807.10198.70595.08962zm-5.9617-.21008c.27265-.01276.44637-.05433.65659-.15716.1629-.07975.38571-.25094.51807-.39818.12774-.14208.28355-.39094.34624-.55306.08543-.22096.11398-.40464.11398-.73406 0-.32496-.02871-.51337-.11015-.72364-.06061-.15635-.18219-.37162-.27023-.47836-.08802-.10674-.26149-.26384-.38543-.34912-.12395-.085229-.37136-.19246-.5498-.23817-.21812-.055922-.41824-.07237-.6106-.05024-.15739.018042-.40536.090711-.55105.16151-.14568.070774-.3741.24543-.5076.38816-.1335.14272-.29172.36922-.35158.50332-.070675.15826-.11684.39061-.13162.66207-.015849.29091.00299.50539.060507.70456.045754.15749.16035.39823.25459.53498.0942.13674.2831.32565.41969.41977.1366.0941.3562.20574.48802.24803.15011.04815.37821.07038.61044.05961z"/></svg>',
  'podcasting:apple' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M11.36,22.27c-.77-.28-.94-.65-1.25-2.84-.37-2.54-.45-4.11-.23-4.61a2.11,2.11,0,0,1,2.11-1,2.09,2.09,0,0,1,2.12,1c.21.5.13,2.07-.24,4.61-.24,1.78-.38,2.23-.72,2.53a1.78,1.78,0,0,1-1.78.31ZM8.08,19.66a9,9,0,0,1-5-6.45,11.9,11.9,0,0,1,0-3.26A9.05,9.05,0,0,1,5.43,5.33,9,9,0,0,1,18.5,5.26,8.83,8.83,0,0,1,20.92,10a12.6,12.6,0,0,1,0,3.07,9.08,9.08,0,0,1-3.47,5.68A10.5,10.5,0,0,1,15,20.08c-.09,0-.1-.1-.06-.5.08-.63.16-.76.52-.92a8.2,8.2,0,0,0,4.31-5.33,10.13,10.13,0,0,0-.06-3.76,8,8,0,0,0-6-5.74,9.67,9.67,0,0,0-3.22,0A8.06,8.06,0,0,0,4.33,9.76a10.76,10.76,0,0,0,0,3.58,8.27,8.27,0,0,0,3.42,4.84,7,7,0,0,0,.89.5c.36.16.43.29.5.92,0,.39,0,.5-.06.5a6.76,6.76,0,0,1-1-.41Zm0-3.49A6.54,6.54,0,0,1,6.1,13a7.36,7.36,0,0,1,0-2.92A6.3,6.3,0,0,1,10.2,5.72a7.57,7.57,0,0,1,3.13-.12A6.12,6.12,0,0,1,18,12.23a6,6,0,0,1-1.3,3.09,5.44,5.44,0,0,1-1.39,1.23,2.06,2.06,0,0,1-.05-.65v-.64l.44-.54a4.87,4.87,0,0,0-.27-6.67,4.66,4.66,0,0,0-2.6-1.34,3.25,3.25,0,0,0-1.55,0A4.71,4.71,0,0,0,8.6,8.05a4.88,4.88,0,0,0-.28,6.67l.44.54v.65a1.9,1.9,0,0,1-.06.65,3,3,0,0,1-.55-.39Zm3-3.51a2,2,0,0,1-1.19-1.9,2.1,2.1,0,0,1,1.2-1.87,2.28,2.28,0,0,1,1.81,0A2.35,2.35,0,0,1,14,10.25a2.08,2.08,0,0,1-2.91,2.41Z"/></svg>',
  'podcasting:blubrry' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M15.84,4.47s.92-2.09.87-2.13-2.1,1.25-2.1,1.25S12.11,1.66,12,1.66,9.74,3.43,9.74,3.43,7.47,1.78,7.41,1.84s.74,2.65.74,2.65a8.83,8.83,0,0,0-5.62,8.13,9.26,9.26,0,0,0,9.47,9,9.16,9.16,0,0,0,9.47-9A8.88,8.88,0,0,0,15.84,4.47Zm.93,8.12a4.45,4.45,0,0,0-2.56-3.93l.35-.88a5.39,5.39,0,0,1,3.19,4.81Zm2.14,0A6.47,6.47,0,0,0,15,6.74l.5-1.26a7.81,7.81,0,0,1,4.86,7.11Z"/></svg>',
  'podcasting:breez' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0Z"/><path d="M18.66 10.64a5.13 5.13 0 0 1 2.25 1.86 4.93 4.93 0 0 1 .84 2.83 5 5 0 0 1-.69 2.56 5.26 5.26 0 0 1-1.85 1.84 5.12 5.12 0 0 1-2.56.67H14.5v.6a1 1 0 0 1-.36.74 1.16 1.16 0 0 1-.84.31 1.07 1.07 0 0 1-.76-.31 1 1 0 0 1-.34-.74v-.6H8.38a1.09 1.09 0 0 1-.84-.4 1.21 1.21 0 0 1-.31-.91 1.34 1.34 0 0 1 .45-.72 1.15 1.15 0 0 1 .77-.31h8.11a2.76 2.76 0 0 0 1.44-.34 3 3 0 0 0 1-1 2.66 2.66 0 0 0-.22-3.11 2.79 2.79 0 0 0-1.55-1 1.74 1.74 0 0 0-.67-.09h-2.2a1.28 1.28 0 0 1-.84-.31 1.33 1.33 0 0 1-.41-.75 1 1 0 0 1 .27-.83 1.16 1.16 0 0 1 .83-.36h1a2.09 2.09 0 0 0 1.44-.72A2.29 2.29 0 0 0 17.23 8a2.16 2.16 0 0 0-.62-1.58 2.09 2.09 0 0 0-1.56-.64h-4.66a1 1 0 0 1-.75-.32 1.1 1.1 0 0 1-.31-.76 1.09 1.09 0 0 1 .31-.77 1 1 0 0 1 .75-.33h1.81v-.5a1 1 0 0 1 .34-.77A1.07 1.07 0 0 1 13.3 2a1.16 1.16 0 0 1 .84.31 1 1 0 0 1 .36.77v.5h.55a4.41 4.41 0 0 1 2.25.6 4.52 4.52 0 0 1 1.63 1.62 4.33 4.33 0 0 1 .62 2.25 4.28 4.28 0 0 1-.89 2.59Zm-4.85-2.49a1.15 1.15 0 0 0-.36-.84 1.11 1.11 0 0 0-.82-.38H7.51a1.06 1.06 0 0 0-.81.38 1.23 1.23 0 0 0-.31.84 1.16 1.16 0 0 0 .31.79 1.07 1.07 0 0 0 .81.36h5.12a1.12 1.12 0 0 0 .82-.36 1.09 1.09 0 0 0 .36-.79Zm-4.12 3.32a1 1 0 0 0-.33-.76 1.13 1.13 0 0 0-.84-.31h-5.1a1.16 1.16 0 0 0-.83.31 1 1 0 0 0-.34.76 1.17 1.17 0 0 0 .34.84 1.14 1.14 0 0 0 .83.34h5.1a1.11 1.11 0 0 0 .84-.34 1.14 1.14 0 0 0 .33-.84Zm4.36 3.86a1.13 1.13 0 0 0-1.11-1.11H5.67a1.07 1.07 0 0 0-.79.32 1.09 1.09 0 0 0-.31.79 1.27 1.27 0 0 0 .31.83 1.06 1.06 0 0 0 .79.36h7.27a1 1 0 0 0 .77-.36 1.21 1.21 0 0 0 .34-.83Z"/></svg>',
  'podcasting:castamatic' => '<svg fill="currentColor" version="1.1" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path stroke-width=".054074" d="m8.1088 22c.17844.0032.54344-.01907.81111-.04955.26767-.03048.7665-.1174 1.1085-.19314.34202-.07574 1.0484-.2794 1.5697-.45257.5213-.17317 1.3772-.49866 1.902-.7233.52483-.22464 1.3271-.59482 1.7829-.82263.45578-.2278 1.0964-.56133 1.4235-.74118.32715-.17985.92331-.5219 1.3248-.76012.4015-.23822 1.0443-.6376 1.4285-.88752l.69853-.45439-1.6715-1.6722c-.91935-.91971-1.6916-1.6722-1.7161-1.6722-.02448 0-.38963.21582-.81144.47961-.42181.26378-1.0468.63765-1.3888.83082-.34202.19317-.954.52156-1.36.72976-.40596.2082-.91905.45387-1.1402.54593-.22115.09207-.63991.22918-.93059.30471-.37181.0966-.66702.13696-.99573.13613-.33573-.000855-.52869-.0291-.68562-.10038-.12012-.05457-.32424-.21828-.45361-.36382-.12937-.14554-.31662-.43494-.41612-.64313-.0995-.20818-.22776-.56242-.28504-.78719-.05728-.22477-.13564-.6506-.17414-.9463-.04009-.30786-.06998-1.0807-.06992-1.8084 4.9e-5-.7202.02936-1.4816.06766-1.7574.03717-.26767.11543-.6907.17392-.94007.05849-.24937.18316-.61437.27705-.81111.1043-.21853.28838-.47539.47316-.66017.24564-.24565.35698-.31555.59273-.3721.18298-.043896.42646-.056982.65866-.035401.2026.01883.56192.080463.79847.13696.23655.056499.66828.20449.95939.32887.29111.12438.73768.33098.99236.45911.25469.12814.85241.45031 1.3283.71593.47585.26563 1.1932.68801 1.594.93862.40087.25061.75061.46477.77721.4759.02659.01119.79624-.73889 1.7103-1.6667l1.662-1.687-.54976-.36885c-.30237-.20287-.97416-.6237-1.4929-.9352-.51872-.31149-1.3434-.77858-1.8326-1.038-.48923-.25939-1.275-.65178-1.7462-.87198-.47117-.2202-1.2024-.53746-1.6249-.70502-.42254-.16756-1.0603-.40081-1.4171-.51834s-.94089-.28311-1.2978-.36797c-.35689-.084855-.83923-.18026-1.0719-.21202-.23264-.031756-.63414-.057314-.89222-.056798-.25808.0005191-.63059.03514-.8278.076941s-.47705.1364-.62185.21023c-.15146.077217-.46018.33736-.72689.6125-.25498.26305-.53769.58778-.62824.72161-.09056.13383-.25442.42194-.36415.64023-.10973.21829-.28346.64776-.38606.95438-.1026.30662-.24868.83273-.32462 1.1691-.07594.33642-.18389.94111-.23988 1.3438-.05599.40266-.13297 1.0849-.17104 1.5162-.04166.47182-.06848 1.5916-.06733 2.8118.0014 1.5223.02547 2.2637.09647 2.9741.05201.52046.15522 1.3057.22933 1.7449.07411.43923.2167 1.0962.31687 1.46.10016.36377.27396.87978.38621 1.1467.11224.26691.34343.69362.51375.94825.17032.25463.51451.65962.76487.89998.34606.33224.52985.46494.76655.5535.17124.06407.43674.13744.59.16304.15326.02561.42466.0492.6031.05243z"/></svg>',
  'podcasting:castbox' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path fill-rule="evenodd" d="M14.42,6.47a1.07,1.07,0,0,0-1.11,1.06v2.56c0,.33-.28.55-.67.55a.63.63,0,0,1-.67-.55V6.64a1.11,1.11,0,0,0-1.11-1.06A1.07,1.07,0,0,0,9.75,6.64V9.41c0,.34-.28.56-.67.56a.63.63,0,0,1-.66-.56v-1a1.1,1.1,0,0,0-1.11-1,1.07,1.07,0,0,0-1.12,1V10.8a.58.58,0,0,1-.66.56.63.63,0,0,1-.67-.56v-.27a1.11,1.11,0,1,0-2.22-.08v3.41a1.11,1.11,0,0,0,2.22,0v-.28c0-.33.28-.55.67-.55a.61.61,0,0,1,.66.55v3.78a1.11,1.11,0,0,0,1.12,1.06,1.07,1.07,0,0,0,1.11-1.06V12.2a.58.58,0,0,1,.66-.56.63.63,0,0,1,.67.56v2.55a1.1,1.1,0,0,0,1.11,1.06A1.07,1.07,0,0,0,12,14.75V12.86c0-.33.28-.55.67-.55a.63.63,0,0,1,.67.55v2.06A1.11,1.11,0,0,0,14.42,16a1.07,1.07,0,0,0,1.11-1.06V7.53a1.11,1.11,0,0,0-1.11-1.06M18,9.36a1.07,1.07,0,0,0-1.11,1.06v4.22A1.1,1.1,0,0,0,18,15.7a1.07,1.07,0,0,0,1.11-1.06V10.42A1.07,1.07,0,0,0,18,9.36m3.56,2.11a1.07,1.07,0,0,0-1.11,1.06v1.06a1.1,1.1,0,0,0,1.11,1.06,1.07,1.07,0,0,0,1.11-1.06V12.53a1.07,1.07,0,0,0-1.11-1.06"/></svg>',
  'podcasting:castopod' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M17.13,11.69a1.28,1.28,0,0,1-.26.8,2.91,2.91,0,0,0-1.09-.3,2.12,2.12,0,0,0-1.15.35,1.36,1.36,0,0,1-.29-.85,1.4,1.4,0,1,1,2.79,0ZM8.26,10.28a1.39,1.39,0,0,0-1.14,2.2,2.84,2.84,0,0,1,1.09-.3,2.12,2.12,0,0,1,1.15.35,1.36,1.36,0,0,0,.29-.85A1.39,1.39,0,0,0,8.26,10.28ZM22,7.19V17.8a1.34,1.34,0,0,1-1.34,1.35H17.17s-.36-.65-.49-.86a.57.57,0,0,0-.45-.19H7.75a.54.54,0,0,0-.46.19c-.17.23-.5.86-.5.86H3.35A1.35,1.35,0,0,1,2,17.81V7.2A1.35,1.35,0,0,1,3.34,5.85H20.65A1.35,1.35,0,0,1,22,7.19Zm-2.6,4.39a2.82,2.82,0,0,0-2.84-2.86H7.43a2.85,2.85,0,0,0,0,5.7h9.13A2.84,2.84,0,0,0,19.4,11.58Z"/></svg>',
  'podcasting:castro' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path fill-rule="evenodd" d="M12,2h0A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,11.67a1.73,1.73,0,1,1,1.72-1.73A1.72,1.72,0,0,1,12,13.67Zm4.17,4L14.5,15.39a4.25,4.25,0,1,0-4.94,0L7.89,17.72a7.12,7.12,0,1,1,11.28-5.78A7.37,7.37,0,0,1,16.17,17.72Z"/></svg>',
  'podcasting:deezer' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="m19.54 3.4058c-0.31949 0-0.57508 0.67093-0.76677 1.7252-0.31949-1.8211-0.79872-3.0032-1.3419-3.0032-0.63898 0-1.2141 1.6933-1.4696 4.1214-0.25559-1.7891-0.63898-2.9073-1.1182-2.9073-0.63898 0-1.1502 2.2364-1.3419 5.3355-0.38339-1.5974-0.89457-2.5879-1.5016-2.5879-0.57508 0-1.1182 0.95847-1.5016 2.5559-0.19169-3.0671-0.70288-5.3035-1.3419-5.3035-0.44728 0-0.83067 1.1182-1.1182 2.8754-0.25559-2.3962-0.83067-4.0895-1.4696-4.0895-0.54313 0-1.0543 1.1821-1.3419 3.0032-0.19169-1.0543-0.44728-1.7252-0.76677-1.7252-0.54313 0-0.99042 2.3323-0.99042 5.1757s0.44728 5.1438 0.99042 5.1438c0.25559 0 0.44728-0.38339 0.63898-1.0543 0.25559 2.4281 0.83067 4.0895 1.4696 4.0895 0.51118 0 0.95847-1.0224 1.278-2.5559 0.19169 2.9712 0.70288 5.0799 1.3099 5.0799 0.38339 0 0.73482-0.83067 0.95847-2.2045 0.31949 2.8115 1.0543 4.7923 1.9169 4.7923 0.79872 0 1.5335-1.9808 1.8211-4.7923 0.25559 1.3738 0.63898 2.2045 0.99042 2.2045 0.63898 0 1.1502-2.1086 1.3419-5.1118 0.31949 1.5974 0.76677 2.5559 1.278 2.5559 0.63898 0 1.1821-1.6294 1.4696-4.0575 0.15974 0.67093 0.38339 1.0543 0.60703 1.0543 0.54313 0 1.0224-2.3003 1.0224-5.1438 0-2.8754-0.47923-5.1757-1.0224-5.1757zm-16.965 6.9649c0.31949 0 0.57508-1.0224 0.57508-2.3003s-0.25559-2.3003-0.57508-2.3003-0.57508 1.0224-0.57508 2.3003 0.25559 2.3003 0.57508 2.3003zm19.425-2.3003c0 1.278-0.25559 2.3003-0.57508 2.3003s-0.57508-1.0224-0.57508-2.3003 0.25559-2.3003 0.57508-2.3003 0.57508 1.0224 0.57508 2.3003z"/></svg>',
  'podcasting:episodes-fm' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="m0 0h24v24h-24z"/><path d="m6.291 1.2265c0.1724 0.29294 0.0746 0.67011-0.2184 0.84243-1.026 0.60355-1.9514 1.2448-2.6918 2.0422-0.23126 0.24905-0.62064 0.26347-0.86969 0.03221s-0.26347-0.62064-0.03221-0.86969c0.85961-0.92574 1.9034-1.6383 2.9697-2.2655 0.293-0.17232 0.6701-0.07453 0.8424 0.21841zm2.6343 2.3859c0.3297-0.08243 0.5302-0.41654 0.4477-0.74626-0.0824-0.32972-0.4165-0.53019-0.7462-0.44776-2.9085 0.72713-5.2109 2.839-6.3269 5.5306-0.13018 0.3139 0.0188 0.6739 0.33275 0.8041s0.67399-0.0188 0.80416-0.3327c0.97629-2.3546 2.9816-4.1812 5.4885-4.808zm1.943 2.2338c-3.0588 0-5.5384 2.4796-5.5384 5.5384 0 2.8508 2.1539 5.1986 4.9231 5.5047v1.237c-3.4502-0.3109-6.1539-3.2105-6.1539-6.7417 0-3.7385 3.0307-6.7692 6.7692-6.7692 3.7386 0 6.7693 3.0307 6.7693 6.7692 0 3.0986-2.0819 5.7109-4.9231 6.5145v4.5625c0 0.3399-0.2755 0.6154-0.6154 0.6154-0.3387 0-0.6134-0.2736-0.6154-0.6118v-8.0652c1.4045-0.2851 2.4616-1.5268 2.4616-3.0154 0-1.6993-1.3776-3.0769-3.077-3.0769-1.6993 0-3.0769 1.3776-3.0769 3.0769 0 1.4886 1.0571 2.7303 2.4616 3.0154v1.2487c-2.0876-0.2986-3.6924-2.0939-3.6924-4.2641 0-2.379 1.9287-4.3076 4.3077-4.3076 2.3791 0 4.3077 1.9286 4.3077 4.3076 0 1.7184-1.0062 3.2018-2.4615 3.8932v1.3302c2.1511-0.7604 3.6923-2.8119 3.6923-5.2234 0-3.0588-2.4797-5.5384-5.5385-5.5384zm-8.2357 8.17c0.31395-0.1301 0.67399 0.0188 0.80416 0.3328 0.97629 2.3546 2.9816 4.1812 5.4885 4.8079 0.3297 0.0824 0.5302 0.4166 0.4477 0.7463-0.0824 0.3297-0.4165 0.5302-0.7462 0.4477-2.9085-0.7271-5.2109-2.8389-6.3269-5.5305-0.13018-0.3139 0.0188-0.674 0.33275-0.8042zm16.869-5.8755c-0.1262-0.3155-0.4843-0.469-0.7999-0.3428-0.3155 0.1262-0.469 0.4843-0.3428 0.7999 0.337 0.8425 0.5098 1.8101 0.5098 2.7868 0 0.9768-0.1728 1.9443-0.5098 2.7869-0.1262 0.3155 0.0273 0.6737 0.3428 0.7999 0.3156 0.1262 0.6737-0.0273 0.7999-0.3428 0.4015-1.0036 0.5979-2.1284 0.5979-3.244 0-1.1155-0.1964-2.2403-0.5979-3.2439zm-16.12 10.456c-0.23126-0.2491-0.62064-0.2635-0.86969-0.0322-0.24905 0.2312-0.26347 0.6206-0.03221 0.8697 0.85029 0.9157 1.8912 1.6952 2.9938 2.2789 0.3004 0.1591 0.6728 0.0445 0.8318-0.2559s0.0444-0.6728-0.2559-0.8318c-0.9897-0.5239-1.9181-1.2213-2.6678-2.0287zm18.427-9.2996c0.3373-0.0421 0.6448 0.1971 0.687 0.5343 0.0663 0.5305 0.0663 1.0551 0.0663 1.5366v0.0448c0 0.4748 1e-4 1.0318-0.1415 1.5981-0.0824 0.3297-0.4165 0.5302-0.7462 0.4477-0.3298-0.0824-0.5302-0.4165-0.4478-0.7462 0.1018-0.4071 0.1047-0.824 0.1047-1.3277 0-0.4985-8e-4 -0.9526-0.0568-1.4006-0.0421-0.3372 0.1971-0.6448 0.5343-0.687zm-9.0929 2.0875c0 1.0196-0.8266 1.8462-1.8462 1.8462-1.0196 0-1.8461-0.8266-1.8461-1.8462s0.8265-1.8461 1.8461-1.8461c1.0196 0 1.8462 0.8265 1.8462 1.8461z"/></svg>',
  'podcasting:fountain' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0Z"/><path d="M8.82 21.87c.14-.17.13-.23-.1-.76a6.83 6.83 0 0 1-.38-3.22 6.26 6.26 0 0 1 .89-3.15 2.59 2.59 0 0 1 .42-.51A1.57 1.57 0 0 1 11.2 14a5.2 5.2 0 0 0 2.43.33 4.33 4.33 0 0 0 2.73-1.18 2.11 2.11 0 0 0 .45-2.67 3.17 3.17 0 0 0-2.18-1.59 8.69 8.69 0 0 0-2.57-.11 6.35 6.35 0 0 0-5.22 5.38A11.6 11.6 0 0 0 7.65 21c.33.67.63 1 .9 1a.28.28 0 0 0 .27-.13ZM8 10.25a7.17 7.17 0 0 1 1.52-1.4c.47-.31.48-.32.68-.72a1.47 1.47 0 0 1 1.37-1 1.44 1.44 0 0 1 .74.1 5.09 5.09 0 0 0 1.32.36 3.71 3.71 0 0 0 3-1.15 2 2 0 0 0 .71-1.8 3.2 3.2 0 0 0-2.71-2.54 5.37 5.37 0 0 0-4.92 1.68 7.67 7.67 0 0 0-2 4.94 9.12 9.12 0 0 0 .07 1.71.83.83 0 0 0 .22-.18Z"/></svg>',
  'podcasting:fyyd' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path fill-rule="evenodd" d="M2,12A10,10,0,1,1,12,22,10,10,0,0,1,2,12Zm8.16,6.5a.85.85,0,0,0,1.18,0l5.91-5.91a.83.83,0,0,0,0-1.17L11.34,5.5a.85.85,0,0,0-1.18,0L8.84,6.83A.82.82,0,0,0,8.84,8l4,4-4,4a.82.82,0,0,0,0,1.17Z"/></svg>',
  'podcasting:gpodder' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0Z"/><path d="M9.94 20.23c-1.36 0-2.9-.06-3.42-.11s-1.26-.12-1.63-.21a11.65 11.65 0 0 1-1.4-.37 3.84 3.84 0 0 1-1.11-.61L2 18.57v-1a2.79 2.79 0 0 1 .24-1.3 1.32 1.32 0 0 1 .48-.41 5.84 5.84 0 0 1 1.93.14 25.59 25.59 0 0 0 2.76.24A6.54 6.54 0 0 0 9 16.08a1.71 1.71 0 0 0 .66-.45.85.85 0 0 0 .14-.77c-.07-.42-.11-.46-.32-.39a5.71 5.71 0 0 1-.67.13 1.72 1.72 0 0 1-.76-.08 2.43 2.43 0 0 1-.72-.59 3.92 3.92 0 0 1-.55-.93l-.19-.5-.76.08a3.78 3.78 0 0 1-.77 0s-.1-.87-.22-1.89a12 12 0 0 1-.14-1.91 1 1 0 0 1 .41-.11c.34 0 .34 0 .41-.92a4.19 4.19 0 0 1 .53-1.81 5 5 0 0 1 1.19-1.61 6.73 6.73 0 0 1 1.55-1.07 7.92 7.92 0 0 1 1.41-.51 8.21 8.21 0 0 1 1.4-.12 7.43 7.43 0 0 1 1.48.17 8.11 8.11 0 0 1 1.4.53 6.12 6.12 0 0 1 1.42 1 5.52 5.52 0 0 1 1 1.4 7.26 7.26 0 0 1 .41 1.08c.07.33.12.37.45.37s.38 0 .44.42c0 .23.11.93.18 1.54l.17 1.55c.05.4 0 .42-.26.42a1 1 0 0 0-.39.06.72.72 0 0 0 .06.42 1.88 1.88 0 0 0 .28.55 1.23 1.23 0 0 0 .52.3c.19.06.74.19 1.21.29a2.39 2.39 0 0 1 1.43.69 2.08 2.08 0 0 1 .57.66.24.24 0 0 1-.15.2c-.09 0-.33-.11-.54-.33a3.14 3.14 0 0 0-.66-.54 5.49 5.49 0 0 0-1-.28 5.7 5.7 0 0 1-1.2-.34 1.82 1.82 0 0 1-.64-.59 3 3 0 0 1-.29-.68c0-.22-.14-.3-.27-.28s-.22.2-.27.54a5.52 5.52 0 0 1-.27.95 4.19 4.19 0 0 1-.46.83 2.67 2.67 0 0 1-.64.58 1.59 1.59 0 0 1-.71.22c-.32 0-.37 0-.37.27a1.08 1.08 0 0 0 .27.59c.22.25.37.31 1 .35a7.93 7.93 0 0 0 1.51-.08 19.2 19.2 0 0 0 1.92-.46 8.55 8.55 0 0 1 1.41-.33 1.64 1.64 0 0 1 .49.07.87.87 0 0 1 .35.38 3.22 3.22 0 0 1 .16 1.19 2.88 2.88 0 0 1-.23 1.35 2.91 2.91 0 0 1-.67.82 5.07 5.07 0 0 1-1 .6 8.6 8.6 0 0 1-1.38.45c-.43.1-1.19.23-1.68.29s-1.63.17-2.53.23-2.73.11-4.09.1Zm-1.26-6a1.12 1.12 0 0 0 .81-.36 4.18 4.18 0 0 0 .68-.82 7.2 7.2 0 0 0 .5-1.35 8.26 8.26 0 0 0 .22-1.78 8.76 8.76 0 0 0-.17-1.62 6.06 6.06 0 0 0-.38-1.12 2.68 2.68 0 0 0-.48-.66 1.83 1.83 0 0 0-.57-.36.81.81 0 0 0-.61 0 2.26 2.26 0 0 0-.63.41 3.76 3.76 0 0 0-.59.84A7.46 7.46 0 0 0 7 8.61a8.13 8.13 0 0 0-.19 1.82 5.42 5.42 0 0 0 .26 2 3 3 0 0 0 .74 1.32c.38.4.54.49.87.49ZM9 12.39a1 1 0 0 1-.65-.33.92.92 0 0 1-.35-.73 2 2 0 0 1 .17-.74 1.39 1.39 0 0 1 .52-.5.73.73 0 0 1 .7-.09 1 1 0 0 1 .55.45 1.6 1.6 0 0 1 .17.61 1.7 1.7 0 0 1-.17.62 1.72 1.72 0 0 1-.42.5 1.23 1.23 0 0 1-.52.21Zm6 1.51a1.45 1.45 0 0 0 .64-.35 2.77 2.77 0 0 0 .53-.81 8.12 8.12 0 0 0 .36-1.29 7.17 7.17 0 0 0 .06-1.61 10 10 0 0 0-.36-1.72 5.16 5.16 0 0 0-.64-1.35 4.14 4.14 0 0 0-.67-.7 1.32 1.32 0 0 0-.68-.23 1.49 1.49 0 0 0-.69.2 2.71 2.71 0 0 0-.65.94 3.9 3.9 0 0 0-.4 2 5.84 5.84 0 0 0 .2 2.17 9 9 0 0 0 .45 1.3 5.19 5.19 0 0 0 .53.79 2.36 2.36 0 0 0 .65.52 1.43 1.43 0 0 0 .67.09Zm-.41-1.56c-.23.06-.36 0-.59-.21a1 1 0 0 1-.28-.84 1.54 1.54 0 0 1 .25-.93 1.48 1.48 0 0 1 .56-.49 1.09 1.09 0 0 1 .62 0 .74.74 0 0 1 .44.52 1.44 1.44 0 0 1 0 .85 1.86 1.86 0 0 1-.42.74 1.66 1.66 0 0 1-.6.36Zm-8.2-3.76c.06 0 .19-.27.3-.59a6.37 6.37 0 0 1 .45-1 4 4 0 0 1 .71-.86 2.09 2.09 0 0 1 .84-.48 1.8 1.8 0 0 1 .61 0c.19.06.27 0 .56-.66a2.07 2.07 0 0 1 .72-.99 1.5 1.5 0 0 1 .66-.23 1.51 1.51 0 0 1 .67.25 3.39 3.39 0 0 1 .77 1l.4.74.39-.22a1.39 1.39 0 0 1 .88-.16 1.7 1.7 0 0 1 .9.38 4.54 4.54 0 0 1 .76.85 6.61 6.61 0 0 1 .41.66c0 .08.08.12.11.09a1.46 1.46 0 0 0-.13-.65 5.91 5.91 0 0 0-.58-1.15 5.39 5.39 0 0 0-1-1.06 6.85 6.85 0 0 0-1.29-.74 5.2 5.2 0 0 0-1.67-.3 4.62 4.62 0 0 0-1.67.14 8.36 8.36 0 0 0-1.22.47 6.14 6.14 0 0 0-1.14.84 5.36 5.36 0 0 0-.92 1.19 5.09 5.09 0 0 0-.46 1.24 5.87 5.87 0 0 0-.13.92c0 .19 0 .34.1.34Z"/></svg>',
  'podcasting:ivoox' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M12,2.07a10,10,0,0,0-1.62,19.86c0-2.77,0-6.41,0-9,0-.29,0-.29-.28-.29H7.69c-.17,0-.22-.05-.22-.22q0-1.38,0-2.76c0-.17,0-.23.22-.23,1.6,0,3.21,0,4.82,0a1.64,1.64,0,0,1,.7.22,1.05,1.05,0,0,1,.47,1c0,1.29,0,2.56,0,3.83v7.44A10,10,0,0,0,12,2.07ZM11.91,8.7h-.07a1.76,1.76,0,0,1-1.73-1.82,1.8,1.8,0,0,1,1.83-1.81,1.82,1.82,0,0,1,0,3.63Z"/></svg>',
  'podcasting:listennotes' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M22.48,21.2a3.61,3.61,0,0,0-.34-.84,7.94,7.94,0,0,0-.84-1.29A13.12,13.12,0,0,0,19,16.81a9.68,9.68,0,0,0-1.46-1l0,0a8.34,8.34,0,0,0,.4-9.31,8.65,8.65,0,0,0-.67-.92A8.32,8.32,0,1,0,4.44,16.21a8.13,8.13,0,0,0,5.32,2.92,8.24,8.24,0,0,0,6.11-1.61.05.05,0,0,0,0,0,9.88,9.88,0,0,0,.91,1.31,13.73,13.73,0,0,0,2,2,10.41,10.41,0,0,0,1.42,1,5.15,5.15,0,0,0,1,.44,1.79,1.79,0,0,0,.69.08.71.71,0,0,0,.37-.12.64.64,0,0,0,.26-.5A1.67,1.67,0,0,0,22.48,21.2ZM10.84,17.46a6.58,6.58,0,0,1,0-13.16h0a6.58,6.58,0,0,1,0,13.16ZM7.62,6.31a7.29,7.29,0,0,1,3,.62,7.77,7.77,0,0,1,4.7,7.17H14.12V14a6.54,6.54,0,0,0-2.86-5.36,6.12,6.12,0,0,0-2.08-.94,5.36,5.36,0,0,0-.89-.16l-.57,0h-.1Zm5.57,8H12a4.39,4.39,0,0,0-1.36-3.18,4.49,4.49,0,0,0-3.2-1.31V8.59a5.8,5.8,0,0,1,5,2.86A5.5,5.5,0,0,1,13.19,14.3ZM7.42,11.71V10.59a3.67,3.67,0,0,1,3.23,1.94,3.42,3.42,0,0,1,.4,1.66H9.94a2.43,2.43,0,0,0-.75-1.76A2.45,2.45,0,0,0,7.42,11.71Zm1.69,2A1.06,1.06,0,1,1,8,12.68a1,1,0,0,1,1.07,1.05Z"/></svg>',
  'podcasting:overcast' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path fill-rule="evenodd" d="M12,22a10,10,0,1,1,.08,0Zm0-3.94.72-.73L12,14.44l-.72,2.89ZM11.06,18l-.39,1.44.89-.88Zm1.88,0-.5.5.89.89Zm.72,2.56L12,18.89l-1.67,1.67a8.51,8.51,0,0,0,1.67.16,5.92,5.92,0,0,0,1.67-.16ZM12,3.22A8.8,8.8,0,0,0,3.22,12a8.65,8.65,0,0,0,5.89,8.22L11,13.28A1.53,1.53,0,0,1,10.33,12,1.67,1.67,0,0,1,12,10.28a1.64,1.64,0,0,1,1.67,1.61v0A1.76,1.76,0,0,1,13,13.28l1.89,6.94A8.71,8.71,0,0,0,20.78,12,8.8,8.8,0,0,0,12,3.22Zm5.72,13.11a.61.61,0,0,1-.89.11.57.57,0,0,1-.11-.83,6.43,6.43,0,0,0,0-7.22.57.57,0,0,1,.11-.83.66.66,0,0,1,.89.11A7,7,0,0,1,19.11,12,7.28,7.28,0,0,1,17.72,16.33Zm-3.06-1.61a.68.68,0,0,1,.06-.94A2.79,2.79,0,0,0,15.33,12a3.2,3.2,0,0,0-.61-1.78.67.67,0,0,1-.05-.94.61.61,0,0,1,.87-.06h0a4.19,4.19,0,0,1,0,5.55.69.69,0,0,1-.89-.06Zm-5.33,0a.63.63,0,0,1-.88.07h0A4.07,4.07,0,0,1,7.38,12,4.19,4.19,0,0,1,8.44,9.22a.62.62,0,0,1,.89.06.68.68,0,0,1-.06.94,2.89,2.89,0,0,0,0,3.55.68.68,0,0,1,.06,1ZM7.16,16.44a.67.67,0,0,1-.89-.11A7,7,0,0,1,4.89,12,7.15,7.15,0,0,1,6.27,7.67a.62.62,0,0,1,.89-.12.55.55,0,0,1,.11.83,6.43,6.43,0,0,0,0,7.22.56.56,0,0,1,0,.79l-.06.05Z"/></svg>',
  'podcasting:playerfm' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M11.4,22A9.4,9.4,0,0,1,9.17,3.48,2,2,0,0,1,11.62,5a2,2,0,0,1-1.5,2.44A5.37,5.37,0,0,0,11.4,18h0a5.36,5.36,0,0,0,5.23-4.12,2,2,0,0,1,3.95.95A9.47,9.47,0,0,1,11.4,22Zm9.74-11.24a.84.84,0,0,1-.84-.61,10.1,10.1,0,0,0-6.4-6.51A.84.84,0,1,1,14.36,2h.05A11.81,11.81,0,0,1,22,9.66a.86.86,0,0,1-.56,1.06A.5.5,0,0,1,21.14,10.77Zm-2.78.56a.85.85,0,0,1-.84-.61,7.38,7.38,0,0,0-4.17-4.34.85.85,0,0,1,.51-1.62,8.61,8.61,0,0,1,5.28,5.45.86.86,0,0,1-.56,1.06C18.52,11.27,18.41,11.33,18.36,11.33Zm-2.84.33a.82.82,0,0,1-.78-.5,4.61,4.61,0,0,0-2-2.06.87.87,0,1,1,.78-1.56h0a6.77,6.77,0,0,1,2.78,2.9A.8.8,0,0,1,16,11.53l0,0A.76.76,0,0,1,15.52,11.66Z"/></svg>',
  'podcasting:plink' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0Z"/><path d="M12 2a10 10 0 1 0 10 10A10 10 0 0 0 12 2Zm0 18a8 8 0 1 1 8-8 8 8 0 0 1-8 8Z"/><path d="M12 5.23A6.75 6.75 0 1 0 18.75 12 6.75 6.75 0 0 0 12 5.23Zm1.63 11V14.8a3.24 3.24 0 1 0-4.73-3.72l-1.35.39a4.49 4.49 0 1 1 6.08 4.71Z"/></svg>',
  'podcasting:pocketcasts' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path fill-rule="evenodd" d="M2,12a10,10,0,0,1,20,0H19.5A7.5,7.5,0,1,0,12,19.5V22A10,10,0,0,1,2,12Zm10,6a6,6,0,1,1,6-6H15.83A3.83,3.83,0,1,0,12,15.83h0Z"/></svg>',
  'podcasting:podbean' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M11.79,4.1a10.58,10.58,0,0,1,1.69.08,10.85,10.85,0,0,1,1.38.27,12.06,12.06,0,0,1,2,.68A11.42,11.42,0,0,1,19,6.4,10.4,10.4,0,0,1,20,7.31c.2.2.41.4.61.61a11.51,11.51,0,0,1,1.23,1.64A1.36,1.36,0,0,1,22,10a1.25,1.25,0,0,1-.43,1,1.16,1.16,0,0,1-.67.26A1.14,1.14,0,0,1,20,11a5.65,5.65,0,0,1-.56-.73A9.11,9.11,0,0,0,17.12,8a10,10,0,0,0-1.4-.77c-.18-.08-.37-.14-.55-.21a6.54,6.54,0,0,0-1.31-.37,8.88,8.88,0,0,0-1.78-.18,8.27,8.27,0,0,0-1.79.14A9.52,9.52,0,0,0,8.9,7a9.33,9.33,0,0,0-4.12,2.9c-.19.25-.38.49-.54.75a1.72,1.72,0,0,1-.36.4,1.14,1.14,0,0,1-.44.18,1.51,1.51,0,0,1-.56,0,1.14,1.14,0,0,1-.7-.52,1.21,1.21,0,0,1-.11-1,2,2,0,0,1,.17-.32A11.7,11.7,0,0,1,6.36,5.54a12.77,12.77,0,0,1,2.12-.91A12,12,0,0,1,11.79,4.1Zm.12,4.3a7.24,7.24,0,0,1,5.21,2.1,6.88,6.88,0,0,1,1.05,1.3,1.27,1.27,0,0,1,.09,1,1.24,1.24,0,0,1-.65.68,1.2,1.2,0,0,1-1.21-.16,1.34,1.34,0,0,1-.31-.36,6.31,6.31,0,0,0-.71-.84A4.85,4.85,0,0,0,13,10.89a6.09,6.09,0,0,0-1.13-.1,4.91,4.91,0,0,0-2.7.88,5.55,5.55,0,0,0-.94.87c-.19.23-.34.49-.54.71a1.2,1.2,0,0,1-1.69,0,1.13,1.13,0,0,1-.29-.51,1.06,1.06,0,0,1,0-.61,1.86,1.86,0,0,1,.23-.47,9.71,9.71,0,0,1,.86-1.06A7.92,7.92,0,0,1,8,9.57a7.16,7.16,0,0,1,1.38-.7A7.33,7.33,0,0,1,11.91,8.4Zm-.09,4.65a3.7,3.7,0,0,1,3.89,3.42,5.13,5.13,0,0,1,0,1,3.92,3.92,0,0,1-1.19,2.12,3.74,3.74,0,0,1-1.76.89,4,4,0,0,1-1.25,0A3.88,3.88,0,0,1,10.16,20a4.32,4.32,0,0,1-1.1-.94,5.11,5.11,0,0,1-.57-1,3.76,3.76,0,0,1,1.39-4.36,3.59,3.59,0,0,1,1.94-.66m0,1.77a3.21,3.21,0,0,0-.63.14,2.77,2.77,0,0,0-.6.41,2,2,0,0,0-.47,2.09,2.12,2.12,0,0,0,.61.86,2.61,2.61,0,0,0,.77.37,3.08,3.08,0,0,0,.68,0,1.7,1.7,0,0,0,.9-.33,1.93,1.93,0,0,0,.82-1.29A2.21,2.21,0,0,0,13.81,16a2.57,2.57,0,0,0-.34-.54,2,2,0,0,0-1.61-.65Z"/></svg>',
  'podcasting:podcastaddict' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M22,11.77A10,10,0,1,0,7.3,20.83V12a4.76,4.76,0,0,1,3.86-4.66V9a3.12,3.12,0,0,0-2.24,3v0h0a3.13,3.13,0,0,0,6.13.85h1.66a4.74,4.74,0,0,1-5.56,3.76,4.59,4.59,0,0,1-2.23-1.09v6A10.33,10.33,0,0,0,12,22a10,10,0,0,0,5.61-1.72V22H22Zm-9.95,2a1.83,1.83,0,1,1,1.82-1.83h0a1.81,1.81,0,0,1-1.81,1.82ZM16.79,12H15.18a3.13,3.13,0,0,0-3.13-3.13h0V7.2h0A4.75,4.75,0,0,1,16.79,12h0Zm2.78,0H18A5.93,5.93,0,0,0,12.05,6h0V4.42h0A7.53,7.53,0,0,1,19.57,12Z"/></svg>',
  'podcasting:podcastguru' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0Z"/><path fill-rule="evenodd" d="M22 12.05a9.28 9.28 0 0 0-2.74-2.85 6.78 6.78 0 0 0-.19-4.2 9.45 9.45 0 0 0-4-.07A6.71 6.71 0 0 0 12 2.05a9.39 9.39 0 0 0-2.85 2.74A6.74 6.74 0 0 0 4.93 5a9.34 9.34 0 0 0-.07 4A6.67 6.67 0 0 0 2 12.05a9.34 9.34 0 0 0 2.74 2.84 6.78 6.78 0 0 0 .19 4.23 9.45 9.45 0 0 0 4 .07A6.77 6.77 0 0 0 12 22.05a9.53 9.53 0 0 0 2.85-2.75 6.74 6.74 0 0 0 4.22-.18 9.34 9.34 0 0 0 .07-4A6.69 6.69 0 0 0 22 12.05ZM9.73 7.86a2.25 2.25 0 1 1 4.5 0v1.91h-4.5Zm0 2.64h4.5v1.91a2.25 2.25 0 0 1-4.5 0Zm6.14 1.94a3.88 3.88 0 0 1-3.52 3.86v2.06a.36.36 0 1 1-.72 0V16.3a3.87 3.87 0 0 1-3.51-3.86v-1.19a.36.36 0 0 1 .72 0v1.19A3.16 3.16 0 0 0 12 15.6a3.16 3.16 0 0 0 3.15-3.16v-1.19a.37.37 0 0 1 .73 0Z"/></svg>',
  'podcasting:podcastindex' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0Z"/><path d="M7.53 12.59a5 5 0 0 1 0-7.36 1 1 0 0 1 1.35 1.45 3 3 0 0 0 0 4.48 1 1 0 0 1 0 1.39 1 1 0 0 1-1.35.04ZM6.83 14A.89.89 0 0 1 7 15.42a.92.92 0 0 1-.8.39 1.42 1.42 0 0 1-.6-.2 8.88 8.88 0 0 1-3.39-6.7A7.92 7.92 0 0 1 5.63 2.2 1 1 0 0 1 7 2.4a1 1 0 0 1-.2 1.38 6.23 6.23 0 0 0-2.56 5.13A6.34 6.34 0 0 0 6.83 14Zm8.23-1.48a1 1 0 0 1 0-1.4 3 3 0 0 0 0-4.48 1 1 0 0 1 0-1.39 1 1 0 0 1 1.41 0 5 5 0 0 1 0 7.36 1 1 0 0 1-1.41-.06ZM18.37 2.2a7.94 7.94 0 0 1 3.39 6.71 8.29 8.29 0 0 1-3.39 6.7 1.42 1.42 0 0 1-.6.2.92.92 0 0 1-.8-.39.89.89 0 0 1 .2-1.39 6.34 6.34 0 0 0 2.59-5.12 6.23 6.23 0 0 0-2.59-5.13A1 1 0 0 1 17 2.4a1 1 0 0 1 1.37-.2Zm-4.23 6.7a2.14 2.14 0 1 0-3.29 1.81L8.43 22h2.1l2.4-11.17a2.14 2.14 0 0 0 1.21-1.93Z"/></svg>',
  'podcasting:podchaser' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18.63a8.81,8.81,0,0,1-2.78-.46V17.94a6.39,6.39,0,1,0-3.61-5.76v5.61A8.61,8.61,0,1,1,12,20.63Z"/></svg>',
  'podcasting:podcloud' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M19.42,11.07c0-.08,0-.16,0-.24a4.92,4.92,0,0,0-9.28-2.3,3.87,3.87,0,0,0-.77-.08A3.56,3.56,0,0,0,6,11l-.4,0a3.57,3.57,0,0,0,0,7.14H18.41a3.59,3.59,0,0,0,1-7Zm-6.77,6.71c-1,0-1.76-1.16-1.76-2.24,0-1.28.48-1.28,1.69-1.28s1.83,0,1.83,1.28C14.41,16.62,13.62,17.78,12.65,17.78Zm-1.18-5.3a1.17,1.17,0,1,1,1.17,1.17A1.17,1.17,0,0,1,11.47,12.48Zm2.85,1.33a2.07,2.07,0,0,0,.47-1.33,2.15,2.15,0,1,0-3.86,1.3,1,1,0,0,0-.35.25,2.58,2.58,0,1,1,4.09,0A.9.9,0,0,0,14.32,13.81ZM15,15.89a4.38,4.38,0,0,0,0-.51,2.62,2.62,0,0,0,0-.29,3.53,3.53,0,1,0-4.75,0c0,.09,0,.18,0,.28a3.05,3.05,0,0,0,.05.52,4.14,4.14,0,1,1,4.68,0Z"/></svg>',
  'podcasting:podfriend' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M2.46,15.14l.07.48a7.24,7.24,0,0,0,1.56,3.22C5.29,20.28,7.63,22,12,22s6.71-1.72,7.9-3.16a7.2,7.2,0,0,0,1.57-3.22l.07-.48Zm9.54,6a10.56,10.56,0,0,1-5.34-1.24,9.09,9.09,0,0,1,.3-1.1,5.35,5.35,0,0,1,.78-1.45A5.06,5.06,0,0,1,9.54,16H13l0,0A6,6,0,0,0,11.8,19h0c0,.18,0,.41.14.49a.33.33,0,0,0,.37-.1,1,1,0,0,0,.17-.37,7.32,7.32,0,0,1,1.88-3h6.17C20.11,17.34,18.35,21.17,12,21.17ZM20.24,9.49h0c0-.39-.76-7.41-8.18-7.49h-.12C4.53,2.08,3.8,9.09,3.76,9.49c0,.19-.28,2.38.77,3.58a2.24,2.24,0,0,0,1.78.76H17.69a2.24,2.24,0,0,0,1.78-.76C20.52,11.87,20.26,9.68,20.24,9.49Zm-7.6-1.57a1.25,1.25,0,1,1,1.25,1.24A1.25,1.25,0,0,1,12.64,7.92Zm6.21,4.6h0a1.45,1.45,0,0,1-1.16.48H14A4.35,4.35,0,1,0,10,13H6.31a1.45,1.45,0,0,1-1.16-.48c-.82-.94-.57-2.91-.57-2.93v0c0-.27.55-6.69,7.41-6.73s7.39,6.46,7.41,6.73v0A4.39,4.39,0,0,1,18.85,12.52Z"/></svg>',
  'podcasting:podinstall' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M22,9.69C21.74,8,21.37,7.38,18.94,5s-3-2.78-4.5-3.07c-.45-.09-3-.13-5.23-.13H4.43v17.5l.07.07,1.43,1.43,1.42,1.43.07.07h6.36V16.67H15a17.15,17.15,0,0,0,2.2-.13A6.08,6.08,0,0,0,22,9.69ZM7.22,19.46v1.26l-.66-.65L6,19.46Zm0-14.27V18.48H5.42V3.39Zm.65-.65L6.08,2.74H10v1.8ZM8.2,18.48v-13H10v13Zm0,2.79V19.46h2.14l1.07,1.08.73.73ZM11,12.9V5.52H12.8V12.9Zm1.81,1v3.5c0,1.44,0,2.57,0,3.2L12,19.85,11,18.8V13.89ZM11,4.54V3.4l.55.54.59.59H11Zm7,5.13a5.32,5.32,0,0,1-2.89,2.89,5.61,5.61,0,0,1-1.13.3l-.24,0V5.52h1.49a9.07,9.07,0,0,1,2.27.18l.49.14.17.64A5.86,5.86,0,0,1,18,9.67Zm-4.26,4.19.25,0a7.76,7.76,0,0,0,2.56-1,6.1,6.1,0,0,0,2.66-6c0-.12,0-.24-.06-.34.12.1.25.23.4.37a5.46,5.46,0,0,1,1.14,1.55,3.41,3.41,0,0,1,.37,2.06,4.39,4.39,0,0,1-.26,1.9,5.42,5.42,0,0,1-2.92,2.92,6.39,6.39,0,0,1-2.49.29l-1.65.05Zm3.39-9.19A15.74,15.74,0,0,0,15,4.55H13.45L11.66,2.73l1.2,0c1.65,0,1.81.06,2.43.35a5.66,5.66,0,0,1,2,1.59h0Z"/></svg>',
  'podcasting:podlink' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M2.49,10.51a.27.27,0,0,1,.37-.09l2.63,1.66a.27.27,0,0,1,.08.38.26.26,0,0,1-.22.12.28.28,0,0,1-.15,0L2.57,10.88A.27.27,0,0,1,2.49,10.51Zm3.61,1a.28.28,0,0,0,.23.13.23.23,0,0,0,.14,0,.27.27,0,0,0,.1-.37L5.32,9.14A.27.27,0,0,0,5,9.05a.28.28,0,0,0-.1.37ZM4.92,14a.28.28,0,0,0,.27-.24.27.27,0,0,0-.23-.3l-2.41-.33a.27.27,0,1,0-.08.53L4.88,14ZM21.6,6.89h0a.71.71,0,0,0-1-.09h0l-4.1,3.42L13.46,5.09a1.49,1.49,0,0,0-1-.73V1.89a.27.27,0,0,0-.54,0V4.34a1.5,1.5,0,0,0-1.1.75h0l-7,13.81a.73.73,0,0,0,1.26.72h0l7-13.78a.09.09,0,0,1,.09,0h0a.12.12,0,0,1,.09,0h0l3.13,5.3h0L9.91,15.71h0a.69.69,0,0,0,.88,1.07l5.31-4.42,3.3,5.58a.11.11,0,0,1-.1.16h0L5.34,20.24a.69.69,0,0,0-.68.69.7.7,0,0,0,.7.69h0l14-2.13a1.53,1.53,0,0,0,1.3-2.29h0l-3.44-5.77,4.28-3.55h0A.71.71,0,0,0,21.6,6.89Z"/></svg>',
  'podcasting:podlp' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0Z"/><path d="M12 2a10 10 0 1 0 10 10A10 10 0 0 0 12 2Zm.07 11.5a1.5 1.5 0 1 1 1.5-1.5 1.5 1.5 0 0 1-1.5 1.5Zm5.34-.5h-1.55a4.09 4.09 0 0 0 .14-1 4 4 0 0 0-4-4 3.75 3.75 0 0 0-.95.13V6.59A5 5 0 0 1 12 6.5a5.5 5.5 0 0 1 5.5 5.5 6.52 6.52 0 0 1-.09 1Zm1.51 0a6.63 6.63 0 0 0 .08-1 7 7 0 0 0-7-7 7.45 7.45 0 0 0-.95.07V3.56A7.46 7.46 0 0 1 12 3.5a8.51 8.51 0 0 1 8.5 8.5 8.26 8.26 0 0 1-.06 1Z"/></svg>',
  'podcasting:podnews' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0z"/><path d="M12 2C8.7 2 6 4.7 6 8v9.3h2.3V8a3.71 3.71 0 0 1 7-1.7c-.1-.1-.3-.1-.5-.1-.6 0-.9.4-.9.9V9c0 .6.4.9.9.9.2 0 .4 0 .5-.1-.6 1.2-1.9 2-3.3 2-.5 0-1-.1-1.4-.3V18c0 .8.6 1.4 1.4 1.4.8 0 1.4-.6 1.4-1.4v-.7c0-.5.4-.9.9-.9s.9.4.9.9v3.3c0 .8.6 1.4 1.4 1.4.8 0 1.4-.6 1.4-1.4V8c0-3.3-2.7-6-6-6Z"/></svg>',
  'podcasting:podtail' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0Z"/><path d="M20.47 16.9a2.14 2.14 0 0 0-2-.38c-.87.23-1.36 1.13-1.86 2.09C16 19.77 15.32 21 14 21c-1.11 0-2.25-.32-2.25-2.72v-.38h1.81c.23 0 .4-.23.4-.52s-.17-.53-.4-.53h-1.8v-1.68A3.35 3.35 0 0 0 15 11.83V5.36A3.35 3.35 0 0 0 11.68 2h-.8a3.34 3.34 0 0 0-3.34 3.36v4.78H6.8a.53.53 0 1 0 0 1h.74v.65a3.34 3.34 0 0 0 3.16 3.33v1.68H9c-.22 0-.4.24-.4.53a.47.47 0 0 0 .4.52h1.69v.38c0 2.49 1.1 3.74 3.27 3.74 1.95 0 2.81-1.62 3.5-2.92.4-.75.78-1.47 1.23-1.58a1.06 1.06 0 0 1 1.16.23.58.58 0 0 0 .36.15.47.47 0 0 0 .5-.48.66.66 0 0 0-.24-.47ZM8.58 9.34h1.77a.53.53 0 0 0 .53-.53.52.52 0 0 0-.52-.52H8.58v-.64h1.77a.53.53 0 1 0 0-1.05H8.58V6h1.67a.53.53 0 0 0 .53-.53.52.52 0 0 0-.53-.52H8.62a2.31 2.31 0 0 1 2.26-1.87h.81A2.31 2.31 0 0 1 14 4.92h-1.81a.52.52 0 0 0-.52.52.53.53 0 0 0 .52.53H14v.64h-1.7a.53.53 0 1 0 0 1H14v.69h-1.7a.53.53 0 1 0 0 1H14v.8H8.58v-.76Zm2.3 4.78a2.3 2.3 0 0 1-2.3-2.29v-.65H14v.65a2.3 2.3 0 0 1-2.3 2.29Z"/></svg>',
  'podcasting:podverse' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M7.12,21.73a4.62,4.62,0,0,1-2.46-2.49,10.13,10.13,0,0,0-.85-1.63,10,10,0,1,1,16.4,0,9.39,9.39,0,0,0-.85,1.63,4.5,4.5,0,0,1-2.52,2.49A2.48,2.48,0,0,1,16,22a65.25,65.25,0,0,1,2.21-7.53,1.55,1.55,0,0,1,.59.46,2.13,2.13,0,0,0,.52.46,3.71,3.71,0,0,0,.42-1,7.37,7.37,0,0,0,.24-2.76,5.78,5.78,0,0,0-.76-3.12,8,8,0,0,0-14.34,0,5.79,5.79,0,0,0-.77,3.12,7.56,7.56,0,0,0,.25,2.76,3.71,3.71,0,0,0,.42,1,2.34,2.34,0,0,0,.52-.46,1.49,1.49,0,0,1,.6-.46,10.94,10.94,0,0,1,.84,2.45c.37,1.35.84,3,1,3.71A3.32,3.32,0,0,1,8,21.9a2,2,0,0,1-.84-.17Zm1.41-.3c-.1-.34-.62-2.19-1.17-4.11-.83-3-1-3.51-.72-3.65a1.35,1.35,0,0,1,1.54.16A54.67,54.67,0,0,1,10.34,21c0,.32-.58.78-1.14.92s-.52.06-.67-.49Zm5.84.37a1,1,0,0,1-.62-.61,33.68,33.68,0,0,1,2-7.26,1.14,1.14,0,0,1,.85-.44c1.11,0,1.11,0-.15,4.43A23.9,23.9,0,0,1,15.09,22a4.11,4.11,0,0,1-.72-.2Z"/></svg>',
  'podcasting:radiopublic' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path fill-rule="evenodd" d="M15.52,12.63V9.58l.37-.08c.46-.11.51.13.51.52v1.8c0,.33,0,.62-.51.73ZM7.65,9.85V7.12L8.09,7c.4-.09.49,0,.49.5V9c0,.51-.15.69-.55.78Zm5.89-4.47V2.48C9.92.82,6.3,4.14,2.68,2.48V19.06c2.64,1.21,5.27-.22,7.91-.44v2.9c3.58,1.66,7.15-1.66,10.73,0V4.94C18.73,3.74,16.14,5.14,13.54,5.38Zm-2.8,10.31a13.18,13.18,0,0,0-2,.32c-.1-.1-.18-.31-.18-.79V12.06c0-.5-.12-.61-.52-.52l-.41.1v4.62a16.38,16.38,0,0,1-2,.34V5.79a24.5,24.5,0,0,0,3.12-.6c1.21-.27,1.81.35,1.81,1.5V8.42A1.72,1.72,0,0,1,9.73,10a1.09,1.09,0,0,1,.84,1.17v3.67a1.36,1.36,0,0,0,.17.79Zm7.65-4a2.26,2.26,0,0,1-1.93,2.51l-.94.22v4.33a14.75,14.75,0,0,1-2,.34V8.26a23.56,23.56,0,0,0,2.81-.54c1.68-.38,2,.46,2,1.78Z"/></svg>',
  'podcasting:sphinxchat' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0Z"/><path d="M10.36 21.54a.92.92 0 0 0 .22-.22l.08-.13V18.8a10.27 10.27 0 0 1 .05-2.37 4.61 4.61 0 0 0 .9.15 5.12 5.12 0 0 0 1.63-.15h.07v4.78l.08.13a.69.69 0 0 0 .48.31 8 8 0 0 0 2-.39 5.61 5.61 0 0 0 2.3-1.36 3.85 3.85 0 0 0 1.15-2.21 4.52 4.52 0 0 1 .41-1.24 5.36 5.36 0 0 1 1.75-2A.93.93 0 0 0 22 14a8.63 8.63 0 0 0-.1-2 10.94 10.94 0 0 0-4.25-7.7 10.37 10.37 0 0 0-4.09-1.81A6.38 6.38 0 0 0 12 2.37a7.87 7.87 0 0 0-2.72.44 10.28 10.28 0 0 0-6 5.19A12.42 12.42 0 0 0 2 13.27c0 .77 0 .84.45 1.15a5.35 5.35 0 0 1 2 2.59c0 .14.12.43.17.66a4.07 4.07 0 0 0 .63 1.6 5.3 5.3 0 0 0 1.1 1.12 7.56 7.56 0 0 0 3.16 1.19c.48.08.68.07.85 0ZM9.15 20.2a5.61 5.61 0 0 1-1.95-.8 2.83 2.83 0 0 1-1.31-1.94c0-.2-.09-.43-.11-.49a6.33 6.33 0 0 0-1.16-2.28 8.56 8.56 0 0 0-1.09-1.08l-.24-.19v-.39A10.39 10.39 0 0 1 5.4 7a5.55 5.55 0 0 1 .67-.73l.54 1 .52 1v1.71a11.37 11.37 0 0 0 .08 2 6 6 0 0 0 1.1 2.62 6 6 0 0 0 .89.92l.16.13v4.48l-.22-.05Zm5.47-2.2v-2.27l.08-.05a6.4 6.4 0 0 0 .75-.74A6.46 6.46 0 0 0 16.73 12a25.43 25.43 0 0 0 .1-2.8v-.83l1.1-2.1.22.23a9.46 9.46 0 0 1 2.1 3.79 13.06 13.06 0 0 1 .45 3v.17l-.24.19a9.18 9.18 0 0 0-1.08 1.08 6.05 6.05 0 0 0-1.27 2.78 2.83 2.83 0 0 1-.87 1.59 5.29 5.29 0 0 1-2.44 1.15h-.18Zm-3.16-2.72a3.2 3.2 0 0 1-1.81-1 4.68 4.68 0 0 1-1.13-2.24 14 14 0 0 1-.11-2.35v-.83h7.12V11.68a5.94 5.94 0 0 1-.34 1.27 3.52 3.52 0 0 1-2.45 2.3 4.23 4.23 0 0 1-1.23 0ZM7.62 6.49l-.56-1.08.12-.09a9.15 9.15 0 0 1 1-.63 9.31 9.31 0 0 1 2.79-1 6.06 6.06 0 0 1 1-.07 5.49 5.49 0 0 1 1.38.13 9.11 9.11 0 0 1 2.53.94 9.21 9.21 0 0 1 1 .64s-.05.2-.53 1.12l-.55 1.12H8.17l-.55-1.08Z"/></svg>',
  'podcasting:spotify' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M17.91,10.87C14.69,9,9.37,8.77,6.3,9.71a.93.93,0,1,1-.54-1.79c3.53-1.08,9.4-.87,13.11,1.34a.93.93,0,1,1-1,1.6h0Zm-.1,2.83a.78.78,0,0,1-1.07.26h0a13.14,13.14,0,0,0-10-1.17.78.78,0,0,1-1-.49.79.79,0,0,1,.5-1h0a14.58,14.58,0,0,1,11.23,1.33.78.78,0,0,1,.26,1.07Zm-1.22,2.72a.63.63,0,0,1-.86.21h0c-2.35-1.44-5.3-1.76-8.79-1a.62.62,0,0,1-.27-1.21c3.81-.87,7.07-.5,9.71,1.11a.63.63,0,0,1,.21.86ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Z"/></svg>',
  'podcasting:spreaker' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M14.82,2,10.11,7.45l-7-1.52,7.23,6.15L3.2,18.29l7-1.65L15,22l.59-7.17,6.6-2.9L15.56,9.16,14.82,2Z"/></svg>',
  'podcasting:truefans' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path d="M8.503 2.111q1.56-.873 3.49-.873 1.931 0 3.491.867a6.32 6.32 0 0 1 2.447 2.393q.885 1.527.885 3.404 0 1.88-.885 3.406a6.32 6.32 0 0 1-2.447 2.393q-1.56.866-3.49.866-1.931 0-3.491-.872a6.338 6.338 0 0 1-2.44-2.393q-.88-1.523-.88-3.399 0-1.876.88-3.399a6.338 6.338 0 0 1 2.44-2.393m6.335 2.87Q13.7 3.842 11.994 3.842T9.16 4.98Q8.028 6.118 8.028 7.903q0 1.785 1.13 2.922 1.132 1.138 2.836 1.138 1.705 0 2.844-1.138 1.138-1.137 1.137-2.922 0-1.785-1.137-2.923M6.333 23.032H3.326a8.367 8.367 0 0 1 2.356-4.52 8.487 8.487 0 0 1 1.797-1.338 8.672 8.672 0 0 1 2.136-.846 10.185 10.185 0 0 1 4.752-.002 8.733 8.733 0 0 1 2.138.84 8.303 8.303 0 0 1 1.799 1.333 8.395 8.395 0 0 1 2.37 4.533h-3.009a5.535 5.535 0 0 0-.55-1.308 5.48 5.48 0 0 0-2.11-2.064c-.893-.496-1.906-.747-3.01-.747s-2.119.253-3.012.753a5.489 5.489 0 0 0-2.104 2.063 5.535 5.535 0 0 0-.546 1.302"/></svg>',
  'podcasting:tsacdop' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0Z"/><path d="M18 5.49 8.84 2.17a4.08 4.08 0 0 0-2.79 7.67l3.32 1.21v8.82a2.06 2.06 0 0 0 4.12 0v-7.33l1.68.61A4.08 4.08 0 0 0 18 5.49Z"/></svg>',
  'podcasting:tunein' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path fill-rule="evenodd" d="M21.5,5.23H12.06a.49.49,0,0,0-.5.49h0V8.32H2.5a.5.5,0,0,0-.5.5H2v9.45a.5.5,0,0,0,.49.5h9.45a.49.49,0,0,0,.5-.49h0v-2.6H21.5a.49.49,0,0,0,.5-.49h0V5.67A.49.49,0,0,0,21.5,5.23Zm-10,12.6H2.94V9.26H11.5Zm6.41-5.36a.11.11,0,0,1-.11.11h-2a.11.11,0,0,1-.11-.11v-.61a.12.12,0,0,1,.11-.11h.5s0,0,0-.05V9.21c0-.06,0-.06,0-.06h-.45A.12.12,0,0,1,15.7,9v-.6a.11.11,0,0,1,.11-.11h1.88a.11.11,0,0,1,.11.11V9a.11.11,0,0,1-.11.11h-.44c-.05,0-.05,0-.05.06V11.7c0,.05,0,.05.05.05h.5a.12.12,0,0,1,.11.11l.06.61Zm-12-.33v-.61A.11.11,0,0,1,6,11.42H8.46a.11.11,0,0,1,.11.11v.61h0a.12.12,0,0,1-.11.11H7.7c-.06,0-.06,0-.06.05v3.26a.11.11,0,0,1-.11.11H6.92a.11.11,0,0,1-.11-.11V12.3c0-.05,0-.05-.06-.05H6A.12.12,0,0,1,5.87,12.14Z"/></svg>',
  'podcasting:youtube-music' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path d="M12 0C5.376 0 0 5.376 0 12s5.376 12 12 12 12-5.376 12-12S18.624 0 12 0zm0 19.104c-3.924 0-7.104-3.18-7.104-7.104S8.076 4.896 12 4.896s7.104 3.18 7.104 7.104-3.18 7.104-7.104 7.104zm0-13.332c-3.432 0-6.228 2.796-6.228 6.228S8.568 18.228 12 18.228s6.228-2.796 6.228-6.228S15.432 5.772 12 5.772zM9.684 15.54V8.46L15.816 12l-6.132 3.54z"/></svg>',
  'podcasting:default' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0z"/><path d="M12 1a5 5 0 0 1 5 5v6a5 5 0 0 1-10 0V6a5 5 0 0 1 5-5zM2.192 13.962l1.962-.393a8.003 8.003 0 0 0 15.692 0l1.962.393C20.896 18.545 16.85 22 12 22s-8.896-3.455-9.808-8.038z"/></svg>',
  'funding:buymeacoffee' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0z"/><path d="m18.755 7.346-.11-.555c-.099-.498-.323-.97-.834-1.15-.164-.057-.35-.081-.475-.2-.127-.12-.163-.305-.192-.477-.054-.315-.104-.63-.16-.944-.048-.27-.085-.575-.209-.823-.162-.333-.497-.528-.83-.656a4.775 4.775 0 0 0-.521-.162c-.834-.219-1.709-.3-2.565-.347a21.528 21.528 0 0 0-3.083.052c-.763.07-1.567.153-2.292.417-.265.096-.538.213-.74.417-.247.252-.327.642-.147.955.128.223.346.38.576.484.3.135.615.236.936.305.896.198 1.825.276 2.74.308 1.014.042 2.03.008 3.041-.098.25-.028.499-.061.747-.1.293-.044.482-.427.395-.694-.103-.32-.38-.443-.695-.395-.388.062-.8.09-1.152.122-.98.067-1.965.068-2.947.005a18.518 18.518 0 0 1-.964-.09 10.513 10.513 0 0 1-.818-.138c-.093-.022-.093-.154 0-.176h.004c.231-.05.464-.09.698-.123h.002c.11-.007.22-.026.328-.04a20.898 20.898 0 0 1 2.856-.1c.561.016 1.122.056 1.68.12l.19.026c.223.033.445.073.665.121.327.07.746.094.892.452.046.114.067.24.093.359l.265 1.237a.198.198 0 0 1-.165.236h-.003l-.093.013c-1.311.167-2.631.25-3.953.246A30.882 30.882 0 0 1 8 5.699c-.116-.014-.244-.035-.347-.05-.272-.04-.541-.09-.811-.134-.328-.054-.64-.027-.936.134-.242.134-.44.337-.562.584-.129.264-.166.55-.223.834-.057.283-.147.589-.112.88.072.627.51 1.137 1.141 1.251 3.12.557 6.303.663 9.453.314a.403.403 0 0 1 .446.441l-.06.581-.848 8.256c-.034.342-.039.694-.104 1.031-.102.531-.46.857-.985.976-.48.11-.97.167-1.463.17-.547.004-1.092-.02-1.639-.017-.582.003-1.296-.05-1.746-.484-.395-.382-.45-.978-.504-1.494l-.609-5.844-.268-2.579c-.031-.292-.239-.579-.565-.565-.28.013-.599.25-.565.566l.19 1.821.79 7.594c.123 1.12.979 1.723 2.039 1.893.618.1 1.252.12 1.88.13.806.013 1.62.044 2.41-.102 1.174-.215 2.055-.998 2.181-2.214.283-2.777.57-5.553.853-8.33l.18-1.739a.403.403 0 0 1 .325-.355c.335-.065.655-.176.895-.431.379-.407.455-.936.32-1.471Zm-1.231.643c-.121.114-.303.168-.482.194-2.013.3-4.055.45-6.09.384-1.457-.05-2.898-.212-4.34-.415-.141-.02-.294-.046-.391-.15-.183-.197-.093-.592-.045-.83.043-.216.127-.507.386-.538.403-.047.871.124 1.271.184.481.073.964.132 1.448.176 2.067.189 4.168.159 6.227-.116.375-.05.749-.109 1.12-.175.333-.06.7-.172.9.171.139.234.157.548.136.812a.453.453 0 0 1-.141.303Zm-5.133 3.25c-.718.309-1.533.657-2.59.657a4.906 4.906 0 0 1-1.308-.18l.73 7.503c.055.65.598 1.15 1.25 1.15 0 0 1.036.054 1.382.054.373 0 1.489-.054 1.489-.054.652 0 1.195-.5 1.249-1.15l.783-8.292a3.328 3.328 0 0 0-1.102-.198c-.688 0-1.242.236-1.883.51Z"/></svg>',
  'funding:donorbox' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path d="M16.455 10.658c0 1.09-.705 2.244-2.098 3.443a13.447 13.447 0 0 1-2.381 1.62 14.102 14.102 0 0 1-2.381-1.629c-1.4-1.2-2.106-2.353-2.106-3.443 0-1.346.887-2.298 2.106-2.298.558 0 .888.054 1.263.238.22.1.412.237.577.403l.541.55.532-.55a2.07 2.07 0 0 1 .586-.421c.366-.166.678-.22 1.254-.22 1.209.018 2.107.988 2.107 2.307Z" clip-rule="evenodd"/><path d="M22 3.915v16.17A1.911 1.911 0 0 1 20.085 22H3.915A1.911 1.911 0 0 1 2 20.085V3.915C2 2.855 2.854 2 3.915 2h8.066c.267 0 .503.107.68.282a.986.986 0 0 1 .281.68v2.807a.962.962 0 0 1-1.922 0V3.923H4.83a.919.919 0 0 0-.916.916v14.346c0 .51.413.915.916.915h14.346a.914.914 0 0 0 .916-.915V4.839a.942.942 0 0 0-.275-.649s-.214-.206-.48-.252c-.032-.008-.07-.008-.07-.008-.03 0-.061-.007-.09-.007h-2.504a.967.967 0 0 1-.96-.962c0-.526.434-.961.96-.961h3.41A1.907 1.907 0 0 1 22 3.915Z"/></svg>',
  'funding:gofundme' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M6.07,14.76a4.78,4.78,0,0,1,.48-.37A2.58,2.58,0,0,1,8.13,14a2.5,2.5,0,0,1,.76.19A2,2,0,0,1,9.7,15c0,.05.06.06.09,0A2,2,0,0,1,11.3,14a2,2,0,0,1,1.69.48,1.44,1.44,0,0,1,.44.83,4.6,4.6,0,0,1,.05.64V19.3c0,.1,0,.12-.12.12q-.87,0-1.74,0c-.08,0-.1,0-.1-.11v-2.6a2.56,2.56,0,0,0-.07-.62.8.8,0,0,0-1.33-.38,1.15,1.15,0,0,0-.33.76,5.88,5.88,0,0,0,0,.73v2.12c0,.07,0,.1-.09.1H7.91c-.08,0-.1,0-.1-.1V16.68a3.27,3.27,0,0,0,0-.54.73.73,0,0,0-.58-.61.86.86,0,0,0-1,.36,1.12,1.12,0,0,0-.15.62q0,1.39,0,2.79c0,.1,0,.12-.13.12q-.87,0-1.74,0c-.08,0-.1,0-.1-.1V14.21c0-.08,0-.1.11-.1H6c.08,0,.1,0,.1.1s0,.36,0,.55Zm14.62,2.29a3.65,3.65,0,0,0-.11-1,2.5,2.5,0,0,0-1.81-1.9,3.93,3.93,0,0,0-2.35,0,2.5,2.5,0,0,0-1.36,1,3,3,0,0,0-.38,2.17,2.56,2.56,0,0,0,1.72,2,4,4,0,0,0,1.5.22,4.14,4.14,0,0,0,.87-.1,2.36,2.36,0,0,0,1.81-1.61c0-.08,0-.1-.07-.1H18.82c-.07,0-.1,0-.14.07a.93.93,0,0,1-.52.37,1.47,1.47,0,0,1-.88,0,.88.88,0,0,1-.62-.67,1.64,1.64,0,0,1-.05-.32c0-.11,0-.12.1-.12h3.88C20.64,17.12,20.69,17.12,20.69,17.05Zm-1.91-1h-2c-.06,0-.08,0-.07-.08a1,1,0,0,1,1-.83,1.18,1.18,0,0,1,.77.18,1.12,1.12,0,0,1,.42.66C18.87,16.07,18.82,16.05,18.78,16.05Zm3-10.15a1.67,1.67,0,0,0-1.81-.3,2.7,2.7,0,0,0-.34.17L16.32,8.16a1.15,1.15,0,0,0-.48.73.82.82,0,0,0,.24.75,1.74,1.74,0,0,0,2,.28c.42-.25,3.2-2.31,3.66-2.64l.11-.12a1,1,0,0,0-.06-1.26ZM7.92,9.58a.82.82,0,0,0,.24-.75,1.19,1.19,0,0,0-.48-.74L4.39,5.71a1.83,1.83,0,0,0-.34-.18,1.68,1.68,0,0,0-1.8.31,1,1,0,0,0-.06,1.25l.11.12C2.76,7.55,5.54,9.6,6,9.86a1.76,1.76,0,0,0,2-.28ZM12,8.94A1.4,1.4,0,0,0,13.48,8a1.07,1.07,0,0,0,0-.25l0-2.14V5.58c0-.82-.66-1.2-1.49-1.2s-1.5.44-1.51,1.26V7.79a1,1,0,0,0,0,.25,1.35,1.35,0,0,0,1.47.9Zm4.34,1.62a10.11,10.11,0,0,0-4.51-.9c-3.23,0-5.39,1-6.49,2.5h13a5.75,5.75,0,0,0-2-1.6Z"/></svg>',
  'funding:helloasso' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M9.74,3c7.35.4,6.31,7.57,6.31,7.57A7.62,7.62,0,0,0,9.56,7.08c-3.39.08-7,2.61-7.06,7.71A8,8,0,0,1,2,12.14C2.14,5.71,7,2.83,9.74,3Zm7.11.07a8,8,0,0,0-2.56-.81c4.48,2.43,5,6.84,3.43,9.87a7.61,7.61,0,0,1-6.13,4.07s5.83,4.32,9.66-2C22.7,11.83,22.45,6.23,16.85,3.05ZM17,20.32a8,8,0,0,0,2-1.77c-4.4,2.58-8.43.73-10.23-2.15a7.64,7.64,0,0,1-.32-7.35s-6.7,2.76-3.3,9.28C6.44,20.8,11.37,23.48,17,20.32Z"/></svg>',
  'funding:indiegogo' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M17.08,15.11c-1.66,0-1.88-1.14-1.88-3s.22-3,1.88-3,1.87,1.14,1.87,3S18.72,15.11,17.08,15.11Zm0-8.87C12.89,6.24,12.14,9,12.14,12s.75,5.75,4.94,5.75S22,15,22,12s-.73-5.77-4.92-5.77m-10.7,7H8.32v.2c0,1.24,0,1.79-1.44,1.79S5,14.63,5,12.1s.79-3,2-3a4,4,0,0,1,2,.51l1.61-2.5a6.61,6.61,0,0,0-3.5-.91C3.25,6.24,2,8.1,2,12c0,3.4.91,5.75,4.6,5.75a9.41,9.41,0,0,0,1.7-.13h2.77V10.84H6.71l-.33,2.44"/></svg>',
  'funding:kickstarter' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M21,17.52a4.6,4.6,0,0,1-8.33,2.56l-.94-1.33A4.21,4.21,0,0,1,7.47,22,4.44,4.44,0,0,1,3,17.56V6.44A4.42,4.42,0,0,1,7.47,2a4.27,4.27,0,0,1,4.29,3.38l1.08-1.46A4.63,4.63,0,0,1,16.53,2,4.4,4.4,0,0,1,21,6.38,4.35,4.35,0,0,1,20.16,9L18,12l2.15,3A4.44,4.44,0,0,1,21,17.52Z"/></svg>',
  'funding:kisskissbankbank' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M15,6.84a7.54,7.54,0,1,0-.09,10.42L9.77,12.09Zm4.86,5.23A2.54,2.54,0,1,0,17.7,7.73h0l-4.33,4.34,4.23,4.23a2.55,2.55,0,1,0,2.3-4.24"/></svg>',
  'funding:kofi' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0z"/><path d="M21.9 9.827C21.257 6.423 17.852 6 17.852 6H2.602c-.503 0-.565.665-.565.665s-.069 6.103-.019 9.852c.137 2.02 2.155 2.226 2.155 2.226s6.89-.019 9.972-.04c2.031-.356 2.236-2.139 2.215-3.112 3.626.2 6.185-2.36 5.54-5.764Zm-9.218 2.926c-1.038 1.211-3.342 3.314-3.342 3.314s-.101.099-.258.019c-.064-.048-.09-.075-.09-.075-.37-.368-2.807-2.541-3.362-3.295-.59-.804-.868-2.25-.076-3.092.793-.842 2.504-.905 3.636.34 0 0 1.304-1.486 2.89-.803 1.586.683 1.527 2.509.602 3.592Zm5.144.399c-.773.096-1.401.023-1.401.023V8.44H17.9s1.642.459 1.642 2.198c0 1.594-.82 2.223-1.716 2.513Z"/></svg>',
  'funding:liberapay' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M8.12,18.36A5.69,5.69,0,0,1,5.79,18a2.41,2.41,0,0,1-1.2-1,3,3,0,0,1-.36-1.53,8.94,8.94,0,0,1,.24-1.84l2.65-11L10.34,2,7.45,14a3,3,0,0,0-.09.68,1.12,1.12,0,0,0,.11.56.86.86,0,0,0,.43.38,2.37,2.37,0,0,0,.84.19Zm11.65-6.89a7.55,7.55,0,0,1-.5,2.78,6.68,6.68,0,0,1-1.39,2.17,6.15,6.15,0,0,1-2.12,1.43,7,7,0,0,1-2.69.51,7.5,7.5,0,0,1-1.42-.13L10.71,22H7.63L11.09,7.6A16.73,16.73,0,0,1,13,7.15,13,13,0,0,1,15.31,7a5.08,5.08,0,0,1,2,.36,3.8,3.8,0,0,1,1.39,1,4.06,4.06,0,0,1,.8,1.44,5.9,5.9,0,0,1,.26,1.76Zm-7.56,4.27a4.33,4.33,0,0,0,.88.08,3.51,3.51,0,0,0,1.47-.3,3.22,3.22,0,0,0,1.14-.85,4,4,0,0,0,.73-1.3,5.18,5.18,0,0,0,.26-1.67,2.79,2.79,0,0,0-.4-1.52,1.48,1.48,0,0,0-1.37-.63,6.15,6.15,0,0,0-1.25.13Z"/></svg>',
  'funding:patreon' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M15,17a7.5,7.5,0,1,1,7.5-7.5A7.5,7.5,0,0,1,15,17ZM2,2H6V22H2Z"/></svg>',
  'funding:paypal' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M20.07,8.48a4.89,4.89,0,0,1,.3,3.32c-.74,3.81-3.28,5.12-6.52,5.12h-.5a.81.81,0,0,0-.79.68l0,.22-.63,4,0,.17a.81.81,0,0,1-.8.68H7.72a.48.48,0,0,1-.48-.49v-.07L7.42,21H8.94l1-6h1.38C16,15,19,12.78,20.07,8.48Zm-3-5.09a3.62,3.62,0,0,1,.75,3.28L17.8,7c-.74,3.78-3.09,5.45-7,5.45H9a1.42,1.42,0,0,0-1.36,1h0l-.93,5.89H3.12a0,0,0,0,1-.05-.05h0L5.67,2.8A1,1,0,0,1,6.61,2h6c2.19,0,3.72.47,4.53,1.39Z"/></svg>',
  'funding:tipeee' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M12.7,14h-.62V7.58a.2.2,0,0,0-.19-.2l-3.3,1a.27.27,0,0,0-.19.29v1.89a.19.19,0,0,0,.19.19l.59-.17V14H8.56a.19.19,0,0,0-.19.19v2a.19.19,0,0,0,.19.2h4.15a.2.2,0,0,0,.19-.2v-2a.2.2,0,0,0-.2-.19ZM10.63,7.09A1.45,1.45,0,1,0,9.18,5.64a1.45,1.45,0,0,0,1.45,1.45Zm-3.42.29H5.69V5.26s0-.55-.53-.35-1.94.6-1.94.6A.42.42,0,0,0,2.9,6c0,.34,0,.54,0,1.41H2.19a.2.2,0,0,0-.19.2v2a.2.2,0,0,0,.19.19h.73v4.32s-.17,3.49,4.24,1.77c0,0,.23-.12.24-.31V13.61s0-.29-.27-.16c0,0-1.44.65-1.44-.29V9.75H7.21a.2.2,0,0,0,.2-.2v-2a.2.2,0,0,0-.2-.19Zm10.88,0a3.56,3.56,0,0,0-1.34.27V7.57a.2.2,0,0,0-.2-.2H13.21a.2.2,0,0,0-.2.2v2a.2.2,0,0,0,.2.2h.63v7.69h-.63a.19.19,0,0,0-.2.19v2a.2.2,0,0,0,.2.2h4.16a.19.19,0,0,0,.19-.2v-2a.19.19,0,0,0-.19-.19h-.62V16.05a3.56,3.56,0,0,0,1.34.27A4.22,4.22,0,0,0,22,11.85,4.22,4.22,0,0,0,18.09,7.38ZM18.14,14c-.78,0-1.4-1-1.39-2.16s.63-2.15,1.41-2.14,1.39,1,1.39,2.16S18.91,14,18.14,14Z"/></svg>',
  'funding:ulule' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0,0H24V24H0Z"/><path d="M21.88,6.22a.42.42,0,0,0-.59,0h0l-.69.68a10,10,0,0,0-17.2,0l-.69-.68a.42.42,0,0,0-.59,0,.45.45,0,0,0-.12.3V12a10,10,0,0,0,20,0V6.52A.42.42,0,0,0,21.88,6.22ZM16.32,17.57a4.6,4.6,0,0,1-4.09-2.49.26.26,0,0,0-.35-.1.24.24,0,0,0-.1.1,4.62,4.62,0,1,1,0-4.15,2.28,2.28,0,0,0,.11,3.13.1.1,0,0,0,.14,0,2.28,2.28,0,0,0,.11-3.13,4.61,4.61,0,1,1,4.13,6.64Zm.16-8.2Zm-6.25,2.91a2.91,2.91,0,1,1-3.1-2.9c0,.13-.1.21-.21.32l0,0a.79.79,0,0,0-.28.58.73.73,0,0,0,1.45,0,.76.76,0,0,0-.29-.6.78.78,0,0,1-.26-.34A2.9,2.9,0,0,1,10.23,12.28Zm9.34,0a2.91,2.91,0,1,1-3.11-2.9c0,.13-.1.21-.21.32l0,0a.82.82,0,0,0-.28.58.74.74,0,0,0,.7.7.73.73,0,0,0,.75-.7.76.76,0,0,0-.29-.6c-.12-.11-.24-.23-.25-.34A2.9,2.9,0,0,1,19.57,12.28Z"/></svg>',
  'funding:default' => '<svg fill="currentColor" viewBox="0 0 24 24" width="1em" height="1em"><path fill="none" d="M0 0h24v24H0z"/><path d="M23 12v2c0 3.314-4.925 6-11 6-5.967 0-10.824-2.591-10.995-5.823L1 14v-2c0 3.314 4.925 6 11 6s11-2.686 11-6zM12 4c6.075 0 11 2.686 11 6s-4.925 6-11 6-11-2.686-11-6 4.925-6 11-6z"/></svg>',
  'material-symbols:sort' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M3 18v-2h6v2zm0-5v-2h12v2zm0-5V6h18v2z"/></svg>',
];
}
