#!/opt/cloudlinux/venv/bin/python3 -bb
# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
#
import argparse

from clcommon.public_hooks import setup_logger_and_sentry
from clcommon.public_hooks.bundle import install_hooks, remove_hooks


if __name__ == '__main__':
    logger = setup_logger_and_sentry()
    parser = argparse.ArgumentParser()

    subparsers = parser.add_subparsers(dest='command')
    subparsers.add_parser('install')
    subparsers.add_parser('remove')

    args = parser.parse_args()
    if args.command == 'install':
        logger.info('Installing hooks for control panel actions')
        install_hooks()
    elif args.command == 'remove':
        logger.info('Removing hooks from control panel')
        remove_hooks()
    else:
        raise NotImplementedError(f'command `{args.command}` is not implemented')
