
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `soft_app405`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]administrators`
--

CREATE TABLE `[[dbprefix]]administrators` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupid` int(11) NOT NULL,
  `f_name` varchar(50) NOT NULL,
  `l_name` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(100) NOT NULL,
  `email` varchar(50) NOT NULL,
  `createdate` datetime NOT NULL,
  `latestlogin` int(11) NOT NULL,
  `lastlogin` int(11) NOT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  `type` enum('Super','Normal') NOT NULL DEFAULT 'Normal',
  `acl` text NOT NULL,
  `aclobject` text NOT NULL,
  `description` text NOT NULL,
  `resetsid` varchar(200) NOT NULL,
  `lastresettime` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]administrators`
--

INSERT INTO `[[dbprefix]]administrators` VALUES
(1, 0, '[[admin_fname]]', '[[admin_lname]]', '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', '[[regtime]]', 0, 0, 'Active', 'Super', '', '', '', '', [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]appreportcodes`
--

CREATE TABLE `[[dbprefix]]appreportcodes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `adminid` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `groups` varchar(100) NOT NULL,
  `code` text NOT NULL,
  `dated` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]appreportcodes`
--

INSERT INTO `[[dbprefix]]appreportcodes` VALUES
(1, 1, 'All User Report', '1', '1519835753.arbt', '2023-04-16 23:12:18');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]appslide`
--

CREATE TABLE `[[dbprefix]]appslide` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `adminref` int(11) NOT NULL,
  `entrydate` datetime NOT NULL DEFAULT '2012-08-18 10:08:56',
  `lastmodified` datetime NOT NULL,
  `title` varchar(255) NOT NULL,
  `image` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `status` enum('Active','Inactive') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fkey` int(11) NOT NULL DEFAULT '0',
  `adminref` int(11) NOT NULL DEFAULT '0',
  `parentid` int(11) NOT NULL DEFAULT '0',
  `image` varchar(200) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `type` varchar(255) NOT NULL,
  `generic` varchar(250) NOT NULL,
  `entrydate` datetime NOT NULL,
  `lastmodified` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(1, 0, 1, 0, '', 'Common Reports', '', 'appreportgroup', '', '2023-04-16 23:11:11', '2023-04-16 23:11:11');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]coreresources`
--

CREATE TABLE `[[dbprefix]]coreresources` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `type` enum('Model','Module','Plugin','Component') NOT NULL DEFAULT 'Model',
  `version` varchar(200) NOT NULL DEFAULT '',
  `status` enum('Active','Inactive') NOT NULL,
  `info` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=24 ;

--
-- Dumping data for table `[[dbprefix]]coreresources`
--

INSERT INTO `[[dbprefix]]coreresources` VALUES
(1, 'Admin', 'Model', '0.1.0', 'Active', ''),
(2, 'Category', 'Model', '0.1.0', 'Active', ''),
(3, 'Config', 'Model', '0.1.0', 'Active', ''),
(4, 'Coreresource', 'Model', '0.1.0', 'Active', ''),
(5, 'Developer', 'Model', '0.1.0', 'Active', ''),
(6, 'Home', 'Model', '0.1.0', 'Active', ''),
(7, 'Information', 'Model', '0.1.0', 'Active', ''),
(8, 'Log', 'Model', '0.1.0', 'Active', ''),
(9, 'Page', 'Model', '0.1.0', 'Active', ''),
(10, 'appeditor', 'Component', '0.1.7', 'Active', 'a:1:{s:11:"installdate";s:19:"2021-07-26 06:54:52";}'),
(11, 'appslide', 'Component', '0.1.0', 'Inactive', 'a:1:{s:11:"installdate";s:19:"2023-04-19 23:41:14";}'),
(12, 'homepress', 'Component', '0.1.0', 'Active', 'a:1:{s:11:"installdate";s:19:"2023-04-20 00:45:42";}'),
(13, 'pagemanager', 'Component', '1.2.6', 'Active', 'a:1:{s:11:"installdate";s:19:"2021-07-26 22:18:13";}'),
(14, 'adminpanelquicklaunch', 'Component', '1.0.1', 'Active', 'a:1:{s:11:"installdate";s:19:"2023-04-15 20:55:05";}'),
(15, 'dbexpert', 'Component', '0.1.2', 'Active', 'a:1:{s:11:"installdate";s:19:"2021-07-26 22:51:31";}'),
(16, 'ethical', 'Component', '2.1.1', 'Active', 'a:1:{s:11:"installdate";s:19:"2021-07-26 23:06:08";}'),
(17, 'appreport', 'Component', '2.1.1', 'Active', 'a:1:{s:11:"installdate";s:19:"2023-04-19 23:42:39";}'),
(18, 'Appreportcode', 'Model', '0.1.0', 'Active', ''),
(19, 'messenger', 'Component', '2.0.0', 'Inactive', 'a:1:{s:11:"installdate";s:19:"2023-04-19 23:41:49";}'),
(20, 'Message', 'Model', '0.1.0', 'Active', ''),
(21, 'Notification', 'Model', '0.1.0', 'Active', ''),
(22, 'contactus', 'Component', '0.1.1', 'Inactive', 'a:1:{s:11:"installdate";s:19:"2023-04-20 01:25:39";}'),
(23, 'tablesorter', 'Component', '1.0.2', 'Active', 'a:1:{s:11:"installdate";s:19:"2023-04-19 23:41:55";}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]emailtemplate`
--

CREATE TABLE `[[dbprefix]]emailtemplate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `adminref` int(11) NOT NULL,
  `entrydate` datetime NOT NULL DEFAULT '2012-08-22 15:59:32',
  `lastmodified` datetime NOT NULL,
  `templatetype` varchar(100) NOT NULL,
  `subject` varchar(200) NOT NULL,
  `message` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]emailtemplate`
--

INSERT INTO `[[dbprefix]]emailtemplate` VALUES
(7, 1, '2012-08-22 15:59:32', '2023-04-19 23:41:18', 'ContactUs', 'One message sent  by {FirstName}{LastName}', 'Following message sen by {FirstName}{LastName}\n\n{Message}\n\n<hr />\n\nSubject:  {Subject}\n\nSender Email:  {Email}\n\n<a href="{baseurl}">View Website</a> <a href="{baseurl}/admin">View Admin</a>');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]homepress`
--

CREATE TABLE `[[dbprefix]]homepress` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `adminref` int(11) NOT NULL,
  `entrydate` datetime NOT NULL DEFAULT '2016-05-04 19:12:42',
  `lastmodified` datetime NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `image` varchar(255) NOT NULL,
  `shortdesc` text NOT NULL,
  `linkedto` varchar(255) NOT NULL,
  `status` enum('Active','Inactive') NOT NULL,
  `position` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log`
--

CREATE TABLE `[[dbprefix]]log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fkey` int(11) NOT NULL,
  `type` varchar(20) NOT NULL,
  `dated` datetime NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messages`
--

CREATE TABLE `[[dbprefix]]messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` int(11) NOT NULL,
  `sendertitle` varchar(50) NOT NULL,
  `senderid` varchar(50) NOT NULL,
  `receivedid` varchar(50) NOT NULL,
  `session` varchar(15) NOT NULL,
  `message` varchar(200) NOT NULL,
  `imagelink` text NOT NULL,
  `readerstatus` char(1) NOT NULL,
  `timestamp` varchar(15) NOT NULL,
  `entrydate` datetime NOT NULL,
  `type` varchar(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notifications`
--

CREATE TABLE `[[dbprefix]]notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel` varchar(20) NOT NULL,
  `title` varchar(50) NOT NULL,
  `description` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `timestamp` varchar(12) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pages`
--

CREATE TABLE `[[dbprefix]]pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fkey` int(11) NOT NULL DEFAULT '0',
  `page_title` varchar(255) NOT NULL,
  `meta_keywords` varchar(255) NOT NULL,
  `meta_description` varchar(255) NOT NULL,
  `name` varchar(200) NOT NULL,
  `title` varchar(200) NOT NULL,
  `content` text NOT NULL,
  `hook` varchar(255) NOT NULL,
  `userdefinehook` varchar(256) NOT NULL,
  `richtexteditor` enum('Yes','No') NOT NULL,
  `rendertype` enum('h_link','smart_h_link','text') NOT NULL,
  `contenttype` enum('Content','Snip') NOT NULL DEFAULT 'Content',
  `sort_order` int(5) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fkey` (`fkey`,`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=60 ;

--
-- Dumping data for table `[[dbprefix]]pages`
--

INSERT INTO `[[dbprefix]]pages` VALUES
(1, 0, 'About appRain Content Management Framework', '', '', 'aboutus', 'About Us', '<div>\n<p>appRain is one of the first officially released open-source content management frameworks (CMF). CMF is a new, web engineering concept where a content management system (CMS) and a rapid development framework perform side-by-side to produce endless varieties of output in a very limited time.</p>\n\n<p>appRain is developed on a daily basis, drawing on extensive project experience. A common problem that we all face in a framework is that we need to re-develop some common modules in each project. With content management systems, we sometimes get stuck driving our development based on the strict conventions the system enforces. Why is there no CMS integrated with a framework? This is the question that gave birth to appRain.</p>\n\n<p>Content management systems and frameworks are very popular in web development. These two technologies work in different ways. One is used for rapid development, the other for more customized output. appRain merges these two technologies. appRain is fast, flexible, and makes it easy to complete tasks in a very short time period. It can be expanded and scaled.</p>\n\n<p>The tools in the CMS component of appRain are all configurable, making development faster. It helps to avoid repeating tasks. The framework component is used when it becomes too difficult to complete your requirements using the CMS tools. The framework contains all of the core programming tools.</p>\n\n<p>appRain aims to make creating web technology simple and easily optimized.</p>\n</div>\n', 'sitemenu', '', 'Yes', 'text', 'Content', 9),
(2, 0, 'InformationSet and CategorySet', 'InformationSet and CategorySet', 'InformationSet and CategorySet', 'informationset-categoryset', 'InformationSet and CategorySet', '<div>\n<p>InformationSet and CategorySet are two common tools used to manage data. These two methods reduce development time significantly.</p>\n\n<p>InformationSet automatically creates interfaces for data entry controlled by a preconfigured validation matrix. This is a single database table managed by an XML file where all database fields are defined separately with parameters like</p>\n\n<ol>\n	<li>Database attributes</li>\n	<li>Data Input Type (Text Box, Text Area, File Input, etc.)</li>\n	<li>Define the validation.</li>\n	<li>Render an interface in the admin panel for Add, Modify, and View.</li>\n</ol>\n\n<p>InformationSet can adjust when the definition of a field changes. In that case, the database user needs the necessary permissions.<br />\n<br />\nAn InformationSet can be linked with other InformationSets or CategorySets for joining, and it also creates linked input tags like Drop Down and Check Box, etc.<br />\n<br />\nCategorySet works similarly to InformationSet, but it specifically works to manage recursive parent-child relations. Generally, it is used to categorize any InformationSet data.</p>\n\n<p>A rich library of functions has been developed to work with InformationSet and CategorySet.</p>\n</div>\n', 'quicklinks', '', 'Yes', 'smart_h_link', 'Content', 5),
(3, 0, 'Theme Development', 'Theme Development', 'Theme Development', 'theme-development', 'Theme Development', '<p>When developing websites, working with themes is a typical task. It could be the website&#39;s front end or the admin area. Let&#39;s take a look at how to create a front-end theme.</p>\n\n<p>All themes are created inside the view folder of the development folder. Create a directory in the location below if the theme&#39;s name is Rainy Day.</p>\n\n<p><code>development/view/rainyday</code></p>\n\n<p>There are a few fundamental folders that must be created in the view folder; let&#39;s go over each one individually.</p>\n\n<p><strong>Definition:</strong></p>\n\n<p>Definition is a required folder that stores a theme&#39;s core resources. First of all, the <em>info.xml</em>. It contains basic boot files and developer&#39;s information.When you open a file from an existing theme, you may find the XML with the nodes listed below.</p>\n\n<p>{{name=UI type=staticpage name=theme-info-xml-field-information-dp autoformat=off}}</p>\n\n<p>The logo serves as the theme&#39;s thumbnail in the theme gallery. The name of the logo should match the info.xml definition.</p>\n\n<p><em>register.php</em> is the class file defined in info XML. As per Apprain convention, the <a href="http://docs.apprain.org/index.html?definition.htm">class name</a> comes with the path of the file. The class contains the basic callback function listed below</p>\n\n<p><code>before_theme_load($Send=null)<br />\nafter_theme_load($Send=null)<br />\nbefore_theme_install($Send=null)<br />\nafter_theme_installed($Send=null)<br />\non_theme_removed($Send=null) </code></p>\n\n<p>Before the theme loads, we frequently change the layout based on what the page is showing. For an illustration, see the sample below.</p>\n\n<pre>\nif(App::Config()-&gt;isPageView()){\n  $Send-&gt;layout = App::Config()-&gt;Setting(&#39;site_pageview_layout&#39;,&#39;right_column_layout&#39;);\n}\n</pre>\n\n<p>The <em>themesettings.xml </em>file contains any settings that a theme could require from the user. The field that a user must edit in order to change the theme might be specified. The settings can be accessed via the admin panel from <em>Preferences &gt; Theme &gt; Settings.</em></p>\n\n<p><strong>Layout</strong></p>\n\n<p>Through layout, we define the basic page structure; all are the.phtml files stored in the layout folder, and the system loads default.phtml by default; however, when a different layout is needed, we can set it like $send-&gt;layout = &#39;simple&#39; from the register callback method.</p>\n\n<p>Below are some important points to be noted</p>\n\n<p><em><code>$this-&gt;callElement(&quot;header_info&quot;)</code> </em>:<br />\nThis is to call an element from the elements folder that sets the header of the HTML documents.</p>\n\n<p><code><em>$this-&gt;fetchAddonlibs();</em></code><br />\nLoad all client-side addons generally based on HTML, Javascript, and CSS</p>\n\n<p><code><em>$this-&gt;callElement(&quot;header&quot;), $this-&gt;callElement(&quot;footer&quot;)</em></code><br />\nIt is advised to keep the header and footer in these two elements that eventually help to edit from the admin panel.</p>\n\n<p><code><em>$content_rendered</em></code><br />\nThis variable contains the output of the page view that we have defined in the controller function as per the conventions of MVC. So when we browse different web pages, the content changes and is placed in the layout. more, as you can see in the <a href="http://docs.apprain.org/layout.htm">documentation</a>.</p>\n\n<p><strong>Elements:</strong><br />\nElements are split-view files that can be included into other pages as needed. The <a href="http://docs.apprain.org/elements.htm">method for rendering an element&#39;s</a> content is shown below.</p>\n\n<p><code>$this-&gt;callElement([Element Name])</code> for example <code>echo $this-&gt;callElement(&quot;quicklinks&quot;)</code></p>\n\n<p><strong>Home, Page</strong><br />\nThese are two folders created for Home and Page Controller in the development folder as a standard. All the files inside are templates for Action Method.</p>\n\n<p>index.html in the home folder is the default page, as it&#39;s defined in Router (boot_router.xml). On the other hand, view.phtml in the pages folder is to display content from the Page Manger in the admin panel.</p>\n\n<p>More pages can be created in the development area or from a component that loads as per the browsed webpage address following the <a href="http://docs.apprain.org/action_template.htm">convention of the MVC pattern</a></p>\n\n<p><strong>UI Hook</strong></p>\n\n<p>UI Hooks are placeholders to render content from external modules like Component, Page Manager, and so on. A theme contains basic UI hooks defined in info.xml by the theme developer. Then the end user can easily place content on a webpage from the Page Manager in the admin panel.</p>\n\n<p>As these hooks cannot be seen without going into code, the end user can go to Preferences &gt; Configuration and set the parameter Show Hook Positions to &quot;Yes&quot; to view the positions in the front end to select where to put the content. See the instance below; more illustrations can be <a href="http://docs.apprain.org/ui_hooks.htm">found in the documentation</a>.</p>\n\n<p><code>App::Hook(&#39;UI&#39;)-&gt;Render([Hook Name]); </code>for example <code>App::Hook(&#39;UI&#39;)-&gt;Render(&#39;quick_links_top&#39;);</code></p>\n\n<p>External Resouces</p>\n\n<p>For most of the theme, we need to store CSS, JavaScript, and other theme files and access them from the development area. Generally, we store those files in the themeroot folder in webroot; for example, see below location</p>\n\n<p><code>webroot/themeroot/rainyday</code></p>\n\n<p>Note: Generally, we save a default.css file in a CSS folder that we can modify from the admin panel in the theme area.</p>\n\n<p>To retrieve resources from the theme folder that is presently active, use the skinUrl function. See examples below.</p>\n\n<p><code>echo App::Config()-&gt;skinUrl(&quot;/css/default.css&quot;);<br />\necho App::Config()-&gt;skinUrl(&quot;/images/banner.jpg&quot;);</code></p>\n\n<p>One more function that will help you is to load resources uploaded by file manager using filemanagerUrl. See below example:</p>\n\n<p><code>echo App::Config()-&gt;fileManagerUrl(&quot;/logo.png&quot;);</code></p>\n\n<p>You can read a lot about theme development in the <a href="http://docs.apprain.org/theme.htm">manual</a>.</p>\n', 'quicklinks', '', 'Yes', 'smart_h_link', 'Content', 6),
(4, 0, 'General Help Center', 'General Help Center', 'General Help Center', 'general-help-center', 'General Help Center', '<p>appRain has a detailed manual to read online or download. We always encourage sending your valuable feedback to info@apprain.com</p>\n\n<p><a href="http://docs.apprain.org">Online Manual</a></p>\n\n<p>CHM is the standard help format for a windows desktop application. The output is a single file with extension *.chm.</p>\n\n<p><a href="http://www.apprain.org/help/chm">Download</a></p>\n\n<p>Adobe Portable Document Format (PDF) is a platform independent file format. This is ideal for Device and Print.</p>\n\n<p><a href="http://www.apprain.org/help/pdf">Download</a></p>\n\n<p>This type is a cross-platform e-book standard created by the IDPF, which is supported by Apple iBooks, Andriod Tablets/smartphones and many other e-readers on windows, Mac OSX, iOS and Linux.</p>\n\n<p><a href="http://www.apprain.org/help/epub">Download</a></p>\n\n<p>This format is an ideal to illustrate web-based application, to publish documentation to the internet, intranet or CD-ROM</p>\n\n<p><a href="http://www.apprain.org/help/html">Download</a></p>\n\n<p>Windows e-books are stand-alone Windows executable with HTML formatted texts and images. This output format is great for CD-ROM presentations.</p>\n\n<p><a href="http://www.apprain.org/help/ebook">Download</a></p>\n', 'quicklinks', '', 'Yes', 'smart_h_link', 'Content', 8),
(12, 0, 'Quick Links Top', '', '', 'quick-links-top', 'Quick Links Top', '{{name=UI type=staticpage name=quick-links-top-dp autoformat=off}}\n', 'quick_links_top', '', 'Yes', 'text', 'Content', 0),
(13, 0, '', '', '', 'quick-links-top-dp', '', '<div class="p-4 mb-3 bg-light rounded">\n	<h4 class="fst-italic">Apprain <?php echo App::__Def()->sysConfig(''APPRAINVERSION''); ?></h4>\n	<p class="mb-0">\n	    Version <?php echo App::__Def()->sysConfig(''APPRAINVERSION''); ?> has come up with many fixes with the new version of PHP.This release includes two components: ethincal and messenger, which play a significant role in development.\n	</p>\n</div>', '', '', 'Yes', 'h_link', 'Snip', 0),
(6, 0, 'Terms of Use: appRain Content Management Framework', 'Terms, Condition, Copy Right', '', 'terms-of-use', 'Terms of Use', '<p>Copyright (c) appRain CMF (http://www.apprain.com)<br />\n<br />\nPermission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the &quot;Software&quot;), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:<br />\n<br />\nThe above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.<br />\n<br />\nTHE SOFTWARE IS PROVIDED &quot;AS IS&quot;, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.</p>\n', 'quicklinks', '', 'Yes', 'smart_h_link', 'Content', 7),
(41, 0, '', '', '', 'whitecloud_slide', '', '<section id="myCarousel" class="carousel slide" data-bs-ride="carousel">\n	<div class="carousel-indicators">\n	  <button type="button" data-bs-target="#myCarousel" data-bs-slide-to="0" class="active" aria-current="true" aria-label="Slide 1"></button>\n	  <button type="button" data-bs-target="#myCarousel" data-bs-slide-to="1" aria-label="Slide 2"></button>\n	  <button type="button" data-bs-target="#myCarousel" data-bs-slide-to="2" aria-label="Slide 3"></button>\n	</div>\n	<div class="carousel-inner">\n	  <div class="carousel-item active">\n		<svg class="bd-placeholder-img" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" preserveAspectRatio="xMidYMid slice" focusable="false">\n			<rect width="100%" height="100%" fill="#666"/>\n		</svg>\n		<div class="container">\n		  <div class="carousel-caption text-start">\n			<h1 class="display-5 fw-bold">Apprain 4.0.5</h1>\n			\n			 <p>\n				Are you ready to write some XML tags? It''s pretty simple, right? XML-based coding will enable significant advancements in appRain. \n				You can create an admin panel interface, configure software, work with databases, and many other things.\n			 </p>\n			 <p>\n			 appRain is the best fit for your enterprise projects with less effort.</p><hr />\n			<p><a class="btn btn-lg btn-primary" href="<?php echo App::Config()->baseUrl("/concept-of-development");?>">Concept of development.</a></p>\n		  </div>\n		</div>\n	  </div>\n	  <div class="carousel-item">\n		<svg class="bd-placeholder-img" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" preserveAspectRatio="xMidYMid slice" focusable="false"><rect width="100%" height="100%" fill="#444"/></svg>\n		<div class="container">\n		  <div class="carousel-caption text-start">\n			<h1 class="display-5 fw-bold">CMS + Framework</h1>\n			<p>Website or enterprise project, plan it first properly to make the development faster and more convenient. First, use the built-in tools available in CMS. Secondly, use the configureable tools in Framework, and then go for coding for customized development in MVC.</p>\n			<p>appRain enables the maximum amount of customized development through its standard libraries. </p>\n			<hr />\n			<p><a class="btn btn-lg btn-primary" href="#">Quick Start</a></p>\n		  </div>\n		</div>\n	  </div>\n	  <div class="carousel-item">\n		<svg class="bd-placeholder-img" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" preserveAspectRatio="xMidYMid slice" focusable="false">\n			<rect width="100%" height="100%" fill="#555"/>\n		</svg>\n		<div class="container">\n		  <div class="carousel-caption text-start">\n			<h1 class="display-5 fw-bold">API Service</h1>\n			<p>Convert your work into APIs; it''s very easy. The application can be securely integrated with any other system on any platform.</p>\n			<p>Ethical is a security plugin in-built with version 4.0.5 that also works as an API layer. Install the component, create a service helper, and that''s all it takes to make the method callable from other systems through user authentication and a secure token. </p>\n			<p><a class="btn btn-lg btn-primary" href="#">Ethical Component</a></p>\n		  </div>\n		</div>\n	  </div>\n	  \n	</div>\n	<button class="carousel-control-prev" type="button" data-bs-target="#myCarousel" data-bs-slide="prev">\n	  <span class="carousel-control-prev-icon" aria-hidden="true"></span>\n	  <span class="visually-hidden">Previous</span>\n	</button>\n	<button class="carousel-control-next" type="button" data-bs-target="#myCarousel" data-bs-slide="next">\n	  <span class="carousel-control-next-icon" aria-hidden="true"></span>\n	  <span class="visually-hidden">Next</span>\n	</button>\n</section>', '', '', 'Yes', 'h_link', 'Snip', 0),
(8, 0, 'appRain:  Content  Management Framework is a combination of Content Management System and Rapid Development Framework', 'Content Management System, PHP Framework, PHP Content Management System, PHP CMS, Web Development Tool, Project Development Tool', 'A PHP Content Management Framework combining  CMS(Content Management System) and Framework (Rapid Development Framework) to enable fast Web Developmen', 'home-page', 'What is appRain  Content Management Framework?', '<hr />\n<h2>What is appRain&nbsp; Content Management Framework?</h2>\n\n<p>appRain is one of the first officially released Opensource Content Management Framework (CMF). CMF is a new web engineering concept where &quot;CMS (Content Management System)&quot; and &quot;Framework&quot; perform together to produce endless varieties of output in a very limited time.</p>\n\n<p>appRain, published with lots of extensive features to reduce our development work time. It satisfies both Client and Developers with a safe and quality output.</p>\n', '', '', 'Yes', 'text', 'Content', 0),
(9, 0, 'Page Manager', '', '', 'page-manager', 'Page Manager', '<p>Page Manager is a frequently used module to create new pages on the website. You will find it in the first tab after logging into the Admin Panel.</p>\n\n<p>Use the link page section to assign your page to different places on the website. You will get a selected section to assign the page in the menu under Quick Links. Holding the CTRL key and clicking with the left mouse button selects multiple hooks.</p>\n\n<p>You can select the option from the drop-down beneath the hook list. The Text option will place the page content in a particular area of a page. Hyperlinks can be of two types; one is Smart Link, which generates a page with an optimized URL. The other is a direct link to the page.</p>\n\n<p>A large text box is available to renter a page in a User Defile Hook defined in the theme; each hook name must be comma separated.</p>\n\n<p>It is really important to format the page well. Use the common field section to set the page title and other meta information.</p>\n\n<p>The Sort Order field is helpful to manage the order of the page in the website menu and quick links.</p>\n\n<p>Dynamic pages are great features in Page Manager for writing server-side code from the interface. All resources should be accessible through App Factory. Because this factory will make all your resources available in the script, To work in a dynamic page, you should be familiar with the system&#39;s internal coding structure. One important tip: dynamic pages render only under static pages. Click on the &quot;Page Code List&quot; button, and the list will pop up. Also, a static page can be rendered alongside another static page. Just paste the page code inside the content.</p>\n\n<p>For developers, there is a detailed module to execute all operations. This module helps to work with pages in the MVC model. Moreover, it has different hooks to register Page Manager in a component in different events.</p>\n', 'quicklinks', '', 'Yes', 'smart_h_link', 'Content', 2),
(10, 0, 'Quick Start', 'Quick Start', 'Quick Start', 'quick-start', 'Quick Start', '<p>How a project&#39;s development starts basically depends on the demands of the requirements, but typically it is either front end of the website or in the admin panel.</p>\n\n<p>First, log in to the admin panel (see the link in the footer) and go to &quot;<em>Preferences &gt; Admin Settings</em>,&quot; where you can change basic information. Moreover, check all the other menus under &quot;Preferences&quot; to explore other options. Among them, theme is one of the options that helps to change the installed themes.</p>\n\n<p><u>Note:</u> Two basic themes have been released as samples with the installation of version 4.0.5. These themes have been given as a sample, but other themes may vary depending on the theme developer. How to develop a theme has been described in the <a href="{baseurl}/theme-development">Theme Development Section</a>.</p>\n\n<p><strong>Customize website content</strong></p>\n\n<p>Login to the admin panel and activate the theme &quot;White Cloud&quot; from the below location</p>\n\n<p><em>Preferences &gt; Theme.</em></p>\n\n<p>We can use Page Manager to modify the content of the website. Go to the below location to modify website page content.</p>\n\n<p><em>Page Manager &gt; Static Pages &gt; Manage Pages</em></p>\n\n<p>For this theme, Page Manager will help modify the HTML content as well. Go to the dynamic pages section to modify the content from the below location.</p>\n\n<p><em>Page Manager &gt; Dynamic Pages &gt; Manage Pages</em></p>\n\n<p>White Cloud is a special theme that saves all HTML content to the database and allows modification from the admin panel. However, because HTML is generally saved in the file system, you should find it in the below folder. To simulate this, you can use the Rainy Day theme.</p>\n\n<p><code>development/view/rainyday</code></p>\n\n<p><u>Note:</u> Dynamic pages allow HTML and PHP to be executed, and it is recommended that Apprain Factory be used to access all internal resources.</p>\n\n<p><strong>Create your first controller and page:</strong></p>\n\n<p>Creating a controller and a page is generally the first step of a project to create a webpage and process data. More detail will be in the documentation, but we will see a simple simulation here. A controller is a class containing a set of methods; a method is called an action method when we add the word &quot;Action&quot; at the end of the function name. As a result, it gains the ability to display a page and interact with external calls. Create the below class in the &quot;<em>development/controllers</em>&quot; folder with the name <em>helloworld.php</em>.</p>\n\n<pre>\nclass helloworldController extends appRain_Base_Core\n{\n  public $name = &#39;helloworld&#39;;\n  public function mypageAction(){}\n}</pre>\n\n<p>Now create a folder called &quot;helloworld&quot; in your theme directory; for example, if the theme name is White Cloud, then the location will be</p>\n\n<p><em>/development/view/whitecloud/</em></p>\n\n<p>Inside the folder, create a file with the name &quot;mypage.phtml,&quot; which is basically the name of the action method, and put some content there.&nbsp;</p>\n\n<p>Now you can browse the page with the below convention:</p>\n\n<p><em>[domain name]/[controller name]/[action method name]</em><br />\nFor example <em>www.example.com/helloworld/mypage</em></p>\n\n<p>This is a minimal example of a controller, and there are many more things to do, which can be found in the documentation.</p>\n\n<p><strong>Page in Admin Panel:</strong></p>\n\n<p>After creating a page to render in the admin panel with user authentication, it is widely used in enterprise projects. To render a page in admin panel simple add a tab name in action method</p>\n\n<pre>\npublic function mypageAction()\n{\n   $this-&gt;setAdminTab(&#39;page_manager&#39;);\n}</pre>\n\n<p>Now if you browse the same page, it will be rendered in the admin panel. For further development, see the documentation.</p>\n\n<p><strong>More Quick Points</strong></p>\n\n<ul>\n	<li>Log in to the Admin Panel, then Preferences &gt; Theme. You can edit Header, Footer and default css throught App Editor. Evaltually, you can edit files across the project.</li>\n	<li>Visit the Applications page in the admin panel to install and test all of the available components. A popular tool for creating reports is called Appreport.</li>\n	<li>Database Expert in the Preferences tab helps to import, export, and backup databases.</li>\n	<li>Read the user <a href="http://docs.apprain.org/index.html?user_manual.htm">manual</a> for more help</li>\n</ul>\n', 'quicklinks', '', 'Yes', 'smart_h_link', 'Content', 1),
(11, 0, 'Concept of Development', 'Concept of Development', 'Concept of Development', 'concept-of-development', 'Concept of Development', '<p>Apprain is a robust platform for development that optimizes effort and time.</p>\n\n<p>After setting up Apprain , start development with all interface-based tools like Page Manager, Theme, etc. This is the primary stage of your start-up.</p>\n\n<p>After that, find components that fit you and install them. This will save you a lot of time.</p>\n\n<p>Next, work with XML to manage your development to save time. Below are some common sections to work with that are found in &quot;development/definition.&quot;.</p>\n\n<ul>\n	<li>Interface Builder is used to develop the admin and manage access control.</li>\n	<li>InformationSet and CategorySet help with data management.</li>\n	<li>Site Settings is a strong tool to manage configuration.</li>\n	<li>The URI Manager is used to manage the routing of the system and dynamically access resources.</li>\n	<li>There is a strong language module to maintain information.</li>\n	<li>Integrate external UI plug-ins by using add-ons.</li>\n</ul>\n\n<p>Now start working with the MVC pattern to meet order requirements. Configure one or multiple databases to work with simultaneously.<br />\nThis is highly recommended: develop new components for specific requirements. Each component will enrich your personal archive because it is reusable. A component uses any core resource by using a hook.</p>\n\n<p>However, appRain has both ready-made and unstitched tools; we just have to use them as per need.</p>\n', 'quicklinks', '', 'Yes', 'smart_h_link', 'Content', 4),
(48, 0, '', '', '', 'whitecloud_footer-content', '', '<div class="col-md-5 offset-md-1 mb-3">\n	<h5>\n		<?php \n			## Check in Language file Admin Panel > Preferances > Language > default.xml\n			echo $this->__("APPRAIN");\n		?>\n		<?php\n			## Check in System Configuration file in source code. This is an hidden field\n			## definition/system_configuration/config.xml \n			echo App::__Def()->sysConfig(''APPRAINVERSION''); \n		?>\n	</h5>\n	<p>\n		The new release focused on security and data interfacing through the Ethical Component.\n	</p>\n</div>', '', '', 'Yes', 'h_link', 'Snip', 0),
(50, 0, '', '', '', 'whitecloud_home-content-area-A', '', '<section>\n<div class="container px-4 py-4">\n	<div class="row row-cols-1 row-cols-md-2 align-items-md-center g-5 py-5">\n	  <div class="col d-flex flex-column align-items-start gap-2">\n		<h3 class="fw-bold">Concept of Development</h3>\n		<p class="text-muted">Working with appRain is all about planning our work. Split the work into three major phases. First, use all CMS tools to execute your first line of defense. Secondly, when you need to work with databases and other customized requirements, switch to using Framework Ready tools. Finally, start coding to do your job. Keep the source code untouched in the core library so applications can be upgraded in the next release.</p>\n		<p class="text-muted">appRain is well-equipped for enterprise project development, making it faster and more secure; appRain ERP is an example. All that remains is to select the appropriate tools.</p>\n  </div>\n\n	  <div class="col">\n		<div class="row row-cols-1 row-cols-sm-2 g-4">\n		  <div class="col d-flex flex-column gap-2">\n			<h4 class="fw-semibold mb-0">&check;  Information Set</h4>		\n			<p class="text-muted">Helps to work with database tables without manual intervention.</p>\n		  </div>\n\n		  <div class="col d-flex flex-column gap-2">\n			<h4 class="fw-semibold mb-0">&check; Category Set</h4>\n			<p class="text-muted">It aids in categorizing information for more meaningful use.</p>\n		  </div>\n\n		  <div class="col d-flex flex-column gap-2">\n			<h4 class="fw-semibold mb-0">&check; Static Page</h4>\n			<p class="text-muted">Use to manage your content and publish to present on your website </p>\n		  </div>\n\n		  <div class="col d-flex flex-column gap-2">\n			<h4 class="fw-semibold mb-0">&check; Dynamic Page</h4>\n			<p class="text-muted">Write code from the interface to prepare content for Page Manager.</p>\n		  </div>\n		</div>\n	  </div>\n	</div>\n  </div>\n</section>', '', '', 'Yes', 'h_link', 'Snip', 0),
(43, 0, '', '', '', 'whitecloud_home-content-area-B', '', '<section class="background-grey">\n<div class="container px-4 py-4">\n	<div class="row row-cols-1 row-cols-md-2 align-items-md-center g-5 py-5">\n	  <div class="col d-flex flex-column align-items-start gap-2">\n		<h3 class="fw-bold">COMPONENT</h3>\n		<p class="text-muted">Always try to make your work reusable. Each component works independently and is reusable, so create a component when the requirement is new. \n		Use all resources through App Factory, staying within the component folder; if needed, access other components resources or send back references using Hooks.</p>\n	 </div>\n	  <div class="col">\n		<h3 class="fw-bold">Base Pattern</h3>\n		<p class="text-muted"><code>App</code> Factory helps manage all resources in the system. It is recommended to use that to ensure compliance.</p>\n		<p class="text-muted"><code>App::Module(''Hook'')</code>  is primarily used in components to register all resources and utilize them in a standalone manner.</p>\n	 \n	  </div>\n	</div>\n</div>\n</section>', '', '', 'Yes', 'h_link', 'Snip', 0),
(44, 0, '', '', '', 'whitecloud_home-content-area-C', '', '<section>\n<div class="container px-4 py-4">\n    <div class="row  align-items-md-center g-5 py-5">\n      <div class="col">\n        <h3 class="fw-bold">Guide Line</h3>\n        <p class="text-muted">\n			Need any help? Shoot us a mail at info[at]apprain.com\n		</p>\n        <p>\nSee the Site Setting, Interface Builder, and ACL sections; those will make your development most customizable. </p>\n		<p>\nIf multiple applications run in a single organization, then try to avoid going through multiple instances of installation. First, configure the router to merge multiple applications with database profiling and give distributed access to the end user by specifying a domain or sub-domin.		</p>\n		<p>\n			Always do component-based development; save your work for future use. Develop hooks for your own component and open it up for other developers to use internally.\n      </div>\n    </div>\n  </div>\n</section>', '', '', 'Yes', 'h_link', 'Snip', 0),
(45, 0, '', '', '', 'whitecloud_home-content-area-D', '', '<section>\n<div class="bg-dark text-secondary px-4 text-center">\n	<div class="py-5">\n		<h1 class="display-5 fw-bold text-white">Apprain Community</h1>\n		<div class="col-lg-6 mx-auto">\n			<p class="fs-5 mb-4">\n			appRain is currently hosted on two websites, which are www.apprain.org and www.apprain.com. New releases, developer materials, and all other information are available on the ORG website. The COM website, on the other hand, offers support for the appRain team''s ERP.\n			The context here is that the ORG is practicing CSR with the support of COM in return enjoys all the releases from the ORG.\n			</p>\n			<div class="d-grid gap-2 d-sm-flex justify-content-sm-center">\n				<a href="https://www.apprain.org" target="_blank"><button type="button" class="btn btn-outline-info btn-lg px-4 me-sm-3 fw-bold">.ORG</button></a>\n				<a href="https://www.apprain.com" target="_blank"><button type="button" class="btn btn-outline-light btn-lg px-4 me-sm-3 fw-bold">.COM</button></a>\n			</div>\n		</div>\n	</div>\n</div>\n</section>', '', '', 'Yes', 'h_link', 'Snip', 0),
(56, 0, '', '', '', 'whitecloud_menu', '', '<ul class="navbar-nav col-lg-8 justify-content-lg-end">		  \n<?php App::Hook("UI")->Render("template_header_A"); #User Interface Hook ?>\n<li class="nav-item">\n  <a class="nav-link" aria-current="page" href="<?php echo App::Config()->baseUrl(); ?>">Home</a>\n</li>\n<li class="nav-item dropdown">\n  <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown" aria-expanded="false">Hand Book</a>\n  <ul class="dropdown-menu">\n	<li><a class="dropdown-item" href="<?php echo App::Config()->baseUrl("/quick-start");?>">Quick Start</a></li>\n	<li><a class="dropdown-item" href="<?php echo App::Config()->baseUrl("/page-manager");?>">Page Manager</a></li>\n	<li><a class="dropdown-item" href="<?php echo App::Config()->baseUrl("/concept-of-development");?>">Concept of Development</a></li>\n	<li><a class="dropdown-item" href="<?php echo App::Config()->baseUrl("/informationset-categoryset");?>">InformationSet and CategorySet</a></li>\n	<li><a class="dropdown-item" href="<?php echo App::Config()->baseUrl("/theme-development");?>">Theme Development</a></li>\n	<li><a class="dropdown-item" href="<?php echo App::Config()->baseUrl("/terms-of-use");?>">Terms of Use</a></li>\n  </ul>\n</li>\n<li class="nav-item">\n  <a class="nav-link" href="<?php echo App::Config()->baseUrl("/about-us");?>">About Apprain</a>\n \n</li>\n<li class="nav-item">\n  <a class="nav-link" href="<?php echo App::Config()->baseUrl("/general-help-center");?>">Support</a>\n</li>\n<?php App::Hook("UI")->Render("template_header_B"); #User Interface Hook ?>\n</ul>', '', '', 'Yes', 'h_link', 'Snip', 0),
(51, 0, '', '', '', 'theme-info-xml-field-information-dp ', '', '<table class="table">\n	<tbody>\n		<tr>\n			<td>Tag Name</td>\n			<td>Purpose</td>\n		</tr>\n		<tr>\n			<td>&lt;name&gt;</td>\n			<td>Name of the theme</td>\n		</tr>\n		<tr>\n			<td>&lt;author&gt;</td>\n			<td>Developers Name</td>\n		</tr>\n		<tr>\n			<td>&lt;author_uri&gt;</td>\n			<td>Website address</td>\n		</tr>\n		<tr>\n			<td>&lt;description&gt;</td>\n			<td>Summary of the theme</td>\n		</tr>\n		<tr>\n			<td>&lt;image&gt;</td>\n			<td>The logo image name is in the same folder</td>\n		</tr>\n		<tr>\n			<td valign="top">&lt;pagemanager_hooks&gt;</td>\n			<td>These are the placeholder names for rendering content created in Page Manager from the admin panel or from a component</td>\n		</tr>\n		<tr>\n			<td valign="top">&lt;settings&gt;</td>\n			<td>This is a site setting file name that contains a set of configurations that the user can change from theme settings in the admin panel</td>\n		</tr>\n		<tr>\n			<td valign="top">&lt;components&gt;</td>\n			<td>List of the components that need to be installed or uninstalled when the theme is activated from the admin panel</td>\n		</tr>\n		<tr>\n			<td valign="top">&lt;callback&gt;</td>\n			<td>Call Back is a class name that runs each time the theme loads to work with dynamic resources in the system. </td>\n		</tr>		\n	</tbody>\n</table>', '', '', 'Yes', 'h_link', 'Snip', 0),
(58, 0, '', '', '', 'whitecloud_footer-menu', '', '<div class="col-6 col-md-2 mb-3">\n	<h5>Themes</h5>\n	<ul class="nav flex-column">\n		<li class="nav-item mb-2"><a href="<?php echo App::Config()->baseUrl("/theme-development"); ?>" class="nav-link p-0 text-muted">Website Theme</a></li>\n		<li class="nav-item mb-2"><a href="<?php echo App::Config()->baseUrl("/page-manager"); ?>" class="nav-link p-0 text-muted">Page Manager</a></li>\n	</ul>\n  </div>\n  \n  <div class="col-6 col-md-2 mb-3">\n	<h5>Developers</h5>\n	<ul class="nav flex-column">\n	  <li class="nav-item mb-2"><a href="<?php echo App::Config()->baseUrl("/quick-start"); ?>" class="nav-link p-0 text-muted">Quick Start</a></li>\n	  <li class="nav-item mb-2"><a href="<?php echo App::Config()->baseUrl("/concept-of-development"); ?>" class="nav-link p-0 text-muted">Ideas and Concepts</a></li>\n	</ul>	\n  </div>\n\n  <div class="col-6 col-md-2 mb-3">\n	<h5>Help</h5>\n	<ul class="nav flex-column">\n	  <li class="nav-item mb-2"><a href="<?php echo App::Config()->baseUrl("/admin"); ?>" class="nav-link p-0 text-muted">Admin Login</a></li>\n	  <li class="nav-item mb-2"><a href="https://www.apprain.org/general-help-center" class="nav-link p-0 text-muted" target="_blamk">Documentations</a></li>\n	</ul>\n</div>', '', '', 'Yes', 'h_link', 'Snip', 0),
(57, 0, 'API Development', 'API Development', '', 'api-development', 'API Development', '<p>Here, creating an API is fairly easy. It is prepared in two steps.</p>\n\n<p><strong>Step 1:</strong><br />\nActivate the Ethical component under the Applications page in the Admin Panel after logging in.</p>\n\n<p><strong>Step 2: </strong><br />\nGo to any of your components and create a helper called service. Now each function in the helper serves as an API call.</p>\n\n<p>After the two steps, go to user management and create a user because credentials are required to create a token for the call to the API. Now let&#39;s look at a step-by-step guideline.</p>\n\n<p><strong>Activate the Ethical Component:</strong><br />\nLog in to the admin panel, go to the Applications menu, find the ethical component, and activate it if it is not already activated.</p>\n\n<p><code>Admin Panel &gt; Applications &gt; Ethical (Activate)</code></p>\n\n<p><u>Note:</u> The Messenger component should also be enabled so that we can replicate the API there.</p>\n\n<p><strong>Create Api User: </strong><br />\nGo to User Management and create a user to use the API service. For example, the user name is &quot;apiuser&quot; and the password is &quot;Api@24H7&quot;</p>\n\n<p><strong>Create Service</strong><br />\nGo to the following location in the messenger component&#39;s helper directory.</p>\n\n<p><code>component/messenger/helpers</code></p>\n\n<p>Create the file service.php and the following classes if they don&#39;t already exist.</p>\n\n<pre>\nclass Component_Messenger_Helpers_Service extends appRain_Base_Objects\n{\n}</pre>\n\n<p>Now let&#39;s create the function below in the service class as test service.</p>\n\n<pre>\npublic function getMyPetName($data){\n  $type = isset($data[&#39;type&#39;]) ? $data[&#39;type&#39;] : &#39;&#39;;\n  switch($type){\n    case &#39;animal&#39;:\n      return array(&#39;state&#39;=&gt;&#39;100&#39;,&#39;petname&#39;=&gt;&#39;Dog&#39;);\n    case &#39;bird&#39;:\n      return array(&#39;state&#39;=&gt;&#39;100&#39;,&#39;petname&#39;=&gt;&#39;Cockatiel&#39;);			\n    default:\n      return array(&#39;state&#39;=&gt;&#39;101&#39;,&#39;petname&#39;=&gt;&#39;&#39;);\n}</pre>\n\n<p>Thats all our API server has ready; if we want to know an animal, it should return &quot;Dog&quot; and for a bird, it will return &quot;Cockatiel&quot;. In both cases, it will return the state code &quot;100&quot;. For other requests, it will return state code &quot;101&quot;. It is a sample setup, but we can do it as needed.</p>\n\n<p><strong>API Call </strong></p>\n\n<p>For an API call, we have two basic addresses: one for authorization and another for the final call to receive data. For example, if project address is www.example.com the authentication and data exchange addresses will be as follows:</p>\n\n<p><code>https://www.example.com/ethical/auth<br />\nhttps://www.example.com/ethical/exchange</code></p>\n\n<p><em>Crate Token:</em><br />\nFollow the below script to create an authentication token</p>\n\n<pre>\n$AUTH_URI = &quot;https://www.example.com/ethical/auth&quot;\n$DATA_EXCHANGE_URI = &quot;https://www.example.com/ethical/exchange&quot;\n\n$data = array(\n	&quot;username&quot;=&gt;&quot;apiuser&quot;,\n	&quot;password&quot;=&gt;&quot;Api@24H7&quot;\n);\n$response = httpPost($AUTH_URI ,$data);\n$result = json_decode($response,true);\n\n$token = $result[&#39;token&#39;];\n$timestamp = $result[&#39;timestamp&#39;];</pre>\n\n<p><em>Do API Call<strong>: </strong></em><br />\nIn the last step, we received a token and a time stamp that we will use to send the reques. There are specific parameters that must be sent during a call; see the list of important information below.</p>\n\n<ol>\n	<li>Component containing the service class sent in the request array at index &#39;com&#39;</li>\n	<li>The service method, which we send in the &quot;action&quot; index, is the second important parameter.</li>\n	<li>The token and timestamp are sent in the request received during the previous stage.</li>\n	<li>Other parameters should be given as needed.</li>\n</ol>\n\n<pre>\n$post = array();\n$post[&#39;token&#39;] = $result[&#39;token&#39;];\n$post[&#39;timestamp&#39;] = $result[&#39;timestamp&#39;];\n$post[&#39;com&#39;] = &#39;Messenger&#39;;\n$post[&#39;action&#39;] = &quot;getMyPetName&quot;;\n$post[&#39;type&#39;] = &quot;animal&quot;;\n\n$response = httpPost($DATA_EXCHANGE_URI ,$post);\n$result = json_decode($response,true);\nprint_r($result)</pre>\n\n<p>Return value</p>\n\n<pre>\nArray\n(\n    [state] =&gt; 100\n    [petname] =&gt; Dog\n    [token] =&gt; ezEyMzQ1Njc4OTAxMjoyOjE2ODE5MjM3NjJ9\n    [timestamp] =&gt; 1681923762\n    [status] =&gt; 1\n)</pre>\n\n<p>Now see the full script with the additional calls</p>\n\n<pre>\n$AUTH_URI = "https://www.example.com/ethical/auth";\n$DATA_EXCHANGE_URI = "https://www.example.com/ethical/exchange";\n\n## Step 1: Create the token\n$data = array(\n	"username"=>"apiuser",\n	"password"=>"Api@24H7"\n);\n$response = httpPost($AUTH_URI ,$data);\n$result = json_decode($response,true);\n\n$token = $result[''token''];\n$timestamp = $result[''timestamp''];\n\n## Step 2: \n# Call 1\n$post = array();\n$post[''token''] = $result[''token''];\n$post[''timestamp''] = $result[''timestamp''];\n$post[''com''] = ''Messenger'';\n$post[''action''] = "getMyPetName";\n$post[''type''] = "animal";\n\n$response = httpPost($DATA_EXCHANGE_URI ,$post);\n$result = json_decode($response,true);\nprint_r($result);\n\n# Call 2\n$post = array();\n$post[''token''] = $result[''token''];\n$post[''timestamp''] = $result[''timestamp''];\n$post[''com''] = ''Messenger'';\n$post[''action''] = "getMyPetName";\n$post[''type''] = "bird";\n\n$response = httpPost($DATA_EXCHANGE_URI ,$post);\n$result = json_decode($response,true);\nprint_r($result);\n\n# Call 3\n$post = array();\n$post[''token''] = $result[''token''];\n$post[''timestamp''] = $result[''timestamp''];\n$post[''com''] = ''Messenger'';\n$post[''action''] = "getMyPetName";\n$post[''type''] = "other";\n\n$response = httpPost($DATA_EXCHANGE_URI ,$post);\n$result = json_decode($response,true);\nprint_r($result);\n\n\n## Submit request\nfunction httpPost($url, $data)\n{\n  $curl = curl_init($url);\n  curl_setopt($curl, CURLOPT_POST, true);\n  curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));\n  curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);\n  $response = curl_exec($curl);\n  curl_close($curl); \n  return $response;\n}</pre>\n', '', '', 'Yes', 'smart_h_link', 'Content', 0),
(59, 0, 'Contact Us', '', '', 'contact-us', 'Contact Us', '<p>\n	Duis arcu elit, rutrum a interdum quis, vulputate et diam. Mauris eleifend cursus tortor. Sed ut leo quis nisi vehicula sagittis. Maecenas sed nisl at quam vulputate mattis in nec sapien. Etiam vel massa in eros sodales bibendum. Vestibulum ut urna cursus lectus sodales facilisis vel vitae sem. Aenean a nisl ut nulla ullamcorper tristique non quis sem.<br />\n	<br />\n	<strong>Vestibulum at orci a velit varius</strong><br />\n	45/B consectetur quis sit amet<br />\n	diam. <br />\n	phasellus@eget felis.purus.</p>\n', '', '', 'Yes', 'h_link', 'Content', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sconfigs`
--

CREATE TABLE `[[dbprefix]]sconfigs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fkey` int(11) NOT NULL DEFAULT '0',
  `soption` text NOT NULL,
  `svalue` text NOT NULL,
  `sort_order` varchar(5) NOT NULL,
  `section` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=224 ;

--
-- Dumping data for table `[[dbprefix]]sconfigs`
--

INSERT INTO `[[dbprefix]]sconfigs` VALUES
(1, 0, 'theme', 'whitecloud', '0', 'hidden'),
(2, 0, 'site_logo', '', '', 'themesettings'),
(3, 0, 'default_pagination', '50', '19', 'general'),
(4, 0, 'time_zone', 'Asia/Dhaka', '23', 'general'),
(5, 0, 'copy_right_text', 'Copyright Apprain Technologies, www.apprain.org.', '', 'general'),
(6, 0, 'site_title', '[[site_name]]', '', ''),
(7, 0, 'admin_title', '[[site_name]] Admin', '', ''),
(8, 0, 'admin_email', '[[admin_email]]', '', ''),
(9, 0, 'activity_widget', 'Yes', '', ''),
(10, 0, 'leave_amessage_widget', 'Yes', '', ''),
(11, 0, 'disable_quick_links', 'No', '', 'themesettings'),
(12, 0, 'whitecloud_disable_footer', 'No', '', 'themesettings'),
(13, 0, 'whitecloud_background_position', 'bgstartfromtop', '', 'themesettings'),
(15, 0, 'appslidesettings_displaymode', 'ajaxbased', '', 'appslidesettings'),
(18, 0, 'site_homepage_layout', 'default', '', 'themesettings'),
(19, 0, 'site_pageview_layout', 'right_column_layout', '', 'themesettings'),
(20, 0, 'site_defaultview_layout', 'default', '', 'themesettings'),
(21, 0, 'flash_file_uploader', 'Yes', '', ''),
(31, 0, 'add_new_page_in_menu_automarically', 'Yes', '', 'opts'),
(32, 0, 'disable_page_meta_options', 'Yes', '', 'opts'),
(33, 0, 'disable_menu_icon', 'No', '', 'opts'),
(34, 0, 'quick_navigation_widget', 'Yes', '', 'opts'),
(35, 0, 'currency', 'BDT', '', 'opts'),
(36, 0, 'is_site_alive', 'Yes', '', 'opts'),
(37, 0, 'large_image_width', '500', '', 'opts'),
(38, 0, 'large_image_height', '500', '', 'opts'),
(39, 0, 'rich_text_editor', 'Yes', '', 'opts'),
(40, 0, 'emailsetup_enabled', 'No', '', 'opts'),
(41, 0, 'emailsetup_host', 'localhost', '', 'opts'),
(42, 0, 'emailsetup_port', '25', '', 'opts'),
(43, 0, 'emailsetup_username', '', '', 'opts'),
(44, 0, 'emailsetup_password', '', '', 'opts'),
(52, 0, 'support_email', 'support@apprain.com', '', 'general'),
(207, 0, 'admin_landing_page', 'admin/introduction', '', 'opts'),
(128, 0, 'business_date', '', '', 'businessdate'),
(129, 0, 'business_time', '', '', 'businessdate'),
(154, 0, 'fileresource_id', '', '', 'opts'),
(155, 0, 'db_version', '2.5.4', '', 'opts'),
(158, 0, 'time_zone_padding', '', '', 'opts'),
(181, 0, 'language', 'default', '', ''),
(186, 0, 'adminpanel_quick_launch', '{"/admin/manage":{"title":"Manage Users","iconpath":"/themeroot/admin/images/icons/info.jpg","mylink":"/admin/manage","fetchtype":"URL"},"/appreport/executor":{"title":"Reports","iconpath":"/component/appreport/interface_builder/icon.jpg","mylink":"/appreport/executor","fetchtype":"FilePath"},"/page/manage-static-pages":{"title":"Static Page","iconpath":"/themeroot/admin/images/icons/info.jpg","mylink":"/page/manage-static-pages","fetchtype":"URL"},"/page/manage-dynamic-pages":{"title":"Dynamic Page","iconpath":"/themeroot/admin/images/icons/info.jpg","mylink":"/page/manage-dynamic-pages","fetchtype":"URL"}}', '', ''),
(191, 0, 'quick_navigation_show_calander', 'Yes', '', 'opts'),
(192, 0, 'emailsetup_from_email', '', '', 'opts'),
(209, 0, 'logo', '', '', 'general'),
(214, 0, 'last_synced', '', '', ''),
(215, 0, 'last_message_board_synced', '', '', ''),
(220, 0, 'contactussettings_title', 'Contact Us', '', 'contactussettings'),
(221, 0, 'contactussettings_replay_email_title', '', '', 'contactussettings'),
(222, 0, 'contactussettings_replay_email', '', '', 'contactussettings'),
(223, 0, 'contactussettings_create_sitemenu', 'Yes', '', 'contactussettings');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
