$(document).ajaxSend(function() {
  $("#ajax-loading").show();
});
$(document).ajaxComplete(function() {
  $("#ajax-loading").hide();
});
$(function() {
  var newHash = "";
  $("body").delegate("a", "click", function() {
    var link = $(this).attr("href");
    if (typeof link !== "undefined" && link !== "" && link.indexOf("javascript:") !== 0 && link !== "#" && typeof link !== "undefined" && typeof $(this).attr("onclick") === "undefined" && !$(this).hasClass("nohtml") && $(this).attr("target") !== "_blank") {
      if ($(this).attr("rel") !== "prettyPhoto") {
        if (link.indexOf(jsWebPath) > -1) {
          window.location.hash = link.substring(jsWebPath.length + 1);
          return false;
        }
      } else {
        window.location.hash = $(this).attr("rel");
        return false;
      }
    }
  });
  $("body").delegate("form", "submit", function(e) {
    var $file = $(this).find("input[type=file]");
    if ($(this).attr("name") !== "login" && $(this).attr("name") !== "export" && (!$file || !$file.val() || $file.val() === "") && (typeof $(this).attr("target") === "undefined" || $(this).attr("target") === "")) {
      var postData = $(this).serializeArray();
      var formURL = $(this).attr("action");
      if (formURL.indexOf("javascript:") !== 0) {
        $.ajax(
          {
            url: formURL,
            type: "POST",
            async: false,
            data: postData,
            success: function(data, status, jqXHR) {
              loadContentData(data);
              window.location.hash = "";
            },
            error(jqXHR, status, errorThrown) {
              alert(errorThrown);
            }
          }
        );
        e.preventDefault();
      }
    }
  });
  $(window).bind("hashchange", function() {
    newHash = window.location.hash.substring(1);
    if (newHash && newHash.indexOf("prettyPhoto") !== 0 && newHash.indexOf(".php") > -1) {
      loadContentPage$1(jsWebPath + "/" + newHash);
      return false;
    }
  });
  $(window).trigger("hashchange");
});
$(document).ajaxSuccess(function() {
  var title = window.location.hash.replace(/[#$&=_]/g, "");
  title = title.replace(/\?.*/gi, "");
  title = title.replace(/\b(?:action|type|tab|.php|\[\]|[a-z]* id|[0-9]*)\b/gi, "");
  title = title.trim();
  if (title === "index") {
    document.title = jsSiteTitle + " | " + jsHomeTitle;
  } else if (title === "browse") {
    document.title = jsSiteTitle + " | " + jsBrowseMusicTitle;
  } else if (title === "albums") {
    document.title = jsSiteTitle + " | " + jsAlbumTitle;
  } else if (title === "artists") {
    document.title = jsSiteTitle + " | " + jsArtistTitle;
  } else if (title === "song") {
    document.title = jsSiteTitle + " | " + jsSongTitle;
  } else if (title === "democratic") {
    document.title = jsSiteTitle + " | " + jsDemocraticTitle;
  } else if (title === "labels") {
    document.title = jsSiteTitle + " | " + jsLabelsTitle;
  } else if (title === "mashup") {
    document.title = jsSiteTitle + " | " + jsDashboardTitle;
  } else if (title === "podcast") {
    document.title = jsSiteTitle + " | " + jsPodcastTitle;
  } else if (title === "podcast_episode") {
    document.title = jsSiteTitle + " | " + jsPodcastEpisodeTitle;
  } else if (title === "radio") {
    document.title = jsSiteTitle + " | " + jsRadioTitle;
  } else if (title === "video") {
    document.title = jsSiteTitle + " | " + jsVideoTitle;
  } else if (title === "localplay") {
    document.title = jsSiteTitle + " | " + jsLocalplayTitle;
  } else if (title === "random") {
    document.title = jsSiteTitle + " | " + jsRandomTitle;
  } else if (title === "playlist") {
    document.title = jsSiteTitle + " | " + jsPlaylistTitle;
  } else if (title === "smartplaylist") {
    document.title = jsSiteTitle + " | " + jsSmartPlaylistTitle;
  } else if (title === "search") {
    document.title = jsSiteTitle + " | " + jsSearchTitle;
  } else if (title === "preferences") {
    document.title = jsSiteTitle + " | " + jsPreferencesTitle;
  } else if (title === "stats") {
    document.title = jsSiteTitle + " | " + jsStatisticsTitle;
  } else if (title === "upload") {
    document.title = jsSiteTitle + " | " + jsUploadTitle;
  } else if (title === "admin/catalog" || title === "admin/index") {
    document.title = jsSiteTitle + " | " + jsAdminCatalogTitle;
  } else if (title === "admin/users") {
    document.title = jsSiteTitle + " | " + jsAdminUserTitle;
  } else if (title === "admin/mail") {
    document.title = jsSiteTitle + " | " + jsAdminMailTitle;
  } else if (title === "admin/access") {
    document.title = jsSiteTitle + " | " + jsAdminManageAccessTitle;
  } else if (title === "admin/preferences" || title === "admin/system") {
    document.title = jsSiteTitle + " | " + jsAdminPreferencesTitle;
  } else if (title === "admin/modules") {
    document.title = jsSiteTitle + " | " + jsAdminManageModulesTitle;
  } else if (title === "admin/filter") {
    document.title = jsSiteTitle + " | " + jsAdminFilterTitle;
  } else if (title === "admin/license") {
    document.title = jsSiteTitle + " | " + jsAdminLicenseTitle;
  } else {
    document.title = jsSiteTitle;
  }
});
function ajaxPost(url2, input, source2) {
  if ($(source2)) {
    $(source2).off("click");
  }
  $.ajax(url2, { success: processContents, type: "post", data: $("#" + input).serialize() });
}
function ajaxPut$1(url2, source2) {
  if ($(source2)) {
    $(source2).off("click");
  }
  $.ajax(url2, { success: processContents, type: "post", dataType: "xml" });
}
function ajaxState(url2, input) {
  $.ajax({
    url: url2,
    type: "POST",
    data: $("#" + input).serialize(true),
    success: processContents
  });
}
function processContents(data) {
  $(data).find("content").each(function() {
    $("[id=" + $(this).attr("div")).html($(this).text());
  });
}
function loadContentData(data, status, jqXHR) {
  var $response = $(data);
  if ($response.find("#guts").length === 0) {
    $("body").undelegate("a");
    $("body").undelegate("form");
    $("body").empty().append($response);
  } else {
    var $mainContent = $("#content");
    var $pageWrap = $("#guts");
    $mainContent.empty().append($response.find("#guts"));
    $mainContent.fadeIn(200, function() {
      $pageWrap.animate({
        height: $mainContent.height() + "px"
      });
    });
    $("a[rel^='prettyPhoto']").prettyPhoto({
      social_tools: false,
      deeplinking: false
    });
    initTabs();
  }
}
function loadContentPage$1(url2) {
  var $mainContent = $("#content");
  $mainContent.find("#guts").fadeOut(200, function() {
    $.get(url2, function(data, status, jqXHR) {
      loadContentData(data);
    }, "html");
  });
}
var sseSource = null;
function sse_worker(url) {
  if (typeof EventSource !== "undefined") {
    sseSource = new EventSource(url);
    sseSource.onmessage = function(event) {
      eval(event.data);
    };
    sseSource.onopen = function() {
      displayNotification("Connected through Server-Sent Events, processing...", 5e3);
    };
    sseSource.onerror = function() {
      displayNotification("Server-Sent Events connection error. Re-connection...", 5e3);
    };
  } else {
    $.get(url + "&html=1", function(data) {
      $("#guts").append(data);
    }, "html");
  }
}
function stop_sse_worker() {
  if (sseSource !== null) {
    sseSource.close();
    sseSource = null;
  }
}
function display_sse_error(error) {
  displayNotification("ERROR: " + error, 1e4);
}
const Ajax = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  ajaxPost,
  ajaxPut: ajaxPut$1,
  ajaxState,
  display_sse_error,
  loadContentData,
  loadContentPage: loadContentPage$1,
  processContents,
  sse_worker,
  stop_sse_worker
}, Symbol.toStringTag, { value: "Module" }));
function topTracksIndexes() {
  var index = 1;
  $("#top_tracks .cel_play_content").each(function() {
    $(this).html(index++);
  });
}
const Artist = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  topTracksIndexes
}, Symbol.toStringTag, { value: "Module" }));
$(document).ready(function() {
  initTabs$1();
  $.ajaxSetup({
    // Enable caching of AJAX responses, including script and jsonp
    cache: true
  });
  $("#notification").click(function() {
    clearNotification();
  });
});
$(function() {
  var rightmenu = $("#rightbar");
  var pos = rightmenu.offset();
  if (rightmenu.hasClass("rightbar-float")) {
    $(window).scroll(function() {
      var rightsubmenu = $("#rightbar .submenu");
      if ($(this).scrollTop() > pos.top) {
        rightmenu.addClass("fixedrightbar");
        rightsubmenu.addClass("fixedrightbarsubmenu");
      } else if ($(this).scrollTop() <= pos.top && rightmenu.hasClass("fixedrightbar")) {
        rightmenu.removeClass("fixedrightbar");
        rightsubmenu.removeClass("fixedrightbarsubmenu");
      } else {
        rightmenu.offset({ left: pos.left, top: pos.top });
      }
    });
  }
});
$(document).ready(function() {
  if (jsAmpConfigGeolocation) {
    geolocate_user();
  }
  if (jsAmpConfigLibitemContextmenu) {
    let libitem_action2 = function(item, action2) {
      var iinfo = item.attr("id").split("_", 2);
      var object_type = iinfo[0];
      var object_id = iinfo[1];
      if (typeof action2 !== "undefined" && action2 !== "") {
        ajaxPut(jsAjaxUrl + action2 + "&object_type=" + object_type + "&object_id=" + object_id);
      } else {
        showPlaylistDialog(this, object_type, object_id);
      }
    };
    var libitem_action = libitem_action2;
    $.contextMenu({
      selector: ".libitem_menu",
      items: {
        play: { name: jsPlay, callback: function(key, opt) {
          libitem_action2(opt.$trigger, "?page=stream&action=directplay");
        } },
        play_next: { name: jsPlayNext, callback: function(key, opt) {
          libitem_action2(opt.$trigger, "?page=stream&action=directplay&playnext=true");
        } },
        play_last: { name: jsPlayLast, callback: function(key, opt) {
          libitem_action2(opt.$trigger, "?page=stream&action=directplay&append=true");
        } },
        add_tmp_playlist: { name: jsAddTmpPlaylist, callback: function(key, opt) {
          libitem_action2(opt.$trigger, "?action=basket");
        } },
        add_playlist: { name: jsAddPlaylist, callback: function(key, opt) {
          libitem_action2(opt.$trigger, "");
        } }
      }
    });
  }
});
var notificationTimeout = null;
function clearNotification() {
  clearTimeout(notificationTimeout);
  notificationTimeout = null;
  $("#notification").addClass("notification-out");
}
function displayNotification$1(message, timeout) {
  if (notificationTimeout !== null || !message) {
    clearNotification();
  }
  if (message) {
    if ($("#webplayer").css("display") !== "block") {
      $("#notification").css("bottom", "20px");
    } else {
      $("#notification").css("bottom", "120px");
    }
    $("#notification-content").html(message);
    $("#notification").removeClass("notification-out");
    notificationTimeout = setTimeout(function() {
      clearNotification();
    }, timeout);
  }
}
function initTabs$1() {
  $(".default_hidden").hide();
  $("#tabs li").click(function() {
    $("#tabs li").removeClass("tab_active");
    $(this).addClass("tab_active");
    $(".tab_content").hide();
    var selected_tab = $(this).find("a").attr("href");
    $(selected_tab).fadeIn();
    return false;
  });
}
function flipField(field) {
  if ($(field).disabled === false) {
    $(field).disabled = true;
  } else {
    $(field).disabled = false;
  }
}
function updateText(field, value) {
  $("#" + field).html(value);
}
function toggleVisible(element2) {
  var target = $("#" + element2);
  if (target.is(":visible")) {
    target.hide();
  } else {
    target.show();
  }
}
function delayRun(element, time, method, page, source) {
  var function_string = method + "('" + page + "','" + source + "')";
  var action = function() {
    eval(function_string);
  };
  if (element.zid) {
    clearTimeout(element.zid);
  }
  element.zid = setTimeout(action, time);
}
function reloadUtil(target) {
  $("#util_iframe").prop("src", target);
}
function reloadDivUtil(target) {
  var $util = $("#util_div");
  $.get(target, function(data, status, xhr) {
    var $response = $(data);
    $util.empty().append($response);
  });
}
function reloadRedirect(target) {
  window.location = target;
}
function NavigateTo$1(url2) {
  if (jsAmpConfigAjaxLoad) {
    window.location.hash = url2.substring(jsWebPath.length + 1);
  } else {
    window.location.href = url2;
  }
}
function getCurrentPage() {
  if (jsAmpConfigAjaxLoad) {
    if (window.location.hash.length > 0) {
      var wpage = window.location.hash.substring(1);
      if (wpage !== "prettyPhoto") {
        return btoa(wpage);
      } else {
        return "";
      }
    }
    return btoa(window.location.href.substring(jsWebPath.length + 1));
  } else {
    return btoa(window.location.href);
  }
}
const Base = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  NavigateTo: NavigateTo$1,
  clearNotification,
  delayRun,
  displayNotification: displayNotification$1,
  flipField,
  getCurrentPage,
  initTabs: initTabs$1,
  reloadDivUtil,
  reloadRedirect,
  reloadUtil,
  toggleVisible,
  updateText
}, Symbol.toStringTag, { value: "Module" }));
$.widget("custom.catcomplete", $.ui.autocomplete, {
  _renderItem: function(ul, item) {
    var itemhtml = "";
    if (item.link !== "") {
      itemhtml += "<a href='" + item.link + "'>";
    } else {
      itemhtml += "<a>";
    }
    if (item.image !== "") {
      itemhtml += "<img src='" + item.image + "' class='searchart' alt=''>";
    }
    itemhtml += "<span class='searchitemtxt'>" + item.label + (item.album ? " - " + item.album : "") + (item.rels === "" ? "" : " - " + item.rels) + "</span>";
    itemhtml += "</a>";
    return $("<li class='ui-menu-item'>").data("ui-autocomplete-item", item).append(itemhtml + "</li>").appendTo(ul);
  },
  _renderMenu: function(ul, items) {
    var that = this, currentType = "";
    $.each(items, function(index, item) {
      if (item.type !== currentType) {
        $("<li class='ui-autocomplete-category'>").data("ui-autocomplete-item", item).append(item.type + "</li>").appendTo(ul);
        currentType = item.type;
      }
      that._renderItem(ul, item);
    });
  }
});
$(function() {
  var minSearchChars = 2;
  $("#searchString").bind("keydown", function(event2) {
    if (event2.keyCode === $.ui.keyCode.TAB && $(this).data("custom-catcomplete").widget().is(":visible")) {
      event2.preventDefault();
    }
  }).bind("click", function(event2) {
    if ($(this).val().length >= minSearchChars) {
      $(this).data("custom-catcomplete").search();
    }
  }).catcomplete({
    source: function(request, response) {
      $.getJSON(jsAjaxUrl, {
        page: "search",
        action: "search",
        target: $("#searchStringRule").val(),
        search: request.term,
        xoutput: "json"
      }, response);
    },
    search: function() {
      if ($(this).val().length < minSearchChars) {
        return false;
      }
    },
    focus: function() {
      return false;
    },
    select: function(event2, ui) {
      if (event2.keyCode === $.ui.keyCode.ENTER) {
        NavigateTo(ui.item.link);
      }
      return false;
    }
  });
});
const Search = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null
}, Symbol.toStringTag, { value: "Module" }));
$("#sidebar-header").click(function() {
  if (jsAmpConfigSidebarHideSwitcher) return false;
  var newstate = "collapsed";
  if ($("#sidebar-header").hasClass("sidebar-header-collapsed")) {
    newstate = "expanded";
  }
  if (newstate != "expanded") {
    $("#content").addClass("content-left-wild", 600);
  } else {
    $("#content").removeClass("content-left-wild", 1e3);
  }
  $("#sidebar").hide(500, function() {
    if (newstate == "expanded") {
      $("#sidebar-content-light").removeClass("sidebar-content-light-collapsed");
      $("#sidebar-content").removeClass("sidebar-content-collapsed");
      $("#sidebar-header").removeClass("sidebar-header-collapsed");
    } else {
      $("#sidebar-content").addClass("sidebar-content-collapsed");
      $("#sidebar-header").addClass("sidebar-header-collapsed");
      $("#sidebar-content-light").addClass("sidebar-content-light-collapsed");
    }
    $("#sidebar").show(500);
  });
  Cookies.set("sidebar_state", newstate, { jsCookieString });
});
function ToggleRightbarVisibility() {
  if ($("#rightbar").is(":visible")) {
    $("#rightbar").slideUp();
  } else {
    $("#rightbar").slideDown();
  }
}
function RightbarInit() {
  if (jsBasketCount > 0 || jsAmpConfigPlayType === "localplay") {
    $("#content").removeClass("content-right-wild", 500);
    $("#footer").removeClass("footer-wild", 500);
    $("#rightbar").removeClass("hidden");
    $("#rightbar").show("slow");
  } else {
    $("#content").addClass("content-right-wild", 500);
    $("#footer").addClass("footer-wild", 500);
    $("#rightbar").hide("slow");
  }
}
const Sidebar = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  RightbarInit,
  ToggleRightbarVisibility
}, Symbol.toStringTag, { value: "Module" }));
(/* @__PURE__ */ new Date()).getTime();
var refresh_slideshow_interval = jsPrefExistsFlickrApiKey ? jsAmpConfigSlideshowTime : 0;
var iSlideshow = null;
var tSlideshow = null;
$("#aslideshow").click(function(e) {
  if (!$(e.target).hasClass("rhino-btn")) {
    update_action();
  }
});
function init_slideshow_check() {
  if (refresh_slideshow_interval > 0) {
    if (tSlideshow != null) {
      clearTimeout(tSlideshow);
    }
    tSlideshow = window.setTimeout(function() {
      init_slideshow_refresh();
    }, refresh_slideshow_interval * 1e3);
  }
}
function swap_slideshow() {
  if (iSlideshow == null) {
    init_slideshow_refresh();
  } else {
    stop_slideshow();
  }
}
function init_slideshow_refresh() {
  if ($("#webplayer").is(":visible")) {
    clearTimeout(tSlideshow);
    tSlideshow = null;
    $("#aslideshow").height($(document).height()).css({ "display": "inline" });
    iSlideshow = true;
    refresh_slideshow();
  }
}
function refresh_slideshow() {
  if (iSlideshow != null) {
    ajaxPut(jsAjaxUrl + "?page=index&action=slideshow", "");
  } else {
    init_slideshow_check();
  }
}
function stop_slideshow() {
  if (iSlideshow != null) {
    iSlideshow = null;
    $("#aslideshow").css({ "display": "none" });
  }
}
function update_action() {
  (/* @__PURE__ */ new Date()).getTime();
  stop_slideshow();
  init_slideshow_check();
}
$(document).mousemove(function(e) {
  if (iSlideshow == null) {
    update_action();
  }
});
$(document).ready(function() {
  init_slideshow_check();
});
const Slideshow = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  init_slideshow_check,
  init_slideshow_refresh,
  refresh_slideshow,
  stop_slideshow,
  swap_slideshow,
  update_action
}, Symbol.toStringTag, { value: "Module" }));
function showFilters(element2, string, group_release) {
  if (group_release === true) {
    var link = $("#browse-options-link" + string);
    var hidelink = $("#browse-options-hidelink" + string);
    var content = $("#browse-options-content" + string);
  } else {
    var link = $(".browse-options-link");
    var hidelink = $(".browse-options-hidelink");
    var content = $(".browse-options-content");
  }
  link.hide();
  hidelink.show();
  content.show();
}
function hideFilters(element2, string, group_release) {
  if (group_release === true) {
    var link = $("#browse-options-link" + string);
    var hidelink = $("#browse-options-hidelink" + string);
    var content = $("#browse-options-content" + string);
  } else {
    var link = $(".browse-options-link");
    var hidelink = $(".browse-options-hidelink");
    var content = $(".browse-options-content");
  }
  link.show();
  hidelink.hide();
  content.hide();
}
var closeplaylist;
function overlayclickclose() {
  if (closeplaylist) {
    $("#playlistdialog").dialog("close");
  }
  closeplaylist = 1;
}
function showPlaylistDialog$1(e, item_type, item_ids) {
  $("#playlistdialog").dialog("close");
  var parent = window;
  parent.itemType = item_type;
  parent.contentUrl = jsAjaxServer + "/edit.server.php?action=show_edit_playlist&object_type=" + item_type + "&id=" + item_ids;
  parent.editDialogId = '<div id="playlistdialog"></div>';
  $(parent.editDialogId).dialog({
    modal: false,
    dialogClass: "playlistdialogstyle",
    resizable: false,
    draggable: false,
    width: 300,
    height: 100,
    autoOpen: false,
    position: {
      my: "left+10 top",
      of: e
    },
    open() {
      closeplaylist = 1;
      $(document).bind("click", overlayclickclose);
      $(this).load(parent.contentUrl, function() {
        $("#playlistdialog").focus();
      });
    },
    focus() {
      closeplaylist = 0;
    },
    close(e2) {
      $(document).unbind("click");
      $(this).empty();
      $(this).dialog("destroy");
    }
  });
  $("#playlistdialog").dialog("open");
  closeplaylist = 0;
}
function handlePlaylistAction(url2, id) {
  ajaxPut(url2, id);
  $("#playlistdialog").dialog("close");
}
function createNewPlaylist(title, url2, id) {
  var plname = window.prompt(title, "");
  if (plname !== null) {
    url2 += "&name=" + plname;
    handlePlaylistAction(url2, id);
  }
}
var closeshare;
function shoverlayclickclose(e) {
  if (closeshare) {
    $("#sharedialog").dialog("close");
  }
  closeshare = 1;
}
var closebroadcasts;
function showBroadcastsDialog(e) {
  $("#broadcastsdialog").dialog("close");
  var parent = window;
  parent.contentUrl = jsAjaxServer + "/ajax.server.php?page=player&action=show_broadcasts";
  parent.editDialogId = '<div id="broadcastsdialog"></div>';
  $(parent.editDialogId).dialog({
    modal: false,
    dialogClass: "broadcastsdialogstyle",
    resizable: false,
    draggable: false,
    width: 150,
    height: 70,
    autoOpen: false,
    position: {
      my: "left-180 top",
      of: e
    },
    open() {
      closebroadcasts = 1;
      $(document).bind("click", broverlayclickclose);
      $(this).load(parent.contentUrl, function() {
        $("#broadcastsdialog").focus();
      });
    },
    focus() {
      closebroadcasts = 0;
    },
    close(e2) {
      $(document).unbind("click");
      $(this).empty();
      $(this).dialog("destroy");
    }
  });
  $("#broadcastsdialog").dialog("open");
  closebroadcasts = 0;
}
function broverlayclickclose() {
  if (closebroadcasts) {
    $("#broadcastsdialog").dialog("close");
  }
  closebroadcasts = 1;
}
function handleBroadcastAction(url2, id) {
  ajaxPut(url2, id);
  $("#broadcastsdialog").dialog("close");
}
function showShareDialog(e, object_type, object_id) {
  $("#sharedialog").dialog("close");
  var parent = window;
  parent.contentUrl = jsAjaxServer + "/ajax.server.php?page=browse&action=get_share_links&object_type=" + object_type + "&object_id=" + object_id;
  parent.editDialogId = '<div id="sharedialog"></div>';
  $(parent.editDialogId).dialog({
    modal: false,
    dialogClass: "sharedialogstyle",
    resizable: false,
    draggable: false,
    width: 200,
    height: 90,
    autoOpen: false,
    position: {
      my: "left+10 top",
      of: e
    },
    open() {
      closeshare = 1;
      $(document).bind("click", shoverlayclickclose);
      $(this).load(parent.contentUrl, function() {
        $("#sharedialog").focus();
      });
    },
    focus() {
      closeshare = 0;
    },
    close(e2) {
      $(document).unbind("click");
      $(this).empty();
      $(this).dialog("destroy");
    }
  });
  $("#sharedialog").dialog("open");
  closeshare = 0;
}
function handleShareAction(url2) {
  window.open(url2);
  $("#sharedialog").dialog("close");
}
function showEditDialog(edit_type, edit_id, edit_form_id, edit_title, refresh_row_prefix, argument_string) {
  var parent = window;
  parent.editFormId = "form#" + edit_form_id;
  parent.contentUrl = jsAjaxServer + "/edit.server.php?action=show_edit_object&id=" + edit_id + "&type=" + edit_type;
  parent.saveUrl = jsAjaxServer + "/edit.server.php?action=edit_object&id=" + edit_id + "&type=" + edit_type;
  parent.editDialogId = '<div id="editdialog"></div>';
  parent.refreshRowPrefix = refresh_row_prefix;
  parent.editType = edit_type;
  parent.editId = edit_id;
  $.when($.ajax(jsAjaxServer + "/ajax.server.php?page=tag&action=get_tag_map&type=" + edit_type), $.ajax(jsAjaxServer + "/ajax.server.php?page=tag&action=get_labels&type=" + edit_type)).then(function(a1, a2) {
    if (a1[2].status !== 200 || a2[2].status !== 200) {
      displayNotification("Failed to open dialog", 5e3);
    }
    var tag_choices;
    var label_choices;
    tag_choices = $(a1[0]).find("content").text();
    label_choices = $(a2[0]).find("content").text();
    var splitted = tag_choices.split(",");
    parent.editTagChoices = splitted.map($.trim);
    splitted = label_choices.split(",");
    parent.editLabelChoices = splitted.map($.trim);
    parent.dialog_buttons = {};
    parent.dialog_buttons[jsSaveTitle] = function() {
      $.ajax({
        url: parent.saveUrl,
        type: "POST",
        data: $(parent.editFormId).serializeArray(),
        success(resp) {
          $("#editdialog").dialog("close");
          if (parent.refreshRowPrefix !== "") {
            var new_id = $.trim(resp.lastChild.textContent);
            if (new_id == "") {
              new_id = parent.editId;
            }
            var url2 = jsAjaxServer + "/edit.server.php?action=refresh_updated&type=" + parent.editType + "&id=" + new_id + argument_string;
            $("#" + parent.refreshRowPrefix + parent.editId).load(url2, function() {
              $("#" + parent.refreshRowPrefix + parent.editId).attr("id", parent.refreshRowPrefix + new_id);
            });
          } else {
            var reloadp = window.location;
            var hash = window.location.hash.substring(1);
            if (hash && hash.indexOf(".php") > -1) {
              reloadp = jsWebPath + "/" + hash;
            }
            loadContentPage(reloadp);
          }
        },
        error(resp) {
          $("#editdialog").dialog("close");
        }
      });
    };
    parent.dialog_buttons[jsCancelTitle] = function() {
      $("#editdialog").dialog("close");
    };
    $(parent.editDialogId).dialog({
      title: edit_title,
      modal: true,
      dialogClass: "editdialogstyle",
      resizable: false,
      width: 666,
      autoOpen: false,
      show: { effect: "fade", duration: 400 },
      open() {
        $(this).load(parent.contentUrl, function() {
          if ($("#edit_tags").length > 0) {
            $("#edit_tags").tagit({
              allowSpaces: true,
              singleField: true,
              singleFieldDelimiter: ",",
              availableTags: parent.editTagChoices
            });
          }
          if ($("#edit_labels").length > 0) {
            $("#edit_labels").tagit({
              allowSpaces: true,
              singleField: true,
              singleFieldDelimiter: ",",
              availableTags: parent.editLabelChoices
            });
          }
        });
      },
      close(e) {
        $(this).empty();
        $(this).dialog("destroy");
      },
      buttons: dialog_buttons
    });
    $("#editdialog").dialog("open");
  });
}
$(window).resize(function() {
  $("#editdialog").dialog("option", "position", { my: "center", at: "center", of: window });
});
function check_inline_song_edit(type, song) {
  var source2 = "#" + type + "_select_" + song;
  if ($(source2 + " option:selected").val() == -1) {
    $(source2).fadeOut(600, function() {
      $(this).replaceWith('<input id="' + type + '_name" type="text" name="' + type + '_name" value="New ' + type + '" onclick="this.select();" />');
    });
  } else {
    var change_to = $(source2).val();
    $(source2).val(change_to).prop("selected", true);
  }
}
function sortPlaylistRender() {
  var eles = $('tbody[id^="sortableplaylist_"]');
  if (eles !== null) {
    var len = eles.length;
    for (var i = 0; i < len; i++) {
      $("#" + eles[i].id).sortable({
        axis: "y",
        delay: 200
      });
    }
  }
}
$(document).ready(function() {
  sortPlaylistRender();
});
function submitNewItemsOrder(itemId, tableid, rowPrefix, updateUrl, refreshAction) {
  var parent = window;
  parent.itemId = itemId;
  parent.refreshAction = refreshAction;
  var table = document.getElementById(tableid);
  var rowLength = table.rows.length;
  var offset = 0;
  var finalOrder = "";
  if ($("#" + tableid).attr("data-offset")) {
    offset = $("#" + tableid).attr("data-offset");
  }
  for (var i = 0; i < rowLength; ++i) {
    var row = table.rows[i];
    if (row.id !== "") {
      var songid = row.id.replace(rowPrefix, "");
      finalOrder += songid + ";";
    }
  }
  if (finalOrder !== "") {
    $.ajax({
      url: updateUrl,
      type: "GET",
      async: false,
      data: "offset=" + offset + "&order=" + finalOrder,
      success(resp) {
        var url2 = jsAjaxServer + "/refresh_reordered.server.php?action=" + parent.refreshAction + "&id=" + parent.itemId;
        $("#reordered_list_" + parent.itemId).load(url2, function() {
          $("#sortableplaylist_" + parent.itemId).sortable({
            axis: "y",
            delay: 200
          });
        });
      }
    });
  }
}
function getPagePlaySettings() {
  var settings = "";
  var stg_subtitle = document.getElementById("play_setting_subtitle");
  if (typeof stg_subtitle !== "undefined" && stg_subtitle !== null) {
    if (stg_subtitle.value !== "") {
      settings += "&subtitle=" + stg_subtitle.value;
    }
  }
  return settings;
}
function geolocate_user_callback(position) {
  var url2 = jsAjaxUrl + "?page=stats&action=geolocation&latitude=" + position.coords.latitude + "&longitude=" + position.coords.longitude;
  $.get(url2);
}
function geolocate_user$1() {
  if (navigator.geolocation) {
    navigator.geolocation.getCurrentPosition(geolocate_user_callback);
  }
}
function show_selected_license_link(license_select) {
  var license = $("#" + license_select + " option:selected");
  var link = license.attr("data-link");
  if (typeof link !== "undefined") {
    window.open(link);
  }
}
const Tools = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  broverlayclickclose,
  check_inline_song_edit,
  createNewPlaylist,
  geolocate_user: geolocate_user$1,
  geolocate_user_callback,
  getPagePlaySettings,
  handleBroadcastAction,
  handlePlaylistAction,
  handleShareAction,
  hideFilters,
  overlayclickclose,
  shoverlayclickclose,
  showBroadcastsDialog,
  showEditDialog,
  showFilters,
  showPlaylistDialog: showPlaylistDialog$1,
  showShareDialog,
  show_selected_license_link,
  sortPlaylistRender,
  submitNewItemsOrder
}, Symbol.toStringTag, { value: "Module" }));
Object.assign(window, Ajax);
Object.assign(window, Base);
Object.assign(window, Tools);
Object.assign(window, Search);
Object.assign(window, Sidebar);
Object.assign(window, Artist);
Object.assign(window, Slideshow);
