<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9">
	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>XML Sitemap</title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
				<style type="text/css">
					body {
						font-family: Helvetica, Arial, sans-serif;
						font-size: 13px;
						color: #545353;
						background: #fff;
						margin: 0;
						padding: 0;
					}
					a {
						color: #05809e;
						text-decoration: underline;
					}
					a:visited {
						color: #05809e;
					}
					a:hover {
						text-decoration: none;
					}
					th {
						text-align: left;
					}
					#header {
						background-color: #05809e;
						padding: 20px 30px;
					}
					#header h1 {
						font-size: 24px;
						margin: 0;
						color: white;
					}
					#header p {
						font-size: 16px;
						margin: 10px 0 0 0;
						color: #b8e4f0;
					}
					#content {
						padding: 20px 30px;
						background: #fff;
					}
					#content h2 {
						color: #000;
						font-size: 22px;
						margin: 0 0 10px;
					}
					#content p {
						margin: 10px 0;
						line-height: 20px;
					}
					table {
						border: none;
						border-collapse: collapse;
						font-size: 11px;
						width: 100%;
					}
					th {
						border-bottom: 1px solid #ccc;
						text-transform: uppercase;
						font-size: 11px;
						color: #333;
						padding: 10px 6px;
						line-height: 12px;
					}
					td {
						border-bottom: 1px solid #ccc;
						padding: 6px;
						line-height: 18px;
					}
					tbody tr:nth-child(even) {
						background-color: #f7f7f7;
					}
					tbody tr:hover {
						background-color: #f0f8ff;
					}
					.url {
						color: #05809e;
						text-decoration: none;
					}
					.priority {
						text-align: center;
					}
					.changefreq {
						text-align: center;
					}
					.lastmod {
						text-align: center;
						font-size: 11px;
						color: #666;
					}
					.stats {
						background-color: #f9f9f9;
						border: 1px solid #e6e6e6;
						padding: 10px;
						margin: 20px 0;
						border-radius: 3px;
					}
					.note {
						background-color: #fff8dc;
						border: 1px solid #f4d03f;
						padding: 10px;
						margin: 20px 0;
						border-radius: 3px;
					}
				</style>
			</head>
			<body>
				<div id="header">
					<h1>XML Sitemap</h1>
					<p>This sitemap contains <xsl:value-of select="count(sitemap:urlset/sitemap:url)"/> URLs</p>
				</div>
				<div id="content">
					<p>This is a XML Sitemap which is supposed to be processed by search engines like <a href="https://www.google.com/">Google</a>, <a href="https://www.bing.com/">Bing</a> etc.</p>
					<p>This sitemap was generated by <strong>Zenario</strong>. You can find more information about XML sitemaps on <a href="https://sitemaps.org/">sitemaps.org</a>.</p>
					
					<div class="stats">
						<strong>Number of URLs in this XML sitemap:</strong> <xsl:value-of select="count(sitemap:urlset/sitemap:url)"/>
					</div>

					<xsl:if test="count(sitemap:urlset/sitemap:url) &gt; 0">
						<table cellpadding="5">
							<tr style="border-bottom:1px solid #ccc;">
								<th width="75%">URL</th>
								<th width="25%">Last Modified</th>
							</tr>
							<xsl:variable name="lower" select="'abcdefghijklmnopqrstuvwxyz'"/>
							<xsl:variable name="upper" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
							<xsl:for-each select="sitemap:urlset/sitemap:url">
								<tr>
									<td>
										<xsl:variable name="itemURL">
											<xsl:value-of select="sitemap:loc"/>
										</xsl:variable>
										<a href="{$itemURL}" class="url">
											<xsl:value-of select="sitemap:loc"/>
										</a>
									</td>
									<td class="lastmod">
										<xsl:value-of select="concat(substring(sitemap:lastmod,0,11),concat(' ', substring(sitemap:lastmod,12,5)))"/>
									</td>
								</tr>
							</xsl:for-each>
						</table>
					</xsl:if>

					<div class="note">
						<strong>Note:</strong> This is the XML Sitemap for this website. For more information about this sitemap, please visit <a href="https://sitemaps.org/">sitemaps.org</a>.
					</div>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>