960 Grid System
===============

Created by Nathan Smith. See the official site for more info: http://960.gs

To install the Adobe Fireworks extension, simply double-click the `*.mxp` file
included in the `/fireworks_extension directory`. If you are running Windows 7
you will need admin permissions in order to install this extension properly.

----------------------------------------------------------------------------

Thank you for downloading the 960 Grid System. I hope it helps to streamline
web development workflow. Enclosed in the bundle are printable sketch sheets
and template files for Adobe Fireworks and Photoshop, OmniGraffle and Visio.

Also included is a lightweight CSS file, which contains the grid dimensions.
To use this file, simply include the `960.css` in the `<head>` of the HTML page.
You may also use the `reset.css` and `text.css` files, or opt to leave them out.
Here is an example of the XHTML code necessary to incorporate the CSS files:

```html
<head>
<link rel="stylesheet" type="text/css" media="all" href="css/reset.css" />
<link rel="stylesheet" type="text/css" media="all" href="css/text.css" />
<link rel="stylesheet" type="text/css" media="all" href="css/960.css" />
</head>
```

It is worth noting that these styles do not automatically make up a finished
site design. They are simply a starting point, ideally for rapid prototyping
or as a basis for creating your own designs. You should not feel constrained
by the way I have built the initial code. If you disagree with how something
has been done, feel free to revise it for the needs of your particular site.

The files in the 960 Grid System are free of charge, licensed under MIT/GPL.

----------------------------------------------------------------------------

Note that if you are building a site in a language which reads from right to
left, use the CSS files that end in `_rtl.css` instead. Denote the language:

```html
<html lang="..." dir="rtl">
```

Be sure to set `lang="..."` to the appropriate two-letter abbreviation of the
language you are using. Example: lang="he" for Hebrew, lang="ar" for Arabic.

----------------------------------------------------------------------------

GPL license:
http://www.gnu.org/licenses/gpl.html

MIT license:
http://www.opensource.org/licenses/mit-license.php
