新しいバージョンのリリース
==========================

フレームワークのリリースを作成するのに必要とされる手順のリストは、時とともに長くなり、手作業で管理するのが困難になっています。
そのため、どの手順も忘れられることが無いように、コマンドライン・ツールを作成しました。

リリースの手順の概要
--------------------

- ...

リリース・コマンド
------------------

リリースの手順は、フレームワークの開発レポジトリに含まれている [release コンソール・コマンド](../../build/controllers/ReleaseController.php)
によって自動化されています。

リリース・コマンドは、フレームワークの `build` ディレクトリに含まれている Yii
アプリケーションを使って呼び出すことが出来ます。

    ./build/build help release  # このコマンドをフレームワークのレポジトリのルートで実行します

> Info: コマンドを `--dryRun` オプションを付けて実行すると、どのようになるかを見ることが出来ます。
> このオプションを使うと、変更は何もなされず、どんなコミットやタグも生成されたり、プッシュされたりしません。

### 必要条件

リリース・コマンドは、[Git ワークフローのドキュメント](git-workflow.md#extensions) で紹介されている開発環境に依存しています。
すなわち、アプリケーション・テンプレートは `/apps/` の下に配置されていなければならず、
エクステンションは `/extensions/` の下に配置されていなければなりません。
この構成は `dev/app` および `dev/ext` のコマンドを使って作成することが推奨されます。

例えば、エクステンションのインストールは:

    ./build/build dev/ext authclient

アプリケーションは:

    ./build/build dev/app basic

このインストール方法によって、エクステンションが現在のレポジトリの状態と同じフレームワーク・コードを使用する事を
保証することが出来ます。

### バージョンの概要

フレームワークとエクステンションのバージョンについて概要を把握したいときは、以下を実行することが出来ます。

    ./build/build release/info

全てのレポジトリのタグを取得するために `--update` を指定して実行し、最新の情報を取得することも出来ます。

### リリースを作成する

フレームワークのリリースの作成では、下記のコマンドの実行します (アプリケーションは常にフレームワークと一緒にリリースされます)。

    ./build/build release framework
    ./build/build release app-basic
    ./build/build release app-advanced

エクステンションのリリースの作成では、実行するコマンドは一つだけです (例えば、redis なら)

    ./build/build release redis

リリース・コマンドは、デフォルトでは、現在チェックアウトされているブランチを元に新しいマイナー・バージョンをリリースします。
デフォルトと異なるバージョンをリリースするためには、`--version` オプションを使ってバージョンを指定する必要があります。例えば、
`--version=2.1.0`, or `--version=2.1.0-beta`.


#### 新しいメジャー・バージョン、例えば 2.1.0 をリリースする

新しいメジャー・バージョンのリリースは、[バージョン規約](versions.md) で説明されているように、
ブランチの変更を伴います。
以下は、`master` から派生した `2.1` ブランチ上で開発されている 
`2.1.0` バージョンをリリースする例を示すものです。
リリース前においては `master` は `2.0.x` の諸バージョンを含んでいます。

- `master` から新しいブランチ `2.0` を作成する
- composer.json がこのブランチに対するブランチエイリアスを含まないようにする
- 必要な変更を `master` から `2.1` にマージする
- `master` が `2.1` の最新のコミットを指すようにする
- composer.json のマスターに対するブランチ・エイリアスを `2.1.x-dev` とする
- `2.1` ブランチを削除する

`master` をチェックアウトし、`--version=2.1.0` オプションを付けて、リリース・コマンドを実行する。

