<div
    data-control="media-manager"
    class="layout"
    data-alias="<?= $this->alias ?>"
    data-upload-handler="<?= $this->getEventHandler('onUpload') ?>"
    data-delete-empty="<?= e(trans('backend::lang.media.delete_empty')) ?>"
    data-delete-confirm="<?= e(trans('backend::lang.media.delete_confirm')) ?>"
    data-move-empty="<?= e(trans('backend::lang.media.move_empty')) ?>"
    data-select-single-image="<?= e(trans('backend::lang.media.select_single_image')) ?>"
    data-selection-not-image="<?= e(trans('backend::lang.media.selection_not_image')) ?>"
    data-bottom-toolbar="<?= $this->bottomToolbar ? 'true' : 'false' ?>"
    data-crop-and-insert-button="<?= $this->cropAndInsertButton ? 'true' : 'false' ?>"
    data-read-only="<?= $this->readOnly ? 'true' : 'false'; ?>"
    tabindex="0"
>

    <?= $this->makePartial('toolbar') ?>

    <?= (!$this->readOnly) ? $this->makePartial('upload-progress') : '' ?>

    <div class="layout-row whiteboard">
        <div class="layout">
            <div class="layout-row">
                <div class="layout-cell panel w-200 border-right" data-control="left-sidebar">
                    <?= $this->makePartial('left-sidebar') ?>
                </div>
                <div class="layout-cell">
                    <div class="layout">

                        <div class="layout-row min-size">
                            <?= $this->makePartial('folder-toolbar') ?>
                        </div>
                        <div class="layout-row">
                            <!-- Main area -->
                            <div class="layout">
                                <div class="layout-row">
                                    <div class="layout">
                                        <!-- Main area - list -->
                                        <div data-control="item-list">
                                            <div class="control-scrollpad">
                                                <div class="scroll-wrapper"> <!-- This element is required for the scrollpad control -->
                                                    <div id="<?= $this->getId('item-list') ?>" >
                                                        <?= $this->makePartial('item-list') ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="layout-cell w-300 panel border-left no-padding <?= !$sidebarVisible ? 'hide' : null ?>" data-control="preview-sidebar">
                                            <!-- Right sidebar -->
                                            <?= $this->makePartial('right-sidebar') ?>
                                        </div>

                                    </div>
                                </div>

                                <div class="layout-row min-size hide" data-control="bottom-toolbar">
                                    <?= $this->makePartial('bottom-toolbar') ?>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <?= $this->makePartial('new-folder-form') ?>
</div>
