
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `wbce165`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]addons`
--

CREATE TABLE `[[dbprefix]]addons` (
  `addon_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `directory` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `function` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `version` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `platform` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `author` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `license` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`addon_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=59 ;

--
-- Dumping data for table `[[dbprefix]]addons`
--

INSERT INTO `[[dbprefix]]addons` VALUES
(1, 'module', 'outputfilter_dashboard', 'Output Filter Dashboard', 'Admin-Tool to manage OutputFilter', 'tool', '1.6.6', 'WBCE 1.x', 'Thomas "thorn" Hornik <thorn@nettest.thekk.de>, Christian M. Stefan (Stefek) <stefek@designthings.de>, Martin Hecht (mrbaseman) <mrbaseman@gmx.de>', 'GNU General Public License, Version 3'),
(2, 'module', 'droplets', 'Droplets', 'This tool allows you to manage your local Droplets.', 'tool', '2.4.0', '1.6.0', 'Ruud, pcwacht, WebBird, cwsoft, Norhei, Colinax, Christian M. Stefan (Stefek)', 'GNU General Public License'),
(3, 'module', 'CodeMirror_Config', 'CodeMirror Configurator', 'Change Settings of the CodeMirror implementation', 'tool, initialize', '0.1.0', '1.5.5', 'Christian M. Stefan (Stefek)', 'GNU General Public License'),
(4, 'module', 'SecureFormSwitcher', 'More Security Settings', 'This tool provides some additional security settings', 'tool', '1.3.3', '1.1.0', 'Complete rewrite of Secure Form Switcher by  Norbert Heimsath(heimsath.org)', 'GPLv2 or any later'),
(5, 'module', 'addon_monitor', 'Addon Monitor', 'This AdminTool''s entire purpose is to give you a handy way to overview all the installed add-ons. You will be able to see whether or not your installed modules are in use and where.', 'tool', '0.7.2', '1.0.0', 'Christian M. Stefan (Stefek)', 'GNU/GPL v.2'),
(6, 'module', 'captcha_control', 'Captcha and Advanced-Spam-Protection (ASP) Control', 'Admin-Tool to control CAPTCHA and ASP', 'tool', '2.0.5', '1.4.0', 'Thorn, Luise Hahne, Norbert Heimsath', 'WTFPL'),
(7, 'module', 'ckeditor', 'CKEditor', 'includes CKEditor 4.22.1 Standard Package and some other Plugins, CKE allows editing content and can be integrated in frontend and backend modules.', 'wysiwyg,snippet', '4.22.1', '1.5.0', 'diverse, cwsoft, Norhei, Colinax', 'GPL, LGPL and MPL'),
(8, 'module', 'elfinder', 'elFinder', 'elFinder file manager as Admin Tool', 'tool', '2.1.66', '1.6.0', 'WBCE', 'Modul under GPL, elFinder under BSD'),
(9, 'module', 'errorlogger', 'Errorlog viewer', 'Catch PHP warnings and errors into a logfile and view them using this tool.', 'tool,preinit,initialize', '1.1.4.2', '1.3.0', 'Ruud Eisinga - Dev4me', 'GNU General Public License'),
(10, 'module', 'jsadmin', 'Javascript Admin', 'Settings for the page tree and section management behaviour.', 'tool', '1.4.4', '1.4.0', 'Stepan Riha, Swen Uth', 'BSD License'),
(11, 'module', 'maintainance_mode', 'Maintenance Mode Switcher', 'This tool offers a plain and simple switch to turn maintenance mode on and off.', 'tool', '1.1.4', '1.4.0', 'Norbert Heimsath(heimsath.org)', 'WTFPL'),
(12, 'module', 'menu_link', 'Menu Link', 'This module allows you to insert a link into the menu.', 'page', '2.9.8', '1.4.0', 'Ryan Djurovich, thorn, Christian M. Stefan', 'GNU General Public License'),
(13, 'module', 'miniform', 'MiniForm WBCE CMS Edition', 'This module allows you to create a quick and simple form without complicated settings.', 'page, tool', '0.23.3', '1.4.x', 'Ruud / Dev4me', 'GNU General Public License'),
(14, 'module', 'mod_opf_auto_placeholder', 'OPF Auto Placeholder', 'Auto Add Placeholders for Javascript, CSS, Metas and Title', 'opffilter', '1.3.4', 'WBCE 1.4.x ', 'Martin Hecht (mrbaseman)', 'GNU GPL2 (or any later version)'),
(15, 'module', 'mod_opf_csstohead', 'OPF CSS to head', 'moves css definitions from the body section into head', 'opffilter', '1.0.8', 'WBCE 1.2.x ', 'Martin Hecht (mrbaseman)', 'GNU GPL2 (or any later version)'),
(16, 'module', 'mod_opf_email', 'OPF E-Mail', 'settings for the output filter to protect email addresses in text, mailto links, and javascript', 'tool', '1.1.11', 'WBCE 1.x', 'Martin Hecht (mrbaseman)', 'GNU GPL2 (or any later version)'),
(17, 'module', 'mod_opf_insert', 'OPF Insert', 'fill out placeholders for Javascript, CSS, Metas and Title', 'opffilter', '1.0.8', 'WBCE 1.4.x ', 'Martin Hecht (mrbaseman)', 'GNU GPL2 (or any later version)'),
(18, 'module', 'mod_opf_move_stuff', 'OPF Move Contents', 'move sections enclosed by move markers to the areas denoted by the corresponding place holders', 'opffilter', '1.0.8', 'WBCE 1.3.x ', 'Martin Hecht (mrbaseman)', 'GNU GPL2 (or any later version)'),
(19, 'module', 'mod_opf_remove_system_ph', 'OPF Remove System PH', 'remove system placeholder markers ', 'opffilter', '1.1.7', 'WBCE 1.3.x ', 'Martin Hecht (mrbaseman)', 'GNU GPL2 (or any later version)'),
(20, 'module', 'mod_opf_replace_stuff', 'OPF Replace Contents', 'replaces the areas marked by placeholders by the corresponding parts enclosed by replacement markers', 'opffilter', '1.0.8', 'WBCE 1.3.x ', 'Martin Hecht (mrbaseman)', 'GNU GPL2 (or any later version)'),
(21, 'module', 'mod_opf_wblink', 'OPF Internal Link Replacer', 'change internal wblinkxx into real URLs', 'opffilter', '1.0.7', 'WBCE 1.2.x ', 'Martin Hecht (mrbaseman)', 'GNU GPL2 (or any later version)'),
(22, 'module', 'news_img', 'News with Images', 'This page type is designed for making a news page with Images and Lightboxeffect.', 'page', '5.0.29', '1.4', 'Ryan Djurovich, Rob Smith, Silvia Reins, Martin Hecht, Florian Meerwinck, Bianka Martinovic', 'GNU General Public License'),
(23, 'module', 'show_menu2', 'show_menu2', 'A code snippet for the WBCE CMS providing menu functions. See the <a href="[[softurl]]/modules/show_menu2/README.en.txt" target="_blank">readme</a> file or view <a href="https://sm2.wbce-cms.org/" target="_blank">sm2.wbce-cms.org</a>.', 'snippet', '4.14.1', '1.4.0', 'diverse, WBCE Dev Team', 'GNU General Public License v2'),
(24, 'module', 'simplepagehead', 'SimplePageHead', 'Snippet to generate better and simpler head tags (title, keywords.. ) for core and modules. Function can be invoked from the template. Simplest call: simplepagehead();', 'snippet', '0.8.3', '1.4.0', 'Chio, with a litte help from thorn. Extended for use with other modules by Christoph Marti. Updated by Florian Meerwinck for WBCE', 'GNU General Public License'),
(25, 'module', 'sitemap', 'Sitemap', 'This module allows you to easily create a sitemap. You can even work with additional layout settings for the sitemap. It also gives you the option to show hidden menu items if required', 'page', '4.0.11', '1.4.0', 'Ryan Djurovich, Frank Schoep, Woudloper, Ruebenwurzel, Rob Smith, Mouring Kolhoff, Michael Milette, Dietrich Roland Pehlke, Christian M. Stefan (Stefanek) (last)', 'GNU General Public License'),
(26, 'module', 'tool_account_settings', 'Account and Signups configuration', 'Set up the registration process (signup) and have an overview of all users registered to the system.', 'tool', '0.7.1', '1.4.0', 'Christian M. Stefan (Stefek)', 'GNU General Public License'),
(27, 'module', 'wbSeoTool', 'SEO Tool', 'This Admin-Tool provides some SEO handling help.', 'tool', '0.7.1', '2.8.3', 'Christian M. Stefan <stefek@designthings.de>', 'GNU General Public License v.2'),
(28, 'module', 'wbstats', 'Visitor statistics - WBstats - by Dev4me', 'Displays website statistics as an admintool', 'tool,initialize,page', '0.2.5.8', '1.3.0', 'Dev4me - Ruud Eisinga - www.dev4me.nl, Norbert Heimsath(heimsath.org)', 'GNU General Public License'),
(29, 'module', 'wrapper', 'Wrapper', 'This module allows you to wrap your site around another using an inline frame', 'page', '2.8.3', '2.8.x', 'Ryan Djurovich', 'GNU General Public License'),
(30, 'module', 'wysiwyg', 'WYSIWYG', 'This module allows you to edit the contents of a page using a graphical editor', 'page', '2.10.0', '1.4.0', 'Ryan Djurovich', 'GNU General Public License'),
(31, 'template', 'argos_theme_reloaded', 'Argos Theme Reloaded', 'Enhanced backend theme for WBCE 1.x', 'theme', '2.1.8', '1.5.0', 'Bernd Michna (BerndJM / WWnW) based on the work by Jurgen Nijhuis (Argos Media) & Ruud Eisinga', '<a href="http://www.wtfpl.net/">WTFPL</a>'),
(32, 'template', 'wbce_flat_theme', 'WBCE Flat Theme', 'Flat theme for WBCE 1.x', 'theme', '1.7.11', '1.5.0', 'Colinax based on the work by Yetiie, BerndJM and rjgamer', 'GNU General Public License'),
(33, 'template', 'wbcetik', 'WBCETik', 'Klassisch aufgebautes Template mit vertikaler Navigation, Content- und optionaler Seitenspalte, optionalen breiten Blöcken darüber und darunter. ', 'template', '1.1', '1.4', 'Florian Meerwinck', 'Responsee is licenced under MIT, MFG Labs icon set under CC-BY 3.0 and SIL Open Font License, Open Sans is licensed under Apache license. Images from pixabay.com, Pixabay License. '),
(34, 'template', 'wbcezon', 'WBCEZon', 'Klassisch aufgebautes Template mit horizontaler Navigation, Content- und optionaler Seitenspalte, optionalen breiten Blöcken darüber und darunter. Die linke Spalte ist nur in der Desktop/Tablet-Ansicht sichtbar, nicht auf Smartphones. ', 'template', '1.0.1', '1.4', 'Florian Meerwinck', 'Responsee is licenced under MIT, MFG Labs icon set under CC-BY 3.0 and SIL Open Font License, Open Sans is licensed under Apache license. Images from pixabay.com, Pixabay License. '),
(35, 'template', 'whiteboard', 'Whiteboard Template', 'This template is for use on page where you do not want anything wrapping the content.', 'template', '1.0', '1.0.0', 'WBCE', 'GNU General Public License'),
(36, 'language', 'BG', 'Bulgarian', '', '', '2.8', '2.8.x', 'Hristo Benev(&#1061;&#1088;&#1080;&#1089;&#1090;&#1086; &#1041;&#1077;&#1085;&#1077;&#1074;)', 'GNU General Public License'),
(37, 'language', 'CA', 'Catalan', '', '', '2.8', '2.8.x', 'Carles Escrig (simkin)', 'GNU General Public License'),
(38, 'language', 'CS', 'Czech', '', '', '2.8', '2.8.x', 'WebStep, s.r.o.', 'GNU General Public License'),
(39, 'language', 'DA', 'Danish', '', '', '2.8', '2.8.x', 'Allan Christensen', 'GNU General Public License'),
(40, 'language', 'DE', 'German', '', '', '3.3', '1.4.0', 'Stefan Braunewell, Matthias Gallas, Florian Meerwinck', 'GNU General Public License'),
(41, 'language', 'EN', 'English', '', '', '3.2', '1.3.0', 'Ryan Djurovich, Christian Sommer', 'GNU General Public License'),
(42, 'language', 'ES', 'Spanish', '', '', '3.2', '1.3.0', 'Samuel Mateo, Jr. | samuelmateo.com', 'GNU General Public License'),
(43, 'language', 'ET', 'Estonian', '', '', '2.8', '2.8.x', 'Heiko H&auml;ng', 'GNU General Public License'),
(44, 'language', 'FI', 'Finnish', '', '', '2.8', '2.8.x', 'Jontse', 'GNU General Public License'),
(45, 'language', 'FR', 'French', '', '', '3.2', '1.3.0', 'Marin Susac', 'GNU General Public License'),
(46, 'language', 'GR', 'Greek', '', '', '3.2', '1.3.0', 'Yannis Spyrou', 'GNU General Public License'),
(47, 'language', 'HR', 'Croatian', '', '', '2.8', '2.8.x', 'Vedran Presecki', 'GNU General Public License'),
(48, 'language', 'HU', 'Hungarian', '', '', '3.2', '1.3.0', 'Zsolt + Robert', 'GNU General Public License'),
(49, 'language', 'IT', 'Italian', '', '', '3.2', '1.3.0', 'Roberto Rossi', 'GNU General Public License'),
(50, 'language', 'LV', 'Latvian', '', '', '2.8', '2.8.x', 'Kri&scaron;janis Rijnieks', 'GNU General Public License'),
(51, 'language', 'NL', 'Dutch', '', '', '3.2', '1.3.0', 'Bramus, CodeALot, Luckyluke, Argos', 'GNU General Public License'),
(52, 'language', 'NO', 'Norsk Bokmål''; // ''Norwegian', '', '', '3.2', '1.3.0', 'Odd Egil Hansen (oeh)', 'GNU General Public License'),
(53, 'language', 'PL', 'Polish', '', '', '3.2', '1.3.0', 'Marek Stepien;', 'GNU General Public License'),
(54, 'language', 'PT', 'Portuguese', '', '', '3.2', '1.3.0', 'Daniel Neto', 'GNU General Public License'),
(55, 'language', 'RU', 'Russian', '', '', '2.9', '1.4.x', 'Kirill Karakulko (kirill@nadosoft.com), Leo Klee', 'GNU General Public License'),
(56, 'language', 'SK', 'Slovak', '', '', '2.8', '2.8.x', 'Michal Kurtulik - YONIX.SK', 'GNU General Public License'),
(57, 'language', 'SV', 'Swedish', '', '', '2.8', '2.8.x', 'Markus Eriksson, Peppe Bergqvist', 'GNU General Public License'),
(58, 'language', 'TR', 'Turkish', '', '', '2.8', '2.8.x', 'Atakan KO&Ccedil;', 'GNU General Public License');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blocking`
--

CREATE TABLE `[[dbprefix]]blocking` (
  `source_ip` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `timestamp` int(11) NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`source_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]blocking`
--
-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dbsessions`
--

CREATE TABLE `[[dbprefix]]dbsessions` (
  `id` varchar(148) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Session Id',
  `data` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT 'Session Data',
  `last_accessed` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Last timestamp',
  `user` int(11) NOT NULL COMMENT 'User Id',
  PRIMARY KEY (`id`),
  KEY `last_accessed` (`last_accessed`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='WBCE Session Table';

--
-- Dumping data for table `[[dbprefix]]dbsessions`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups`
--

CREATE TABLE `[[dbprefix]]groups` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `system_permissions` text COLLATE utf8_unicode_ci NOT NULL,
  `module_permissions` text COLLATE utf8_unicode_ci NOT NULL,
  `template_permissions` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]groups`
--

INSERT INTO `[[dbprefix]]groups` VALUES
(1, 'Administrators', 'pages,pages_view,pages_add,pages_add_l0,pages_settings,pages_modify,pages_intro,pages_delete,media,media_view,media_upload,media_rename,media_delete,media_create,addons,modules,modules_view,modules_install,modules_uninstall,templates,templates_view,templates_install,templates_uninstall,languages,languages_view,languages_install,languages_uninstall,settings,settings_basic,settings_advanced,access,users,users_view,users_add,users_modify,users_delete,groups,groups_view,groups_add,groups_modify,groups_delete,admintools', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_droplets`
--

CREATE TABLE `[[dbprefix]]mod_droplets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `code` longtext COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `modified_when` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `active` int(11) NOT NULL DEFAULT '0',
  `admin_edit` int(11) NOT NULL DEFAULT '0',
  `admin_view` int(11) NOT NULL DEFAULT '0',
  `show_wysiwyg` int(11) NOT NULL DEFAULT '0',
  `comments` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=16 ;

--
-- Dumping data for table `[[dbprefix]]mod_droplets`
--

INSERT INTO `[[dbprefix]]mod_droplets` VALUES
(1, 'EditThisPage', '// This Droplet will show a link to the backend page editor. This is only shown when the user is logged in and has the correct permissions to edit the page in question.\nglobal $wb, $page_id, $HEADING, $database, $admin;\n$str = " ";\nif (FRONTEND_LOGIN == ''enabled'' and is_numeric($wb->get_session(''USER_ID''))) {\n    if ($page_id) {\n        $this_page = $page_id;\n    } else {\n        $this_page = $wb->default_page_id;\n    }\n    $results = $database->query("SELECT * FROM ".TABLE_PREFIX."pages WHERE page_id = ''$this_page''");\n    $results_array = $results->fetchRow();\n    $old_admin_groups = explode('','', $results_array[''admin_groups'']);\n    $old_admin_users = explode('','', $results_array[''admin_users'']);\n    $this_user = $wb->get_session(''GROUP_ID'');\n    $query = "SELECT * FROM ".TABLE_PREFIX."pages WHERE page_id = ''".$page_id."''";\n    $get_pages = $database->query($query);\n    $page = $get_pages->fetchRow();\n    $admin_groups = explode('','', str_replace(''_'', '''', $page[''admin_groups'']));\n    $admin_users = explode('','', str_replace(''_'', '''', $page[''admin_users'']));\n    $in_group = false;\n    foreach ($admin->get_groups_id() as $cur_gid) {\n        if (in_array($cur_gid, $admin_groups)) {\n            $in_group = true;\n        }\n    }\n    if (($in_group) or is_numeric(array_search($this_user, $old_admin_groups))) {\n        $str  = ''<a href="'' . ADMIN_URL . ''/pages/modify.php?page_id=''.$this_page;\n        $str .= ''" target="_blank"><img align="left" border="0" src="'';\n        $str .= THEME_URL . ''/images/modify_16.png" alt="'' . $HEADING[''MODIFY_PAGE''] . ''" />Edit Page</a>'';\n    }\n}\nreturn $str;\n', 'Shows an "Edit page" link in the frontend', [[timestamp]], 1, 1, 0, 0, 0, 'Usage: [[editthispage]]'),
(2, 'LoginBox', '// Absolute or relative url possible\n// Remember to enable frontend login in your website settings.\n\nglobal $wb,$page_id,$TEXT, $MENU, $HEADING;\nrequire_once(WB_PATH.''/include/captcha/captcha.php'');\nob_start();\ncall_captcha("all","","login");\n$captcha = ob_get_contents();\nob_end_clean();\n\n$return_value = ''<div class="login-box">''."\\n";\n$return_admin = '' '';\n// Return a system permission\nfunction get_permission($name, $type = ''system'')\n{\n	global $wb;\n	// Append to permission type\n	$type .= ''_permissions'';\n	// Check if we have a section to check for\n	if ($name == ''start'') {\n		return true;\n	} else {\n		// Set system permissions var\n		$system_permissions = $wb->get_session(''SYSTEM_PERMISSIONS'');\n		// Set module permissions var\n		$module_permissions = $wb->get_session(''MODULE_PERMISSIONS'');\n		// Set template permissions var\n		$template_permissions = $wb->get_session(''TEMPLATE_PERMISSIONS'');\n		// Return true if system perm = 1\n		if (isset($$type) && is_array($$type) && is_numeric(array_search($name, $$type))) {\n			if ($type == ''system_permissions'') {\n				return true;\n			} else {\n				return false;\n			}\n		} else {\n			if ($type == ''system_permissions'') {\n				return false;\n			} else {\n				return true;\n			}\n		}\n	}\n}\n\nfunction get_page_permission($page, $action=''admin'')\n{\n	if ($action!=''viewing'') {\n		$action=''admin'';\n	}\n	$action_groups=$action.''_groups'';\n	$action_users=$action.''_users'';\n	if (is_array($page)) {\n		$groups=$page[$action_groups];\n		$users=$page[$action_users];\n	} else {\n		global $database,$wb;\n		$results = $database->query("SELECT $action_groups,$action_users FROM ".TABLE_PREFIX."pages WHERE page_id = ''$page''");\n		$result = $results->fetchRow();\n		$groups = explode('','', str_replace(''_'', '''', $result[$action_groups]));\n		$users = explode('','', str_replace(''_'', '''', $result[$action_users]));\n	}\n\n	$in_group = false;\n	foreach ($wb->get_groups_id() as $cur_gid) {\n		if (in_array($cur_gid, $groups)) {\n			$in_group = true;\n		}\n	}\n	if ((!$in_group) and !is_numeric(array_search($wb->get_user_id(), $users))) {\n		return false;\n	}\n	return true;\n}\n\n// Get redirect\n$redirect_url = ((isset($_SESSION[''HTTP_REFERER'']) && $_SESSION[''HTTP_REFERER''] != '''') ? $_SESSION[''HTTP_REFERER''] : WB_URL);\n$redirect_url = (isset($redirect) && ($redirect!='''') ? $redirect : $redirect_url);\n\nif ((FRONTEND_LOGIN == ''enabled'') &&\n		(VISIBILITY != ''private'') &&\n			($wb->get_session(''USER_ID'') == '''')) {\n	$return_value .= ''<form action="''.LOGIN_URL.''" method="post">''."\\n";\n	$return_value .= ''<input type="hidden" name="redirect" value="''.$redirect_url.''" />''."\\n";\n	$return_value .= ''<fieldset>''."\\n";\n	$return_value .= ''<h1>''.$TEXT[''LOGIN''].''</h1>''."\\n";\n	$return_value .= ''<label for="username">''.$TEXT[''USERNAME''].'':</label>''."\\n";\n	$return_value .= ''<p><input type="text" name="username" id="username"  /></p>''."\\n";\n	$return_value .= ''<label for="password">''.$TEXT[''PASSWORD''].'':</label>''."\\n";\n	$return_value .= ''<p><input type="password" name="password" id="password"/></p>''."\\n";\n	$return_value .= ''<p>''.$captcha.''</p>''."\\n";\n	$return_value .= ''<p><input type="submit" id="submit" value="''.$TEXT[''LOGIN''].''" class="dbutton" /></p>''."\\n";\n	$return_value .= ''<ul class="login-advance">''."\\n";\n	$return_value .= ''<li class="forgot"><a href="''.FORGOT_URL.''"><span>''.$TEXT[''FORGOT_DETAILS''].''</span></a></li>''."\\n";\n\n	if (intval(FRONTEND_SIGNUP) > 0) {\n		$return_value .= ''<li class="sign"><a href="''.SIGNUP_URL.''">''.$TEXT[''SIGNUP''].''</a></li>''."\\n";\n	}\n	$return_value .= ''</ul>''."\\n";\n	$return_value .= ''</fieldset>''."\\n";\n	$return_value .= ''</form>''."\\n";\n} elseif ((FRONTEND_LOGIN == ''enabled'') &&\n			(is_numeric($wb->get_session(''USER_ID'')))) {\n	$return_value .= ''<form action="''.LOGOUT_URL.''" method="post" class="login-table">''."\\n";\n	$return_value .= ''<fieldset>''."\\n";\n	$return_value .= ''<h1>''.$TEXT["LOGGED_IN"].''</h1>''."\\n";\n	$return_value .= ''<label>''.$TEXT[''WELCOME_BACK''].'', ''.$wb->get_display_name().''</label>''."\\n";\n	$return_value .= ''<p><input type="submit" name="submit" value="''.$MENU[''LOGOUT''].''" class="dbutton" /></p>''."\\n";\n	$return_value .= ''<ul class="logout-advance">''."\\n";\n	$return_value .= ''<li class="preference"><a href="''.PREFERENCES_URL.''" title="''.$MENU[''PREFERENCES''].''">''.$MENU[''PREFERENCES''].''</a></li>''."\\n";\n\n	if ($wb->ami_group_member(''1'')) {  //change ot the group that should get special links\n		$return_admin .= ''<li class="admin"><a target="_blank" href="''.ADMIN_URL.''/index.php" title="''.$TEXT[''ADMINISTRATION''].''" class="blank_target">''.$TEXT["ADMINISTRATION"].''</a></li>''."\\n";\n		//you can add more links for your users like userpage, lastchangedpages or something\n		$return_value .= $return_admin;\n	}\n	//change ot the group that should get special links\n	if (get_permission(''pages_modify'') && get_page_permission(PAGE_ID)) {\n		$return_value .= ''<li class="modify"><a target="_blank" href="''.ADMIN_URL.''/pages/modify.php?page_id=''.PAGE_ID.''" title="''.$HEADING[''MODIFY_PAGE''].''" class="blank_target">''.$HEADING[''MODIFY_PAGE''].''</a></li>''."\\n";\n	}\n	$return_value .= ''</ul>''."\\n";\n	$return_value .= ''</fieldset>''."\\n";\n	$return_value .= ''</form>''."\\n";\n}\n$return_value .= ''</div>''."\\n";\nreturn $return_value;\n', 'Puts a Login / Logout box on your page.', [[timestamp]], 1, 1, 0, 0, 0, 'Use: [[LoginBox?redirect=url]]'),
(3, 'Lorem', '$lorem = array();\n$lorem[] = "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Ut odio. Nam sed est. Nam a risus et est iaculis adipiscing. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Integer ut justo. In tincidunt viverra nisl. Donec dictum malesuada magna. Curabitur id nibh auctor tellus adipiscing pharetra. Fusce vel justo non orci semper feugiat. Cras eu leo at purus ultrices tristique.<br /><br />";\n$lorem[] = "Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat.<br /><br />";\n$lorem[] = "Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.<br /><br />";\n$lorem[] = "Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.<br /><br />";\n$lorem[] = "Cras consequat magna ac tellus. Duis sed metus sit amet nunc faucibus blandit. Fusce tempus cursus urna. Sed bibendum, dolor et volutpat nonummy, wisi justo convallis neque, eu feugiat leo ligula nec quam. Nulla in mi. Integer ac mauris vel ligula laoreet tristique. Nunc eget tortor in diam rhoncus vehicula. Nulla quis mi. Fusce porta fringilla mauris. Vestibulum sed dolor. Aliquam tincidunt interdum arcu. Vestibulum eget lacus. Curabitur pellentesque egestas lectus. Duis dolor. Aliquam erat volutpat. Aliquam erat volutpat. Duis egestas rhoncus dui. Sed iaculis, metus et mollis tincidunt, mauris dolor ornare odio, in cursus justo felis sit amet arcu. Aenean sollicitudin. Duis lectus leo, eleifend mollis, consequat ut, venenatis at, ante.<br /><br />";\n$lorem[] = "Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.<br /><br />";\nif (!isset($blocks)) {\n    $blocks=1;\n}\n$blocks = (int)$blocks - 1;\nif ($blocks <= 0) {\n    $blocks = 0;\n}\nif ($blocks > 5) {\n    $blocks = 5;\n}\n$returnvalue = "";\nfor ($i=0 ; $i<=$blocks ; $i++) {\n    $returnvalue .= $lorem[$i];\n}\nreturn $returnvalue;\n', 'Create Lorum Ipsum text', [[timestamp]], 1, 1, 0, 0, 0, 'Use: [[Lorem?blocks=6]] (max 6 paragraphs)'),
(4, 'ModifiedWhen', 'global $database, $wb;\nif (PAGE_ID>0) {\n    $query=$database->query("SELECT modified_when FROM ".TABLE_PREFIX."pages where page_id=".PAGE_ID);\n    $mod_details=$query->fetchRow();\n    return "This page was last modified on ".date("d/m/Y", $mod_details[0]). " at ".date("H:i", $mod_details[0]).".";\n}\n', 'Displays the last modification time of the current page', [[timestamp]], 1, 1, 0, 0, 0, 'Use [[ModifiedWhen]]'),
(5, 'NextPage', '$info = show_menu2(0, SM2_CURR, SM2_START, SM2_ALL|SM2_BUFFER, ''[if(class==menu-current){[level] [sib] [sibCount] [parent]}]'', '''', '''', '''');\nlist($nLevel, $nSib, $nSibCount, $nParent) = explode('' '', $info);\n\n// show next\n$nxt = $nSib < $nSibCount ? $nSib + 1 : 0;\nif ($nxt > 0) {\n    return show_menu2(0, SM2_CURR, SM2_START, SM2_ALL|SM2_BUFFER, "[if(sib==$nxt){&gt;&gt; [a][menu_title]</a>}]", '''', '''', '''');\n} else {\n    return ''(no next)'';\n}\n', 'Create a next link to your page', [[timestamp]], 1, 1, 0, 0, 0, 'Display a link to the next page on the same menu level'),
(6, 'Oneliner', '$line = file(dirname(__FILE__)."/example/oneliners.txt");\nshuffle($line);\nreturn $line[0];\n', 'Create a random oneliner on your page', [[timestamp]], 1, 1, 0, 0, 0, 'Use: [[OneLiner]]. The file with the oneliner data is located in /modules/droplets/example/oneliners.txt'),
(7, 'ParentPage', '$info = show_menu2(0, SM2_CURR, SM2_START, SM2_ALL|SM2_BUFFER, ''[if(class==menu-current){[level] [sib] [sibCount] [parent]}]'', '''', '''', '''');\nlist($nLevel, $nSib, $nSibCount, $nParent) = explode('' '', $info);\n\n// show up level\nif ($nLevel > 0) {\n    $lev = $nLevel - 1;\n    return show_menu2(0, SM2_ROOT, SM2_CURR, SM2_CRUMB|SM2_BUFFER, "[if(level==$lev){[a][menu_title]</a>}]", '''', '''', '''');\n} else {\n    return ''(no parent)'';\n}\n', 'Create a parent link to your page', [[timestamp]], 1, 1, 0, 0, 0, 'Display a link to the parent page of the current page'),
(8, 'PreviousPage', '$info = show_menu2(0, SM2_CURR, SM2_START, SM2_ALL|SM2_BUFFER, ''[if(class==menu-current){[level] [sib] [sibCount] [parent]}]'', '''', '''', '''');\nlist($nLevel, $nSib, $nSibCount, $nParent) = explode('' '', $info);\n\n// show previous\n$prv = $nSib > 1 ? $nSib - 1 : 0;\nif ($prv > 0) {\n    return show_menu2(0, SM2_CURR, SM2_START, SM2_ALL|SM2_BUFFER, "[if(sib==$prv){[a][menu_title]</a> &lt;&lt;}]", '''', '''', '''');\n} else {\n    return ''(no previous)'';\n}\n', 'Create a previous link to your page', [[timestamp]], 1, 1, 0, 0, 0, 'Display a link to the previous page on the same menu level'),
(9, 'RandomImage', '$dir = ((isset($dir) && ($dir!='''')) ? $dir : '''');\r\n$folder = opendir(WB_PATH.MEDIA_DIRECTORY.''/''.$dir.''/.'');\r\n$names = array();\r\nwhile ($file = readdir($folder)) {\r\n    $ext=strtolower(substr($file, -4));\r\n    if ($ext==".jpg"||$ext==".gif"||$ext==".png") {\r\n        $names[count($names)] = $file;\r\n    }\r\n}\r\nclosedir($folder);\r\nshuffle($names);\r\n$image=$names[0];\r\n$name=substr($image, 0, -4);\r\nreturn ''<img src="''.WB_URL.MEDIA_DIRECTORY.''/''.$dir.''/''.$image.''" alt="''.$name.''" width="''.$width.''" height="''.$height.''"/>'';\r\n', 'Get a random image from a folder in the MEDIA folder.', [[timestamp]], 1, 1, 0, 0, 0, 'Usage [[RandomImage?dir=subfolder_in_mediafolder]]'),
(10, 'SearchBox', 'global $TEXT;\n$return_value = true;\nif (!isset($msg)) {\n    $msg=''search this site..'';\n}\n$j = "onfocus=\\"if(this.value==''$msg''){this.value='''';this.style.color=''#000'';}else{this.select();}\\"\n        onblur=\\"if(this.value==''''){this.value=''$msg'';this.style.color=''#b3b3b3'';}\\"";\nif (SHOW_SEARCH) {\n    $return_value  = ''<div class="searchbox">'';\n    $return_value  .= ''<form action="''.WB_URL.''/search/index''.PAGE_EXTENSION.''" method="get" name="search" class="searchform" id="search">'';\n    $return_value  .= ''<input type="hidden" name="referrer" value="''.PAGE_ID.''" />'';\n    $return_value  .= ''<input style="color:#b3b3b3;" type="text" name="string" size="25" class="textbox" value="''.$msg.''" ''.$j.''  />&nbsp;'';\n    $return_value  .= ''</form>'';\n    $return_value  .= ''</div>'';\n}\nreturn $return_value;\n', 'Create a searchbox', [[timestamp]], 1, 1, 0, 0, 0, 'Creates a serachbox on the position of [[searchbox]]. Optional parameter "?msg=the search message"'),
(11, 'SectionPicker', '$sid = isset($sid) ? intval($sid) : 0;\n$anchor = isset($anchor) ? (string) $anchor : '''';\nreturn get_section_content($sid, false, $anchor);\n', 'Load the view.php from any other section-module', [[timestamp]], 1, 1, 0, 0, 0, 'Use [[SectionPicker?sid=123]] or use [[SectionPicker?sid=123&anchor=MyAnchor]] if you want to have a anchor added before the section'),
(12, 'ShowRandomWysiwyg', 'global $database;\n    $content = '''';\n    if (isset($section)) {\n        if (preg_match(''/^[0-9]+(?:\\s*[\\,\\|\\-\\;\\:\\+\\#\\/]\\s*[0-9]+\\s*)*$/'', $section)) {\n            if (is_readable(WB_PATH.''/modules/wysiwyg/view.php'')) {\n                // if valid arguments given and module wysiwyg is installed\n                // split and sanitize arguments\n                $aSections = preg_split(''/[\\s\\,\\|\\-\\;\\:\\+\\#\\/]+/'', $section);\n                $section_id = $aSections[array_rand($aSections)]; // get random element\n                ob_start(); // generate output by wysiwyg module\n                require(WB_PATH.''/modules/wysiwyg/view.php'');\n                $content = ob_get_clean();\n            }\n        }\n    }\nreturn $content;\n', 'Randomly display one WYSIWYG section from a given list', [[timestamp]], 1, 1, 0, 0, 0, 'Use [[ShowRandomWysiwyg?section=10,12,15,20]] possible Delimiters: [ ,;:|-+#/ ]'),
(13, 'SiteModified', 'global $database, $wb;\nif (PAGE_ID>0) {\n    $query=$database->query("SELECT max(modified_when) FROM ".TABLE_PREFIX."pages");\n    $mod_details=$query->fetchRow();\n    return "This site was last modified on ".date("d/m/Y", $mod_details[0]). " at ".date("H:i", $mod_details[0]).".";\n}\n', 'Create information on when your site was last updated.', [[timestamp]], 1, 1, 0, 0, 0, 'Create information on when your site was last updated. Any page update counts.'),
(14, 'mp4video', '// w and h are optional\n// load mp4-Video from /media/ or subfolder\nif (!isset($w)) $w="100%";\nif (!isset($h)) $h="auto";\nif (!isset($p)) $p="preview-video.jpg";\n$rv= "<video width=\\"".$w."\\" height=\\"".$h."\\" poster=\\"".WB_URL."/media/".$p."\\" controls>";\n$rv.="<source src=\\"".WB_URL."/media/".$mp4."\\" type=\\"video/mp4\\" />";\n$rv.="Your browser does not support the video element.</video>";\nreturn $rv;', 'mp4video', [[timestamp]], 1, 1, 0, 0, 0, 'Use: [[mp4video?mp4=dateiname.mp4&w=640&h=480]]'),
(15, 'fetchNewsItems', 'include_once WB_PATH . ''/modules/news_img/functions.inc.php'';\r\n\r\n$options = array(\r\n    ''group_id_type'' => ''group_id'',    // type used by group_id to extract news entries (supported: ''group_id'', ''page_id'', ''section_id'', ''post_id'')\r\n    ''group_id'' => 0,                  // IDs of news to show, matching defined $group_id_type (default:=0, all news, 0..N, or array(2,4,5,N) to limit news to IDs matching $group_id_type)\r\n    ''start_news_item'' => 0,           // start showing news from the Nth news item onwards (default:= 0, min:=-999, max:= 999); Note: -1: last item, -2: 2nd last etc.\r\n    ''max_news_items'' => 10,           // maximum number of news shown (default:= 10, min:=1, max:= 999)\r\n    ''max_news_length'' => -1,          // maximum length of the short news text shown (default:=-1 => full news length)\r\n    ''strip_tags'' => true,             // true:=remove tags from short and long text (default:=true); false:=don?t strip tags\r\n    ''allowed_tags'' => ''<p><a><img>'',  // tags not striped off (default:=''<p><a><img>'')\r\n    ''custom_placeholder'' => false,    // false:= none (default), array(''MY_VAR_1'' => ''%TAG%#'', ... ''MY_VAR_N'' => ''#regex_N#'' ...)\r\n    ''sort_by'' => 1,                   // 1:=position (default), 2:=posted_when, 3:=published_when, 4:=random order, 5:=number of comments\r\n    ''sort_order'' => 1,                // 1:=descending (default), 2:=ascending\r\n    ''is_not_older_than'' => 0,         // alias for not_older_than (CKE problem, see issue #78)\r\n    ''not_older_than'' => 0,            // 0:=disabled (default), 0-999 (only show news `published_when` date <=x days; 12 hours:=0.5)\r\n    ''lang_id'' => ''AUTO'',              // language file to load and lang_id used if $lang_filer = true (default:= auto, examples: AUTO, DE, EN)\r\n    ''lang_filter'' => false,           // flag to enable language filter (default:= false, show only news from a news page, which language fits $lang_id)\r\n    ''skip'' => null,                   // filter by tags (blacklist)\r\n    ''tags'' => null,                   // filter by tags (whitelist)\r\n    ''view'' => null,                   // use CSS from view (default, faq)\r\n    ''aslist'' => false,                // only titles (<ul>)\r\n    ''groups_on_tags'' => 1\r\n);\r\n\r\n// update options with user defined values\r\nforeach($options as $key => $value) {\r\n	// remove options not defined via [[displayNewsItems?supported_option=VALUE]]\r\n	if (! isset(${$key})) {\r\n		unset($options[$key]);\r\n		continue;\r\n	}\r\n\r\n	// update options with user defined values (will be sanitized in getImageNewsItems later on)\r\n	if ($key == ''group_id'') {\r\n		$options[$key] = explode('','', ${$key});\r\n	} else {\r\n		if (in_array($key, array(''allowed_tags''))) {\r\n			// deal with fact that Droplets don''t yet support urldecode by itself\r\n			${$key} = str_replace(array(''<'', ''%3C'', ''>'', ''%3E''), array(''<'', ''<'', ''>'', ''>''), ${$key});\r\n		}\r\n		if (in_array($key, array(''strip_tags'', ''lang_filter''))) {\r\n			// deal with boolean types (''false'', ''true'' are both True if converted to Boolean)\r\n			${$key} = str_replace(array(''false'', ''true''), array(''0'', ''1''), strtolower(${$key}));\r\n		}\r\n		// strip leading and trailing single and double quotes\r\n		$options[$key] = trim(${$key}, ''"\\'''');\r\n	}\r\n}\r\n\r\n$output = mod_nwi_get_news_items($options);\r\nreturn $output;\r\n\r\n', '', [[timestamp]], 0, 1, 0, 0, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_jsadmin`
--

CREATE TABLE `[[dbprefix]]mod_jsadmin` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `value` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]mod_jsadmin`
--

INSERT INTO `[[dbprefix]]mod_jsadmin` VALUES
(1, 'mod_jsadmin_persist_order', 1),
(2, 'mod_jsadmin_ajax_order_pages', 1),
(3, 'mod_jsadmin_ajax_order_sections', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_menu_link`
--

CREATE TABLE `[[dbprefix]]mod_menu_link` (
  `section_id` int(11) NOT NULL DEFAULT '0',
  `page_id` int(11) NOT NULL DEFAULT '0',
  `target_page_id` int(11) NOT NULL DEFAULT '0',
  `redirect_type` int(3) NOT NULL DEFAULT '301',
  `anchor` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `extern` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`section_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_miniform`
--

CREATE TABLE `[[dbprefix]]mod_miniform` (
  `section_id` int(11) NOT NULL DEFAULT '0',
  `email` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `emailfrom` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `subject` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `confirm_user` int(11) NOT NULL DEFAULT '0',
  `confirm_subject` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `template` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'form',
  `successpage` int(11) NOT NULL DEFAULT '0',
  `use_ajax` int(11) NOT NULL DEFAULT '1',
  `use_recaptcha` int(11) NOT NULL DEFAULT '0',
  `recaptcha_key` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `recaptcha_secret` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `remote_id` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `remote_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `disable_tls` int(11) NOT NULL DEFAULT '0',
  `no_store` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`section_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_miniform_data`
--

CREATE TABLE `[[dbprefix]]mod_miniform_data` (
  `message_id` int(11) NOT NULL AUTO_INCREMENT,
  `section_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `data` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `guid` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `session_data` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `submitted_when` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`message_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_news_img_groups`
--

CREATE TABLE `[[dbprefix]]mod_news_img_groups` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `section_id` int(11) NOT NULL DEFAULT '0',
  `active` int(11) NOT NULL DEFAULT '0',
  `position` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]mod_news_img_groups`
--

INSERT INTO `[[dbprefix]]mod_news_img_groups` VALUES
(1, 0, 0, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_news_img_img`
--

CREATE TABLE `[[dbprefix]]mod_news_img_img` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `picname` varchar(255) NOT NULL DEFAULT '',
  `picdesc` varchar(255) NOT NULL DEFAULT '',
  `post_id` int(11) NOT NULL DEFAULT '0',
  `position` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_news_img_posts`
--

CREATE TABLE `[[dbprefix]]mod_news_img_posts` (
  `post_id` int(11) NOT NULL AUTO_INCREMENT,
  `section_id` int(11) NOT NULL DEFAULT '0',
  `group_id` int(11) NOT NULL DEFAULT '0',
  `active` int(11) NOT NULL DEFAULT '0',
  `position` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `link` text NOT NULL,
  `image` varchar(256) NOT NULL DEFAULT '',
  `content_short` text NOT NULL,
  `content_long` text NOT NULL,
  `content_block2` text NOT NULL,
  `published_when` int(11) NOT NULL DEFAULT '0',
  `published_until` int(11) NOT NULL DEFAULT '0',
  `posted_when` int(11) NOT NULL DEFAULT '0',
  `posted_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`post_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]mod_news_img_posts`
--

INSERT INTO `[[dbprefix]]mod_news_img_posts` VALUES
(1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_news_img_posts_img`
--

CREATE TABLE `[[dbprefix]]mod_news_img_posts_img` (
  `post_id` int(11) NOT NULL,
  `pic_id` int(11) NOT NULL,
  `position` int(11) NOT NULL,
  UNIQUE KEY `post_id_pic_id` (`post_id`,`pic_id`),
  KEY `FK_[[dbprefix]]mod_news_img_posts_img_[[dbprefix]]mod_news_img_img` (`pic_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_news_img_settings`
--

CREATE TABLE `[[dbprefix]]mod_news_img_settings` (
  `section_id` int(11) NOT NULL DEFAULT '0',
  `header` text NOT NULL,
  `post_loop` text NOT NULL,
  `view_order` int(11) NOT NULL DEFAULT '0',
  `footer` text NOT NULL,
  `block2` text NOT NULL,
  `posts_per_page` int(11) NOT NULL DEFAULT '0',
  `post_header` text NOT NULL,
  `post_content` text NOT NULL,
  `image_loop` text NOT NULL,
  `post_footer` text NOT NULL,
  `resize_preview` varchar(50) DEFAULT NULL,
  `crop_preview` char(1) NOT NULL DEFAULT 'N',
  `gallery` text NOT NULL,
  `imgthumbsize` varchar(50) DEFAULT NULL,
  `imgmaxwidth` varchar(50) DEFAULT NULL,
  `imgmaxheight` varchar(50) DEFAULT NULL,
  `imgmaxsize` varchar(50) DEFAULT NULL,
  `use_second_block` char(1) NOT NULL DEFAULT 'N',
  `view` varchar(50) NOT NULL DEFAULT 'default',
  `mode` varchar(50) DEFAULT 'default',
  `show_settings_only_admins` char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]mod_news_img_settings`
--

INSERT INTO `[[dbprefix]]mod_news_img_settings` VALUES
(0, '', '', 0, '', '', 0, '', '', '', '', NULL, 'N', '', NULL, NULL, NULL, NULL, 'N', 'default', 'default', 'N');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_news_img_tags`
--

CREATE TABLE `[[dbprefix]]mod_news_img_tags` (
  `tag_id` int(11) NOT NULL AUTO_INCREMENT,
  `tag` varchar(255) NOT NULL,
  `tag_color` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_news_img_tags_posts`
--

CREATE TABLE `[[dbprefix]]mod_news_img_tags_posts` (
  `post_id` int(11) NOT NULL,
  `tag_id` int(11) NOT NULL,
  UNIQUE KEY `post_id_tag_id` (`post_id`,`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_news_img_tags_sections`
--

CREATE TABLE `[[dbprefix]]mod_news_img_tags_sections` (
  `section_id` int(11) unsigned NOT NULL DEFAULT '0',
  `tag_id` int(11) unsigned NOT NULL,
  UNIQUE KEY `section_id_tag_id` (`section_id`,`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_outputfilter_dashboard`
--

CREATE TABLE `[[dbprefix]]mod_outputfilter_dashboard` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userfunc` tinyint(4) NOT NULL DEFAULT '0',
  `position` int(11) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `allowedit` tinyint(4) NOT NULL DEFAULT '0',
  `allowedittarget` tinyint(4) NOT NULL DEFAULT '0',
  `name` varchar(249) NOT NULL,
  `func` text NOT NULL,
  `type` varchar(255) NOT NULL,
  `file` varchar(255) NOT NULL,
  `csspath` varchar(255) NOT NULL,
  `funcname` varchar(255) NOT NULL,
  `configurl` varchar(255) NOT NULL,
  `plugin` varchar(255) NOT NULL,
  `helppath` text NOT NULL,
  `modules` text NOT NULL,
  `desc` longtext NOT NULL,
  `pages` text NOT NULL,
  `pages_parent` text NOT NULL,
  `additional_values` longtext NOT NULL,
  `additional_fields` text NOT NULL,
  `additional_fields_languages` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `type` (`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]mod_outputfilter_dashboard`
--

INSERT INTO `[[dbprefix]]mod_outputfilter_dashboard` VALUES
(1, 0, 0, 1, 0, 1, 'Cache Control', '', '8page_last', '{OPF:PLUGIN_PATH}/filter.php', '', 'opff_cachecontrol', '', 'cachecontrol', 'a:0:{}', 'a:0:{}', 'a:2:{s:2:"EN";s:182:"Prevent Browsers from delivering outdated files (css, js) from its cache by adding the timestamp of the files to their URLs as a parameter.\nMake sure that this filter is called last!";s:2:"DE";s:220:"Verhindert, dass Browser veraltete CSS- oder JS-Dateien aus ihrem Cache ausliefern, indem der Datei-Timestamp an deren URLs als Parameter angefügt wird.\nAchten Sie darauf, dass dieser Filter als letzter aufgerufen wird!";}', 'a:1:{i:0;s:3:"all";}', 'a:3:{i:0;s:3:"all";i:1;s:7:"backend";i:2;s:1:"0";}', 's:0:"";', 's:0:"";', 's:0:"";'),
(2, 0, 0, 1, 1, 1, 'Colorbox', '', '6page_first', '{OPF:PLUGIN_PATH}/filter.php', '', 'opff_jq_colorbox', '', 'opf_jq_colorbox', 'a:2:{s:2:"EN";s:29:"{OPF:PLUGIN_URL}/help/EN.html";s:2:"DE";s:29:"{OPF:PLUGIN_URL}/help/DE.html";}', 'a:0:{}', 'a:2:{s:2:"EN";s:220:"Use class=colorbox, iframe, youtube, cslide, cfade or csingle as additional CSS class to open a link in a modal window. 5 different styles available via filter config. See http://www.jacklmoore.com/colorbox/ for details.";s:2:"DE";s:255:"Verwende class=colorbox, iframe, youtube, cslide, cfade or csingle als zusätzliche CSS-Klasse, um einen Link in einem Overlay zu öffnen. 5 verschiedene Styles per Filterkonfiguration auswählbar. Besuche http://www.jacklmoore.com/colorbox/ für Details.";}', 'a:1:{i:0;s:3:"all";}', 'a:1:{i:0;s:3:"all";}', 'a:2:{s:6:"places";s:4:"body";s:9:"cb_design";s:1:"1";}', 'a:2:{i:0;a:6:{s:4:"text";s:17:"Write js files to";s:8:"variable";s:6:"places";s:4:"type";s:6:"select";s:4:"name";s:5:"where";s:7:"checked";s:4:"body";s:5:"value";a:2:{s:4:"head";s:4:"Head";s:4:"body";s:4:"Body";}}i:1;a:6:{s:4:"text";s:21:"ColorBox Design Theme";s:8:"variable";s:9:"cb_design";s:4:"type";s:6:"select";s:4:"name";s:6:"design";s:7:"checked";s:1:"1";s:5:"value";a:6:{i:1;s:1:"1";i:2;s:1:"2";i:3;s:1:"3";i:4;s:1:"4";i:5;s:1:"5";s:6:"custom";s:6:"custom";}}}', 's:0:"";'),
(3, 0, 0, 1, 0, 1, 'Droplets Injector', '', '7page', '{SYSVAR:WB_PATH}/modules/droplets/opf_filter_droplets.php', '', 'opff_droplets', '', '', 'a:1:{s:2:"EN";s:71:"(link){SYSVAR:ADMIN_URL}/admintools/tool.php?tool=droplets&do=show_help";}', 'a:0:{}', 'a:2:{s:2:"EN";s:162:"This filter is working in conjunction with the Droplets AdminTool to inject Droplets PHP code at places where Droplet calls are located. (See HELP for more info).";s:2:"DE";s:182:"Dieser Filter arbeitet mit dem Droplets AdminTool zusammen, indem er den PHP-Code aus Droplets an Stellen einzufügt wo Droplet-Aufrufe platziert sind. (Siehe HILFE für mehr Infos).";}', 'a:1:{i:0;s:3:"all";}', 'a:3:{i:0;s:3:"all";i:1;s:8:" backend";i:2;s:2:" 0";}', 's:0:"";', 's:0:"";', 's:0:"";'),
(4, 0, 1, 1, 0, 1, 'Auto Placeholder', '', '6page_first', '{SYSVAR:WB_PATH}/modules/mod_opf_auto_placeholder/filter.php', '', 'opff_mod_opf_auto_placeholder', '', '', 'a:0:{}', 'a:0:{}', 'a:2:{s:2:"EN";s:189:"This filter adds placeholders (hooks) which can be used for code replacements or inserts. See https://help.wbce.org/pages/de/module-programmieren/platzhalter-hooks.php for more information.";s:2:"DE";s:221:"Dieser Filter fügt Platzhalter (Hooks) ein, die für Code-Ersetzungen oder -Ergänzungen genutzt werden können. Siehe https://help.wbce.org/pages/de/module-programmieren/platzhalter-hooks.php für weitere Informationen.";}', 'a:1:{i:0;s:3:"all";}', 'a:3:{i:0;s:3:"all";i:1;s:7:"backend";i:2;s:1:"0";}', 's:0:"";', 's:0:"";', 's:0:"";'),
(5, 0, 1, 1, 0, 1, 'CSS to head', '', '7page', '{SYSVAR:WB_PATH}/modules/mod_opf_csstohead/filter.php', '', 'opff_mod_opf_csstohead', '', '', 'a:0:{}', 'a:0:{}', 'a:2:{s:2:"EN";s:60:"moves css definitions from the body of a page into the head.";s:2:"DE";s:72:"Verschiebt CSS-Definitionen und -Links vom body in den head einer Seite.";}', 'a:1:{i:0;s:3:"all";}', 'a:2:{i:0;s:3:"all";i:1;s:1:"0";}', 's:0:"";', 's:0:"";', 's:0:"";'),
(6, 0, 2, 1, 0, 1, 'E-Mail Masking', '', '7page', '{SYSVAR:WB_PATH}/modules/mod_opf_email/filter.php', '', 'opff_mod_opf_email', '[[softurl]]/admin/admintools/tool.php?tool=mod_opf_email', '', 'a:0:{}', 'a:0:{}', 'a:2:{s:2:"EN";s:155:"Hides e-mail addresses from spambots by masking them with JavaScript and replacing . and @ by (dot) and (at). Can be configured via backend (see cog icon).";s:2:"DE";s:208:"Versteckt E-Mail-Adressen vor Spambots, indem diese mit Javascript maskiert werden und die Zeichen . und @ durch (dot) und (at) ersetzt werden. Kann über das Backend konfiguriert werden (siehe Zahnrad-Icon).";}', 'a:1:{i:0;s:3:"all";}', 'a:2:{i:0;s:3:"all";i:1;s:1:"0";}', 's:0:"";', 's:0:"";', 's:0:"";'),
(7, 0, 1, 1, 0, 1, 'Class Insert Helper', '', '8page_last', '{SYSVAR:WB_PATH}/modules/mod_opf_insert/filter.php', '', 'opff_mod_opf_insert', '', '', 'a:0:{}', 'a:0:{}', 'a:2:{s:2:"EN";s:117:"This filter works in conjunction with Class Insert. Detail instructions will follow in a later iteration of WBCE CMS.";s:2:"DE";s:135:"Dieser Filter arbeitet mit der Klasse Insert zusammen. Detailierte Beschreibungen folgen in einer der nächsten Versionen von WBCE CMS.";}', 'a:1:{i:0;s:3:"all";}', 'a:3:{i:0;s:3:"all";i:1;s:7:"backend";i:2;s:1:"0";}', 's:0:"";', 's:0:"";', 's:0:"";'),
(8, 0, 2, 1, 0, 1, 'Move Contents', '', '8page_last', '{SYSVAR:WB_PATH}/modules/mod_opf_move_stuff/filter.php', '', 'opff_mod_opf_move_stuff', '', '', 'a:0:{}', 'a:0:{}', 'a:2:{s:2:"EN";s:154:"This filter is needed to move content or code to defined hooks. See https://help.wbce.org/pages/de/module-programmieren/platzhalter-hooks.php for details.";s:2:"DE";s:145:"Verschiebt Code an die dafür vorgesehenen Stellen. Siehe https://help.wbce.org/pages/de/module-programmieren/platzhalter-hooks.php für Details.";}', 'a:1:{i:0;s:3:"all";}', 'a:3:{i:0;s:3:"all";i:1;s:7:"backend";i:2;s:1:"0";}', 's:0:"";', 's:0:"";', 's:0:"";'),
(9, 0, 0, 1, 0, 1, 'Remove System PH', '', '9page_final', '{SYSVAR:WB_PATH}/modules/mod_opf_remove_system_ph/filter.php', '', 'opff_mod_opf_remove_system_ph', '', '', 'a:0:{}', 'a:0:{}', 'a:2:{s:2:"EN";s:109:"remove system placeholder markers (HTML comments as hooks) from the sourcecode of the finally generated page.";s:2:"DE";s:107:"Entfernt die System-Platzhalter (HTML-Kommentare als Hooks) aus dem Quellcode der fertig generierten Seite.";}', 'a:1:{i:0;s:3:"all";}', 'a:3:{i:0;s:3:"all";i:1;s:7:"backend";i:2;s:1:"0";}', 's:0:"";', 's:0:"";', 's:0:"";'),
(10, 0, 3, 1, 0, 1, 'Replace Contents', '', '8page_last', '{SYSVAR:WB_PATH}/modules/mod_opf_replace_stuff/filter.php', '', 'opff_mod_opf_replace_stuff', '', '', 'a:0:{}', 'a:0:{}', 'a:2:{s:2:"EN";s:140:"This filter is needed to replace content or code. See https://help.wbce.org/pages/de/module-programmieren/platzhalter-hooks.php for details.";s:2:"DE";s:132:"Ersetzt entsprechend markierten Code. Siehe https://help.wbce.org/pages/de/module-programmieren/platzhalter-hooks.php  für Details.";}', 'a:1:{i:0;s:3:"all";}', 'a:3:{i:0;s:3:"all";i:1;s:7:"backend";i:2;s:1:"0";}', 's:0:"";', 's:0:"";', 's:0:"";'),
(11, 0, 3, 1, 0, 1, 'Internal Link Replacer', '', '7page', '{SYSVAR:WB_PATH}/modules/mod_opf_wblink/filter.php', '', 'opff_mod_opf_wblink', '', '', 'a:0:{}', 'a:0:{}', 'a:2:{s:2:"EN";s:148:"When this filter is active, internal links can be set with the shortcode [wblinkXX] as URL (i.e. [wblink12]  = URL of the page with the page-ID 12).";s:2:"DE";s:151:"Ist dieser Filter aktiviert, können Adressen von internen Seiten als [wblinkXX] angegeben werden (z.B. [wblink12] = URL der seite mit der Page-ID 12).";}', 'a:1:{i:0;s:3:"all";}', 'a:2:{i:0;s:3:"all";i:1;s:1:"0";}', 's:0:"";', 's:0:"";', 's:0:"";');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_page_seo_tool`
--

CREATE TABLE `[[dbprefix]]mod_page_seo_tool` (
  `settings_json` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]mod_page_seo_tool`
--

INSERT INTO `[[dbprefix]]mod_page_seo_tool` VALUES
('{"iTitleCount":{"use":true,"optimum":50,"minimum":30},"iDescriptionCount":{"use":true,"optimum":150,"minimum":90},"keywordsConfig":{"use":true,"wordReplace":"keywords"},"rewriteUrl":{"use":false,"dbString":""},"bUseRemainingChars":true}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_sitemap`
--

CREATE TABLE `[[dbprefix]]mod_sitemap` (
  `section_id` int(11) NOT NULL DEFAULT '0',
  `page_id` int(11) NOT NULL DEFAULT '0',
  `header` text NOT NULL,
  `sitemaploop` text NOT NULL,
  `footer` text NOT NULL,
  `level_header` text NOT NULL,
  `level_footer` text NOT NULL,
  `static` int(11) NOT NULL DEFAULT '0',
  `startatroot` int(11) NOT NULL DEFAULT '0',
  `depth` int(11) NOT NULL DEFAULT '0',
  `show_hidden` int(11) NOT NULL DEFAULT '0',
  `show_settings` int(1) NOT NULL DEFAULT '1',
  `menus` varchar(30) NOT NULL DEFAULT '0',
  `layout` varchar(128) NOT NULL DEFAULT '0',
  PRIMARY KEY (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wbstats_browser`
--

CREATE TABLE `[[dbprefix]]mod_wbstats_browser` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` varchar(8) NOT NULL DEFAULT '',
  `agent` varchar(200) NOT NULL DEFAULT '',
  `browser` varchar(50) NOT NULL DEFAULT '',
  `version` varchar(50) NOT NULL DEFAULT '',
  `os` varchar(100) NOT NULL DEFAULT '',
  `view` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `browser_version` (`browser`,`version`),
  KEY `os` (`os`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wbstats_cfg`
--

CREATE TABLE `[[dbprefix]]mod_wbstats_cfg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL DEFAULT 'none',
  `name` varchar(50) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wbstats_day`
--

CREATE TABLE `[[dbprefix]]mod_wbstats_day` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` varchar(8) NOT NULL DEFAULT '',
  `user` int(10) NOT NULL DEFAULT '0',
  `view` int(10) NOT NULL DEFAULT '0',
  `bots` int(10) NOT NULL DEFAULT '0',
  `suspected` int(10) NOT NULL DEFAULT '0',
  `refspam` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `day` (`day`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wbstats_hist`
--

CREATE TABLE `[[dbprefix]]mod_wbstats_hist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(50) NOT NULL DEFAULT '',
  `session` varchar(64) NOT NULL DEFAULT '',
  `page` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY USING BTREE (`id`),
  KEY `ip` (`ip`,`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wbstats_ips`
--

CREATE TABLE `[[dbprefix]]mod_wbstats_ips` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(50) NOT NULL DEFAULT '',
  `session` varchar(64) NOT NULL DEFAULT '',
  `time` int(20) NOT NULL DEFAULT '0',
  `online` int(20) NOT NULL DEFAULT '0',
  `page` varchar(512) NOT NULL DEFAULT '',
  `last_page` varchar(512) NOT NULL DEFAULT '',
  `last_status` varchar(10) NOT NULL DEFAULT '',
  `pages` int(11) NOT NULL DEFAULT '0',
  `loggedin` int(1) NOT NULL DEFAULT '0',
  `location` varchar(64) NOT NULL DEFAULT '',
  `os` varchar(32) NOT NULL DEFAULT '',
  `browser` varchar(32) NOT NULL DEFAULT '',
  `language` varchar(32) NOT NULL DEFAULT '',
  `referer` varchar(64) NOT NULL DEFAULT '',
  `ua` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `ip` (`ip`,`online`),
  KEY `online` (`online`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wbstats_keywords`
--

CREATE TABLE `[[dbprefix]]mod_wbstats_keywords` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` varchar(8) NOT NULL DEFAULT '',
  `keyword` varchar(255) NOT NULL DEFAULT '',
  `view` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wbstats_lang`
--

CREATE TABLE `[[dbprefix]]mod_wbstats_lang` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` varchar(8) NOT NULL DEFAULT '',
  `language` varchar(2) NOT NULL DEFAULT '',
  `view` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wbstats_loc`
--

CREATE TABLE `[[dbprefix]]mod_wbstats_loc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(50) NOT NULL DEFAULT '',
  `location` varchar(128) NOT NULL DEFAULT '',
  `city` varchar(64) NOT NULL DEFAULT '',
  `country` varchar(64) NOT NULL DEFAULT '',
  `country_code` varchar(64) NOT NULL DEFAULT '',
  `timezone` varchar(64) NOT NULL DEFAULT '',
  `latitude` varchar(12) NOT NULL DEFAULT '',
  `longitude` varchar(12) NOT NULL DEFAULT '',
  `timestamp` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wbstats_pages`
--

CREATE TABLE `[[dbprefix]]mod_wbstats_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` varchar(8) NOT NULL DEFAULT '',
  `page` varchar(255) NOT NULL DEFAULT '',
  `view` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wbstats_ref`
--

CREATE TABLE `[[dbprefix]]mod_wbstats_ref` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` varchar(8) NOT NULL DEFAULT '',
  `referer` varchar(255) NOT NULL DEFAULT '',
  `view` int(10) NOT NULL DEFAULT '0',
  `spam` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wbstats_shop`
--

CREATE TABLE `[[dbprefix]]mod_wbstats_shop` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shoptype` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `order_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `invoice_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `timestamp` int(11) NOT NULL DEFAULT '0',
  `order_total` decimal(12,2) NOT NULL DEFAULT '0.00',
  `status` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_method` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `order_data` mediumtext CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  PRIMARY KEY USING BTREE (`id`),
  KEY `order_id` USING BTREE (`order_id`),
  KEY `timestamp` USING BTREE (`timestamp`),
  KEY `ip` USING BTREE (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wbstats_utm`
--

CREATE TABLE `[[dbprefix]]mod_wbstats_utm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(50) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `session` varchar(64) NOT NULL DEFAULT '',
  `page` varchar(255) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `source` varchar(128) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `medium` varchar(128) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `campaign` varchar(128) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `term` varchar(128) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `content` varchar(128) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `referer` varchar(255) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `timestamp` int(11) NOT NULL DEFAULT '0',
  `pagecount` int(11) NOT NULL DEFAULT '0',
  `day` varchar(8) CHARACTER SET latin1 NOT NULL DEFAULT '',
  PRIMARY KEY USING BTREE (`id`),
  KEY `campaign` USING BTREE (`campaign`),
  KEY `day` USING BTREE (`day`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wrapper`
--

CREATE TABLE `[[dbprefix]]mod_wrapper` (
  `section_id` int(11) NOT NULL DEFAULT '0',
  `page_id` int(11) NOT NULL DEFAULT '0',
  `url` text COLLATE utf8_unicode_ci NOT NULL,
  `height` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`section_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wysiwyg`
--

CREATE TABLE `[[dbprefix]]mod_wysiwyg` (
  `section_id` int(11) NOT NULL DEFAULT '0',
  `page_id` int(11) NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8_unicode_ci NOT NULL,
  `text` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`section_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pages`
--

CREATE TABLE `[[dbprefix]]pages` (
  `page_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` int(11) NOT NULL DEFAULT '0',
  `root_parent` int(11) NOT NULL DEFAULT '0',
  `level` int(11) NOT NULL DEFAULT '0',
  `link` text COLLATE utf8_unicode_ci NOT NULL,
  `target` varchar(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `page_title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `menu_title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `keywords` text COLLATE utf8_unicode_ci NOT NULL,
  `page_trail` text COLLATE utf8_unicode_ci NOT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `visibility` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `visibility_backup` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `position` int(11) NOT NULL DEFAULT '0',
  `menu` int(11) NOT NULL DEFAULT '0',
  `language` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `searching` int(11) NOT NULL DEFAULT '0',
  `admin_groups` text COLLATE utf8_unicode_ci NOT NULL,
  `admin_users` text COLLATE utf8_unicode_ci NOT NULL,
  `viewing_groups` text COLLATE utf8_unicode_ci NOT NULL,
  `viewing_users` text COLLATE utf8_unicode_ci NOT NULL,
  `modified_when` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search`
--

CREATE TABLE `[[dbprefix]]search` (
  `search_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  `extra` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`search_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=20 ;

--
-- Dumping data for table `[[dbprefix]]search`
--

INSERT INTO `[[dbprefix]]search` VALUES
(1, 'header', '<form name="search" action="[WB_URL]/search/index.php" method="get">\n<input type="hidden" name="referrer" value="[REFERRER_ID]" />\n<input type="hidden" name="search_path" value="[SEARCH_PATH]" />\n<input type="text" name="string" value="[SEARCH_STRING]" style="width: 200px;" />&nbsp;&nbsp;<input type="submit" value="[TEXT_SEARCH]" style="width: 100px;" /><br />\n<input type="radio" name="match" id="match_all" value="all"[ALL_CHECKED] /><label for="match_all">[TEXT_ALL_WORDS]</label>&nbsp;&nbsp;\n<input type="radio" name="match" id="match_any" value="any"[ANY_CHECKED] /><label for="match_any">[TEXT_ANY_WORDS]</label>&nbsp;&nbsp;\n<input type="radio" name="match" id="match_exact" value="exact"[EXACT_CHECKED] /><label for="match_exact">[TEXT_EXACT_MATCH]</label>\n\n</form>\n\n<hr />    ', ''),
(2, 'footer', '', ''),
(3, 'results_header', '[TEXT_RESULTS_FOR] ''<b>[SEARCH_STRING]</b>'':\n<dl>', ''),
(4, 'results_loop', '<dt><a href="[LINK]">[TITLE]</a></dt>\n<dd style="margin-bottom:1em"><div>[DESCRIPTION]</div>\n[EXCERPT]</dd>', ''),
(5, 'results_footer', '</dl>', ''),
(6, 'no_results', '<p>[TEXT_NO_RESULTS]</p>', ''),
(7, 'module_order', 'wysiwyg,news_img', ''),
(8, 'max_excerpt', '15', ''),
(9, 'time_limit', '0', ''),
(10, 'cfg_enable_old_search', 'false', ''),
(11, 'cfg_search_keywords', 'true', ''),
(12, 'cfg_search_description', 'true', ''),
(13, 'cfg_show_description', 'true', ''),
(14, 'cfg_enable_flush', 'false', ''),
(15, 'template', '', ''),
(16, 'module', 'news_img', 'a:6:{s:7:"page_id";s:7:"page_id";s:5:"title";s:10:"page_title";s:4:"link";s:4:"link";s:11:"description";s:11:"description";s:13:"modified_when";s:13:"modified_when";s:11:"modified_by";s:11:"modified_by";}'),
(17, 'query_start', 'SELECT [TP]pages.page_id, [TP]pages.page_title, [TP]pages.link, [TP]pages.description, [TP]pages.modified_when, [TP]pages.modified_by    FROM [TP]mod_news_img_posts, [TP]mod_news_img_groups, [TP]mod_news_img_settings, [TP]pages WHERE ', 'news_img'),
(18, 'query_body', '\n        [TP]pages.page_id = [TP]mod_news_img_posts.page_id AND [TP]mod_news_img_posts.title LIKE ''%[STRING]%''\n        OR [TP]pages.page_id = [TP]mod_news_img_posts.page_id AND [TP]mod_news_img_posts.content_short LIKE ''%[STRING]%''\n        OR [TP]pages.page_id = [TP]mod_news_img_posts.page_id AND [TP]mod_news_img_posts.content_long LIKE ''%[STRING]%''\n        OR [TP]pages.page_id = [TP]mod_news_img_posts.page_id AND [TP]mod_news_img_posts.content_block2 LIKE ''%[STRING]%''\n        OR [TP]pages.page_id = [TP]mod_news_img_settings.page_id AND [TP]mod_news_img_settings.header LIKE ''%[STRING]%''\n        OR [TP]pages.page_id = [TP]mod_news_img_settings.page_id AND [TP]mod_news_img_settings.footer LIKE ''%[STRING]%''\n        OR [TP]pages.page_id = [TP]mod_news_img_settings.page_id AND [TP]mod_news_img_settings.post_header LIKE ''%[STRING]%''\n        OR [TP]pages.page_id = [TP]mod_news_img_settings.page_id AND [TP]mod_news_img_settings.post_footer LIKE ''%[STRING]%''', 'news_img'),
(19, 'query_end', '', 'news_img');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sections`
--

CREATE TABLE `[[dbprefix]]sections` (
  `section_id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) NOT NULL DEFAULT '0',
  `position` int(11) NOT NULL DEFAULT '0',
  `module` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `block` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `publ_start` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `publ_end` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `namesection` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`setting_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=104 ;

--
-- Dumping data for table `[[dbprefix]]settings`
--

INSERT INTO `[[dbprefix]]settings` VALUES
(1, 'website_description', ''),
(2, 'website_keywords', ''),
(3, 'website_header', ''),
(4, 'website_footer', ''),
(5, 'wysiwyg_style', 'font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 12px;'),
(6, 'er_level', 'E0'),
(7, 'sec_anchor', 'wbce_'),
(8, 'default_date_format', 'd.m.Y'),
(9, 'default_time_format', 'H:i'),
(10, 'redirect_timer', '500'),
(11, 'home_folders', 'true'),
(12, 'warn_page_leave', '1'),
(13, 'default_template', 'wbcezon'),
(14, 'default_theme', 'wbce_flat_theme'),
(15, 'default_charset', 'utf-8'),
(16, 'multiple_menus', 'true'),
(17, 'page_level_limit', '4'),
(18, 'intro_page', 'false'),
(19, 'page_trash', 'inline'),
(20, 'homepage_redirection', 'false'),
(21, 'page_languages', 'false'),
(22, 'wysiwyg_editor', 'ckeditor'),
(23, 'manage_sections', 'true'),
(24, 'section_blocks', 'true'),
(25, 'smart_login', 'true'),
(26, 'frontend_login', 'false'),
(27, 'frontend_signup', 'false'),
(28, 'search', 'public'),
(29, 'page_extension', '.php'),
(30, 'page_spacer', '-'),
(31, 'pages_directory', '/pages'),
(32, 'rename_files_on_upload', 'ph.*?,cgi,pl,pm,exe,com,bat,pif,cmd,src,asp,aspx,js,lnk,inc'),
(33, 'media_directory', '/media'),
(34, 'wbmailer_routine', 'phpmail'),
(35, 'wbmailer_default_sendername', 'WBCE CMS Mailer'),
(36, 'wbmailer_smtp_host', ''),
(37, 'wbmailer_smtp_auth', ''),
(38, 'wbmailer_smtp_username', ''),
(39, 'wbmailer_smtp_password', ''),
(40, 'wbmailer_smtp_secure', ''),
(41, 'wbmailer_smtp_port', ''),
(42, 'fingerprint_with_ip_octets', '2'),
(43, 'mediasettings', ''),
(44, 'wbce_version', '1.6.5'),
(45, 'wbce_tag', '1.6.5'),
(46, 'wb_version', '2.8.3'),
(47, 'wb_revision', '1641'),
(48, 'wb_sp', 'SP4'),
(49, 'website_title', '[[site_name]]'),
(50, 'default_language', '[[language]]'),
(51, 'app_name', '[[app_name]]'),
(52, 'default_timezone', '-14400'),
(53, 'operating_system', 'linux'),
(54, 'string_file_mode', '[[file_mode]]'),
(55, 'string_dir_mode', '[[dir_mode]]'),
(56, 'server_email', '[[admin_email]]'),
(57, 'opf_cache_control', '1'),
(58, 'opf_cache_control_be', 'btrueb'),
(59, 'opf_colorbox', '1'),
(60, 'opf_droplets', '1'),
(61, 'opf_auto_placeholder', '1'),
(62, 'opf_move_stuff', '1'),
(63, 'opf_replace_stuff', '1'),
(64, 'opf_css_to_head', '1'),
(65, 'opf_wblink', '1'),
(66, 'opf_short_url', '0'),
(67, 'opf_sys_rel', '0'),
(68, 'opf_remove_system_ph', '1'),
(69, 'opf_droplets_be', '1'),
(70, 'opf_auto_placeholder_be', '1'),
(71, 'opf_move_stuff_be', '1'),
(72, 'opf_replace_stuff_be', '1'),
(73, 'opf_css_to_head_be', '0'),
(74, 'opf_remove_system_ph_be', '1'),
(75, 'opf_droplets_injector', '1'),
(76, 'cmc_cfg', 'a:3:{s:5:"theme";s:8:"wbce-day";s:4:"font";s:6:"Proggy";s:9:"font_size";s:2:"14";}'),
(77, 'wb_secform_secret', '5609bnefg93jmgi99igjefg'),
(78, 'wb_secform_secrettime', '86400'),
(79, 'wb_secform_timeout', '7200'),
(80, 'wb_session_timeout', '7200'),
(81, 'wb_secform_tokenname', 'formtoken'),
(82, 'wb_secform_usefp', 'bfalseb'),
(83, 'enabled_captcha', 'btrueb'),
(84, 'enabled_asp', 'btrueb'),
(85, 'captcha_type', 'calc_text'),
(86, 'asp_session_min_age', '20'),
(87, 'asp_view_min_age', '10'),
(88, 'asp_input_min_age', '5'),
(89, 'ct_text', ''),
(90, 'wb_maintainance_mode', 'bfalseb'),
(91, 'opf_email_filter', '1'),
(92, 'opf_mailto_filter', '1'),
(93, 'opf_js_mailto', '1'),
(94, 'opf_at_replacement', '(at)'),
(95, 'opf_dot_replacement', '(dot)'),
(96, 'opf_email', '1'),
(97, 'opf_email_masking', '1'),
(98, 'opf_insert', '1'),
(99, 'opf_insert_be', '1'),
(100, 'opf_class_insert_helper', '1'),
(101, 'opf_move_contents', '1'),
(102, 'opf_replace_contents', '1'),
(103, 'opf_internal_link_replacer', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL DEFAULT '0',
  `groups_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `username` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `display_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'DE',
  `email` text COLLATE utf8_unicode_ci NOT NULL,
  `signup_checksum` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `active` int(11) NOT NULL DEFAULT '0',
  `gdpr_check` int(1) NOT NULL DEFAULT '0',
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `remember_key` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `last_reset` int(11) NOT NULL DEFAULT '0',
  `timezone` varchar(11) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date_format` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `time_format` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `home_folder` text COLLATE utf8_unicode_ci NOT NULL,
  `login_when` int(11) NOT NULL DEFAULT '0',
  `login_ip` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `signup_timestamp` int(11) NOT NULL DEFAULT '0',
  `signup_timeout` int(11) NOT NULL DEFAULT '0',
  `signup_confirmcode` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, 1, '1', '[[admin_username]]', '[[admin_realname]]', '[[language]]', '[[admin_email]]', '[[regtime]]', 1, 0, '[[admin_pass]]', '', 0, '-14400', '', '', '', 0, '', [[timestamp]], 0, 'install-script');

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]mod_news_img_posts_img`
--
ALTER TABLE `[[dbprefix]]mod_news_img_posts_img`
  ADD CONSTRAINT `FK_[[dbprefix]]mod_news_img_posts_img_[[dbprefix]]mod_news_img_img` FOREIGN KEY (`pic_id`) REFERENCES `[[dbprefix]]mod_news_img_img` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_[[dbprefix]]mod_news_img_posts_img_[[dbprefix]]mod_news_img_posts` FOREIGN KEY (`post_id`) REFERENCES `[[dbprefix]]mod_news_img_posts` (`post_id`) ON DELETE CASCADE ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
