<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = 'uvdesk/community-skeleton';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'carbonphp/carbon-doctrine-types' => '1.0.0@3c430083d0b41ceed84ecccf9dac613241d7305d',
  'composer/package-versions-deprecated' => '1.11.99.5@b4f54f74ef3453349c24a845d22392cd31e65f1d',
  'doctrine/annotations' => '1.14.4@253dca476f70808a5aeed3a47cc2cc88c5cab915',
  'doctrine/cache' => '2.2.0@1ca8f21980e770095a31456042471a57bc4c68fb',
  'doctrine/collections' => '2.2.2@d8af7f248c74f195f7347424600fd9e17b57af59',
  'doctrine/common' => '3.5.0@d9ea4a54ca2586db781f0265d36bea731ac66ec5',
  'doctrine/data-fixtures' => '1.6.7@ae4e845decbe177348fdbecd04331f4fb96aa301',
  'doctrine/dbal' => '2.13.9@c480849ca3ad6706a39c970cdfe6888fa8a058b8',
  'doctrine/deprecations' => '1.1.4@31610dbb31faa98e6b5447b62340826f54fbc4e9',
  'doctrine/doctrine-bundle' => '2.7.2@22d53b2c5ad03929628fb4a928b01135585b7179',
  'doctrine/doctrine-fixtures-bundle' => '3.4.5@5988484f79362cd7d06564bd11be7ce622e08c87',
  'doctrine/doctrine-migrations-bundle' => '2.2.3@0a081b55a88259a887af7be654743a8c5f703e99',
  'doctrine/event-manager' => '1.2.0@95aa4cb529f1e96576f3fda9f5705ada4056a520',
  'doctrine/inflector' => '2.0.10@5817d0659c5b50c9b950feb9af7b9668e2c436bc',
  'doctrine/instantiator' => '2.0.0@c6222283fa3f4ac679f8b9ced9a4e23f163e80d0',
  'doctrine/lexer' => '2.1.1@861c870e8b75f7c8f69c146c7f89cc1c0f1b49b6',
  'doctrine/migrations' => '2.3.5@28d92a34348fee5daeb80879e56461b2e862fc05',
  'doctrine/orm' => '2.20.1@e3cabade99ebccc6ba078884c1c5f250866a494e',
  'doctrine/persistence' => '3.4.0@0ea965320cec355dba75031c1b23d4c78362e3ff',
  'doctrine/sql-formatter' => '1.5.1@b784cbde727cf806721451dde40eff4fec3bbe86',
  'egulias/email-validator' => '3.2.6@e5997fa97e8790cdae03a9cbd5e78e45e3c7bda7',
  'friendsofphp/proxy-manager-lts' => 'v1.0.18@2c8a6cffc3220e99352ad958fe7cf06bf6f7690f',
  'google/recaptcha' => '1.3.0@d59a801e98a4e9174814a6d71bbc268dff1202df',
  'guzzlehttp/psr7' => '2.7.0@a70f5c95fb43bc83f07c9c948baa0dc1829bf201',
  'iamcal/lib_autolink' => 'v1.9@6a9e44d17f836806301b40723af673971a1a5112',
  'illuminate/cache' => 'v8.83.27@7ae5b3661413dad7264b5c69037190d766bae50f',
  'illuminate/collections' => 'v8.83.27@705a4e1ef93cd492c45b9b3e7911cccc990a07f4',
  'illuminate/contracts' => 'v8.83.27@5e0fd287a1b22a6b346a9f7cd484d8cf0234585d',
  'illuminate/filesystem' => 'v8.83.27@73db3e9a233ed587ba54f52ab8580f3c7bc872b2',
  'illuminate/macroable' => 'v8.83.27@aed81891a6e046fdee72edd497f822190f61c162',
  'illuminate/support' => 'v8.83.27@1c79242468d3bbd9a0f7477df34f9647dde2a09b',
  'intervention/image' => '2.7.2@04be355f8d6734c826045d02a1079ad658322dad',
  'intervention/imagecache' => '2.6.0@86136575a62d3634b51f196a998fce4a583b49bb',
  'knplabs/knp-components' => 'v3.6.0@145d74f3fbb24619a60a6f7e54aa4bd10862b07a',
  'knplabs/knp-paginator-bundle' => 'v5.9.0@7879916a8af4f4d4668535cb0b71f55cc416da66',
  'laminas/laminas-code' => '4.16.0@1793e78dad4108b594084d05d1fb818b85b110af',
  'monolog/monolog' => '2.10.0@5cf826f2991858b54d5c3809bee745560a1042a7',
  'nesbot/carbon' => '2.72.6@1e9d50601e7035a4c61441a208cb5bed73e108c5',
  'opis/closure' => '3.6.3@3d81e4309d2a927abbe66df935f4bb60082805ad',
  'php-mime-mail-parser/php-mime-mail-parser' => '7.1.2@81d84bbc6a73b913110e155e98059526825c7ee3',
  'phpdocumentor/reflection-common' => '2.2.0@1d01c49d4ed62f25aa84a747ad35d5a16924662b',
  'phpdocumentor/reflection-docblock' => '5.6.1@e5e784149a09bd69d9a5e3b01c5cbd2e2bd653d8',
  'phpdocumentor/type-resolver' => '1.10.0@679e3ce485b99e84c775d28e2e96fade9a7fb50a',
  'phpstan/phpdoc-parser' => '1.33.0@82a311fd3690fb2bf7b64d5c98f912b3dd746140',
  'psr/cache' => '2.0.0@213f9dbc5b9bfbc4f8db86d2838dc968752ce13b',
  'psr/clock' => '1.0.0@e41a24703d4560fd0acb709162f73b8adfc3aa0d',
  'psr/container' => '1.1.2@513e0666f7216c7459170d56df27dfcefe1689ea',
  'psr/event-dispatcher' => '1.0.0@dbefd12671e8a14ec7f180cab83036ed26714bb0',
  'psr/http-factory' => '1.1.0@2b4765fddfe3b508ac62f829e852b1501d3f6e8a',
  'psr/http-message' => '2.0@402d35bcb92c70c026d1a6a9883f06b2ead23d71',
  'psr/link' => '1.1.1@846c25f58a1f02b93a00f2404e3626b6bf9b7807',
  'psr/log' => '2.0.0@ef29f6d262798707a9edd554e2b82517ef3a9376',
  'psr/simple-cache' => '1.0.1@408d5eafb83c57f6365a3ca330ff23aa4a5fa39b',
  'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822',
  'sensio/framework-extra-bundle' => 'v6.2.10@2f886f4b31f23c76496901acaedfedb6936ba61f',
  'swiftmailer/swiftmailer' => 'v6.3.0@8a5d5072dca8f48460fce2f4131fcc495eec654c',
  'symfony/asset' => 'v5.4.45@b7a18eaff1d717c321b4f13403413f8815bf9cb0',
  'symfony/cache' => 'v5.4.46@0fe08ee32cec2748fbfea10c52d3ee02049e0f6b',
  'symfony/cache-contracts' => 'v2.5.4@517c3a3619dadfa6952c4651767fcadffb4df65e',
  'symfony/config' => 'v5.4.46@977c88a02d7d3f16904a81907531b19666a08e78',
  'symfony/console' => 'v5.4.47@c4ba980ca61a9eb18ee6bcc73f28e475852bb1ed',
  'symfony/dependency-injection' => 'v5.4.48@e5ca16dee39ef7d63e552ff0bf0a2526a1142c92',
  'symfony/deprecation-contracts' => 'v3.5.1@74c71c939a79f7d5bf3c1ce9f5ea37ba0114c6f6',
  'symfony/doctrine-bridge' => 'v5.4.48@43ed5e31c9188e4f4d3845d16986db4a86644eef',
  'symfony/dotenv' => 'v5.4.48@08013403089c8a126c968179179b817a552841ab',
  'symfony/error-handler' => 'v5.4.46@d19ede7a2cafb386be9486c580649d0f9e3d0363',
  'symfony/event-dispatcher' => 'v5.4.45@72982eb416f61003e9bb6e91f8b3213600dcf9e9',
  'symfony/event-dispatcher-contracts' => 'v3.5.1@7642f5e970b672283b7823222ae8ef8bbc160b9f',
  'symfony/expression-language' => 'v5.4.45@a784b66edc4c151eb05076d04707906ee2c209a9',
  'symfony/filesystem' => 'v5.4.45@57c8294ed37d4a055b77057827c67f9558c95c54',
  'symfony/finder' => 'v5.4.45@63741784cd7b9967975eec610b256eed3ede022b',
  'symfony/flex' => 'v2.4.7@92f4fba342161ff36072bd3b8e0b3c6c23160402',
  'symfony/form' => 'v5.4.45@c1974a723cdee8a273cb49ce13fada5c1667706a',
  'symfony/framework-bundle' => 'v5.4.45@3d70f14176422d4d8ee400b6acae4e21f7c25ca2',
  'symfony/http-client' => 'v5.4.49@d77d8e212cde7b5c4a64142bf431522f19487c28',
  'symfony/http-client-contracts' => 'v2.5.5@48ef1d0a082885877b664332b9427662065a360c',
  'symfony/http-foundation' => 'v5.4.48@3f38b8af283b830e1363acd79e5bc3412d055341',
  'symfony/http-kernel' => 'v5.4.48@c2dbfc92b851404567160d1ecf3fb7d9b7bde9b0',
  'symfony/intl' => 'v5.4.47@5258476a3ab680cd633a1d23130fcc9e8027e3ff',
  'symfony/mailer' => 'v5.4.45@f732e1fafdf0f4a2d865e91f1018aaca174aeed9',
  'symfony/mime' => 'v5.4.45@8c1b9b3e5b52981551fc6044539af1d974e39064',
  'symfony/monolog-bridge' => 'v5.4.45@cf7d75d4d64a41fbb1c0e92301bec404134fa84b',
  'symfony/monolog-bundle' => 'v3.10.0@414f951743f4aa1fd0f5bf6a0e9c16af3fe7f181',
  'symfony/notifier' => 'v5.4.45@d3c9c31224684ab10a4b9614aaf21985b2e0d41b',
  'symfony/options-resolver' => 'v5.4.45@74e5b6f0db3e8589e6cfd5efb317a1fc2bb52fb6',
  'symfony/password-hasher' => 'v5.4.45@6c5993b24505f98b90ca4896448012bbec54c7c8',
  'symfony/polyfill-intl-grapheme' => 'v1.31.0@b9123926e3b7bc2f98c02ad54f6a4b02b91a8abe',
  'symfony/polyfill-intl-icu' => 'v1.31.0@d80a05e9904d2c2b9b95929f3e4b5d3a8f418d78',
  'symfony/polyfill-intl-idn' => 'v1.31.0@c36586dcf89a12315939e00ec9b4474adcb1d773',
  'symfony/polyfill-intl-normalizer' => 'v1.31.0@3833d7255cc303546435cb650316bff708a1c75c',
  'symfony/polyfill-mbstring' => 'v1.31.0@85181ba99b2345b0ef10ce42ecac37612d9fd341',
  'symfony/polyfill-php73' => 'v1.31.0@0f68c03565dcaaf25a890667542e8bd75fe7e5bb',
  'symfony/polyfill-php80' => 'v1.31.0@60328e362d4c2c802a54fcbf04f9d3fb892b4cf8',
  'symfony/polyfill-php81' => 'v1.31.0@4a4cfc2d253c21a5ad0e53071df248ed48c6ce5c',
  'symfony/process' => 'v5.4.47@5d1662fb32ebc94f17ddb8d635454a776066733d',
  'symfony/property-access' => 'v5.4.45@111e7ed617509f1a9139686055d234aad6e388e0',
  'symfony/property-info' => 'v5.4.48@a0396295ad585f95fccd690bc6a281e5bd303902',
  'symfony/proxy-manager-bridge' => 'v5.4.45@e96cd37f3de0b75ff32f6b79c180ba77c4037eec',
  'symfony/routing' => 'v5.4.48@dd08c19879a9b37ff14fd30dcbdf99a4cf045db1',
  'symfony/runtime' => 'v5.4.46@242b4d773c004fa258e1b412f3f49fc2ac78353a',
  'symfony/security-bundle' => 'v5.4.45@d6081d1b9118f944df90bb77444a8617eba01542',
  'symfony/security-core' => 'v5.4.48@cca947b1a74bdbc21c4d6288a4abb938d9a7eaba',
  'symfony/security-csrf' => 'v5.4.45@28dcafc3220f12264bb2aabe2389a2163458c1f4',
  'symfony/security-guard' => 'v5.4.45@f3da3dbec38aaedaf287ffeb4e3a90994af37faa',
  'symfony/security-http' => 'v5.4.47@cde02b002e0447075430e6a84482e38f2fd9268d',
  'symfony/serializer' => 'v5.4.45@460c5df9fb6c39d10d5b7f386e4feae4b6370221',
  'symfony/service-contracts' => 'v2.5.4@f37b419f7aea2e9abf10abd261832cace12e3300',
  'symfony/stopwatch' => 'v5.4.45@fb2c199cf302eb207f8c23e7ee174c1c31a5c004',
  'symfony/string' => 'v5.4.47@136ca7d72f72b599f2631aca474a4f8e26719799',
  'symfony/swiftmailer-bundle' => 'v3.5.4@9daab339f226ac958192bf89836cb3378cc0e652',
  'symfony/translation' => 'v5.4.45@98f26acc99341ca4bab345fb14d7b1d7cb825bed',
  'symfony/translation-contracts' => 'v2.5.4@450d4172653f38818657022252f9d81be89ee9a8',
  'symfony/twig-bridge' => 'v5.4.48@853a0c9aa40123a9feeb335c865b659d94e49e5d',
  'symfony/twig-bundle' => 'v5.4.45@e1ca56e1dc7791eb19f0aff71d3d94e6a91cc8f9',
  'symfony/validator' => 'v5.4.48@883667679d93d6c30f1b7490d669801712d3be2f',
  'symfony/var-dumper' => 'v5.4.48@42f18f170aa86d612c3559cfb3bd11a375df32c8',
  'symfony/var-exporter' => 'v6.4.13@0f605f72a363f8743001038a176eeb2a11223b51',
  'symfony/web-link' => 'v5.4.45@5b71baea258dbbe2a3627cb11c1721e8a2216a55',
  'symfony/yaml' => 'v5.4.45@a454d47278cc16a5db371fe73ae66a78a633371e',
  'twig/extra-bundle' => 'v3.18.0@9746573ca4bc1cd03a767a183faadaf84e0c31fa',
  'twig/twig' => 'v3.18.0@acffa88cc2b40dbe42eaf3a5025d6c0d4600cc50',
  'uvdesk/api-bundle' => 'v1.1.3@a185ba1f3ce7e64fe818ba795d11076db34b22ab',
  'uvdesk/automation-bundle' => 'v1.1.3@65ba99f427d1d3df41af03edf22dd9989f4ecf74',
  'uvdesk/core-framework' => 'v1.1.6@ba4d561e4831358ad0a8ad34e7f6a0d5e6e2da01',
  'uvdesk/extension-framework' => 'v1.1.2@7fc4b0bf225b606c1679d9a51b579733a8494685',
  'uvdesk/mailbox-component' => 'v1.1.4@ad6cfee1764e4fa081663fc60879ed63efc1544e',
  'uvdesk/support-center-bundle' => 'v1.1.3.2@1089ba789a9be46df5d4f257a7f53707715489d6',
  'voku/portable-ascii' => '1.6.1@87337c91b9dfacee02452244ee14ab3c43bc485a',
  'webmozart/assert' => '1.11.0@11cb2199493b2f8a3b53e7f19068fc6aac760991',
  'myclabs/deep-copy' => '1.12.1@123267b2c49fbf30d78a7b2d333f6be754b94845',
  'nikic/php-parser' => 'v4.19.4@715f4d25e225bc47b293a8b997fe6ce99bf987d2',
  'phar-io/manifest' => '2.0.4@54750ef60c58e43759730615a392c31c80e23176',
  'phar-io/version' => '3.2.1@4f7fd7836c6f332bb2933569e566a0d6c4cbed74',
  'phpunit/php-code-coverage' => '9.2.32@85402a822d1ecf1db1096959413d35e1c37cf1a5',
  'phpunit/php-file-iterator' => '3.0.6@cf1c2e7c203ac650e352f4cc675a7021e7d1b3cf',
  'phpunit/php-invoker' => '3.1.1@5a10147d0aaf65b58940a0b72f71c9ac0423cc67',
  'phpunit/php-text-template' => '2.0.4@5da5f67fc95621df9ff4c4e5a84d6a8a2acf7c28',
  'phpunit/php-timer' => '5.0.3@5a63ce20ed1b5bf577850e2c4e87f4aa902afbd2',
  'phpunit/phpunit' => '9.6.22@f80235cb4d3caa59ae09be3adf1ded27521d1a9c',
  'sebastian/cli-parser' => '1.0.2@2b56bea83a09de3ac06bb18b92f068e60cc6f50b',
  'sebastian/code-unit' => '1.0.8@1fc9f64c0927627ef78ba436c9b17d967e68e120',
  'sebastian/code-unit-reverse-lookup' => '2.0.3@ac91f01ccec49fb77bdc6fd1e548bc70f7faa3e5',
  'sebastian/comparator' => '4.0.8@fa0f136dd2334583309d32b62544682ee972b51a',
  'sebastian/complexity' => '2.0.3@25f207c40d62b8b7aa32f5ab026c53561964053a',
  'sebastian/diff' => '4.0.6@ba01945089c3a293b01ba9badc29ad55b106b0bc',
  'sebastian/environment' => '5.1.5@830c43a844f1f8d5b7a1f6d6076b784454d8b7ed',
  'sebastian/exporter' => '4.0.6@78c00df8f170e02473b682df15bfcdacc3d32d72',
  'sebastian/global-state' => '5.0.7@bca7df1f32ee6fe93b4d4a9abbf69e13a4ada2c9',
  'sebastian/lines-of-code' => '1.0.4@e1e4a170560925c26d424b6a03aed157e7dcc5c5',
  'sebastian/object-enumerator' => '4.0.4@5c9eeac41b290a3712d88851518825ad78f45c71',
  'sebastian/object-reflector' => '2.0.4@b4f479ebdbf63ac605d183ece17d8d7fe49c15c7',
  'sebastian/recursion-context' => '4.0.5@e75bd0f07204fec2a0af9b0f3cfe97d05f92efc1',
  'sebastian/resource-operations' => '3.0.4@05d5692a7993ecccd56a03e40cd7e5b09b1d404e',
  'sebastian/type' => '3.2.1@75e2c2a32f5e0b3aef905b9ed0b179b953b3d7c7',
  'sebastian/version' => '3.0.2@c6c1022351a901512170118436c764e473f6de8c',
  'symfony/browser-kit' => 'v5.4.45@03cce39764429e07fbab9b989a1182a24578341d',
  'symfony/css-selector' => 'v5.4.45@4f7f3c35fba88146b56d0025d20ace3f3901f097',
  'symfony/debug-bundle' => 'v5.4.45@653c7629d036ef24ac5de54a157aecdc400d2570',
  'symfony/dom-crawler' => 'v5.4.48@b57df76f4757a9a8dfbb57ba48d7780cc20776c6',
  'symfony/maker-bundle' => 'v1.50.0@a1733f849b999460c308e66f6392fb09b621fa86',
  'symfony/phpunit-bridge' => 'v7.2.0@2bbde92ab25a0e2c88160857af7be9db5da0d145',
  'symfony/web-profiler-bundle' => 'v5.4.48@4afb0399456b966be92410d2bbd6146cc3ce2174',
  'theseer/tokenizer' => '1.2.3@737eda637ed5e28c3413cb1ebe8bb52cbf1ca7a2',
  'symfony/polyfill-ctype' => '*@',
  'symfony/polyfill-iconv' => '*@',
  'symfony/polyfill-php72' => '*@',
  'uvdesk/community-skeleton' => 'v1.1.7@',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!self::composer2ApiUsable()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (self::composer2ApiUsable()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }

    private static function composer2ApiUsable(): bool
    {
        if (!class_exists(InstalledVersions::class, false)) {
            return false;
        }

        if (method_exists(InstalledVersions::class, 'getAllRawData')) {
            $rawData = InstalledVersions::getAllRawData();
            if (count($rawData) === 1 && count($rawData[0]) === 0) {
                return false;
            }
        } else {
            $rawData = InstalledVersions::getRawData();
            if ($rawData === null || $rawData === []) {
                return false;
            }
        }

        return true;
    }
}
