+function ($) {
    "use strict";

    // TOGGLE CLASS DEFINITION
    // ============================

    var Toggler = function (element, options) {
        this.options = options
        this.$el = $(element)

        this.$el.on('click', $.proxy(this.onClicked, this))

        if (this.options.disabled)
            this.$el.attr('readonly', true)
    }

    Toggler.DEFAULTS = {
        disabled: true
    }

    Toggler.prototype.onClicked = function (event) {
        var $element = $(event.target)

        if ($element.attr('readonly'))
            this.$el.attr('readonly', false)
    }

    // TOGGLE PLUGIN DEFINITION
    // ============================

    var old = $.fn.toggler

    $.fn.toggler = function (option) {
        var args = Array.prototype.slice.call(arguments, 1), result
        this.each(function () {
            var $this = $(this)
            var data = $this.data('ti.toggler')
            var options = $.extend({}, Toggler.DEFAULTS, $this.data(), typeof option == 'object' && option)
            if (!data) $this.data('ti.toggler', (data = new Toggler(this, options)))
            if (typeof option == 'string') result = data[option].apply(data, args)
            if (typeof result != 'undefined') return false
        })

        return result ? result : this
    }

    $.fn.toggler.Constructor = Toggler

    // TOGGLE NO CONFLICT
    // =================

    $.fn.toggler.noConflict = function () {
        $.fn.toggler = old
        return this
    }

    // TOGGLE DATA-API
    // ===============
    $(document).render(function () {
        $('[data-toggle="disabled"]').toggler()
    })

}(window.jQuery);
