
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `suitecrm7150`
--

-- --------------------------------------------------------

--
-- Table structure for table `accounts`
--

CREATE TABLE `accounts` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `account_type` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `industry` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `annual_revenue` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_fax` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_address_street` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_address_city` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_address_state` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_address_postalcode` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_address_country` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `rating` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_office` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_alternate` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `website` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ownership` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `employees` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ticker_symbol` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_address_street` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_address_city` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_address_state` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_address_postalcode` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_address_country` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `sic_code` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `campaign_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_accnt_id_del` (`id`,`deleted`),
  KEY `idx_accnt_name_del` (`name`,`deleted`),
  KEY `idx_accnt_assigned_del` (`deleted`,`assigned_user_id`),
  KEY `idx_accnt_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `accounts_audit`
--

CREATE TABLE `accounts_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_accounts_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `accounts_bugs`
--

CREATE TABLE `accounts_bugs` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `account_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bug_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_acc_bug_acc` (`account_id`),
  KEY `idx_acc_bug_bug` (`bug_id`),
  KEY `idx_account_bug` (`account_id`,`bug_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `accounts_cases`
--

CREATE TABLE `accounts_cases` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `account_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `case_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_acc_case_acc` (`account_id`),
  KEY `idx_acc_acc_case` (`case_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `accounts_contacts`
--

CREATE TABLE `accounts_contacts` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `contact_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `account_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_account_contact` (`account_id`,`contact_id`),
  KEY `idx_contid_del_accid` (`contact_id`,`deleted`,`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `accounts_cstm`
--

CREATE TABLE `accounts_cstm` (
  `id_c` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `jjwg_maps_lng_c` float(11,8) DEFAULT '0.00000000',
  `jjwg_maps_lat_c` float(10,8) DEFAULT '0.00000000',
  `jjwg_maps_geocode_status_c` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `jjwg_maps_address_c` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id_c`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `accounts_opportunities`
--

CREATE TABLE `accounts_opportunities` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `opportunity_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `account_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_account_opportunity` (`account_id`,`opportunity_id`),
  KEY `idx_oppid_del_accid` (`opportunity_id`,`deleted`,`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `acl_actions`
--

CREATE TABLE `acl_actions` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `category` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `acltype` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `aclaccess` int DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_aclaction_id_del` (`id`,`deleted`),
  KEY `idx_category_name` (`category`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `acl_actions`
--

INSERT INTO `acl_actions` VALUES
('001b6c2a-8d0b-4e7f-a65d-0df9fa3e20c4', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Leads', 'module', 90, 0),
('0079015c-274d-4615-bab1-2c48c224025f', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AM_TaskTemplates', 'module', 90, 0),
('00dcd813-dd05-4aa0-99f1-b0761bfbab31', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AOP_Case_Events', 'module', 90, 0),
('00efd864-8f58-4a35-baaa-2a7d9fad6991', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Cases', 'module', 90, 0),
('00f2eb50-2f50-494a-9899-ffac75288fac', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AOW_WorkFlow', 'module', 90, 0),
('01a55d0a-aaae-4034-a4fb-e89a3954f172', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Alerts', 'module', 90, 0),
('020e359b-84ed-40a4-bbfc-09e2822f84ca', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'SecurityGroups', 'module', 90, 0),
('02655409-4eaf-438f-8971-20a639768fbe', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Users', 'module', 90, 0),
('028cfa5b-b3cf-40f0-8183-d61857ca2f98', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Emails', 'module', 90, 0),
('02ab55c7-8801-4d5c-9508-fbe3d764edcd', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'FP_Event_Locations', 'module', 90, 0),
('03be2827-949b-4d03-a1aa-c1e0252cf7f2', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AOD_IndexEvent', 'module', 90, 0),
('0502b8e4-d91e-44e0-917a-1b5c061c3365', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Opportunities', 'module', 90, 0),
('055b969a-d032-480e-b6e1-aee46b161324', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AOS_Products', 'module', 90, 0),
('067f4814-9d17-4a50-9f2c-7714971f92f7', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'ExternalOAuthProvider', 'module', 90, 0),
('0721f113-79fb-46bc-a806-e8373236d6c3', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'ProspectLists', 'module', 90, 0),
('07ceeb36-0957-4366-b327-0a898f982e17', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'TemplateSectionLine', 'module', 90, 0),
('08537129-7ec2-4d2f-b9df-816e0e2557f9', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'ProspectLists', 'module', 90, 0),
('08bdcd96-a7a7-488a-9fd9-698bd1d80da3', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'SurveyQuestionOptions', 'module', 89, 0),
('0a06de77-2dda-42eb-b532-b76374f67f14', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Opportunities', 'module', 90, 0),
('0a98faea-9942-4825-a7de-2b10410d608b', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Cases', 'module', 89, 0),
('0ac3a418-d663-4819-802e-6ad8027713f4', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'ExternalOAuthConnection', 'module', 90, 0),
('0aee84d7-99c4-4874-963d-60dc3f2b07ed', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Opportunities', 'module', 90, 0),
('0b40ca08-8336-4325-83d9-1a4c2095656d', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Campaigns', 'module', 90, 0),
('0bc5d5a5-7b77-4643-b998-d13703d83cb7', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Calls_Reschedule', 'module', 90, 0),
('0bd56a0b-5900-4abe-ad27-5761c6075496', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AOW_Processed', 'module', 90, 0),
('0c7f15c8-54e2-4abb-8b2b-8060abd3080e', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AM_ProjectTemplates', 'module', 90, 0),
('0df470a5-1d1b-4da7-aa87-2024af638d40', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AOS_Products', 'module', 90, 0),
('0eaf77ae-4cff-430c-9fe4-1fb99e3f014e', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'ExternalOAuthConnection', 'module', 90, 0),
('0ed0d54c-c995-4d60-a4d9-8afdffed34fa', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AOR_Reports', 'module', 90, 0),
('0f20f6b5-8620-4c1d-9825-8f02d5c63c0c', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'jjwg_Maps', 'module', 90, 0),
('0fcf4942-82de-48f5-9489-4c81f8cf7350', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Project', 'module', 90, 0),
('109e8d02-8c93-482c-8fbb-74e7b2d175ec', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Surveys', 'module', 89, 0),
('11591b63-36c0-4c88-9e45-2e2027bf90d8', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'SurveyQuestions', 'module', 90, 0),
('11ce1039-bf5b-4dbd-8d44-1d8f28062747', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Contacts', 'module', 90, 0),
('12ddfdb7-6dd2-4298-9f5d-a028c08f07a2', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Contacts', 'module', 90, 0),
('130950c9-5eed-41fe-ae02-e19e1cb02c22', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Calls', 'module', 90, 0),
('13d76a4e-8c35-428c-9d6d-f2365b953d26', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Project', 'module', 90, 0),
('13f1bef1-0621-44ff-b93f-36ae88d1d041', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AOK_KnowledgeBase', 'module', 90, 0),
('140e5a96-aa03-41cb-9f5c-20e766e3eb6a', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Contacts', 'module', 89, 0),
('1574e7a6-758c-4c46-b783-615dfef3f432', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AOS_Invoices', 'module', 89, 0),
('1586ba53-4656-44f7-8eef-6446779db09f', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AOK_KnowledgeBase', 'module', 90, 0),
('15a0e217-e814-4f44-a109-8ed13ce07207', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Spots', 'module', 90, 0),
('1692ff2c-0b8f-4370-aa66-e260081b67ac', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'EAPM', 'module', 90, 0),
('189c93eb-2101-4a5b-ad9b-4f8d986ac4a0', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AM_ProjectTemplates', 'module', 90, 0),
('18f6c160-1b59-4083-9f6e-6718179c5ce3', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'TemplateSectionLine', 'module', 90, 0),
('196f4c60-105b-4039-ae08-ab152e5bc2a3', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Users', 'module', 90, 0),
('19a83b39-36da-41cd-b47e-305ce3272e55', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'jjwg_Markers', 'module', 90, 0),
('19bf46c2-1e74-4f8f-afe4-05c8193f609c', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AOD_Index', 'module', 90, 0),
('19c718f4-7ad1-42ee-9b35-cd4a6bc6ccd7', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AOK_Knowledge_Base_Categories', 'module', 90, 0),
('19d68578-59ec-4ff6-a0be-167420ff8266', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AOR_Reports', 'module', 90, 0),
('1a61ed65-656e-40e3-929d-09dac65b6c17', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AOR_Reports', 'module', 90, 0),
('1b0b0bbe-b4f3-438f-8480-bbfb3e2417bd', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Calls_Reschedule', 'module', 90, 0),
('1b29f096-0dc8-4a9a-921c-953360d3aba1', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AOS_Invoices', 'module', 90, 0),
('1b2c5b79-731d-4f12-9205-59027ea150db', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Meetings', 'module', 90, 0),
('1b9b372e-f824-406f-b577-c07bdc7a1c53', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'TemplateSectionLine', 'module', 90, 0),
('1bbf5f79-6faf-4b4d-ae6a-d9e09a84e497', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AM_TaskTemplates', 'module', 90, 0),
('1bf5497a-047a-4e45-881e-04cdad268831', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'FP_Event_Locations', 'module', 90, 0),
('1d1af69d-6849-4da8-bdd2-8766dce53b14', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AOS_Quotes', 'module', 90, 0),
('1f155801-3910-4a40-b98d-c2152309901a', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Tasks', 'module', 90, 0),
('1f54f354-7a3d-4c42-a028-7ca792942a8a', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Calls_Reschedule', 'module', 90, 0),
('1f7e5093-8d8f-41b5-90ed-d8d51068036f', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AOD_IndexEvent', 'module', 90, 0),
('1fa0a567-c025-4164-b737-f0412d295973', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Emails', 'module', 90, 0),
('2037f34d-d957-45a0-92d7-f85951bf2574', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AOS_Quotes', 'module', 90, 0),
('20acbba9-6d6c-4946-aaca-f813c4f81bb0', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'SurveyQuestions', 'module', 90, 0),
('21682aaf-f3a7-454d-9960-1fa0cf54089b', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AM_ProjectTemplates', 'module', 89, 0),
('21decbc3-5dc7-43a4-86f5-c194a4e68a0f', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Surveys', 'module', 90, 0),
('22c51808-4772-40cc-ac43-7ad5accb2d28', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'ExternalOAuthConnection', 'module', 89, 0),
('22e5e753-936a-4dc2-9c68-1e2681f9d4b9', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'jjwg_Address_Cache', 'module', 89, 0),
('23293635-267d-4e68-971f-d4cbfb7039c2', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AOS_PDF_Templates', 'module', 90, 0),
('2420ef71-4542-431f-ac88-0d99121f02e6', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AOP_Case_Updates', 'module', 90, 0),
('2421752f-2c63-450f-b4a3-1e42b544d6b3', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'ExternalOAuthProvider', 'module', 90, 0),
('244e0181-f89f-48be-b7f5-83f6d4276d8e', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AOS_Products', 'module', 90, 0),
('24f4ba03-7ad6-431c-a231-08b33dbf2fc6', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AOS_Product_Categories', 'module', 90, 0),
('24fe3085-1782-4ee8-87b6-ea1e669949c2', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'ExternalOAuthConnection', 'module', 90, 0),
('26081185-77ad-4102-b614-7276d219667c', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'jjwg_Address_Cache', 'module', 90, 0),
('2623678b-e287-4f13-9fab-1080601ee241', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Leads', 'module', 90, 0),
('273e91fe-10c7-4036-930d-15b363c3d94d', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'SecurityGroups', 'module', 89, 0),
('279cbe21-633c-4f52-bb88-183a059b084e', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AOP_Case_Events', 'module', 90, 0),
('285cfe2b-a587-4390-b5cb-b0eaa9be78db', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Bugs', 'module', 90, 0),
('28c25204-8ad5-4433-b551-413222c8b932', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AM_ProjectTemplates', 'module', 90, 0),
('28fc23e5-577e-4207-be5d-222d07ee1f75', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Accounts', 'module', 90, 0),
('2903d933-96a2-4283-8827-901e7dcb7f24', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Accounts', 'module', 90, 0),
('29524c26-5a0e-4a93-90e8-f51e46fe457e', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AOR_Scheduled_Reports', 'module', 90, 0),
('29f49b45-b7a0-4138-a685-4064c13dbb95', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AOS_Invoices', 'module', 90, 0),
('2a5e085c-38c1-4ce3-ac10-d69205f1cf76', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'InboundEmail', 'module', 90, 0),
('2a9d3e08-ef73-4639-8611-5c1960fc5294', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Spots', 'module', 89, 0),
('2ae35bde-7cd2-44ec-8af6-b7ea9b11d6a8', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'EmailMarketing', 'module', 90, 0),
('2b224d4f-fc4f-440e-90e3-61098b3be8f1', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Alerts', 'module', 89, 0),
('2bdf4961-4638-4641-9619-711ecaa75b3e', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Bugs', 'module', 90, 0),
('2d15d882-479a-4712-962b-b1fb10967145', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AOD_IndexEvent', 'module', 90, 0),
('2dd7ae6e-f614-458a-ae72-3b818c6d513a', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'SurveyQuestionResponses', 'module', 90, 0),
('2f0efe6a-4184-4264-8821-0d2ca86b50c1', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Accounts', 'module', 90, 0),
('2f1cbff1-a811-4683-8e79-0dfe81e9225f', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Calls', 'module', 90, 0),
('2f405596-5a7d-41af-bae9-4b7df1106547', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Calls', 'module', 89, 0),
('2f4b66e2-6857-4f31-8a35-8d3a59aca1f5', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AOS_PDF_Templates', 'module', 90, 0),
('2fd36ac4-5bc8-4298-8fef-fb0adbd117b5', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Leads', 'module', 90, 0),
('303dc386-437f-48a1-a59d-6555e2c10ab6', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AM_TaskTemplates', 'module', 90, 0),
('31af06d5-2dc1-4c49-935e-5bc3d8f3671b', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'ProspectLists', 'module', 90, 0),
('32092763-a37f-4e76-b7c6-3f8af7ccb652', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Emails', 'module', 89, 0),
('322941b5-3512-4cab-b9bc-7ac4dd36845f', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Spots', 'module', 90, 0),
('3290968c-1d56-4cb6-b3e6-1c9b24402907', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'EmailMarketing', 'module', 90, 0),
('32aa840b-6655-4259-9f69-bbd55224bffc', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Campaigns', 'module', 90, 0),
('32bfd843-f43d-41c7-ad3e-58fd966f3165', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'SurveyResponses', 'module', 90, 0),
('32fc0250-1db7-4e12-9c13-a6634f237271', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Cases', 'module', 90, 0),
('33020a49-7a87-4c6b-9f60-d322ce2922f4', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Calls', 'module', 90, 0),
('330837da-f053-4fc2-ae6e-04d3376d0ff8', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'TemplateSectionLine', 'module', 90, 0),
('33109890-53be-467b-b036-56fa0a2e078c', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AOR_Reports', 'module', 90, 0),
('341bae61-1bbd-4f46-91fd-df0bfd71903a', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'ProspectLists', 'module', 90, 0),
('34cb7baa-5e57-405e-a406-0b2989cae3e3', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'jjwg_Areas', 'module', 90, 0),
('34f7c8e2-683d-48ee-bf1f-bd3eae0ece44', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AOS_Invoices', 'module', 90, 0),
('351e3b1a-a30f-445a-bf53-d3a1e7ea97f5', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AOK_Knowledge_Base_Categories', 'module', 90, 0),
('35cab665-0f6d-49e2-beef-afc26a62c9a2', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'ProjectTask', 'module', 90, 0),
('361dd2a5-78c8-4be6-953d-342698cba770', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AOW_Processed', 'module', 90, 0),
('36492b92-1dcb-46de-8b2b-ca30b065ba2e', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Surveys', 'module', 90, 0),
('3655290e-d362-424d-93c3-80a02a60ebd6', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Accounts', 'module', 90, 0),
('36693d57-82e4-4b37-8fe0-578d36ce0175', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Meetings', 'module', 90, 0),
('37cf6e7c-96d7-42f3-b615-23f524989c36', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Notes', 'module', 90, 0),
('37d507ef-9488-432b-a1fc-12958c2a3173', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'jjwg_Markers', 'module', 90, 0),
('3818e82e-c8cd-4a3b-8210-e2b37d8c975c', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'EAPM', 'module', 90, 0),
('387dfa94-cded-4839-bdea-0706c5664764', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'jjwg_Maps', 'module', 90, 0),
('38fde13d-f27e-49f1-96c2-c6cb1e310b35', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AOK_KnowledgeBase', 'module', 90, 0),
('39ffc595-adc7-4827-9cfe-9e0cd7af72be', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AOS_Quotes', 'module', 90, 0),
('3a20a3fe-298c-450c-9c1c-6df675ce7b2c', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Tasks', 'module', 90, 0),
('3af75c67-bd14-44e9-bc1f-bd8971b7cba2', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'ProjectTask', 'module', 90, 0),
('3c19dcf5-bcf7-4197-b11d-b7b357e4c022', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Opportunities', 'module', 89, 0),
('3c632e0b-41e9-4374-9bd7-aac48e218bab', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AOS_Product_Categories', 'module', 89, 0),
('3c8296b6-375b-4ca8-8492-b0a7c73c26ae', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AOK_Knowledge_Base_Categories', 'module', 90, 0),
('3da2285c-1871-4210-828a-07bf4201a153', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'SecurityGroups', 'module', 90, 0),
('3de2bb61-e423-439f-8922-74137f1c9cde', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'ProjectTask', 'module', 90, 0),
('3e087c3f-95f9-47c0-b7ed-f56c8577214c', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'jjwg_Maps', 'module', 90, 0),
('3e5433d6-c05c-47be-b163-7f68569755f9', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Notes', 'module', 90, 0),
('3f80f3f6-0776-40d7-9528-af891182bca8', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'ProspectLists', 'module', 90, 0),
('4059e901-2652-4dc2-8c35-b5db462c3825', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'OutboundEmailAccounts', 'module', 90, 0),
('40d69632-6494-477b-9f69-5fc6cf00aab3', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Accounts', 'module', 90, 0),
('453ab71a-c1b8-44bb-9d24-faadb3416c5e', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'SurveyResponses', 'module', 90, 0),
('45d3d116-7f5d-4a38-9184-5298e5501bb7', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'SurveyQuestionOptions', 'module', 90, 0),
('465d9605-c288-4738-aea4-c3f655a2c7ca', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'jjwg_Address_Cache', 'module', 90, 0),
('47ed1cb1-8da2-4d8f-a6ae-f076581010ee', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AM_ProjectTemplates', 'module', 90, 0),
('4993d352-83b0-4e08-a973-435e4f1c41b0', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Calls', 'module', 90, 0),
('49a71433-4cf7-4a1f-8b4d-659121c95105', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AOK_Knowledge_Base_Categories', 'module', 90, 0),
('4ac1ea77-6814-430a-b992-7623eee7d6d5', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'jjwg_Maps', 'module', 89, 0),
('4adb2951-b1c7-4896-a94e-b2754f660452', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'jjwg_Maps', 'module', 90, 0),
('4ba6c866-dacc-48a2-9ab7-bcb675402cdc', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'InboundEmail', 'module', 90, 0),
('4dd8aa0e-7628-491b-8ae1-3bd72dccdb1a', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'FP_events', 'module', 90, 0),
('4e501454-eb93-451f-a5c1-d0d1f3715375', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Leads', 'module', 90, 0),
('4e8bcd71-fc38-45f0-a185-39c5d3c01f84', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AOP_Case_Events', 'module', 90, 0),
('4fcdc57e-279a-4746-8aad-bab832914890', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AOS_Product_Categories', 'module', 90, 0),
('500e7199-3248-4caa-bb12-d4a79045465f', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'InboundEmail', 'module', 89, 0),
('508c46e5-7408-429d-9b38-42240002487f', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Documents', 'module', 90, 0),
('5111452e-883d-4980-b72b-0440c013b83d', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'EmailMarketing', 'module', 90, 0),
('5142ca23-d627-4ecc-b165-0df441a68147', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'EmailMarketing', 'module', 90, 0),
('519d0f8b-06b1-4713-a47f-10aa54cb8df6', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Users', 'module', 90, 0),
('51cbfd61-fd16-4a29-bed4-146426ddfe3d', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Project', 'module', 90, 0),
('52036743-22dc-44f5-b7f6-712d924a3457', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AM_ProjectTemplates', 'module', 90, 0),
('54019672-d276-43be-997d-ce0347441674', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AOR_Scheduled_Reports', 'module', 90, 0),
('54dbeb87-41c7-4b73-bfab-e6961baba3d9', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Accounts', 'module', 90, 0),
('55a67254-9a3a-4e9c-809f-1aade258327d', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'EmailTemplates', 'module', 90, 0),
('565555e8-4722-4fcd-8d55-c64cb5ab289c', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'EmailTemplates', 'module', 90, 0),
('568a1935-91aa-4970-b016-161bc64709e9', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'EAPM', 'module', 90, 0),
('57951639-c461-4c96-96d1-fe469076e857', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Meetings', 'module', 89, 0),
('581f67ac-93c2-48d4-9ccb-41d1b3920f62', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'ProjectTask', 'module', 89, 0),
('584238e5-921b-4d8a-a406-ec853c557649', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AOW_WorkFlow', 'module', 90, 0),
('58abc1e4-967c-4233-b7fe-f11fae541027', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Project', 'module', 90, 0),
('5990dcee-77fe-41e0-8a36-8d94a370c73e', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'EAPM', 'module', 90, 0),
('5a3d2566-dc5e-4d77-ae9e-5a9374542992', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Users', 'module', 90, 0),
('5a3e7184-c2a4-4741-bff1-39ab2a4dd607', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AOS_Products', 'module', 90, 0),
('5bc0bd2d-83bc-4d41-a42c-d8f3c098c368', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AOW_WorkFlow', 'module', 90, 0),
('5be379d5-7b5d-4407-9f07-af729b34a4c5', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'TemplateSectionLine', 'module', 90, 0),
('5d1d5c75-4a36-4248-beee-76534d0f04b0', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AM_ProjectTemplates', 'module', 90, 0),
('5d83173f-e236-4b1b-838f-c8f5d992ac88', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'SurveyQuestionOptions', 'module', 90, 0),
('5f3e77bd-2674-4861-9a56-3bf88622dec0', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AOS_Product_Categories', 'module', 90, 0),
('5f82a366-f596-4414-abeb-00d9ba79d4d5', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'jjwg_Maps', 'module', 90, 0),
('601318a9-f22a-4808-a1e4-456080ad907b', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'FP_events', 'module', 90, 0),
('60467236-e290-40c8-a7ea-f1f544f8afd9', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'FP_events', 'module', 90, 0),
('6171bda3-204e-42d7-bb05-75d4de7ac32d', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'FP_events', 'module', 89, 0),
('61bbd0f8-eaa3-4868-a35d-584c758085d3', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'FP_events', 'module', 90, 0),
('657df3a8-8de9-4d73-b26f-e17f3d9b17d1', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Emails', 'module', 90, 0),
('65b1295f-42a9-4c10-81ae-c260648b9774', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AOW_Processed', 'module', 90, 0),
('65cdca54-cb23-49a9-a153-9013613387f8', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Surveys', 'module', 90, 0),
('665e841b-dcd9-4403-9bb2-a84c6a80bc29', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Tasks', 'module', 90, 0),
('6667ed97-e41d-4ca8-a7ba-63b2920b4c70', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Contacts', 'module', 90, 0),
('678cd2f7-0b6d-4c15-8f50-8ebe5bc7574f', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'ExternalOAuthConnection', 'module', 90, 0),
('67946e4c-eace-422a-820e-ca6775fe1899', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AM_TaskTemplates', 'module', 90, 0),
('67a3ae2c-db8c-4666-a29e-d782941e723c', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AOS_Product_Categories', 'module', 90, 0),
('680ee55f-d5f6-4da3-bf68-91f942f10d74', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'EmailTemplates', 'module', 90, 0),
('6880b967-658c-48e3-a933-9c1d0b1c3be7', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'OutboundEmailAccounts', 'module', 90, 0),
('6882a644-383a-4bf6-ae07-f675677c8aea', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'SurveyQuestionResponses', 'module', 90, 0),
('68b6ea0a-9821-4579-baf0-a86a87dabe22', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Users', 'module', 90, 0),
('68dbd497-edad-4960-b2b4-e8a8a8ad75ab', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AOK_Knowledge_Base_Categories', 'module', 90, 0),
('68e3a540-dab5-41eb-9851-771bcfef569e', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'EAPM', 'module', 90, 0),
('692a65c0-63c6-4bb4-b78e-6a74ab95bb7b', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'EAPM', 'module', 90, 0),
('694a9067-0e03-4fe6-b7f9-d239b426fb00', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AOS_Products', 'module', 89, 0),
('69853835-37a7-4a37-82b1-af4c1d1a4864', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'EmailTemplates', 'module', 89, 0),
('69cdfa86-4506-4d58-8985-78827e49cb6a', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Calls_Reschedule', 'module', 90, 0),
('69fb1474-9941-4173-afe5-3f6dd4bba079', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AOR_Scheduled_Reports', 'module', 90, 0),
('6a1f3895-248c-4452-a64f-8c9b3c01000a', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'jjwg_Maps', 'module', 90, 0),
('6a562ebc-c08d-4801-aadf-c2bde240e093', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AOR_Scheduled_Reports', 'module', 90, 0),
('6ad625cc-7d39-4290-a3de-3bf73d10805c', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Campaigns', 'module', 90, 0),
('6b2ff2e6-db20-499e-80d6-949e1116b81e', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'FP_Event_Locations', 'module', 90, 0),
('6d46848d-2869-40a5-9caf-109cbb4eeefe', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AOR_Scheduled_Reports', 'module', 90, 0),
('6d6c3c37-c4d9-4ee8-9005-ad10d5921e12', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AOP_Case_Events', 'module', 90, 0),
('6de3269a-8309-48ad-8240-709c3252443c', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AOP_Case_Updates', 'module', 90, 0),
('6e078d62-d45d-4cc3-876c-60cbaa8726b8', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Bugs', 'module', 90, 0),
('6e70babd-c426-4ebd-9acc-edb105a30d11', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AOD_IndexEvent', 'module', 90, 0),
('6ea6d093-1487-44aa-a236-d76627b4a490', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Cases', 'module', 90, 0),
('6ed8e6d5-17cf-4adf-aa35-db4f7bad3937', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'CalendarAccount', 'module', 89, 0),
('7058b706-c792-4b04-a000-6496aaf5cb45', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'jjwg_Address_Cache', 'module', 90, 0),
('709adacb-1717-43d7-878a-b1921ebbda38', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AOW_Processed', 'module', 90, 0),
('71aaa3d6-63d4-4cd5-b2dc-b9a55d72aafc', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'OutboundEmailAccounts', 'module', 90, 0),
('71af0b05-3fff-4f7f-a898-4cf163b31d5a', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Leads', 'module', 89, 0),
('73385890-1436-4e0b-abc8-73c33e4671df', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AOD_Index', 'module', 90, 0),
('7373dd63-ebed-438b-a406-46cbc1eafd70', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AOD_IndexEvent', 'module', 90, 0),
('7383c52c-9e7f-4a37-8034-edc266dc4a4c', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AOS_Contracts', 'module', 90, 0),
('74d23b2f-761e-4310-8259-452dc727c69f', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'EmailTemplates', 'module', 90, 0),
('74f8769a-51d4-4cdb-b4b5-7d0d08952bc0', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'jjwg_Areas', 'module', 90, 0),
('75de143f-8fb0-422f-97c0-45864a248091', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Meetings', 'module', 90, 0),
('76b876e8-622e-4a78-8f3d-32cf3bc77a46', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Bugs', 'module', 90, 0),
('771aea53-cbed-4060-ba1f-4d1431ac0d73', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Tasks', 'module', 89, 0),
('77eef124-3100-4194-bfb9-8ae6e67195ae', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'OutboundEmailAccounts', 'module', 90, 0),
('7851a992-d400-4329-a55b-dcbdd672783a', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Meetings', 'module', 90, 0),
('78eaca77-c215-47a9-adff-df9e71be8547', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AOS_Products', 'module', 90, 0),
('79035cb9-4465-49b5-9077-40261102fc57', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'InboundEmail', 'module', 90, 0),
('7980fb8a-d1fb-498f-8819-24d8a9a8306e', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'EmailTemplates', 'module', 90, 0),
('79bd62cd-5586-4792-aa32-fade38b3e348', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AOR_Scheduled_Reports', 'module', 89, 0),
('7a6cbc3c-78f2-4c93-9a25-a33289cdf690', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'ExternalOAuthConnection', 'module', 90, 0),
('7baf3a26-6ed4-418c-8f6d-2908a626ed73', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AOS_PDF_Templates', 'module', 90, 0),
('7c1b8355-ae90-4f16-be13-6e032fcd9072', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'TemplateSectionLine', 'module', 90, 0),
('7c7ff6fe-8dd4-4c51-a340-eebac8f480b2', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Alerts', 'module', 90, 0),
('7cd47d6b-c7be-44af-be9f-c5da5c557ff8', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AOS_Product_Categories', 'module', 90, 0),
('7d704dd4-a0c3-401b-b8a4-9ce63a43b3d4', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'SurveyResponses', 'module', 90, 0),
('7f7f0ed5-795d-42c8-98de-fbc5b0271d26', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'jjwg_Areas', 'module', 90, 0),
('7fa551a7-9465-4b55-af68-c10942a8316a', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Users', 'module', 89, 0),
('7fbcfda0-9246-4f6e-a024-4a9693c183b4', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Calls_Reschedule', 'module', 90, 0),
('7fceda2d-377a-48fd-9f1e-8b165a3dd3b2', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'SurveyQuestionOptions', 'module', 90, 0),
('80cb81e9-9bd6-499f-8f8d-3fbd73540573', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'jjwg_Areas', 'module', 90, 0),
('8199f2a8-140c-435e-a5c1-1f845c944c01', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'FP_Event_Locations', 'module', 89, 0),
('81b9ebb0-af44-4561-a130-85ab9c70d8be', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Meetings', 'module', 90, 0),
('81ff9858-f030-4fea-a2cc-5589ed90e0a8', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AOS_Quotes', 'module', 90, 0),
('8300d2e0-ff6b-4664-9897-989be64bf94e', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Surveys', 'module', 90, 0),
('8441e1e9-724b-44af-a38c-62612b347a73', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'ProjectTask', 'module', 90, 0),
('844de364-0465-4afb-a418-28b336eabb8e', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'SecurityGroups', 'module', 90, 0),
('84734db4-20e5-4dd9-93c1-1db4950da7c2', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'SecurityGroups', 'module', 90, 0),
('857b31aa-9d45-4acd-8b76-539357b1e287', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'jjwg_Areas', 'module', 90, 0),
('8587b1ce-acaa-43d9-ae30-41502ee1f4b9', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'OutboundEmailAccounts', 'module', 90, 0),
('85ab7681-ef52-4c72-82fa-67bb2f71ed65', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Alerts', 'module', 90, 0),
('85cbf43b-cbab-4f7b-82fc-91956c512b4a', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'jjwg_Markers', 'module', 90, 0),
('86289f57-ca69-4a7a-88b3-46ed07da28a9', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AOS_PDF_Templates', 'module', 90, 0),
('8731762f-8993-4b25-8705-e834e1348401', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AOW_WorkFlow', 'module', 90, 0),
('874251b7-f82d-4da8-a67d-1550524a777a', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AOD_IndexEvent', 'module', 89, 0),
('876068ef-b8a6-46a9-a642-4a89daf27c14', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AOP_Case_Updates', 'module', 89, 0),
('87f80910-c073-48e9-bf9f-d76c4ced8631', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Cases', 'module', 90, 0),
('88065190-b090-48c6-8260-300a081a428b', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'CalendarAccount', 'module', 90, 0),
('88696d55-0f9b-4aae-be9b-e9ee2bee3c71', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AOK_KnowledgeBase', 'module', 90, 0),
('88ad19b9-5924-42ee-bbc1-c4aca7e370cd', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Cases', 'module', 90, 0),
('8a0bebd6-e4ef-4b8c-ab28-ea5774369c65', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AOW_Processed', 'module', 90, 0),
('8a4a3461-487c-4474-acb6-b201244c3134', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Calls', 'module', 90, 0),
('8ae5f138-4885-4c89-8dcf-b657262f8451', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AOP_Case_Updates', 'module', 90, 0),
('8b32878b-397a-4a36-8e4a-9480b9b24d6e', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Opportunities', 'module', 90, 0),
('8ba0552b-8ebc-4b84-88e2-c699f7c2085a', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Leads', 'module', 90, 0),
('8c1073cc-9837-438e-a7a4-93a8ad3a2501', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AOS_Quotes', 'module', 90, 0),
('8d95b400-ef13-4493-b0bd-7e5c3e2321b8', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Notes', 'module', 90, 0),
('8d98ca75-258b-4ef2-a2e3-df33c580d0a3', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Calls_Reschedule', 'module', 90, 0),
('8dc5ad7a-ba34-4925-b9a8-5191c8463660', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Surveys', 'module', 90, 0),
('8deaede2-29a0-4b06-8325-17cd6e0fe730', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'ProspectLists', 'module', 89, 0),
('8e38557e-0c0d-493d-a53f-d4d26caf5378', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Prospects', 'module', 90, 0),
('8ee442a6-d95f-4e85-8b91-ad76c88e921e', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'EAPM', 'module', 90, 0),
('8f378f30-8a36-4edb-8d5b-a9aa831bb508', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AM_TaskTemplates', 'module', 89, 0),
('8fb24e3a-f23e-497d-b749-33d4c3bba06c', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AOR_Scheduled_Reports', 'module', 90, 0),
('90e60c17-b652-4b7c-9947-093e86d2cec3', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Spots', 'module', 90, 0),
('915f159a-cd32-4ddf-9657-b85de405e562', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'SecurityGroups', 'module', 90, 0),
('923fc3c2-ae13-4fdb-ac38-b2fd4779b74e', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'jjwg_Areas', 'module', 90, 0),
('9249f44b-d70a-4ac5-8740-4e67636f2bed', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'jjwg_Areas', 'module', 89, 0),
('92bfe73f-5d40-4f18-a3b4-217dab433c4b', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'ExternalOAuthConnection', 'module', 90, 0),
('92d96913-6296-4e22-a6cd-60a2897a5631', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Tasks', 'module', 90, 0),
('936fded4-32f1-4a0a-8428-ccc64030144b', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Emails', 'module', 90, 0),
('93983470-1988-48d2-b39c-c18d2a6cbcf2', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'FP_events', 'module', 90, 0),
('93df2376-e259-4c36-b2a6-7f326b2effda', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'OutboundEmailAccounts', 'module', 90, 0),
('94481c7a-bb13-4b04-8722-01b6260fb9a8', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AOW_WorkFlow', 'module', 89, 0),
('9453f161-018b-4b24-b72c-067bec596a5b', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'TemplateSectionLine', 'module', 89, 0),
('946552ad-1d0f-48d2-9108-e5e57091e960', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'FP_Event_Locations', 'module', 90, 0),
('949786cc-83ed-4501-a9b9-00af984b5cfa', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AOW_WorkFlow', 'module', 90, 0),
('9505950f-1447-4472-8dcd-011f213d52c1', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Campaigns', 'module', 89, 0),
('9507cb59-56db-4d1e-a6c0-3ecfe9b7d59e', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Project', 'module', 89, 0),
('959973a6-9f04-4ad1-8cfe-86e1b09ffd5c', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'FP_events', 'module', 90, 0),
('95a9c30e-c66a-49b9-b765-85c91c70a2e7', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Leads', 'module', 90, 0),
('9651ea96-6470-432d-b08e-dda9466d951f', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Surveys', 'module', 90, 0),
('965b005d-bd83-46dd-8b19-9ee431a83474', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AOP_Case_Updates', 'module', 90, 0),
('966831c6-6fba-46a9-9153-47b7ec521e7c', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'FP_Event_Locations', 'module', 90, 0),
('96c7afef-d8a2-4cfd-803d-18bad0e9b41b', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Bugs', 'module', 89, 0),
('96cd45d8-dc39-48a5-a88d-99d4079c246d', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'SurveyResponses', 'module', 90, 0),
('974c32ea-8cac-4cfb-bef8-e398a026928f', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'ExternalOAuthProvider', 'module', 90, 0),
('97c4e256-6adb-440c-8064-85c7d07854c4', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AOK_KnowledgeBase', 'module', 90, 0),
('98004d22-5cfb-4080-85d0-2edb2ca2f4fc', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'jjwg_Markers', 'module', 90, 0),
('983750d7-8b22-470e-ad3c-2f82fab02ae9', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'SurveyResponses', 'module', 90, 0),
('9888f2aa-dc65-4dca-8446-6731775a9fda', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AOK_KnowledgeBase', 'module', 90, 0),
('9936c248-dc1a-4f04-9816-15b7cac088f3', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'jjwg_Address_Cache', 'module', 90, 0),
('9a1d0ed7-1bd9-46d8-9b77-9d3ecdc5845a', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'SurveyQuestionResponses', 'module', 90, 0),
('9ab87e2a-ece4-4867-8d04-aa3d5ab2c03c', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AOD_Index', 'module', 89, 0),
('9abfa68b-092e-4aba-820c-0d5000dd5c48', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'EmailMarketing', 'module', 89, 0),
('9b0b10e7-a0d8-4496-984a-9c8bbe41edc5', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AOD_Index', 'module', 90, 0),
('9bb59c1a-5143-4fed-b66c-c174411657e8', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Meetings', 'module', 90, 0),
('9d7eab6c-2f19-46fc-926d-b08148495383', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Tasks', 'module', 90, 0),
('9e4a64b2-e514-4d59-ad2a-08dc8ff826a8', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Spots', 'module', 90, 0),
('9eaa63e1-3b5b-4a2a-9db1-9554e9aaa13c', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Spots', 'module', 90, 0),
('9f138468-488e-4489-b104-758e3bed8c69', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Surveys', 'module', 90, 0),
('9ffd8ba4-d2be-489f-ac64-a8cb9aedb755', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Documents', 'module', 90, 0),
('a0e3bc7c-a023-442f-8571-98bb95d53644', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AOS_Contracts', 'module', 90, 0),
('a0ff4023-9f7d-4331-b4e3-19b1a7c92553', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'SecurityGroups', 'module', 90, 0),
('a12d4319-2c07-440a-9186-7d3d10bd0a36', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AOK_Knowledge_Base_Categories', 'module', 89, 0),
('a13af5f2-63dc-4361-b1e4-7abbd0dce8e0', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AOS_Quotes', 'module', 90, 0),
('a15a3f48-40da-49e0-a887-c2366bc83120', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'SurveyQuestions', 'module', 89, 0),
('a15bfcd8-6600-4a0f-83b4-7ed110480108', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'ExternalOAuthProvider', 'module', 90, 0),
('a2bbedf2-ded4-4b30-a871-f07bac98f765', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AOS_Contracts', 'module', 90, 0),
('a457d44b-15ed-4f93-b06b-ce74af5d82b0', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Project', 'module', 90, 0),
('a537aaf9-ac4a-4ca9-9cac-22ae107078f2', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'jjwg_Markers', 'module', 90, 0),
('a6333c72-21c7-45cf-a918-8838950d6427', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AOS_Quotes', 'module', 90, 0),
('a69ca8ed-bb61-4643-86bb-c8055e725c64', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Calls_Reschedule', 'module', 89, 0),
('a785f040-315c-48af-bfd9-9b46f04fb149', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'InboundEmail', 'module', 90, 0),
('a83d136d-4de3-4dcc-b793-5ab5812fdc16', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Bugs', 'module', 90, 0),
('a9061977-dcce-41ad-816a-fdac20b0c5b1', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'SurveyQuestionResponses', 'module', 90, 0),
('a91d5dcf-03a3-46cf-aad4-42c3467c6d13', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AOS_Invoices', 'module', 90, 0),
('a984fc2c-e20c-4f3a-9654-a4edaabe5603', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'jjwg_Address_Cache', 'module', 90, 0),
('aa96e54d-e3e4-4617-ac19-1fa7bd4f1712', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AM_ProjectTemplates', 'module', 90, 0),
('ab5bb0ef-7e45-4a5c-b1d0-531ae4fd7467', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AOS_Product_Categories', 'module', 90, 0),
('abada9c6-255a-476f-9b3c-5b3b1af2b353', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Bugs', 'module', 90, 0),
('ac06f146-3431-4ad1-bc58-fea6063ff566', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Contacts', 'module', 90, 0),
('ac2619f4-e604-47a2-95b3-59a6e27ab62c', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'EmailMarketing', 'module', 90, 0),
('ac959093-0d49-4c20-ba12-a42dfae8381b', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AOP_Case_Updates', 'module', 90, 0),
('ad534997-a662-41a2-9211-5aeb1bca9371', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'SurveyResponses', 'module', 90, 0),
('ae01756e-d966-47ca-ab6a-5db08a27906c', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'FP_Event_Locations', 'module', 90, 0),
('ae0c1547-6f2e-4b32-aa94-fbfb869ae363', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'SurveyQuestions', 'module', 90, 0),
('aedeb3de-3246-4590-9195-9ecf8f08bf10', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AOS_Contracts', 'module', 90, 0),
('afa9164a-f86b-4e04-b950-e4f3160f9bd2', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Spots', 'module', 90, 0),
('b09881d2-a0a4-42a5-8786-a78b3a43cd99', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Alerts', 'module', 90, 0),
('b17c96c2-4a17-49a2-8529-b6d1f518e64f', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'CalendarAccount', 'module', 90, 0),
('b27046c5-af02-4756-b142-347285e4f956', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Alerts', 'module', 90, 0),
('b27d3c65-0291-476a-be3a-09db70a65c3e', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Prospects', 'module', 90, 0),
('b32502b9-9ef6-496d-94bc-c3751fdfc170', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'EmailMarketing', 'module', 90, 0),
('b3d31f70-b26e-4a43-8efe-dc22788d0eb3', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'SurveyQuestionResponses', 'module', 89, 0),
('b4045c8a-6b96-4db6-bda9-69227e4c82c7', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Project', 'module', 90, 0),
('b42546f7-9842-4492-940c-011cdf79f345', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AOS_Contracts', 'module', 89, 0),
('b481e95b-dc6a-428c-b4b9-882baf58b1dd', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'jjwg_Markers', 'module', 89, 0),
('b4b2b254-338f-4cb8-ab7f-dc25c13e366a', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AOP_Case_Updates', 'module', 90, 0),
('b4ff2dfd-cadd-4bb7-b479-480709c2e790', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Prospects', 'module', 89, 0),
('b5802c0d-639e-4c0a-9f87-720b28e7c5e8', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Cases', 'module', 90, 0),
('b5cfcbe9-78b4-492e-bbcf-f31e42c817a2', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AOK_Knowledge_Base_Categories', 'module', 90, 0),
('b602b661-a745-4e0d-8602-78d3812440e1', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Cases', 'module', 90, 0),
('b706ab05-3bd8-4e04-b764-961e446187cf', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Notes', 'module', 90, 0),
('b8476c62-d529-4bd9-b7b2-068775340440', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AM_TaskTemplates', 'module', 90, 0),
('b933c98d-cd14-473c-ba0a-5386efdb9c10', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'ProjectTask', 'module', 90, 0),
('bb1a7db6-89eb-4425-97bf-53e7890a83c6', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AOS_Invoices', 'module', 90, 0),
('bb1fd110-acbd-4db6-a809-98934dc0e739', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Campaigns', 'module', 90, 0),
('bb5c5187-ba32-433b-9fe6-e19ecc103bdd', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'InboundEmail', 'module', 90, 0),
('bb9a652c-04de-4a41-9b74-12a97b055199', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AOD_IndexEvent', 'module', 90, 0),
('bbda6306-1004-4b66-bc20-7ed3441f8c5b', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Prospects', 'module', 90, 0),
('bc24d84d-ac11-498a-908d-251a961e34da', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AOW_Processed', 'module', 89, 0),
('bd9ff8a4-c737-4669-b232-e01134ceed71', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AOS_Invoices', 'module', 90, 0),
('be50cd80-68fe-4a8b-ab22-f359272c82ce', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Documents', 'module', 90, 0),
('bea98238-3d66-44dc-8e0e-cb7bbc7a0bec', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Opportunities', 'module', 90, 0),
('bffed933-3000-440e-b4f6-5ac23ad54748', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'ProjectTask', 'module', 90, 0),
('c07c29ab-da0e-4f4e-b050-9bd01c76b0b7', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'AOP_Case_Updates', 'module', 90, 0);
INSERT INTO `acl_actions` VALUES
('c08c58b6-c588-4b61-b86e-0c4d33da4662', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'jjwg_Markers', 'module', 90, 0),
('c14f5d11-1c4e-403c-9311-faa3455bba0c', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Bugs', 'module', 90, 0),
('c15fa772-83c7-4459-b4de-6e394092f1cc', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'jjwg_Address_Cache', 'module', 90, 0),
('c1b7bf48-53c0-4b13-8bf1-a71172d6ada8', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'ExternalOAuthProvider', 'module', 89, 0),
('c2368d80-f661-4b4c-ba59-7872cbad5e97', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'ExternalOAuthProvider', 'module', 90, 0),
('c24647b3-4693-46f0-98d0-b7d1aa4e5d62', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Campaigns', 'module', 90, 0),
('c2bd2ba6-ccc0-4a34-95c7-523bd11da2e7', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'SecurityGroups', 'module', 90, 0),
('c356954b-914e-47bd-92e7-3f86e8da5336', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AOS_Invoices', 'module', 90, 0),
('c478f1fa-dcfa-48f8-bae6-99308b860393', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AOK_Knowledge_Base_Categories', 'module', 90, 0),
('c4c96579-0ef2-411c-914a-f80edb00e679', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'SurveyResponses', 'module', 89, 0),
('c4e542db-69cf-46a2-8aee-1d3a75dd7591', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Spots', 'module', 90, 0),
('c55a4c69-675a-416f-aa18-d7424762b832', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'OutboundEmailAccounts', 'module', 89, 0),
('c55f54c9-57fc-4652-b37f-a737ea8ddf84', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'FP_events', 'module', 90, 0),
('c581808e-df75-47a2-b8e4-4841de540ac3', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AOS_PDF_Templates', 'module', 90, 0),
('c58f8d59-cd45-4940-9e92-c7a1eebec120', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Prospects', 'module', 90, 0),
('c5ee8685-0fad-403e-87fc-948dd3734081', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'jjwg_Maps', 'module', 90, 0),
('c60cf5c0-196a-475f-8686-9c9959fcce65', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Accounts', 'module', 89, 0),
('c841128a-0eb1-47c0-aaa9-707b8a9406ec', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'ProspectLists', 'module', 90, 0),
('c8531365-a0dc-4481-8176-347deab5144a', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Notes', 'module', 90, 0),
('c9650a8d-6233-4209-839e-12679ebc3ddb', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AOK_KnowledgeBase', 'module', 90, 0),
('c96a0b26-91f1-439a-a0e2-378fbd1b109f', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AOW_WorkFlow', 'module', 90, 0),
('c9e0ac3b-bac3-4312-b671-443753a763da', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Contacts', 'module', 90, 0),
('c9fa129a-da7e-4f9b-a131-496156d56b56', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AOR_Reports', 'module', 90, 0),
('ca2860d1-00d7-482b-9841-1fd8e5b29020', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Leads', 'module', 90, 0),
('cc50c705-d163-484e-aa81-da2f8e4b390b', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Tasks', 'module', 90, 0),
('cd9c2458-5624-4b2e-899a-81d5f00ade77', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'jjwg_Address_Cache', 'module', 90, 0),
('ceea941b-c5b7-45e3-9b30-a5fa6a051402', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Emails', 'module', 90, 0),
('d020b120-302b-46b4-b9f5-93051d19518d', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AOS_Product_Categories', 'module', 90, 0),
('d0ba59a0-fcc6-47a9-9821-6f2e57ac9f53', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'InboundEmail', 'module', 90, 0),
('d0cc7d96-c7d1-4d00-a0ec-85719cd0ecce', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AOS_Contracts', 'module', 90, 0),
('d0f2bf51-b2b7-4343-a591-2b9353130a01', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'SurveyQuestionResponses', 'module', 90, 0),
('d0f5a809-6ee4-4500-b4ac-717f87b9ab75', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'CalendarAccount', 'module', 90, 0),
('d1121014-4c4b-42cb-9e52-b2f81ab40d70', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AOS_PDF_Templates', 'module', 90, 0),
('d181c3a5-dfb7-49bc-9ead-6f457bdfa655', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Tasks', 'module', 90, 0),
('d254a460-dd09-4172-a5fc-289a1cad659c', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'TemplateSectionLine', 'module', 90, 0),
('d2aa472e-f871-466a-b7e3-48685b98970b', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Documents', 'module', 90, 0),
('d2d24e01-8985-4223-b119-0a2f766759f5', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Prospects', 'module', 90, 0),
('d3844de5-95b0-4cdd-9228-2933487398bd', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Opportunities', 'module', 90, 0),
('d4cc9cf6-bdb3-4470-95ab-7f9a34846d59', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AOS_Contracts', 'module', 90, 0),
('d4ed0f12-1754-4627-801c-a903f98369bc', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Users', 'module', 90, 0),
('d51e8eef-f57f-4ba8-b733-95d2f2dcfcc9', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Emails', 'module', 90, 0),
('d53726ac-6158-4aa2-932f-81efb75dc583', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'CalendarAccount', 'module', 90, 0),
('d6a5ea90-418f-4a13-bc07-41c3541dc6b6', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AOR_Reports', 'module', 90, 0),
('d71a9924-9a73-43ae-b711-06362b0254b1', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AOD_Index', 'module', 90, 0),
('d7215692-6dc5-46f7-9948-9c005c9abc1f', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Calls', 'module', 90, 0),
('d92a4359-b6b0-4808-972f-b6f79bb73a07', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Contacts', 'module', 90, 0),
('d92a9ea3-4662-4017-9914-40aa60117253', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AOW_WorkFlow', 'module', 90, 0),
('d9cffcef-7126-4502-abe6-2d93ba7245f1', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'CalendarAccount', 'module', 90, 0),
('d9d77ed6-966a-43e4-9c54-b6a6a53a4313', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Prospects', 'module', 90, 0),
('da1fd95b-f97f-4cc6-a283-896dff929b81', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AOW_Processed', 'module', 90, 0),
('da24e496-bda2-4423-9a6f-9af2cf9f4c12', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Accounts', 'module', 90, 0),
('db22c442-4ccc-491d-8f3d-04a82062b7f5', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AOD_Index', 'module', 90, 0),
('db3cf292-7759-48a8-9691-1657187de28c', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Documents', 'module', 90, 0),
('db8049d0-a5ec-44d4-bee0-fc20c2aabb55', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'InboundEmail', 'module', 90, 0),
('dbadd3a1-e796-40c6-96a1-3ea2c1f49425', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'SurveyQuestionResponses', 'module', 90, 0),
('dc08af78-5538-4529-9f49-775cd92b253e', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AOS_Products', 'module', 90, 0),
('dcfb8480-541e-40c0-be98-9dcdef23bc04', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AOS_PDF_Templates', 'module', 89, 0),
('dd16771b-d606-44bf-b37d-b13bf38f679d', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'SurveyQuestionOptions', 'module', 90, 0),
('dd2cca88-9b1c-433f-961b-ccfaaf66709d', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Prospects', 'module', 90, 0),
('dd408577-e9fa-4f85-a039-d11164d87d66', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'ProspectLists', 'module', 90, 0),
('dd5f6e4f-bfff-463a-832a-45d1c9d9c17b', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'CalendarAccount', 'module', 90, 0),
('ddb22bd3-b3a0-437b-afa7-1942e2d95dba', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Notes', 'module', 90, 0),
('dddf7612-38a0-4af7-b07f-b52113459e6c', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'FP_Event_Locations', 'module', 90, 0),
('dfacea5e-12e8-4bda-a941-393b7280bc8c', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'Alerts', 'module', 90, 0),
('e058508e-4f7e-4c15-8d00-66fef0f82bee', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'EAPM', 'module', 89, 0),
('e0b581eb-4dce-4589-a478-34d5a2661556', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Campaigns', 'module', 90, 0),
('e1032f9a-74a6-417c-bbde-5a442a7af0f2', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'SurveyQuestionOptions', 'module', 90, 0),
('e156c3a7-c0e1-438c-bd1b-4ce6eb4b4c38', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'jjwg_Markers', 'module', 90, 0),
('e18ea955-7e06-45b8-80cf-2d4f62c2cd5b', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Emails', 'module', 90, 0),
('e1cc8ead-c74c-47f4-9607-304ddc562e20', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AOR_Reports', 'module', 89, 0),
('e279f8f0-8f85-4e54-a93e-37724110433a', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'jjwg_Areas', 'module', 90, 0),
('e28a3924-b9c8-4ac0-a34c-0e95a86a30e2', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AOK_KnowledgeBase', 'module', 89, 0),
('e2f6f4aa-14d8-4832-98f8-161b04350be2', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'ProjectTask', 'module', 90, 0),
('e30d042c-85bf-4aca-b808-2ebf9637b472', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'Calls', 'module', 90, 0),
('e34e7b8c-ae6b-4002-b173-ce053fbd407c', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AOS_Quotes', 'module', 89, 0),
('e3521608-d345-46e4-b7ad-6d195e0708af', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'SurveyQuestions', 'module', 90, 0),
('e36ad80b-8a25-4bf2-8e66-98fa7a596ae9', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Calls_Reschedule', 'module', 90, 0),
('e3de953a-8c5c-49c8-973b-a5e7722a1992', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AOP_Case_Events', 'module', 90, 0),
('e42de440-9337-436f-ac86-394d8ee40863', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'SurveyQuestionResponses', 'module', 90, 0),
('e78b9cac-fc0d-4354-a137-fdbada26c7cd', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AOR_Reports', 'module', 90, 0),
('e85f176a-60a4-4159-99d3-692433c45484', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'CalendarAccount', 'module', 90, 0),
('e8ae71ad-1431-404c-879f-46e015b3e746', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AOP_Case_Events', 'module', 90, 0),
('e8d227c5-37c6-493c-a9c5-4ff4eda20dc3', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'SurveyQuestionOptions', 'module', 90, 0),
('e9350736-e0f9-4cc9-893c-dbd8a3251b61', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'AOD_Index', 'module', 90, 0),
('e97269a0-e7c6-4884-8910-63044f419abf', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AOD_IndexEvent', 'module', 90, 0),
('e9f00fe7-5ac3-4fa1-9b6b-d62c52ddd6b2', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Documents', 'module', 89, 0),
('ea7becde-f7e5-46ff-9aca-74a940f42ccb', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'AOP_Case_Events', 'module', 89, 0),
('eafb3bc7-7eb4-4b58-9ef7-8fc1c587817b', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'Documents', 'module', 90, 0),
('ebca7a52-d9b1-43d9-b0f1-e16418682377', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Project', 'module', 90, 0),
('eca10119-48e7-42f6-94b2-79882e1cbd53', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AOS_PDF_Templates', 'module', 90, 0),
('ed09aa4c-86a9-4dfc-9a85-c9ad120d7653', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AOR_Scheduled_Reports', 'module', 90, 0),
('ee1c823f-e03b-45bc-b846-e5254a53a749', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'SurveyQuestions', 'module', 90, 0),
('ee537c88-6fbc-4192-a4eb-0901e498e55a', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'SurveyResponses', 'module', 90, 0),
('ee9e9cf1-f914-4923-ba57-64b35a1b204a', '[[regtime]]', '[[regtime]]', '1', '', 'export', 'Documents', 'module', 90, 0),
('f0d11ac7-1052-4d5f-b993-c042ce1e301c', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'AOW_Processed', 'module', 90, 0),
('f119da74-512f-4d1c-95c2-d7f0a212521b', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AOD_Index', 'module', 90, 0),
('f14d6acb-5ac5-4d34-bf93-e919c93cfc77', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'ExternalOAuthConnection', 'module', 90, 0),
('f1833a40-f977-4712-bb59-9a2955fca9a1', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'AM_TaskTemplates', 'module', 90, 0),
('f183a555-9342-4679-a2df-1028d8a1a48a', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Alerts', 'module', 90, 0),
('f1de6fa4-8ef8-493c-9b1c-8051f2715866', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'EmailMarketing', 'module', 90, 0),
('f2ef8139-cb4e-4b47-844d-58103be784ec', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'SurveyQuestions', 'module', 90, 0),
('f3005de3-2707-439f-a84b-7c75165059dd', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'SurveyQuestionOptions', 'module', 90, 0),
('f305898b-36eb-4d87-9821-bae2fafc3326', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'AOP_Case_Events', 'module', 90, 0),
('f450271c-b4c4-42a3-af27-75c44dff0eba', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Contacts', 'module', 90, 0),
('f4f166da-eca3-47ba-8121-40460c0321e0', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'OutboundEmailAccounts', 'module', 90, 0),
('f5f3f063-be4b-461d-84ea-c7c40dd3facd', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'SurveyQuestions', 'module', 90, 0),
('f6130a18-7f80-4c3c-8467-9fa6bdb2bd9f', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Users', 'module', 90, 0),
('f63d6ba4-7295-4556-ab08-278b43009d3a', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'ExternalOAuthProvider', 'module', 90, 0),
('f70a6396-3530-4fa0-8f68-a55657a8bcc3', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'ExternalOAuthProvider', 'module', 90, 0),
('f7254043-31a1-416f-b701-16d39dce84bf', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Opportunities', 'module', 90, 0),
('f7690caa-0248-44fd-aed8-ba67042bf669', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'Notes', 'module', 90, 0),
('f8aa4735-c69b-4ef9-b290-0a5f2d6aa054', '[[regtime]]', '[[regtime]]', '1', '', 'view', 'EmailTemplates', 'module', 90, 0),
('f8b35cab-3d48-4397-8c22-96d0a5665173', '[[regtime]]', '[[regtime]]', '1', '', 'import', 'AOS_Products', 'module', 90, 0),
('f8f6e4d2-6ab0-41fb-adf6-c6491c731ec9', '[[regtime]]', '[[regtime]]', '1', '', 'edit', 'EmailTemplates', 'module', 90, 0),
('f9d8615d-af5f-4a7b-8ad0-2dfce5bcf744', '[[regtime]]', '[[regtime]]', '1', '', 'delete', 'Meetings', 'module', 90, 0),
('fa22429c-7641-4ad8-8c0c-9b1988608986', '[[regtime]]', '[[regtime]]', '1', '', 'access', 'Notes', 'module', 89, 0),
('fb0db941-cc3f-4702-84ed-253976a147a0', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AOS_Contracts', 'module', 90, 0),
('fd1fecd2-4bd5-4037-a291-7a11f75d780d', '[[regtime]]', '[[regtime]]', '1', '', 'massupdate', 'AM_TaskTemplates', 'module', 90, 0),
('fd250cde-28a1-48b6-915a-e0c5fb8e8369', '[[regtime]]', '[[regtime]]', '1', '', 'list', 'Campaigns', 'module', 90, 0);

-- --------------------------------------------------------

--
-- Table structure for table `acl_roles`
--

CREATE TABLE `acl_roles` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_aclrole_id_del` (`id`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `acl_roles_actions`
--

CREATE TABLE `acl_roles_actions` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `role_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `action_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `access_override` int DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_acl_role_id` (`role_id`),
  KEY `idx_acl_action_id` (`action_id`),
  KEY `idx_aclrole_action` (`role_id`,`action_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `acl_roles_users`
--

CREATE TABLE `acl_roles_users` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `role_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_aclrole_id` (`role_id`),
  KEY `idx_acluser_id` (`user_id`),
  KEY `idx_aclrole_user` (`role_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `address_book`
--

CREATE TABLE `address_book` (
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `bean` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bean_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  KEY `ab_user_bean_idx` (`assigned_user_id`,`bean`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `alerts`
--

CREATE TABLE `alerts` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT NULL,
  `target_module` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `url_redirect` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reminder_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `am_projecttemplates`
--

CREATE TABLE `am_projecttemplates` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Draft',
  `priority` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'High',
  `override_business_hours` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `am_projecttemplates_audit`
--

CREATE TABLE `am_projecttemplates_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_am_projecttemplates_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `am_projecttemplates_contacts_1_c`
--

CREATE TABLE `am_projecttemplates_contacts_1_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `am_projecttemplates_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contacts_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `am_projecttemplates_contacts_1_alt` (`am_projecttemplates_ida`,`contacts_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `am_projecttemplates_project_1_c`
--

CREATE TABLE `am_projecttemplates_project_1_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `am_projecttemplates_project_1am_projecttemplates_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `am_projecttemplates_project_1project_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `am_projecttemplates_project_1_ida1` (`am_projecttemplates_project_1am_projecttemplates_ida`),
  KEY `am_projecttemplates_project_1_alt` (`am_projecttemplates_project_1project_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `am_projecttemplates_users_1_c`
--

CREATE TABLE `am_projecttemplates_users_1_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `am_projecttemplates_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `users_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `am_projecttemplates_users_1_alt` (`am_projecttemplates_ida`,`users_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `am_tasktemplates`
--

CREATE TABLE `am_tasktemplates` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Not Started',
  `priority` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'High',
  `percent_complete` int DEFAULT '0',
  `predecessors` int DEFAULT NULL,
  `milestone_flag` tinyint(1) DEFAULT '0',
  `relationship_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'FS',
  `task_number` int DEFAULT NULL,
  `order_number` int DEFAULT NULL,
  `estimated_effort` int DEFAULT NULL,
  `utilization` varchar(100) COLLATE utf8mb4_general_ci DEFAULT '0',
  `duration` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `am_tasktemplates_am_projecttemplates_c`
--

CREATE TABLE `am_tasktemplates_am_projecttemplates_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `am_tasktemplates_am_projecttemplatesam_projecttemplates_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `am_tasktemplates_am_projecttemplatesam_tasktemplates_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `am_tasktemplates_am_projecttemplates_ida1` (`am_tasktemplates_am_projecttemplatesam_projecttemplates_ida`),
  KEY `am_tasktemplates_am_projecttemplates_alt` (`am_tasktemplates_am_projecttemplatesam_tasktemplates_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `am_tasktemplates_audit`
--

CREATE TABLE `am_tasktemplates_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_am_tasktemplates_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aobh_businesshours`
--

CREATE TABLE `aobh_businesshours` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `opening_hours` varchar(100) COLLATE utf8mb4_general_ci DEFAULT '1',
  `closing_hours` varchar(100) COLLATE utf8mb4_general_ci DEFAULT '1',
  `open_status` tinyint(1) DEFAULT NULL,
  `day` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'monday',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aod_index`
--

CREATE TABLE `aod_index` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `last_optimised` datetime DEFAULT NULL,
  `location` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aod_indexevent`
--

CREATE TABLE `aod_indexevent` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `error` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `success` tinyint(1) DEFAULT '0',
  `record_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `record_module` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_record_module` (`record_module`),
  KEY `idx_record_id` (`record_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aod_indexevent_audit`
--

CREATE TABLE `aod_indexevent_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_aod_indexevent_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aod_index_audit`
--

CREATE TABLE `aod_index_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_aod_index_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aok_knowledgebase`
--

CREATE TABLE `aok_knowledgebase` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Draft',
  `revision` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `additional_info` text COLLATE utf8mb4_general_ci,
  `user_id_c` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_id1_c` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aok_knowledgebase_audit`
--

CREATE TABLE `aok_knowledgebase_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_aok_knowledgebase_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aok_knowledgebase_categories`
--

CREATE TABLE `aok_knowledgebase_categories` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `aok_knowledgebase_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `aok_knowledge_base_categories_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `aok_knowledgebase_categories_alt` (`aok_knowledgebase_id`,`aok_knowledge_base_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aok_knowledge_base_categories`
--

CREATE TABLE `aok_knowledge_base_categories` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aok_knowledge_base_categories_audit`
--

CREATE TABLE `aok_knowledge_base_categories_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_aok_knowledge_base_categories_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aop_case_events`
--

CREATE TABLE `aop_case_events` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `case_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aop_case_events_audit`
--

CREATE TABLE `aop_case_events_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_aop_case_events_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aop_case_updates`
--

CREATE TABLE `aop_case_updates` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `case_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contact_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `internal` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aop_case_updates_audit`
--

CREATE TABLE `aop_case_updates_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_aop_case_updates_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aor_charts`
--

CREATE TABLE `aor_charts` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `aor_report_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `x_field` int DEFAULT NULL,
  `y_field` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aor_conditions`
--

CREATE TABLE `aor_conditions` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `aor_report_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `condition_order` int DEFAULT NULL,
  `logic_op` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parenthesis` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `module_path` longtext COLLATE utf8mb4_general_ci,
  `field` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `operator` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `value_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `value` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parameter` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `aor_conditions_index_report_id` (`aor_report_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aor_fields`
--

CREATE TABLE `aor_fields` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `aor_report_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_order` int DEFAULT NULL,
  `module_path` longtext COLLATE utf8mb4_general_ci,
  `field` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `display` tinyint(1) DEFAULT NULL,
  `link` tinyint(1) DEFAULT NULL,
  `label` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_function` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `sort_by` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `format` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `total` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `sort_order` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `group_by` tinyint(1) DEFAULT NULL,
  `group_order` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `group_display` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `aor_fields_index_report_id` (`aor_report_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aor_reports`
--

CREATE TABLE `aor_reports` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `report_module` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `graphs_per_row` int DEFAULT '2',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aor_reports_audit`
--

CREATE TABLE `aor_reports_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_aor_reports_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aor_scheduled_reports`
--

CREATE TABLE `aor_scheduled_reports` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `schedule` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `last_run` datetime DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email_recipients` longtext COLLATE utf8mb4_general_ci,
  `aor_report_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_contracts`
--

CREATE TABLE `aos_contracts` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reference_code` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `total_contract_value` decimal(26,6) DEFAULT NULL,
  `total_contract_value_usdollar` decimal(26,6) DEFAULT NULL,
  `currency_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Not Started',
  `customer_signed_date` date DEFAULT NULL,
  `company_signed_date` date DEFAULT NULL,
  `renewal_reminder_date` datetime DEFAULT NULL,
  `contract_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Type',
  `contract_account_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `opportunity_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contact_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `call_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `total_amt` decimal(26,6) DEFAULT NULL,
  `total_amt_usdollar` decimal(26,6) DEFAULT NULL,
  `subtotal_amount` decimal(26,6) DEFAULT NULL,
  `subtotal_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `discount_amount` decimal(26,6) DEFAULT NULL,
  `discount_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `tax_amount` decimal(26,6) DEFAULT NULL,
  `tax_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `shipping_amount` decimal(26,6) DEFAULT NULL,
  `shipping_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `shipping_tax` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_tax_amt` decimal(26,6) DEFAULT NULL,
  `shipping_tax_amt_usdollar` decimal(26,6) DEFAULT NULL,
  `total_amount` decimal(26,6) DEFAULT NULL,
  `total_amount_usdollar` decimal(26,6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_contracts_audit`
--

CREATE TABLE `aos_contracts_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_aos_contracts_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_contracts_documents`
--

CREATE TABLE `aos_contracts_documents` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `aos_contracts_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `documents_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `document_revision_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `aos_contracts_documents_alt` (`aos_contracts_id`,`documents_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_invoices`
--

CREATE TABLE `aos_invoices` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_account_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_contact_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_address_street` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_address_city` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_address_state` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_address_postalcode` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_address_country` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_address_street` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_address_city` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_address_state` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_address_postalcode` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_address_country` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `number` int NOT NULL,
  `total_amt` decimal(26,6) DEFAULT NULL,
  `total_amt_usdollar` decimal(26,6) DEFAULT NULL,
  `subtotal_amount` decimal(26,6) DEFAULT NULL,
  `subtotal_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `discount_amount` decimal(26,6) DEFAULT NULL,
  `discount_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `tax_amount` decimal(26,6) DEFAULT NULL,
  `tax_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `shipping_amount` decimal(26,6) DEFAULT NULL,
  `shipping_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `shipping_tax` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_tax_amt` decimal(26,6) DEFAULT NULL,
  `shipping_tax_amt_usdollar` decimal(26,6) DEFAULT NULL,
  `total_amount` decimal(26,6) DEFAULT NULL,
  `total_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `currency_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `quote_number` int DEFAULT NULL,
  `quote_date` date DEFAULT NULL,
  `invoice_date` date DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `template_ddown_c` text COLLATE utf8mb4_general_ci,
  `subtotal_tax_amount` decimal(26,6) DEFAULT NULL,
  `subtotal_tax_amount_usdollar` decimal(26,6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_invoices_audit`
--

CREATE TABLE `aos_invoices_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_aos_invoices_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_line_item_groups`
--

CREATE TABLE `aos_line_item_groups` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `total_amt` decimal(26,6) DEFAULT NULL,
  `total_amt_usdollar` decimal(26,6) DEFAULT NULL,
  `discount_amount` decimal(26,6) DEFAULT NULL,
  `discount_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `subtotal_amount` decimal(26,6) DEFAULT NULL,
  `subtotal_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `tax_amount` decimal(26,6) DEFAULT NULL,
  `tax_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `subtotal_tax_amount` decimal(26,6) DEFAULT NULL,
  `subtotal_tax_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `total_amount` decimal(26,6) DEFAULT NULL,
  `total_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `parent_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `number` int DEFAULT NULL,
  `currency_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_line_item_groups_audit`
--

CREATE TABLE `aos_line_item_groups_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_aos_line_item_groups_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_pdf_templates`
--

CREATE TABLE `aos_pdf_templates` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `active` tinyint(1) DEFAULT '1',
  `type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `pdfheader` longtext COLLATE utf8mb4_general_ci,
  `pdffooter` longtext COLLATE utf8mb4_general_ci,
  `margin_left` int DEFAULT '15',
  `margin_right` int DEFAULT '15',
  `margin_top` int DEFAULT '16',
  `margin_bottom` int DEFAULT '16',
  `margin_header` int DEFAULT '9',
  `margin_footer` int DEFAULT '9',
  `page_size` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `orientation` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_pdf_templates_audit`
--

CREATE TABLE `aos_pdf_templates_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_aos_pdf_templates_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_products`
--

CREATE TABLE `aos_products` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `maincode` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'XXXX',
  `part_number` varchar(25) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `category` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Good',
  `cost` decimal(26,6) DEFAULT NULL,
  `cost_usdollar` decimal(26,6) DEFAULT NULL,
  `currency_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `price` decimal(26,6) DEFAULT NULL,
  `price_usdollar` decimal(26,6) DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contact_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `product_image` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `aos_product_category_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_products_audit`
--

CREATE TABLE `aos_products_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_aos_products_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_products_quotes`
--

CREATE TABLE `aos_products_quotes` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` text COLLATE utf8mb4_general_ci,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `currency_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `part_number` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `item_description` text COLLATE utf8mb4_general_ci,
  `number` int DEFAULT NULL,
  `product_qty` decimal(18,4) DEFAULT NULL,
  `product_cost_price` decimal(26,6) DEFAULT NULL,
  `product_cost_price_usdollar` decimal(26,6) DEFAULT NULL,
  `product_list_price` decimal(26,6) DEFAULT NULL,
  `product_list_price_usdollar` decimal(26,6) DEFAULT NULL,
  `product_discount` decimal(26,6) DEFAULT NULL,
  `product_discount_usdollar` decimal(26,6) DEFAULT NULL,
  `product_discount_amount` decimal(26,6) DEFAULT NULL,
  `product_discount_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `discount` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'Percentage',
  `product_unit_price` decimal(26,6) DEFAULT NULL,
  `product_unit_price_usdollar` decimal(26,6) DEFAULT NULL,
  `vat_amt` decimal(26,6) DEFAULT NULL,
  `vat_amt_usdollar` decimal(26,6) DEFAULT NULL,
  `product_total_price` decimal(26,6) DEFAULT NULL,
  `product_total_price_usdollar` decimal(26,6) DEFAULT NULL,
  `vat` varchar(100) COLLATE utf8mb4_general_ci DEFAULT '5.0',
  `parent_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `product_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `group_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_aospq_par_del` (`parent_id`,`parent_type`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_products_quotes_audit`
--

CREATE TABLE `aos_products_quotes_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_aos_products_quotes_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_product_categories`
--

CREATE TABLE `aos_product_categories` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_parent` tinyint(1) DEFAULT '0',
  `parent_category_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_product_categories_audit`
--

CREATE TABLE `aos_product_categories_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_aos_product_categories_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_quotes`
--

CREATE TABLE `aos_quotes` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `approval_issue` text COLLATE utf8mb4_general_ci,
  `billing_account_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_contact_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_address_street` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_address_city` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_address_state` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_address_postalcode` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `billing_address_country` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_address_street` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_address_city` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_address_state` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_address_postalcode` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_address_country` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `expiration` date DEFAULT NULL,
  `number` int DEFAULT NULL,
  `opportunity_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `template_ddown_c` text COLLATE utf8mb4_general_ci,
  `total_amt` decimal(26,6) DEFAULT NULL,
  `total_amt_usdollar` decimal(26,6) DEFAULT NULL,
  `subtotal_amount` decimal(26,6) DEFAULT NULL,
  `subtotal_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `discount_amount` decimal(26,6) DEFAULT NULL,
  `discount_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `tax_amount` decimal(26,6) DEFAULT NULL,
  `tax_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `shipping_amount` decimal(26,6) DEFAULT NULL,
  `shipping_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `shipping_tax` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `shipping_tax_amt` decimal(26,6) DEFAULT NULL,
  `shipping_tax_amt_usdollar` decimal(26,6) DEFAULT NULL,
  `total_amount` decimal(26,6) DEFAULT NULL,
  `total_amount_usdollar` decimal(26,6) DEFAULT NULL,
  `currency_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `stage` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Draft',
  `term` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `terms_c` text COLLATE utf8mb4_general_ci,
  `approval_status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `invoice_status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Not Invoiced',
  `subtotal_tax_amount` decimal(26,6) DEFAULT NULL,
  `subtotal_tax_amount_usdollar` decimal(26,6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_quotes_aos_invoices_c`
--

CREATE TABLE `aos_quotes_aos_invoices_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `aos_quotes77d9_quotes_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `aos_quotes6b83nvoices_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `aos_quotes_aos_invoices_alt` (`aos_quotes77d9_quotes_ida`,`aos_quotes6b83nvoices_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_quotes_audit`
--

CREATE TABLE `aos_quotes_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_aos_quotes_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_quotes_os_contracts_c`
--

CREATE TABLE `aos_quotes_os_contracts_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `aos_quotese81e_quotes_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `aos_quotes4dc0ntracts_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `aos_quotes_aos_contracts_alt` (`aos_quotese81e_quotes_ida`,`aos_quotes4dc0ntracts_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aos_quotes_project_c`
--

CREATE TABLE `aos_quotes_project_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `aos_quotes1112_quotes_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `aos_quotes7207project_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `aos_quotes_project_alt` (`aos_quotes1112_quotes_ida`,`aos_quotes7207project_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aow_actions`
--

CREATE TABLE `aow_actions` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `aow_workflow_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `action_order` int DEFAULT NULL,
  `action` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parameters` longtext COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `aow_action_index_workflow_id` (`aow_workflow_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aow_conditions`
--

CREATE TABLE `aow_conditions` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `aow_workflow_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `condition_order` int DEFAULT NULL,
  `module_path` longtext COLLATE utf8mb4_general_ci,
  `field` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `operator` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `value_type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `value` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `aow_conditions_index_workflow_id` (`aow_workflow_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aow_processed`
--

CREATE TABLE `aow_processed` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `aow_workflow_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parent_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Pending',
  PRIMARY KEY (`id`),
  KEY `aow_processed_index_workflow` (`aow_workflow_id`,`status`,`parent_id`,`deleted`),
  KEY `aow_processed_index_status` (`status`),
  KEY `aow_processed_index_workflow_id` (`aow_workflow_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aow_processed_aow_actions`
--

CREATE TABLE `aow_processed_aow_actions` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `aow_processed_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `aow_action_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(36) COLLATE utf8mb4_general_ci DEFAULT 'Pending',
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_aow_processed_aow_actions` (`aow_processed_id`,`aow_action_id`),
  KEY `idx_actid_del_freid` (`aow_action_id`,`deleted`,`aow_processed_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aow_workflow`
--

CREATE TABLE `aow_workflow` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `flow_module` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `flow_run_on` varchar(100) COLLATE utf8mb4_general_ci DEFAULT '0',
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Active',
  `run_when` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Always',
  `multiple_runs` tinyint(1) DEFAULT '0',
  `run_on_import` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `aow_workflow_index_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `aow_workflow_audit`
--

CREATE TABLE `aow_workflow_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_aow_workflow_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `bugs`
--

CREATE TABLE `bugs` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bug_number` int NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `priority` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `resolution` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `work_log` text COLLATE utf8mb4_general_ci,
  `found_in_release` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `fixed_in_release` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `source` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `product_category` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bugsnumk` (`bug_number`),
  KEY `bug_number` (`bug_number`),
  KEY `idx_bug_name` (`name`),
  KEY `idx_bugs_assigned_user` (`assigned_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `bugs_audit`
--

CREATE TABLE `bugs_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_bugs_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `calendar_accounts`
--

CREATE TABLE `calendar_accounts` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `source` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'personal',
  `oauth_connection_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `username` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `server_url` varchar(500) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `api_key` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `api_endpoint` varchar(500) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `calendar_user_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `last_connection_status` tinyint(1) DEFAULT '0',
  `last_connection_test` datetime DEFAULT NULL,
  `last_sync_attempt_date` datetime DEFAULT NULL,
  `last_sync_attempt_status` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `last_sync_attempt_message` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `last_sync_date` datetime DEFAULT NULL,
  `external_calendar_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_cal_acct_user_type_status` (`calendar_user_id`,`type`,`last_connection_status`,`deleted`),
  KEY `idx_cal_acct_external_cal_id` (`external_calendar_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `calendar_accounts_audit`
--

CREATE TABLE `calendar_accounts_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_calendar_accounts_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `calendar_account_meetings`
--

CREATE TABLE `calendar_account_meetings` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `calendar_account_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `meeting_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `calendar_account_source` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `external_event_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `last_sync` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_calendar_account_meeting` (`calendar_account_id`,`meeting_id`),
  KEY `idx_cal_acc_mtg_cal` (`calendar_account_id`),
  KEY `idx_cal_acc_mtg_mtg` (`meeting_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `calls`
--

CREATE TABLE `calls` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `duration_hours` int DEFAULT NULL,
  `duration_minutes` int DEFAULT NULL,
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `parent_type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Planned',
  `direction` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reminder_time` int DEFAULT '-1',
  `email_reminder_time` int DEFAULT '-1',
  `email_reminder_sent` tinyint(1) DEFAULT '0',
  `outlook_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `repeat_type` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `repeat_interval` int DEFAULT '1',
  `repeat_dow` varchar(7) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `repeat_until` date DEFAULT NULL,
  `repeat_count` int DEFAULT NULL,
  `repeat_parent_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `recurring_source` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_call_name` (`name`),
  KEY `idx_status` (`status`),
  KEY `idx_calls_date_start` (`date_start`),
  KEY `idx_calls_par_del` (`parent_id`,`parent_type`,`deleted`),
  KEY `idx_calls_assigned_del` (`deleted`,`assigned_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `calls_contacts`
--

CREATE TABLE `calls_contacts` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `call_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contact_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `required` varchar(1) COLLATE utf8mb4_general_ci DEFAULT '1',
  `accept_status` varchar(25) COLLATE utf8mb4_general_ci DEFAULT 'none',
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_con_call_call` (`call_id`),
  KEY `idx_con_call_con` (`contact_id`),
  KEY `idx_call_contact` (`call_id`,`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `calls_leads`
--

CREATE TABLE `calls_leads` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `call_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `lead_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `required` varchar(1) COLLATE utf8mb4_general_ci DEFAULT '1',
  `accept_status` varchar(25) COLLATE utf8mb4_general_ci DEFAULT 'none',
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_lead_call_call` (`call_id`),
  KEY `idx_lead_call_lead` (`lead_id`),
  KEY `idx_call_lead` (`call_id`,`lead_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `calls_reschedule`
--

CREATE TABLE `calls_reschedule` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reason` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `call_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `calls_reschedule_audit`
--

CREATE TABLE `calls_reschedule_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_calls_reschedule_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `calls_users`
--

CREATE TABLE `calls_users` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `call_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `required` varchar(1) COLLATE utf8mb4_general_ci DEFAULT '1',
  `accept_status` varchar(25) COLLATE utf8mb4_general_ci DEFAULT 'none',
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_usr_call_call` (`call_id`),
  KEY `idx_usr_call_usr` (`user_id`),
  KEY `idx_call_users` (`call_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `campaigns`
--

CREATE TABLE `campaigns` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `tracker_key` int NOT NULL AUTO_INCREMENT,
  `tracker_count` int DEFAULT '0',
  `refer_url` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'http://',
  `tracker_text` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `impressions` int DEFAULT '0',
  `currency_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `budget` double DEFAULT NULL,
  `expected_cost` double DEFAULT NULL,
  `actual_cost` double DEFAULT NULL,
  `expected_revenue` double DEFAULT NULL,
  `campaign_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `objective` text COLLATE utf8mb4_general_ci,
  `content` text COLLATE utf8mb4_general_ci,
  `frequency` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `survey_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `camp_auto_tracker_key` (`tracker_key`),
  KEY `idx_campaign_name` (`name`),
  KEY `idx_survey_id` (`survey_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `campaigns_audit`
--

CREATE TABLE `campaigns_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_campaigns_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `campaign_log`
--

CREATE TABLE `campaign_log` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `campaign_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `target_tracker_key` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `target_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `target_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `activity_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `activity_date` datetime DEFAULT NULL,
  `related_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `related_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `archived` tinyint(1) DEFAULT '0',
  `hits` int DEFAULT '0',
  `list_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `more_information` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `marketing_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_camp_tracker` (`target_tracker_key`),
  KEY `idx_camp_campaign_id` (`campaign_id`),
  KEY `idx_camp_more_info` (`more_information`),
  KEY `idx_target_id` (`target_id`),
  KEY `idx_target_id_deleted` (`target_id`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `campaign_trkrs`
--

CREATE TABLE `campaign_trkrs` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `tracker_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `tracker_url` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'http://',
  `tracker_key` int NOT NULL AUTO_INCREMENT,
  `campaign_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_optout` tinyint(1) DEFAULT '0',
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `campaign_tracker_key_idx` (`tracker_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cases`
--

CREATE TABLE `cases` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `case_number` int NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `priority` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `resolution` text COLLATE utf8mb4_general_ci,
  `work_log` text COLLATE utf8mb4_general_ci,
  `account_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `state` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Open',
  `contact_created_by_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `casesnumk` (`case_number`),
  KEY `case_number` (`case_number`),
  KEY `idx_case_name` (`name`),
  KEY `idx_account_id` (`account_id`),
  KEY `idx_cases_stat_del` (`assigned_user_id`,`status`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cases_audit`
--

CREATE TABLE `cases_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_cases_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cases_bugs`
--

CREATE TABLE `cases_bugs` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `case_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bug_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_cas_bug_cas` (`case_id`),
  KEY `idx_cas_bug_bug` (`bug_id`),
  KEY `idx_case_bug` (`case_id`,`bug_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cases_cstm`
--

CREATE TABLE `cases_cstm` (
  `id_c` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `jjwg_maps_lng_c` float(11,8) DEFAULT '0.00000000',
  `jjwg_maps_lat_c` float(10,8) DEFAULT '0.00000000',
  `jjwg_maps_geocode_status_c` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `jjwg_maps_address_c` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id_c`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `config`
--

CREATE TABLE `config` (
  `category` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_general_ci,
  KEY `idx_config_cat` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `config`
--

INSERT INTO `config` VALUES
('notify', 'fromaddress', '[[admin_email]]'),
('notify', 'fromname', '[[site_name]]'),
('notify', 'send_by_default', '1'),
('notify', 'on', '1'),
('notify', 'send_from_assigning_user', '0'),
('info', 'sugar_version', '6.5.25'),
('MySettings', 'tab', 'YTozMzp7aTowO3M6NDoiSG9tZSI7aToxO3M6ODoiQWNjb3VudHMiO2k6MjtzOjg6IkNvbnRhY3RzIjtpOjM7czoxMzoiT3Bwb3J0dW5pdGllcyI7aTo0O3M6NToiTGVhZHMiO2k6NTtzOjEwOiJBT1NfUXVvdGVzIjtpOjY7czo4OiJDYWxlbmRhciI7aTo3O3M6OToiRG9jdW1lbnRzIjtpOjg7czo2OiJFbWFpbHMiO2k6OTtzOjU6IlNwb3RzIjtpOjEwO3M6OToiQ2FtcGFpZ25zIjtpOjExO3M6NToiQ2FsbHMiO2k6MTI7czo4OiJNZWV0aW5ncyI7aToxMztzOjU6IlRhc2tzIjtpOjE0O3M6NToiTm90ZXMiO2k6MTU7czoxMjoiQU9TX0ludm9pY2VzIjtpOjE2O3M6MTM6IkFPU19Db250cmFjdHMiO2k6MTc7czo1OiJDYXNlcyI7aToxODtzOjk6IlByb3NwZWN0cyI7aToxOTtzOjEzOiJQcm9zcGVjdExpc3RzIjtpOjIwO3M6NzoiUHJvamVjdCI7aToyMTtzOjE5OiJBTV9Qcm9qZWN0VGVtcGxhdGVzIjtpOjIyO3M6MTY6IkFNX1Rhc2tUZW1wbGF0ZXMiO2k6MjM7czo5OiJGUF9ldmVudHMiO2k6MjQ7czoxODoiRlBfRXZlbnRfTG9jYXRpb25zIjtpOjI1O3M6MTI6IkFPU19Qcm9kdWN0cyI7aToyNjtzOjIyOiJBT1NfUHJvZHVjdF9DYXRlZ29yaWVzIjtpOjI3O3M6MTc6IkFPU19QREZfVGVtcGxhdGVzIjtpOjI4O3M6MTE6IkFPUl9SZXBvcnRzIjtpOjI5O3M6MTc6IkFPS19Lbm93bGVkZ2VCYXNlIjtpOjMwO3M6Mjk6IkFPS19Lbm93bGVkZ2VfQmFzZV9DYXRlZ29yaWVzIjtpOjMxO3M6MTQ6IkVtYWlsVGVtcGxhdGVzIjtpOjMyO3M6NzoiU3VydmV5cyI7fQ=='),
('portal', 'on', '0'),
('tracker', 'Tracker', '1'),
('sugarfeed', 'enabled', '1'),
('sugarfeed', 'module_UserFeed', '1'),
('sugarfeed', 'module_Cases', '1'),
('sugarfeed', 'module_Opportunities', '1'),
('sugarfeed', 'module_Contacts', '1'),
('sugarfeed', 'module_Leads', '1'),
('Update', 'CheckUpdates', 'manual'),
('system', 'name', '[[site_name]]'),
('system', 'adminwizard', '1');

-- --------------------------------------------------------

--
-- Table structure for table `contacts`
--

CREATE TABLE `contacts` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `salutation` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `first_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `last_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `title` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `photo` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `department` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `do_not_call` tinyint(1) DEFAULT '0',
  `phone_home` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_mobile` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_work` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_other` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_fax` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `lawful_basis` text COLLATE utf8mb4_general_ci,
  `date_reviewed` date DEFAULT NULL,
  `lawful_basis_source` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_address_street` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_address_city` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_address_state` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_address_postalcode` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_address_country` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `alt_address_street` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `alt_address_city` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `alt_address_state` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `alt_address_postalcode` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `alt_address_country` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `assistant` varchar(75) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `assistant_phone` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `lead_source` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reports_to_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `birthdate` date DEFAULT NULL,
  `campaign_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `joomla_account_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `portal_account_disabled` tinyint(1) DEFAULT NULL,
  `portal_user_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Single',
  PRIMARY KEY (`id`),
  KEY `idx_cont_last_first` (`last_name`,`first_name`,`deleted`),
  KEY `idx_contacts_del_last` (`deleted`,`last_name`),
  KEY `idx_cont_del_reports` (`deleted`,`reports_to_id`,`last_name`),
  KEY `idx_reports_to_id` (`reports_to_id`),
  KEY `idx_del_id_user` (`deleted`,`id`,`assigned_user_id`),
  KEY `idx_cont_assigned` (`assigned_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `contacts_audit`
--

CREATE TABLE `contacts_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_contacts_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `contacts_bugs`
--

CREATE TABLE `contacts_bugs` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `contact_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bug_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contact_role` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_con_bug_con` (`contact_id`),
  KEY `idx_con_bug_bug` (`bug_id`),
  KEY `idx_contact_bug` (`contact_id`,`bug_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `contacts_cases`
--

CREATE TABLE `contacts_cases` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `contact_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `case_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contact_role` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_con_case_con` (`contact_id`),
  KEY `idx_con_case_case` (`case_id`),
  KEY `idx_contacts_cases` (`contact_id`,`case_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `contacts_cstm`
--

CREATE TABLE `contacts_cstm` (
  `id_c` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `jjwg_maps_lng_c` float(11,8) DEFAULT '0.00000000',
  `jjwg_maps_lat_c` float(10,8) DEFAULT '0.00000000',
  `jjwg_maps_geocode_status_c` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `jjwg_maps_address_c` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id_c`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `contacts_users`
--

CREATE TABLE `contacts_users` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `contact_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_con_users_con` (`contact_id`),
  KEY `idx_con_users_user` (`user_id`),
  KEY `idx_contacts_users` (`contact_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cron_remove_documents`
--

CREATE TABLE `cron_remove_documents` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `bean_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `module` varchar(25) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_cron_remove_document_bean_id` (`bean_id`),
  KEY `idx_cron_remove_document_stamp` (`date_modified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `currencies`
--

CREATE TABLE `currencies` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `symbol` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `iso4217` varchar(3) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `conversion_rate` double DEFAULT '0',
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_currency_name` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_fields`
--

CREATE TABLE `custom_fields` (
  `bean_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `set_num` int DEFAULT '0',
  `field0` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field1` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field2` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field3` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field4` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field5` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field6` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field7` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field8` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field9` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  KEY `idx_beanid_set_num` (`bean_id`,`set_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `documents`
--

CREATE TABLE `documents` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `document_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `doc_id` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `doc_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Sugar',
  `doc_url` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `active_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `category_id` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `subcategory_id` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status_id` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `document_revision_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `related_doc_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `related_doc_rev_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_template` tinyint(1) DEFAULT '0',
  `template_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_doc_cat` (`category_id`,`subcategory_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `documents_accounts`
--

CREATE TABLE `documents_accounts` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `document_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `account_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `documents_accounts_account_id` (`account_id`,`document_id`),
  KEY `documents_accounts_document_id` (`document_id`,`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `documents_bugs`
--

CREATE TABLE `documents_bugs` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `document_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bug_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `documents_bugs_bug_id` (`bug_id`,`document_id`),
  KEY `documents_bugs_document_id` (`document_id`,`bug_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `documents_cases`
--

CREATE TABLE `documents_cases` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `document_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `case_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `documents_cases_case_id` (`case_id`,`document_id`),
  KEY `documents_cases_document_id` (`document_id`,`case_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `documents_contacts`
--

CREATE TABLE `documents_contacts` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `document_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contact_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `documents_contacts_contact_id` (`contact_id`,`document_id`),
  KEY `documents_contacts_document_id` (`document_id`,`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `documents_opportunities`
--

CREATE TABLE `documents_opportunities` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `document_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `opportunity_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_docu_opps_oppo_id` (`opportunity_id`,`document_id`),
  KEY `idx_docu_oppo_docu_id` (`document_id`,`opportunity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `document_revisions`
--

CREATE TABLE `document_revisions` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `change_log` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `document_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `doc_id` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `doc_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `doc_url` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `filename` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `file_ext` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `file_mime_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `revision` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `date_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `documentrevision_mimetype` (`file_mime_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `eapm`
--

CREATE TABLE `eapm` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `application` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'webex',
  `api_data` text COLLATE utf8mb4_general_ci,
  `consumer_key` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `consumer_secret` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `oauth_token` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `oauth_secret` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `validated` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_app_active` (`assigned_user_id`,`application`,`validated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `emailman`
--

CREATE TABLE `emailman` (
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `campaign_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `marketing_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `list_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `send_date_time` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `in_queue` tinyint(1) DEFAULT '0',
  `in_queue_date` datetime DEFAULT NULL,
  `send_attempts` int DEFAULT '0',
  `deleted` tinyint(1) DEFAULT '0',
  `related_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `related_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `related_confirm_opt_in` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_eman_list` (`list_id`,`user_id`,`deleted`),
  KEY `idx_eman_campaign_id` (`campaign_id`),
  KEY `idx_eman_relid_reltype_id` (`related_id`,`related_type`,`campaign_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `emails`
--

CREATE TABLE `emails` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `orphaned` tinyint(1) DEFAULT NULL,
  `last_synced` datetime DEFAULT NULL,
  `date_sent_received` datetime DEFAULT NULL,
  `message_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `flagged` tinyint(1) DEFAULT NULL,
  `reply_to_status` tinyint(1) DEFAULT NULL,
  `intent` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'pick',
  `mailbox_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parent_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `uid` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `category_id` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_email_name` (`name`),
  KEY `idx_message_id` (`message_id`),
  KEY `idx_email_parent_id` (`parent_id`),
  KEY `idx_email_assigned` (`assigned_user_id`,`type`,`status`),
  KEY `idx_email_cat` (`category_id`),
  KEY `idx_email_uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `emails_beans`
--

CREATE TABLE `emails_beans` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `email_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bean_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bean_module` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `campaign_data` text COLLATE utf8mb4_general_ci,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_emails_beans_bean_id` (`bean_id`),
  KEY `idx_emails_beans_email_bean` (`email_id`,`bean_id`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `emails_email_addr_rel`
--

CREATE TABLE `emails_email_addr_rel` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `email_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `address_type` varchar(4) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email_address_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_eearl_email_id` (`email_id`,`address_type`),
  KEY `idx_eearl_address_id` (`email_address_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `emails_text`
--

CREATE TABLE `emails_text` (
  `email_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `from_addr` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reply_to_addr` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `to_addrs` text COLLATE utf8mb4_general_ci,
  `cc_addrs` text COLLATE utf8mb4_general_ci,
  `bcc_addrs` text COLLATE utf8mb4_general_ci,
  `description` longtext COLLATE utf8mb4_general_ci,
  `description_html` longtext COLLATE utf8mb4_general_ci,
  `raw_source` longtext COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`email_id`),
  KEY `emails_textfromaddr` (`from_addr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `email_addresses`
--

CREATE TABLE `email_addresses` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `email_address` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email_address_caps` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `invalid_email` tinyint(1) DEFAULT '0',
  `opt_out` tinyint(1) DEFAULT '0',
  `confirm_opt_in` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'not-opt-in',
  `confirm_opt_in_date` datetime DEFAULT NULL,
  `confirm_opt_in_sent_date` datetime DEFAULT NULL,
  `confirm_opt_in_fail_date` datetime DEFAULT NULL,
  `confirm_opt_in_token` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_ea_caps_opt_out_invalid` (`email_address_caps`,`opt_out`,`invalid_email`),
  KEY `idx_ea_opt_out_invalid` (`email_address`,`opt_out`,`invalid_email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `email_addresses_audit`
--

CREATE TABLE `email_addresses_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_email_addresses_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `email_addr_bean_rel`
--

CREATE TABLE `email_addr_bean_rel` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `email_address_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `bean_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `bean_module` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_address` tinyint(1) DEFAULT '0',
  `reply_to_address` tinyint(1) DEFAULT '0',
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_email_address_id` (`email_address_id`),
  KEY `idx_bean_id` (`bean_id`,`bean_module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `email_cache`
--

CREATE TABLE `email_cache` (
  `ie_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `mbox` varchar(60) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `fromaddr` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `toaddr` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `senddate` datetime DEFAULT NULL,
  `message_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `mailsize` int unsigned DEFAULT NULL,
  `imap_uid` int unsigned DEFAULT NULL,
  `msgno` int unsigned DEFAULT NULL,
  `recent` tinyint DEFAULT NULL,
  `flagged` tinyint DEFAULT NULL,
  `answered` tinyint DEFAULT NULL,
  `deleted` tinyint DEFAULT NULL,
  `seen` tinyint DEFAULT NULL,
  `draft` tinyint DEFAULT NULL,
  KEY `idx_ie_id` (`ie_id`),
  KEY `idx_mail_date` (`ie_id`,`mbox`,`senddate`),
  KEY `idx_mail_from` (`ie_id`,`mbox`,`fromaddr`),
  KEY `idx_mail_subj` (`subject`),
  KEY `idx_mail_to` (`toaddr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `email_marketing`
--

CREATE TABLE `email_marketing` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `from_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `from_addr` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reply_to_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reply_to_addr` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `inbound_email_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_start` datetime DEFAULT NULL,
  `template_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `campaign_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `outbound_email_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `all_prospect_lists` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_emmkt_name` (`name`),
  KEY `idx_emmkit_del` (`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `email_marketing_prospect_lists`
--

CREATE TABLE `email_marketing_prospect_lists` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `prospect_list_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email_marketing_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `email_mp_prospects` (`email_marketing_id`,`prospect_list_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `email_templates`
--

CREATE TABLE `email_templates` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `published` varchar(3) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `subject` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `body` longtext COLLATE utf8mb4_general_ci,
  `body_html` longtext COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT NULL,
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `text_only` tinyint(1) DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_email_template_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `email_templates`
--

INSERT INTO `email_templates` VALUES
('[[generatepasswordtmpl]]', '[[regtime]]', '[[regtime]]', '1', '1', 'off', 'System-generated password email', 'This template is used when the System Administrator sends a new password to a user.', 'New account information', '\nHere is your account username and temporary password:\nUsername : $contact_user_user_name\nPassword : $contact_user_user_hash\n\n$config_site_url\n\nAfter you log in using the above password, you may be required to reset the password to one of your own choice.', '<div><table width="550"><tbody><tr><td><p>Here is your account username and temporary password:</p><p>Username : $contact_user_user_name </p><p>Password : $contact_user_user_hash </p><br /><p>$config_site_url</p><br /><p>After you log in using the above password, you may be required to reset the password to one of your own choice.</p>   </td>         </tr><tr><td></td>         </tr> </tbody></table> </div>', 0, NULL, 0, 'system'),
('[[lostpasswordtmpl]]', '[[regtime]]', '[[regtime]]', '1', '1', 'off', 'Forgot Password email', 'This template is used to send a user a link to click to reset the user''s account password.', 'Reset your account password', '\nYou recently requested on $contact_user_pwd_last_changed to be able to reset your account password.\n\nClick on the link below to reset your password:\n\n$contact_user_link_guid', '<div><table width="550"><tbody><tr><td><p>You recently requested on $contact_user_pwd_last_changed to be able to reset your account password. </p><p>Click on the link below to reset your password:</p><p> $contact_user_link_guid </p>  </td>         </tr><tr><td></td>         </tr> </tbody></table> </div>', 0, NULL, 0, 'system'),
('[[email_confirm_opt_in_email_template_id]]', '[[regtime]]', '[[regtime]]', '1', '1', 'off', 'Confirmed Opt In', 'Email template to send to a contact to confirm they have opted in.', 'Confirm Opt In', 'Hi $contact_first_name $contact_last_name, \\n Please confirm that you have opted in by selecting the following link: $sugarurl/index.php?entryPoint=ConfirmOptIn&from=$emailaddress_email_address', '<p>Hi $contact_first_name $contact_last_name,</p>\n             <p>\n                Please confirm that you have opted in by selecting the following link:\n                <a href="$sugarurl/index.php?entryPoint=ConfirmOptIn&from=$emailaddress_confirm_opt_in_token">Opt In</a>\n             </p>', 0, NULL, NULL, 'system'),
('[factoremailtmpl]]', '[[regtime]]', '[[regtime]]', '1', '1', 'off', 'Two Factor Authentication email', 'This template is used to send a user a code for Two Factor Authentication.', 'Two Factor Authentication Code', 'Two Factor Authentication code is $code.', '<div><table width="550"><tbody><tr><td><p>Two Factor Authentication code is <b>$code</b>.</p>  </td>         </tr><tr><td></td>         </tr> </tbody></table> </div>', 0, NULL, 0, 'system'),
('[[joomla_account_creation_email_template_id]]', '[[regtime]]', '[[regtime]]', '1', '1', 'off', 'Joomla Account Creation', 'Template used when informing a contact that they''ve been given an account on the joomla portal.', 'Support Portal Account Created', 'Hi $contact_name,\n					   An account has been created for you at $portal_address.\n					   You may login using this email address and the password $joomla_pass', '<p>Hi $contact_name,</p>\n					    <p>An account has been created for you at <a href="$portal_address">$portal_address</a>.</p>\n					    <p>You may login using this email address and the password $joomla_pass</p>', 0, NULL, NULL, 'system'),
('c58cfd68-0a2b-4cc9-a63e-de1cf2bd6a1d', '2013-05-24 14:31:45', '[[regtime]]', '1', '1', 'off', 'Event Invite Template', 'Default event invite template.', 'You have been invited to $fp_events_name', 'Dear $contact_name,\nYou have been invited to $fp_events_name on $fp_events_date_start to $fp_events_date_end\n$fp_events_description\nYours Sincerely,\n', '\n<p>Dear $contact_name,</p>\n<p>You have been invited to $fp_events_name on $fp_events_date_start to $fp_events_date_end</p>\n<p>$fp_events_description</p>\n<p>If you would like to accept this invititation please click accept.</p>\n<p> $fp_events_link or $fp_events_link_declined</p>\n<p>Yours Sincerely,</p>\n', 0, NULL, NULL, 'system'),
('[[contact_email_template_id]]', '[[regtime]]', '[[regtime]]', '1', '1', 'off', 'Contact Case Update', 'Template to send to a contact when their case is updated.', '$acase_name update [CASE:$acase_case_number]', 'Hi $user_first_name $user_last_name,\n\n					   You''ve had an update to your case $acase_name (# $acase_case_number) on $aop_case_updates_date_entered:\n					       $contact_first_name $contact_last_name, said:\n					               $aop_case_updates_description', '<p>Hi $contact_first_name $contact_last_name,</p>\n					    <p> </p>\n					    <p>You''ve had an update to your case $acase_name (# $acase_case_number) on $aop_case_updates_date_entered:</p>\n					    <p><strong>$user_first_name $user_last_name said:</strong></p>\n					    <p style="padding-left:30px;">$aop_case_updates_description</p>', 0, NULL, NULL, 'system'),
('[[user_email_template_id]]', '[[regtime]]', '[[regtime]]', '1', '1', 'off', 'User Case Update', 'Email template to send to a SuiteCRM user when their case is updated.', '$acase_name (# $acase_case_number) update', 'Hi $user_first_name $user_last_name,\n\n					   You''ve had an update to your case $acase_name (# $acase_case_number) on $aop_case_updates_date_entered:\n					       $contact_first_name $contact_last_name, said:\n					               $aop_case_updates_description\n                        You may review this Case at:\n                            $sugarurl/index.php?module=Cases&action=DetailView&record=$acase_id;', '<p>Hi $user_first_name $user_last_name,</p>\n					     <p> </p>\n					     <p>You''ve had an update to your case $acase_name (# $acase_case_number) on $aop_case_updates_date_entered:</p>\n					     <p><strong>$contact_first_name $contact_last_name, said:</strong></p>\n					     <p style="padding-left:30px;">$aop_case_updates_description</p>\n					     <p>You may review this Case at: $sugarurl/index.php?module=Cases&action=DetailView&record=$acase_id;</p>', 0, NULL, NULL, 'system'),
('[[case_creation_email_template_id]]', '[[regtime]]', '[[regtime]]', '1', '1', 'off', 'Case Creation', 'Template to send to a contact when a case is received from them.', '$acase_name [CASE:$acase_case_number]', 'Hi $contact_first_name $contact_last_name,\n\n					   We''ve received your case $acase_name (# $acase_case_number) on $acase_date_entered\n					   Status:		$acase_status\n					   Reference:	$acase_case_number\n					   Description:	$acase_description', '<p> Hi $contact_first_name $contact_last_name,</p>\n					    <p>We''ve received your case $acase_name (# $acase_case_number) on $acase_date_entered</p>\n					    <table border="0"><tbody>\n					    <tr><td>Status</td><td>$acase_status</td></tr>\n					    <tr><td>Reference</td><td>$acase_case_number</td></tr>\n					    <tr><td>Description</td><td>$acase_description</td></tr>\n					    </tbody></table>', 0, NULL, NULL, 'system'),
('[[case_closure_email_template_id]]', '[[regtime]]', '[[regtime]]', '1', '1', 'off', 'Case Closure', 'Template for informing a contact that their case has been closed.', '$acase_name [CASE:$acase_case_number] closed', 'Hi $contact_first_name $contact_last_name,\n\n					   Your case $acase_name (# $acase_case_number) has been closed on $acase_date_entered\n					   Status:				$acase_status\n					   Reference:			$acase_case_number\n					   Resolution:			$acase_resolution', '<p> Hi $contact_first_name $contact_last_name,</p>\n					    <p>Your case $acase_name (# $acase_case_number) has been closed on $acase_date_entered</p>\n					    <table border="0"><tbody>\n					    <tr><td>Status</td><td>$acase_status</td></tr>\n					    <tr><td>Reference</td><td>$acase_case_number</td></tr>\n					    <tr><td>Resolution</td><td>$acase_resolution</td></tr>\n					    </tbody></table>', 0, NULL, NULL, 'system');

-- --------------------------------------------------------

--
-- Table structure for table `external_oauth_connections`
--

CREATE TABLE `external_oauth_connections` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `client_id` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `client_secret` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `token_type` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `expires_in` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `access_token` text COLLATE utf8mb4_general_ci,
  `refresh_token` text COLLATE utf8mb4_general_ci,
  `external_oauth_provider_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `external_oauth_providers`
--

CREATE TABLE `external_oauth_providers` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `connector` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `redirect_uri_type` varchar(50) COLLATE utf8mb4_general_ci DEFAULT 'pretty_url',
  `client_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `client_secret` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `scope` text COLLATE utf8mb4_general_ci,
  `url_authorize` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `authorize_url_options` text COLLATE utf8mb4_general_ci,
  `url_access_token` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `extra_provider_params` text COLLATE utf8mb4_general_ci,
  `get_token_request_grant` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'authorization_code',
  `get_token_request_options` text COLLATE utf8mb4_general_ci,
  `refresh_token_request_grant` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'refresh_token',
  `refresh_token_request_options` text COLLATE utf8mb4_general_ci,
  `access_token_mapping` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'access_token',
  `expires_in_mapping` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'expires_in',
  `refresh_token_mapping` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'refresh_token',
  `token_type_mapping` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `favorites`
--

CREATE TABLE `favorites` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parent_type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fields_meta_data`
--

CREATE TABLE `fields_meta_data` (
  `id` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `vname` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `comments` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `help` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `custom_module` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `len` int DEFAULT NULL,
  `required` tinyint(1) DEFAULT '0',
  `default_value` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `audited` tinyint(1) DEFAULT '0',
  `massupdate` tinyint(1) DEFAULT '0',
  `duplicate_merge` smallint DEFAULT '0',
  `reportable` tinyint(1) DEFAULT '1',
  `importable` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ext1` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ext2` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ext3` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ext4` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_meta_id_del` (`id`,`deleted`),
  KEY `idx_meta_cm_del` (`custom_module`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `fields_meta_data`
--

INSERT INTO `fields_meta_data` VALUES
('Accountsjjwg_maps_address_c', 'jjwg_maps_address_c', 'LBL_JJWG_MAPS_ADDRESS', 'Address', 'Address', 'Accounts', 'varchar', 255, 0, NULL, '[[regtime]]', 0, 0, 0, 0, 1, 'true', NULL, '', '', ''),
('Accountsjjwg_maps_geocode_status_c', 'jjwg_maps_geocode_status_c', 'LBL_JJWG_MAPS_GEOCODE_STATUS', 'Geocode Status', 'Geocode Status', 'Accounts', 'varchar', 255, 0, NULL, '[[regtime]]', 0, 0, 0, 0, 1, 'true', NULL, '', '', ''),
('Accountsjjwg_maps_lat_c', 'jjwg_maps_lat_c', 'LBL_JJWG_MAPS_LAT', '', 'Latitude', 'Accounts', 'float', 10, 0, '0.00000000', '[[regtime]]', 0, 0, 0, 0, 1, 'true', '8', '', '', ''),
('Accountsjjwg_maps_lng_c', 'jjwg_maps_lng_c', 'LBL_JJWG_MAPS_LNG', '', 'Longitude', 'Accounts', 'float', 11, 0, '0.00000000', '[[regtime]]', 0, 0, 0, 0, 1, 'true', '8', '', '', ''),
('Casesjjwg_maps_address_c', 'jjwg_maps_address_c', 'LBL_JJWG_MAPS_ADDRESS', 'Address', 'Address', 'Cases', 'varchar', 255, 0, NULL, '[[regtime]]', 0, 0, 0, 0, 1, 'true', NULL, '', '', ''),
('Casesjjwg_maps_geocode_status_c', 'jjwg_maps_geocode_status_c', 'LBL_JJWG_MAPS_GEOCODE_STATUS', 'Geocode Status', 'Geocode Status', 'Cases', 'varchar', 255, 0, NULL, '[[regtime]]', 0, 0, 0, 0, 1, 'true', NULL, '', '', ''),
('Casesjjwg_maps_lat_c', 'jjwg_maps_lat_c', 'LBL_JJWG_MAPS_LAT', '', 'Latitude', 'Cases', 'float', 10, 0, '0.00000000', '[[regtime]]', 0, 0, 0, 0, 1, 'true', '8', '', '', ''),
('Casesjjwg_maps_lng_c', 'jjwg_maps_lng_c', 'LBL_JJWG_MAPS_LNG', '', 'Longitude', 'Cases', 'float', 11, 0, '0.00000000', '[[regtime]]', 0, 0, 0, 0, 1, 'true', '8', '', '', ''),
('Contactsjjwg_maps_address_c', 'jjwg_maps_address_c', 'LBL_JJWG_MAPS_ADDRESS', 'Address', 'Address', 'Contacts', 'varchar', 255, 0, NULL, '[[regtime]]', 0, 0, 0, 0, 1, 'true', NULL, '', '', ''),
('Contactsjjwg_maps_geocode_status_c', 'jjwg_maps_geocode_status_c', 'LBL_JJWG_MAPS_GEOCODE_STATUS', 'Geocode Status', 'Geocode Status', 'Contacts', 'varchar', 255, 0, NULL, '[[regtime]]', 0, 0, 0, 0, 1, 'true', NULL, '', '', ''),
('Contactsjjwg_maps_lat_c', 'jjwg_maps_lat_c', 'LBL_JJWG_MAPS_LAT', '', 'Latitude', 'Contacts', 'float', 10, 0, '0.00000000', '[[regtime]]', 0, 0, 0, 0, 1, 'true', '8', '', '', ''),
('Contactsjjwg_maps_lng_c', 'jjwg_maps_lng_c', 'LBL_JJWG_MAPS_LNG', '', 'Longitude', 'Contacts', 'float', 11, 0, '0.00000000', '[[regtime]]', 0, 0, 0, 0, 1, 'true', '8', '', '', ''),
('Leadsjjwg_maps_address_c', 'jjwg_maps_address_c', 'LBL_JJWG_MAPS_ADDRESS', 'Address', 'Address', 'Leads', 'varchar', 255, 0, NULL, '[[regtime]]', 0, 0, 0, 0, 1, 'true', NULL, '', '', ''),
('Leadsjjwg_maps_geocode_status_c', 'jjwg_maps_geocode_status_c', 'LBL_JJWG_MAPS_GEOCODE_STATUS', 'Geocode Status', 'Geocode Status', 'Leads', 'varchar', 255, 0, NULL, '[[regtime]]', 0, 0, 0, 0, 1, 'true', NULL, '', '', ''),
('Leadsjjwg_maps_lat_c', 'jjwg_maps_lat_c', 'LBL_JJWG_MAPS_LAT', '', 'Latitude', 'Leads', 'float', 10, 0, '0.00000000', '[[regtime]]', 0, 0, 0, 0, 1, 'true', '8', '', '', ''),
('Leadsjjwg_maps_lng_c', 'jjwg_maps_lng_c', 'LBL_JJWG_MAPS_LNG', '', 'Longitude', 'Leads', 'float', 11, 0, '0.00000000', '[[regtime]]', 0, 0, 0, 0, 1, 'true', '8', '', '', ''),
('Meetingsjjwg_maps_address_c', 'jjwg_maps_address_c', 'LBL_JJWG_MAPS_ADDRESS', 'Address', 'Address', 'Meetings', 'varchar', 255, 0, NULL, '[[regtime]]', 0, 0, 0, 0, 1, 'true', NULL, '', '', ''),
('Meetingsjjwg_maps_geocode_status_c', 'jjwg_maps_geocode_status_c', 'LBL_JJWG_MAPS_GEOCODE_STATUS', 'Geocode Status', 'Geocode Status', 'Meetings', 'varchar', 255, 0, NULL, '[[regtime]]', 0, 0, 0, 0, 1, 'true', NULL, '', '', ''),
('Meetingsjjwg_maps_lat_c', 'jjwg_maps_lat_c', 'LBL_JJWG_MAPS_LAT', '', 'Latitude', 'Meetings', 'float', 10, 0, '0.00000000', '[[regtime]]', 0, 0, 0, 0, 1, 'true', '8', '', '', ''),
('Meetingsjjwg_maps_lng_c', 'jjwg_maps_lng_c', 'LBL_JJWG_MAPS_LNG', '', 'Longitude', 'Meetings', 'float', 11, 0, '0.00000000', '[[regtime]]', 0, 0, 0, 0, 1, 'true', '8', '', '', ''),
('Opportunitiesjjwg_maps_address_c', 'jjwg_maps_address_c', 'LBL_JJWG_MAPS_ADDRESS', 'Address', 'Address', 'Opportunities', 'varchar', 255, 0, NULL, '[[regtime]]', 0, 0, 0, 0, 1, 'true', NULL, '', '', ''),
('Opportunitiesjjwg_maps_geocode_status_c', 'jjwg_maps_geocode_status_c', 'LBL_JJWG_MAPS_GEOCODE_STATUS', 'Geocode Status', 'Geocode Status', 'Opportunities', 'varchar', 255, 0, NULL, '[[regtime]]', 0, 0, 0, 0, 1, 'true', NULL, '', '', ''),
('Opportunitiesjjwg_maps_lat_c', 'jjwg_maps_lat_c', 'LBL_JJWG_MAPS_LAT', '', 'Latitude', 'Opportunities', 'float', 10, 0, '0.00000000', '[[regtime]]', 0, 0, 0, 0, 1, 'true', '8', '', '', ''),
('Opportunitiesjjwg_maps_lng_c', 'jjwg_maps_lng_c', 'LBL_JJWG_MAPS_LNG', '', 'Longitude', 'Opportunities', 'float', 11, 0, '0.00000000', '[[regtime]]', 0, 0, 0, 0, 1, 'true', '8', '', '', ''),
('Projectjjwg_maps_address_c', 'jjwg_maps_address_c', 'LBL_JJWG_MAPS_ADDRESS', 'Address', 'Address', 'Project', 'varchar', 255, 0, NULL, '[[regtime]]', 0, 0, 0, 0, 1, 'true', NULL, '', '', ''),
('Projectjjwg_maps_geocode_status_c', 'jjwg_maps_geocode_status_c', 'LBL_JJWG_MAPS_GEOCODE_STATUS', 'Geocode Status', 'Geocode Status', 'Project', 'varchar', 255, 0, NULL, '[[regtime]]', 0, 0, 0, 0, 1, 'true', NULL, '', '', ''),
('Projectjjwg_maps_lat_c', 'jjwg_maps_lat_c', 'LBL_JJWG_MAPS_LAT', '', 'Latitude', 'Project', 'float', 10, 0, '0.00000000', '[[regtime]]', 0, 0, 0, 0, 1, 'true', '8', '', '', ''),
('Projectjjwg_maps_lng_c', 'jjwg_maps_lng_c', 'LBL_JJWG_MAPS_LNG', '', 'Longitude', 'Project', 'float', 11, 0, '0.00000000', '[[regtime]]', 0, 0, 0, 0, 1, 'true', '8', '', '', ''),
('Prospectsjjwg_maps_address_c', 'jjwg_maps_address_c', 'LBL_JJWG_MAPS_ADDRESS', 'Address', 'Address', 'Prospects', 'varchar', 255, 0, NULL, '[[regtime]]', 0, 0, 0, 0, 1, 'true', NULL, '', '', ''),
('Prospectsjjwg_maps_geocode_status_c', 'jjwg_maps_geocode_status_c', 'LBL_JJWG_MAPS_GEOCODE_STATUS', 'Geocode Status', 'Geocode Status', 'Prospects', 'varchar', 255, 0, NULL, '[[regtime]]', 0, 0, 0, 0, 1, 'true', NULL, '', '', ''),
('Prospectsjjwg_maps_lat_c', 'jjwg_maps_lat_c', 'LBL_JJWG_MAPS_LAT', '', 'Latitude', 'Prospects', 'float', 10, 0, '0.00000000', '[[regtime]]', 0, 0, 0, 0, 1, 'true', '8', '', '', ''),
('Prospectsjjwg_maps_lng_c', 'jjwg_maps_lng_c', 'LBL_JJWG_MAPS_LNG', '', 'Longitude', 'Prospects', 'float', 11, 0, '0.00000000', '[[regtime]]', 0, 0, 0, 0, 1, 'true', '8', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `folders`
--

CREATE TABLE `folders` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `folder_type` varchar(25) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parent_folder` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `has_child` tinyint(1) DEFAULT '0',
  `is_group` tinyint(1) DEFAULT '0',
  `is_dynamic` tinyint(1) DEFAULT '0',
  `dynamic_query` text COLLATE utf8mb4_general_ci,
  `assign_to_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `modified_by` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_parent_folder` (`parent_folder`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `folders_rel`
--

CREATE TABLE `folders_rel` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `folder_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `polymorphic_module` varchar(25) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `polymorphic_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_poly_module_poly_id` (`polymorphic_module`,`polymorphic_id`),
  KEY `idx_fr_id_deleted_poly` (`folder_id`,`deleted`,`polymorphic_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `folders_subscriptions`
--

CREATE TABLE `folders_subscriptions` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `folder_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_folder_id_assigned_user_id` (`folder_id`,`assigned_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fp_events`
--

CREATE TABLE `fp_events` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `duration_hours` int DEFAULT NULL,
  `duration_minutes` int DEFAULT NULL,
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `budget` decimal(26,6) DEFAULT NULL,
  `currency_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `invite_templates` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `accept_redirect` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `decline_redirect` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `activity_status_type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fp_events_audit`
--

CREATE TABLE `fp_events_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_fp_events_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fp_events_contacts_c`
--

CREATE TABLE `fp_events_contacts_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `fp_events_contactsfp_events_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `fp_events_contactscontacts_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `invite_status` varchar(25) COLLATE utf8mb4_general_ci DEFAULT 'Not Invited',
  `accept_status` varchar(25) COLLATE utf8mb4_general_ci DEFAULT 'No Response',
  `email_responded` int DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fp_events_contacts_alt` (`fp_events_contactsfp_events_ida`,`fp_events_contactscontacts_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fp_events_fp_event_delegates_1_c`
--

CREATE TABLE `fp_events_fp_event_delegates_1_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `fp_events_fp_event_delegates_1fp_events_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `fp_events_fp_event_delegates_1fp_event_delegates_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fp_events_fp_event_delegates_1_ida1` (`fp_events_fp_event_delegates_1fp_events_ida`),
  KEY `fp_events_fp_event_delegates_1_alt` (`fp_events_fp_event_delegates_1fp_event_delegates_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fp_events_fp_event_locations_1_c`
--

CREATE TABLE `fp_events_fp_event_locations_1_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `fp_events_fp_event_locations_1fp_events_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `fp_events_fp_event_locations_1fp_event_locations_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fp_events_fp_event_locations_1_alt` (`fp_events_fp_event_locations_1fp_events_ida`,`fp_events_fp_event_locations_1fp_event_locations_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fp_events_leads_1_c`
--

CREATE TABLE `fp_events_leads_1_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `fp_events_leads_1fp_events_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `fp_events_leads_1leads_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `invite_status` varchar(25) COLLATE utf8mb4_general_ci DEFAULT 'Not Invited',
  `accept_status` varchar(25) COLLATE utf8mb4_general_ci DEFAULT 'No Response',
  `email_responded` int DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fp_events_leads_1_alt` (`fp_events_leads_1fp_events_ida`,`fp_events_leads_1leads_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fp_events_prospects_1_c`
--

CREATE TABLE `fp_events_prospects_1_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `fp_events_prospects_1fp_events_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `fp_events_prospects_1prospects_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `invite_status` varchar(25) COLLATE utf8mb4_general_ci DEFAULT 'Not Invited',
  `accept_status` varchar(25) COLLATE utf8mb4_general_ci DEFAULT 'No Response',
  `email_responded` int DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fp_events_prospects_1_alt` (`fp_events_prospects_1fp_events_ida`,`fp_events_prospects_1prospects_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fp_event_locations`
--

CREATE TABLE `fp_event_locations` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `address_city` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `address_country` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `address_postalcode` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `address_state` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `capacity` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fp_event_locations_audit`
--

CREATE TABLE `fp_event_locations_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_fp_event_locations_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fp_event_locations_fp_events_1_c`
--

CREATE TABLE `fp_event_locations_fp_events_1_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `fp_event_locations_fp_events_1fp_event_locations_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `fp_event_locations_fp_events_1fp_events_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fp_event_locations_fp_events_1_ida1` (`fp_event_locations_fp_events_1fp_event_locations_ida`),
  KEY `fp_event_locations_fp_events_1_alt` (`fp_event_locations_fp_events_1fp_events_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `import_maps`
--

CREATE TABLE `import_maps` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(254) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `source` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `enclosure` varchar(1) COLLATE utf8mb4_general_ci DEFAULT ' ',
  `delimiter` varchar(1) COLLATE utf8mb4_general_ci DEFAULT ',',
  `module` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_general_ci,
  `default_values` text COLLATE utf8mb4_general_ci,
  `has_header` tinyint(1) DEFAULT '1',
  `deleted` tinyint(1) DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_published` varchar(3) COLLATE utf8mb4_general_ci DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `idx_owner_module_name` (`assigned_user_id`,`module`,`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `inbound_email`
--

CREATE TABLE `inbound_email` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `last_import_run_datetime` datetime DEFAULT NULL,
  `mailbox_last_imported_days` text COLLATE utf8mb4_general_ci,
  `email_import_per_run_threshold` int DEFAULT NULL,
  `email_import_timeframe_start` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email_import_unread_only` tinyint(1) DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Active',
  `email_body_filtering` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'multi',
  `server_url` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `connection_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email_user` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email_password` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `port` int DEFAULT '143',
  `service` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `mailbox` text COLLATE utf8mb4_general_ci,
  `sentFolder` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `trashFolder` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `delete_seen` tinyint(1) DEFAULT '0',
  `move_messages_to_trash_after_import` tinyint(1) DEFAULT '0',
  `mailbox_type` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `template_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `stored_options` text COLLATE utf8mb4_general_ci,
  `group_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_personal` tinyint(1) DEFAULT '0',
  `groupfolder_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `auth_type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'basic',
  `protocol` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'imap',
  `is_ssl` tinyint(1) DEFAULT '0',
  `distribution_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `outbound_email_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `create_case_template_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `external_oauth_connection_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `inbound_email_autoreply`
--

CREATE TABLE `inbound_email_autoreply` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `autoreplied_to` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ie_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_ie_autoreplied_to` (`autoreplied_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `inbound_email_cache_ts`
--

CREATE TABLE `inbound_email_cache_ts` (
  `id` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `ie_timestamp` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jjwg_address_cache`
--

CREATE TABLE `jjwg_address_cache` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `lat` float(10,8) DEFAULT NULL,
  `lng` float(11,8) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jjwg_address_cache_audit`
--

CREATE TABLE `jjwg_address_cache_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_jjwg_address_cache_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jjwg_areas`
--

CREATE TABLE `jjwg_areas` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `coordinates` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jjwg_areas_audit`
--

CREATE TABLE `jjwg_areas_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_jjwg_areas_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jjwg_maps`
--

CREATE TABLE `jjwg_maps` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `distance` float(9,4) DEFAULT NULL,
  `unit_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'mi',
  `module_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Accounts',
  `parent_type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jjwg_maps_audit`
--

CREATE TABLE `jjwg_maps_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_jjwg_maps_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jjwg_maps_jjwg_areas_c`
--

CREATE TABLE `jjwg_maps_jjwg_areas_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `jjwg_maps_5304wg_maps_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `jjwg_maps_41f2g_areas_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `jjwg_maps_jjwg_areas_alt` (`jjwg_maps_5304wg_maps_ida`,`jjwg_maps_41f2g_areas_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jjwg_maps_jjwg_markers_c`
--

CREATE TABLE `jjwg_maps_jjwg_markers_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `jjwg_maps_b229wg_maps_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `jjwg_maps_2e31markers_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `jjwg_maps_jjwg_markers_alt` (`jjwg_maps_b229wg_maps_ida`,`jjwg_maps_2e31markers_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jjwg_markers`
--

CREATE TABLE `jjwg_markers` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `jjwg_maps_lat` float(10,8) DEFAULT '0.00000000',
  `jjwg_maps_lng` float(11,8) DEFAULT '0.00000000',
  `marker_image` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'company',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jjwg_markers_audit`
--

CREATE TABLE `jjwg_markers_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_jjwg_markers_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `job_queue`
--

CREATE TABLE `job_queue` (
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `scheduler_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `execute_time` datetime DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `resolution` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_general_ci,
  `target` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_general_ci,
  `requeue` tinyint(1) DEFAULT '0',
  `retry_count` tinyint DEFAULT NULL,
  `failure_count` tinyint DEFAULT NULL,
  `job_delay` int DEFAULT NULL,
  `client` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `percent_complete` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_status_scheduler` (`status`,`scheduler_id`),
  KEY `idx_status_time` (`status`,`execute_time`,`date_entered`),
  KEY `idx_status_entered` (`status`,`date_entered`),
  KEY `idx_status_modified` (`status`,`date_modified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `leads`
--

CREATE TABLE `leads` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `salutation` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `first_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `last_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `title` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `photo` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `department` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `do_not_call` tinyint(1) DEFAULT '0',
  `phone_home` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_mobile` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_work` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_other` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_fax` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `lawful_basis` text COLLATE utf8mb4_general_ci,
  `date_reviewed` date DEFAULT NULL,
  `lawful_basis_source` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_address_street` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_address_city` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_address_state` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_address_postalcode` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_address_country` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `alt_address_street` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `alt_address_city` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `alt_address_state` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `alt_address_postalcode` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `alt_address_country` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `assistant` varchar(75) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `assistant_phone` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `converted` tinyint(1) DEFAULT '0',
  `refered_by` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `lead_source` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `lead_source_description` text COLLATE utf8mb4_general_ci,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status_description` text COLLATE utf8mb4_general_ci,
  `reports_to_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `account_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `account_description` text COLLATE utf8mb4_general_ci,
  `contact_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `account_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `opportunity_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `opportunity_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `opportunity_amount` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `campaign_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `birthdate` date DEFAULT NULL,
  `portal_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `portal_app` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `website` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_lead_acct_name_first` (`account_name`,`deleted`),
  KEY `idx_lead_last_first` (`last_name`,`first_name`,`deleted`),
  KEY `idx_lead_del_stat` (`last_name`,`status`,`deleted`,`first_name`),
  KEY `idx_lead_opp_del` (`opportunity_id`,`deleted`),
  KEY `idx_leads_acct_del` (`account_id`,`deleted`),
  KEY `idx_del_user` (`deleted`,`assigned_user_id`),
  KEY `idx_lead_assigned` (`assigned_user_id`),
  KEY `idx_lead_contact` (`contact_id`),
  KEY `idx_reports_to` (`reports_to_id`),
  KEY `idx_lead_phone_work` (`phone_work`),
  KEY `idx_leads_id_del` (`id`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `leads_audit`
--

CREATE TABLE `leads_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_leads_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `leads_cstm`
--

CREATE TABLE `leads_cstm` (
  `id_c` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `jjwg_maps_lng_c` float(11,8) DEFAULT '0.00000000',
  `jjwg_maps_lat_c` float(10,8) DEFAULT '0.00000000',
  `jjwg_maps_geocode_status_c` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `jjwg_maps_address_c` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id_c`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `linked_documents`
--

CREATE TABLE `linked_documents` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parent_type` varchar(25) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `document_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `document_revision_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_parent_document` (`parent_type`,`parent_id`,`document_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `meetings`
--

CREATE TABLE `meetings` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `location` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `password` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `join_url` varchar(200) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `host_url` varchar(400) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `displayed_url` varchar(400) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `creator` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `external_id` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `duration_hours` int DEFAULT NULL,
  `duration_minutes` int DEFAULT NULL,
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `parent_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Planned',
  `type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'Sugar',
  `parent_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reminder_time` int DEFAULT '-1',
  `email_reminder_time` int DEFAULT '-1',
  `email_reminder_sent` tinyint(1) DEFAULT '0',
  `outlook_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `sequence` int DEFAULT '0',
  `repeat_type` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `repeat_interval` int DEFAULT '1',
  `repeat_dow` varchar(7) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `repeat_until` date DEFAULT NULL,
  `repeat_count` int DEFAULT NULL,
  `repeat_parent_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `recurring_source` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `gsync_id` varchar(1024) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `gsync_lastsync` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_mtg_name` (`name`),
  KEY `idx_meet_par_del` (`parent_id`,`parent_type`,`deleted`),
  KEY `idx_meet_stat_del` (`assigned_user_id`,`status`,`deleted`),
  KEY `idx_meet_date_start` (`date_start`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `meetings_contacts`
--

CREATE TABLE `meetings_contacts` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `meeting_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contact_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `required` varchar(1) COLLATE utf8mb4_general_ci DEFAULT '1',
  `accept_status` varchar(25) COLLATE utf8mb4_general_ci DEFAULT 'none',
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_con_mtg_mtg` (`meeting_id`),
  KEY `idx_con_mtg_con` (`contact_id`),
  KEY `idx_meeting_contact` (`meeting_id`,`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `meetings_cstm`
--

CREATE TABLE `meetings_cstm` (
  `id_c` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `jjwg_maps_lng_c` float(11,8) DEFAULT '0.00000000',
  `jjwg_maps_lat_c` float(10,8) DEFAULT '0.00000000',
  `jjwg_maps_geocode_status_c` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `jjwg_maps_address_c` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id_c`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `meetings_leads`
--

CREATE TABLE `meetings_leads` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `meeting_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `lead_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `required` varchar(1) COLLATE utf8mb4_general_ci DEFAULT '1',
  `accept_status` varchar(25) COLLATE utf8mb4_general_ci DEFAULT 'none',
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_lead_meeting_meeting` (`meeting_id`),
  KEY `idx_lead_meeting_lead` (`lead_id`),
  KEY `idx_meeting_lead` (`meeting_id`,`lead_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `meetings_users`
--

CREATE TABLE `meetings_users` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `meeting_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `required` varchar(1) COLLATE utf8mb4_general_ci DEFAULT '1',
  `accept_status` varchar(25) COLLATE utf8mb4_general_ci DEFAULT 'none',
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_usr_mtg_mtg` (`meeting_id`),
  KEY `idx_usr_mtg_usr` (`user_id`),
  KEY `idx_meeting_users` (`meeting_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `notes`
--

CREATE TABLE `notes` (
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `file_mime_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `filename` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parent_type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contact_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `portal_flag` tinyint(1) DEFAULT NULL,
  `embed_flag` tinyint(1) DEFAULT '0',
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_note_name` (`name`),
  KEY `idx_notes_parent` (`parent_id`,`parent_type`),
  KEY `idx_note_contact` (`contact_id`),
  KEY `idx_notes_assigned_del` (`deleted`,`assigned_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `oauth2authcodes`
--

CREATE TABLE `oauth2authcodes` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `auth_code_is_revoked` tinyint(1) DEFAULT NULL,
  `auto_authorize` tinyint(1) DEFAULT NULL,
  `auth_code_expires` datetime DEFAULT NULL,
  `auth_code` varchar(4000) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `client` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `oauth2clients`
--

CREATE TABLE `oauth2clients` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `secret` varchar(4000) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `redirect_url` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_confidential` tinyint(1) DEFAULT '1',
  `allowed_grant_type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'password',
  `duration_value` int DEFAULT NULL,
  `duration_amount` int DEFAULT NULL,
  `duration_unit` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'Duration Unit',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `oauth2tokens`
--

CREATE TABLE `oauth2tokens` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `token_is_revoked` tinyint(1) DEFAULT NULL,
  `token_type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `access_token_expires` datetime DEFAULT NULL,
  `access_token` varchar(4000) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `refresh_token` varchar(4000) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `refresh_token_expires` datetime DEFAULT NULL,
  `grant_type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `state` varchar(1024) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `client` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `oauth_consumer`
--

CREATE TABLE `oauth_consumer` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `c_key` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `c_secret` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ckey` (`c_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `oauth_nonce`
--

CREATE TABLE `oauth_nonce` (
  `conskey` varchar(32) COLLATE utf8mb4_general_ci NOT NULL,
  `nonce` varchar(32) COLLATE utf8mb4_general_ci NOT NULL,
  `nonce_ts` bigint DEFAULT NULL,
  PRIMARY KEY (`conskey`,`nonce`),
  KEY `oauth_nonce_keyts` (`conskey`,`nonce_ts`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `oauth_tokens`
--

CREATE TABLE `oauth_tokens` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `secret` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `tstate` varchar(1) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `consumer` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `token_ts` bigint DEFAULT NULL,
  `verify` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `callback_url` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`,`deleted`),
  KEY `oauth_state_ts` (`tstate`,`token_ts`),
  KEY `constoken_key` (`consumer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `opportunities`
--

CREATE TABLE `opportunities` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `opportunity_type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `campaign_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `lead_source` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `amount_usdollar` double DEFAULT NULL,
  `currency_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_closed` date DEFAULT NULL,
  `next_step` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `sales_stage` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `probability` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_opp_name` (`name`),
  KEY `idx_opp_assigned` (`assigned_user_id`),
  KEY `idx_opp_id_deleted` (`id`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `opportunities_audit`
--

CREATE TABLE `opportunities_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_opportunities_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `opportunities_contacts`
--

CREATE TABLE `opportunities_contacts` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `contact_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `opportunity_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contact_role` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_con_opp_con` (`contact_id`),
  KEY `idx_con_opp_opp` (`opportunity_id`),
  KEY `idx_opportunities_contacts` (`opportunity_id`,`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `opportunities_cstm`
--

CREATE TABLE `opportunities_cstm` (
  `id_c` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `jjwg_maps_lng_c` float(11,8) DEFAULT '0.00000000',
  `jjwg_maps_lat_c` float(10,8) DEFAULT '0.00000000',
  `jjwg_maps_geocode_status_c` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `jjwg_maps_address_c` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id_c`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `outbound_email`
--

CREATE TABLE `outbound_email` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `type` varchar(15) COLLATE utf8mb4_general_ci DEFAULT 'user',
  `user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `smtp_from_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `smtp_from_addr` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reply_to_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reply_to_addr` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `signature` text COLLATE utf8mb4_general_ci,
  `mail_sendtype` varchar(8) COLLATE utf8mb4_general_ci DEFAULT 'SMTP',
  `mail_smtptype` varchar(20) COLLATE utf8mb4_general_ci DEFAULT 'other',
  `mail_smtpserver` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `mail_smtpport` varchar(5) COLLATE utf8mb4_general_ci DEFAULT '25',
  `mail_smtpuser` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `mail_smtppass` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `mail_smtpauth_req` tinyint(1) DEFAULT '0',
  `mail_smtpssl` varchar(1) COLLATE utf8mb4_general_ci DEFAULT '0',
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `auth_type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'no_auth',
  `external_oauth_connection_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `outbound_email`
--

INSERT INTO `outbound_email` VALUES
('ca23167b-ed70-4c49-afda-78abc56c4960', 'system', 'system', '1', NULL, NULL, NULL, NULL, NULL, 'SMTP', 'other', '', '25', '', '', 1, '0', NULL, NULL, NULL, NULL, 0, NULL, 'no_auth', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `outbound_email_audit`
--

CREATE TABLE `outbound_email_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_outbound_email_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `project`
--

CREATE TABLE `project` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `estimated_start_date` date DEFAULT NULL,
  `estimated_end_date` date DEFAULT NULL,
  `status` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `priority` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `override_business_hours` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `projects_accounts`
--

CREATE TABLE `projects_accounts` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `account_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `project_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_proj_acct_proj` (`project_id`),
  KEY `idx_proj_acct_acct` (`account_id`),
  KEY `projects_accounts_alt` (`project_id`,`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `projects_bugs`
--

CREATE TABLE `projects_bugs` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `bug_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `project_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_proj_bug_proj` (`project_id`),
  KEY `idx_proj_bug_bug` (`bug_id`),
  KEY `projects_bugs_alt` (`project_id`,`bug_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `projects_cases`
--

CREATE TABLE `projects_cases` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `case_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `project_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_proj_case_proj` (`project_id`),
  KEY `idx_proj_case_case` (`case_id`),
  KEY `projects_cases_alt` (`project_id`,`case_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `projects_contacts`
--

CREATE TABLE `projects_contacts` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `contact_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `project_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_proj_con_proj` (`project_id`),
  KEY `idx_proj_con_con` (`contact_id`),
  KEY `projects_contacts_alt` (`project_id`,`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `projects_opportunities`
--

CREATE TABLE `projects_opportunities` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `opportunity_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `project_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_proj_opp_proj` (`project_id`),
  KEY `idx_proj_opp_opp` (`opportunity_id`),
  KEY `projects_opportunities_alt` (`project_id`,`opportunity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `projects_products`
--

CREATE TABLE `projects_products` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `product_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `project_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_proj_prod_project` (`project_id`),
  KEY `idx_proj_prod_product` (`product_id`),
  KEY `projects_products_alt` (`project_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `project_contacts_1_c`
--

CREATE TABLE `project_contacts_1_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `project_contacts_1project_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `project_contacts_1contacts_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_contacts_1_alt` (`project_contacts_1project_ida`,`project_contacts_1contacts_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `project_cstm`
--

CREATE TABLE `project_cstm` (
  `id_c` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `jjwg_maps_lng_c` float(11,8) DEFAULT '0.00000000',
  `jjwg_maps_lat_c` float(10,8) DEFAULT '0.00000000',
  `jjwg_maps_geocode_status_c` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `jjwg_maps_address_c` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id_c`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `project_task`
--

CREATE TABLE `project_task` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `project_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `project_task_id` int DEFAULT NULL,
  `name` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `relationship_type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `predecessors` text COLLATE utf8mb4_general_ci,
  `date_start` date DEFAULT NULL,
  `time_start` int DEFAULT NULL,
  `time_finish` int DEFAULT NULL,
  `date_finish` date DEFAULT NULL,
  `duration` int DEFAULT NULL,
  `duration_unit` text COLLATE utf8mb4_general_ci,
  `actual_duration` int DEFAULT NULL,
  `percent_complete` int DEFAULT NULL,
  `date_due` date DEFAULT NULL,
  `time_due` time DEFAULT NULL,
  `parent_task_id` int DEFAULT NULL,
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `priority` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `milestone_flag` tinyint(1) DEFAULT NULL,
  `order_number` int DEFAULT '1',
  `task_number` int DEFAULT NULL,
  `estimated_effort` int DEFAULT NULL,
  `actual_effort` int DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `utilization` int DEFAULT '100',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `project_task_audit`
--

CREATE TABLE `project_task_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_project_task_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `project_users_1_c`
--

CREATE TABLE `project_users_1_c` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `project_users_1project_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `project_users_1users_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_users_1_alt` (`project_users_1project_ida`,`project_users_1users_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `prospects`
--

CREATE TABLE `prospects` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `salutation` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `first_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `last_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `title` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `photo` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `department` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `do_not_call` tinyint(1) DEFAULT '0',
  `phone_home` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_mobile` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_work` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_other` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_fax` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `lawful_basis` text COLLATE utf8mb4_general_ci,
  `date_reviewed` date DEFAULT NULL,
  `lawful_basis_source` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_address_street` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_address_city` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_address_state` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_address_postalcode` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_address_country` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `alt_address_street` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `alt_address_city` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `alt_address_state` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `alt_address_postalcode` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `alt_address_country` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `assistant` varchar(75) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `assistant_phone` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `tracker_key` int NOT NULL AUTO_INCREMENT,
  `birthdate` date DEFAULT NULL,
  `lead_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `account_name` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `campaign_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `prospect_auto_tracker_key` (`tracker_key`),
  KEY `idx_prospects_last_first` (`last_name`,`first_name`,`deleted`),
  KEY `idx_prospecs_del_last` (`last_name`,`deleted`),
  KEY `idx_prospects_id_del` (`id`,`deleted`),
  KEY `idx_prospects_assigned` (`assigned_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `prospects_cstm`
--

CREATE TABLE `prospects_cstm` (
  `id_c` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `jjwg_maps_lng_c` float(11,8) DEFAULT '0.00000000',
  `jjwg_maps_lat_c` float(10,8) DEFAULT '0.00000000',
  `jjwg_maps_geocode_status_c` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `jjwg_maps_address_c` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id_c`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `prospect_lists`
--

CREATE TABLE `prospect_lists` (
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `list_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `domain_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_prospect_list_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `prospect_lists_prospects`
--

CREATE TABLE `prospect_lists_prospects` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `prospect_list_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `related_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `related_type` varchar(25) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_plp_pro_id` (`prospect_list_id`,`deleted`),
  KEY `idx_plp_rel_id` (`related_id`,`related_type`,`prospect_list_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `prospect_list_campaigns`
--

CREATE TABLE `prospect_list_campaigns` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `prospect_list_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `campaign_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_pro_id` (`prospect_list_id`),
  KEY `idx_cam_id` (`campaign_id`),
  KEY `idx_prospect_list_campaigns` (`prospect_list_id`,`campaign_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `relationships`
--

CREATE TABLE `relationships` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `relationship_name` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `lhs_module` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `lhs_table` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `lhs_key` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `rhs_module` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `rhs_table` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `rhs_key` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `join_table` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `join_key_lhs` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `join_key_rhs` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `relationship_type` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `relationship_role_column` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `relationship_role_column_value` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reverse` tinyint(1) DEFAULT '0',
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_rel_name` (`relationship_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `relationships`
--

INSERT INTO `relationships` VALUES
('0026be24-a3ff-446d-a292-9567ff817c70', 'aos_products_quotes_assigned_user', 'Users', 'users', 'id', 'AOS_Products_Quotes', 'aos_products_quotes', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('00d0a9cd-f9c3-40c1-b20c-48b6544b2b29', 'aor_charts_aor_reports', 'AOR_Reports', 'aor_reports', 'id', 'AOR_Charts', 'aor_charts', 'aor_report_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('00e6a8ff-6e12-4b0f-80ec-3194c5eb5417', 'bugs_modified_user', 'Users', 'users', 'id', 'Bugs', 'bugs', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('01691577-f496-436f-88b4-57da3b9a7354', 'aor_reports_aor_conditions', 'AOR_Reports', 'aor_reports', 'id', 'AOR_Conditions', 'aor_conditions', 'aor_report_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('026350ee-8d7f-4a82-a6fc-7564bc3a6805', 'securitygroups_tasks', 'SecurityGroups', 'securitygroups', 'id', 'Tasks', 'tasks', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Tasks', 0, 0),
('03ef0f44-46fc-4898-9e73-93bb9a827479', 'sugarfeed_assigned_user', 'Users', 'users', 'id', 'SugarFeed', 'sugarfeed', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('04469d36-b1fc-4b78-8e22-7a44d72d4d0a', 'inbound_emails_external_oauth_connections', 'ExternalOAuthConnection', 'external_oauth_connections', 'id', 'InboundEmail', 'inbound_email', 'external_oauth_connection_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('053aa4e6-3f16-48e0-84d1-b20f2360d376', 'alerts_created_by', 'Users', 'users', 'id', 'Alerts', 'alerts', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('06a795ca-0876-4e53-9cec-684d40db37b1', 'tasks_assigned_user', 'Users', 'users', 'id', 'Tasks', 'tasks', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('06f0e0f3-cbf0-49ae-af54-04f29b9c5caa', 'documents_contacts', 'Documents', 'documents', 'id', 'Contacts', 'contacts', 'id', 'documents_contacts', 'document_id', 'contact_id', 'many-to-many', NULL, NULL, 0, 0),
('07283335-d423-4d69-a59e-a0129bd2a09e', 'campaignlog_sent_emails', 'CampaignLog', 'campaign_log', 'related_id', 'Emails', 'emails', 'id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('07b9b542-025a-40d5-bc45-4d9a8a3934dc', 'email_marketing_prospect_lists', 'EmailMarketing', 'email_marketing', 'id', 'ProspectLists', 'prospect_lists', 'id', 'email_marketing_prospect_lists', 'email_marketing_id', 'prospect_list_id', 'many-to-many', NULL, NULL, 0, 0),
('085fc4cb-4739-47da-ba19-c55ef9371726', 'aor_charts_modified_user', 'Users', 'users', 'id', 'AOR_Charts', 'aor_charts', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('08d8104b-0386-4334-b701-c431ded5ada7', 'case_meetings', 'Cases', 'cases', 'id', 'Meetings', 'meetings', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Cases', 0, 0),
('0a0340c6-2ffb-4e35-8fc5-3cc77805ea06', 'aos_quotes_project', 'AOS_Quotes', 'aos_quotes', 'id', 'Project', 'project', 'id', 'aos_quotes_project_c', 'aos_quotes1112_quotes_ida', 'aos_quotes7207project_idb', 'many-to-many', NULL, NULL, 0, 0),
('0a2f90f6-cfb4-4ada-8cb8-3a02bd88c60c', 'aop_case_updates_notes', 'AOP_Case_Updates', 'aop_case_updates', 'id', 'Notes', 'notes', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'AOP_Case_Updates', 0, 0),
('0a4a737e-d3b4-43a6-817b-d84bed70a28c', 'aor_fields_created_by', 'Users', 'users', 'id', 'AOR_Fields', 'aor_fields', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('0c654b59-c11d-4842-9167-1e5e7dc6279f', 'contact_direct_reports', 'Contacts', 'contacts', 'id', 'Contacts', 'contacts', 'reports_to_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('0ced30bc-210e-40b1-a881-6d2c11dfc688', 'aop_case_updates_modified_user', 'Users', 'users', 'id', 'AOP_Case_Updates', 'aop_case_updates', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('0e4a0bf8-fada-4416-80ac-7fdf769807f6', 'accounts_opportunities', 'Accounts', 'accounts', 'id', 'Opportunities', 'opportunities', 'id', 'accounts_opportunities', 'account_id', 'opportunity_id', 'many-to-many', NULL, NULL, 0, 0),
('0e51f4d5-9e37-455f-8561-9a5467954e5c', 'project_tasks_notes', 'ProjectTask', 'project_task', 'id', 'Notes', 'notes', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'ProjectTask', 0, 0),
('0e6ac66b-45ac-4d91-a30a-ab1d3de91161', 'jjwg_areas_assigned_user', 'Users', 'users', 'id', 'jjwg_Areas', 'jjwg_areas', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('0e7690c9-add6-43db-9821-672b3102dc7d', 'outbound_email_assigned_user', 'Users', 'users', 'id', 'OutboundEmailAccounts', 'outbound_email', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('0ec331b2-5e5d-457f-9501-8918c8a7e79f', 'favorites_modified_user', 'Users', 'users', 'id', 'Favorites', 'favorites', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('10978ea2-e188-43cb-8985-8b22fb6545c3', 'securitygroups_jjwg_markers', 'SecurityGroups', 'securitygroups', 'id', 'jjwg_Markers', 'jjwg_markers', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'jjwg_Markers', 0, 0),
('11df20a0-b890-4c9c-b43d-33608d7fead2', 'account_aos_contracts', 'Accounts', 'accounts', 'id', 'AOS_Contracts', 'aos_contracts', 'contract_account_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('1220d5c3-eb40-44e5-88c1-40b92667b708', 'projects_project_tasks', 'Project', 'project', 'id', 'ProjectTask', 'project_task', 'project_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('136d5a2d-ca93-4669-b3f9-ad8515b6467a', 'fp_event_locations_created_by', 'Users', 'users', 'id', 'FP_Event_Locations', 'fp_event_locations', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('13903b0c-a0f3-4e5c-b2a3-4b3d3d466b8b', 'notes_assigned_user', 'Users', 'users', 'id', 'Notes', 'notes', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('143cc825-4cf8-4692-ac49-d30ede2c76e7', 'am_tasktemplates_created_by', 'Users', 'users', 'id', 'AM_TaskTemplates', 'am_tasktemplates', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('145440e1-38df-44d1-af34-6ea35ca35225', 'surveyquestions_surveyquestionoptions', 'SurveyQuestions', 'surveyquestions', 'id', 'SurveyQuestionOptions', 'surveyquestionoptions', 'survey_question_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('149f9540-0534-4855-8e10-f1d0dd097841', 'calendaraccount_created_by', 'Users', 'users', 'id', 'CalendarAccount', 'calendar_accounts', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('14c6f716-43bb-486d-b8ef-5c57306903e3', 'jjwg_Maps_prospects', 'jjwg_Maps', 'jjwg_Maps', 'parent_id', 'Prospects', 'prospects', 'id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Prospects', 0, 0),
('15027f4e-bc27-4ed1-8ff8-cbc022266095', 'meetings_contacts', 'Meetings', 'meetings', 'id', 'Contacts', 'contacts', 'id', 'meetings_contacts', 'meeting_id', 'contact_id', 'many-to-many', NULL, NULL, 0, 0),
('151e4665-e22f-4330-94a6-29b217c09305', 'jjwg_markers_created_by', 'Users', 'users', 'id', 'jjwg_Markers', 'jjwg_markers', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('15dedc32-2089-48d6-b2ef-d5106f2ac149', 'contact_tasks_parent', 'Contacts', 'contacts', 'id', 'Tasks', 'tasks', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Contacts', 0, 0),
('167e8df8-bb09-4d47-8f9f-831a5684280e', 'contact_aos_quotes', 'Contacts', 'contacts', 'id', 'AOS_Quotes', 'aos_quotes', 'billing_contact_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('1726b5f6-4981-49ef-a279-7db744283563', 'externaloauthprovider_modified_user', 'Users', 'users', 'id', 'ExternalOAuthProvider', 'external_oauth_providers', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('17bdbb3f-9bf4-47bf-850c-d4bb6f19517d', 'meetings_modified_user', 'Users', 'users', 'id', 'Meetings', 'meetings', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('17be4986-4394-4829-82d5-5e14c14bb49a', 'calls_reschedule_modified_user', 'Users', 'users', 'id', 'Calls_Reschedule', 'calls_reschedule', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('17c38f86-928a-475b-b038-ac2b583e6c97', 'external_oauth_connections_external_oauth_providers', 'ExternalOAuthProvider', 'external_oauth_providers', 'id', 'ExternalOAuthConnection', 'external_oauth_connections', 'external_oauth_provider_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('1814a011-8483-4d00-ab75-d97424c3463f', 'prospects_modified_user', 'Users', 'users', 'id', 'Prospects', 'prospects', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('18524fd9-baa3-492a-aaa2-9b4048b008cb', 'aos_product_quotes_aos_products', 'AOS_Products', 'aos_products', 'id', 'AOS_Products_Quotes', 'aos_products_quotes', 'product_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('18f89979-71b0-4c46-ad58-ba8c4af7ae65', 'emails_assigned_user', 'Users', 'users', 'id', 'Emails', 'emails', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('197dd789-37f9-4a81-ae10-8ecf5805c6f6', 'lead_emails', 'Leads', 'leads', 'id', 'Emails', 'emails', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Leads', 0, 0),
('19cf872e-811e-4856-9c0e-66338ce8461f', 'securitygroups_documents', 'SecurityGroups', 'securitygroups', 'id', 'Documents', 'documents', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Documents', 0, 0),
('1a0ccac3-a3a1-4749-a669-2def963ea623', 'inbound_emails_distribution_user', 'Users', 'users', 'id', 'InboundEmail', 'inbound_email', 'distribution_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('1b7afd0f-c5e5-4478-a8e3-5cef8c08ef13', 'oauth2authcodes_modified_user', 'Users', 'users', 'id', 'OAuth2AuthCodes', 'oauth2authcodes', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('1c3e4555-8131-4f32-a801-c4429f59f774', 'aok_knowledgebase_assigned_user', 'Users', 'users', 'id', 'AOK_KnowledgeBase', 'aok_knowledgebase', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('1c957420-8901-4be6-a843-4097ea6c6e75', 'contacts_modified_user', 'Users', 'users', 'id', 'Contacts', 'contacts', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('1dd750b1-08e6-4a49-b2a5-344bcf43cf26', 'aos_quotes_aos_line_item_groups', 'AOS_Quotes', 'aos_quotes', 'id', 'AOS_Line_Item_Groups', 'aos_line_item_groups', 'parent_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('1ecf6a06-1cda-4ed7-b215-fdf992160dce', 'surveyquestions_modified_user', 'Users', 'users', 'id', 'SurveyQuestions', 'surveyquestions', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('1ef4b263-d821-4644-a91d-98ac6b5a3585', 'jjwg_Maps_leads', 'jjwg_Maps', 'jjwg_Maps', 'parent_id', 'Leads', 'leads', 'id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Leads', 0, 0),
('1f181dcd-2c86-4ddf-bee2-4943d9352c28', 'jjwg_address_cache_assigned_user', 'Users', 'users', 'id', 'jjwg_Address_Cache', 'jjwg_address_cache', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('1f31dee8-9a1d-4d7f-adb3-67c581a594d8', 'securitygroups_aos_pdf_templates', 'SecurityGroups', 'securitygroups', 'id', 'AOS_PDF_Templates', 'aos_pdf_templates', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'AOS_PDF_Templates', 0, 0),
('1f841c8c-a528-4f87-b726-b535be421643', 'campaign_assigned_user', 'Users', 'users', 'id', 'Campaigns', 'campaigns', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('1fc40591-5357-420d-abea-1fa28f69d7ba', 'bug_calls', 'Bugs', 'bugs', 'id', 'Calls', 'calls', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Bugs', 0, 0),
('213e71cc-1f51-4a3f-a3f7-32eca71cae80', 'cases_created_by', 'Users', 'users', 'id', 'Cases', 'cases', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('21cce0ff-dfe2-43ff-8aaf-a78ca429955a', 'aos_invoices_assigned_user', 'Users', 'users', 'id', 'AOS_Invoices', 'aos_invoices', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('22a0322a-b79c-49eb-b160-be0a2f507d63', 'schedulers_created_by_rel', 'Users', 'users', 'id', 'Schedulers', 'schedulers', 'created_by', NULL, NULL, NULL, 'one-to-one', NULL, NULL, 0, 0),
('23f32c0a-2e65-4a2b-92b7-d803dac24b0e', 'securitygroups_accounts', 'SecurityGroups', 'securitygroups', 'id', 'Accounts', 'accounts', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Accounts', 0, 0),
('245eead7-4d43-4e59-ac84-3023ea021f57', 'unified_search', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0),
('2491773e-5a9e-4c0a-9a34-214132db5d72', 'reminders_invitees_assigned_user', 'Users', 'users', 'id', 'Reminders_Invitees', 'reminders_invitees', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('25110ba6-2ffb-4d02-b31f-9bb4ded3b2af', 'securitygroups_aok_knowledgebase', 'SecurityGroups', 'securitygroups', 'id', 'AOK_KnowledgeBase', 'aok_knowledgebase', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'AOK_KnowledgeBase', 0, 0),
('252753ea-4547-40ca-b249-afe6d9e3bc1a', 'contacts_users', 'Contacts', 'contacts', 'id', 'Users', 'users', 'id', 'contacts_users', 'contact_id', 'user_id', 'many-to-many', NULL, NULL, 0, 0),
('252ae24d-5e41-4ba5-8c83-bf72cf4312c9', 'project_users_1', 'Project', 'project', 'id', 'Users', 'users', 'id', 'project_users_1_c', 'project_users_1project_ida', 'project_users_1users_idb', 'many-to-many', NULL, NULL, 0, 0),
('2550f656-d61d-4c26-a2ec-a388748d9f3e', 'aok_knowledgebase_created_by', 'Users', 'users', 'id', 'AOK_KnowledgeBase', 'aok_knowledgebase', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('2556376e-a610-4bb1-8d59-10a107ba9073', 'projects_opportunities', 'Project', 'project', 'id', 'Opportunities', 'opportunities', 'id', 'projects_opportunities', 'project_id', 'opportunity_id', 'many-to-many', NULL, NULL, 0, 0),
('2573af3b-ee74-460b-a3bf-7389c44af45c', 'accounts_email_addresses', 'Accounts', 'accounts', 'id', 'EmailAddresses', 'email_addresses', 'id', 'email_addr_bean_rel', 'bean_id', 'email_address_id', 'many-to-many', 'bean_module', 'Accounts', 0, 0),
('2581bfee-f19e-47e9-9af7-3b202d2f5c22', 'oauth2clients_created_by', 'Users', 'users', 'id', 'OAuth2Clients', 'oauth2clients', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('25c0bcd5-5e57-4a39-bb79-e5466e2c9a9f', 'contact_aos_invoices', 'Contacts', 'contacts', 'id', 'AOS_Invoices', 'aos_invoices', 'billing_contact_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('267360d3-38f2-4e6a-8afa-3c338fc87ef9', 'eapm_assigned_user', 'Users', 'users', 'id', 'EAPM', 'eapm', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('267c3ef1-1d1c-4cea-a43d-128829caf5a1', 'securitygroups_created_by', 'Users', 'users', 'id', 'SecurityGroups', 'securitygroups', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('26abb7bd-dfb7-4dfc-ac55-6c1380499a3c', 'cases_aop_case_updates', 'Cases', 'cases', 'id', 'AOP_Case_Updates', 'aop_case_updates', 'case_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('271f3285-d28b-4b3c-bb77-18fab4c65e26', 'project_tasks_created_by', 'Users', 'users', 'id', 'ProjectTask', 'project_task', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('27c3247d-824b-4913-85f2-11950931ff20', 'aos_quotes_aos_product_quotes', 'AOS_Quotes', 'aos_quotes', 'id', 'AOS_Products_Quotes', 'aos_products_quotes', 'parent_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('283e4253-4e68-4fbf-8b94-ff39ffcf433c', 'aod_indexevent_modified_user', 'Users', 'users', 'id', 'AOD_IndexEvent', 'aod_indexevent', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('28a25bf4-b651-4fb6-a72c-b28c9d5eec05', 'aos_product_categories_assigned_user', 'Users', 'users', 'id', 'AOS_Product_Categories', 'aos_product_categories', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('2966f181-8baf-41a8-8936-e2155ee93589', 'jjwg_maps_created_by', 'Users', 'users', 'id', 'jjwg_Maps', 'jjwg_maps', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('2b1661ee-5710-46d7-9783-047dedd7367b', 'externaloauthconnection_modified_user', 'Users', 'users', 'id', 'ExternalOAuthConnection', 'external_oauth_connections', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('2b268390-b78f-4dd1-ad8d-572e3ec31899', 'surveys_assigned_user', 'Users', 'users', 'id', 'Surveys', 'surveys', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('2bca84c6-730d-44c4-a6f9-b2bd35950a3e', 'aok_knowledgebase_categories', 'AOK_KnowledgeBase', 'aok_knowledgebase', 'id', 'AOK_Knowledge_Base_Categories', 'aok_knowledge_base_categories', 'id', 'aok_knowledgebase_categories', 'aok_knowledgebase_id', 'aok_knowledge_base_categories_id', 'many-to-many', NULL, NULL, 0, 0),
('2c7c7a25-aa1b-44f1-b9d1-7f8cb48c6858', 'aos_pdf_templates_modified_user', 'Users', 'users', 'id', 'AOS_PDF_Templates', 'aos_pdf_templates', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('2cd9e463-a74f-4ee6-a510-62469112de75', 'email_template_email_marketings', 'EmailTemplates', 'email_templates', 'id', 'EmailMarketing', 'email_marketing', 'template_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('2da7ee9f-4e0f-40d5-ba56-ee7c5c83a3aa', 'calls_notes', 'Calls', 'calls', 'id', 'Notes', 'notes', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Calls', 0, 0),
('2daa0dcc-8990-4088-ad6c-f9e13e1124f9', 'opportunities_created_by', 'Users', 'users', 'id', 'Opportunities', 'opportunities', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('2dc3c880-4725-4848-a8ed-b0696a38883c', 'cases_aop_case_events', 'Cases', 'cases', 'id', 'AOP_Case_Events', 'aop_case_events', 'case_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('2ee2b892-423a-45a3-8e32-3031cd5b7ef6', 'campaignlog_created_opportunities', 'CampaignLog', 'campaign_log', 'related_id', 'Opportunities', 'opportunities', 'id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('2f302ec2-1d20-4417-b3fe-6a920474f3de', 'contacts_assigned_user', 'Users', 'users', 'id', 'Contacts', 'contacts', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('2fd8ad6f-6844-491c-996e-a790ddec10f4', 'aos_products_modified_user', 'Users', 'users', 'id', 'AOS_Products', 'aos_products', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('31393389-7f37-4725-82a5-e50276d62f4f', 'aos_quotes_assigned_user', 'Users', 'users', 'id', 'AOS_Quotes', 'aos_quotes', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('3140ee4b-e2bd-4b4e-96f8-22d66e05519b', 'aos_products_created_by', 'Users', 'users', 'id', 'AOS_Products', 'aos_products', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('32abe6ed-5843-41e9-a6ad-c10e3159b2b6', 'jjwg_maps_jjwg_areas', 'jjwg_Maps', 'jjwg_maps', 'id', 'jjwg_Areas', 'jjwg_areas', 'id', 'jjwg_maps_jjwg_areas_c', 'jjwg_maps_5304wg_maps_ida', 'jjwg_maps_41f2g_areas_idb', 'many-to-many', NULL, NULL, 0, 0),
('34c6cf60-61fb-4818-87c0-900eb7c8c120', 'fp_events_modified_user', 'Users', 'users', 'id', 'FP_events', 'fp_events', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('350f7371-f11f-4f7c-bda0-8d07e1ca56b8', 'aos_product_categories_modified_user', 'Users', 'users', 'id', 'AOS_Product_Categories', 'aos_product_categories', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('35864d22-cb66-42c4-9cd8-90c16529ec5c', 'oauth2clients_oauth2tokens', 'OAuth2Clients', 'oauth2clients', 'id', 'OAuth2Tokens', 'oauth2tokens', 'client', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('363804d7-a590-4374-a0a5-a7edbc77aa1a', 'securitygroups_aos_product_categories', 'SecurityGroups', 'securitygroups', 'id', 'AOS_Product_Categories', 'aos_product_categories', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'AOS_Product_Categories', 0, 0),
('3805c1d3-19ac-418b-97df-ec01fe473bae', 'campaignlog_lead', 'CampaignLog', 'campaign_log', 'related_id', 'Leads', 'leads', 'id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('38357ef5-84bd-4481-a388-b40dd69b57b8', 'notes_created_by', 'Users', 'users', 'id', 'Notes', 'notes', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('38519ea3-4b1b-4846-a96a-67cf59c5c4b1', 'calls_users', 'Calls', 'calls', 'id', 'Users', 'users', 'id', 'calls_users', 'call_id', 'user_id', 'many-to-many', NULL, NULL, 0, 0),
('38de145e-e50d-4c5d-8331-3b58c90c1f76', 'prospect_list_users', 'ProspectLists', 'prospect_lists', 'id', 'Users', 'users', 'id', 'prospect_lists_prospects', 'prospect_list_id', 'related_id', 'many-to-many', 'related_type', 'Users', 0, 0),
('3a862f01-253f-48c4-9134-719b79ab31d7', 'account_leads', 'Accounts', 'accounts', 'id', 'Leads', 'leads', 'account_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('3ac730e4-e6dc-4583-aea3-b970fe8814f0', 'emails_contacts_rel', 'Emails', 'emails', 'id', 'Contacts', 'contacts', 'id', 'emails_beans', 'email_id', 'bean_id', 'many-to-many', 'bean_module', 'Contacts', 0, 0),
('3ac7b420-aeca-4188-bee7-94f9d7228ecf', 'aos_line_item_groups_assigned_user', 'Users', 'users', 'id', 'AOS_Line_Item_Groups', 'aos_line_item_groups', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('3b0e4107-17f0-4233-bd57-74fdeaa08588', 'securitygroups_spots', 'SecurityGroups', 'securitygroups', 'id', 'Spots', 'spots', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Spots', 0, 0),
('3c1c2f32-9b25-4db9-9972-c0ff8531462f', 'securitygroups_surveyquestionresponses', 'SecurityGroups', 'securitygroups', 'id', 'SurveyQuestionResponses', 'surveyquestionresponses', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'SurveyQuestionResponses', 0, 0),
('3ce5bcdd-e60d-49e2-a42b-ec665e567382', 'templatesectionline_modified_user', 'Users', 'users', 'id', 'TemplateSectionLine', 'templatesectionline', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('3d545646-c005-46cb-8b13-8ea7d525c8e3', 'aod_index_modified_user', 'Users', 'users', 'id', 'AOD_Index', 'aod_index', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('3d9131e6-036d-439d-aa65-79acfe4718d0', 'project_tasks_meetings', 'ProjectTask', 'project_task', 'id', 'Meetings', 'meetings', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'ProjectTask', 0, 0),
('3ea6d4dc-6a2d-4315-b540-c08dad856467', 'securitygroups_emailtemplates', 'SecurityGroups', 'securitygroups', 'id', 'EmailTemplates', 'email_templates', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'EmailTemplates', 0, 0),
('3ed1186d-2dc8-4835-8419-bb752578f65b', 'oauth2authcodes_created_by', 'Users', 'users', 'id', 'OAuth2AuthCodes', 'oauth2authcodes', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('3f96ec7b-fc8d-4d0e-8a60-c952fb199969', 'sugarfeed_created_by', 'Users', 'users', 'id', 'SugarFeed', 'sugarfeed', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('3fde3fb4-ae00-43f1-ab66-10f029e08f1a', 'aos_contracts_assigned_user', 'Users', 'users', 'id', 'AOS_Contracts', 'aos_contracts', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('40ddfd0f-861a-43b4-a6fc-757fd943c129', 'prospect_meetings', 'Prospects', 'prospects', 'id', 'Meetings', 'meetings', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Prospects', 0, 0),
('410c8ce2-3e04-4b3c-a946-5dbd6d30b51d', 'oauth2tokens_assigned_user', 'Users', 'users', 'id', 'OAuth2Tokens', 'oauth2tokens', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('41258e87-91b5-4e83-9d32-c3a78d1e8c3f', 'projects_accounts', 'Project', 'project', 'id', 'Accounts', 'accounts', 'id', 'projects_accounts', 'project_id', 'account_id', 'many-to-many', NULL, NULL, 0, 0),
('4139bb93-7979-407f-b2f7-cdfaeabc0e3b', 'lead_notes', 'Leads', 'leads', 'id', 'Notes', 'notes', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Leads', 0, 0),
('42974c48-7fdf-43c4-896e-fa3e65675c69', 'eapm_created_by', 'Users', 'users', 'id', 'EAPM', 'eapm', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('42c97f07-f3e2-45b1-ba8b-2fa526cc8cc8', 'oauthkeys_modified_user', 'Users', 'users', 'id', 'OAuthKeys', 'oauth_consumer', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('430c077d-f41f-4394-a146-b1cfa8ccdc98', 'securitygroups_surveyresponses', 'SecurityGroups', 'securitygroups', 'id', 'SurveyResponses', 'surveyresponses', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'SurveyResponses', 0, 0),
('4343ac50-97bc-41ad-ba38-07afbc7b321c', 'aos_contracts_created_by', 'Users', 'users', 'id', 'AOS_Contracts', 'aos_contracts', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('438457ca-4664-4b94-aa4c-342267626b7b', 'surveyquestions_assigned_user', 'Users', 'users', 'id', 'SurveyQuestions', 'surveyquestions', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('45b97149-4ae6-4c1d-a679-440ad5f5083b', 'securitygroups_modified_user', 'Users', 'users', 'id', 'SecurityGroups', 'securitygroups', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('4616e087-f54f-498d-9647-c4fa7acf5c14', 'documents_bugs', 'Documents', 'documents', 'id', 'Bugs', 'bugs', 'id', 'documents_bugs', 'document_id', 'bug_id', 'many-to-many', NULL, NULL, 0, 0),
('47a7c05d-19d0-4988-b1a2-83137e11d9e2', 'inbound_email_created_by', 'Users', 'users', 'id', 'InboundEmail', 'inbound_email', 'created_by', NULL, NULL, NULL, 'one-to-one', NULL, NULL, 0, 0),
('47efa487-8c5b-43a2-930c-7c728e2f753e', 'securitygroups_acl_roles', 'SecurityGroups', 'securitygroups', 'id', 'ACLRoles', 'acl_roles', 'id', 'securitygroups_acl_roles', 'securitygroup_id', 'role_id', 'many-to-many', NULL, NULL, 0, 0),
('489bda82-8b91-4e12-a5bd-fc69cc7b21a4', 'surveys_surveyquestions', 'Surveys', 'surveys', 'id', 'SurveyQuestions', 'surveyquestions', 'survey_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('48e84c36-230e-4c8c-8acd-868c936cd7ed', 'users_users_password_link', 'Users', 'users', 'id', NULL, 'users_signatures', 'user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('4943338c-7428-445c-8446-b2b2fe69d1f4', 'securitygroups_surveys', 'SecurityGroups', 'securitygroups', 'id', 'Surveys', 'surveys', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Surveys', 0, 0),
('494360b7-d8a2-4763-8c15-085b200968a5', 'reminders_invitees_created_by', 'Users', 'users', 'id', 'Reminders_Invitees', 'reminders_invitees', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('49706ed5-75cb-4892-a392-64f34d1e3cf2', 'document_revisions', 'Documents', 'documents', 'id', 'DocumentRevisions', 'document_revisions', 'document_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('4a295888-7978-457c-87c5-e5df7dd82b15', 'leads_email_addresses_primary', 'Leads', 'leads', 'id', 'EmailAddresses', 'email_addresses', 'id', 'email_addr_bean_rel', 'bean_id', 'email_address_id', 'many-to-many', 'primary_address', '1', 0, 0),
('4ab05051-9161-4cdd-887e-e9691e2a259b', 'user_direct_reports', 'Users', 'users', 'id', 'Users', 'users', 'reports_to_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('4b0a7287-f53c-4039-8df6-4d1260be0473', 'aos_contracts_notes', 'AOS_Contracts', 'aos_contracts', 'id', 'Notes', 'notes', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'AOS_Contracts', 0, 0),
('4b19857a-5f23-40d1-bfab-e68d1e457d2d', 'accounts_assigned_user', 'Users', 'users', 'id', 'Accounts', 'accounts', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('4b251cfc-e6b0-48fb-bdc4-06705a190c71', 'schedulersjobs_assigned_user', 'Users', 'users', 'id', 'SchedulersJobs', 'job_queue', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('4b6938d6-4c51-4cb7-87ae-04a28d86aaa8', 'templatesectionline_created_by', 'Users', 'users', 'id', 'TemplateSectionLine', 'templatesectionline', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('4b7e5d63-7849-445a-87c7-b760bb237e6d', 'aos_line_item_groups_modified_user', 'Users', 'users', 'id', 'AOS_Line_Item_Groups', 'aos_line_item_groups', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('4b7f295b-104a-4e10-8a8a-cb6c03ef7fac', 'opportunities_assigned_user', 'Users', 'users', 'id', 'Opportunities', 'opportunities', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('4b84fe66-646e-445a-8a6c-e44bd4627f10', 'outbound_emails_external_oauth_connections', 'ExternalOAuthConnection', 'external_oauth_connections', 'id', 'OutboundEmailAccounts', 'outbound_email', 'external_oauth_connection_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('4bdd4ea8-7a7a-4e2f-9ee8-129a67d79915', 'emails_bugs_rel', 'Emails', 'emails', 'id', 'Bugs', 'bugs', 'id', 'emails_beans', 'email_id', 'bean_id', 'many-to-many', 'bean_module', 'Bugs', 0, 0),
('4ca1aada-cf19-4d74-aa2e-4eb9aa5dd3b2', 'calls_reschedule_assigned_user', 'Users', 'users', 'id', 'Calls_Reschedule', 'calls_reschedule', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('4ca2f61a-abc3-49b6-8dff-ba7bff1c8cfa', 'securitygroups_campaigns', 'SecurityGroups', 'securitygroups', 'id', 'Campaigns', 'campaigns', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Campaigns', 0, 0),
('4cd20508-be7b-469e-9e54-b9f7439baf29', 'bugs_created_by', 'Users', 'users', 'id', 'Bugs', 'bugs', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('4cee0947-9fcd-449a-a539-479374b65af6', 'account_calls', 'Accounts', 'accounts', 'id', 'Calls', 'calls', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Accounts', 0, 0),
('4d22f7a4-6333-4254-8a62-d78362174f32', 'prospect_campaign_log', 'Prospects', 'prospects', 'id', 'CampaignLog', 'campaign_log', 'target_id', NULL, NULL, NULL, 'one-to-many', 'target_type', 'Prospects', 0, 0),
('4daf570c-e440-4c47-be6f-7567ffe3a518', 'am_projecttemplates_project_1', 'AM_ProjectTemplates', 'am_projecttemplates', 'id', 'Project', 'project', 'id', 'am_projecttemplates_project_1_c', 'am_projecttemplates_project_1am_projecttemplates_ida', 'am_projecttemplates_project_1project_idb', 'many-to-many', NULL, NULL, 0, 0),
('4dd40ef3-1244-43f0-999a-7fa5af18f300', 'surveyresponses_assigned_user', 'Users', 'users', 'id', 'SurveyResponses', 'surveyresponses', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('4e31909d-1c6c-41bb-ab49-6856fe52d0d0', 'surveyquestions_surveyquestionresponses', 'SurveyQuestions', 'surveyquestions', 'id', 'SurveyQuestionResponses', 'surveyquestionresponses', 'surveyquestion_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('4f3ad9b9-e799-425a-9f1c-b8279daa9763', 'aos_pdf_templates_assigned_user', 'Users', 'users', 'id', 'AOS_PDF_Templates', 'aos_pdf_templates', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('507d629b-14c7-4e87-8f43-0f96f1391563', 'users_email_addresses', 'Users', 'users', 'id', 'EmailAddresses', 'email_addresses', 'id', 'email_addr_bean_rel', 'bean_id', 'email_address_id', 'many-to-many', 'bean_module', 'Users', 0, 0),
('5204cdf4-1049-4e7f-8d80-a6b3a31317ca', 'emailtemplates_assigned_user', 'Users', 'users', 'id', 'EmailTemplates', 'email_templates', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('52052c04-943c-45b5-8a0e-6736db50d48e', 'case_tasks', 'Cases', 'cases', 'id', 'Tasks', 'tasks', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Cases', 0, 0),
('53f1099e-c35e-4c30-8b3c-bcb0c01965fc', 'aos_products_quotes_modified_user', 'Users', 'users', 'id', 'AOS_Products_Quotes', 'aos_products_quotes', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('540cb89c-8438-49d4-9ae9-d01738638f54', 'aor_conditions_modified_user', 'Users', 'users', 'id', 'AOR_Conditions', 'aor_conditions', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('54f9c98c-2714-4d7f-92d0-0ce7e7f53085', 'jjwg_address_cache_created_by', 'Users', 'users', 'id', 'jjwg_Address_Cache', 'jjwg_address_cache', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('556c091d-698c-41be-a88d-c2c13a3fc44b', 'prospect_tasks', 'Prospects', 'prospects', 'id', 'Tasks', 'tasks', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Prospects', 0, 0),
('562bf628-b7e8-4f26-82f8-8695f522ea9f', 'contact_notes_parent', 'Contacts', 'contacts', 'id', 'Notes', 'notes', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Contacts', 0, 0),
('56f91418-fbee-4689-8959-9e4f1c2d34ef', 'account_cases', 'Accounts', 'accounts', 'id', 'Cases', 'cases', 'account_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('5739531b-328d-41f3-98ef-58a052136270', 'inbound_emails_autoreply_email_templates', 'EmailTemplates', 'email_templates', 'id', 'InboundEmail', 'inbound_email', 'template_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('59175fa9-09c0-412e-a2aa-421925ab78a2', 'oauthkeys_assigned_user', 'Users', 'users', 'id', 'OAuthKeys', 'oauth_consumer', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('59fc7bd7-bc56-4270-bb41-f4499ff819a7', 'securitygroups_prospect_lists', 'SecurityGroups', 'securitygroups', 'id', 'ProspectLists', 'prospect_lists', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'ProspectLists', 0, 0),
('5a3e001a-6f34-4593-b12a-6b3a85c776ba', 'surveyquestionresponses_modified_user', 'Users', 'users', 'id', 'SurveyQuestionResponses', 'surveyquestionresponses', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('5ac735ca-7c5c-4074-85bc-512bb5f48ec4', 'accounts_bugs', 'Accounts', 'accounts', 'id', 'Bugs', 'bugs', 'id', 'accounts_bugs', 'account_id', 'bug_id', 'many-to-many', NULL, NULL, 0, 0),
('5bf0a433-63a3-47fe-b381-e8921dc4a2d9', 'outbound_email_owner_user', 'Users', 'users', 'id', 'OutboundEmailAccounts', 'outbound_email', 'user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('5bfb01e8-7f0c-452c-b142-2e1a9c68be92', 'aos_invoices_modified_user', 'Users', 'users', 'id', 'AOS_Invoices', 'aos_invoices', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('5c0b73d3-a36c-4097-8513-9d4fcb2bb73e', 'surveyquestions_created_by', 'Users', 'users', 'id', 'SurveyQuestions', 'surveyquestions', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('5c97ef36-6dee-4503-95ca-2759bec49a20', 'aop_case_events_modified_user', 'Users', 'users', 'id', 'AOP_Case_Events', 'aop_case_events', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('5d2a6f83-b20a-4a8f-8f3f-c3dba79fe8f2', 'campaign_emailman', 'Campaigns', 'campaigns', 'id', 'EmailMan', 'emailman', 'campaign_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('5daf5024-c1e9-4afb-8c82-fb4e764f2358', 'meetings_assigned_user', 'Users', 'users', 'id', 'Meetings', 'meetings', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('5e45dfd2-ba73-4d63-a15d-7f58e1c4dd44', 'saved_search_assigned_user', 'Users', 'users', 'id', 'SavedSearch', 'saved_search', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('5e865af6-1c3a-49da-9711-853e950ba257', 'securitygroups_aos_quotes', 'SecurityGroups', 'securitygroups', 'id', 'AOS_Quotes', 'aos_quotes', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'AOS_Quotes', 0, 0),
('5ece9827-3ee5-47e5-bd71-e1cf96488462', 'am_tasktemplates_am_projecttemplates', 'AM_ProjectTemplates', 'am_projecttemplates', 'id', 'AM_TaskTemplates', 'am_tasktemplates', 'id', 'am_tasktemplates_am_projecttemplates_c', 'am_tasktemplates_am_projecttemplatesam_projecttemplates_ida', 'am_tasktemplates_am_projecttemplatesam_tasktemplates_idb', 'many-to-many', NULL, NULL, 0, 0),
('5efb5674-7305-4d8e-9c51-412d4290df95', 'tasks_notes', 'Tasks', 'tasks', 'id', 'Notes', 'notes', 'parent_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('5f7d37ff-0065-4a57-8ae2-48e17af06a89', 'prospectlists_assigned_user', 'Users', 'users', 'id', 'ProspectLists', 'prospect_lists', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('5fcc29fd-de88-439d-98b2-0ef1f714610c', 'emails_project_task_rel', 'Emails', 'emails', 'id', 'ProjectTask', 'project_task', 'id', 'emails_beans', 'email_id', 'bean_id', 'many-to-many', 'bean_module', 'ProjectTask', 0, 0),
('601c5480-8652-4e6b-9027-4cfd027fb9cb', 'projects_calls', 'Project', 'project', 'id', 'Calls', 'calls', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Project', 0, 0),
('60e4fc20-f71b-4068-9668-f6e60668aa74', 'securitygroups_project_task', 'SecurityGroups', 'securitygroups', 'id', 'ProjectTask', 'project_task', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'ProjectTask', 0, 0),
('60f26966-3318-49cc-bdf2-1853115bd741', 'campaign_campaignlog', 'Campaigns', 'campaigns', 'id', 'CampaignLog', 'campaign_log', 'campaign_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('6117fc4c-01c7-4283-bb46-1a2075a469c5', 'oauth2tokens_created_by', 'Users', 'users', 'id', 'OAuth2Tokens', 'oauth2tokens', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('618cfd3b-4a66-43f4-a33c-ddbcde05e753', 'project_tasks_calls', 'ProjectTask', 'project_task', 'id', 'Calls', 'calls', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'ProjectTask', 0, 0),
('619cb3f7-be71-4660-a6a3-0ea3ce3c4681', 'groups_aos_product_quotes', 'AOS_Line_Item_Groups', 'aos_line_item_groups', 'id', 'AOS_Products_Quotes', 'aos_products_quotes', 'group_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('61debcbd-df1a-4563-ba9c-022a9777b3bc', 'oauthkeys_created_by', 'Users', 'users', 'id', 'OAuthKeys', 'oauth_consumer', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('62641906-e332-4779-a6e6-6f10332ad161', 'fp_events_assigned_user', 'Users', 'users', 'id', 'FP_events', 'fp_events', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('626af7ed-f2e7-4a27-a895-baa60c1d303b', 'prospects_assigned_user', 'Users', 'users', 'id', 'Prospects', 'prospects', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('63034e61-ca52-4c62-90d2-c4f60e452ed5', 'calls_reschedule_created_by', 'Users', 'users', 'id', 'Calls_Reschedule', 'calls_reschedule', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('64630f19-cc74-4484-b37e-1251dfbb03a0', 'account_emails', 'Accounts', 'accounts', 'id', 'Emails', 'emails', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Accounts', 0, 0),
('64bed1d8-c457-4115-aeca-b27d6489cb1e', 'projects_contacts', 'Project', 'project', 'id', 'Contacts', 'contacts', 'id', 'projects_contacts', 'project_id', 'contact_id', 'many-to-many', NULL, NULL, 0, 0),
('660d22aa-8550-4048-8c19-9666c6cff907', 'emails_created_by', 'Users', 'users', 'id', 'Emails', 'emails', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('668ae957-b6b9-4f80-ae55-ae6f914d39d7', 'surveyquestionoptions_assigned_user', 'Users', 'users', 'id', 'SurveyQuestionOptions', 'surveyquestionoptions', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('66bb0009-110f-4822-810f-3d94a678b7dd', 'favorites_created_by', 'Users', 'users', 'id', 'Favorites', 'favorites', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('66d7164c-0d4e-4db9-b4e0-ea273f27b1b3', 'surveyquestionoptions_created_by', 'Users', 'users', 'id', 'SurveyQuestionOptions', 'surveyquestionoptions', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('67397754-cb3e-440a-94e3-eb6cd8794ad5', 'securitygroups_assigned_user', 'Users', 'users', 'id', 'SecurityGroups', 'securitygroups', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('674d0a4d-8745-461d-a7d0-12895a2b7e6c', 'leads_modified_user', 'Users', 'users', 'id', 'Leads', 'leads', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('67c29f3e-016e-4c46-9e5b-baf6de405d1e', 'account_tasks', 'Accounts', 'accounts', 'id', 'Tasks', 'tasks', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Accounts', 0, 0),
('67d609b0-7599-4ab8-89a3-f77c9a46f975', 'surveyresponses_surveyquestionresponses', 'SurveyResponses', 'surveyresponses', 'id', 'SurveyQuestionResponses', 'surveyquestionresponses', 'surveyresponse_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('68561801-b0fd-4505-9e3d-cae62abd20dc', 'contacts_aop_case_updates', 'Contacts', 'contacts', 'id', 'AOP_Case_Updates', 'aop_case_updates', 'contact_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('6892c5e3-b787-4060-b1ce-a78634b5c324', 'securitygroups_users', 'SecurityGroups', 'securitygroups', 'id', 'Users', 'users', 'id', 'securitygroups_users', 'securitygroup_id', 'user_id', 'many-to-many', NULL, NULL, 0, 0),
('69410761-ac05-42e2-8aa7-90dd2726d487', 'contacts_bugs', 'Contacts', 'contacts', 'id', 'Bugs', 'bugs', 'id', 'contacts_bugs', 'contact_id', 'bug_id', 'many-to-many', NULL, NULL, 0, 0),
('6956dfc7-6ec9-4a1a-b3e0-a50951833259', 'securitygroups_bugs', 'SecurityGroups', 'securitygroups', 'id', 'Bugs', 'bugs', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Bugs', 0, 0),
('69ff8b5f-5172-4a64-a327-a2322cd6a6ef', 'campaigns_assigned_user', 'Users', 'users', 'id', 'Campaigns', 'campaigns', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('6b020445-2271-4d91-a29a-da275a2ba494', 'cases_assigned_user', 'Users', 'users', 'id', 'Cases', 'cases', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('6baed601-7c32-4338-a146-7113f6c20f63', 'calls_assigned_user', 'Users', 'users', 'id', 'Calls', 'calls', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('6be0d8ec-9d75-423d-817f-26b9114e4f62', 'aok_knowledgebase_modified_user', 'Users', 'users', 'id', 'AOK_KnowledgeBase', 'aok_knowledgebase', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('6c52c863-77b7-4a75-b1f0-d245b6266e20', 'optimistic_locking', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0),
('6d048b8f-5ed0-4f6f-bdbb-5054fb2abfcd', 'aow_processed_modified_user', 'Users', 'users', 'id', 'AOW_Processed', 'aow_processed', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('6dc52c54-ecf3-4377-97e3-aac3f5bf89f9', 'projects_assigned_user', 'Users', 'users', 'id', 'Project', 'project', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('6e0d4e96-d4c7-4e00-acef-a10f6bf47f55', 'opportunity_leads', 'Opportunities', 'opportunities', 'id', 'Leads', 'leads', 'opportunity_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('6e9bd5a8-bb4c-4229-924b-ea65647eb1e8', 'aos_quotes_aos_invoices', 'AOS_Quotes', 'aos_quotes', 'id', 'AOS_Invoices', 'aos_invoices', 'id', 'aos_quotes_aos_invoices_c', 'aos_quotes77d9_quotes_ida', 'aos_quotes6b83nvoices_idb', 'many-to-many', NULL, NULL, 0, 0),
('6f886c02-9505-430d-bfdb-be4234b6f6d1', 'inbound_emails_case_email_templates', 'EmailTemplates', 'email_templates', 'id', 'InboundEmail', 'inbound_email', 'create_case_template_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('7083e267-79b4-4202-8167-ed91059e628a', 'opportunity_currencies', 'Opportunities', 'opportunities', 'currency_id', 'Currencies', 'currencies', 'id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('71b70e18-ea8b-44e9-8192-1fa4ec04b2ae', 'documents_opportunities', 'Documents', 'documents', 'id', 'Opportunities', 'opportunities', 'id', 'documents_opportunities', 'document_id', 'opportunity_id', 'many-to-many', NULL, NULL, 0, 0),
('72062740-5623-4323-806a-888a4affc7c2', 'aos_contracts_aos_line_item_groups', 'AOS_Contracts', 'aos_contracts', 'id', 'AOS_Line_Item_Groups', 'aos_line_item_groups', 'parent_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('724a870c-f944-4077-9869-b4080b3012b4', 'securitygroups_jjwg_areas', 'SecurityGroups', 'securitygroups', 'id', 'jjwg_Areas', 'jjwg_areas', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'jjwg_Areas', 0, 0),
('72777632-f0ef-4340-b25d-aac5a8a6c24b', 'fp_events_prospects_1', 'FP_events', 'fp_events', 'id', 'Prospects', 'prospects', 'id', 'fp_events_prospects_1_c', 'fp_events_prospects_1fp_events_ida', 'fp_events_prospects_1prospects_idb', 'many-to-many', NULL, NULL, 0, 0),
('7297d6e8-d50b-42d4-b538-13ccdf11571e', 'am_projecttemplates_contacts_1', 'AM_ProjectTemplates', 'am_projecttemplates', 'id', 'Contacts', 'contacts', 'id', 'am_projecttemplates_contacts_1_c', 'am_projecttemplates_ida', 'contacts_idb', 'many-to-many', NULL, NULL, 0, 0),
('72b6735a-b816-40fd-ae5a-647a90bc13d8', 'schedulers_modified_user_id_rel', 'Users', 'users', 'id', 'Schedulers', 'schedulers', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('73d70d8b-50af-4c58-993d-64f59ad652b5', 'aor_scheduled_reports_aor_reports', 'AOR_Reports', 'aor_reports', 'id', 'AOR_Scheduled_Reports', 'aor_scheduled_reports', 'aor_report_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('74442b4f-f1b4-46da-8722-d71c82c4d159', 'notes_modified_user', 'Users', 'users', 'id', 'Notes', 'notes', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('74c5c775-8905-4ff8-94b5-0b8858dbc676', 'aod_indexevent_assigned_user', 'Users', 'users', 'id', 'AOD_IndexEvent', 'aod_indexevent', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('74d5eea6-71ed-4f4f-95a5-4269e00ef1d4', 'reminders_modified_user', 'Users', 'users', 'id', 'Reminders', 'reminders', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('7545a54e-a8cb-46f5-bf99-f0560cf11bde', 'aor_charts_created_by', 'Users', 'users', 'id', 'AOR_Charts', 'aor_charts', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('754b4c8c-418d-4682-8585-eecf5279ba11', 'jjwg_maps_assigned_user', 'Users', 'users', 'id', 'jjwg_Maps', 'jjwg_maps', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('759c7397-c527-4103-b070-071f9a19fc91', 'securitygroups_emailmarketing', 'SecurityGroups', 'securitygroups', 'id', 'EmailMarketing', 'email_marketing', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'EmailMarketing', 0, 0),
('761c8638-728f-45fb-a19d-72b58d45bb6e', 'leads_documents', 'Leads', 'leads', 'id', 'Documents', 'documents', 'id', 'linked_documents', 'parent_id', 'document_id', 'many-to-many', 'parent_type', 'Leads', 0, 0),
('763e7e4d-8bcf-42c2-9d3a-5da006b1e2ab', 'contacts_created_by', 'Users', 'users', 'id', 'Contacts', 'contacts', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('76546b78-7f6f-4f55-8051-9490946c7f29', 'account_meetings', 'Accounts', 'accounts', 'id', 'Meetings', 'meetings', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Accounts', 0, 0),
('76858635-92bc-4734-89dd-977a2a74d59e', 'aow_workflow_assigned_user', 'Users', 'users', 'id', 'AOW_WorkFlow', 'aow_workflow', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('7696f386-7a60-4c1c-9007-12350c5ac03b', 'documents_created_by', 'Users', 'users', 'id', 'Documents', 'documents', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('76e6b8e1-2032-47ba-8282-7a2626b17bed', 'spots_created_by', 'Users', 'users', 'id', 'Spots', 'spots', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('770a8476-24d2-4d3b-8af9-7a36189b243f', 'fp_events_leads_1', 'FP_events', 'fp_events', 'id', 'Leads', 'leads', 'id', 'fp_events_leads_1_c', 'fp_events_leads_1fp_events_ida', 'fp_events_leads_1leads_idb', 'many-to-many', NULL, NULL, 0, 0),
('77d79b6c-f94d-44b5-b12d-7792b8833c4c', 'aor_reports_created_by', 'Users', 'users', 'id', 'AOR_Reports', 'aor_reports', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('7820f581-5a30-4a61-932f-671e2a10222f', 'prospects_created_by', 'Users', 'users', 'id', 'Prospects', 'prospects', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('785a6877-0493-4cdb-af83-d01fbdc6ca91', 'aor_conditions_created_by', 'Users', 'users', 'id', 'AOR_Conditions', 'aor_conditions', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('787f8cbe-5097-4914-9c05-469a044bb2a1', 'fp_events_contacts', 'FP_events', 'fp_events', 'id', 'Contacts', 'contacts', 'id', 'fp_events_contacts_c', 'fp_events_contactsfp_events_ida', 'fp_events_contactscontacts_idb', 'many-to-many', NULL, NULL, 0, 0),
('78f3c5e0-a888-403b-8f1e-c3e96b1d93b5', 'aos_quotes_modified_user', 'Users', 'users', 'id', 'AOS_Quotes', 'aos_quotes', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('790e4226-ec2f-4e07-a3b8-8ba65d0a5f76', 'aor_reports_aor_fields', 'AOR_Reports', 'aor_reports', 'id', 'AOR_Fields', 'aor_fields', 'aor_report_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('7a515aec-6c39-453a-aab4-3c3b3e74f08e', 'aow_conditions_modified_user', 'Users', 'users', 'id', 'AOW_Conditions', 'aow_conditions', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('7bc7a377-a9a3-40df-bf49-1bafd661b5c7', 'aos_quotes_created_by', 'Users', 'users', 'id', 'AOS_Quotes', 'aos_quotes', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('7c176f49-288b-4511-b94f-35965b60ce39', 'alerts_assigned_user', 'Users', 'users', 'id', 'Alerts', 'alerts', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('7cffaaa7-d185-4c1b-92a4-fe5da1e391d7', 'jjwg_Maps_opportunities', 'jjwg_Maps', 'jjwg_Maps', 'parent_id', 'Opportunities', 'opportunities', 'id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Opportunities', 0, 0);
INSERT INTO `relationships` VALUES
('7dc67d0c-c189-4b0b-a53e-7505e2fd5fc7', 'securitygroups_aor_scheduled_reports', 'SecurityGroups', 'securitygroups', 'id', 'AOR_Scheduled_Reports', 'aor_scheduled_reports', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'AOR_Scheduled_Reports', 0, 0),
('7de9d962-b0dd-4749-a905-0dd56439dd66', 'account_aos_invoices', 'Accounts', 'accounts', 'id', 'AOS_Invoices', 'aos_invoices', 'billing_account_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('7df385d0-3c04-4dbe-80ba-dfda5282a470', 'campaignlog_targeted_users', 'CampaignLog', 'campaign_log', 'target_id', 'Users', 'users', 'id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('7ef2bbf7-2109-44d5-8812-285f84574a00', 'campaigns_created_by', 'Users', 'users', 'id', 'Campaigns', 'campaigns', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('7f5da679-339f-455c-9288-b7b9c3d3d5d9', 'securitygroups_surveyquestionoptions', 'SecurityGroups', 'securitygroups', 'id', 'SurveyQuestionOptions', 'surveyquestionoptions', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'SurveyQuestionOptions', 0, 0),
('7fc34eb7-f8cb-44f3-a900-e54a7c7960b4', 'fp_event_locations_assigned_user', 'Users', 'users', 'id', 'FP_Event_Locations', 'fp_event_locations', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('7fd4c7de-6f35-456e-aee6-e6338a59df43', 'calls_reschedule', 'Calls', 'calls', 'id', 'Calls_Reschedule', 'calls_reschedule', 'call_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('7fe3e08c-e36e-4686-860e-3594c4f14974', 'calendaraccount_modified_user', 'Users', 'users', 'id', 'CalendarAccount', 'calendar_accounts', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('8067a969-69ee-4e7b-a103-7e602ef1288a', 'cases_created_contact', 'Contacts', 'contacts', 'id', 'Cases', 'cases', 'contact_created_by_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('808b4cda-d388-41b2-81ec-ccc97411b94e', 'securitygroups_inboundemail', 'SecurityGroups', 'securitygroups', 'id', 'InboundEmail', 'inbound_email', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'InboundEmail', 0, 0),
('811a6ee6-5324-4ac0-b336-6c9e32b2a9a0', 'aow_workflow_aow_conditions', 'AOW_WorkFlow', 'aow_workflow', 'id', 'AOW_Conditions', 'aow_conditions', 'aow_workflow_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('8159ca07-2c12-4d8d-99eb-97c2ed40c2dd', 'securitygroups_project', 'SecurityGroups', 'securitygroups', 'id', 'Project', 'project', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Project', 0, 0),
('81619f84-39c2-46fa-8128-0bef14f756ba', 'case_notes', 'Cases', 'cases', 'id', 'Notes', 'notes', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Cases', 0, 0),
('8222e5ff-39db-47e7-932f-ecce1144599a', 'emails_users_rel', 'Emails', 'emails', 'id', 'Users', 'users', 'id', 'emails_beans', 'email_id', 'bean_id', 'many-to-many', 'bean_module', 'Users', 0, 0),
('82b62843-946e-4588-aac5-6b52d8486c67', 'oauth2clients_modified_user', 'Users', 'users', 'id', 'OAuth2Clients', 'oauth2clients', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('83223df7-e360-46a6-a616-af5609ceb324', 'jjwg_Maps_accounts', 'jjwg_Maps', 'jjwg_Maps', 'parent_id', 'Accounts', 'accounts', 'id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Accounts', 0, 0),
('838b4794-3bf9-449b-a936-f5f51b1a29dc', 'aod_index_created_by', 'Users', 'users', 'id', 'AOD_Index', 'aod_index', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('853bcdd7-d327-467c-94b2-508ce7961171', 'campaignlog_contact', 'CampaignLog', 'campaign_log', 'related_id', 'Contacts', 'contacts', 'id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('85aca4b5-6d5f-498c-9db6-f9361f7e9ae9', 'prospects_email_addresses', 'Prospects', 'prospects', 'id', 'EmailAddresses', 'email_addresses', 'id', 'email_addr_bean_rel', 'bean_id', 'email_address_id', 'many-to-many', 'bean_module', 'Prospects', 0, 0),
('85b7d60b-cf8b-4349-91fb-62f552986fb3', 'projects_modified_user', 'Users', 'users', 'id', 'Project', 'project', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('85de5382-83eb-476e-b57c-4809cf32e925', 'surveyquestionresponses_created_by', 'Users', 'users', 'id', 'SurveyQuestionResponses', 'surveyquestionresponses', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('86159cbb-436e-4844-a483-c06736aaa92d', 'projects_notes', 'Project', 'project', 'id', 'Notes', 'notes', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Project', 0, 0),
('86b9915c-0fb6-479a-8342-edd6c462430a', 'aos_invoices_created_by', 'Users', 'users', 'id', 'AOS_Invoices', 'aos_invoices', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('8724d259-7c4d-4e7e-9ee6-69e2f242f95b', 'aos_contracts_tasks', 'AOS_Contracts', 'aos_contracts', 'id', 'Tasks', 'tasks', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'AOS_Contracts', 0, 0),
('879d502f-41d4-4e45-91f3-a6ca4b8b0f0a', 'bugs_assigned_user', 'Users', 'users', 'id', 'Bugs', 'bugs', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('87f6f1a7-c87a-483d-829c-ab837b66fdca', 'aow_conditions_created_by', 'Users', 'users', 'id', 'AOW_Conditions', 'aow_conditions', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('881f383f-f1ad-499b-851f-1b0b9bc8d3b3', 'surveyquestionoptions_modified_user', 'Users', 'users', 'id', 'SurveyQuestionOptions', 'surveyquestionoptions', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('8a43b497-a7e6-4916-ada1-512ad0849ab3', 'opportunity_aos_quotes', 'Opportunities', 'opportunities', 'id', 'AOS_Quotes', 'aos_quotes', 'opportunity_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('8ac1d1f6-f158-4651-b64c-001b8eba6ae3', 'tasks_modified_user', 'Users', 'users', 'id', 'Tasks', 'tasks', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('8acbdb20-7b51-41a4-9b3a-f3caa6d0e4c8', 'inbound_email_modified_user_id', 'Users', 'users', 'id', 'InboundEmail', 'inbound_email', 'modified_user_id', NULL, NULL, NULL, 'one-to-one', NULL, NULL, 0, 0),
('8b02c650-4706-4270-8d53-84356fede288', 'project_tasks_emails', 'ProjectTask', 'project_task', 'id', 'Emails', 'emails', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'ProjectTask', 0, 0),
('8bc9b9b9-9fa2-4a7f-aad6-fc9c35ca6c9c', 'sub_product_categories', 'AOS_Product_Categories', 'aos_product_categories', 'id', 'AOS_Product_Categories', 'aos_product_categories', 'parent_category_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('8ccfee7e-9dc8-45c4-b238-43b11e0f54f3', 'aos_contracts_modified_user', 'Users', 'users', 'id', 'AOS_Contracts', 'aos_contracts', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('8d57689a-633f-4079-95d2-efb17d318be5', 'aos_quotes_aos_contracts', 'AOS_Quotes', 'aos_quotes', 'id', 'AOS_Contracts', 'aos_contracts', 'id', 'aos_quotes_os_contracts_c', 'aos_quotese81e_quotes_ida', 'aos_quotes4dc0ntracts_idb', 'many-to-many', NULL, NULL, 0, 0),
('8d5ce258-fd21-47b5-828c-12d86560d902', 'surveys_campaigns', 'Surveys', 'surveys', 'id', 'Campaigns', 'campaigns', 'survey_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('8e018315-c1ec-4fcf-87e7-6f24a8160b46', 'fp_events_fp_event_locations_1', 'FP_events', 'fp_events', 'id', 'FP_Event_Locations', 'fp_event_locations', 'id', 'fp_events_fp_event_locations_1_c', 'fp_events_fp_event_locations_1fp_events_ida', 'fp_events_fp_event_locations_1fp_event_locations_idb', 'many-to-many', NULL, NULL, 0, 0),
('8ea65a50-8f60-4c68-a4df-e53f722c0b52', 'reminders_invitees_modified_user', 'Users', 'users', 'id', 'Reminders_Invitees', 'reminders_invitees', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('8f245e30-49a9-49a3-bd60-faf782dde33f', 'jjwg_Maps_projects', 'jjwg_Maps', 'jjwg_Maps', 'parent_id', 'Project', 'project', 'id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Project', 0, 0),
('8f4e51ae-7c3f-4e23-addf-6401f329f1bf', 'aor_scheduled_reports_created_by', 'Users', 'users', 'id', 'AOR_Scheduled_Reports', 'aor_scheduled_reports', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('912160cf-04ee-42fb-b146-f24fdaa391a6', 'securitygroups_opportunities', 'SecurityGroups', 'securitygroups', 'id', 'Opportunities', 'opportunities', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Opportunities', 0, 0),
('91a6fdc8-1317-42c4-867a-c23d8a5c7d00', 'documents_accounts', 'Documents', 'documents', 'id', 'Accounts', 'accounts', 'id', 'documents_accounts', 'document_id', 'account_id', 'many-to-many', NULL, NULL, 0, 0),
('9251bc0c-dcb9-417b-aa3b-9f517e92f8e1', 'emails_projects_rel', 'Emails', 'emails', 'id', 'Project', 'project', 'id', 'emails_beans', 'email_id', 'bean_id', 'many-to-many', 'bean_module', 'Project', 0, 0),
('933cc863-ede6-4a22-8b60-8d02665dcaee', 'emails_aos_contracts_rel', 'Emails', 'emails', 'id', 'AOS_Contracts', 'aos_contracts', 'id', 'emails_beans', 'email_id', 'bean_id', 'many-to-many', 'bean_module', 'AOS_Contracts', 0, 0),
('93b3bf7c-9958-4eff-ad3b-f9916c63bb85', 'securitygroups_aos_contracts', 'SecurityGroups', 'securitygroups', 'id', 'AOS_Contracts', 'aos_contracts', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'AOS_Contracts', 0, 0),
('93c6d240-5850-451c-a92f-8c69fce0a769', 'account_campaign_log', 'Accounts', 'accounts', 'id', 'CampaignLog', 'campaign_log', 'target_id', NULL, NULL, NULL, 'one-to-many', 'target_type', 'Accounts', 0, 0),
('93cbb5b5-dd0a-49df-b645-3acb802a5fb2', 'surveys_modified_user', 'Users', 'users', 'id', 'Surveys', 'surveys', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('93e827a3-72f4-41af-a130-3a1f346cc7a8', 'aok_knowledge_base_categories_created_by', 'Users', 'users', 'id', 'AOK_Knowledge_Base_Categories', 'aok_knowledge_base_categories', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('95675dcb-5843-4a52-ae55-a12d5089d79a', 'jjwg_Maps_meetings', 'jjwg_Maps', 'jjwg_Maps', 'parent_id', 'Meetings', 'meetings', 'id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Meetings', 0, 0),
('96a95594-bda5-4650-af7c-0cac2fd17338', 'campaign_contacts', 'Campaigns', 'campaigns', 'id', 'Contacts', 'contacts', 'campaign_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('9960c11a-c440-46ab-abcd-b7a4f0e76af6', 'prospect_list_accounts', 'ProspectLists', 'prospect_lists', 'id', 'Accounts', 'accounts', 'id', 'prospect_lists_prospects', 'prospect_list_id', 'related_id', 'many-to-many', 'related_type', 'Accounts', 0, 0),
('9a17c50d-9dbc-46b1-9116-508c733e0609', 'revisions_created_by', 'Users', 'users', 'id', 'DocumentRevisions', 'document_revisions', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('9a3af414-c190-4a90-9a58-f323f64c5f07', 'oauth2clients_oauth2authcodes', 'OAuth2Clients', 'oauth2clients', 'id', 'Oauth2AuthCodes', 'oauth2authcodes', 'client', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('9a7a8bd8-b2d7-45db-9aad-d1e2811a5aee', 'emails_tasks_rel', 'Emails', 'emails', 'id', 'Tasks', 'tasks', 'id', 'emails_beans', 'email_id', 'bean_id', 'many-to-many', 'bean_module', 'Tasks', 0, 0),
('9b11eef5-fa62-4567-a963-9dff62a683cb', 'consumer_tokens', 'OAuthKeys', 'oauth_consumer', 'id', 'OAuthTokens', 'oauth_tokens', 'consumer', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('9b907657-91c7-449a-bcb7-4d657c993132', 'prospect_notes', 'Prospects', 'prospects', 'id', 'Notes', 'notes', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Prospects', 0, 0),
('9b91cfb3-9081-4597-8520-bcfe6c029b2f', 'securitygroups_calls', 'SecurityGroups', 'securitygroups', 'id', 'Calls', 'calls', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Calls', 0, 0),
('9bc4d46d-c39d-4c79-82f2-7ce9f038251d', 'aow_processed_created_by', 'Users', 'users', 'id', 'AOW_Processed', 'aow_processed', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('9cb41a74-2a91-441f-823b-c4955b634c77', 'emails_opportunities_rel', 'Emails', 'emails', 'id', 'Opportunities', 'opportunities', 'id', 'emails_beans', 'email_id', 'bean_id', 'many-to-many', 'bean_module', 'Opportunities', 0, 0),
('9ccd5ff4-2be4-4a69-b703-49d27c73de9e', 'opportunity_emails', 'Opportunities', 'opportunities', 'id', 'Emails', 'emails', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Opportunities', 0, 0),
('9d66f393-02d7-4474-a1d2-b388dd7b4fba', 'opportunity_tasks', 'Opportunities', 'opportunities', 'id', 'Tasks', 'tasks', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Opportunities', 0, 0),
('9db3dd6c-11ab-4c2e-ae46-43a0bcab5139', 'acl_roles_actions', 'ACLRoles', 'acl_roles', 'id', 'ACLActions', 'acl_actions', 'id', 'acl_roles_actions', 'role_id', 'action_id', 'many-to-many', NULL, NULL, 0, 0),
('9dc8a5aa-d34e-4eaf-a350-aa03d1582128', 'jjwg_markers_assigned_user', 'Users', 'users', 'id', 'jjwg_Markers', 'jjwg_markers', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('9de61cc1-03a3-4f74-a2a2-30b4412589d8', 'aod_index_assigned_user', 'Users', 'users', 'id', 'AOD_Index', 'aod_index', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('9decbed8-6c1f-4e61-b0dc-7731b47e98f7', 'tasks_created_by', 'Users', 'users', 'id', 'Tasks', 'tasks', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('9e3d5275-6c90-492f-8465-be7d8e542d6d', 'users_email_addresses_primary', 'Users', 'users', 'id', 'EmailAddresses', 'email_addresses', 'id', 'email_addr_bean_rel', 'bean_id', 'email_address_id', 'many-to-many', 'primary_address', '1', 0, 0),
('9e4af7aa-3a3f-43e3-b36b-316d8d2bc05e', 'externaloauthprovider_created_by', 'Users', 'users', 'id', 'ExternalOAuthProvider', 'external_oauth_providers', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('9e9a8a95-6a18-45de-a0e9-d2c0c795c6f0', 'jjwg_markers_modified_user', 'Users', 'users', 'id', 'jjwg_Markers', 'jjwg_markers', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('9e9e23dd-f9c6-4220-8b17-563b3a3e0999', 'aos_line_item_groups_created_by', 'Users', 'users', 'id', 'AOS_Line_Item_Groups', 'aos_line_item_groups', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('9f318656-e876-4212-b28b-a53d7dce8f36', 'aos_invoices_aos_product_quotes', 'AOS_Invoices', 'aos_invoices', 'id', 'AOS_Products_Quotes', 'aos_products_quotes', 'parent_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('9fead714-1ce5-4489-8b16-6b4535f39412', 'securitygroups_emails', 'SecurityGroups', 'securitygroups', 'id', 'Emails', 'emails', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Emails', 0, 0),
('a0023bc5-264b-4997-8d7f-3a3d133ce2b4', 'schedulers_jobs_rel', 'Schedulers', 'schedulers', 'id', 'SchedulersJobs', 'job_queue', 'scheduler_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('a0035515-65ba-42ec-a2a5-c44d442a6a8a', 'contacts_cases', 'Contacts', 'contacts', 'id', 'Cases', 'cases', 'id', 'contacts_cases', 'contact_id', 'case_id', 'many-to-many', NULL, NULL, 0, 0),
('a07d2b0a-89e9-40fa-afb8-1a2d391dcd14', 'contact_leads', 'Contacts', 'contacts', 'id', 'Leads', 'leads', 'contact_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('a087d572-e763-4219-b999-67fb3f390380', 'aow_workflow_aow_actions', 'AOW_WorkFlow', 'aow_workflow', 'id', 'AOW_Actions', 'aow_actions', 'aow_workflow_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('a0ebb63c-cd64-4cf6-867f-dbd47c9441f0', 'emails_leads_rel', 'Emails', 'emails', 'id', 'Leads', 'leads', 'id', 'emails_beans', 'email_id', 'bean_id', 'many-to-many', 'bean_module', 'Leads', 0, 0),
('a0f5443d-d032-4b85-8a5c-90806e23fe92', 'securitygroups_meetings', 'SecurityGroups', 'securitygroups', 'id', 'Meetings', 'meetings', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Meetings', 0, 0),
('a12edd02-0ce4-4018-aa76-ed7ed263fa93', 'cases_bugs', 'Cases', 'cases', 'id', 'Bugs', 'bugs', 'id', 'cases_bugs', 'case_id', 'bug_id', 'many-to-many', NULL, NULL, 0, 0),
('a14108d8-c3c4-49de-bab0-cb677e815816', 'lead_calls', 'Leads', 'leads', 'id', 'Calls', 'calls', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Leads', 0, 0),
('a1b53089-8abf-483a-8e76-903df70de288', 'contacts_email_addresses', 'Contacts', 'contacts', 'id', 'EmailAddresses', 'email_addresses', 'id', 'email_addr_bean_rel', 'bean_id', 'email_address_id', 'many-to-many', 'bean_module', 'Contacts', 0, 0),
('a1c89819-cbc4-415a-b6b4-d88503acac65', 'oauth2tokens_modified_user', 'Users', 'users', 'id', 'OAuth2Tokens', 'oauth2tokens', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('a217ffdc-b23d-43de-baca-57736bd39d05', 'am_projecttemplates_modified_user', 'Users', 'users', 'id', 'AM_ProjectTemplates', 'am_projecttemplates', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('a2302255-f6ae-4d2e-9530-b555b4c80c49', 'aos_contracts_meetings', 'AOS_Contracts', 'aos_contracts', 'id', 'Meetings', 'meetings', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'AOS_Contracts', 0, 0),
('a26deb74-92d9-49c9-9846-baf27267f32d', 'surveyquestionresponses_assigned_user', 'Users', 'users', 'id', 'SurveyQuestionResponses', 'surveyquestionresponses', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('a2b8ccae-9d30-4b4c-86fe-4178daa40d9c', 'campaign_opportunities', 'Campaigns', 'campaigns', 'id', 'Opportunities', 'opportunities', 'campaign_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('a2ddf1aa-fc13-4edb-8e99-a0cec0bc251f', 'product_categories', 'AOS_Product_Categories', 'aos_product_categories', 'id', 'AOS_Products', 'aos_products', 'aos_product_category_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('a4207971-69a8-493f-a111-e145c1b463d8', 'jjwg_areas_created_by', 'Users', 'users', 'id', 'jjwg_Areas', 'jjwg_areas', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('a5d5f46e-be0d-46cd-a888-2c8d4d1f148f', 'aobh_businesshours_modified_user', 'Users', 'users', 'id', 'AOBH_BusinessHours', 'aobh_businesshours', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('a62d99fa-0ee4-4d63-b688-005b978d117d', 'contacts_email_addresses_primary', 'Contacts', 'contacts', 'id', 'EmailAddresses', 'email_addresses', 'id', 'email_addr_bean_rel', 'bean_id', 'email_address_id', 'many-to-many', 'primary_address', '1', 0, 0),
('a6906d83-63bd-4cff-b961-98b6bf9d2244', 'lead_meetings', 'Leads', 'leads', 'id', 'Meetings', 'meetings', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Leads', 0, 0),
('a6b91a6e-702a-4637-936f-b2c947225317', 'opportunity_aos_contracts', 'Opportunities', 'opportunities', 'id', 'AOS_Contracts', 'aos_contracts', 'opportunity_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('a6d95895-b704-47ce-b4b2-566f2e4f619f', 'documents_cases', 'Documents', 'documents', 'id', 'Cases', 'cases', 'id', 'documents_cases', 'document_id', 'case_id', 'many-to-many', NULL, NULL, 0, 0),
('a6f660e6-8604-4710-b09a-35b2894fffad', 'securitygroups_aos_invoices', 'SecurityGroups', 'securitygroups', 'id', 'AOS_Invoices', 'aos_invoices', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'AOS_Invoices', 0, 0),
('a71a24f8-a85c-4a87-9e9a-b6c940775d46', 'securitygroups_contacts', 'SecurityGroups', 'securitygroups', 'id', 'Contacts', 'contacts', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Contacts', 0, 0),
('a76207c5-b6a2-47bf-b223-e9e8e4d6c975', 'securitygroups_fp_events', 'SecurityGroups', 'securitygroups', 'id', 'FP_events', 'fp_events', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'FP_events', 0, 0),
('a799af81-1c59-4d86-8f96-40c6bfc687ae', 'acl_roles_users', 'ACLRoles', 'acl_roles', 'id', 'Users', 'users', 'id', 'acl_roles_users', 'role_id', 'user_id', 'many-to-many', NULL, NULL, 0, 0),
('a7a2e159-8232-4380-bcd1-e016542515e3', 'surveyresponses_campaigns', 'Campaigns', 'campaigns', 'id', 'SurveyResponses', 'surveyresponses', 'campaign_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('a7fab301-577b-407f-9ae9-4ec1c997479b', 'aos_contracts_aos_products_quotes', 'AOS_Contracts', 'aos_contracts', 'id', 'AOS_Products_Quotes', 'aos_products_quotes', 'parent_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('a966d481-21bf-4c29-821d-11371a273943', 'securitygroups_fp_event_locations', 'SecurityGroups', 'securitygroups', 'id', 'FP_Event_Locations', 'fp_event_locations', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'FP_Event_Locations', 0, 0),
('aa90e2fd-7f94-49ba-b127-2d27967b231c', 'surveys_created_by', 'Users', 'users', 'id', 'Surveys', 'surveys', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('aafbc8dd-9379-47ae-9e3c-32f4fd901ccb', 'surveys_surveyresponses', 'Surveys', 'surveys', 'id', 'SurveyResponses', 'surveyresponses', 'survey_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('ab85141f-8f84-4006-ab8d-a8f70e292e4a', 'securitygroups_cases', 'SecurityGroups', 'securitygroups', 'id', 'Cases', 'cases', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Cases', 0, 0),
('ac3054b1-bc26-4da0-9a71-2ac838792c95', 'bug_meetings', 'Bugs', 'bugs', 'id', 'Meetings', 'meetings', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Bugs', 0, 0),
('ad73a7e0-7995-45e7-929d-66e5b05605bd', 'emails_notes_rel', 'Emails', 'emails', 'id', 'Notes', 'notes', 'parent_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('ae407efa-2bbd-47ee-91a3-d56279f57bca', 'project_tasks_assigned_user', 'Users', 'users', 'id', 'ProjectTask', 'project_task', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('aee55c6d-749a-45c0-b1d2-92e49f5e8afa', 'securitygroups_outboundemailaccounts', 'SecurityGroups', 'securitygroups', 'id', 'OutboundEmailAccounts', 'outbound_email', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'OutboundEmailAccounts', 0, 0),
('b0490827-2369-45c2-8abd-f1da94acfdf8', 'projects_meetings', 'Project', 'project', 'id', 'Meetings', 'meetings', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Project', 0, 0),
('b1748ffa-1cbb-41da-9d4c-58d1205972cd', 'calls_created_by', 'Users', 'users', 'id', 'Calls', 'calls', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('b2295bb3-2615-4ee8-a5e9-7f0b2408f984', 'jjwg_Maps_contacts', 'jjwg_Maps', 'jjwg_Maps', 'parent_id', 'Contacts', 'contacts', 'id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Contacts', 0, 0),
('b2f56449-ba47-464a-bb0f-e9b47bd4a656', 'account_aos_quotes', 'Accounts', 'accounts', 'id', 'AOS_Quotes', 'aos_quotes', 'billing_account_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('b34905a7-7bfb-4c7a-b653-d936332b7346', 'bugs_release', 'Releases', 'releases', 'id', 'Bugs', 'bugs', 'found_in_release', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('b36a29a0-838b-4750-b10f-14975377bca8', 'campaign_leads', 'Campaigns', 'campaigns', 'id', 'Leads', 'leads', 'campaign_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('b36df193-1c70-4fd8-8e8d-5f274553cf83', 'contact_notes', 'Contacts', 'contacts', 'id', 'Notes', 'notes', 'contact_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('b4db1ee6-40b5-4710-9885-ca08f7e9ce77', 'calendar_accounts_calendar_user', 'Users', 'users', 'id', 'CalendarAccount', 'calendar_accounts', 'calendar_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('b5206feb-886a-4b9b-a9fc-c70a944e75d8', 'eapm_modified_user', 'Users', 'users', 'id', 'EAPM', 'eapm', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('b598258f-28c4-404c-a82a-f989403d51f5', 'campaign_campaigntrakers', 'Campaigns', 'campaigns', 'id', 'CampaignTrackers', 'campaign_trkrs', 'campaign_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('b7304c05-2d3d-4cf1-acba-2e2daae74122', 'jjwg_maps_modified_user', 'Users', 'users', 'id', 'jjwg_Maps', 'jjwg_maps', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('b757bdbe-4922-44da-a76c-9f130aedb0e4', 'securitygroups_jjwg_maps', 'SecurityGroups', 'securitygroups', 'id', 'jjwg_Maps', 'jjwg_maps', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'jjwg_Maps', 0, 0),
('b7adf21d-123c-4517-92d7-b25dc3582f04', 'calendaraccount_assigned_user', 'Users', 'users', 'id', 'CalendarAccount', 'calendar_accounts', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('b8593afc-2c07-47cf-836d-8b01fdeac33a', 'account_notes', 'Accounts', 'accounts', 'id', 'Notes', 'notes', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Accounts', 0, 0),
('b9181203-1df5-429d-a1f2-a2589c7b7ff8', 'cases_modified_user', 'Users', 'users', 'id', 'Cases', 'cases', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('b925e769-c774-41eb-ac30-96a9f164c02c', 'case_calls', 'Cases', 'cases', 'id', 'Calls', 'calls', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Cases', 0, 0),
('b96d0af2-2a9c-47cd-93ba-957398527a06', 'securitygroups_leads', 'SecurityGroups', 'securitygroups', 'id', 'Leads', 'leads', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Leads', 0, 0),
('b9a4a063-42a4-428c-b1e7-6e87f2d2c344', 'surveyresponses_created_by', 'Users', 'users', 'id', 'SurveyResponses', 'surveyresponses', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('bb447652-6623-4369-8a64-d33eaaa9e461', 'roles_users', 'Roles', 'roles', 'id', 'Users', 'users', 'id', 'roles_users', 'role_id', 'user_id', 'many-to-many', NULL, NULL, 0, 0),
('bb8ff410-d0b4-43fd-b5fb-a6b9903031db', 'project_tasks_tasks', 'ProjectTask', 'project_task', 'id', 'Tasks', 'tasks', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'ProjectTask', 0, 0),
('bb94e3c3-147b-47d0-ad10-b74f4eab15ff', 'aow_processed_aow_actions', 'AOW_Processed', 'aow_processed', 'id', 'AOW_Actions', 'aow_actions', 'id', 'aow_processed_aow_actions', 'aow_processed_id', 'aow_action_id', 'many-to-many', NULL, NULL, 0, 0),
('bbc0e286-d859-4026-acb4-169902ab29e9', 'outbound_email_modified_user', 'Users', 'users', 'id', 'OutboundEmailAccounts', 'outbound_email', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('bbc4b9ef-c669-4eab-ad2a-ed466414d92e', 'projects_bugs', 'Project', 'project', 'id', 'Bugs', 'bugs', 'id', 'projects_bugs', 'project_id', 'bug_id', 'many-to-many', NULL, NULL, 0, 0),
('bc7a1a0d-c9a0-4f5f-9670-818ceb6cc839', 'securitygroups_notes', 'SecurityGroups', 'securitygroups', 'id', 'Notes', 'notes', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Notes', 0, 0),
('bd94c699-edc3-4b63-bc2d-b22f1ffd233d', 'opportunities_contacts', 'Opportunities', 'opportunities', 'id', 'Contacts', 'contacts', 'id', 'opportunities_contacts', 'opportunity_id', 'contact_id', 'many-to-many', NULL, NULL, 0, 0),
('bdb4d387-e164-44f4-ac8d-0b979e0dbd8a', 'calls_contacts', 'Calls', 'calls', 'id', 'Contacts', 'contacts', 'id', 'calls_contacts', 'call_id', 'contact_id', 'many-to-many', NULL, NULL, 0, 0),
('bec39518-bd1f-4754-a453-954b5c8a3b70', 'jjwg_address_cache_modified_user', 'Users', 'users', 'id', 'jjwg_Address_Cache', 'jjwg_address_cache', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('bed6c6ba-3526-43f2-9a60-66f60e40e93a', 'leads_email_addresses', 'Leads', 'leads', 'id', 'EmailAddresses', 'email_addresses', 'id', 'email_addr_bean_rel', 'bean_id', 'email_address_id', 'many-to-many', 'bean_module', 'Leads', 0, 0),
('bf458a5b-64e2-4d63-8078-b42c87539e9a', 'fp_event_locations_modified_user', 'Users', 'users', 'id', 'FP_Event_Locations', 'fp_event_locations', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('bfb5f287-aad1-40f5-a0c2-1625aa2ac73a', 'opportunity_meetings', 'Opportunities', 'opportunities', 'id', 'Meetings', 'meetings', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Opportunities', 0, 0),
('c0982c04-a859-4153-9c94-f49d44026c07', 'bugs_fixed_in_release', 'Releases', 'releases', 'id', 'Bugs', 'bugs', 'fixed_in_release', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('c0e1bf4e-516f-4a1a-8e45-257dbdb11fbb', 'meetings_leads', 'Meetings', 'meetings', 'id', 'Leads', 'leads', 'id', 'meetings_leads', 'meeting_id', 'lead_id', 'many-to-many', NULL, NULL, 0, 0),
('c1047598-04be-4a2a-baaa-307678718077', 'jjwg_Maps_cases', 'jjwg_Maps', 'jjwg_Maps', 'parent_id', 'Cases', 'cases', 'id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Cases', 0, 0),
('c189279d-cbef-4534-800b-087395a1f616', 'am_tasktemplates_modified_user', 'Users', 'users', 'id', 'AM_TaskTemplates', 'am_tasktemplates', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('c19a4f85-6fc1-449c-8d96-f49cf592426e', 'meetings_created_by', 'Users', 'users', 'id', 'Meetings', 'meetings', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('c27d790b-1a7b-4aa9-9d49-f2a97e6babc0', 'accounts_modified_user', 'Users', 'users', 'id', 'Accounts', 'accounts', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('c2bbcedf-e5d9-4461-9580-a2cb957064c6', 'securitygroups_aow_workflow', 'SecurityGroups', 'securitygroups', 'id', 'AOW_WorkFlow', 'aow_workflow', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'AOW_WorkFlow', 0, 0),
('c2ef6e6a-d508-405d-8972-b9cbf14fa47c', 'project_tasks_modified_user', 'Users', 'users', 'id', 'ProjectTask', 'project_task', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('c2f78387-81cf-4233-a445-f9594638c777', 'meetings_users', 'Meetings', 'meetings', 'id', 'Users', 'users', 'id', 'meetings_users', 'meeting_id', 'user_id', 'many-to-many', NULL, NULL, 0, 0),
('c31d95b4-3a88-4f6e-8871-72eeaf6f8c48', 'leads_assigned_user', 'Users', 'users', 'id', 'Leads', 'leads', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('c367c2f0-c3c1-48c2-9b8f-227bbb587ec3', 'project_contacts_1', 'Project', 'project', 'id', 'Contacts', 'contacts', 'id', 'project_contacts_1_c', 'project_contacts_1project_ida', 'project_contacts_1contacts_idb', 'many-to-many', NULL, NULL, 0, 0),
('c3e00bf2-efb5-4b18-8f2c-7ca048fab318', 'fp_event_locations_fp_events_1', 'FP_Event_Locations', 'fp_event_locations', 'id', 'FP_events', 'fp_events', 'id', 'fp_event_locations_fp_events_1_c', 'fp_event_locations_fp_events_1fp_event_locations_ida', 'fp_event_locations_fp_events_1fp_events_idb', 'many-to-many', NULL, NULL, 0, 0),
('c49b9309-7d3c-4f6f-924b-7010d641bba5', 'aod_indexevent_created_by', 'Users', 'users', 'id', 'AOD_IndexEvent', 'aod_indexevent', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('c4d3b9bb-9cec-4c79-80e7-4ad872389304', 'prospect_list_contacts', 'ProspectLists', 'prospect_lists', 'id', 'Contacts', 'contacts', 'id', 'prospect_lists_prospects', 'prospect_list_id', 'related_id', 'many-to-many', 'related_type', 'Contacts', 0, 0),
('c53748ab-6bf8-4a02-a34d-0e55fb2bf5e3', 'favorites_assigned_user', 'Users', 'users', 'id', 'Favorites', 'favorites', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('c58336b3-d762-4f61-9e01-fff35ccb0073', 'securitygroups_projecttask', 'SecurityGroups', 'securitygroups', 'id', 'ProjectTask', 'project_task', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'ProjectTask', 0, 0),
('c59857d1-1951-475e-ad43-3d479dc785c1', 'calls_modified_user', 'Users', 'users', 'id', 'Calls', 'calls', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('c6256587-85e5-4380-9973-a053ac778ff3', 'contact_campaign_log', 'Contacts', 'contacts', 'id', 'CampaignLog', 'campaign_log', 'target_id', NULL, NULL, NULL, 'one-to-many', 'target_type', 'Contacts', 0, 0),
('c6c3a17a-9d25-4cc8-a91b-07f69f56d078', 'sugarfeed_modified_user', 'Users', 'users', 'id', 'SugarFeed', 'sugarfeed', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('c6eae121-b762-441d-9bf8-f6b446de6520', 'aop_case_events_assigned_user', 'Users', 'users', 'id', 'AOP_Case_Events', 'aop_case_events', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('c7355fb1-a101-4824-9070-e8f3fbdaae76', 'emails_cases_rel', 'Emails', 'emails', 'id', 'Cases', 'cases', 'id', 'emails_beans', 'email_id', 'bean_id', 'many-to-many', 'bean_module', 'Cases', 0, 0),
('c82f30dd-3d59-470a-b689-7e58e642f7d3', 'documents_modified_user', 'Users', 'users', 'id', 'Documents', 'documents', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('c86e71e7-7333-442e-a1af-fccf6c56f281', 'am_projecttemplates_users_1', 'AM_ProjectTemplates', 'am_projecttemplates', 'id', 'Users', 'users', 'id', 'am_projecttemplates_users_1_c', 'am_projecttemplates_ida', 'users_idb', 'many-to-many', NULL, NULL, 0, 0),
('caa0a429-2742-438a-9e1d-8feecfb46722', 'aop_case_events_created_by', 'Users', 'users', 'id', 'AOP_Case_Events', 'aop_case_events', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('cab3e864-e26f-41e0-a6fa-ca9ed1929181', 'reminders_assigned_user', 'Users', 'users', 'id', 'Reminders', 'reminders', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('cabe3175-117c-48e3-8f9c-a1b8b458b293', 'aop_case_updates_assigned_user', 'Users', 'users', 'id', 'AOP_Case_Updates', 'aop_case_updates', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('caf113a4-dc2c-4195-9d14-2bcefb45d617', 'aos_product_categories_created_by', 'Users', 'users', 'id', 'AOS_Product_Categories', 'aos_product_categories', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('cb0e4ea5-63db-4fbc-8d86-06ef524cb639', 'case_emails', 'Cases', 'cases', 'id', 'Emails', 'emails', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Cases', 0, 0),
('cb8efa2c-0772-4f07-acb9-cd46f18ee096', 'oauthtokens_assigned_user', 'Users', 'users', 'id', 'OAuthTokens', 'oauth_tokens', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('cba96c3c-50cb-4cad-9227-cbb6daa9072f', 'outbound_email_created_by', 'Users', 'users', 'id', 'OutboundEmailAccounts', 'outbound_email', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('cc06a5d2-f5ca-42c0-8dc3-f9f86e73b936', 'campaign_modified_user', 'Users', 'users', 'id', 'Campaigns', 'campaigns', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('ccbdedd2-2aef-40d2-ac07-2db8872842be', 'aor_reports_assigned_user', 'Users', 'users', 'id', 'AOR_Reports', 'aor_reports', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('cd0864d0-8fe1-4d76-9ef0-70a68fd6e99f', 'surveyquestionoptions_surveyquestionresponses', 'SurveyQuestionOptions', 'surveyquestionoptions', 'id', 'SurveyQuestionResponses', 'surveyquestionresponses', 'id', 'surveyquestionoptions_surveyquestionresponses', 'surveyq72c7options_ida', 'surveyq10d4sponses_idb', 'many-to-many', NULL, NULL, 0, 0),
('cd9f883b-1dc7-40fa-97b8-fee61b03fac1', 'reminders_created_by', 'Users', 'users', 'id', 'Reminders', 'reminders', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('cde82588-a80b-4165-90d6-ed01646d2889', 'accounts_contacts', 'Accounts', 'accounts', 'id', 'Contacts', 'contacts', 'id', 'accounts_contacts', 'account_id', 'contact_id', 'many-to-many', NULL, NULL, 0, 0),
('cf68860a-2142-4eac-a29a-cc88b7b4cca5', 'campaigns_modified_user', 'Users', 'users', 'id', 'Campaigns', 'campaigns', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('cf871160-3986-46a8-a8ae-c1ab4172579d', 'opportunity_notes', 'Opportunities', 'opportunities', 'id', 'Notes', 'notes', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Opportunities', 0, 0),
('cf932bf0-c1de-4866-b4f1-5a0375d959dc', 'securitygroups_prospectlists', 'SecurityGroups', 'securitygroups', 'id', 'ProspectLists', 'prospect_lists', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'ProspectLists', 0, 0),
('cfd082bd-0ba9-4306-a676-d783cc9dfe90', 'inbound_outbound_email_accounts', 'OutboundEmailAccounts', 'outbound_email', 'id', 'InboundEmail', 'inbound_email', 'outbound_email_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('d2cfbf8f-7f2b-4ece-8f11-60383ab16771', 'aop_case_updates_created_by', 'Users', 'users', 'id', 'AOP_Case_Updates', 'aop_case_updates', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('d3571c5c-3543-414b-a457-4ef803d6af92', 'securitygroups_externaloauthprovider', 'SecurityGroups', 'securitygroups', 'id', 'ExternalOAuthProvider', 'external_oauth_providers', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'ExternalOAuthProvider', 0, 0),
('d4e55e17-0beb-4d22-93e3-c6dd786c47b9', 'aor_reports_modified_user', 'Users', 'users', 'id', 'AOR_Reports', 'aor_reports', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('d580f900-0589-483c-8463-e1513d21b1a6', 'lead_direct_reports', 'Leads', 'leads', 'id', 'Leads', 'leads', 'reports_to_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('d5c1be0a-edbd-43c5-a15f-4689f18f5c29', 'securitygroups_externaloauthconnection', 'SecurityGroups', 'securitygroups', 'id', 'ExternalOAuthConnection', 'external_oauth_connections', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'ExternalOAuthConnection', 0, 0),
('d6977b6c-dd5e-439c-a8c9-dee950e6390f', 'projects_emails', 'Project', 'project', 'id', 'Emails', 'emails', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Project', 0, 0),
('d6b867c3-6b84-4f63-9dff-8b7eb8bed482', 'securitygroups_aor_reports', 'SecurityGroups', 'securitygroups', 'id', 'AOR_Reports', 'aor_reports', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'AOR_Reports', 0, 0),
('d79fe876-9193-4451-b0bf-687771197f33', 'prospects_email_addresses_primary', 'Prospects', 'prospects', 'id', 'EmailAddresses', 'email_addresses', 'id', 'email_addr_bean_rel', 'bean_id', 'email_address_id', 'many-to-many', 'primary_address', '1', 0, 0),
('d8a7de1b-8362-4243-9fa8-0efa6c93b5e6', 'securitygroups_prospects', 'SecurityGroups', 'securitygroups', 'id', 'Prospects', 'prospects', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'Prospects', 0, 0),
('d9c0fb14-28d8-4044-82c2-0d721a534536', 'bug_emails', 'Bugs', 'bugs', 'id', 'Emails', 'emails', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Bugs', 0, 0),
('d9c57bcc-bc30-4e4a-b8cc-f99f6dc7018a', 'am_projecttemplates_created_by', 'Users', 'users', 'id', 'AM_ProjectTemplates', 'am_projecttemplates', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('daa6d9ad-4395-40dd-90f7-49f9fbdbe055', 'oauth2clients_assigned_user', 'Users', 'users', 'id', 'OAuth2Clients', 'oauth2clients', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('dabb4d7c-f094-4332-ad47-ea98037c2e2c', 'securitygroups_calendaraccount', 'SecurityGroups', 'securitygroups', 'id', 'CalendarAccount', 'calendar_accounts', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'CalendarAccount', 0, 0),
('db2fc0b1-2ed1-42d8-b345-860bdea9af7e', 'aos_pdf_templates_created_by', 'Users', 'users', 'id', 'AOS_PDF_Templates', 'aos_pdf_templates', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('db5e55c1-ed1b-4598-b555-00117f83414d', 'surveyresponses_contacts', 'Contacts', 'contacts', 'id', 'SurveyResponses', 'surveyresponses', 'contact_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('db803f79-34e3-4282-9de5-6fc337b08d43', 'securitygroups_surveyquestions', 'SecurityGroups', 'securitygroups', 'id', 'SurveyQuestions', 'surveyquestions', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'SurveyQuestions', 0, 0),
('dba1d7d3-ad06-4d3e-9a37-bb5626b19992', 'aobh_businesshours_created_by', 'Users', 'users', 'id', 'AOBH_BusinessHours', 'aobh_businesshours', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('dc18f50d-4c07-4136-ac82-f855dd2d7304', 'prospect_list_leads', 'ProspectLists', 'prospect_lists', 'id', 'Leads', 'leads', 'id', 'prospect_lists_prospects', 'prospect_list_id', 'related_id', 'many-to-many', 'related_type', 'Leads', 0, 0),
('dc26327b-df0e-41d0-8165-3897122a9e8e', 'meetings_notes', 'Meetings', 'meetings', 'id', 'Notes', 'notes', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Meetings', 0, 0),
('dc38e511-540b-4549-9dfa-f4b5a5ab6112', 'oauth2authcodes_assigned_user', 'Users', 'users', 'id', 'OAuth2AuthCodes', 'oauth2authcodes', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('ddf2e717-2bf7-42bb-b1e8-4452efcfe7d7', 'jjwg_maps_jjwg_markers', 'jjwg_Maps', 'jjwg_maps', 'id', 'jjwg_Markers', 'jjwg_markers', 'id', 'jjwg_maps_jjwg_markers_c', 'jjwg_maps_b229wg_maps_ida', 'jjwg_maps_2e31markers_idb', 'many-to-many', NULL, NULL, 0, 0),
('de9b91c0-fd63-4ae1-a125-8c73fbbfab07', 'opportunities_modified_user', 'Users', 'users', 'id', 'Opportunities', 'opportunities', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('df6613bb-200d-41c6-a9b7-c8fb13f0b366', 'surveyresponses_modified_user', 'Users', 'users', 'id', 'SurveyResponses', 'surveyresponses', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('dfec6fb1-bb00-44ba-be49-a8ef9e97881a', 'aok_knowledge_base_categories_assigned_user', 'Users', 'users', 'id', 'AOK_Knowledge_Base_Categories', 'aok_knowledge_base_categories', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('e06d3369-57e6-4180-b76b-1b34214dfcad', 'leads_created_by', 'Users', 'users', 'id', 'Leads', 'leads', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('e0c1d613-214f-442e-adc1-82b79abe8bce', 'emails_meetings_rel', 'Emails', 'emails', 'id', 'Meetings', 'meetings', 'id', 'emails_beans', 'email_id', 'bean_id', 'many-to-many', 'bean_module', 'Meetings', 0, 0),
('e0d98346-8eea-490c-ac22-7fd5625490fe', 'aos_products_quotes_created_by', 'Users', 'users', 'id', 'AOS_Products_Quotes', 'aos_products_quotes', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('e0f48e74-a0fb-4254-b032-54ebd5a9489a', 'member_accounts', 'Accounts', 'accounts', 'id', 'Accounts', 'accounts', 'parent_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('e1c9c0df-1421-42be-b730-a84da919c13d', 'campaign_prospects', 'Campaigns', 'campaigns', 'id', 'Prospects', 'prospects', 'campaign_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('e1eae416-c2d2-4498-8c20-d44c2fa6ca28', 'opportunity_calls', 'Opportunities', 'opportunities', 'id', 'Calls', 'calls', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Opportunities', 0, 0),
('e2306e9c-e30a-44b8-8de6-b4ec249e6819', 'projects_tasks', 'Project', 'project', 'id', 'Tasks', 'tasks', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Project', 0, 0),
('e27dd53b-ef6f-495c-94cc-843e6e7f1557', 'surveyresponses_accounts', 'Accounts', 'accounts', 'id', 'SurveyResponses', 'surveyresponses', 'account_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('e2a23473-6a13-4fb1-85bd-4029248bb86f', 'prospect_list_campaigns', 'ProspectLists', 'prospect_lists', 'id', 'Campaigns', 'campaigns', 'id', 'prospect_list_campaigns', 'prospect_list_id', 'campaign_id', 'many-to-many', NULL, NULL, 0, 0),
('e2faf4c8-396b-4b30-aa44-d4914bac2c2b', 'aow_actions_created_by', 'Users', 'users', 'id', 'AOW_Actions', 'aow_actions', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('e3039b4d-bcf8-4979-8253-1a005d146655', 'externaloauthconnection_created_by', 'Users', 'users', 'id', 'ExternalOAuthConnection', 'external_oauth_connections', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('e36f9fcd-7cd9-4225-965f-e356a6f4bab8', 'projects_created_by', 'Users', 'users', 'id', 'Project', 'project', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('e578855e-8803-4fb2-9040-7def3e44442e', 'am_projecttemplates_assigned_user', 'Users', 'users', 'id', 'AM_ProjectTemplates', 'am_projecttemplates', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('e697e4f2-f100-47e6-b6d8-28a606effb25', 'spots_assigned_user', 'Users', 'users', 'id', 'Spots', 'spots', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('e6dc18fa-8688-4d7c-8a02-5df4af78cfab', 'campaign_email_marketing', 'Campaigns', 'campaigns', 'id', 'EmailMarketing', 'email_marketing', 'campaign_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('e7841a31-bc54-417c-96a1-ce85ee19db94', 'spots_modified_user', 'Users', 'users', 'id', 'Spots', 'spots', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('e7f3fb83-7cf5-425d-a3a1-fd052889023a', 'emails_prospects_rel', 'Emails', 'emails', 'id', 'Prospects', 'prospects', 'id', 'emails_beans', 'email_id', 'bean_id', 'many-to-many', 'bean_module', 'Prospects', 0, 0),
('e8214f1c-cc40-4c30-acd4-3cd3f7813b26', 'aok_knowledge_base_categories_modified_user', 'Users', 'users', 'id', 'AOK_Knowledge_Base_Categories', 'aok_knowledge_base_categories', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('ea274342-4fd1-4458-886d-3e8ea642e7b7', 'emails_accounts_rel', 'Emails', 'emails', 'id', 'Accounts', 'accounts', 'id', 'emails_beans', 'email_id', 'bean_id', 'many-to-many', 'bean_module', 'Accounts', 0, 0),
('eb8f6058-756b-4ba6-bea4-ef151160afc2', 'jjwg_areas_modified_user', 'Users', 'users', 'id', 'jjwg_Areas', 'jjwg_areas', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('ebeac41e-be96-4951-953e-c3dcc35f48b6', 'lead_tasks', 'Leads', 'leads', 'id', 'Tasks', 'tasks', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Leads', 0, 0),
('ec729366-fd05-445d-b2b6-3de1b403726b', 'am_tasktemplates_assigned_user', 'Users', 'users', 'id', 'AM_TaskTemplates', 'am_tasktemplates', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('ed55cd79-5483-429b-84f4-682a4b8b60a0', 'aor_fields_modified_user', 'Users', 'users', 'id', 'AOR_Fields', 'aor_fields', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('ee4b4cf6-8e76-495d-a143-e398498649c2', 'opportunities_campaign', 'Campaigns', 'campaigns', 'id', 'Opportunities', 'opportunities', 'campaign_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('ef0f965b-feeb-451b-901a-517e285041fe', 'aos_products_assigned_user', 'Users', 'users', 'id', 'AOS_Products', 'aos_products', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('ef3db8f3-7f7b-467e-9de0-55cef59a0247', 'aow_workflow_aow_processed', 'AOW_WorkFlow', 'aow_workflow', 'id', 'AOW_Processed', 'aow_processed', 'aow_workflow_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('efcac1cf-3a2e-4c0f-a3f6-0e75fb86c2fd', 'contact_aos_contracts', 'Contacts', 'contacts', 'id', 'AOS_Contracts', 'aos_contracts', 'contact_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('f18616aa-86d4-4ba2-b842-ab610b781c33', 'aow_actions_modified_user', 'Users', 'users', 'id', 'AOW_Actions', 'aow_actions', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('f239fa9a-5781-4584-b463-cd5433c4cd54', 'aor_scheduled_reports_modified_user', 'Users', 'users', 'id', 'AOR_Scheduled_Reports', 'aor_scheduled_reports', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('f270a2e5-854d-44e3-bf86-244288417f56', 'prospect_list_prospects', 'ProspectLists', 'prospect_lists', 'id', 'Prospects', 'prospects', 'id', 'prospect_lists_prospects', 'prospect_list_id', 'related_id', 'many-to-many', 'related_type', 'Prospects', 0, 0),
('f2da5b64-f3cc-4193-97ab-648ea9a7d442', 'aow_workflow_created_by', 'Users', 'users', 'id', 'AOW_WorkFlow', 'aow_workflow', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('f339a33f-02c1-4303-a960-a5cd629dc9a7', 'campaign_notes', 'Campaigns', 'campaigns', 'id', 'Notes', 'notes', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Campaigns', 0, 0),
('f3aede97-c047-43b6-bdbb-5aa239c9e2ce', 'emails_modified_user', 'Users', 'users', 'id', 'Emails', 'emails', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('f3eb7799-811e-40be-a196-0f7d1d3750eb', 'contact_tasks', 'Contacts', 'contacts', 'id', 'Tasks', 'tasks', 'contact_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('f4f6e9f7-eab7-4fb5-8475-60e9046da5b2', 'lead_campaign_log', 'Leads', 'leads', 'id', 'CampaignLog', 'campaign_log', 'target_id', NULL, NULL, NULL, 'one-to-many', 'target_type', 'Leads', 0, 0),
('f503d309-91b9-4325-9ed2-61ed546c9eed', 'bug_notes', 'Bugs', 'bugs', 'id', 'Notes', 'notes', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Bugs', 0, 0),
('f78e9c66-03f1-45e8-89b6-1a928fd7615b', 'accounts_email_addresses_primary', 'Accounts', 'accounts', 'id', 'EmailAddresses', 'email_addresses', 'id', 'email_addr_bean_rel', 'bean_id', 'email_address_id', 'many-to-many', 'primary_address', '1', 0, 0),
('f7eaca51-6ddd-49f5-98b4-f5cb15aba029', 'aos_contracts_documents', 'AOS_Contracts', 'aos_contracts', 'id', 'Documents', 'documents', 'id', 'aos_contracts_documents', 'aos_contracts_id', 'documents_id', 'many-to-many', NULL, NULL, 0, 0),
('f84ce55b-beff-489d-9834-194203dd6da7', 'projects_cases', 'Project', 'project', 'id', 'Cases', 'cases', 'id', 'projects_cases', 'project_id', 'case_id', 'many-to-many', NULL, NULL, 0, 0),
('f859cd62-b3ee-468b-b994-325d0d0dfd02', 'aow_workflow_modified_user', 'Users', 'users', 'id', 'AOW_WorkFlow', 'aow_workflow', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('f899cbb1-4bfb-4099-b5e4-1cfdc33cd871', 'campaign_accounts', 'Campaigns', 'campaigns', 'id', 'Accounts', 'accounts', 'campaign_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0);
INSERT INTO `relationships` VALUES
('f8ae1262-80ee-4e1e-b387-c819eb38f010', 'aos_invoices_aos_line_item_groups', 'AOS_Invoices', 'aos_invoices', 'id', 'AOS_Line_Item_Groups', 'aos_line_item_groups', 'parent_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('f90f9f80-db0a-45c0-bd7c-69c20e320a75', 'prospect_emails', 'Prospects', 'prospects', 'id', 'Emails', 'emails', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Prospects', 0, 0),
('fa161297-1aac-49c9-abf6-06e3344b292a', 'accounts_created_by', 'Users', 'users', 'id', 'Accounts', 'accounts', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('fabd4ce8-2101-4927-915e-a88b6d1fe3d7', 'prospect_calls', 'Prospects', 'prospects', 'id', 'Calls', 'calls', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Prospects', 0, 0),
('faebca1f-a560-4e43-9207-ad97d04b2234', 'calendar_account_meetings', 'CalendarAccount', 'calendar_accounts', 'id', 'Meetings', 'meetings', 'id', 'calendar_account_meetings', 'calendar_account_id', 'meeting_id', 'one-to-many', NULL, NULL, 0, 0),
('fb440319-bd8d-4bca-907c-460c05472b44', 'calls_leads', 'Calls', 'calls', 'id', 'Leads', 'leads', 'id', 'calls_leads', 'call_id', 'lead_id', 'many-to-many', NULL, NULL, 0, 0),
('fb7f4f0a-29de-48ea-90b8-cd9ddcd370d3', 'aos_contracts_calls', 'AOS_Contracts', 'aos_contracts', 'id', 'Calls', 'calls', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'AOS_Contracts', 0, 0),
('fce6fbd6-7bae-436c-bff1-ca5e5c4f397f', 'bug_tasks', 'Bugs', 'bugs', 'id', 'Tasks', 'tasks', 'parent_id', NULL, NULL, NULL, 'one-to-many', 'parent_type', 'Bugs', 0, 0),
('fd9407ac-6daa-4cc1-b648-6b3a40ee00cf', 'fp_events_created_by', 'Users', 'users', 'id', 'FP_events', 'fp_events', 'created_by', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('fdb01cc3-16ab-489f-8245-346b5153a7d0', 'securitygroups_aos_products', 'SecurityGroups', 'securitygroups', 'id', 'AOS_Products', 'aos_products', 'id', 'securitygroups_records', 'securitygroup_id', 'record_id', 'many-to-many', 'module', 'AOS_Products', 0, 0),
('fe203643-071d-4f20-bc44-cfc806e62568', 'documents_assigned_user', 'Users', 'users', 'id', 'Documents', 'documents', 'assigned_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0),
('fec9a35b-dab1-48ce-b9e5-b54b2ffe29f7', 'alerts_modified_user', 'Users', 'users', 'id', 'Alerts', 'alerts', 'modified_user_id', NULL, NULL, NULL, 'one-to-many', NULL, NULL, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `releases`
--

CREATE TABLE `releases` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `list_order` int DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_releases` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `reminders`
--

CREATE TABLE `reminders` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `popup` tinyint(1) DEFAULT NULL,
  `email` tinyint(1) DEFAULT NULL,
  `email_sent` tinyint(1) DEFAULT NULL,
  `timer_popup` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `timer_email` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `related_event_module` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `related_event_module_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_willexecute` int DEFAULT '-1',
  `popup_viewed` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_reminder_name` (`name`),
  KEY `idx_reminder_deleted` (`deleted`),
  KEY `idx_reminder_related_event_module` (`related_event_module`),
  KEY `idx_reminder_related_event_module_id` (`related_event_module_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `reminders_invitees`
--

CREATE TABLE `reminders_invitees` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reminder_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `related_invitee_module` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `related_invitee_module_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_reminder_invitee_name` (`name`),
  KEY `idx_reminder_invitee_assigned_user_id` (`assigned_user_id`),
  KEY `idx_reminder_invitee_reminder_id` (`reminder_id`),
  KEY `idx_reminder_invitee_related_invitee_module` (`related_invitee_module`),
  KEY `idx_reminder_invitee_related_invitee_module_id` (`related_invitee_module_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

CREATE TABLE `roles` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `modules` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_role_id_del` (`id`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `roles_modules`
--

CREATE TABLE `roles_modules` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `role_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `module_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `allow` tinyint(1) DEFAULT '0',
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_role_id` (`role_id`),
  KEY `idx_module_id` (`module_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `roles_users`
--

CREATE TABLE `roles_users` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `role_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_ru_role_id` (`role_id`),
  KEY `idx_ru_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `saved_search`
--

CREATE TABLE `saved_search` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `search_module` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contents` text COLLATE utf8mb4_general_ci,
  `description` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_desc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `schedulers`
--

CREATE TABLE `schedulers` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `job` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_time_start` datetime DEFAULT NULL,
  `date_time_end` datetime DEFAULT NULL,
  `job_interval` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `time_from` time DEFAULT NULL,
  `time_to` time DEFAULT NULL,
  `last_run` datetime DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `catch_up` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_schedule` (`date_time_start`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `schedulers`
--

INSERT INTO `schedulers` VALUES
('01440ccc-94fc-46b3-99b3-c590e0e19c56', 0, '[[regtime]]', '[[regtime]]', '1', '1', 'Perform Elasticsearch Index', 'function::runElasticSearchIndexerScheduler', '2015-01-01 07:45:01', NULL, '30::4::*::*::*', NULL, NULL, NULL, 'Active', 0),
('063cf19a-88ab-42a8-8635-0ce456a85ab1', 0, '[[regtime]]', '[[regtime]]', '1', '1', 'Perform Lucene Index', 'function::aodIndexUnindexed', '2015-01-01 08:00:01', NULL, '0::0::*::*::*', NULL, NULL, NULL, 'Active', 0),
('38ffe539-129d-4dd6-8195-31310db15343', 0, '[[regtime]]', '[[regtime]]', '1', '1', 'Prune SuiteCRM Feed Tables', 'function::trimSugarFeeds', '2015-01-01 06:00:01', NULL, '0::2::1::*::*', NULL, NULL, NULL, 'Active', 1),
('390af865-fc87-4013-bf01-b91e776ee250', 0, '[[regtime]]', '[[regtime]]', '1', '1', 'Run Nightly Process Bounced Campaign Emails', 'function::pollMonitoredInboxesForBouncedCampaignEmails', '2015-01-01 16:00:01', NULL, '0::2-6::*::*::*', NULL, NULL, NULL, 'Active', 1),
('415c521f-4041-43b5-85d9-9bbd7b4395a4', 0, '[[regtime]]', '[[regtime]]', '1', '1', 'Process Workflow Tasks', 'function::processAOW_Workflow', '2015-01-01 16:45:01', NULL, '*::*::*::*::*', NULL, NULL, NULL, 'Active', 1),
('50f1b981-de69-4f92-9197-ca49ca32df5d', 0, '[[regtime]]', '[[regtime]]', '1', '1', 'Check Inbound Mailboxes', 'function::pollMonitoredInboxesAOP', '2015-01-01 17:45:01', NULL, '*::*::*::*::*', NULL, NULL, NULL, 'Active', 0),
('64245338-be7f-476e-a5fd-7a6e45b1b5db', 0, '[[regtime]]', '[[regtime]]', '1', '1', 'Run Nightly Mass Email Campaigns', 'function::runMassEmailCampaign', '2015-01-01 12:45:01', NULL, '0::2-6::*::*::*', NULL, NULL, NULL, 'Active', 1),
('6af7838f-80f8-4e4a-8569-3ee69d6dd5d3', 0, '[[regtime]]', '[[regtime]]', '1', '1', 'Prune Tracker Tables', 'function::trimTracker', '2015-01-01 11:15:01', NULL, '0::2::1::*::*', NULL, NULL, NULL, 'Active', 1),
('7844749b-80da-4688-b4a7-06b70c1dc2eb', 0, '[[regtime]]', '[[regtime]]', '1', '1', 'Optimise AOD Index', 'function::aodOptimiseIndex', '2015-01-01 17:15:01', NULL, '0::*/3::*::*::*', NULL, NULL, NULL, 'Active', 0),
('93608e1c-e43c-45fb-9e63-d14a3304d373', 0, '[[regtime]]', '[[regtime]]', '1', '1', 'Clean Jobs Queue', 'function::cleanJobQueue', '2015-01-01 16:15:01', NULL, '0::5::*::*::*', NULL, NULL, NULL, 'Active', 0),
('ac094a0a-f19d-4824-a9a1-3355a14af80f', 0, '[[regtime]]', '[[regtime]]', '1', '1', 'Removal of documents from filesystem', 'function::removeDocumentsFromFS', '2015-01-01 11:45:01', NULL, '0::3::1::*::*', NULL, NULL, NULL, 'Active', 0),
('ac808feb-6993-4c13-be35-bcea3dfa9235', 0, '[[regtime]]', '[[regtime]]', '1', '1', 'Run Email Reminder Notifications', 'function::sendEmailReminders', '2015-01-01 13:30:01', NULL, '*::*::*::*::*', NULL, NULL, NULL, 'Active', 0),
('e348b0f6-1db1-4d46-bbd9-c3ab56d7de1c', 0, '[[regtime]]', '[[regtime]]', '1', '1', 'Prune Database on 1st of Month', 'function::pruneDatabase', '2015-01-01 07:45:01', NULL, '0::4::1::*::*', NULL, NULL, NULL, 'Inactive', 0),
('ef046386-d146-4017-8cad-2fc10ff88bee', 0, '[[regtime]]', '[[regtime]]', '1', '1', 'Run Report Generation Scheduled Tasks', 'function::aorRunScheduledReports', '2015-01-01 08:45:01', NULL, '*::*::*::*::*', NULL, NULL, NULL, 'Active', 1),
('f9d13d6f-a768-4056-b371-7713e162f94c', 0, '[[regtime]]', '[[regtime]]', '1', '1', 'Calendar Accounts Sync', 'function::calendarSyncJob', '2015-01-01 16:45:01', NULL, '*/15::*::*::*::*', NULL, NULL, NULL, 'Active', 0);

-- --------------------------------------------------------

--
-- Table structure for table `securitygroups`
--

CREATE TABLE `securitygroups` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `noninheritable` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `securitygroups_acl_roles`
--

CREATE TABLE `securitygroups_acl_roles` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `securitygroup_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `role_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `securitygroups_audit`
--

CREATE TABLE `securitygroups_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_securitygroups_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `securitygroups_default`
--

CREATE TABLE `securitygroups_default` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `securitygroup_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `module` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `securitygroups_records`
--

CREATE TABLE `securitygroups_records` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `securitygroup_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `record_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `module` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_securitygroups_records_mod` (`module`,`deleted`,`record_id`,`securitygroup_id`),
  KEY `idx_securitygroups_records_del` (`deleted`,`record_id`,`module`,`securitygroup_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `securitygroups_users`
--

CREATE TABLE `securitygroups_users` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `securitygroup_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `primary_group` tinyint(1) DEFAULT NULL,
  `noninheritable` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `securitygroups_users_idxa` (`securitygroup_id`),
  KEY `securitygroups_users_idxb` (`user_id`),
  KEY `securitygroups_users_idxc` (`user_id`,`deleted`,`securitygroup_id`,`id`),
  KEY `securitygroups_users_idxd` (`user_id`,`deleted`,`securitygroup_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `spots`
--

CREATE TABLE `spots` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `config` longtext COLLATE utf8mb4_general_ci,
  `type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sugarfeed`
--

CREATE TABLE `sugarfeed` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `related_module` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `related_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `link_url` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `link_type` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sgrfeed_date` (`date_entered`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `surveyquestionoptions`
--

CREATE TABLE `surveyquestionoptions` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `sort_order` int DEFAULT NULL,
  `survey_question_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `surveyquestionoptions_audit`
--

CREATE TABLE `surveyquestionoptions_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_surveyquestionoptions_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `surveyquestionoptions_surveyquestionresponses`
--

CREATE TABLE `surveyquestionoptions_surveyquestionresponses` (
  `id` varchar(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `surveyq72c7options_ida` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `surveyq10d4sponses_idb` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `surveyquestionoptions_surveyquestionresponses_alt` (`surveyq72c7options_ida`,`surveyq10d4sponses_idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `surveyquestionresponses`
--

CREATE TABLE `surveyquestionresponses` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `answer` text COLLATE utf8mb4_general_ci,
  `answer_bool` tinyint(1) DEFAULT NULL,
  `answer_datetime` datetime DEFAULT NULL,
  `surveyquestion_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `surveyresponse_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `surveyquestionresponses_audit`
--

CREATE TABLE `surveyquestionresponses_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_surveyquestionresponses_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `surveyquestions`
--

CREATE TABLE `surveyquestions` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `sort_order` int DEFAULT NULL,
  `type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `happiness_question` tinyint(1) DEFAULT NULL,
  `survey_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `surveyquestions_audit`
--

CREATE TABLE `surveyquestions_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_surveyquestions_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `surveyresponses`
--

CREATE TABLE `surveyresponses` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `happiness` int DEFAULT NULL,
  `email_response_sent` tinyint(1) DEFAULT NULL,
  `account_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `campaign_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contact_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `survey_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `surveyresponses_audit`
--

CREATE TABLE `surveyresponses_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_surveyresponses_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `surveys`
--

CREATE TABLE `surveys` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'LBL_DRAFT',
  `submit_text` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'Submit',
  `satisfied_text` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'Satisfied',
  `neither_text` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'Neither Satisfied nor Dissatisfied',
  `dissatisfied_text` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'Dissatisfied',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `surveys_audit`
--

CREATE TABLE `surveys_audit` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `after_value_string` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `before_value_text` text COLLATE utf8mb4_general_ci,
  `after_value_text` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_surveys_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tasks`
--

CREATE TABLE `tasks` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT 'Not Started',
  `date_due_flag` tinyint(1) DEFAULT '0',
  `date_due` datetime DEFAULT NULL,
  `date_start_flag` tinyint(1) DEFAULT '0',
  `date_start` datetime DEFAULT NULL,
  `parent_type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parent_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contact_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `priority` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_tsk_name` (`name`),
  KEY `idx_task_con_del` (`contact_id`,`deleted`),
  KEY `idx_task_par_del` (`parent_id`,`parent_type`,`deleted`),
  KEY `idx_task_assigned` (`assigned_user_id`),
  KEY `idx_task_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `templatesectionline`
--

CREATE TABLE `templatesectionline` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `deleted` tinyint(1) DEFAULT '0',
  `thumbnail` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `grp` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ord` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tracker`
--

CREATE TABLE `tracker` (
  `id` int NOT NULL AUTO_INCREMENT,
  `monitor_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `user_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `module_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `item_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `item_summary` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `action` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `session_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `visible` tinyint(1) DEFAULT '0',
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_tracker_iid` (`item_id`),
  KEY `idx_tracker_userid_vis_id` (`user_id`,`visible`,`id`),
  KEY `idx_tracker_userid_itemid_vis` (`user_id`,`item_id`,`visible`),
  KEY `idx_tracker_monitor_id` (`monitor_id`),
  KEY `idx_tracker_date_modified` (`date_modified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `upgrade_history`
--

CREATE TABLE `upgrade_history` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `filename` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `md5sum` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `type` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `version` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `id_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `manifest` longtext COLLATE utf8mb4_general_ci,
  `date_entered` datetime DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `upgrade_history_md5_uk` (`md5sum`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `user_name` varchar(60) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_hash` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `system_generated_password` tinyint(1) DEFAULT NULL,
  `pwd_last_changed` datetime DEFAULT NULL,
  `authenticate_id` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `sugar_login` tinyint(1) DEFAULT '1',
  `first_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_admin` tinyint(1) DEFAULT '0',
  `external_auth_only` tinyint(1) DEFAULT '0',
  `receive_notifications` tinyint(1) DEFAULT '1',
  `description` text COLLATE utf8mb4_general_ci,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `modified_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `title` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `photo` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `department` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_home` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_mobile` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_work` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_other` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone_fax` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `address_street` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `address_city` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `address_state` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `address_country` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `address_postalcode` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `portal_only` tinyint(1) DEFAULT '0',
  `show_on_employees` tinyint(1) DEFAULT '1',
  `employee_status` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `messenger_id` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `messenger_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reports_to_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_group` tinyint(1) DEFAULT NULL,
  `factor_auth` tinyint(1) DEFAULT NULL,
  `factor_auth_interface` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_name` (`user_name`,`is_group`,`status`,`last_name`(30),`first_name`(30),`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` VALUES
('1', '[[admin_username]]', '[[admin_pass]]', 0, NULL, NULL, 1, '[[admin_fname]]', '[[admin_lname]]', 1, 0, 1, NULL, '[[regtime]]', '[[regtime]]', '1', '1', 'Administrator', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 'Active', NULL, NULL, NULL, 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `users_feeds`
--

CREATE TABLE `users_feeds` (
  `user_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `feed_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `rank` int DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  KEY `idx_ud_user_id` (`user_id`,`feed_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users_last_import`
--

CREATE TABLE `users_last_import` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `import_module` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bean_type` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bean_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`assigned_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users_password_link`
--

CREATE TABLE `users_password_link` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `keyhash` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `username` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_generated` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users_signatures`
--

CREATE TABLE `users_signatures` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `user_id` varchar(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `signature` text COLLATE utf8mb4_general_ci,
  `signature_html` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_usersig_uid` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_preferences`
--

CREATE TABLE `user_preferences` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `category` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `assigned_user_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contents` longtext COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_userprefnamecat` (`assigned_user_id`,`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `user_preferences`
--

INSERT INTO `user_preferences` VALUES
('b522eac1-663b-46a1-82c3-8d07476eb4df', 'global', 0, '[[regtime]]', '[[regtime]]', '1', 'YToxODp7czoyMDoiY2FsZW5kYXJfcHVibGlzaF9rZXkiO3M6MzY6ImUwY2NjMTgwLTQwNGItNGExMS04MjM3LTMzMzE1NTU5YzI1YSI7czoxMjoibWFpbG1lcmdlX29uIjtzOjM6Im9mZiI7czoxNjoic3dhcF9sYXN0X3ZpZXdlZCI7YjowO3M6MTQ6InN3YXBfc2hvcnRjdXRzIjtiOjA7czoxOToibmF2aWdhdGlvbl9wYXJhZGlnbSI7czoyOiJnbSI7czoyMDoic29ydF9tb2R1bGVzX2J5X25hbWUiO3M6MDoiIjtzOjEzOiJzdWJwYW5lbF90YWJzIjtiOjE7czoyNToiY291bnRfY29sbGFwc2VkX3N1YnBhbmVscyI7czowOiIiO3M6MTQ6Im1vZHVsZV9mYXZpY29uIjtiOjA7czo5OiJoaWRlX3RhYnMiO2E6MDp7fXM6MTE6InJlbW92ZV90YWJzIjthOjA6e31zOjc6Im5vX29wcHMiO3M6Mzoib2ZmIjtzOjg6InRpbWV6b25lIjtzOjE2OiJBbWVyaWNhL05ld19Zb3JrIjtzOjI6InV0IjtzOjE6IjEiO3M6MTQ6InVzZV9yZWFsX25hbWVzIjtiOjE7czoxNzoibWFpbF9zbXRwYXV0aF9yZXEiO3M6MDoiIjtzOjEyOiJtYWlsX3NtdHBzc2wiO2k6MDtzOjE3OiJlbWFpbF9zaG93X2NvdW50cyI7aTowO30=');

-- --------------------------------------------------------

--
-- Table structure for table `vcals`
--

CREATE TABLE `vcals` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `date_entered` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `user_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `source` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_vcal` (`type`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
