@extends('layouts/edit-form', [
    'createText' => trans('admin/categories/general.create') ,
    'updateText' => trans('admin/categories/general.update'),
    'helpPosition'  => 'right',
    'helpText' => trans('help.categories'),
    'topSubmit'  => 'true',
    'formAction' => (isset($item->id)) ? route('categories.update', ['category' => $item->id]) : route('categories.store'),
])

@section('inputFields')

    <!-- Name -->
    <x-form-row
            :label="trans('general.name')"
            :$item
            name="name"
    />


<!-- Type -->
<div class="form-group {{ $errors->has('category_type') ? ' has-error' : '' }}">
    <label for="category_type" class="col-md-3 control-label">{{ trans('general.type') }}</label>
    <div class="col-md-7 required">
        <x-input.select
            name="category_type"
            :options="$category_types"
            :selected="old('category_type', $item->category_type)"
            :disabled="$item->category_type!='' || $item->itemCount() > 0"
            style="min-width:350px"
            aria-label="category_type"
        />
        {!! $errors->first('category_type', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>') !!}
    </div>
    <div class="col-md-7 col-md-offset-3">
        <p class="help-block">{!! trans('admin/categories/message.update.cannot_change_category_type') !!} </p>
    </div>
</div>

<livewire:category-edit-form
    :alert-on-response="(bool) old('alert_on_response', $item->alert_on_response)"
    :default-eula-text="$snipeSettings->default_eula_text"
    :eula-text="old('eula_text', $item->eula_text)"
    :require-acceptance="(bool) old('require_acceptance', $item->require_acceptance)"
    :send-check-in-email="(bool) old('checkin_email', $item->checkin_email)"
    :use-default-eula="(bool) old('use_default_eula', $item->use_default_eula)"
/>

@include ('partials.forms.edit.image-upload', ['image_path' => app('categories_upload_path')])

<div class="form-group{!! $errors->has('notes') ? ' has-error' : '' !!}">
    <label for="notes" class="col-md-3 control-label">{{ trans('general.notes') }}</label>
    <div class="col-md-8">
        <x-input.textarea
                name="notes"
                id="notes"
                :value="old('notes', $item->notes)"
                placeholder="{{ trans('general.placeholders.notes') }}"
                aria-label="notes"
                rows="5"
        />
        {!! $errors->first('notes', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>') !!}
    </div>
</div>



@if ($snipeSettings->default_eula_text!='')
<!-- Modal -->
<div class="modal fade" id="eulaModal" tabindex="-1" role="dialog" aria-labelledby="eulaModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h2 class="modal-title" id="eulaModalLabel">{{ trans('admin/settings/general.default_eula_text') }}</h2>
            </div>
            <div class="modal-body">
                {{ \App\Models\Setting::getDefaultEula() }}
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">{{ trans('button.cancel') }}</button>
            </div>
        </div>
    </div>
</div>
@endif

    <fieldset name="color-preferences">
        <x-form-legend help_text="{{ trans('general.tag_color_help') }}">
            {{ trans('general.tag_color') }}
        </x-form-legend>
        <!--  color -->
        <div class="form-group {{ $errors->has('tag_color') ? 'error' : '' }}">
            <label for="tag_color" class="col-md-3 control-label">
                {{ trans('general.tag_color') }}
            </label>
            <div class="col-md-9">
                <x-input.colorpicker :item="$item" id="color" :value="old('color', ($item->color ?? '#f4f4f4'))" name="tag_color" id="tag_color" />
                {!! $errors->first('tag_color', '<span class="alert-msg" aria-hidden="true">:message</span>') !!}
            </div>
        </div>
    </fieldset>


@stop
