
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `shopware6760`
--


-- --------------------------------------------------------

--
-- Table structure for table `acl_role`
--

CREATE TABLE `acl_role` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `privileges` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `deleted_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `acl_user_role`
--

CREATE TABLE `acl_user_role` (
  `user_id` binary(16) NOT NULL,
  `acl_role_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`user_id`,`acl_role_id`),
  KEY `fk.acl_user_role.acl_role_id` (`acl_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app`
--

CREATE TABLE `app` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(4096) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `copyright` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `privacy` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `base_app_url` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `allow_disable` tinyint(1) NOT NULL DEFAULT '1',
  `configurable` tinyint(1) NOT NULL DEFAULT '0',
  `icon` mediumblob,
  `app_secret` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modules` json DEFAULT NULL,
  `main_module` json DEFAULT NULL,
  `cookies` json DEFAULT NULL,
  `allowed_hosts` json DEFAULT NULL,
  `integration_id` binary(16) NOT NULL,
  `acl_role_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `template_load_priority` int DEFAULT '0',
  `checkout_gateway_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `self_managed` tinyint(1) NOT NULL DEFAULT '0',
  `source_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'local',
  `source_config` json NOT NULL DEFAULT (json_object()),
  `in_app_purchases_gateway_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `requested_privileges` json NOT NULL DEFAULT (json_array()),
  `context_gateway_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.name` (`name`),
  KEY `fk.app.integration_id` (`integration_id`),
  KEY `fk.app.acl_role_id` (`acl_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_action_button`
--

CREATE TABLE `app_action_button` (
  `id` binary(16) NOT NULL,
  `entity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `view` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `app_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_action_button.action` (`action`,`app_id`),
  KEY `fk.app_action_button.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_action_button_translation`
--

CREATE TABLE `app_action_button_translation` (
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `app_action_button_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  PRIMARY KEY (`app_action_button_id`,`language_id`),
  KEY `fk.app_action_button_translation.app_action_button_id` (`app_action_button_id`),
  KEY `fk.app_action_button_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_administration_snippet`
--

CREATE TABLE `app_administration_snippet` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `locale_id` binary(16) NOT NULL,
  `value` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.app_id` (`app_id`),
  KEY `fk.locale_id` (`locale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_cms_block`
--

CREATE TABLE `app_cms_block` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `block` json NOT NULL,
  `template` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `styles` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.app_cms_block.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_cms_block_translation`
--

CREATE TABLE `app_cms_block_translation` (
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_cms_block_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_cms_block_id`,`language_id`),
  KEY `fk.app_cms_block_translation.app_cms_block_id` (`app_cms_block_id`),
  KEY `fk.app_cms_block_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_config`
--

CREATE TABLE `app_config` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_flow_action`
--

CREATE TABLE `app_flow_action` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `badge` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delayable` tinyint(1) NOT NULL DEFAULT '0',
  `parameters` json DEFAULT NULL,
  `config` json DEFAULT NULL,
  `headers` json DEFAULT NULL,
  `requirements` json DEFAULT NULL,
  `icon` mediumblob,
  `sw_icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_flow_action.name` (`name`),
  KEY `fk.app_flow_action.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_flow_action_translation`
--

CREATE TABLE `app_flow_action_translation` (
  `app_flow_action_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `headline` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_flow_action_id`,`language_id`),
  KEY `fk.app_flow_action_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_flow_event`
--

CREATE TABLE `app_flow_event` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `aware` json NOT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `uniq.app_flow_event.name` (`name`),
  KEY `fk.app_flow_event.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_payment_method`
--

CREATE TABLE `app_payment_method` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) DEFAULT NULL,
  `payment_method_id` binary(16) NOT NULL,
  `app_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pay_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `finalize_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `validate_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `capture_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `refund_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `original_media_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `recurring_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_payment_method.payment_method_id` (`payment_method_id`),
  KEY `fk.app_payment_method.app_id` (`app_id`),
  KEY `fk.app_payment_method.original_media_id` (`original_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_script_condition`
--

CREATE TABLE `app_script_condition` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `group` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `script` longtext COLLATE utf8mb4_unicode_ci,
  `constraints` longblob,
  `config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.app_script_condition.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_script_condition_translation`
--

CREATE TABLE `app_script_condition_translation` (
  `app_script_condition_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_script_condition_id`,`language_id`),
  KEY `fk.app_script_condition_translation.app_script_condition_id` (`app_script_condition_id`),
  KEY `fk.app_script_condition_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_shipping_method`
--

CREATE TABLE `app_shipping_method` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) DEFAULT NULL,
  `app_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_method_id` binary(16) NOT NULL,
  `original_media_id` binary(16) DEFAULT NULL,
  `identifier` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_shipping_method.shipping_method_id` (`shipping_method_id`),
  KEY `fk.app_shipping_method.app_id` (`app_id`),
  KEY `fk.app_shipping_method.original_media_id` (`original_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_template`
--

CREATE TABLE `app_template` (
  `id` binary(16) NOT NULL,
  `template` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.template.path` (`path`(256)),
  KEY `fk.template.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_translation`
--

CREATE TABLE `app_translation` (
  `app_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `privacy_policy_extensions` mediumtext COLLATE utf8mb4_unicode_ci,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_id`,`language_id`),
  KEY `fk.app_translation.app_id` (`app_id`),
  KEY `fk.app_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cart`
--

CREATE TABLE `cart` (
  `token` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rule_ids` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `auto_increment` bigint NOT NULL AUTO_INCREMENT,
  `compressed` tinyint(1) NOT NULL DEFAULT '0',
  `payload` longblob,
  PRIMARY KEY (`token`),
  UNIQUE KEY `auto_increment` (`auto_increment`),
  KEY `idx.cart.created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `category`
--

CREATE TABLE `category` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL,
  `auto_increment` int NOT NULL AUTO_INCREMENT,
  `parent_id` binary(16) DEFAULT NULL,
  `parent_version_id` binary(16) DEFAULT NULL,
  `media_id` binary(16) DEFAULT NULL,
  `cms_page_id` binary(16) DEFAULT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `product_stream_id` binary(16) DEFAULT NULL,
  `product_assignment_type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'product',
  `path` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `after_category_id` binary(16) DEFAULT NULL,
  `after_category_version_id` binary(16) DEFAULT NULL,
  `level` int unsigned NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `child_count` int unsigned NOT NULL DEFAULT '0',
  `display_nested_products` tinyint unsigned NOT NULL DEFAULT '1',
  `visible` tinyint unsigned NOT NULL DEFAULT '1',
  `type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `custom_entity_type_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  UNIQUE KEY `auto_increment` (`auto_increment`),
  KEY `idx.level` (`level`),
  KEY `fk.category.media_id` (`media_id`),
  KEY `fk.category.parent_id` (`parent_id`,`parent_version_id`),
  KEY `fk.category.after_category_id` (`after_category_id`,`after_category_version_id`),
  KEY `fk.category.product_stream_id` (`product_stream_id`),
  KEY `fk.category.cms_page_id` (`cms_page_id`,`cms_page_version_id`),
  KEY `fk.category.custom_entity_type_id` (`custom_entity_type_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `category`
--

INSERT INTO `category` VALUES
('Crتqk;', 'jK¾Ku,4%', 1, NULL, NULL, NULL, NULL, 'jK¾Ku,4%', NULL, 'product', NULL, NULL, NULL, 1, 1, 0, 1, 1, 'page', '[[regtime_]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `category_tag`
--

CREATE TABLE `category_tag` (
  `category_id` binary(16) NOT NULL,
  `category_version_id` binary(16) NOT NULL,
  `tag_id` binary(16) NOT NULL,
  PRIMARY KEY (`category_id`,`category_version_id`,`tag_id`),
  KEY `fk.category_tag.tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `category_translation`
--

CREATE TABLE `category_translation` (
  `category_id` binary(16) NOT NULL,
  `category_version_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `breadcrumb` json DEFAULT NULL,
  `internal_link` binary(16) DEFAULT NULL,
  `link_new_tab` tinyint DEFAULT NULL,
  `link_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `meta_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `slot_config` json DEFAULT NULL,
  PRIMARY KEY (`category_id`,`category_version_id`,`language_id`),
  KEY `fk.category_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `category_translation`
--

INSERT INTO `category_translation` VALUES
('Crتqk;', 'jK¾Ku,4%', '\nQpppS:', 'Home', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL, NULL),
('Crتqk;', 'jK¾Ku,4%', '/_MpXT|', 'Home', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_block`
--

CREATE TABLE `cms_block` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `cms_section_id` binary(16) DEFAULT NULL,
  `cms_section_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `position` int NOT NULL,
  `section_position` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT 'main',
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `margin_top` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `margin_bottom` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `margin_left` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `margin_right` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_color` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_media_id` binary(16) DEFAULT NULL,
  `background_media_mode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visibility` json DEFAULT NULL,
  `css_class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_block.background_media_id` (`background_media_id`),
  KEY `fk.cms_block.cms_section_id` (`cms_section_id`,`cms_section_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_block`
--

INSERT INTO `cms_block` VALUES
('Tpho%p', 'jK¾Ku,4%', '-s7g]', 'jK¾Ku,4%', 3, 'main', 'product-listing', 'Category listing', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Tphov', 'jK¾Ku,4%', '-s7g]', 'jK¾Ku,4%', 1, 'main', 'image-text', 'Category info', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('0|p{0pއ', 'jK¾Ku,4%', '-s7g]', 'jK¾Ku,4%', 2, 'main', 'sidebar-filter', 'Filter', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('0sJpM', 'jK¾Ku,4%', '0s	gZ', 'jK¾Ku,4%', 1, 'main', 'image-text', 'Category info', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('0sJqhB', 'jK¾Ku,4%', '0s	g9', 'jK¾Ku,4%', 1, 'sidebar', 'category-navigation', 'Sidebar navigation', 1, NULL, '30px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('0sJr6\\', 'jK¾Ku,4%', '0s	g9', 'jK¾Ku,4%', 2, 'sidebar', 'sidebar-filter', 'Sidebar filter', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('0sJrա', 'jK¾Ku,4%', '0s	g9', 'jK¾Ku,4%', 2, 'main', 'product-listing', 'Category listing', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('@#ssZ;|O', 'jK¾Ku,4%', '@ r;s-Ƭ4', 'jK¾Ku,4%', 1, 'main', 'form', 'Contact form', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('@<rl!\0&', 'jK¾Ku,4%', '@9r''zk', 'jK¾Ku,4%', 1, 'main', 'form', 'Newsletter form', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('HpAŀԂ}', 'jK¾Ku,4%', 'HpAŀ7', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Hq,f', 'jK¾Ku,4%', 'Hq,fe', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Hs\rΓ\Z', 'jK¾Ku,4%', 'Hs\r:R', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('HrLXս', 'jK¾Ku,4%', 'HrLX^Q', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Irm$6', 'jK¾Ku,4%', 'Irm$>X', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('sՇ,F5π', 'jK¾Ku,4%', 'qW0Qi', 'jK¾Ku,4%', 0, 'main', 'product-heading', 'Product heading', 1, '0', '20px', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('sՇ,F5', 'jK¾Ku,4%', 'qW0Qi', 'jK¾Ku,4%', 1, 'main', 'gallery-buybox', 'Gallery buy box', 1, '20px', '0', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('sՇ,F5K', 'jK¾Ku,4%', 'qW0Qi', 'jK¾Ku,4%', 2, 'main', 'product-description-reviews', 'Product description and reviews', 1, '20px', '20px', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('sՇ,F5I', 'jK¾Ku,4%', 'qW0Qi', 'jK¾Ku,4%', 3, 'main', 'cross-selling', 'Cross selling', 1, '0', '0', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('BqEQQ\\,|', 'jK¾Ku,4%', '-s7g]', 'jK¾Ku,4%', 0, 'main', 'text', 'Category name', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('C\0phvlG', 'jK¾Ku,4%', '0s	gZ', 'jK¾Ku,4%', 0, 'main', 'text', 'Category name', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_page`
--

CREATE TABLE `cms_page` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `entity` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `preview_media_id` binary(16) DEFAULT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `css_class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_page.preview_media_id` (`preview_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_page`
--

INSERT INTO `cms_page` VALUES
('Er\n', 'jK¾Ku,4%', 'product_list', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('0sȍ$3:', 'jK¾Ku,4%', 'product_list', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('@rF*}۹', 'jK¾Ku,4%', 'page', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('@0q\Z>~', 'jK¾Ku,4%', 'page', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('HpAŀ:', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('Hq,e', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('Hs\rjn:', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('HrLX&_', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('Irm$', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('zm%:g @7oB', 'jK¾Ku,4%', 'product_detail', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_page_translation`
--

CREATE TABLE `cms_page_translation` (
  `cms_page_id` binary(16) NOT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`cms_page_id`,`language_id`,`cms_page_version_id`),
  KEY `fk.cms_page_translation.language_id` (`language_id`),
  KEY `fk.cms_page_translation.cms_page_id` (`cms_page_id`,`cms_page_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_page_translation`
--

INSERT INTO `cms_page_translation` VALUES
('Er\n', 'jK¾Ku,4%', '\nQpppS:', 'Standard Kategorie-Layout', NULL, '[[regtime_]]', NULL),
('Er\n', 'jK¾Ku,4%', '/_MpXT|', 'Default listing layout', NULL, '[[regtime_]]', NULL),
('0sȍ$3:', 'jK¾Ku,4%', '\nQpppS:', 'Standard Kategorie-Layout mit Sidebar', NULL, '[[regtime_]]', NULL),
('0sȍ$3:', 'jK¾Ku,4%', '/_MpXT|', 'Default listing layout with sidebar', NULL, '[[regtime_]]', NULL),
('@rF*}۹', 'jK¾Ku,4%', '\nQpppS:', 'Standard Shopseiten-Layout mit Kontaktformular', NULL, '[[regtime_]]', NULL),
('@rF*}۹', 'jK¾Ku,4%', '/_MpXT|', 'Default shop page layout with contact form', NULL, '[[regtime_]]', NULL),
('@0q\Z>~', 'jK¾Ku,4%', '\nQpppS:', 'Standard Shopseiten-Layout mit Newsletterformular', NULL, '[[regtime_]]', NULL),
('@0q\Z>~', 'jK¾Ku,4%', '/_MpXT|', 'Default shop page layout with newsletter form', NULL, '[[regtime_]]', NULL),
('HpAŀ:', 'jK¾Ku,4%', '\nQpppS:', 'Versand und Zahlung', NULL, '[[regtime_]]', NULL),
('HpAŀ:', 'jK¾Ku,4%', '/_MpXT|', 'Payment / Shipping', NULL, '[[regtime_]]', NULL),
('Hq,e', 'jK¾Ku,4%', '\nQpppS:', 'AGB', NULL, '[[regtime_]]', NULL),
('Hq,e', 'jK¾Ku,4%', '/_MpXT|', 'Terms of service', NULL, '[[regtime_]]', NULL),
('Hs\rjn:', 'jK¾Ku,4%', '\nQpppS:', 'Widerrufsbelehrungen', NULL, '[[regtime_]]', NULL),
('Hs\rjn:', 'jK¾Ku,4%', '/_MpXT|', 'Right of rescission', NULL, '[[regtime_]]', NULL),
('HrLX&_', 'jK¾Ku,4%', '\nQpppS:', 'Datenschutz', NULL, '[[regtime_]]', NULL),
('HrLX&_', 'jK¾Ku,4%', '/_MpXT|', 'Privacy', NULL, '[[regtime_]]', NULL),
('Irm$', 'jK¾Ku,4%', '\nQpppS:', 'Impressum', NULL, '[[regtime_]]', NULL),
('Irm$', 'jK¾Ku,4%', '/_MpXT|', 'Imprint', NULL, '[[regtime_]]', NULL),
('zm%:g @7oB', 'jK¾Ku,4%', '\nQpppS:', 'Standard Produktseite-Layout', NULL, '[[regtime_]]', NULL),
('zm%:g @7oB', 'jK¾Ku,4%', '/_MpXT|', 'Default product page Layout', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_section`
--

CREATE TABLE `cms_section` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `cms_page_id` binary(16) NOT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `position` int NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `sizing_mode` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'boxed',
  `mobile_behavior` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'wrap',
  `background_color` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_media_id` binary(16) DEFAULT NULL,
  `background_media_mode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visibility` json DEFAULT NULL,
  `css_class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_section.background_media_id` (`background_media_id`),
  KEY `fk.cms_section.cms_page_id` (`cms_page_id`,`cms_page_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_section`
--

INSERT INTO `cms_section` VALUES
('-s7g]', 'jK¾Ku,4%', 'Er\n', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('0s	gZ', 'jK¾Ku,4%', '0sȍ$3:', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('0s	g9', 'jK¾Ku,4%', '0sȍ$3:', 'jK¾Ku,4%', 1, 'sidebar', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('@ r;s-Ƭ4', 'jK¾Ku,4%', '@rF*}۹', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('@9r''zk', 'jK¾Ku,4%', '@0q\Z>~', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('HpAŀ7', 'jK¾Ku,4%', 'HpAŀ:', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('Hq,fe', 'jK¾Ku,4%', 'Hq,e', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('Hs\r:R', 'jK¾Ku,4%', 'Hs\rjn:', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('HrLX^Q', 'jK¾Ku,4%', 'HrLX&_', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('Irm$>X', 'jK¾Ku,4%', 'Irm$', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('qW0Qi', 'jK¾Ku,4%', 'zm%:g @7oB', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_slot`
--

CREATE TABLE `cms_slot` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL,
  `cms_block_id` binary(16) NOT NULL,
  `cms_block_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slot` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_slot.cms_block_id` (`cms_block_id`,`cms_block_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_slot`
--

INSERT INTO `cms_slot` VALUES
('^qu^Rt', 'jK¾Ku,4%', 'Tpho%p', 'jK¾Ku,4%', 'product-listing', 'content', 1, '[[regtime_]]', NULL),
('^qu^Rc', 'jK¾Ku,4%', 'Tphov', 'jK¾Ku,4%', 'image', 'left', 1, '[[regtime_]]', NULL),
('^qu^RT', 'jK¾Ku,4%', 'Tphov', 'jK¾Ku,4%', 'text', 'right', 1, '[[regtime_]]', NULL),
('0q\n', 'jK¾Ku,4%', '0|p{0pއ', 'jK¾Ku,4%', 'sidebar-filter', 'content', 1, '[[regtime_]]', NULL),
('0qCU?', 'jK¾Ku,4%', '0sJpM', 'jK¾Ku,4%', 'image', 'left', 1, '[[regtime_]]', NULL),
('0qD3', 'jK¾Ku,4%', '0sJpM', 'jK¾Ku,4%', 'text', 'right', 1, '[[regtime_]]', NULL),
('0qD@=', 'jK¾Ku,4%', '0sJqhB', 'jK¾Ku,4%', 'category-navigation', 'content', 1, '[[regtime_]]', NULL),
('0qDa', 'jK¾Ku,4%', '0sJr6\\', 'jK¾Ku,4%', 'sidebar-filter', 'content', 1, '[[regtime_]]', NULL),
('0qE''~', 'jK¾Ku,4%', '0sJr6\\', 'jK¾Ku,4%', 'sidebar-filter', 'content', 1, '[[regtime_]]', NULL),
('0qE_', 'jK¾Ku,4%', '0sJrա', 'jK¾Ku,4%', 'product-listing', 'content', 1, '[[regtime_]]', NULL),
('@&qNm^', 'jK¾Ku,4%', '@#ssZ;|O', 'jK¾Ku,4%', 'form', 'content', 1, '[[regtime_]]', NULL),
('@?p13', 'jK¾Ku,4%', '@<rl!\0&', 'jK¾Ku,4%', 'form', 'content', 1, '[[regtime_]]', NULL),
('HpAŀԎ0', 'jK¾Ku,4%', 'HpAŀԂ}', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('Hq,gz', 'jK¾Ku,4%', 'Hq,f', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('Hs\rn<', 'jK¾Ku,4%', 'Hs\rΓ\Z', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('HrLX"', 'jK¾Ku,4%', 'HrLXս', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('Irm$L', 'jK¾Ku,4%', 'Irm$6', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('rFQ,/', 'jK¾Ku,4%', 'sՇ,F5π', 'jK¾Ku,4%', 'product-name', 'left', 1, '[[regtime_]]', NULL),
('rFQ,', 'jK¾Ku,4%', 'sՇ,F5π', 'jK¾Ku,4%', 'manufacturer-logo', 'right', 1, '[[regtime_]]', NULL),
('rFQ,e', 'jK¾Ku,4%', 'sՇ,F5', 'jK¾Ku,4%', 'image-gallery', 'left', 1, '[[regtime_]]', NULL),
('rFQ,[', 'jK¾Ku,4%', 'sՇ,F5', 'jK¾Ku,4%', 'buy-box', 'right', 1, '[[regtime_]]', NULL),
('rFQ,;1', 'jK¾Ku,4%', 'sՇ,F5K', 'jK¾Ku,4%', 'product-description-reviews', 'content', 1, '[[regtime_]]', NULL),
('rFQ,(', 'jK¾Ku,4%', 'sՇ,F5I', 'jK¾Ku,4%', 'cross-selling', 'content', 1, '[[regtime_]]', NULL),
('Bq5', 'jK¾Ku,4%', 'BqEQQ\\,|', 'jK¾Ku,4%', 'text', 'content', 1, '[[regtime_]]', NULL),
('Cq4Үdu', 'jK¾Ku,4%', 'C\0phvlG', 'jK¾Ku,4%', 'text', 'content', 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_slot_translation`
--

CREATE TABLE `cms_slot_translation` (
  `cms_slot_id` binary(16) NOT NULL,
  `cms_slot_version_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `config` json DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`cms_slot_id`,`cms_slot_version_id`,`language_id`),
  KEY `fk.cms_slot_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_slot_translation`
--

INSERT INTO `cms_slot_translation` VALUES
('^qu^Rt', 'jK¾Ku,4%', '\nQpppS:', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('^qu^Rt', 'jK¾Ku,4%', '/_MpXT|', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('^qu^Rc', 'jK¾Ku,4%', '\nQpppS:', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('^qu^Rc', 'jK¾Ku,4%', '/_MpXT|', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('^qu^RT', 'jK¾Ku,4%', '\nQpppS:', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('^qu^RT', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('0q\n', 'jK¾Ku,4%', '/_MpXT|', NULL, NULL, '[[regtime_]]', NULL),
('0qCU?', 'jK¾Ku,4%', '\nQpppS:', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('0qCU?', 'jK¾Ku,4%', '/_MpXT|', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('0qD3', 'jK¾Ku,4%', '\nQpppS:', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('0qD3', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('0qD@=', 'jK¾Ku,4%', '\nQpppS:', NULL, NULL, '[[regtime_]]', NULL),
('0qD@=', 'jK¾Ku,4%', '/_MpXT|', NULL, NULL, '[[regtime_]]', NULL),
('0qDa', 'jK¾Ku,4%', '\nQpppS:', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('0qDa', 'jK¾Ku,4%', '/_MpXT|', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('@&qNm^', 'jK¾Ku,4%', '\nQpppS:', '{"type": {"value": "contact", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('@&qNm^', 'jK¾Ku,4%', '/_MpXT|', '{"type": {"value": "contact", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('@?p13', 'jK¾Ku,4%', '\nQpppS:', '{"type": {"value": "newsletter", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('@?p13', 'jK¾Ku,4%', '/_MpXT|', '{"type": {"value": "newsletter", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('HpAŀԎ0', 'jK¾Ku,4%', '\nQpppS:', '{"content": {"value": "<h2>Versand und Zahlung</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('HpAŀԎ0', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Payment / Shipping</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Hq,gz', 'jK¾Ku,4%', '\nQpppS:', '{"content": {"value": "<h2>AGB</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Hq,gz', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Terms of service</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Hs\rn<', 'jK¾Ku,4%', '\nQpppS:', '{"content": {"value": "<h2>Widerrufsbelehrungen</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Hs\rn<', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Right of rescission</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('HrLX"', 'jK¾Ku,4%', '\nQpppS:', '{"content": {"value": "<h2>Datenschutz</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('HrLX"', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Privacy</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Irm$L', 'jK¾Ku,4%', '\nQpppS:', '{"content": {"value": "<h2>Impressum</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Irm$L', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Imprint</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('rFQ,/', 'jK¾Ku,4%', '\nQpppS:', '{"content": {"value": "product.name", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('rFQ,/', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "product.name", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('rFQ,', 'jK¾Ku,4%', '\nQpppS:', '{"url": {"value": null, "source": "static"}, "media": {"value": "product.manufacturer.media", "source": "mapped"}, "newTab": {"value": true, "source": "static"}, "minHeight": {"value": null, "source": "static"}, "displayMode": {"value": "standard", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('rFQ,', 'jK¾Ku,4%', '/_MpXT|', '{"url": {"value": null, "source": "static"}, "media": {"value": "product.manufacturer.media", "source": "mapped"}, "newTab": {"value": true, "source": "static"}, "minHeight": {"value": null, "source": "static"}, "displayMode": {"value": "standard", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('rFQ,e', 'jK¾Ku,4%', '\nQpppS:', '{"zoom": {"value": true, "source": "static"}, "minHeight": {"value": "430px", "source": "static"}, "fullScreen": {"value": true, "source": "static"}, "displayMode": {"value": "contain", "source": "static"}, "sliderItems": {"value": "product.media", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}, "navigationDots": {"value": "inside", "source": "static"}, "galleryPosition": {"value": "left", "source": "static"}, "navigationArrows": {"value": "inside", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('rFQ,e', 'jK¾Ku,4%', '/_MpXT|', '{"zoom": {"value": true, "source": "static"}, "minHeight": {"value": "430px", "source": "static"}, "fullScreen": {"value": true, "source": "static"}, "displayMode": {"value": "contain", "source": "static"}, "sliderItems": {"value": "product.media", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}, "navigationDots": {"value": "inside", "source": "static"}, "galleryPosition": {"value": "left", "source": "static"}, "navigationArrows": {"value": "inside", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('rFQ,[', 'jK¾Ku,4%', '\nQpppS:', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('rFQ,[', 'jK¾Ku,4%', '/_MpXT|', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('rFQ,;1', 'jK¾Ku,4%', '\nQpppS:', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('rFQ,;1', 'jK¾Ku,4%', '/_MpXT|', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('rFQ,(', 'jK¾Ku,4%', '\nQpppS:', '{"product": {"value": null, "source": "static"}, "boxLayout": {"value": "standard", "source": "static"}, "elMinWidth": {"value": "200px", "source": "static"}, "displayMode": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('rFQ,(', 'jK¾Ku,4%', '/_MpXT|', '{"product": {"value": null, "source": "static"}, "boxLayout": {"value": "standard", "source": "static"}, "elMinWidth": {"value": "200px", "source": "static"}, "displayMode": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Bq5', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h1>{{ category.name }}</h1>", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Cq4Үdu', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h1>{{ category.name }}</h1>", "source": "static"}}', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `country`
--

CREATE TABLE `country` (
  `id` binary(16) NOT NULL,
  `iso` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `iso3` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_state_in_registration` tinyint(1) NOT NULL DEFAULT '0',
  `force_state_in_registration` tinyint(1) NOT NULL DEFAULT '0',
  `check_vat_id_pattern` tinyint(1) NOT NULL DEFAULT '0',
  `vat_id_pattern` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_id_required` tinyint(1) NOT NULL DEFAULT '0',
  `customer_tax` json DEFAULT NULL,
  `company_tax` json DEFAULT NULL,
  `advanced_postal_code_pattern` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `check_advanced_postal_code_pattern` tinyint(1) NOT NULL DEFAULT '0',
  `check_postal_code_pattern` tinyint(1) NOT NULL DEFAULT '0',
  `default_postal_code_pattern` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code_required` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `shipping_available` tinyint(1) NOT NULL DEFAULT '1',
  `is_eu` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country`
--

INSERT INTO `country` VALUES
('\nq!$', 'DE', 1, 1, 'DEU', 0, 0, 0, 'DE\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('ptǪ+', 'GR', 10, 1, 'GRC', 0, 0, 0, '(EL|GR)\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('qo''n/|}', 'GB', 5, 1, 'GBR', 0, 0, 0, '(GB)?([0-9]{9}([0-9]{3})?|[A-Z]{2}[0-9]{3})', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '^GIR ?0AA$|^(?:(?:AB|AL|B|BA|BB|BD|BH|BL|BN|BR|BS|BT|BX|CA|CB|CF|CH|CM|CO|CR|CT|CV|CW|DA|DD|DE|DG|DH|DL|DN|DT|DY|E|EC|EH|EN|EX|FK|FY|G|GL|GY|GU|HA|HD|HG|HP|HR|HS|HU|HX|IG|IM|IP|IV|JE|KA|KT|KW|KY|L|LA|LD|LE|LL|LN|LS|LU|M|ME|MK|ML|N|NE|NG|NN|NP|NR|NW|OL|OX|PA|PE|PH|PL|PO|PR|RG|RH|RM|S|SA|SE|SG|SK|SL|SM|SN|SO|SP|SR|SS|ST|SW|SY|TA|TD|TF|TN|TQ|TR|TS|TW|UB|W|WA|WC|WD|WF|WN|WR|WS|WV|YO|ZE)(?:\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}))$|^BFPO ?\\d{1,4}$', 1, '[[regtime_]]', NULL, 1, 0),
('Gp?_V6\nT', 'IE', 10, 1, 'IRL', 0, 0, 0, 'IE(\\d{7}[A-Z]{1,2}|(\\d{1}[A-Z]{1}\\d{5}[A-Z]{1}))', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[\\dA-Z]{3}( ?[\\dA-Z]{4})?', 1, '[[regtime_]]', NULL, 1, 1),
('Pq*', 'IS', 10, 1, 'ISL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('Ypε5(}', 'IT', 10, 1, 'ITA', 0, 0, 0, 'IT\\d{11}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('bqnLAE', 'JP', 10, 1, 'JPN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}-?\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ksįCzf', 'CA', 10, 1, 'CAN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[ABCEGHJKLMNPRSTVXY]\\d[ABCEGHJ-NPRSTV-Z] ?\\d[ABCEGHJ-NPRSTV-Z]\\d', 1, '[[regtime_]]', NULL, 1, 0),
('ws\Z~fR', 'LU', 10, 1, 'LUX', 0, 0, 0, 'LU\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('py_', 'NA', 10, 1, 'NAM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('qU''2', 'NL', 10, 1, 'NLD', 0, 0, 0, 'NL\\d{9}B\\d{2}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[1-9]{1}\\d{3}([ ]?[A-Z]{2})', 1, '[[regtime_]]', NULL, 1, 1),
('sN2E', 'NO', 10, 1, 'NOR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('sؔYaV', 'AT', 10, 1, 'AUT', 0, 0, 0, 'ATU\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('rIo', 'PT', 10, 1, 'PRT', 0, 0, 0, 'PT\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}-\\d{3}', 1, '[[regtime_]]', NULL, 1, 1),
('q@>=S6/', 'SE', 10, 1, 'SWE', 0, 0, 0, 'SE\\d{12}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('pҜ8N3X', 'CH', 10, 1, 'CHE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 1, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[1-9]\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('pS1z', 'ES', 10, 1, 'ESP', 0, 0, 0, 'ES[A-Z]\\d{7}[A-Z]$|^ES[A-Z][0-9]{7}[0-9A-Z]$|^ES[0-9]{8}[A-Z]', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '^([0-4]\\d{4}|5[0-2]\\d{3})$', 1, '[[regtime_]]', NULL, 1, 1),
('rƄ4ڒ', 'US', 10, 1, 'USA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(\\d{5})(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('q~<7\Z', 'LI', 10, 1, 'LIE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '948[5-9]|949[0-7]', 1, '[[regtime_]]', NULL, 1, 0),
('r;~Fu', 'AE', 10, 1, 'ARE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('qTl#\r+', 'PL', 10, 1, 'POL', 0, 0, 0, 'PL\\d{10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{2}-\\d{3}', 1, '[[regtime_]]', NULL, 1, 1),
('&r#', 'HU', 10, 1, 'HUN', 0, 0, 0, 'HU\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('/peu\0Kf', 'TR', 10, 1, 'TUR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('8sopv', 'CZ', 10, 1, 'CZE', 0, 0, 0, 'CZ\\d{8,10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('Aqp', 'SK', 10, 1, 'SVK', 0, 0, 0, 'SK\\d{10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('Js}{K @', 'RO', 10, 1, 'ROU', 0, 0, 0, 'RO(?!0)\\d{1,10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 1),
('RsĒߨ\\', 'BR', 10, 1, 'BRA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}-?\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('\\rϋp[W', 'IL', 10, 1, 'ISR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}(?:\\d{2})?', 1, '[[regtime_]]', NULL, 1, 0),
('eq`''', 'AU', 10, 1, 'AUS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('qpPt#d', 'BE', 10, 1, 'BEL', 0, 0, 0, 'BE\\d{10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('zqdOFo', 'DK', 10, 1, 'DNK', 0, 0, 0, 'DK\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('sߡ2pޓ', 'FI', 10, 1, 'FIN', 0, 0, 0, 'FI\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('qpIM7', 'FR', 10, 1, 'FRA', 0, 0, 0, 'FR[A-HJ-NP-Z0-9]{2}\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{1}(?:A|B|\\d{1}) ?\\d{3}', 1, '[[regtime_]]', NULL, 1, 1),
('\\r3(i!+', 'BG', 10, 1, 'BGR', 0, 0, 0, 'BG\\d{9,10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('\\q$ww', 'EE', 10, 1, 'EST', 0, 0, 0, 'EE\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('\\pߩv2Z', 'HR', 10, 1, 'HRV', 0, 0, 0, 'HR\\d{11}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('\\sئ&~', 'LV', 10, 1, 'LVA', 0, 0, 0, 'LV\\d{11}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(LV-)?\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('\\q޶%y,?', 'LT', 10, 1, 'LTU', 0, 0, 0, 'LT(\\d{12}|\\d{9})', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(LT-)?\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('\\re۫mQ', 'MT', 10, 1, 'MLT', 0, 0, 0, 'MT\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{3} ?\\d{2,4}', 1, '[[regtime_]]', NULL, 1, 1),
('\\q7(;', 'SI', 10, 1, 'SVN', 0, 0, 0, 'SI\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('\\s@Ci@', 'CY', 10, 1, 'CYP', 0, 0, 0, 'CY\\d{8}[A-Z]', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('\\qnQW>', 'AF', 10, 1, 'AFG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('\\rW', 'AX', 10, 1, 'ALA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '22\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('\\p" ', 'AL', 10, 1, 'ALB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('\\s,-', 'DZ', 10, 1, 'DZA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
(']	q$H2', 'AS', 10, 1, 'ASM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(96799)(?  :[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
(']p+aUV', 'AD', 10, 1, 'AND', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'AD[1-7]0\\d', 1, '[[regtime_]]', NULL, 1, 0),
(']sڇ8j ', 'AO', 10, 1, 'AGO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
(']$qa`\r.', 'AI', 10, 1, 'AIA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:AI-)?2640', 1, '[[regtime_]]', NULL, 1, 0),
(']-qְNV:', 'AQ', 10, 1, 'ATA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
(']6q<SK"', 'AG', 10, 1, 'ATG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
(']>pi[cQ', 'AR', 10, 1, 'ARG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '((?:[A-HJ-NP-Z])?\\d{4})([A-Z]{3})?', 1, '[[regtime_]]', NULL, 1, 0),
(']Hpz', 'AM', 10, 1, 'ARM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:37)?\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
(']QqG<^{', 'AW', 10, 1, 'ABW', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('][pP''B', 'AZ', 10, 1, 'AZE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
(']epڏoB', 'BS', 10, 1, 'BHS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
(']npdp', 'BH', 10, 1, 'BHR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:\\d|1[0-2])\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
(']wpsl\r0', 'BD', 10, 1, 'BGD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
(']pՋ$L9', 'BB', 10, 1, 'BRB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'BB\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
(']rcJ4̊^', 'BY', 10, 1, 'BLR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
(']s@!]C', 'BZ', 10, 1, 'BLZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
(']p', 'BJ', 10, 1, 'BEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
(']p8rQd', 'BM', 10, 1, 'BMU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{2} ?[A-Z0-9]{2}', 1, '[[regtime_]]', NULL, 1, 0),
(']rJ,''\r)"', 'BT', 10, 1, 'BTN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
(']p滞&l/S', 'BO', 10, 1, 'BOL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
(']rިNw.֔p', 'BQ', 10, 1, 'BES', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
(']qeo[rM', 'BA', 10, 1, 'BIH', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
(']s/L~O', 'BW', 10, 1, 'BWA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
(']qMчg', 'BV', 10, 1, 'BVT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
(']qNB_', 'IO', 10, 1, 'IOT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Bb]{2}[Nn][Dd]\\s{0,1}[1][Zz]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('^qnt4-', 'UM', 10, 1, 'UMI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '96898', 1, '[[regtime_]]', NULL, 1, 0),
('^/pKQD', 'VG', 10, 1, 'VGB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'VG\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('^Dq檧''U"', 'VI', 10, 1, 'VIR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(008(?:(?:[0-4]\\d)|(?:5[01])))(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('^Uqo*G', 'BN', 10, 1, 'BRN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{2} ?\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('^jsB@NΑ', 'BF', 10, 1, 'BFA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('^rր#U&?', 'BI', 10, 1, 'BDI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('^pG]W\r', 'KH', 10, 1, 'KHM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('^q.8p', 'CM', 10, 1, 'CMR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('^sڡ,''f', 'CV', 10, 1, 'CPV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('^r^іc,', 'KY', 10, 1, 'CYM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'KY\\d-\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('^pzh7\rS', 'CF', 10, 1, 'CAF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('^pujK+', 'TD', 10, 1, 'TCD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('^p-*\Zr4', 'CL', 10, 1, 'CHL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{7}', 1, '[[regtime_]]', NULL, 1, 0),
('^sڼMl]	5', 'CN', 10, 1, 'CHN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('_qĒAu', 'CX', 10, 1, 'CXR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '6798', 1, '[[regtime_]]', NULL, 1, 0),
('_\rqdIo\0', 'CC', 10, 1, 'CCK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '6799', 1, '[[regtime_]]', NULL, 1, 0),
('_q\Z+', 'CO', 10, 1, 'COL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('_se\\\0', 'KM', 10, 1, 'COM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('_(pqjA', 'CG', 10, 1, 'COG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('_1rm=e', 'CD', 10, 1, 'COD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Cc][Dd]', 1, '[[regtime_]]', NULL, 1, 0),
('_:sÏ%Pd', 'CK', 10, 1, 'COK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('_Cpn8l', 'CR', 10, 1, 'CRI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4,5}|\\d{3}-\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('_MqΣxa', 'CU', 10, 1, 'CUB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('_XsY', 'CW', 10, 1, 'CUW', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('_`q2c&	<', 'DJ', 10, 1, 'DJI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('_ipO', 'DM', 10, 1, 'DMA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('_rrtiU', 'DO', 10, 1, 'DOM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('_|poY', 'EC', 10, 1, 'ECU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('_pتz_z', 'EG', 10, 1, 'EGY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('_r0]V', 'SV', 10, 1, 'SLV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'CP [1-3][1-7][0-2]\\d', 1, '[[regtime_]]', NULL, 1, 0),
('_r˘ ll', 'GQ', 10, 1, 'GNQ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('_pTZ#}=', 'ER', 10, 1, 'ERI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('_s\Zr)r4O', 'ET', 10, 1, 'ETH', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('_pi', 'FK', 10, 1, 'FLK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Ff][Ii][Qq]{2}\\s{0,1}[1][Zz]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('_s6q3', 'FO', 10, 1, 'FRO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('_sv9', 'FJ', 10, 1, 'FJI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('_r8J', 'GF', 10, 1, 'GUF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]3\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('_sMl-O	', 'PF', 10, 1, 'PYF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '987\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('_sNw', 'TF', 10, 1, 'ATF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('_p:=Q`=_', 'GA', 10, 1, 'GAB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{2}\\s[a-zA-Z-_ ]\\s\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('_pK1T$<', 'GM', 10, 1, 'GMB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('`pz''?7\Z', 'GE', 10, 1, 'GEO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('`\nr[$', 'GH', 10, 1, 'GHA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('`rq8-<', 'GI', 10, 1, 'GIB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Gg][Xx][1]{2}\\s{0,1}[1][Aa]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('`r%', 'GL', 10, 1, 'GRL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '39\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('`)qz%w', 'GD', 10, 1, 'GRD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('`2qƘ7;l', 'GP', 10, 1, 'GLP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78][01]\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('`;pP8	N', 'GU', 10, 1, 'GUM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(969(?:[12]\\d|3[12]))(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('`Ds=$ȿ|', 'GT', 10, 1, 'GTM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('`MrlC؂', 'GG', 10, 1, 'GGY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'GY\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('`VpK{', 'GN', 10, 1, 'GIN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('``s_QZ;"', 'GW', 10, 1, 'GNB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('`iq]g3c*', 'GY', 10, 1, 'GUY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('`rs47~:4', 'HT', 10, 1, 'HTI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('`|rDgJO', 'HM', 10, 1, 'HMD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('`r쫱|', 'VA', 10, 1, 'VAT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '00120', 1, '[[regtime_]]', NULL, 1, 0),
('`svU>', 'HN', 10, 1, 'HND', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('`qГ;\0', 'HK', 10, 1, 'HKG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '999077', 1, '[[regtime_]]', NULL, 1, 0),
('`qܱ: ', 'IN', 10, 1, 'IND', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('`p\rW', 'ID', 10, 1, 'IDN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('`sϐs', 'CI', 10, 1, 'CIV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('`sUy^sa', 'IR', 10, 1, 'IRN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}-?\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('`qX؀Lh', 'IQ', 10, 1, 'IRQ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('`pЪHq \r', 'IM', 10, 1, 'IMN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'IM\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('`px<', 'JM', 10, 1, 'JAM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[a-zA-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('`sրkNZ', 'JE', 10, 1, 'JEY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'JE\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('`pɠFؼ', 'JO', 10, 1, 'JOR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('`sk[', 'KZ', 10, 1, 'KAZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('apӂ\r~', 'KE', 10, 1, 'KEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('a\ns	?Gl\Z', 'KI', 10, 1, 'KIR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('apdIr\n', 'KW', 10, 1, 'KWT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ar}%', 'KG', 10, 1, 'KGZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('a%pɭ|D($', 'LA', 10, 1, 'LAO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('a.rvu9GgC', 'LB', 10, 1, 'LBN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:\\d{4})(?: ?(?:\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('a7r< MnHI', 'LS', 10, 1, 'LSO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('a@sϼƚ|', 'LR', 10, 1, 'LBR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('aLsyy/ ', 'LY', 10, 1, 'LBY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('aUq.,9', 'MO', 10, 1, 'MAC', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '999078', 1, '[[regtime_]]', NULL, 1, 0),
('a^p_H', 'MK', 10, 1, 'MKD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ags%j', 'MG', 10, 1, 'MDG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('apr/ooaK9', 'MW', 10, 1, 'MWI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ayrƸTg!', 'MY', 10, 1, 'MYS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('asY\\Z', 'MV', 10, 1, 'MDV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('as&s', 'ML', 10, 1, 'MLI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('asJ(,@\\p@', 'MH', 10, 1, 'MHL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(969[67]\\d)(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('arh<W\\', 'MQ', 10, 1, 'MTQ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]2\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('aqǧm!1', 'MR', 10, 1, 'MRT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ap\0P;i', 'MU', 10, 1, 'MUS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}(?:\\d{2}|[A-Z]{2}\\d{3})', 1, '[[regtime_]]', NULL, 1, 0),
('aqJ', 'YT', 10, 1, 'MYT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '976\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('arQ3/N', 'MX', 10, 1, 'MEX', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('asX@az', 'FM', 10, 1, 'FSM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(9694[1-4])(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('b\0rߠй', 'MD', 10, 1, 'MDA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('b&pŎGunG', 'MC', 10, 1, 'MCO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '980\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('b<sy	UӞ', 'MN', 10, 1, 'MNG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('bSq>!%', 'ME', 10, 1, 'MNE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '8\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('bjrP2uD', 'MS', 10, 1, 'MSR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Mm][Ss][Rr]\\s{0,1}\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('b~r', 'MA', 10, 1, 'MAR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('bsTId', 'MZ', 10, 1, 'MOZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('bqWN*', 'MM', 10, 1, 'MMR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('bs蘆O', 'NR', 10, 1, 'NRU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0);
INSERT INTO `country` VALUES
('bqp;', 'NP', 10, 1, 'NPL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('br|Ro', 'NC', 10, 1, 'NCL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '988\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('bqvY', 'NZ', 10, 1, 'NZL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('brABIv:', 'NI', 10, 1, 'NIC', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('bsRĒ', 'NE', 10, 1, 'NER', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('bpҲ%]', 'NG', 10, 1, 'NGA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('bsǇb:*k', 'NU', 10, 1, 'NIU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('br*:E', 'NF', 10, 1, 'NFK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '2899', 1, '[[regtime_]]', NULL, 1, 0),
('br;)Oo`&', 'KP', 10, 1, 'PRK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('cp-', 'MP', 10, 1, 'MNP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(9695[012])(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('cq?9|oУ', 'OM', 10, 1, 'OMN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:PC )?\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('cqZ', 'PK', 10, 1, 'PAK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('c$rp*\0ø', 'PW', 10, 1, 'PLW', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(969(?:39|40))(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('c-q:rųl7', 'PS', 10, 1, 'PSE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('c5sgVGJ4', 'PA', 10, 1, 'PAN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('cBpͻ\Z!', 'PG', 10, 1, 'PNG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('cKq%yI', 'PY', 10, 1, 'PRY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('cTq؂d\\a^', 'PE', 10, 1, 'PER', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:LIMA \\d{1,2}|CALLAO 0?\\d)|[0-2]\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('c]p2t5f1}', 'PH', 10, 1, 'PHL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('cfr|t&''', 'PN', 10, 1, 'PCN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'PCRN 1ZZ', 1, '[[regtime_]]', NULL, 1, 0),
('coqdP"<', 'PR', 10, 1, 'PRI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(00[679]\\d{2})(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('cxqNؓQ5', 'QA', 10, 1, 'QAT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('csrʈ#}', 'XK', 10, 1, 'KOS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[1-7]\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('cqeB7', 'RE', 10, 1, 'REU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]4\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('cs[`', 'RU', 10, 1, 'RUS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('cpHN	i', 'RW', 10, 1, 'RWA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('csR_>(', 'BL', 10, 1, 'BLM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78][01]\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('crCJ3', 'SH', 10, 1, 'SHN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:ASCN|STHL) 1ZZ', 1, '[[regtime_]]', NULL, 1, 0),
('cq8TB{', 'KN', 10, 1, 'KNA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('cpKn"', 'LC', 10, 1, 'LCA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('cp(hX', 'MF', 10, 1, 'MAF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78][01]\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('crf\\a.Ov', 'PM', 10, 1, 'SPM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]5\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('cr0xA#Hv', 'VC', 10, 1, 'VCT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'VC\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('crp,u', 'WS', 10, 1, 'WSM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('cs֡<V', 'SM', 10, 1, 'SMR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '4789\\d', 1, '[[regtime_]]', NULL, 1, 0),
('cqN', 'ST', 10, 1, 'STP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('dpaJ''', 'SA', 10, 1, 'SAU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('dqCj;', 'SN', 10, 1, 'SEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('dp)<3g[', 'RS', 10, 1, 'SRB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5,6}', 1, '[[regtime_]]', NULL, 1, 0),
('d!sXΓ''', 'SC', 10, 1, 'SYC', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d*sF\Z2Td', 'SL', 10, 1, 'SLE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d3q{Ǌ3', 'SG', 10, 1, 'SGP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('d<sD\rͿ', 'SX', 10, 1, 'SXM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('dEq4m,$eb', 'SB', 10, 1, 'SLB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('dMp3^N', 'SO', 10, 1, 'SOM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{2} ?\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('dWpͶyOZ', 'ZA', 10, 1, 'ZAF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d`p(nP9N+', 'GS', 10, 1, 'SGS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Ss][Ii][Qq]{2}\\s{0,1}[1][Zz]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('dsp9̹{', 'KR', 10, 1, 'KOR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}(?:\\d{2}|-\\d{3})', 1, '[[regtime_]]', NULL, 1, 0),
('d{rنᰑH', 'SS', 10, 1, 'SSD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('dsT`&U0P', 'LK', 10, 1, 'LKA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('dpܻA)', 'SD', 10, 1, 'SDN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('dp$;', 'SR', 10, 1, 'SUR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('dsm^', 'SJ', 10, 1, 'SJM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('dsUߏ37', 'SZ', 10, 1, 'SWZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[HLMS]\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('dq^91I', 'SY', 10, 1, 'SYR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ds`HF,', 'TW', 10, 1, 'TWN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}(?:\\d{2})?', 1, '[[regtime_]]', NULL, 1, 0),
('dsނטo', 'TJ', 10, 1, 'TJK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('dsࣈܨs', 'TZ', 10, 1, 'TZA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4,5}', 1, '[[regtime_]]', NULL, 1, 0),
('dpQwZ}Dj', 'TH', 10, 1, 'THA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('dpV,e', 'TL', 10, 1, 'TLS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('dr94vv', 'TG', 10, 1, 'TGO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('dp.$', 'TK', 10, 1, 'TKL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('e\0p$ب', 'TO', 10, 1, 'TON', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('e	pIx', 'TT', 10, 1, 'TTO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('erOZuI', 'TN', 10, 1, 'TUN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('e\ZsQ޸7n', 'TM', 10, 1, 'TKM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('e$spDls.', 'TC', 10, 1, 'TCA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'TKCA 1ZZ', 1, '[[regtime_]]', NULL, 1, 0),
('e.p`m', 'TV', 10, 1, 'TUV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('e7r֑dS', 'UG', 10, 1, 'UGA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('e@r/ϺE<', 'UA', 10, 1, 'UKR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('eJsѣ.Xe', 'UY', 10, 1, 'URY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('eTs8+-b', 'UZ', 10, 1, 'UZB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('e^q^', 'VU', 10, 1, 'VUT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ehs֨5A>w1=', 'VE', 10, 1, 'VEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('erswŃ0Z}', 'VN', 10, 1, 'VNM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('e{q핾', 'WF', 10, 1, 'WLF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '986\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('erm׾G', 'EH', 10, 1, 'ESH', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ep\\', 'YE', 10, 1, 'YEM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('eqH', 'ZM', 10, 1, 'ZMB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('erFd', 'ZW', 10, 1, 'ZWE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `country_state`
--

CREATE TABLE `country_state` (
  `id` binary(16) NOT NULL,
  `country_id` binary(16) NOT NULL,
  `short_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` int NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.country_state.country_id` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_state`
--

INSERT INTO `country_state` VALUES
('\npYJ', '\nq!$', 'DE-BW', 1, 1, '[[regtime_]]', NULL),
('\0qT^qS', '\nq!$', 'DE-BY', 1, 1, '[[regtime_]]', NULL),
('qͦ:=:', '\nq!$', 'DE-BE', 1, 1, '[[regtime_]]', NULL),
('rd̹', '\nq!$', 'DE-BB', 1, 1, '[[regtime_]]', NULL),
('qy{煿', '\nq!$', 'DE-HB', 1, 1, '[[regtime_]]', NULL),
('&pӛ)UH''', '\nq!$', 'DE-HH', 1, 1, '[[regtime_]]', NULL),
('/p0', '\nq!$', 'DE-HE', 1, 1, '[[regtime_]]', NULL),
('7q%{*', '\nq!$', 'DE-NI', 1, 1, '[[regtime_]]', NULL),
('Cr''%GP)', '\nq!$', 'DE-MV', 1, 1, '[[regtime_]]', NULL),
('LsF@', '\nq!$', 'DE-NW', 1, 1, '[[regtime_]]', NULL),
('WpH3FH3', '\nq!$', 'DE-RP', 1, 1, '[[regtime_]]', NULL),
('`sӠn&-s', '\nq!$', 'DE-SL', 1, 1, '[[regtime_]]', NULL),
('is5\0g)k', '\nq!$', 'DE-SN', 1, 1, '[[regtime_]]', NULL),
('rs\nn', '\nq!$', 'DE-ST', 1, 1, '[[regtime_]]', NULL),
('{s{''nz', '\nq!$', 'DE-SH', 1, 1, '[[regtime_]]', NULL),
('pͨK', '\nq!$', 'DE-TH', 1, 1, '[[regtime_]]', NULL),
('sdo\0', 'qo''n/|}', 'GB-ENG', 1, 1, '[[regtime_]]', NULL),
('pv.b', 'qo''n/|}', 'GB-NIR', 1, 1, '[[regtime_]]', NULL),
('r', 'qo''n/|}', 'GB-SCT', 1, 1, '[[regtime_]]', NULL),
('s$\rF}', 'qo''n/|}', 'GB-WLS', 1, 1, '[[regtime_]]', NULL),
('pN\0', 'qo''n/|}', 'GB-EAW', 1, 1, '[[regtime_]]', NULL),
('rxVFw', 'qo''n/|}', 'GB-GBN', 1, 1, '[[regtime_]]', NULL),
('rɩ3+m', 'qo''n/|}', 'GB-UKM', 1, 1, '[[regtime_]]', NULL),
('s94˿', 'qo''n/|}', 'GB-BKM', 1, 1, '[[regtime_]]', NULL),
('p3 3S', 'qo''n/|}', 'GB-CAM', 1, 1, '[[regtime_]]', NULL),
('sg[K*>', 'qo''n/|}', 'GB-CMA', 1, 1, '[[regtime_]]', NULL),
('pTM\n', 'qo''n/|}', 'GB-DBY', 1, 1, '[[regtime_]]', NULL),
('pઙM-ԟH', 'qo''n/|}', 'GB-DEV', 1, 1, '[[regtime_]]', NULL),
('sy%', 'qo''n/|}', 'GB-DOR', 1, 1, '[[regtime_]]', NULL),
('p5rΜlh', 'qo''n/|}', 'GB-ESX', 1, 1, '[[regtime_]]', NULL),
('q܉l', 'qo''n/|}', 'GB-ESS', 1, 1, '[[regtime_]]', NULL),
('pǶ&O|s', 'qo''n/|}', 'GB-GLS', 1, 1, '[[regtime_]]', NULL),
('r:?C=', 'qo''n/|}', 'GB-HAM', 1, 1, '[[regtime_]]', NULL),
(' r	Thf', 'qo''n/|}', 'GB-HRT', 1, 1, '[[regtime_]]', NULL),
('&qy\nl4o', 'qo''n/|}', 'GB-KEN', 1, 1, '[[regtime_]]', NULL),
(',qev?hIzQ', 'qo''n/|}', 'GB-LAN', 1, 1, '[[regtime_]]', NULL),
('1p', 'qo''n/|}', 'GB-LEC', 1, 1, '[[regtime_]]', NULL),
('7qxHݑ', 'qo''n/|}', 'GB-LIN', 1, 1, '[[regtime_]]', NULL),
('=r[Z0*w', 'qo''n/|}', 'GB-NFK', 1, 1, '[[regtime_]]', NULL),
('Cr܈', 'qo''n/|}', 'GB-NYK', 1, 1, '[[regtime_]]', NULL),
('Is%}', 'qo''n/|}', 'GB-NTH', 1, 1, '[[regtime_]]', NULL),
('OsQ	ju\\|', 'qo''n/|}', 'GB-NTT', 1, 1, '[[regtime_]]', NULL),
('UrSu|O', 'qo''n/|}', 'GB-OXF', 1, 1, '[[regtime_]]', NULL),
('[p5T\r', 'qo''n/|}', 'GB-SOM', 1, 1, '[[regtime_]]', NULL),
('`suɦ{', 'qo''n/|}', 'GB-STS', 1, 1, '[[regtime_]]', NULL),
('fq6+w', 'qo''n/|}', 'GB-SFK', 1, 1, '[[regtime_]]', NULL),
('lsb,c', 'qo''n/|}', 'GB-SRY', 1, 1, '[[regtime_]]', NULL),
('rs*7#n?t', 'qo''n/|}', 'GB-WAR', 1, 1, '[[regtime_]]', NULL),
('xp@[#', 'qo''n/|}', 'GB-WSX', 1, 1, '[[regtime_]]', NULL),
('sބ|x', 'qo''n/|}', 'GB-WOR', 1, 1, '[[regtime_]]', NULL),
('riT', 'qo''n/|}', 'GB-LND', 1, 1, '[[regtime_]]', NULL),
('qJ\nv', 'qo''n/|}', 'GB-BDG', 1, 1, '[[regtime_]]', NULL),
('qM', 'qo''n/|}', 'GB-BNE', 1, 1, '[[regtime_]]', NULL),
('qu5ia', 'qo''n/|}', 'GB-BEX', 1, 1, '[[regtime_]]', NULL),
('q.', 'qo''n/|}', 'GB-BEN', 1, 1, '[[regtime_]]', NULL),
('rͰѰt', 'qo''n/|}', 'GB-BRY', 1, 1, '[[regtime_]]', NULL),
('rZHM徎H', 'qo''n/|}', 'GB-CMD', 1, 1, '[[regtime_]]', NULL),
('rzۗ', 'qo''n/|}', 'GB-CRY', 1, 1, '[[regtime_]]', NULL),
('q̤4=', 'qo''n/|}', 'GB-EAL', 1, 1, '[[regtime_]]', NULL),
('r@_חR', 'qo''n/|}', 'GB-ENF', 1, 1, '[[regtime_]]', NULL),
('pz\\20', 'qo''n/|}', 'GB-GRE', 1, 1, '[[regtime_]]', NULL),
('r\\4', 'qo''n/|}', 'GB-HCK', 1, 1, '[[regtime_]]', NULL),
('p#MgC', 'qo''n/|}', 'GB-HMF', 1, 1, '[[regtime_]]', NULL),
('qCGE*^o', 'qo''n/|}', 'GB-HRY', 1, 1, '[[regtime_]]', NULL),
('ptSØ', 'qo''n/|}', 'GB-HRW', 1, 1, '[[regtime_]]', NULL),
('q;dql2', 'qo''n/|}', 'GB-HAV', 1, 1, '[[regtime_]]', NULL),
('q\nfd', 'qo''n/|}', 'GB-HIL', 1, 1, '[[regtime_]]', NULL),
('sw', 'qo''n/|}', 'GB-HNS', 1, 1, '[[regtime_]]', NULL),
('s{~!T+', 'qo''n/|}', 'GB-ISL', 1, 1, '[[regtime_]]', NULL),
('rz0', 'qo''n/|}', 'GB-KEC', 1, 1, '[[regtime_]]', NULL),
('\rsїӳx', 'qo''n/|}', 'GB-KTT', 1, 1, '[[regtime_]]', NULL),
('\rq꽞ש@&>', 'qo''n/|}', 'GB-LBH', 1, 1, '[[regtime_]]', NULL),
('\rr>.и', 'qo''n/|}', 'GB-LEW', 1, 1, '[[regtime_]]', NULL),
('\rrs-+', 'qo''n/|}', 'GB-MRT', 1, 1, '[[regtime_]]', NULL),
('\r\Zr\nxH2q', 'qo''n/|}', 'GB-NWM', 1, 1, '[[regtime_]]', NULL),
('\r sV͹<', 'qo''n/|}', 'GB-RDB', 1, 1, '[[regtime_]]', NULL),
('\r&rHS', 'qo''n/|}', 'GB-RIC', 1, 1, '[[regtime_]]', NULL),
('\r,qO', 'qo''n/|}', 'GB-SWK', 1, 1, '[[regtime_]]', NULL),
('\r2s:Z(=', 'qo''n/|}', 'GB-STN', 1, 1, '[[regtime_]]', NULL),
('\r8p?}', 'qo''n/|}', 'GB-TWH', 1, 1, '[[regtime_]]', NULL),
('\r>pӦCV ', 'qo''n/|}', 'GB-WFT', 1, 1, '[[regtime_]]', NULL),
('\rErE/', 'qo''n/|}', 'GB-WND', 1, 1, '[[regtime_]]', NULL),
('\rMp܎\\x', 'qo''n/|}', 'GB-WSM', 1, 1, '[[regtime_]]', NULL),
('\rRp5\rj[', 'qo''n/|}', 'GB-BNS', 1, 1, '[[regtime_]]', NULL),
('\rXr=̈́M', 'qo''n/|}', 'GB-BIR', 1, 1, '[[regtime_]]', NULL),
('\r_r}ib', 'qo''n/|}', 'GB-BOL', 1, 1, '[[regtime_]]', NULL),
('\resDqF̪', 'qo''n/|}', 'GB-BRD', 1, 1, '[[regtime_]]', NULL),
('\rkq-', 'qo''n/|}', 'GB-BUR', 1, 1, '[[regtime_]]', NULL),
('\rqqM@5	{', 'qo''n/|}', 'GB-CLD', 1, 1, '[[regtime_]]', NULL),
('\rwp$󺍳X', 'qo''n/|}', 'GB-COV', 1, 1, '[[regtime_]]', NULL),
('\r}p', 'qo''n/|}', 'GB-DNC', 1, 1, '[[regtime_]]', NULL),
('\rp=qܦB', 'qo''n/|}', 'GB-DUD', 1, 1, '[[regtime_]]', NULL),
('\rrȎWb', 'qo''n/|}', 'GB-GAT', 1, 1, '[[regtime_]]', NULL),
('\rp\Z8گ2', 'qo''n/|}', 'GB-KIR', 1, 1, '[[regtime_]]', NULL),
('\rp:s', 'qo''n/|}', 'GB-KWL', 1, 1, '[[regtime_]]', NULL),
('\rs	', 'qo''n/|}', 'GB-LDS', 1, 1, '[[regtime_]]', NULL),
('\rrb\Z', 'qo''n/|}', 'GB-LIV', 1, 1, '[[regtime_]]', NULL),
('\rsϿ\nx', 'qo''n/|}', 'GB-MAN', 1, 1, '[[regtime_]]', NULL),
('\rq[^}', 'qo''n/|}', 'GB-NET', 1, 1, '[[regtime_]]', NULL),
('\rsL+I', 'qo''n/|}', 'GB-NTY', 1, 1, '[[regtime_]]', NULL),
('\rrs', 'qo''n/|}', 'GB-OLD', 1, 1, '[[regtime_]]', NULL),
('\rpƥB\ZG\Z.', 'qo''n/|}', 'GB-RCH', 1, 1, '[[regtime_]]', NULL),
('\rp,y^', 'qo''n/|}', 'GB-ROT', 1, 1, '[[regtime_]]', NULL),
('\rpլ%\\\Z', 'qo''n/|}', 'GB-SHN', 1, 1, '[[regtime_]]', NULL),
('\rp1W-)', 'qo''n/|}', 'GB-SLF', 1, 1, '[[regtime_]]', NULL),
('\rrR}{', 'qo''n/|}', 'GB-SAW', 1, 1, '[[regtime_]]', NULL),
('\rr\ne5T', 'qo''n/|}', 'GB-SFT', 1, 1, '[[regtime_]]', NULL),
('\rqU\ZN赒', 'qo''n/|}', 'GB-SHF', 1, 1, '[[regtime_]]', NULL),
('\rp6M ', 'qo''n/|}', 'GB-SOL', 1, 1, '[[regtime_]]', NULL),
('\rs̒6E', 'qo''n/|}', 'GB-STY', 1, 1, '[[regtime_]]', NULL),
('\rp0 gp', 'qo''n/|}', 'GB-SKP', 1, 1, '[[regtime_]]', NULL),
('\0s', 'qo''n/|}', 'GB-SND', 1, 1, '[[regtime_]]', NULL),
('\rsxd,e', 'qo''n/|}', 'GB-TAM', 1, 1, '[[regtime_]]', NULL),
('`q|%Ct)', 'qo''n/|}', 'GB-TRF', 1, 1, '[[regtime_]]', NULL),
('p\\^&r', 'qo''n/|}', 'GB-WKF', 1, 1, '[[regtime_]]', NULL),
('q+B', 'qo''n/|}', 'GB-WLL', 1, 1, '[[regtime_]]', NULL),
('-qu<5\0', 'qo''n/|}', 'GB-WGN', 1, 1, '[[regtime_]]', NULL),
('pW', 'qo''n/|}', 'GB-WRL', 1, 1, '[[regtime_]]', NULL),
('s''-o2%', 'qo''n/|}', 'GB-WLV', 1, 1, '[[regtime_]]', NULL),
('^sg^`r', 'qo''n/|}', 'GB-BAS', 1, 1, '[[regtime_]]', NULL),
('rqgF<', 'qo''n/|}', 'GB-BDF', 1, 1, '[[regtime_]]', NULL),
('q{8,', 'qo''n/|}', 'GB-BBD', 1, 1, '[[regtime_]]', NULL),
('r{{U', 'qo''n/|}', 'GB-BPL', 1, 1, '[[regtime_]]', NULL),
('''r5', 'qo''n/|}', 'GB-BMH', 1, 1, '[[regtime_]]', NULL),
('Lq\rGA>]>', 'qo''n/|}', 'GB-BRC', 1, 1, '[[regtime_]]', NULL),
('SqsIb!ޞ', 'qo''n/|}', 'GB-BNH', 1, 1, '[[regtime_]]', NULL),
('Xso{]C	', 'qo''n/|}', 'GB-BST', 1, 1, '[[regtime_]]', NULL),
('^sǒ', 'qo''n/|}', 'GB-CBF', 1, 1, '[[regtime_]]', NULL),
('dqGϞ>f', 'qo''n/|}', 'GB-CHE', 1, 1, '[[regtime_]]', NULL),
('jqz8<', 'qo''n/|}', 'GB-CHW', 1, 1, '[[regtime_]]', NULL),
('ps^J>', 'qo''n/|}', 'GB-CON', 1, 1, '[[regtime_]]', NULL),
('urO\\aE%o', 'qo''n/|}', 'GB-DAL', 1, 1, '[[regtime_]]', NULL),
('{s2	/ґ', 'qo''n/|}', 'GB-DER', 1, 1, '[[regtime_]]', NULL),
('p56', 'qo''n/|}', 'GB-DUR', 1, 1, '[[regtime_]]', NULL),
('r{', 'qo''n/|}', 'GB-ERY', 1, 1, '[[regtime_]]', NULL),
('p!݃Jm', 'qo''n/|}', 'GB-HAL', 1, 1, '[[regtime_]]', NULL),
('q,v', 'qo''n/|}', 'GB-HPL', 1, 1, '[[regtime_]]', NULL),
('qۗ; FM', 'qo''n/|}', 'GB-HEF', 1, 1, '[[regtime_]]', NULL),
('rA	ci', 'qo''n/|}', 'GB-IOW', 1, 1, '[[regtime_]]', NULL),
('sy7cp', 'qo''n/|}', 'GB-IOS', 1, 1, '[[regtime_]]', NULL),
('pZQ', 'qo''n/|}', 'GB-KHL', 1, 1, '[[regtime_]]', NULL),
('rq2o', 'qo''n/|}', 'GB-LCE', 1, 1, '[[regtime_]]', NULL),
('qv	o', 'qo''n/|}', 'GB-LUT', 1, 1, '[[regtime_]]', NULL),
('r Rh', 'qo''n/|}', 'GB-MDW', 1, 1, '[[regtime_]]', NULL),
('p"[S', 'qo''n/|}', 'GB-MDB', 1, 1, '[[regtime_]]', NULL),
('sK~', 'qo''n/|}', 'GB-MIK', 1, 1, '[[regtime_]]', NULL),
('r,Ep', 'qo''n/|}', 'GB-NEL', 1, 1, '[[regtime_]]', NULL),
('qׇCT', 'qo''n/|}', 'GB-NLN', 1, 1, '[[regtime_]]', NULL),
('px՛%c0', 'qo''n/|}', 'GB-NSM', 1, 1, '[[regtime_]]', NULL),
('re', 'qo''n/|}', 'GB-NBL', 1, 1, '[[regtime_]]', NULL),
('r٩W2', 'qo''n/|}', 'GB-NGM', 1, 1, '[[regtime_]]', NULL),
('s{%ᓛ#', 'qo''n/|}', 'GB-PTE', 1, 1, '[[regtime_]]', NULL),
('s"bxn@', 'qo''n/|}', 'GB-PLY', 1, 1, '[[regtime_]]', NULL),
('r5})K7', 'qo''n/|}', 'GB-POL', 1, 1, '[[regtime_]]', NULL),
('r07', 'qo''n/|}', 'GB-POR', 1, 1, '[[regtime_]]', NULL),
('	pRŽ5/', 'qo''n/|}', 'GB-RDG', 1, 1, '[[regtime_]]', NULL),
('#sD e', 'qo''n/|}', 'GB-RCC', 1, 1, '[[regtime_]]', NULL),
(')rʷ\ZN问o', 'qo''n/|}', 'GB-RUT', 1, 1, '[[regtime_]]', NULL),
('.p<#gK', 'qo''n/|}', 'GB-SHR', 1, 1, '[[regtime_]]', NULL),
('4q쇂v_', 'qo''n/|}', 'GB-SLG', 1, 1, '[[regtime_]]', NULL),
(';rEξ4', 'qo''n/|}', 'GB-SGC', 1, 1, '[[regtime_]]', NULL),
('Apn*rL', 'qo''n/|}', 'GB-STH', 1, 1, '[[regtime_]]', NULL),
('Gsyb`', 'qo''n/|}', 'GB-SOS', 1, 1, '[[regtime_]]', NULL),
('MpxsU', 'qo''n/|}', 'GB-STT', 1, 1, '[[regtime_]]', NULL),
('SqRp', 'qo''n/|}', 'GB-STE', 1, 1, '[[regtime_]]', NULL),
('Ys_BHC', 'qo''n/|}', 'GB-SWD', 1, 1, '[[regtime_]]', NULL),
('_sCtlŵ', 'qo''n/|}', 'GB-TFW', 1, 1, '[[regtime_]]', NULL),
('eqF֟3', 'qo''n/|}', 'GB-THR', 1, 1, '[[regtime_]]', NULL),
('krM|VÒ3', 'qo''n/|}', 'GB-TOB', 1, 1, '[[regtime_]]', NULL),
('qrjA@T', 'qo''n/|}', 'GB-WRT', 1, 1, '[[regtime_]]', NULL),
('wsE\r̶>''0', 'qo''n/|}', 'GB-WBK', 1, 1, '[[regtime_]]', NULL),
('}rz:', 'qo''n/|}', 'GB-WIL', 1, 1, '[[regtime_]]', NULL),
('rRk\n', 'qo''n/|}', 'GB-WNM', 1, 1, '[[regtime_]]', NULL),
('r̸֋-', 'qo''n/|}', 'GB-WOK', 1, 1, '[[regtime_]]', NULL),
('s^eZfv?', 'qo''n/|}', 'GB-YOR', 1, 1, '[[regtime_]]', NULL),
('pǆ35SU', 'qo''n/|}', 'GB-ANN', 1, 1, '[[regtime_]]', NULL),
('s\\,?', 'qo''n/|}', 'GB-AND', 1, 1, '[[regtime_]]', NULL),
('qޖ^', 'qo''n/|}', 'GB-ABC', 1, 1, '[[regtime_]]', NULL),
('qa{wR', 'qo''n/|}', 'GB-BFS', 1, 1, '[[regtime_]]', NULL),
('p', 'qo''n/|}', 'GB-CCG', 1, 1, '[[regtime_]]', NULL),
('qz6(', 'qo''n/|}', 'GB-DRS', 1, 1, '[[regtime_]]', NULL),
('qc+\0uX', 'qo''n/|}', 'GB-FMO', 1, 1, '[[regtime_]]', NULL),
('pX{', 'qo''n/|}', 'GB-LBC', 1, 1, '[[regtime_]]', NULL),
('qi2', 'qo''n/|}', 'GB-MEA', 1, 1, '[[regtime_]]', NULL),
('pŘ3', 'qo''n/|}', 'GB-MUL', 1, 1, '[[regtime_]]', NULL),
('roGZJy', 'qo''n/|}', 'GB-NMD', 1, 1, '[[regtime_]]', NULL),
('rΓzΞi*', 'qo''n/|}', 'GB-ABE', 1, 1, '[[regtime_]]', NULL),
('r3Ī2@', 'qo''n/|}', 'GB-ABD', 1, 1, '[[regtime_]]', NULL),
('q/fQ', 'qo''n/|}', 'GB-ANS', 1, 1, '[[regtime_]]', NULL),
('sˉD', 'qo''n/|}', 'GB-AGB', 1, 1, '[[regtime_]]', NULL),
('syN{6', 'qo''n/|}', 'GB-CLK', 1, 1, '[[regtime_]]', NULL),
('pgD"', 'qo''n/|}', 'GB-DGY', 1, 1, '[[regtime_]]', NULL),
('q!w6o', 'qo''n/|}', 'GB-DND', 1, 1, '[[regtime_]]', NULL),
('qY6>"', 'qo''n/|}', 'GB-EAY', 1, 1, '[[regtime_]]', NULL),
('rXC9', 'qo''n/|}', 'GB-EDU', 1, 1, '[[regtime_]]', NULL),
('rjG2z3', 'qo''n/|}', 'GB-ELN', 1, 1, '[[regtime_]]', NULL),
('rζ+', 'qo''n/|}', 'GB-ERW', 1, 1, '[[regtime_]]', NULL),
('rޥhTZ', 'qo''n/|}', 'GB-EDH', 1, 1, '[[regtime_]]', NULL),
('%r{>e', 'qo''n/|}', 'GB-ELS', 1, 1, '[[regtime_]]', NULL),
('+pǁ~8A', 'qo''n/|}', 'GB-FAL', 1, 1, '[[regtime_]]', NULL),
('1sBO)"', 'qo''n/|}', 'GB-FIF', 1, 1, '[[regtime_]]', NULL),
('7rg%@"', 'qo''n/|}', 'GB-GLG', 1, 1, '[[regtime_]]', NULL),
('=r)qw1', 'qo''n/|}', 'GB-HLD', 1, 1, '[[regtime_]]', NULL),
('Ds=ԍ-^', 'qo''n/|}', 'GB-IVC', 1, 1, '[[regtime_]]', NULL),
('Ls{s', 'qo''n/|}', 'GB-MLN', 1, 1, '[[regtime_]]', NULL),
('QrÀge', 'qo''n/|}', 'GB-MRY', 1, 1, '[[regtime_]]', NULL),
('Wq8Y1', 'qo''n/|}', 'GB-NAY', 1, 1, '[[regtime_]]', NULL),
(']rċH', 'qo''n/|}', 'GB-NLK', 1, 1, '[[regtime_]]', NULL),
('drJm@', 'qo''n/|}', 'GB-ORK', 1, 1, '[[regtime_]]', NULL),
('kp"ݏjE', 'qo''n/|}', 'GB-PKN', 1, 1, '[[regtime_]]', NULL),
('rsȮ}Sɘ', 'qo''n/|}', 'GB-RFW', 1, 1, '[[regtime_]]', NULL),
('xqFHm', 'qo''n/|}', 'GB-SCB', 1, 1, '[[regtime_]]', NULL),
('s?TÑ', 'qo''n/|}', 'GB-ZET', 1, 1, '[[regtime_]]', NULL),
('sR\0ViI', 'qo''n/|}', 'GB-SAY', 1, 1, '[[regtime_]]', NULL),
('rq,', 'qo''n/|}', 'GB-SLK', 1, 1, '[[regtime_]]', NULL),
('rXpcx', 'qo''n/|}', 'GB-STG', 1, 1, '[[regtime_]]', NULL),
('pf]1f', 'qo''n/|}', 'GB-WDU', 1, 1, '[[regtime_]]', NULL),
('s2CL', 'qo''n/|}', 'GB-WLN', 1, 1, '[[regtime_]]', NULL),
('sp9%', 'qo''n/|}', 'GB-BGW', 1, 1, '[[regtime_]]', NULL),
('so8A', 'qo''n/|}', 'GB-BGE', 1, 1, '[[regtime_]]', NULL),
('r \n@Կ', 'qo''n/|}', 'GB-CAY', 1, 1, '[[regtime_]]', NULL),
('rL3L', 'qo''n/|}', 'GB-CRF', 1, 1, '[[regtime_]]', NULL),
('q@X0%E', 'qo''n/|}', 'GB-CMN', 1, 1, '[[regtime_]]', NULL),
('pOa2N', 'qo''n/|}', 'GB-CGN', 1, 1, '[[regtime_]]', NULL),
('szDNO\Z', 'qo''n/|}', 'GB-CWY', 1, 1, '[[regtime_]]', NULL),
('pG.P]', 'qo''n/|}', 'GB-DEN', 1, 1, '[[regtime_]]', NULL),
('p', 'qo''n/|}', 'GB-FLN', 1, 1, '[[regtime_]]', NULL),
('qAo;5', 'qo''n/|}', 'GB-GWN', 1, 1, '[[regtime_]]', NULL),
('s-\r߼', 'qo''n/|}', 'GB-AGY', 1, 1, '[[regtime_]]', NULL),
('q1k\r', 'qo''n/|}', 'GB-MTY', 1, 1, '[[regtime_]]', NULL),
('	sd:ၡq', 'qo''n/|}', 'GB-MON', 1, 1, '[[regtime_]]', NULL),
('sĻ3Q', 'qo''n/|}', 'GB-NTL', 1, 1, '[[regtime_]]', NULL),
('qV', 'qo''n/|}', 'GB-NWP', 1, 1, '[[regtime_]]', NULL),
('pڟ9J', 'qo''n/|}', 'GB-PEM', 1, 1, '[[regtime_]]', NULL),
('#sjb', 'qo''n/|}', 'GB-POW', 1, 1, '[[regtime_]]', NULL),
(')q*1ͻ^', 'qo''n/|}', 'GB-RCT', 1, 1, '[[regtime_]]', NULL),
('/r\\', 'qo''n/|}', 'GB-SWA', 1, 1, '[[regtime_]]', NULL),
('5p_[o', 'qo''n/|}', 'GB-TOF', 1, 1, '[[regtime_]]', NULL),
(';p2\0IM', 'qo''n/|}', 'GB-VGL', 1, 1, '[[regtime_]]', NULL),
('Ap˹@B`x', 'qo''n/|}', 'GB-WRX', 1, 1, '[[regtime_]]', NULL),
('q''q&', 'rƄ4ڒ', 'US-AL', 1, 1, '[[regtime_]]', NULL),
('s]Y', 'rƄ4ڒ', 'US-AK', 1, 1, '[[regtime_]]', NULL),
('s"~Z', 'rƄ4ڒ', 'US-AZ', 1, 1, '[[regtime_]]', NULL),
('pJ@(', 'rƄ4ڒ', 'US-AR', 1, 1, '[[regtime_]]', NULL),
('pʋ.cj', 'rƄ4ڒ', 'US-CA', 1, 1, '[[regtime_]]', NULL),
('q4Aog', 'rƄ4ڒ', 'US-CO', 1, 1, '[[regtime_]]', NULL),
('q9=(Wr', 'rƄ4ڒ', 'US-CT', 1, 1, '[[regtime_]]', NULL),
('r6\Z5', 'rƄ4ڒ', 'US-DE', 1, 1, '[[regtime_]]', NULL),
('qyj3', 'rƄ4ڒ', 'US-FL', 1, 1, '[[regtime_]]', NULL),
('pfxr', 'rƄ4ڒ', 'US-GA', 1, 1, '[[regtime_]]', NULL),
('rJ]\r', 'rƄ4ڒ', 'US-HI', 1, 1, '[[regtime_]]', NULL),
('sЯ''?4', 'rƄ4ڒ', 'US-ID', 1, 1, '[[regtime_]]', NULL),
('\Zpr "{', 'rƄ4ڒ', 'US-IL', 1, 1, '[[regtime_]]', NULL),
(' rBZ)pZVv', 'rƄ4ڒ', 'US-IN', 1, 1, '[[regtime_]]', NULL),
('&p8tg', 'rƄ4ڒ', 'US-IA', 1, 1, '[[regtime_]]', NULL),
(',p7ʻ', 'rƄ4ڒ', 'US-KS', 1, 1, '[[regtime_]]', NULL),
('2p>', 'rƄ4ڒ', 'US-KY', 1, 1, '[[regtime_]]', NULL),
('8r\r\\v''', 'rƄ4ڒ', 'US-LA', 1, 1, '[[regtime_]]', NULL),
('@q5]H', 'rƄ4ڒ', 'US-ME', 1, 1, '[[regtime_]]', NULL),
('Fp C', 'rƄ4ڒ', 'US-MD', 1, 1, '[[regtime_]]', NULL),
('LqA"ǆ7"', 'rƄ4ڒ', 'US-MA', 1, 1, '[[regtime_]]', NULL),
('Rp5F%q:', 'rƄ4ڒ', 'US-MI', 1, 1, '[[regtime_]]', NULL),
('Xp*M', 'rƄ4ڒ', 'US-MN', 1, 1, '[[regtime_]]', NULL),
('^rů+b\0', 'rƄ4ڒ', 'US-MS', 1, 1, '[[regtime_]]', NULL),
('cpı$щ', 'rƄ4ڒ', 'US-MO', 1, 1, '[[regtime_]]', NULL),
('is\n`-', 'rƄ4ڒ', 'US-MT', 1, 1, '[[regtime_]]', NULL),
('oq3%֩', 'rƄ4ڒ', 'US-NE', 1, 1, '[[regtime_]]', NULL),
('us2Iv/a', 'rƄ4ڒ', 'US-NV', 1, 1, '[[regtime_]]', NULL),
('{p@Ii', 'rƄ4ڒ', 'US-NH', 1, 1, '[[regtime_]]', NULL),
('q>q3', 'rƄ4ڒ', 'US-NJ', 1, 1, '[[regtime_]]', NULL),
('s:,dV', 'rƄ4ڒ', 'US-NM', 1, 1, '[[regtime_]]', NULL),
('p$F]', 'rƄ4ڒ', 'US-NY', 1, 1, '[[regtime_]]', NULL),
('r^^39', 'rƄ4ڒ', 'US-NC', 1, 1, '[[regtime_]]', NULL),
('p0s\n', 'rƄ4ڒ', 'US-ND', 1, 1, '[[regtime_]]', NULL),
('rۃsU', 'rƄ4ڒ', 'US-OH', 1, 1, '[[regtime_]]', NULL),
('p]0', 'rƄ4ڒ', 'US-OK', 1, 1, '[[regtime_]]', NULL),
('pPԕ0', 'rƄ4ڒ', 'US-OR', 1, 1, '[[regtime_]]', NULL),
('rXx', 'rƄ4ڒ', 'US-PA', 1, 1, '[[regtime_]]', NULL),
('s|Jgl', 'rƄ4ڒ', 'US-RI', 1, 1, '[[regtime_]]', NULL),
('r=?QrC', 'rƄ4ڒ', 'US-SC', 1, 1, '[[regtime_]]', NULL),
('q|L', 'rƄ4ڒ', 'US-SD', 1, 1, '[[regtime_]]', NULL),
('p''nľ', 'rƄ4ڒ', 'US-TN', 1, 1, '[[regtime_]]', NULL),
('pe+\ZL', 'rƄ4ڒ', 'US-TX', 1, 1, '[[regtime_]]', NULL),
('rUzt8', 'rƄ4ڒ', 'US-UT', 1, 1, '[[regtime_]]', NULL),
('rra', 'rƄ4ڒ', 'US-VT', 1, 1, '[[regtime_]]', NULL),
('sM\\m', 'rƄ4ڒ', 'US-VA', 1, 1, '[[regtime_]]', NULL),
('q"	Z', 'rƄ4ڒ', 'US-WA', 1, 1, '[[regtime_]]', NULL),
('sƗ@90', 'rƄ4ڒ', 'US-WV', 1, 1, '[[regtime_]]', NULL),
('p#6', 'rƄ4ڒ', 'US-WI', 1, 1, '[[regtime_]]', NULL),
('px', 'rƄ4ڒ', 'US-WY', 1, 1, '[[regtime_]]', NULL),
('sl', 'rƄ4ڒ', 'US-DC', 1, 1, '[[regtime_]]', NULL),
('qK{t', 'ksįCzf', 'CA-ON', 1, 1, '[[regtime_]]', NULL),
('qK', 'ksįCzf', 'CA-QC', 1, 1, '[[regtime_]]', NULL),
('qKik', 'ksįCzf', 'CA-NS', 1, 1, '[[regtime_]]', NULL),
('qK)s', 'ksįCzf', 'CA-NB', 1, 1, '[[regtime_]]', NULL),
('qK9', 'ksįCzf', 'CA-MB', 1, 1, '[[regtime_]]', NULL),
('qK\n', 'ksįCzf', 'CA-BC', 1, 1, '[[regtime_]]', NULL),
('qK', 'ksįCzf', 'CA-PE', 1, 1, '[[regtime_]]', NULL),
('qK', 'ksįCzf', 'CA-SK', 1, 1, '[[regtime_]]', NULL),
('qK\r', 'ksįCzf', 'CA-AB', 1, 1, '[[regtime_]]', NULL),
('qK', 'ksįCzf', 'CA-NL', 1, 1, '[[regtime_]]', NULL),
('qK\r', 'ksįCzf', 'CA-NT', 1, 1, '[[regtime_]]', NULL),
('qKR~', 'ksįCzf', 'CA-YT', 1, 1, '[[regtime_]]', NULL),
('qKh', 'ksįCzf', 'CA-NU', 1, 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `country_state_translation`
--

CREATE TABLE `country_state_translation` (
  `country_state_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`country_state_id`,`language_id`),
  KEY `fk.country_state_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_state_translation`
--

INSERT INTO `country_state_translation` VALUES
('\npYJ', '\nQpppS:', 'Baden-Württemberg', NULL, '[[regtime_]]', NULL),
('\npYJ', '/_MpXT|', 'Baden-Württemberg', NULL, '[[regtime_]]', NULL),
('\0qT^qS', '\nQpppS:', 'Bayern', NULL, '[[regtime_]]', NULL),
('\0qT^qS', '/_MpXT|', 'Bavaria', NULL, '[[regtime_]]', NULL),
('qͦ:=:', '\nQpppS:', 'Berlin', NULL, '[[regtime_]]', NULL),
('qͦ:=:', '/_MpXT|', 'Berlin', NULL, '[[regtime_]]', NULL),
('rd̹', '\nQpppS:', 'Brandenburg', NULL, '[[regtime_]]', NULL),
('rd̹', '/_MpXT|', 'Brandenburg', NULL, '[[regtime_]]', NULL),
('qy{煿', '\nQpppS:', 'Bremen', NULL, '[[regtime_]]', NULL),
('qy{煿', '/_MpXT|', 'Bremen', NULL, '[[regtime_]]', NULL),
('&pӛ)UH''', '\nQpppS:', 'Hamburg', NULL, '[[regtime_]]', NULL),
('&pӛ)UH''', '/_MpXT|', 'Hamburg', NULL, '[[regtime_]]', NULL),
('/p0', '\nQpppS:', 'Hessen', NULL, '[[regtime_]]', NULL),
('/p0', '/_MpXT|', 'Hesse', NULL, '[[regtime_]]', NULL),
('7q%{*', '\nQpppS:', 'Niedersachsen', NULL, '[[regtime_]]', NULL),
('7q%{*', '/_MpXT|', 'Lower Saxony', NULL, '[[regtime_]]', NULL),
('Cr''%GP)', '\nQpppS:', 'Mecklenburg-Vorpommern', NULL, '[[regtime_]]', NULL),
('Cr''%GP)', '/_MpXT|', 'Mecklenburg-Western Pomerania', NULL, '[[regtime_]]', NULL),
('LsF@', '\nQpppS:', 'Nordrhein-Westfalen', NULL, '[[regtime_]]', NULL),
('LsF@', '/_MpXT|', 'North Rhine-Westphalia', NULL, '[[regtime_]]', NULL),
('WpH3FH3', '\nQpppS:', 'Rheinland-Pfalz', NULL, '[[regtime_]]', NULL),
('WpH3FH3', '/_MpXT|', 'Rhineland-Palatinate', NULL, '[[regtime_]]', NULL),
('`sӠn&-s', '\nQpppS:', 'Saarland', NULL, '[[regtime_]]', NULL),
('`sӠn&-s', '/_MpXT|', 'Saarland', NULL, '[[regtime_]]', NULL),
('is5\0g)k', '\nQpppS:', 'Sachsen', NULL, '[[regtime_]]', NULL),
('is5\0g)k', '/_MpXT|', 'Saxony', NULL, '[[regtime_]]', NULL),
('rs\nn', '\nQpppS:', 'Sachsen-Anhalt', NULL, '[[regtime_]]', NULL),
('rs\nn', '/_MpXT|', 'Saxony-Anhalt', NULL, '[[regtime_]]', NULL),
('{s{''nz', '\nQpppS:', 'Schleswig-Holstein', NULL, '[[regtime_]]', NULL),
('{s{''nz', '/_MpXT|', 'Schleswig-Holstein', NULL, '[[regtime_]]', NULL),
('pͨK', '\nQpppS:', 'Thüringen', NULL, '[[regtime_]]', NULL),
('pͨK', '/_MpXT|', 'Thuringia', NULL, '[[regtime_]]', NULL),
('sdo\0', '/_MpXT|', 'England', NULL, '[[regtime_]]', NULL),
('pv.b', '/_MpXT|', 'Northern Ireland', NULL, '[[regtime_]]', NULL),
('r', '/_MpXT|', 'Scotland', NULL, '[[regtime_]]', NULL),
('s$\rF}', '/_MpXT|', 'Wales', NULL, '[[regtime_]]', NULL),
('pN\0', '/_MpXT|', 'England and Wales', NULL, '[[regtime_]]', NULL),
('rxVFw', '/_MpXT|', 'Great Britain', NULL, '[[regtime_]]', NULL),
('rɩ3+m', '/_MpXT|', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('s94˿', '/_MpXT|', 'Buckinghamshire', NULL, '[[regtime_]]', NULL),
('p3 3S', '/_MpXT|', 'Cambridgeshire', NULL, '[[regtime_]]', NULL),
('sg[K*>', '/_MpXT|', 'Cumbria', NULL, '[[regtime_]]', NULL),
('pTM\n', '/_MpXT|', 'Derbyshire', NULL, '[[regtime_]]', NULL),
('pઙM-ԟH', '/_MpXT|', 'Devon', NULL, '[[regtime_]]', NULL),
('sy%', '/_MpXT|', 'Dorset', NULL, '[[regtime_]]', NULL),
('p5rΜlh', '/_MpXT|', 'East Sussex', NULL, '[[regtime_]]', NULL),
('q܉l', '/_MpXT|', 'Essex', NULL, '[[regtime_]]', NULL),
('pǶ&O|s', '/_MpXT|', 'Gloucestershire', NULL, '[[regtime_]]', NULL),
('r:?C=', '/_MpXT|', 'Hampshire', NULL, '[[regtime_]]', NULL),
(' r	Thf', '/_MpXT|', 'Hertfordshire', NULL, '[[regtime_]]', NULL),
('&qy\nl4o', '/_MpXT|', 'Kent', NULL, '[[regtime_]]', NULL),
(',qev?hIzQ', '/_MpXT|', 'Lancashire', NULL, '[[regtime_]]', NULL),
('1p', '/_MpXT|', 'Leicestershire', NULL, '[[regtime_]]', NULL),
('7qxHݑ', '/_MpXT|', 'Lincolnshire', NULL, '[[regtime_]]', NULL),
('=r[Z0*w', '/_MpXT|', 'Norfolk', NULL, '[[regtime_]]', NULL),
('Cr܈', '/_MpXT|', 'North Yorkshire', NULL, '[[regtime_]]', NULL),
('Is%}', '/_MpXT|', 'Northamptonshire', NULL, '[[regtime_]]', NULL),
('OsQ	ju\\|', '/_MpXT|', 'Nottinghamshire', NULL, '[[regtime_]]', NULL),
('UrSu|O', '/_MpXT|', 'Oxfordshire', NULL, '[[regtime_]]', NULL),
('[p5T\r', '/_MpXT|', 'Somerset', NULL, '[[regtime_]]', NULL),
('`suɦ{', '/_MpXT|', 'Staffordshire', NULL, '[[regtime_]]', NULL),
('fq6+w', '/_MpXT|', 'Suffolk', NULL, '[[regtime_]]', NULL),
('lsb,c', '/_MpXT|', 'Surrey', NULL, '[[regtime_]]', NULL),
('rs*7#n?t', '/_MpXT|', 'Warwickshire', NULL, '[[regtime_]]', NULL),
('xp@[#', '/_MpXT|', 'West Sussex', NULL, '[[regtime_]]', NULL),
('sބ|x', '/_MpXT|', 'Worcestershire', NULL, '[[regtime_]]', NULL),
('riT', '/_MpXT|', 'London, City of', NULL, '[[regtime_]]', NULL),
('qJ\nv', '/_MpXT|', 'Barking and Dagenham', NULL, '[[regtime_]]', NULL),
('qM', '/_MpXT|', 'Barnet', NULL, '[[regtime_]]', NULL),
('qu5ia', '/_MpXT|', 'Bexley', NULL, '[[regtime_]]', NULL),
('q.', '/_MpXT|', 'Brent', NULL, '[[regtime_]]', NULL),
('rͰѰt', '/_MpXT|', 'Bromley', NULL, '[[regtime_]]', NULL),
('rZHM徎H', '/_MpXT|', 'Camden', NULL, '[[regtime_]]', NULL),
('rzۗ', '/_MpXT|', 'Croydon', NULL, '[[regtime_]]', NULL),
('q̤4=', '/_MpXT|', 'Ealing', NULL, '[[regtime_]]', NULL),
('r@_חR', '/_MpXT|', 'Enfield', NULL, '[[regtime_]]', NULL),
('pz\\20', '/_MpXT|', 'Greenwich', NULL, '[[regtime_]]', NULL),
('r\\4', '/_MpXT|', 'Hackney', NULL, '[[regtime_]]', NULL),
('p#MgC', '/_MpXT|', 'Hammersmith and Fulham', NULL, '[[regtime_]]', NULL),
('qCGE*^o', '/_MpXT|', 'Haringey', NULL, '[[regtime_]]', NULL),
('ptSØ', '/_MpXT|', 'Harrow', NULL, '[[regtime_]]', NULL),
('q;dql2', '/_MpXT|', 'Havering', NULL, '[[regtime_]]', NULL),
('q\nfd', '/_MpXT|', 'Hillingdon', NULL, '[[regtime_]]', NULL),
('sw', '/_MpXT|', 'Hounslow', NULL, '[[regtime_]]', NULL),
('s{~!T+', '/_MpXT|', 'Islington', NULL, '[[regtime_]]', NULL),
('rz0', '/_MpXT|', 'Kensington and Chelsea', NULL, '[[regtime_]]', NULL),
('\rsїӳx', '/_MpXT|', 'Kingston upon Thames', NULL, '[[regtime_]]', NULL),
('\rq꽞ש@&>', '/_MpXT|', 'Lambeth', NULL, '[[regtime_]]', NULL),
('\rr>.и', '/_MpXT|', 'Lewisham', NULL, '[[regtime_]]', NULL),
('\rrs-+', '/_MpXT|', 'Merton', NULL, '[[regtime_]]', NULL),
('\r\Zr\nxH2q', '/_MpXT|', 'Newham', NULL, '[[regtime_]]', NULL),
('\r sV͹<', '/_MpXT|', 'Redbridge', NULL, '[[regtime_]]', NULL),
('\r&rHS', '/_MpXT|', 'Richmond upon Thames', NULL, '[[regtime_]]', NULL),
('\r,qO', '/_MpXT|', 'Southwark', NULL, '[[regtime_]]', NULL),
('\r2s:Z(=', '/_MpXT|', 'Sutton', NULL, '[[regtime_]]', NULL),
('\r8p?}', '/_MpXT|', 'Tower Hamlets', NULL, '[[regtime_]]', NULL),
('\r>pӦCV ', '/_MpXT|', 'Waltham Forest', NULL, '[[regtime_]]', NULL),
('\rErE/', '/_MpXT|', 'Wandsworth', NULL, '[[regtime_]]', NULL),
('\rMp܎\\x', '/_MpXT|', 'Westminster', NULL, '[[regtime_]]', NULL),
('\rRp5\rj[', '/_MpXT|', 'Barnsley', NULL, '[[regtime_]]', NULL),
('\rXr=̈́M', '/_MpXT|', 'Birmingham', NULL, '[[regtime_]]', NULL),
('\r_r}ib', '/_MpXT|', 'Bolton', NULL, '[[regtime_]]', NULL),
('\resDqF̪', '/_MpXT|', 'Bradford', NULL, '[[regtime_]]', NULL),
('\rkq-', '/_MpXT|', 'Bury', NULL, '[[regtime_]]', NULL),
('\rqqM@5	{', '/_MpXT|', 'Calderdale', NULL, '[[regtime_]]', NULL),
('\rwp$󺍳X', '/_MpXT|', 'Coventry', NULL, '[[regtime_]]', NULL),
('\r}p', '/_MpXT|', 'Doncaster', NULL, '[[regtime_]]', NULL),
('\rp=qܦB', '/_MpXT|', 'Dudley', NULL, '[[regtime_]]', NULL),
('\rrȎWb', '/_MpXT|', 'Gateshead', NULL, '[[regtime_]]', NULL),
('\rp\Z8گ2', '/_MpXT|', 'Kirklees', NULL, '[[regtime_]]', NULL),
('\rp:s', '/_MpXT|', 'Knowsley', NULL, '[[regtime_]]', NULL),
('\rs	', '/_MpXT|', 'Leeds', NULL, '[[regtime_]]', NULL),
('\rrb\Z', '/_MpXT|', 'Liverpool', NULL, '[[regtime_]]', NULL),
('\rsϿ\nx', '/_MpXT|', 'Manchester', NULL, '[[regtime_]]', NULL),
('\rq[^}', '/_MpXT|', 'Newcastle upon Tyne', NULL, '[[regtime_]]', NULL),
('\rsL+I', '/_MpXT|', 'North Tyneside', NULL, '[[regtime_]]', NULL),
('\rrs', '/_MpXT|', 'Oldham', NULL, '[[regtime_]]', NULL),
('\rpƥB\ZG\Z.', '/_MpXT|', 'Rochdale', NULL, '[[regtime_]]', NULL),
('\rp,y^', '/_MpXT|', 'Rotherham', NULL, '[[regtime_]]', NULL),
('\rpլ%\\\Z', '/_MpXT|', 'St. Helens', NULL, '[[regtime_]]', NULL),
('\rp1W-)', '/_MpXT|', 'Salford', NULL, '[[regtime_]]', NULL),
('\rrR}{', '/_MpXT|', 'Sandwell', NULL, '[[regtime_]]', NULL),
('\rr\ne5T', '/_MpXT|', 'Sefton', NULL, '[[regtime_]]', NULL),
('\rqU\ZN赒', '/_MpXT|', 'Sheffield', NULL, '[[regtime_]]', NULL),
('\rp6M ', '/_MpXT|', 'Solihull', NULL, '[[regtime_]]', NULL),
('\rs̒6E', '/_MpXT|', 'South Tyneside', NULL, '[[regtime_]]', NULL),
('\rp0 gp', '/_MpXT|', 'Stockport', NULL, '[[regtime_]]', NULL),
('\0s', '/_MpXT|', 'Sunderland', NULL, '[[regtime_]]', NULL),
('\rsxd,e', '/_MpXT|', 'Tameside', NULL, '[[regtime_]]', NULL),
('`q|%Ct)', '/_MpXT|', 'Trafford', NULL, '[[regtime_]]', NULL),
('p\\^&r', '/_MpXT|', 'Wakefield', NULL, '[[regtime_]]', NULL),
('q+B', '/_MpXT|', 'Walsall', NULL, '[[regtime_]]', NULL),
('-qu<5\0', '/_MpXT|', 'Wigan', NULL, '[[regtime_]]', NULL),
('pW', '/_MpXT|', 'Wirral', NULL, '[[regtime_]]', NULL),
('s''-o2%', '/_MpXT|', 'Wolverhampton', NULL, '[[regtime_]]', NULL),
('^sg^`r', '/_MpXT|', 'Bath and North East Somerset', NULL, '[[regtime_]]', NULL),
('rqgF<', '/_MpXT|', 'Bedford', NULL, '[[regtime_]]', NULL),
('q{8,', '/_MpXT|', 'Blackburn with Darwen', NULL, '[[regtime_]]', NULL),
('r{{U', '/_MpXT|', 'Blackpool', NULL, '[[regtime_]]', NULL),
('''r5', '/_MpXT|', 'Bournemouth', NULL, '[[regtime_]]', NULL),
('Lq\rGA>]>', '/_MpXT|', 'Bracknell Forest', NULL, '[[regtime_]]', NULL),
('SqsIb!ޞ', '/_MpXT|', 'Brighton and Hove', NULL, '[[regtime_]]', NULL),
('Xso{]C	', '/_MpXT|', 'Bristol, City of', NULL, '[[regtime_]]', NULL),
('^sǒ', '/_MpXT|', 'Central Bedfordshire', NULL, '[[regtime_]]', NULL),
('dqGϞ>f', '/_MpXT|', 'Cheshire East', NULL, '[[regtime_]]', NULL),
('jqz8<', '/_MpXT|', 'Cheshire West and Chester', NULL, '[[regtime_]]', NULL),
('ps^J>', '/_MpXT|', 'Cornwall', NULL, '[[regtime_]]', NULL),
('urO\\aE%o', '/_MpXT|', 'Darlington', NULL, '[[regtime_]]', NULL),
('{s2	/ґ', '/_MpXT|', 'Derby', NULL, '[[regtime_]]', NULL),
('p56', '/_MpXT|', 'Durham County', NULL, '[[regtime_]]', NULL),
('r{', '/_MpXT|', 'East Riding of Yorkshire', NULL, '[[regtime_]]', NULL),
('p!݃Jm', '/_MpXT|', 'Halton', NULL, '[[regtime_]]', NULL),
('q,v', '/_MpXT|', 'Hartlepool', NULL, '[[regtime_]]', NULL),
('qۗ; FM', '/_MpXT|', 'Herefordshire', NULL, '[[regtime_]]', NULL),
('rA	ci', '/_MpXT|', 'Isle of Wight', NULL, '[[regtime_]]', NULL),
('sy7cp', '/_MpXT|', 'Isles of Scilly', NULL, '[[regtime_]]', NULL),
('pZQ', '/_MpXT|', 'Kingston upon Hull', NULL, '[[regtime_]]', NULL),
('rq2o', '/_MpXT|', 'Leicester', NULL, '[[regtime_]]', NULL),
('qv	o', '/_MpXT|', 'Luton', NULL, '[[regtime_]]', NULL),
('r Rh', '/_MpXT|', 'Medway', NULL, '[[regtime_]]', NULL),
('p"[S', '/_MpXT|', 'Middlesbrough', NULL, '[[regtime_]]', NULL),
('sK~', '/_MpXT|', 'Milton Keynes', NULL, '[[regtime_]]', NULL),
('r,Ep', '/_MpXT|', 'North East Lincolnshire', NULL, '[[regtime_]]', NULL),
('qׇCT', '/_MpXT|', 'North Lincolnshire', NULL, '[[regtime_]]', NULL),
('px՛%c0', '/_MpXT|', 'North Somerset', NULL, '[[regtime_]]', NULL),
('re', '/_MpXT|', 'Northumberland', NULL, '[[regtime_]]', NULL),
('r٩W2', '/_MpXT|', 'Nottingham', NULL, '[[regtime_]]', NULL),
('s{%ᓛ#', '/_MpXT|', 'Peterborough', NULL, '[[regtime_]]', NULL),
('s"bxn@', '/_MpXT|', 'Plymouth', NULL, '[[regtime_]]', NULL),
('r5})K7', '/_MpXT|', 'Poole', NULL, '[[regtime_]]', NULL),
('r07', '/_MpXT|', 'Portsmouth', NULL, '[[regtime_]]', NULL),
('	pRŽ5/', '/_MpXT|', 'Reading', NULL, '[[regtime_]]', NULL),
('#sD e', '/_MpXT|', 'Redcar and Cleveland', NULL, '[[regtime_]]', NULL),
(')rʷ\ZN问o', '/_MpXT|', 'Rutland', NULL, '[[regtime_]]', NULL),
('.p<#gK', '/_MpXT|', 'Shropshire', NULL, '[[regtime_]]', NULL),
('4q쇂v_', '/_MpXT|', 'Slough', NULL, '[[regtime_]]', NULL),
(';rEξ4', '/_MpXT|', 'South Gloucestershire', NULL, '[[regtime_]]', NULL),
('Apn*rL', '/_MpXT|', 'Southampton', NULL, '[[regtime_]]', NULL),
('Gsyb`', '/_MpXT|', 'Southend-on-Sea', NULL, '[[regtime_]]', NULL),
('MpxsU', '/_MpXT|', 'Stockton-on-Tees', NULL, '[[regtime_]]', NULL),
('SqRp', '/_MpXT|', 'Stoke-on-Trent', NULL, '[[regtime_]]', NULL),
('Ys_BHC', '/_MpXT|', 'Swindon', NULL, '[[regtime_]]', NULL),
('_sCtlŵ', '/_MpXT|', 'Telford and Wrekin', NULL, '[[regtime_]]', NULL),
('eqF֟3', '/_MpXT|', 'Thurrock', NULL, '[[regtime_]]', NULL),
('krM|VÒ3', '/_MpXT|', 'Torbay', NULL, '[[regtime_]]', NULL),
('qrjA@T', '/_MpXT|', 'Warrington', NULL, '[[regtime_]]', NULL),
('wsE\r̶>''0', '/_MpXT|', 'West Berkshire', NULL, '[[regtime_]]', NULL),
('}rz:', '/_MpXT|', 'Wiltshire', NULL, '[[regtime_]]', NULL),
('rRk\n', '/_MpXT|', 'Windsor and Maidenhead', NULL, '[[regtime_]]', NULL),
('r̸֋-', '/_MpXT|', 'Wokingham', NULL, '[[regtime_]]', NULL),
('s^eZfv?', '/_MpXT|', 'York', NULL, '[[regtime_]]', NULL),
('pǆ35SU', '/_MpXT|', 'Antrim and Newtownabbey', NULL, '[[regtime_]]', NULL),
('s\\,?', '/_MpXT|', 'Ards and North Down', NULL, '[[regtime_]]', NULL),
('qޖ^', '/_MpXT|', 'Armagh, Banbridge and Craigavon', NULL, '[[regtime_]]', NULL),
('qa{wR', '/_MpXT|', 'Belfast', NULL, '[[regtime_]]', NULL),
('p', '/_MpXT|', 'Causeway Coast and Glens', NULL, '[[regtime_]]', NULL),
('qz6(', '/_MpXT|', 'Derry and Strabane', NULL, '[[regtime_]]', NULL),
('qc+\0uX', '/_MpXT|', 'Fermanagh and Omagh', NULL, '[[regtime_]]', NULL),
('pX{', '/_MpXT|', 'Lisburn and Castlereagh', NULL, '[[regtime_]]', NULL),
('qi2', '/_MpXT|', 'Mid and East Antrim', NULL, '[[regtime_]]', NULL),
('pŘ3', '/_MpXT|', 'Mid Ulster', NULL, '[[regtime_]]', NULL),
('roGZJy', '/_MpXT|', 'Newry, Mourne and Down', NULL, '[[regtime_]]', NULL),
('rΓzΞi*', '/_MpXT|', 'Aberdeen City', NULL, '[[regtime_]]', NULL),
('r3Ī2@', '/_MpXT|', 'Aberdeenshire', NULL, '[[regtime_]]', NULL),
('q/fQ', '/_MpXT|', 'Angus', NULL, '[[regtime_]]', NULL),
('sˉD', '/_MpXT|', 'Argyll and Bute', NULL, '[[regtime_]]', NULL),
('syN{6', '/_MpXT|', 'Clackmannanshire', NULL, '[[regtime_]]', NULL),
('pgD"', '/_MpXT|', 'Dumfries and Galloway', NULL, '[[regtime_]]', NULL),
('q!w6o', '/_MpXT|', 'Dundee City', NULL, '[[regtime_]]', NULL),
('qY6>"', '/_MpXT|', 'East Ayrshire', NULL, '[[regtime_]]', NULL),
('rXC9', '/_MpXT|', 'East Dunbartonshire', NULL, '[[regtime_]]', NULL),
('rjG2z3', '/_MpXT|', 'East Lothian', NULL, '[[regtime_]]', NULL),
('rζ+', '/_MpXT|', 'East Renfrewshire', NULL, '[[regtime_]]', NULL),
('rޥhTZ', '/_MpXT|', 'Edinburgh, City of', NULL, '[[regtime_]]', NULL),
('%r{>e', '/_MpXT|', 'Eilean Siar', NULL, '[[regtime_]]', NULL),
('+pǁ~8A', '/_MpXT|', 'Falkirk', NULL, '[[regtime_]]', NULL),
('1sBO)"', '/_MpXT|', 'Fife', NULL, '[[regtime_]]', NULL),
('7rg%@"', '/_MpXT|', 'Glasgow City', NULL, '[[regtime_]]', NULL),
('=r)qw1', '/_MpXT|', 'Highland', NULL, '[[regtime_]]', NULL),
('Ds=ԍ-^', '/_MpXT|', 'Inverclyde', NULL, '[[regtime_]]', NULL),
('Ls{s', '/_MpXT|', 'Midlothian', NULL, '[[regtime_]]', NULL),
('QrÀge', '/_MpXT|', 'Moray', NULL, '[[regtime_]]', NULL),
('Wq8Y1', '/_MpXT|', 'North Ayrshire', NULL, '[[regtime_]]', NULL),
(']rċH', '/_MpXT|', 'North Lanarkshire', NULL, '[[regtime_]]', NULL),
('drJm@', '/_MpXT|', 'Orkney Islands', NULL, '[[regtime_]]', NULL),
('kp"ݏjE', '/_MpXT|', 'Perth and Kinross', NULL, '[[regtime_]]', NULL),
('rsȮ}Sɘ', '/_MpXT|', 'Renfrewshire', NULL, '[[regtime_]]', NULL),
('xqFHm', '/_MpXT|', 'Scottish Borders, The', NULL, '[[regtime_]]', NULL),
('s?TÑ', '/_MpXT|', 'Shetland Islands', NULL, '[[regtime_]]', NULL),
('sR\0ViI', '/_MpXT|', 'South Ayrshire', NULL, '[[regtime_]]', NULL),
('rq,', '/_MpXT|', 'South Lanarkshire', NULL, '[[regtime_]]', NULL),
('rXpcx', '/_MpXT|', 'Stirling', NULL, '[[regtime_]]', NULL),
('pf]1f', '/_MpXT|', 'West Dunbartonshire', NULL, '[[regtime_]]', NULL),
('s2CL', '/_MpXT|', 'West Lothian', NULL, '[[regtime_]]', NULL),
('sp9%', '/_MpXT|', 'Blaenau Gwent', NULL, '[[regtime_]]', NULL),
('so8A', '/_MpXT|', 'Bridgend', NULL, '[[regtime_]]', NULL),
('r \n@Կ', '/_MpXT|', 'Caerphilly', NULL, '[[regtime_]]', NULL),
('rL3L', '/_MpXT|', 'Cardiff', NULL, '[[regtime_]]', NULL),
('q@X0%E', '/_MpXT|', 'Carmarthenshire', NULL, '[[regtime_]]', NULL),
('pOa2N', '/_MpXT|', 'Ceredigion', NULL, '[[regtime_]]', NULL),
('szDNO\Z', '/_MpXT|', 'Conwy', NULL, '[[regtime_]]', NULL),
('pG.P]', '/_MpXT|', 'Denbighshire', NULL, '[[regtime_]]', NULL),
('p', '/_MpXT|', 'Flintshire', NULL, '[[regtime_]]', NULL),
('qAo;5', '/_MpXT|', 'Gwynedd', NULL, '[[regtime_]]', NULL),
('s-\r߼', '/_MpXT|', 'Isle of Anglesey', NULL, '[[regtime_]]', NULL),
('q1k\r', '/_MpXT|', 'Merthyr Tydfil', NULL, '[[regtime_]]', NULL),
('	sd:ၡq', '/_MpXT|', 'Monmouthshire', NULL, '[[regtime_]]', NULL),
('sĻ3Q', '/_MpXT|', 'Neath Port Talbot', NULL, '[[regtime_]]', NULL),
('qV', '/_MpXT|', 'Newport', NULL, '[[regtime_]]', NULL),
('pڟ9J', '/_MpXT|', 'Pembrokeshire', NULL, '[[regtime_]]', NULL),
('#sjb', '/_MpXT|', 'Powys', NULL, '[[regtime_]]', NULL),
(')q*1ͻ^', '/_MpXT|', 'Rhondda, Cynon, Taff', NULL, '[[regtime_]]', NULL),
('/r\\', '/_MpXT|', 'Swansea', NULL, '[[regtime_]]', NULL),
('5p_[o', '/_MpXT|', 'Torfaen', NULL, '[[regtime_]]', NULL),
(';p2\0IM', '/_MpXT|', 'Vale of Glamorgan, The', NULL, '[[regtime_]]', NULL),
('Ap˹@B`x', '/_MpXT|', 'Wrexham', NULL, '[[regtime_]]', NULL),
('q''q&', '/_MpXT|', 'Alabama', NULL, '[[regtime_]]', NULL),
('s]Y', '/_MpXT|', 'Alaska', NULL, '[[regtime_]]', NULL),
('s"~Z', '/_MpXT|', 'Arizona', NULL, '[[regtime_]]', NULL),
('pJ@(', '/_MpXT|', 'Arkansas', NULL, '[[regtime_]]', NULL),
('pʋ.cj', '/_MpXT|', 'California', NULL, '[[regtime_]]', NULL),
('q4Aog', '/_MpXT|', 'Colorado', NULL, '[[regtime_]]', NULL),
('q9=(Wr', '/_MpXT|', 'Connecticut', NULL, '[[regtime_]]', NULL),
('r6\Z5', '/_MpXT|', 'Delaware', NULL, '[[regtime_]]', NULL),
('qyj3', '/_MpXT|', 'Florida', NULL, '[[regtime_]]', NULL),
('pfxr', '/_MpXT|', 'Georgia', NULL, '[[regtime_]]', NULL),
('rJ]\r', '/_MpXT|', 'Hawaii', NULL, '[[regtime_]]', NULL),
('sЯ''?4', '/_MpXT|', 'Idaho', NULL, '[[regtime_]]', NULL),
('\Zpr "{', '/_MpXT|', 'Illinois', NULL, '[[regtime_]]', NULL),
(' rBZ)pZVv', '/_MpXT|', 'Indiana', NULL, '[[regtime_]]', NULL),
('&p8tg', '/_MpXT|', 'Iowa', NULL, '[[regtime_]]', NULL),
(',p7ʻ', '/_MpXT|', 'Kansas', NULL, '[[regtime_]]', NULL),
('2p>', '/_MpXT|', 'Kentucky', NULL, '[[regtime_]]', NULL),
('8r\r\\v''', '/_MpXT|', 'Louisiana', NULL, '[[regtime_]]', NULL),
('@q5]H', '/_MpXT|', 'Maine', NULL, '[[regtime_]]', NULL),
('Fp C', '/_MpXT|', 'Maryland', NULL, '[[regtime_]]', NULL),
('LqA"ǆ7"', '/_MpXT|', 'Massachusetts', NULL, '[[regtime_]]', NULL),
('Rp5F%q:', '/_MpXT|', 'Michigan', NULL, '[[regtime_]]', NULL),
('Xp*M', '/_MpXT|', 'Minnesota', NULL, '[[regtime_]]', NULL),
('^rů+b\0', '/_MpXT|', 'Mississippi', NULL, '[[regtime_]]', NULL),
('cpı$щ', '/_MpXT|', 'Missouri', NULL, '[[regtime_]]', NULL),
('is\n`-', '/_MpXT|', 'Montana', NULL, '[[regtime_]]', NULL),
('oq3%֩', '/_MpXT|', 'Nebraska', NULL, '[[regtime_]]', NULL),
('us2Iv/a', '/_MpXT|', 'Nevada', NULL, '[[regtime_]]', NULL),
('{p@Ii', '/_MpXT|', 'New Hampshire', NULL, '[[regtime_]]', NULL),
('q>q3', '/_MpXT|', 'New Jersey', NULL, '[[regtime_]]', NULL),
('s:,dV', '/_MpXT|', 'New Mexico', NULL, '[[regtime_]]', NULL),
('p$F]', '/_MpXT|', 'New York', NULL, '[[regtime_]]', NULL),
('r^^39', '/_MpXT|', 'North Carolina', NULL, '[[regtime_]]', NULL),
('p0s\n', '/_MpXT|', 'North Dakota', NULL, '[[regtime_]]', NULL),
('rۃsU', '/_MpXT|', 'Ohio', NULL, '[[regtime_]]', NULL),
('p]0', '/_MpXT|', 'Oklahoma', NULL, '[[regtime_]]', NULL),
('pPԕ0', '/_MpXT|', 'Oregon', NULL, '[[regtime_]]', NULL),
('rXx', '/_MpXT|', 'Pennsylvania', NULL, '[[regtime_]]', NULL),
('s|Jgl', '/_MpXT|', 'Rhode Island', NULL, '[[regtime_]]', NULL),
('r=?QrC', '/_MpXT|', 'South Carolina', NULL, '[[regtime_]]', NULL),
('q|L', '/_MpXT|', 'South Dakota', NULL, '[[regtime_]]', NULL),
('p''nľ', '/_MpXT|', 'Tennessee', NULL, '[[regtime_]]', NULL),
('pe+\ZL', '/_MpXT|', 'Texas', NULL, '[[regtime_]]', NULL),
('rUzt8', '/_MpXT|', 'Utah', NULL, '[[regtime_]]', NULL),
('rra', '/_MpXT|', 'Vermont', NULL, '[[regtime_]]', NULL),
('sM\\m', '/_MpXT|', 'Virginia', NULL, '[[regtime_]]', NULL),
('q"	Z', '/_MpXT|', 'Washington', NULL, '[[regtime_]]', NULL),
('sƗ@90', '/_MpXT|', 'West Virginia', NULL, '[[regtime_]]', NULL),
('p#6', '/_MpXT|', 'Wisconsin', NULL, '[[regtime_]]', NULL),
('px', '/_MpXT|', 'Wyoming', NULL, '[[regtime_]]', NULL),
('sl', '/_MpXT|', 'District of Columbia', NULL, '[[regtime_]]', NULL),
('qK{t', '\nQpppS:', 'Ontario', NULL, '[[regtime_]]', NULL),
('qK{t', '/_MpXT|', 'Ontario', NULL, '[[regtime_]]', NULL),
('qK', '\nQpppS:', 'Québec', NULL, '[[regtime_]]', NULL),
('qK', '/_MpXT|', 'Quebec', NULL, '[[regtime_]]', NULL),
('qKik', '\nQpppS:', 'Nova Scotia', NULL, '[[regtime_]]', NULL),
('qKik', '/_MpXT|', 'Nova Scotia', NULL, '[[regtime_]]', NULL),
('qK)s', '\nQpppS:', 'New Brunswick', NULL, '[[regtime_]]', NULL),
('qK)s', '/_MpXT|', 'New Brunswick', NULL, '[[regtime_]]', NULL),
('qK9', '\nQpppS:', 'Manitoba', NULL, '[[regtime_]]', NULL),
('qK9', '/_MpXT|', 'Manitoba', NULL, '[[regtime_]]', NULL),
('qK\n', '\nQpppS:', 'British Columbia', NULL, '[[regtime_]]', NULL),
('qK\n', '/_MpXT|', 'British Columbia', NULL, '[[regtime_]]', NULL),
('qK', '\nQpppS:', 'Prince Edward Island', NULL, '[[regtime_]]', NULL),
('qK', '/_MpXT|', 'Prince Edward Island', NULL, '[[regtime_]]', NULL),
('qK', '\nQpppS:', 'Saskatchewan', NULL, '[[regtime_]]', NULL),
('qK', '/_MpXT|', 'Saskatchewan', NULL, '[[regtime_]]', NULL),
('qK\r', '\nQpppS:', 'Alberta', NULL, '[[regtime_]]', NULL),
('qK\r', '/_MpXT|', 'Alberta', NULL, '[[regtime_]]', NULL),
('qK', '\nQpppS:', 'Neufundland und Labrador', NULL, '[[regtime_]]', NULL),
('qK', '/_MpXT|', 'Newfoundland and Labrador', NULL, '[[regtime_]]', NULL),
('qK\r', '\nQpppS:', 'Nordwest-Territorien', NULL, '[[regtime_]]', NULL),
('qK\r', '/_MpXT|', 'Northwest Territories', NULL, '[[regtime_]]', NULL),
('qKR~', '\nQpppS:', 'Yukon', NULL, '[[regtime_]]', NULL),
('qKR~', '/_MpXT|', 'Yukon', NULL, '[[regtime_]]', NULL),
('qKh', '\nQpppS:', 'Nunavut', NULL, '[[regtime_]]', NULL),
('qKh', '/_MpXT|', 'Nunavut', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `country_translation`
--

CREATE TABLE `country_translation` (
  `country_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_format` json DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`country_id`,`language_id`),
  KEY `fk.country_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_translation`
--

INSERT INTO `country_translation` VALUES
('\nq!$', '\nQpppS:', 'Deutschland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\nq!$', '/_MpXT|', 'Germany', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ptǪ+', '\nQpppS:', 'Griechenland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ptǪ+', '/_MpXT|', 'Greece', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qo''n/|}', '\nQpppS:', 'Vereinigtes Königreich', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qo''n/|}', '/_MpXT|', 'United Kingdom', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Gp?_V6\nT', '\nQpppS:', 'Irland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Gp?_V6\nT', '/_MpXT|', 'Ireland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Pq*', '\nQpppS:', 'Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Pq*', '/_MpXT|', 'Iceland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Ypε5(}', '\nQpppS:', 'Italien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Ypε5(}', '/_MpXT|', 'Italy', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bqnLAE', '\nQpppS:', 'Japan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bqnLAE', '/_MpXT|', 'Japan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ksįCzf', '\nQpppS:', 'Kanada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ksįCzf', '/_MpXT|', 'Canada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ws\Z~fR', '\nQpppS:', 'Luxemburg', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ws\Z~fR', '/_MpXT|', 'Luxembourg', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('py_', '\nQpppS:', 'Namibia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('py_', '/_MpXT|', 'Namibia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qU''2', '\nQpppS:', 'Niederlande', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qU''2', '/_MpXT|', 'Netherlands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sN2E', '\nQpppS:', 'Norwegen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sN2E', '/_MpXT|', 'Norway', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sؔYaV', '\nQpppS:', 'Österreich', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sؔYaV', '/_MpXT|', 'Austria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rIo', '\nQpppS:', 'Portugal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rIo', '/_MpXT|', 'Portugal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q@>=S6/', '\nQpppS:', 'Schweden', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q@>=S6/', '/_MpXT|', 'Sweden', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pҜ8N3X', '\nQpppS:', 'Schweiz', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pҜ8N3X', '/_MpXT|', 'Switzerland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pS1z', '\nQpppS:', 'Spanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pS1z', '/_MpXT|', 'Spain', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rƄ4ڒ', '\nQpppS:', 'Vereinigte Staaten von Amerika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('rƄ4ڒ', '/_MpXT|', 'United States of America', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('q~<7\Z', '\nQpppS:', 'Liechtenstein', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q~<7\Z', '/_MpXT|', 'Liechtenstein', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r;~Fu', '\nQpppS:', 'Arabische Emirate', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r;~Fu', '/_MpXT|', 'Arab Emirates', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qTl#\r+', '\nQpppS:', 'Polen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qTl#\r+', '/_MpXT|', 'Poland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('&r#', '\nQpppS:', 'Ungarn', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('&r#', '/_MpXT|', 'Hungary', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('/peu\0Kf', '\nQpppS:', 'Türkei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('/peu\0Kf', '/_MpXT|', 'Turkey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('8sopv', '\nQpppS:', 'Tschechische Republik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('8sopv', '/_MpXT|', 'Czech Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Aqp', '\nQpppS:', 'Slowakei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('Aqp', '/_MpXT|', 'Slovakia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('Js}{K @', '\nQpppS:', 'Rumänien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Js}{K @', '/_MpXT|', 'Romania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('RsĒߨ\\', '\nQpppS:', 'Brasilien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('RsĒߨ\\', '/_MpXT|', 'Brazil', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\rϋp[W', '\nQpppS:', 'Israel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\rϋp[W', '/_MpXT|', 'Israel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('eq`''', '\nQpppS:', 'Australien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('eq`''', '/_MpXT|', 'Australia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qpPt#d', '\nQpppS:', 'Belgien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qpPt#d', '/_MpXT|', 'Belgium', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('zqdOFo', '\nQpppS:', 'Dänemark', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('zqdOFo', '/_MpXT|', 'Denmark', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sߡ2pޓ', '\nQpppS:', 'Finnland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sߡ2pޓ', '/_MpXT|', 'Finland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qpIM7', '\nQpppS:', 'Frankreich', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qpIM7', '/_MpXT|', 'France', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\r3(i!+', '\nQpppS:', 'Bulgarien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\r3(i!+', '/_MpXT|', 'Bulgaria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\q$ww', '\nQpppS:', 'Estland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\q$ww', '/_MpXT|', 'Estonia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\pߩv2Z', '\nQpppS:', 'Kroatien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\pߩv2Z', '/_MpXT|', 'Croatia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\sئ&~', '\nQpppS:', 'Lettland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\sئ&~', '/_MpXT|', 'Latvia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\q޶%y,?', '\nQpppS:', 'Litauen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\q޶%y,?', '/_MpXT|', 'Lithuania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\re۫mQ', '\nQpppS:', 'Malta', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\re۫mQ', '/_MpXT|', 'Malta', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\q7(;', '\nQpppS:', 'Slowenien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\q7(;', '/_MpXT|', 'Slovenia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\s@Ci@', '\nQpppS:', 'Zypern', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\s@Ci@', '/_MpXT|', 'Cyprus', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\qnQW>', '\nQpppS:', 'Afghanistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\qnQW>', '/_MpXT|', 'Afghanistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\rW', '\nQpppS:', 'Åland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\rW', '/_MpXT|', 'Åland Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\p" ', '\nQpppS:', 'Albanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\p" ', '/_MpXT|', 'Albania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\s,-', '\nQpppS:', 'Algerien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\s,-', '/_MpXT|', 'Algeria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']	q$H2', '\nQpppS:', 'Amerikanisch-Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']	q$H2', '/_MpXT|', 'American Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']p+aUV', '\nQpppS:', 'Andorra', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']p+aUV', '/_MpXT|', 'Andorra', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']sڇ8j ', '\nQpppS:', 'Angola', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']sڇ8j ', '/_MpXT|', 'Angola', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']$qa`\r.', '\nQpppS:', 'Anguilla', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']$qa`\r.', '/_MpXT|', 'Anguilla', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']-qְNV:', '\nQpppS:', 'Antarktika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']-qְNV:', '/_MpXT|', 'Antarctica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']6q<SK"', '\nQpppS:', 'Antigua und Barbuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']6q<SK"', '/_MpXT|', 'Antigua and Barbuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']>pi[cQ', '\nQpppS:', 'Argentinien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']>pi[cQ', '/_MpXT|', 'Argentina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']Hpz', '\nQpppS:', 'Armenien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']Hpz', '/_MpXT|', 'Armenia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']QqG<^{', '\nQpppS:', 'Aruba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']QqG<^{', '/_MpXT|', 'Aruba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('][pP''B', '\nQpppS:', 'Aserbaidschan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('][pP''B', '/_MpXT|', 'Azerbaijan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']epڏoB', '\nQpppS:', 'Bahamas', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']epڏoB', '/_MpXT|', 'Bahamas', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']npdp', '\nQpppS:', 'Bahrain', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']npdp', '/_MpXT|', 'Bahrain', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']wpsl\r0', '\nQpppS:', 'Bangladesch', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']wpsl\r0', '/_MpXT|', 'Bangladesh', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']pՋ$L9', '\nQpppS:', 'Barbados', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']pՋ$L9', '/_MpXT|', 'Barbados', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']rcJ4̊^', '\nQpppS:', 'Weißrussland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']rcJ4̊^', '/_MpXT|', 'Belarus', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']s@!]C', '\nQpppS:', 'Belize', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']s@!]C', '/_MpXT|', 'Belize', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']p', '\nQpppS:', 'Benin', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']p', '/_MpXT|', 'Benin', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']p8rQd', '\nQpppS:', 'Bermuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']p8rQd', '/_MpXT|', 'Bermuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']rJ,''\r)"', '\nQpppS:', 'Bhutan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']rJ,''\r)"', '/_MpXT|', 'Bhutan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']p滞&l/S', '\nQpppS:', 'Bolivien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']p滞&l/S', '/_MpXT|', 'Bolivia (Plurinational State of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']rިNw.֔p', '\nQpppS:', 'Bonaire, Sint Eustatius und Saba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']rިNw.֔p', '/_MpXT|', 'Bonaire, Sint Eustatius and Saba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']qeo[rM', '\nQpppS:', 'Bosnien und Herzegowina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']qeo[rM', '/_MpXT|', 'Bosnia and Herzegovina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']s/L~O', '\nQpppS:', 'Botswana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']s/L~O', '/_MpXT|', 'Botswana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']qMчg', '\nQpppS:', 'Bouvetinsel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']qMчg', '/_MpXT|', 'Bouvet Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']qNB_', '\nQpppS:', 'Britisches Territorium im Indischen Ozean', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(']qNB_', '/_MpXT|', 'British Indian Ocean Territory', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^qnt4-', '\nQpppS:', 'Kleinere Inselbesitzungen der Vereinigten Staaten', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^qnt4-', '/_MpXT|', 'United States Minor Outlying Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^/pKQD', '\nQpppS:', 'Britische Jungferninseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^/pKQD', '/_MpXT|', 'Virgin Islands (British)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^Dq檧''U"', '\nQpppS:', 'Amerikanische Jungferninseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^Dq檧''U"', '/_MpXT|', 'Virgin Islands (U.S.)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^Uqo*G', '\nQpppS:', 'Brunei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^Uqo*G', '/_MpXT|', 'Brunei Darussalam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^jsB@NΑ', '\nQpppS:', 'Burkina Faso', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^jsB@NΑ', '/_MpXT|', 'Burkina Faso', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^rր#U&?', '\nQpppS:', 'Burundi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^rր#U&?', '/_MpXT|', 'Burundi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^pG]W\r', '\nQpppS:', 'Kambodscha', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^pG]W\r', '/_MpXT|', 'Cambodia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^q.8p', '\nQpppS:', 'Kamerun', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^q.8p', '/_MpXT|', 'Cameroon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^sڡ,''f', '\nQpppS:', 'Kap Verde', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^sڡ,''f', '/_MpXT|', 'Cabo Verde', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^r^іc,', '\nQpppS:', 'Kaimaninseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^r^іc,', '/_MpXT|', 'Cayman Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^pzh7\rS', '\nQpppS:', 'Zentralafrikanische Republik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^pzh7\rS', '/_MpXT|', 'Central African Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^pujK+', '\nQpppS:', 'Tschad', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^pujK+', '/_MpXT|', 'Chad', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^p-*\Zr4', '\nQpppS:', 'Chile', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^p-*\Zr4', '/_MpXT|', 'Chile', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^sڼMl]	5', '\nQpppS:', 'China', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^sڼMl]	5', '/_MpXT|', 'China', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_qĒAu', '\nQpppS:', 'Weihnachtsinsel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_qĒAu', '/_MpXT|', 'Christmas Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_\rqdIo\0', '\nQpppS:', 'Kokosinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_\rqdIo\0', '/_MpXT|', 'Cocos (Keeling) Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_q\Z+', '\nQpppS:', 'Kolumbien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_q\Z+', '/_MpXT|', 'Colombia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_se\\\0', '\nQpppS:', 'Union der Komoren', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_se\\\0', '/_MpXT|', 'Comoros', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_(pqjA', '\nQpppS:', 'Kongo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_(pqjA', '/_MpXT|', 'Congo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL);
INSERT INTO `country_translation` VALUES
('_1rm=e', '\nQpppS:', 'Kongo (Dem. Rep.)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_1rm=e', '/_MpXT|', 'Congo (Democratic Republic of the)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_:sÏ%Pd', '\nQpppS:', 'Cookinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_:sÏ%Pd', '/_MpXT|', 'Cook Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_Cpn8l', '\nQpppS:', 'Costa Rica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_Cpn8l', '/_MpXT|', 'Costa Rica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_MqΣxa', '\nQpppS:', 'Kuba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_MqΣxa', '/_MpXT|', 'Cuba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_XsY', '\nQpppS:', 'Curaçao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_XsY', '/_MpXT|', 'Curaçao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_`q2c&	<', '\nQpppS:', 'Dschibuti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_`q2c&	<', '/_MpXT|', 'Djibouti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_ipO', '\nQpppS:', 'Dominica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_ipO', '/_MpXT|', 'Dominica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_rrtiU', '\nQpppS:', 'Dominikanische Republik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_rrtiU', '/_MpXT|', 'Dominican Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_|poY', '\nQpppS:', 'Ecuador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_|poY', '/_MpXT|', 'Ecuador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_pتz_z', '\nQpppS:', 'Ägypten', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_pتz_z', '/_MpXT|', 'Egypt', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_r0]V', '\nQpppS:', 'El Salvador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_r0]V', '/_MpXT|', 'El Salvador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_r˘ ll', '\nQpppS:', 'Äquatorial-Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_r˘ ll', '/_MpXT|', 'Equatorial Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_pTZ#}=', '\nQpppS:', 'Eritrea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_pTZ#}=', '/_MpXT|', 'Eritrea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_s\Zr)r4O', '\nQpppS:', 'Äthiopien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_s\Zr)r4O', '/_MpXT|', 'Ethiopia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_pi', '\nQpppS:', 'Falklandinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_pi', '/_MpXT|', 'Falkland Islands (Malvinas)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_s6q3', '\nQpppS:', 'Färöer-Inseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_s6q3', '/_MpXT|', 'Faroe Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_sv9', '\nQpppS:', 'Fidschi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_sv9', '/_MpXT|', 'Fiji', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_r8J', '\nQpppS:', 'Französisch Guyana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_r8J', '/_MpXT|', 'French Guiana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_sMl-O	', '\nQpppS:', 'Französisch-Polynesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_sMl-O	', '/_MpXT|', 'French Polynesia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_sNw', '\nQpppS:', 'Französische Süd- und Antarktisgebiete', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_sNw', '/_MpXT|', 'French Southern Territories', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_p:=Q`=_', '\nQpppS:', 'Gabun', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_p:=Q`=_', '/_MpXT|', 'Gabon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_pK1T$<', '\nQpppS:', 'Gambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('_pK1T$<', '/_MpXT|', 'Gambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`pz''?7\Z', '\nQpppS:', 'Georgien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`pz''?7\Z', '/_MpXT|', 'Georgia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`\nr[$', '\nQpppS:', 'Ghana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`\nr[$', '/_MpXT|', 'Ghana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`rq8-<', '\nQpppS:', 'Gibraltar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`rq8-<', '/_MpXT|', 'Gibraltar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`r%', '\nQpppS:', 'Grönland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`r%', '/_MpXT|', 'Greenland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`)qz%w', '\nQpppS:', 'Grenada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`)qz%w', '/_MpXT|', 'Grenada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`2qƘ7;l', '\nQpppS:', 'Guadeloupe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`2qƘ7;l', '/_MpXT|', 'Guadeloupe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`;pP8	N', '\nQpppS:', 'Guam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`;pP8	N', '/_MpXT|', 'Guam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`Ds=$ȿ|', '\nQpppS:', 'Guatemala', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`Ds=$ȿ|', '/_MpXT|', 'Guatemala', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`MrlC؂', '\nQpppS:', 'Guernsey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`MrlC؂', '/_MpXT|', 'Guernsey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`VpK{', '\nQpppS:', 'Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`VpK{', '/_MpXT|', 'Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('``s_QZ;"', '\nQpppS:', 'Guinea-Bissau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('``s_QZ;"', '/_MpXT|', 'Guinea-Bissau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`iq]g3c*', '\nQpppS:', 'Guyana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`iq]g3c*', '/_MpXT|', 'Guyana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`rs47~:4', '\nQpppS:', 'Haiti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`rs47~:4', '/_MpXT|', 'Haiti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`|rDgJO', '\nQpppS:', 'Heard und die McDonaldinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`|rDgJO', '/_MpXT|', 'Heard Island and McDonald Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`r쫱|', '\nQpppS:', 'Staat Vatikanstadt', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`r쫱|', '/_MpXT|', 'Vatican City', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`svU>', '\nQpppS:', 'Honduras', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`svU>', '/_MpXT|', 'Honduras', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`qГ;\0', '\nQpppS:', 'Hong Kong', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`qГ;\0', '/_MpXT|', 'Hong Kong', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`qܱ: ', '\nQpppS:', 'Indien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`qܱ: ', '/_MpXT|', 'India', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`p\rW', '\nQpppS:', 'Indonesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`p\rW', '/_MpXT|', 'Indonesia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`sϐs', '\nQpppS:', 'Elfenbeinküste', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`sϐs', '/_MpXT|', 'Côte d''Ivoire', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`sUy^sa', '\nQpppS:', 'Iran', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`sUy^sa', '/_MpXT|', 'Iran (Islamic Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`qX؀Lh', '\nQpppS:', 'Irak', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`qX؀Lh', '/_MpXT|', 'Iraq', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`pЪHq \r', '\nQpppS:', 'Insel Man', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`pЪHq \r', '/_MpXT|', 'Isle of Man', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`px<', '\nQpppS:', 'Jamaika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`px<', '/_MpXT|', 'Jamaica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`sրkNZ', '\nQpppS:', 'Jersey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`sրkNZ', '/_MpXT|', 'Jersey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`pɠFؼ', '\nQpppS:', 'Jordanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`pɠFؼ', '/_MpXT|', 'Jordan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`sk[', '\nQpppS:', 'Kasachstan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('`sk[', '/_MpXT|', 'Kazakhstan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('apӂ\r~', '\nQpppS:', 'Kenia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('apӂ\r~', '/_MpXT|', 'Kenya', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('a\ns	?Gl\Z', '\nQpppS:', 'Kiribati', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('a\ns	?Gl\Z', '/_MpXT|', 'Kiribati', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('apdIr\n', '\nQpppS:', 'Kuwait', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('apdIr\n', '/_MpXT|', 'Kuwait', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ar}%', '\nQpppS:', 'Kirgisistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ar}%', '/_MpXT|', 'Kyrgyzstan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('a%pɭ|D($', '\nQpppS:', 'Laos', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('a%pɭ|D($', '/_MpXT|', 'Lao People''s Democratic Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('a.rvu9GgC', '\nQpppS:', 'Libanon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('a.rvu9GgC', '/_MpXT|', 'Lebanon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('a7r< MnHI', '\nQpppS:', 'Lesotho', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('a7r< MnHI', '/_MpXT|', 'Lesotho', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('a@sϼƚ|', '\nQpppS:', 'Liberia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('a@sϼƚ|', '/_MpXT|', 'Liberia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('aLsyy/ ', '\nQpppS:', 'Libyen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('aLsyy/ ', '/_MpXT|', 'Libya', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('aUq.,9', '\nQpppS:', 'Macao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('aUq.,9', '/_MpXT|', 'Macao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('a^p_H', '\nQpppS:', 'Mazedonien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('a^p_H', '/_MpXT|', 'Macedonia (the former Yugoslav Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ags%j', '\nQpppS:', 'Madagaskar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ags%j', '/_MpXT|', 'Madagascar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('apr/ooaK9', '\nQpppS:', 'Malawi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('apr/ooaK9', '/_MpXT|', 'Malawi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ayrƸTg!', '\nQpppS:', 'Malaysia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ayrƸTg!', '/_MpXT|', 'Malaysia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('asY\\Z', '\nQpppS:', 'Malediven', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('asY\\Z', '/_MpXT|', 'Maldives', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('as&s', '\nQpppS:', 'Mali', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('as&s', '/_MpXT|', 'Mali', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('asJ(,@\\p@', '\nQpppS:', 'Marshallinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('asJ(,@\\p@', '/_MpXT|', 'Marshall Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('arh<W\\', '\nQpppS:', 'Martinique', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('arh<W\\', '/_MpXT|', 'Martinique', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('aqǧm!1', '\nQpppS:', 'Mauretanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('aqǧm!1', '/_MpXT|', 'Mauritania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ap\0P;i', '\nQpppS:', 'Mauritius', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ap\0P;i', '/_MpXT|', 'Mauritius', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('aqJ', '\nQpppS:', 'Mayotte', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('aqJ', '/_MpXT|', 'Mayotte', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('arQ3/N', '\nQpppS:', 'Mexiko', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('arQ3/N', '/_MpXT|', 'Mexico', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('asX@az', '\nQpppS:', 'Mikronesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('asX@az', '/_MpXT|', 'Micronesia (Federated States of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('b\0rߠй', '\nQpppS:', 'Moldawie', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('b\0rߠй', '/_MpXT|', 'Moldova (Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('b&pŎGunG', '\nQpppS:', 'Monaco', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('b&pŎGunG', '/_MpXT|', 'Monaco', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('b<sy	UӞ', '\nQpppS:', 'Mongolei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('b<sy	UӞ', '/_MpXT|', 'Mongolia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bSq>!%', '\nQpppS:', 'Montenegro', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bSq>!%', '/_MpXT|', 'Montenegro', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bjrP2uD', '\nQpppS:', 'Montserrat', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bjrP2uD', '/_MpXT|', 'Montserrat', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('b~r', '\nQpppS:', 'Marokko', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('b~r', '/_MpXT|', 'Morocco', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bsTId', '\nQpppS:', 'Mosambik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bsTId', '/_MpXT|', 'Mozambique', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bqWN*', '\nQpppS:', 'Myanmar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bqWN*', '/_MpXT|', 'Myanmar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bs蘆O', '\nQpppS:', 'Nauru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bs蘆O', '/_MpXT|', 'Nauru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bqp;', '\nQpppS:', 'Népal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bqp;', '/_MpXT|', 'Nepal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('br|Ro', '\nQpppS:', 'Neukaledonien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('br|Ro', '/_MpXT|', 'New Caledonia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bqvY', '\nQpppS:', 'Neuseeland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bqvY', '/_MpXT|', 'New Zealand', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('brABIv:', '\nQpppS:', 'Nicaragua', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('brABIv:', '/_MpXT|', 'Nicaragua', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bsRĒ', '\nQpppS:', 'Niger', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bsRĒ', '/_MpXT|', 'Niger', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bpҲ%]', '\nQpppS:', 'Nigeria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bpҲ%]', '/_MpXT|', 'Nigeria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bsǇb:*k', '\nQpppS:', 'Niue', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('bsǇb:*k', '/_MpXT|', 'Niue', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('br*:E', '\nQpppS:', 'Norfolkinsel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('br*:E', '/_MpXT|', 'Norfolk Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('br;)Oo`&', '\nQpppS:', 'Nordkorea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL);
INSERT INTO `country_translation` VALUES
('br;)Oo`&', '/_MpXT|', 'Korea (Democratic People''s Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cp-', '\nQpppS:', 'Nördliche Marianen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cp-', '/_MpXT|', 'Northern Mariana Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cq?9|oУ', '\nQpppS:', 'Oman', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cq?9|oУ', '/_MpXT|', 'Oman', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cqZ', '\nQpppS:', 'Pakistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cqZ', '/_MpXT|', 'Pakistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('c$rp*\0ø', '\nQpppS:', 'Palau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('c$rp*\0ø', '/_MpXT|', 'Palau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('c-q:rųl7', '\nQpppS:', 'Palästina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('c-q:rųl7', '/_MpXT|', 'Palestine, State of', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('c5sgVGJ4', '\nQpppS:', 'Panama', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('c5sgVGJ4', '/_MpXT|', 'Panama', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cBpͻ\Z!', '\nQpppS:', 'Papua-Neuguinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cBpͻ\Z!', '/_MpXT|', 'Papua New Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cKq%yI', '\nQpppS:', 'Paraguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cKq%yI', '/_MpXT|', 'Paraguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cTq؂d\\a^', '\nQpppS:', 'Peru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cTq؂d\\a^', '/_MpXT|', 'Peru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('c]p2t5f1}', '\nQpppS:', 'Philippinen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('c]p2t5f1}', '/_MpXT|', 'Philippines', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cfr|t&''', '\nQpppS:', 'Pitcairn', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cfr|t&''', '/_MpXT|', 'Pitcairn', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('coqdP"<', '\nQpppS:', 'Puerto Rico', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('coqdP"<', '/_MpXT|', 'Puerto Rico', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cxqNؓQ5', '\nQpppS:', 'Katar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cxqNؓQ5', '/_MpXT|', 'Qatar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('csrʈ#}', '\nQpppS:', 'Republik Kosovo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('csrʈ#}', '/_MpXT|', 'Republic of Kosovo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cqeB7', '\nQpppS:', 'Réunion', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cqeB7', '/_MpXT|', 'Réunion', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cs[`', '\nQpppS:', 'Russland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cs[`', '/_MpXT|', 'Russian Federation', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cpHN	i', '\nQpppS:', 'Ruanda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cpHN	i', '/_MpXT|', 'Rwanda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('csR_>(', '\nQpppS:', 'Saint-Barthélemy', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('csR_>(', '/_MpXT|', 'Saint Barthélemy', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('crCJ3', '\nQpppS:', 'Sankt Helena', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('crCJ3', '/_MpXT|', 'Saint Helena, Ascension and Tristan da Cunha', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cq8TB{', '\nQpppS:', 'St. Kitts und Nevis', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cq8TB{', '/_MpXT|', 'Saint Kitts and Nevis', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cpKn"', '\nQpppS:', 'Saint Lucia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cpKn"', '/_MpXT|', 'Saint Lucia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cp(hX', '\nQpppS:', 'Saint Martin', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cp(hX', '/_MpXT|', 'Saint Martin (French part)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('crf\\a.Ov', '\nQpppS:', 'Saint-Pierre und Miquelon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('crf\\a.Ov', '/_MpXT|', 'Saint Pierre and Miquelon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cr0xA#Hv', '\nQpppS:', 'Saint Vincent und die Grenadinen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cr0xA#Hv', '/_MpXT|', 'Saint Vincent and the Grenadines', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('crp,u', '\nQpppS:', 'Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('crp,u', '/_MpXT|', 'Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cs֡<V', '\nQpppS:', 'San Marino', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cs֡<V', '/_MpXT|', 'San Marino', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cqN', '\nQpppS:', 'São Tomé und Príncipe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cqN', '/_MpXT|', 'Sao Tome and Principe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dpaJ''', '\nQpppS:', 'Saudi-Arabien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dpaJ''', '/_MpXT|', 'Saudi Arabia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dqCj;', '\nQpppS:', 'Senegal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dqCj;', '/_MpXT|', 'Senegal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dp)<3g[', '\nQpppS:', 'Serbien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dp)<3g[', '/_MpXT|', 'Serbia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d!sXΓ''', '\nQpppS:', 'Seychellen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d!sXΓ''', '/_MpXT|', 'Seychelles', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d*sF\Z2Td', '\nQpppS:', 'Sierra Leone', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d*sF\Z2Td', '/_MpXT|', 'Sierra Leone', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d3q{Ǌ3', '\nQpppS:', 'Singapur', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d3q{Ǌ3', '/_MpXT|', 'Singapore', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d<sD\rͿ', '\nQpppS:', 'Sint Maarten (niederl. Teil)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d<sD\rͿ', '/_MpXT|', 'Sint Maarten (Dutch part)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dEq4m,$eb', '\nQpppS:', 'Salomonen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dEq4m,$eb', '/_MpXT|', 'Solomon Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dMp3^N', '\nQpppS:', 'Somalia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dMp3^N', '/_MpXT|', 'Somalia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dWpͶyOZ', '\nQpppS:', 'Republik Südafrika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dWpͶyOZ', '/_MpXT|', 'South Africa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d`p(nP9N+', '\nQpppS:', 'Südgeorgien und die Südlichen Sandwichinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d`p(nP9N+', '/_MpXT|', 'South Georgia and the South Sandwich Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dsp9̹{', '\nQpppS:', 'Südkorea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dsp9̹{', '/_MpXT|', 'Korea (Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d{rنᰑH', '\nQpppS:', 'Südsudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d{rنᰑH', '/_MpXT|', 'South Sudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dsT`&U0P', '\nQpppS:', 'Sri Lanka', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dsT`&U0P', '/_MpXT|', 'Sri Lanka', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dpܻA)', '\nQpppS:', 'Sudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dpܻA)', '/_MpXT|', 'Sudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dp$;', '\nQpppS:', 'Suriname', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dp$;', '/_MpXT|', 'Suriname', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dsm^', '\nQpppS:', 'Svalbard und Jan Mayen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dsm^', '/_MpXT|', 'Svalbard and Jan Mayen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dsUߏ37', '\nQpppS:', 'Swasiland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dsUߏ37', '/_MpXT|', 'Swaziland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dq^91I', '\nQpppS:', 'Syrien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dq^91I', '/_MpXT|', 'Syrian Arab Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ds`HF,', '\nQpppS:', 'Taiwan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ds`HF,', '/_MpXT|', 'Taiwan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dsނטo', '\nQpppS:', 'Tadschikistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dsނטo', '/_MpXT|', 'Tajikistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dsࣈܨs', '\nQpppS:', 'Tansania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dsࣈܨs', '/_MpXT|', 'Tanzania, United Republic of', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dpQwZ}Dj', '\nQpppS:', 'Thailand', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dpQwZ}Dj', '/_MpXT|', 'Thailand', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dpV,e', '\nQpppS:', 'Timor-Leste', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dpV,e', '/_MpXT|', 'Timor-Leste', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dr94vv', '\nQpppS:', 'Togo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dr94vv', '/_MpXT|', 'Togo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dp.$', '\nQpppS:', 'Tokelau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dp.$', '/_MpXT|', 'Tokelau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e\0p$ب', '\nQpppS:', 'Tonga', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e\0p$ب', '/_MpXT|', 'Tonga', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e	pIx', '\nQpppS:', 'Trinidad und Tobago', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e	pIx', '/_MpXT|', 'Trinidad and Tobago', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('erOZuI', '\nQpppS:', 'Tunesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('erOZuI', '/_MpXT|', 'Tunisia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e\ZsQ޸7n', '\nQpppS:', 'Turkmenistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e\ZsQ޸7n', '/_MpXT|', 'Turkmenistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e$spDls.', '\nQpppS:', 'Turks- und Caicosinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e$spDls.', '/_MpXT|', 'Turks and Caicos Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e.p`m', '\nQpppS:', 'Tuvalu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e.p`m', '/_MpXT|', 'Tuvalu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e7r֑dS', '\nQpppS:', 'Uganda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e7r֑dS', '/_MpXT|', 'Uganda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e@r/ϺE<', '\nQpppS:', 'Ukraine', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e@r/ϺE<', '/_MpXT|', 'Ukraine', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('eJsѣ.Xe', '\nQpppS:', 'Uruguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('eJsѣ.Xe', '/_MpXT|', 'Uruguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('eTs8+-b', '\nQpppS:', 'Usbekistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('eTs8+-b', '/_MpXT|', 'Uzbekistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e^q^', '\nQpppS:', 'Vanuatu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e^q^', '/_MpXT|', 'Vanuatu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ehs֨5A>w1=', '\nQpppS:', 'Venezuela', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ehs֨5A>w1=', '/_MpXT|', 'Venezuela (Bolivarian Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('erswŃ0Z}', '\nQpppS:', 'Vietnam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('erswŃ0Z}', '/_MpXT|', 'Viet Nam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e{q핾', '\nQpppS:', 'Wallis und Futuna', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('e{q핾', '/_MpXT|', 'Wallis and Futuna', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('erm׾G', '\nQpppS:', 'Westsahara', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('erm׾G', '/_MpXT|', 'Western Sahara', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ep\\', '\nQpppS:', 'Jemen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ep\\', '/_MpXT|', 'Yemen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('eqH', '\nQpppS:', 'Sambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('eqH', '/_MpXT|', 'Zambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('erFd', '\nQpppS:', 'Simbabwe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('erFd', '/_MpXT|', 'Zimbabwe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `currency`
--

CREATE TABLE `currency` (
  `id` binary(16) NOT NULL,
  `iso_code` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `factor` double NOT NULL,
  `symbol` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` int NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `item_rounding` json DEFAULT NULL,
  `total_rounding` json DEFAULT NULL,
  `tax_free_from` double DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.currency.iso_code` (`iso_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `currency`
--

INSERT INTO `currency` VALUES
('UKG͂', 'USD', 1, '$', 1, '[[regtime_]]', NULL, '{"decimals": "2", "interval": 0.01, "roundForNet": true}', '{"decimals": "2", "interval": 0.01, "roundForNet": true}', 0);

-- --------------------------------------------------------

--
-- Table structure for table `currency_country_rounding`
--

CREATE TABLE `currency_country_rounding` (
  `id` binary(16) NOT NULL,
  `currency_id` binary(16) NOT NULL,
  `country_id` binary(16) NOT NULL,
  `item_rounding` json NOT NULL,
  `total_rounding` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currency_id` (`currency_id`),
  KEY `country_id` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `currency_translation`
--

CREATE TABLE `currency_translation` (
  `currency_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `short_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`currency_id`,`language_id`),
  KEY `fk.currency_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `currency_translation`
--

INSERT INTO `currency_translation` VALUES
('UKG͂', '\nQpppS:', 'USD', 'US-Dollar', NULL, '[[regtime_]]', NULL),
('UKG͂', '/_MpXT|', 'USD', 'US-Dollar', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customer`
--

CREATE TABLE `customer` (
  `id` binary(16) NOT NULL,
  `auto_increment` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_group_id` binary(16) NOT NULL,
  `requested_customer_group_id` binary(16) DEFAULT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `last_payment_method_id` binary(16) DEFAULT NULL,
  `default_billing_address_id` binary(16) NOT NULL,
  `default_shipping_address_id` binary(16) NOT NULL,
  `customer_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `salutation_id` binary(16) DEFAULT NULL,
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `company` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `legacy_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `legacy_encoder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_ids` json DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `double_opt_in_registration` tinyint(1) NOT NULL DEFAULT '0',
  `double_opt_in_email_sent_date` datetime(3) DEFAULT NULL,
  `double_opt_in_confirm_date` datetime(3) DEFAULT NULL,
  `hash` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `guest` tinyint(1) NOT NULL DEFAULT '0',
  `first_login` datetime(3) DEFAULT NULL,
  `last_login` datetime(3) DEFAULT NULL,
  `newsletter_sales_channel_ids` json DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `last_order_date` datetime(3) DEFAULT NULL,
  `order_count` int NOT NULL DEFAULT '0',
  `order_total_amount` double DEFAULT '0',
  `custom_fields` json DEFAULT NULL,
  `affiliate_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `campaign_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `remote_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tag_ids` json DEFAULT NULL,
  `bound_sales_channel_id` binary(16) DEFAULT NULL,
  `created_by_id` binary(16) DEFAULT NULL,
  `updated_by_id` binary(16) DEFAULT NULL,
  `account_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'private',
  `review_count` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.auto_increment` (`auto_increment`),
  UNIQUE KEY `hash` (`hash`),
  KEY `idx.firstlogin` (`first_login`),
  KEY `idx.lastlogin` (`last_login`),
  KEY `idx.customer.default_billing_address_id` (`default_billing_address_id`),
  KEY `idx.customer.default_shipping_address_id` (`default_shipping_address_id`),
  KEY `fk.customer.customer_group_id` (`customer_group_id`),
  KEY `fk.customer.last_payment_method_id` (`last_payment_method_id`),
  KEY `fk.customer.sales_channel_id` (`sales_channel_id`),
  KEY `fk.customer.requested_customer_group_id` (`requested_customer_group_id`),
  KEY `fk.customer.bound_sales_channel_id` (`bound_sales_channel_id`),
  KEY `idx.email` (`email`),
  KEY `fk.customer.salutation_id` (`salutation_id`),
  KEY `fk.customer.created_by_id` (`created_by_id`),
  KEY `fk.customer.updated_by_id` (`updated_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customer_address`
--

CREATE TABLE `customer_address` (
  `id` binary(16) NOT NULL,
  `customer_id` binary(16) NOT NULL,
  `country_id` binary(16) NOT NULL,
  `country_state_id` binary(16) DEFAULT NULL,
  `company` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `department` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `salutation_id` binary(16) DEFAULT NULL,
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `street` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zipcode` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(70) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone_number` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_address_line1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_address_line2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.customer_address.country_id` (`country_id`),
  KEY `fk.customer_address.country_state_id` (`country_state_id`),
  KEY `fk.customer_address.customer_id` (`customer_id`),
  KEY `fk.customer_address.salutation_id` (`salutation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_group`
--

CREATE TABLE `customer_group` (
  `id` binary(16) NOT NULL,
  `display_gross` tinyint(1) NOT NULL DEFAULT '1',
  `registration_active` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `customer_group`
--

INSERT INTO `customer_group` VALUES
('ϽPӍAحOȽ', 1, 0, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customer_group_registration_sales_channels`
--

CREATE TABLE `customer_group_registration_sales_channels` (
  `customer_group_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  PRIMARY KEY (`customer_group_id`,`sales_channel_id`),
  KEY `fk.customer_group_registration_sales_channels.customer_group_id` (`customer_group_id`),
  KEY `fk.customer_group_registration_sales_channels.sales_channel_id` (`sales_channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_group_translation`
--

CREATE TABLE `customer_group_translation` (
  `customer_group_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `registration_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `registration_introduction` longtext COLLATE utf8mb4_unicode_ci,
  `registration_only_company_registration` tinyint(1) DEFAULT NULL,
  `registration_seo_meta_description` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`customer_group_id`,`language_id`),
  KEY `fk.customer_group_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `customer_group_translation`
--

INSERT INTO `customer_group_translation` VALUES
('ϽPӍAحOȽ', '\nQpppS:', 'Standard-Kundengruppe', NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('ϽPӍAحOȽ', '/_MpXT|', 'Standard customer group', NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customer_recovery`
--

CREATE TABLE `customer_recovery` (
  `id` binary(16) NOT NULL,
  `customer_id` binary(16) NOT NULL,
  `hash` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.customer_recovery.customer_id` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_tag`
--

CREATE TABLE `customer_tag` (
  `customer_id` binary(16) NOT NULL,
  `tag_id` binary(16) NOT NULL,
  PRIMARY KEY (`customer_id`,`tag_id`),
  KEY `fk.customer_tag.tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_wishlist`
--

CREATE TABLE `customer_wishlist` (
  `id` binary(16) NOT NULL,
  `customer_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.customer_wishlist` (`sales_channel_id`,`customer_id`),
  KEY `fk.customer_wishlist.sales_channel_id` (`sales_channel_id`),
  KEY `fk.customer_wishlist.customer_id` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_wishlist_product`
--

CREATE TABLE `customer_wishlist_product` (
  `id` binary(16) NOT NULL,
  `customer_wishlist_id` binary(16) NOT NULL,
  `product_id` binary(16) NOT NULL,
  `product_version_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.customer_wishlist.sales_channel_id__customer_id` (`customer_wishlist_id`,`product_id`),
  KEY `fk.customer_wishlist_product.product_id` (`product_id`,`product_version_id`),
  KEY `fk.customer_wishlist_product.customer_wishlist_id` (`customer_wishlist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_entity`
--

CREATE TABLE `custom_entity` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fields` json NOT NULL,
  `app_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `flags` json DEFAULT NULL,
  `plugin_id` binary(16) DEFAULT NULL,
  `custom_fields_aware` tinyint(1) NOT NULL DEFAULT '0',
  `label_property` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `app_id` (`app_id`),
  KEY `fk.custom_entity.plugin_id` (`plugin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_field`
--

CREATE TABLE `custom_field` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `config` json DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `set_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `allow_customer_write` tinyint NOT NULL DEFAULT '0',
  `allow_cart_expose` tinyint(1) NOT NULL DEFAULT '0',
  `store_api_aware` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.custom_field.name` (`name`),
  KEY `fk.custom_field.set_id` (`set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_field_set`
--

CREATE TABLE `custom_field_set` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `config` json DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `app_id` binary(16) DEFAULT NULL,
  `position` int NOT NULL DEFAULT '1',
  `global` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.custom_field_set.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_field_set_relation`
--

CREATE TABLE `custom_field_set_relation` (
  `id` binary(16) NOT NULL,
  `set_id` binary(16) NOT NULL,
  `entity_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.custom_field_set_relation.entity_name` (`set_id`,`entity_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `delivery_time`
--

CREATE TABLE `delivery_time` (
  `id` binary(16) NOT NULL,
  `min` int NOT NULL,
  `max` int NOT NULL,
  `unit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `delivery_time`
--

INSERT INTO `delivery_time` VALUES
('pHs{Xo', 1, 3, 'day', '[[regtime_]]', NULL),
('pHs{Sb', 2, 5, 'day', '[[regtime_]]', NULL),
('pHs|=', 1, 2, 'week', '[[regtime_]]', NULL),
('pHs|~~', 3, 4, 'week', '[[regtime_]]', NULL),
('UrDD)E', 0, 0, 'hour', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `delivery_time_translation`
--

CREATE TABLE `delivery_time_translation` (
  `delivery_time_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`delivery_time_id`,`language_id`),
  KEY `fk.delivery_time_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `delivery_time_translation`
--

INSERT INTO `delivery_time_translation` VALUES
('pHs{Xo', '\nQpppS:', '1-3 Tage', NULL, '[[regtime_]]', NULL),
('pHs{Xo', '/_MpXT|', '1-3 days', NULL, '[[regtime_]]', NULL),
('pHs{Sb', '\nQpppS:', '2-5 Tage', NULL, '[[regtime_]]', NULL),
('pHs{Sb', '/_MpXT|', '2-5 days', NULL, '[[regtime_]]', NULL),
('pHs|=', '\nQpppS:', '1-2 Wochen', NULL, '[[regtime_]]', NULL),
('pHs|=', '/_MpXT|', '1-2 weeks', NULL, '[[regtime_]]', NULL),
('pHs|~~', '\nQpppS:', '3-4 Wochen', NULL, '[[regtime_]]', NULL),
('pHs|~~', '/_MpXT|', '3-4 weeks', NULL, '[[regtime_]]', NULL),
('UrDD)E', '\nQpppS:', 'Sofort verfügbar', NULL, '[[regtime_]]', NULL),
('UrDD)E', '/_MpXT|', 'Instant download', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document`
--

CREATE TABLE `document` (
  `id` binary(16) NOT NULL,
  `document_type_id` binary(16) NOT NULL,
  `referenced_document_id` binary(16) DEFAULT NULL,
  `order_id` binary(16) NOT NULL,
  `order_version_id` binary(16) NOT NULL,
  `config` json DEFAULT NULL,
  `sent` tinyint(1) NOT NULL DEFAULT '0',
  `static` tinyint(1) NOT NULL DEFAULT '0',
  `deep_link_code` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `document_media_file_id` binary(16) DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `document_number` varchar(255) COLLATE utf8mb4_unicode_ci GENERATED ALWAYS AS (json_unquote(json_extract(`config`,_utf8mb4'$.documentNumber'))) STORED,
  `document_a11y_media_file_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.deep_link_code` (`deep_link_code`),
  KEY `fk.document.document_type_id` (`document_type_id`),
  KEY `fk.document.referenced_document_id` (`referenced_document_id`),
  KEY `fk.document.order_id` (`order_id`,`order_version_id`),
  KEY `fk.document.document_media_file_id` (`document_media_file_id`),
  KEY `idx.document.document_number` (`document_number`),
  KEY `fk.document.document_a11y_media_file_id` (`document_a11y_media_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `document_base_config`
--

CREATE TABLE `document_base_config` (
  `id` binary(16) NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename_prefix` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `filename_suffix` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `document_number` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `global` tinyint(1) DEFAULT '0',
  `document_type_id` binary(16) NOT NULL,
  `logo_id` binary(16) DEFAULT NULL,
  `config` json DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.document_base_config.type_id` (`document_type_id`),
  KEY `fk.document_base_config.logo_id` (`logo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_base_config`
--

INSERT INTO `document_base_config` VALUES
('p&b', 'cancellation_invoice', 'cancellation_invoice_', '', '', 1, 'upzkI', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": true, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayReturnAddress": true, "displayCompanyAddress": true, "diplayLineItemPosition": true, "referencedDocumentType": "invoice", "displayAdditionalNoteDelivery": false}', NULL, '[[regtime_]]', NULL),
('sBi=<F', 'invoice', 'invoice_', '', '', 1, '\ns֍lga9', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": true, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "deliveryCountries": ["019bbbe90ae671219724e31e9c1d96f0", "019bbbe90b8f70a2b174a5c7aa1d8d2b", "019bbbe90b98716fa0276e2fdc7c7dc8", "019bbbe9144770f8853f5fcb56360a54", "019bbbe9145970b4b8ceb5ee3588287d", "019bbbe91477731aab80a91f7ea26652", "019bbbe914897155a3fc0fb9c7271f32", "019bbbe9149b73d894596104e156fe80", "019bbbe914a3728f98e0f7496fcd10e5", "019bbbe914ac7140933ef63d7f53362f", "019bbbe914be70a5b053f13119ca7ae9", "019bbbe9161e7154ad946c230de6072b", "019bbbe91626728ba823ccc0a5a2bcdd", "019bbbe91638736f8370c3761199f1df", "019bbbe9164171e38f0ef4f592709106", "019bbbe9164a73fc967d7bd24b2040f2", "019bbbe91671701f9d507415162364b4", "019bbbe9167a71648bf7894f46856fe4", "019bbbe9168373dfa1327fbd70c0de93", "019bbbe9168c711cab9f8c70494db037", "019bbbe95c957233a828692106f82bf5", "019bbbe95c9e71248795b3777784f2cb", "019bbbe95ca870dfa91276c132045a9b", "019bbbe95cb173d8a6267e8882f8eafe", "019bbbe95cba71deb6932579852c1d3f", "019bbbe95cc77265bddbabf16dc951dd", "019bbbe95cd071fbb3d237842812ee3b", "019bbbe95cd97340aacb43ff6940e70f"], "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayReturnAddress": true, "displayCompanyAddress": true, "diplayLineItemPosition": true}', NULL, '[[regtime_]]', NULL),
('sBi>xyP', 'delivery_note', 'delivery_note_', '', '', 1, '\ns֍lgbv82', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": false, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayReturnAddress": true, "displayCompanyAddress": true, "diplayLineItemPosition": true}', NULL, '[[regtime_]]', NULL),
('sBi?+Ix', 'credit_note', 'credit_note_', '', '', 1, '\ns֍lgcDC', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": true, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayReturnAddress": true, "displayCompanyAddress": true, "diplayLineItemPosition": true, "displayAdditionalNoteDelivery": false}', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document_base_config_sales_channel`
--

CREATE TABLE `document_base_config_sales_channel` (
  `id` binary(16) NOT NULL,
  `document_base_config_id` binary(16) NOT NULL,
  `document_type_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.document_base_configuration_id__sales_channel_id` (`document_type_id`,`sales_channel_id`),
  KEY `fk.document_base_config_sales_channel.document_base_config_id` (`document_base_config_id`),
  KEY `fk.document_base_config_sales_channel.sales_channel_id` (`sales_channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_base_config_sales_channel`
--

INSERT INTO `document_base_config_sales_channel` VALUES
('pƚlgɣ|', 'p&b', 'upzkI', NULL, '[[regtime_]]', NULL),
('s5`vf', 'sBi=<F', '\ns֍lga9', NULL, '[[regtime_]]', NULL),
('qPRۗ=', 'sBi>xyP', '\ns֍lgbv82', NULL, '[[regtime_]]', NULL),
('sˢO', 'sBi?+Ix', '\ns֍lgcDC', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document_type`
--

CREATE TABLE `document_type` (
  `id` binary(16) NOT NULL,
  `technical_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.document_type.technical_name` (`technical_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_type`
--

INSERT INTO `document_type` VALUES
('\ns֍lga9', 'invoice', '[[regtime_]]', NULL),
('\ns֍lgbv82', 'delivery_note', '[[regtime_]]', NULL),
('\ns֍lgcDC', 'credit_note', '[[regtime_]]', NULL),
('upzkI', 'storno', '[[regtime_]]', NULL),
('Bs	opB', 'zugferd_invoice', '[[regtime_]]', NULL),
('Bs	op', 'zugferd_embedded_invoice', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document_type_translation`
--

CREATE TABLE `document_type_translation` (
  `document_type_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`document_type_id`,`language_id`),
  KEY `fk.document_type_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_type_translation`
--

INSERT INTO `document_type_translation` VALUES
('\ns֍lga9', '\nQpppS:', 'Rechnung', NULL, '[[regtime_]]', NULL),
('\ns֍lga9', '/_MpXT|', 'Invoice', NULL, '[[regtime_]]', NULL),
('\ns֍lgbv82', '\nQpppS:', 'Lieferschein', NULL, '[[regtime_]]', NULL),
('\ns֍lgbv82', '/_MpXT|', 'Delivery note', NULL, '[[regtime_]]', NULL),
('\ns֍lgcDC', '\nQpppS:', 'Gutschrift', NULL, '[[regtime_]]', NULL),
('\ns֍lgcDC', '/_MpXT|', 'Credit note', NULL, '[[regtime_]]', NULL),
('upzkI', '\nQpppS:', 'Stornorechnung', NULL, '[[regtime_]]', NULL),
('upzkI', '/_MpXT|', 'Cancellation invoice', NULL, '[[regtime_]]', NULL),
('Bs	opB', '\nQpppS:', 'Rechnung: ZUGFeRD E-Rechnung', NULL, '[[regtime_]]', NULL),
('Bs	opB', '/_MpXT|', 'Invoice: ZUGFeRD E-invoice', NULL, '[[regtime_]]', NULL),
('Bs	op', '\nQpppS:', 'Rechnung: PDF mit eingebetteter ZUGFeRD E-Rechnung', NULL, '[[regtime_]]', NULL),
('Bs	op', '/_MpXT|', 'Invoice: PDF with embedded ZUGFeRD E-invoice', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `flow`
--

CREATE TABLE `flow` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `event_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` int NOT NULL DEFAULT '1',
  `payload` longblob,
  `invalid` tinyint(1) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `app_flow_event_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.flow.event_name` (`event_name`,`priority`),
  KEY `fk.flow.app_flow_event_id` (`app_flow_event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flow`
--

INSERT INTO `flow` VALUES
('_r\\zn', 'Order placed', NULL, 'checkout.order.placed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('_r\\z}U', 'Customer account registered', NULL, 'checkout.customer.register', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('_r\\z㫨`', 'Newsletter sign-up registered', NULL, 'newsletter.register', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('_r\\zB', 'Newsletter sign-up confirmed', NULL, 'newsletter.confirm', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('_r\\z!~', 'User recovery request sent', NULL, 'user.recovery.request', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rDB', 'Contact form sent', NULL, 'contact_form.send', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rE毎', 'Customer requests new password', NULL, 'customer.recovery.request', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rF:q', 'Customer account registered with double opt-in', NULL, 'checkout.customer.double_opt_in_registration', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rG@I', 'Guest account registered with double opt-in', NULL, 'checkout.customer.double_opt_in_guest_order', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rH', 'Customer group registration request accepted', NULL, 'customer.group.registration.accepted', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rH', 'Customer group registration request declined', NULL, 'customer.group.registration.declined', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rIr', 'Shipment enters status partially returned', NULL, 'state_enter.order_delivery.state.returned_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rJ_]', 'Shipment enters status partially shipped', NULL, 'state_enter.order_delivery.state.shipped_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rK9+_', 'Shipment enters status returned', NULL, 'state_enter.order_delivery.state.returned', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rLM', 'Shipment enters status shipped', NULL, 'state_enter.order_delivery.state.shipped', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rN', 'Shipment enters status cancelled', NULL, 'state_enter.order_delivery.state.cancelled', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rOT', 'Payment enters status reminder sent', NULL, 'state_enter.order_transaction.state.reminded', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rO''', 'Payment enters status partially refunded', NULL, 'state_enter.order_transaction.state.refunded_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rQ_F', 'Payment enters status cancelled', NULL, 'state_enter.order_transaction.state.cancelled', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rR', 'Payment enters status paid', NULL, 'state_enter.order_transaction.state.paid', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rS', 'Payment enters status refunded', NULL, 'state_enter.order_transaction.state.refunded', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rTp', 'Payment enters status partially paid', NULL, 'state_enter.order_transaction.state.paid_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rU', 'Payment enters status open', NULL, 'state_enter.order_transaction.state.open', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rWF', 'Order enters status in progress', NULL, 'state_enter.order.state.in_progress', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rW,', 'Order enters status cancelled', NULL, 'state_enter.order.state.cancelled', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('`qC\rX', 'Order enters status completed', NULL, 'state_enter.order.state.completed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('\0s!>[F', 'Deliver ordered product downloads', NULL, 'state_enter.order_transaction.state.paid', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
(')p	f''#4|', 'Review form sent', NULL, 'review_form.send', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('r؎_Wh´', 'Order enters status authorized', NULL, 'state_enter.order_transaction.state.authorized', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('\ZqGϼҸ\r', 'Order enters status chargeback', NULL, 'state_enter.order_transaction.state.chargeback', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('\Zq5BH', 'Order enters status unconfirmed', NULL, 'state_enter.order_transaction.state.unconfirmed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('Xrlf', 'Customer password changed', NULL, 'customer.password.changed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `flow_sequence`
--

CREATE TABLE `flow_sequence` (
  `id` binary(16) NOT NULL,
  `flow_id` binary(16) NOT NULL,
  `app_flow_action_id` binary(16) DEFAULT NULL,
  `parent_id` binary(16) DEFAULT NULL,
  `rule_id` binary(16) DEFAULT NULL,
  `action_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `config` json DEFAULT NULL,
  `position` int NOT NULL DEFAULT '1',
  `display_group` int NOT NULL DEFAULT '1',
  `true_case` tinyint(1) NOT NULL DEFAULT '0',
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.flow_sequence.flow_id` (`flow_id`),
  KEY `fk.flow_sequence.rule_id` (`rule_id`),
  KEY `fk.flow_sequence.parent_id` (`parent_id`),
  KEY `fk.flow_sequence.app_flow_action_id` (`app_flow_action_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flow_sequence`
--

INSERT INTO `flow_sequence` VALUES
('_r\\z', '_r\\zn', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe919fb721da284da3a5e3b655f", "mailTemplateTypeId": "019bbbe97beb71839595d524a2718044"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('_r\\zvc', '_r\\z}U', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe91a0b708bb6a5ae56786d78ca", "mailTemplateTypeId": "019bbbe97bef726985b0b7e58d6877ab"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('_r\\zEC', '_r\\z㫨`', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9195b71e98615877fdccc4266", "mailTemplateTypeId": "019bbbe97bf373009772f1d04f8fdf72"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('_r\\zs', '_r\\zB', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9195b71e98615877fdd7ba282", "mailTemplateTypeId": "019bbbe97bf7708c93b72b76fda180f0"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rD0', '_r\\z!~', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9235171c5ba05ecda6477770b", "mailTemplateTypeId": "019bbbe97bfc7004bd0163adf8dce0dc"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rEK', '`qC\rDB', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe92d227242aa0d0138ea947bb7", "mailTemplateTypeId": "019bbbe97bff705c8f8d8c8cefccf91a"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rEV', '`qC\rE毎', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9313c71e7ae7881a7b549cfc3", "mailTemplateTypeId": "019bbbe97c02710f8a91fd3f9898a1e0"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rG\Z', '`qC\rF:q', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe939607207901276a80877aeae", "mailTemplateTypeId": "019bbbe97c0971e28d06bc6dc99f2d96"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rH,n', '`qC\rG@I', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe939f571d88351bb12e71e2bc3", "mailTemplateTypeId": "019bbbe97c0c71ea8957e88e79f940d6"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rH', '`qC\rH', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe976ad7065bb0e1c55ac219b38", "mailTemplateTypeId": "019bbbe97c0f700c9d9cc2a593bcae81"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rH»Y', '`qC\rH', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe976c973329257b23bdc3fe038", "mailTemplateTypeId": "019bbbe97c1272cb9dbf069cc0ea189d"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rJU', '`qC\rIr', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9355d706a8d01de2861988a8a", "mailTemplateTypeId": "019bbbe97c167297b212ca06028c1995"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rJeo', '`qC\rJ_]', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe93545724c81c99849e4c74c2e", "mailTemplateTypeId": "019bbbe97c1970d796ac5491635b52b9"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rK', '`qC\rK9+_', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9356f72f7a5d65cc863a8565c", "mailTemplateTypeId": "019bbbe97c1d70329118e2c48e78ae42"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rM>\r ', '`qC\rLM', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9358e721a95fdbe8f058ee8ad", "mailTemplateTypeId": "019bbbe97c2071b099efb6dbf17bfad7"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rN', '`qC\rN', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9357f725cb2ff0fa218aad9c7", "mailTemplateTypeId": "019bbbe97c23731b90c6594c18157fb9"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rO*-', '`qC\rOT', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe935ef713d9b1eeb0547322a33", "mailTemplateTypeId": "019bbbe97c27714abc9446116e7b5eed"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rPm', '`qC\rO''', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe935df72859ea2609ff006d075", "mailTemplateTypeId": "019bbbe97c2c7008a425975a8b3762ea"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rQ<t', '`qC\rQ_F', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9361d730f9c6ee3eafce12b91", "mailTemplateTypeId": "019bbbe97c2f720ba980441ab4b79d47"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rR"', '`qC\rR', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe936097190895e822e59087220", "mailTemplateTypeId": "019bbbe97c3370c3ae0147d08ea1467f"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rT`', '`qC\rS', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9362e72a98aad46f7360f00a7", "mailTemplateTypeId": "019bbbe97c3572cbb3d068d2989d4889"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rT', '`qC\rTp', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9363a7393a1f6f47c59a2e518", "mailTemplateTypeId": "019bbbe97c397153bebf7e5c88916df4"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rVW	', '`qC\rU', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe935fc73bd9d7076141ef9054f", "mailTemplateTypeId": "019bbbe97c3c71e9a65123efc2384aea"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rWP', '`qC\rWF', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe935ae737d9b293617866d1ad8", "mailTemplateTypeId": "019bbbe97c3f7348b7d8abce5231390a"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rX', '`qC\rW,', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe935ce72569196c772afca18cb", "mailTemplateTypeId": "019bbbe97c4373149d741996a3828d75"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('`qC\rY}a', '`qC\rX', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe935be710a806d6022d4be8070", "mailTemplateTypeId": "019bbbe97c4670d59e6c663d4b4ac8b5"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('r¯Rj', '\0s!>[F', NULL, NULL, 'sa͍x\n', NULL, '[]', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('pœ6`', '\0s!>[F', NULL, 'r¯Rj', NULL, 'action.grant.download.access', '{"value": true}', 1, 1, 1, NULL, '[[regtime_]]', NULL),
('\npD9̇', '\0s!>[F', NULL, 'r¯Rj', NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9f44271f9b2d37a3dcf552b78", "documentTypeIds": []}', 2, 1, 1, NULL, '[[regtime_]]', NULL),
('1p2L(t ', ')p	f''#4|', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "admin"}, "mailTemplateId": "019bbbea02e27145ad252daa0f66d234", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('rdMS', 'r؎_Wh´', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbea13f87184870992ad12b9e401", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('\Zsi"', '\ZqGϼҸ\r', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbea141472a9a30b51f858db2c14", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('\Zp?~', '\Zq5BH', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbea1437727a8aa7686f1e15497c", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('Xq*_', 'Xrlf', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbea5896724093e3b2f9ef6e782f", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `flow_template`
--

CREATE TABLE `flow_template` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flow_template`
--

INSERT INTO `flow_template` VALUES
('q~Y<o~', 'Contact form sent', '{"eventName": "contact_form.send", "sequences": [{"id": "019bbbe9f5d9717e9d9da5593ce366e1", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe92d227242aa0d0138ea947bb7", "mailTemplateTypeId": "019bbbe92793724b999195b5cb8e0947"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~Y=', 'Newsletter sign-up registered', '{"eventName": "newsletter.register", "sequences": [{"id": "019bbbe9f5d9717e9d9da5593e5d367d", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9195b71e98615877fdd7ba282", "mailTemplateTypeId": "019bbbe918567128a3bd793517a81603"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~Y>~', 'User recovery request sent', '{"eventName": "user.recovery.request", "sequences": [{"id": "019bbbe9f5d9717e9d9da5593f75cb1d", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9235171c5ba05ecda6477770b", "mailTemplateTypeId": "019bbbe9233871e190997369bbe07723"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~Y@AM', 'Guest account registered with double opt-in', '{"eventName": "checkout.customer.double_opt_in_guest_order", "sequences": [{"id": "019bbbe9f5d9717e9d9da55940cb895b", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe939f571d88351bb12e71e2bc3", "mailTemplateTypeId": "019bbbe939f571d88351bb12e752438b"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YA', 'Customer account registered with double opt-in', '{"eventName": "checkout.customer.double_opt_in_registration", "sequences": [{"id": "019bbbe9f5d9717e9d9da55941bb2888", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe939607207901276a80877aeae", "mailTemplateTypeId": "019bbbe939607207901276a808db9bef"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YA', 'Order placed', '{"eventName": "checkout.order.placed", "sequences": [{"id": "019bbbe9f5d9717e9d9da559420b60d2", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe919fb721da284da3a5e3b655f", "mailTemplateTypeId": "019bbbe918567128a3bd79351880e513"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YBo', 'Customer group registration request declined', '{"eventName": "customer.group.registration.declined", "sequences": [{"id": "019bbbe9f5d9717e9d9da55943e54fbc", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe976c973329257b23bdc3fe038", "mailTemplateTypeId": "019bbbe976bf7108a5e8b9723a93ed4b"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YD*D', 'Customer group registration request accepted', '{"eventName": "customer.group.registration.accepted", "sequences": [{"id": "019bbbe9f5d9717e9d9da55945a4595d", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe976ad7065bb0e1c55ac219b38", "mailTemplateTypeId": "019bbbe976a1730f915a7d3830a431ce"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YE8H', 'Newsletter sign-up confirmed', '{"eventName": "newsletter.confirm", "sequences": [{"id": "019bbbe9f5d9717e9d9da559461cd0ed", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9195b71e98615877fdd7ba282", "mailTemplateTypeId": "019bbbe918567128a3bd793517a81603"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YFKP', 'Customer requests new password', '{"eventName": "customer.recovery.request", "sequences": [{"id": "019bbbe9f5d9717e9d9da55947907b3f", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9313c71e7ae7881a7b549cfc3", "mailTemplateTypeId": "019bbbe93133700ea8869efec0cbf154"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YHn*f', 'Customer account registered', '{"eventName": "checkout.customer.register", "sequences": [{"id": "019bbbe9f5d9717e9d9da55948fe636d", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe91a0b708bb6a5ae56786d78ca", "mailTemplateTypeId": "019bbbe918567128a3bd793516d9b76e"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YIy', 'Payment enters status partially paid', '{"eventName": "state_enter.order_transaction.state.paid_partially", "sequences": [{"id": "019bbbe9f5d9717e9d9da5594ac64c2c", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9363a7393a1f6f47c59a2e518", "mailTemplateTypeId": "019bbbe9185772a0812efc86d54d522a"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YJ̗', 'Shipment enters status returned', '{"eventName": "state_enter.order_delivery.state.returned", "sequences": [{"id": "019bbbe9f5d9717e9d9da5594af99669", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9356f72f7a5d65cc863a8565c", "mailTemplateTypeId": "019bbbe9185772a0812efc86d0fa97ff"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YKt', 'Shipment enters status partially returned', '{"eventName": "state_enter.order_delivery.state.returned_partially", "sequences": [{"id": "019bbbe9f5d9717e9d9da5594bd39b84", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9355d706a8d01de2861988a8a", "mailTemplateTypeId": "019bbbe9185772a0812efc86cf642c96"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YL', 'Payment enters status refunded', '{"eventName": "state_enter.order_transaction.state.refunded", "sequences": [{"id": "019bbbe9f5d9717e9d9da5594cda2c84", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9362e72a98aad46f7360f00a7", "mailTemplateTypeId": "019bbbe9185772a0812efc86d4ad5c17"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YM', 'Payment enters status paid', '{"eventName": "state_enter.order_transaction.state.paid", "sequences": [{"id": "019bbbe9f5d9717e9d9da5594ddc5b3d", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe936097190895e822e59087220", "mailTemplateTypeId": "019bbbe9185772a0812efc86d3f96229"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YNb', 'Order enters status in progress', '{"eventName": "state_enter.order.state.in_progress", "sequences": [{"id": "019bbbe9f5d9717e9d9da5594efef1c1", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe935ae737d9b293617866d1ad8", "mailTemplateTypeId": "019bbbe9185772a0812efc86d6f158bf"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YOߺ', 'Payment enters status partially refunded', '{"eventName": "state_enter.order_transaction.state.refunded_partially", "sequences": [{"id": "019bbbe9f5d9717e9d9da55950ac0ac9", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe935df72859ea2609ff006d075", "mailTemplateTypeId": "019bbbe9185772a0812efc86d2eecc38"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YQ>', 'Payment enters status open', '{"eventName": "state_enter.order_transaction.state.open", "sequences": [{"id": "019bbbe9f5d9717e9d9da559518c4ea9", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe935fc73bd9d7076141ef9054f", "mailTemplateTypeId": "019bbbe9185772a0812efc86d5a9e5fd"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YQ,Q', 'Shipment enters status shipped', '{"eventName": "state_enter.order_delivery.state.shipped", "sequences": [{"id": "019bbbe9f5d9717e9d9da5595211e37a", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9358e721a95fdbe8f058ee8ad", "mailTemplateTypeId": "019bbbe9185772a0812efc86d149eae4"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YRe', 'Shipment enters status partially shipped', '{"eventName": "state_enter.order_delivery.state.shipped_partially", "sequences": [{"id": "019bbbe9f5d9717e9d9da5595338f251", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe93545724c81c99849e4c74c2e", "mailTemplateTypeId": "019bbbe9185772a0812efc86d03007a5"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YT/', 'Shipment enters status cancelled', '{"eventName": "state_enter.order_delivery.state.cancelled", "sequences": [{"id": "019bbbe9f5d9717e9d9da5595494a27d", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9357f725cb2ff0fa218aad9c7", "mailTemplateTypeId": "019bbbe9185772a0812efc86d224a177"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YT<', 'Payment enters status cancelled', '{"eventName": "state_enter.order_transaction.state.cancelled", "sequences": [{"id": "019bbbe9f5d9717e9d9da5595579f418", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9361d730f9c6ee3eafce12b91", "mailTemplateTypeId": "019bbbe9185772a0812efc86d32e7147"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YUǤN', 'Order enters status cancelled', '{"eventName": "state_enter.order.state.cancelled", "sequences": [{"id": "019bbbe9f5d9717e9d9da559560c3fde", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe935ce72569196c772afca18cb", "mailTemplateTypeId": "019bbbe9185772a0812efc86d7231b33"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YVd', 'Payment enters status reminder sent', '{"eventName": "state_enter.order_transaction.state.reminded", "sequences": [{"id": "019bbbe9f5d9717e9d9da5595727604d", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe935ef713d9b1eeb0547322a33", "mailTemplateTypeId": "019bbbe9185772a0812efc86d2e77c50"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q~YWeI', 'Order enters status completed', '{"eventName": "state_enter.order.state.completed", "sequences": [{"id": "019bbbe9f5d9717e9d9da55957e1c9ec", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe935be710a806d6022d4be8070", "mailTemplateTypeId": "019bbbe9185772a0812efc86d7696900"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('q"3', 'Deliver ordered product downloads', '{"eventName": "state_enter.order_transaction.state.paid", "sequences": [{"id": "019bbbea0db0701094ec2aa32e84c0e7", "config": [], "ruleId": "019bbbe9f5ee7361abcd8dc1f078d10a", "parentId": null, "position": 1, "trueCase": 0, "actionName": null, "displayGroup": 1}, {"id": "019bbbea0db0701094ec2aa32f5302ef", "config": {"value": true}, "ruleId": null, "parentId": "019bbbea0db0701094ec2aa32e84c0e7", "position": 1, "trueCase": 1, "actionName": "action.grant.download.access", "displayGroup": 1}, {"id": "019bbbea0db0701094ec2aa32fed922e", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbe9f44271f9b2d37a3dcf552b78", "documentTypeIds": [], "mailTemplateTypeId": "019bbbe9f42771408c98c7297275fadf"}, "ruleId": null, "parentId": "019bbbea0db0701094ec2aa32e84c0e7", "position": 2, "trueCase": 1, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('sǺ u', 'Order enters status authorized', '{"eventName": "state_enter.order_transaction.state.authorized", "sequences": [{"id": "019bbbea19fd73c7ba2075a0a7955a39", "config": "{\\"recipient\\": {\\"data\\": [], \\"type\\": \\"default\\"}, \\"mailTemplateId\\": \\"019bbbea13f87184870992ad12b9e401\\", \\"documentTypeIds\\": []}", "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('\ZsGY_$/\r', 'Order enters status chargeback', '{"eventName": "state_enter.order_transaction.state.chargeback", "sequences": [{"id": "019bbbea1a0c7347ad595f24ee7cc06d", "config": "{\\"recipient\\": {\\"data\\": [], \\"type\\": \\"default\\"}, \\"mailTemplateId\\": \\"019bbbea141472a9a30b51f858db2c14\\", \\"documentTypeIds\\": []}", "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('\Zs^)$ ', 'Order enters status unconfirmed', '{"eventName": "state_enter.order_transaction.state.unconfirmed", "sequences": [{"id": "019bbbea1a16735e9a29ed24b22cfb5a", "config": "{\\"recipient\\": {\\"data\\": [], \\"type\\": \\"default\\"}, \\"mailTemplateId\\": \\"019bbbea1437727a8aa7686f1e15497c\\", \\"documentTypeIds\\": []}", "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('Xp?*H', 'Customer password changed', '{"eventName": "customer.password.changed", "sequences": [{"id": "019bbbea58ae711586f0f4c72a5fa3ee", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bbbea5896724093e3b2f9ef6e782f", "mailTemplateTypeId": "019bbbea58957276bb44874e65c70dda"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `import_export_file`
--

CREATE TABLE `import_export_file` (
  `id` binary(16) NOT NULL,
  `original_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expire_date` datetime(3) NOT NULL,
  `size` int DEFAULT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `access_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `import_export_log`
--

CREATE TABLE `import_export_log` (
  `id` binary(16) NOT NULL,
  `activity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `records` int NOT NULL,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profile_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` binary(16) DEFAULT NULL,
  `profile_id` binary(16) DEFAULT NULL,
  `file_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `config` json DEFAULT NULL,
  `result` json DEFAULT NULL,
  `invalid_records_log_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.import_export_log.user_id` (`user_id`),
  KEY `fk.import_export_log.profile_id` (`profile_id`),
  KEY `fk.import_export_log.invalid_records_log_id` (`invalid_records_log_id`),
  KEY `fk.import_export_log.file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `import_export_profile`
--

CREATE TABLE `import_export_profile` (
  `id` binary(16) NOT NULL,
  `system_default` tinyint unsigned NOT NULL DEFAULT '0',
  `source_entity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delimiter` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enclosure` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'import-export',
  `mapping` longtext COLLATE utf8mb4_unicode_ci,
  `update_by` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `config` json DEFAULT NULL,
  `technical_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.import_export_profile.technical_name` (`technical_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `import_export_profile`
--

INSERT INTO `import_export_profile` VALUES
('Uq`VwxBt', 1, 'category', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"parentId","mappedKey":"parent_id","position":1},{"key":"active","mappedKey":"active","position":2},{"key":"type","mappedKey":"type","position":3},{"key":"visible","mappedKey":"visible","position":4},{"key":"translations.DEFAULT.name","mappedKey":"name","position":5},{"key":"translations.DEFAULT.externalLink","mappedKey":"external_link","position":6},{"key":"translations.DEFAULT.description","mappedKey":"description","position":7},{"key":"translations.DEFAULT.metaTitle","mappedKey":"meta_title","position":8},{"key":"translations.DEFAULT.metaDescription","mappedKey":"meta_description","position":9},{"key":"media.id","mappedKey":"media_id","position":10},{"key":"media.url","mappedKey":"media_url","position":11},{"key":"media.mediaFolderId","mappedKey":"media_folder_id","position":12},{"key":"media.mediaType","mappedKey":"media_type","position":13},{"key":"media.translations.DEFAULT.title","mappedKey":"media_title","position":14},{"key":"media.translations.DEFAULT.alt","mappedKey":"media_alt","position":15},{"key":"cmsPageId","mappedKey":"cms_page_id","position":16}]', NULL, '[[regtime_]]', NULL, NULL, 'default_category'),
('UpC/m4\r', 1, 'media', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"mediaFolderId","mappedKey":"folder_id","position":1},{"key":"url","mappedKey":"url","position":2},{"key":"private","mappedKey":"private","position":3},{"key":"mediaType","mappedKey":"type","position":4},{"key":"translations.DEFAULT.title","mappedKey":"title","position":5},{"key":"translations.DEFAULT.alt","mappedKey":"alt","position":6}]', NULL, '[[regtime_]]', NULL, NULL, 'default_media'),
('Uq&', 1, 'product', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"parentId","mappedKey":"parent_id","position":1},{"key":"productNumber","mappedKey":"product_number","position":2},{"key":"active","mappedKey":"active","position":3},{"key":"stock","mappedKey":"stock","position":4},{"key":"translations.DEFAULT.name","mappedKey":"name","position":5},{"key":"translations.DEFAULT.description","mappedKey":"description","position":6},{"key":"price.DEFAULT.net","mappedKey":"price_net","position":7},{"key":"price.DEFAULT.gross","mappedKey":"price_gross","position":8},{"key":"purchasePrices.DEFAULT.net","mappedKey":"purchase_prices_net","position":9},{"key":"purchasePrices.DEFAULT.gross","mappedKey":"purchase_prices_gross","position":10},{"key":"tax.id","mappedKey":"tax_id","position":11},{"key":"tax.taxRate","mappedKey":"tax_rate","position":12},{"key":"tax.name","mappedKey":"tax_name","position":13},{"key":"cover.media.id","mappedKey":"cover_media_id","position":14},{"key":"cover.media.url","mappedKey":"cover_media_url","position":15},{"key":"cover.media.translations.DEFAULT.title","mappedKey":"cover_media_title","position":16},{"key":"cover.media.translations.DEFAULT.alt","mappedKey":"cover_media_alt","position":17},{"key":"manufacturer.id","mappedKey":"manufacturer_id","position":18},{"key":"manufacturer.translations.DEFAULT.name","mappedKey":"manufacturer_name","position":19},{"key":"categories","mappedKey":"categories","position":20},{"key":"visibilities.all","mappedKey":"sales_channel","position":21},{"key":"properties","mappedKey":"propertyIds","position":22},{"key":"options","mappedKey":"optionIds","position":23}]', NULL, '[[regtime_]]', NULL, NULL, 'default_product'),
('Xp^LJQB', 1, 'newsletter_recipient', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"email","mappedKey":"email","position":1},{"key":"title","mappedKey":"title","position":2},{"key":"salutation.salutationKey","mappedKey":"salutation","position":3},{"key":"firstName","mappedKey":"first_name","position":4},{"key":"lastName","mappedKey":"last_name","position":5},{"key":"zipCode","mappedKey":"zip_code","position":6},{"key":"city","mappedKey":"city","position":7},{"key":"street","mappedKey":"street","position":8},{"key":"status","mappedKey":"status","position":9},{"key":"hash","mappedKey":"hash","position":10},{"key":"salesChannel.id","mappedKey":"sales_channel_id","position":11}]', NULL, '[[regtime_]]', NULL, NULL, 'default_newsletter_recipient'),
('XqA"', 1, 'product_configurator_setting', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"productId","mappedKey":"product_id","position":1},{"key":"optionId","mappedKey":"option_id","position":2},{"key":"position","mappedKey":"position","position":3},{"key":"media.id","mappedKey":"media_id","position":4},{"key":"media.url","mappedKey":"media_url","position":5},{"key":"media.mediaFolderId","mappedKey":"media_folder_id","position":6},{"key":"media.mediaType","mappedKey":"media_type","position":7},{"key":"media.translations.DEFAULT.title","mappedKey":"media_title","position":8},{"key":"media.translations.DEFAULT.alt","mappedKey":"media_alt","position":9},{"key":"price.DEFAULT.net","mappedKey":"price_net","position":10},{"key":"price.DEFAULT.gross","mappedKey":"price_gross","position":11}]', NULL, '[[regtime_]]', NULL, NULL, 'default_variant_configuration_settings'),
('Xsn|IN', 1, 'property_group_option', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"colorHexCode","mappedKey":"color_hex_code","position":1},{"key":"translations.DEFAULT.name","mappedKey":"name","position":2},{"key":"translations.DEFAULT.position","mappedKey":"position","position":3},{"key":"group.id","mappedKey":"group_id","position":4},{"key":"group.displayType","mappedKey":"group_display_type","position":5},{"key":"group.sortingType","mappedKey":"group_sorting_type","position":6},{"key":"group.translations.DEFAULT.name","mappedKey":"group_name","position":7},{"key":"group.translations.DEFAULT.description","mappedKey":"group_description","position":8},{"key":"group.translations.DEFAULT.position","mappedKey":"group_position","position":9},{"key":"media.id","mappedKey":"media_id","position":10},{"key":"media.url","mappedKey":"media_url","position":11},{"key":"media.mediaFolderId","mappedKey":"media_folder_id","position":12},{"key":"media.mediaType","mappedKey":"media_type","position":13},{"key":"media.translations.DEFAULT.title","mappedKey":"media_title","position":14},{"key":"media.translations.DEFAULT.alt","mappedKey":"media_alt","position":15}]', NULL, '[[regtime_]]', NULL, NULL, 'default_properties'),
('2q]=', 1, 'product_cross_selling', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"translations.DEFAULT.name","mappedKey":"name","position":1},{"key":"productId","mappedKey":"product_id","position":2},{"key":"active","mappedKey":"active","position":3},{"key":"position","mappedKey":"position","position":4},{"key":"limit","mappedKey":"limit","position":5},{"key":"type","mappedKey":"type","position":6},{"key":"sortBy","mappedKey":"sort_by","position":7},{"key":"sortDirection","mappedKey":"sort_direction","position":8},{"key":"assignedProducts","mappedKey":"assigned_products","position":9}]', NULL, '[[regtime_]]', NULL, NULL, 'default_cross_selling'),
('ҍq0O0ϗ', 1, 'customer', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"salutation.salutationKey","mappedKey":"salutation","position":1},{"key":"customerNumber","mappedKey":"customer_number","position":2},{"key":"firstName","mappedKey":"first_name","position":3},{"key":"lastName","mappedKey":"last_name","position":4},{"key":"email","mappedKey":"email","position":5},{"key":"active","mappedKey":"active","position":6},{"key":"guest","mappedKey":"guest","position":7},{"key":"group.translations.DEFAULT.name","mappedKey":"customer_group","position":8},{"key":"language.locale.code","mappedKey":"language","position":9},{"key":"salesChannel.translations.DEFAULT.name","mappedKey":"sales_channel","position":10},{"key":"defaultPaymentMethod.translations.DEFAULT.name","mappedKey":"payment_method","position":11},{"key":"defaultBillingAddress.id","mappedKey":"billing_id","position":12},{"key":"defaultBillingAddress.salutation.salutationKey","mappedKey":"billing_salutation","position":13},{"key":"defaultBillingAddress.title","mappedKey":"billing_title","position":14},{"key":"defaultBillingAddress.firstName","mappedKey":"billing_first_name","position":15},{"key":"defaultBillingAddress.lastName","mappedKey":"billing_last_name","position":16},{"key":"defaultBillingAddress.company","mappedKey":"billing_company","position":17},{"key":"defaultBillingAddress.street","mappedKey":"billing_street","position":18},{"key":"defaultBillingAddress.zipcode","mappedKey":"billing_zipcode","position":19},{"key":"defaultBillingAddress.city","mappedKey":"billing_city","position":20},{"key":"defaultBillingAddress.country.iso","mappedKey":"billing_country","position":21},{"key":"defaultBillingAddress.phoneNumber","mappedKey":"billing_phone_number","position":22},{"key":"defaultShippingAddress.id","mappedKey":"shipping_id","position":23},{"key":"defaultShippingAddress.salutation.salutationKey","mappedKey":"shipping_salutation","position":24},{"key":"defaultShippingAddress.title","mappedKey":"shipping_title","position":25},{"key":"defaultShippingAddress.firstName","mappedKey":"shipping_first_name","position":26},{"key":"defaultShippingAddress.lastName","mappedKey":"shipping_last_name","position":27},{"key":"defaultShippingAddress.company","mappedKey":"shipping_company","position":28},{"key":"defaultShippingAddress.street","mappedKey":"shipping_street","position":29},{"key":"defaultShippingAddress.zipcode","mappedKey":"shipping_zipcode","position":30},{"key":"defaultShippingAddress.city","mappedKey":"shipping_city","position":31},{"key":"defaultShippingAddress.country.iso","mappedKey":"shipping_country","position":32},{"key":"defaultShippingAddress.phoneNumber","mappedKey":"shipping_phone_number","position":33},{"key":"accountType","mappedKey":"account_type"}]', NULL, '[[regtime_]]', NULL, NULL, 'default_customer'),
('ӡs>s', 1, 'promotion_individual_code', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"promotionId","mappedKey":"promotion_id","position":1},{"key":"code","mappedKey":"code","position":2}]', NULL, '[[regtime_]]', NULL, NULL, 'default_promotion_codes'),
('q\\}ook', 1, 'order', 'text/csv', ';', '"', 'export', '[{"key":"id","mappedKey":"id","position":0},{"key":"orderNumber","mappedKey":"order_number","position":1},{"key":"salesChannelId","mappedKey":"sales_channel_id","position":2},{"key":"orderCustomer.firstName","mappedKey":"customer_firstname","position":3},{"key":"orderCustomer.lastName","mappedKey":"customer_lastname","position":4},{"key":"orderCustomer.email","mappedKey":"customer_email","position":5},{"key":"billingAddress.street","mappedKey":"billing_address_street","position":6},{"key":"billingAddress.zipcode","mappedKey":"billing_address_zipcode","position":7},{"key":"billingAddress.city","mappedKey":"billing_address_city","position":8},{"key":"billingAddress.company","mappedKey":"billing_address_company","position":9},{"key":"billingAddress.department","mappedKey":"billing_address_department","position":10},{"key":"billingAddress.countryId","mappedKey":"billing_address_country_id","position":11},{"key":"billingAddress.countryStateId","mappedKey":"billing_address_country_state_id","position":12},{"key":"deliveries.shippingOrderAddress.street","mappedKey":"shipping_address_street","position":13},{"key":"deliveries.shippingOrderAddress.zipcode","mappedKey":"shipping_address_zipcode","position":14},{"key":"deliveries.shippingOrderAddress.city","mappedKey":"shipping_address_city","position":15},{"key":"deliveries.shippingOrderAddress.company","mappedKey":"shipping_address_company","position":16},{"key":"deliveries.shippingOrderAddress.department","mappedKey":"shipping_address_department","position":17},{"key":"deliveries.shippingOrderAddress.countryId","mappedKey":"shipping_address_country_id","position":18},{"key":"deliveries.shippingOrderAddress.countryStateId","mappedKey":"shipping_address_country_state_id","position":19},{"key":"amountTotal","mappedKey":"amount_total","position":20},{"key":"stateId","mappedKey":"order_state_id","position":21},{"key":"lineItems","mappedKey":"line_items","position":22},{"key":"orderDateTime","mappedKey":"order_date_time","position":23}]', NULL, '[[regtime_]]', NULL, NULL, 'default_orders'),
('pJ,cmj', 1, 'product_price', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"productId","mappedKey":"product_id","position":1},{"key":"ruleId","mappedKey":"rule_id","position":2},{"key":"price.DEFAULT.net","mappedKey":"price_net","position":3},{"key":"price.DEFAULT.gross","mappedKey":"price_gross","position":4},{"key":"quantityStart","mappedKey":"quantity_start","position":5},{"key":"quantityEnd","mappedKey":"quantity_end","position":6}]', NULL, '[[regtime_]]', NULL, NULL, 'default_advanced_prices'),
('s)Fܛ', 1, 'promotion_discount', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"promotionId","mappedKey":"promotion_id","position":1},{"key":"scope","mappedKey":"scope","position":2},{"key":"type","mappedKey":"type","position":3},{"key":"value","mappedKey":"value","position":4},{"key":"considerAdvancedRules","mappedKey":"consider_advanced_rules","position":5},{"key":"maxValue","mappedKey":"max_value","position":6},{"key":"sorterKey","mappedKey":"sorter_key","position":7,"useDefaultValue":true,"defaultValue":"PRICE_ASC"},{"key":"applierKey","mappedKey":"applier_key","position":8,"useDefaultValue":true,"defaultValue":"ALL"},{"key":"usageKey","mappedKey":"usage_key","position":9,"useDefaultValue":true,"defaultValue":"ALL"},{"key":"pickerKey","mappedKey":"picker_key","position":10},{"key":"discountRules","mappedKey":"discount_rules","position":11}]', NULL, '[[regtime_]]', NULL, NULL, 'default_promotion_discounts');

-- --------------------------------------------------------

--
-- Table structure for table `import_export_profile_translation`
--

CREATE TABLE `import_export_profile_translation` (
  `import_export_profile_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`import_export_profile_id`,`language_id`),
  KEY `fk.import_export_profile_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `import_export_profile_translation`
--

INSERT INTO `import_export_profile_translation` VALUES
('Uq`VwxBt', '\nQpppS:', 'Standardprofil Kategorie', '[[regtime_]]', NULL),
('Uq`VwxBt', '/_MpXT|', 'Default category', '[[regtime_]]', NULL),
('UpC/m4\r', '\nQpppS:', 'Standardprofil Medien', '[[regtime_]]', NULL),
('UpC/m4\r', '/_MpXT|', 'Default media', '[[regtime_]]', NULL),
('Uq&', '\nQpppS:', 'Standardprofil Produkt', '[[regtime_]]', NULL),
('Uq&', '/_MpXT|', 'Default product', '[[regtime_]]', NULL),
('Xp^LJQB', '\nQpppS:', 'Standardprofil Newsletter-Empfänger', '[[regtime_]]', NULL),
('Xp^LJQB', '/_MpXT|', 'Default newsletter recipient', '[[regtime_]]', NULL),
('XqA"', '\nQpppS:', 'Standardprofil Variantenkonfiguration', '[[regtime_]]', NULL),
('XqA"', '/_MpXT|', 'Default variant configuration settings', '[[regtime_]]', NULL),
('Xsn|IN', '\nQpppS:', 'Standardprofil Eigenschaften', '[[regtime_]]', NULL),
('Xsn|IN', '/_MpXT|', 'Default properties', '[[regtime_]]', NULL),
('2q]=', '\nQpppS:', 'Standardprofil Cross-Selling', '[[regtime_]]', NULL),
('2q]=', '/_MpXT|', 'Default cross-selling', '[[regtime_]]', NULL),
('ҍq0O0ϗ', '\nQpppS:', 'Standardprofil Kunde', '[[regtime_]]', NULL),
('ҍq0O0ϗ', '/_MpXT|', 'Default customer', '[[regtime_]]', NULL),
('ӡs>s', '\nQpppS:', 'Standardprofil Aktionscodes', '[[regtime_]]', NULL),
('ӡs>s', '/_MpXT|', 'Default promotion codes', '[[regtime_]]', NULL),
('q\\}ook', '\nQpppS:', 'Standardprofil Bestellungen', '[[regtime_]]', NULL),
('q\\}ook', '/_MpXT|', 'Default orders', '[[regtime_]]', NULL),
('pJ,cmj', '\nQpppS:', 'Standardprofil Erweiterte Preise', '[[regtime_]]', NULL),
('pJ,cmj', '/_MpXT|', 'Default advanced prices', '[[regtime_]]', NULL),
('s)Fܛ', '\nQpppS:', 'Standardprofil Aktionsrabatte', '[[regtime_]]', NULL),
('s)Fܛ', '/_MpXT|', 'Default promotion discounts', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `increment`
--

CREATE TABLE `increment` (
  `pool` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cluster` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `count` bigint unsigned NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`pool`,`cluster`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `integration`
--

CREATE TABLE `integration` (
  `id` binary(16) NOT NULL,
  `access_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret_access_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `admin` tinyint(1) NOT NULL DEFAULT '1',
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `last_usage_at` datetime(3) DEFAULT NULL,
  `deleted_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.access_key` (`access_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `integration_role`
--

CREATE TABLE `integration_role` (
  `integration_id` binary(16) NOT NULL,
  `acl_role_id` binary(16) NOT NULL,
  PRIMARY KEY (`integration_id`,`acl_role_id`),
  KEY `fk.integration_acl_role.acl_role_id` (`acl_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `invalidation_tags`
--

CREATE TABLE `invalidation_tags` (
  `id` binary(16) NOT NULL,
  `tag` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tag` (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page`
--

CREATE TABLE `landing_page` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `cms_page_id` binary(16) DEFAULT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.landing_page.cms_page_id` (`cms_page_id`,`cms_page_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page_sales_channel`
--

CREATE TABLE `landing_page_sales_channel` (
  `landing_page_id` binary(16) NOT NULL,
  `landing_page_version_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  PRIMARY KEY (`landing_page_id`,`landing_page_version_id`,`sales_channel_id`),
  KEY `fk.landing_page_sales_channel.sales_channel_id` (`sales_channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page_tag`
--

CREATE TABLE `landing_page_tag` (
  `landing_page_id` binary(16) NOT NULL,
  `landing_page_version_id` binary(16) NOT NULL,
  `tag_id` binary(16) NOT NULL,
  PRIMARY KEY (`landing_page_id`,`landing_page_version_id`,`tag_id`),
  KEY `fk.landing_page_tag.tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page_translation`
--

CREATE TABLE `landing_page_translation` (
  `landing_page_id` binary(16) NOT NULL,
  `landing_page_version_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `slot_config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`landing_page_id`,`landing_page_version_id`,`language_id`),
  KEY `fk.landing_page_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `language`
--

CREATE TABLE `language` (
  `id` binary(16) NOT NULL,
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` binary(16) DEFAULT NULL,
  `locale_id` binary(16) NOT NULL,
  `translation_code_id` binary(16) DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx.language.translation_code_id` (`translation_code_id`),
  KEY `idx.language.language_id_parent_language_id` (`id`,`parent_id`),
  KEY `fk.language.parent_id` (`parent_id`),
  KEY `fk.language.locale_id` (`locale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `language`
--

INSERT INTO `language` VALUES
('\nQpppS:', 'Deutsch', NULL, '\nQppp4', '\nQppp4', NULL, '[[regtime_]]', NULL, 1),
('/_MpXT|', 'English', NULL, '\nPqޙ^', '\nPqޙ^', NULL, '[[regtime_]]', NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `locale`
--

CREATE TABLE `locale` (
  `id` binary(16) NOT NULL,
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `locale`
--

INSERT INTO `locale` VALUES
('\nPqޙ^', 'en-GB', '[[regtime_]]', NULL),
('\nQppp4', 'de-DE', '[[regtime_]]', NULL),
('\nusCȢ*G.', 'aa-DJ', '[[regtime_]]', NULL),
('\nusCȢ*Gz', 'aa-ER', '[[regtime_]]', NULL),
('\nusCȢ*Hwv', 'aa-ET', '[[regtime_]]', NULL),
('\nusCȢ*H', 'af-NA', '[[regtime_]]', NULL),
('\nusCȢ*H(', 'af-ZA', '[[regtime_]]', NULL),
('\nusCȢ*I(!', 'ak-GH', '[[regtime_]]', NULL),
('\nusCȢ*I:', 'am-ET', '[[regtime_]]', NULL),
('\nusCȢ*IS', 'ar-AE', '[[regtime_]]', NULL),
('\nusCȢ*J|n', 'ar-BH', '[[regtime_]]', NULL),
('\nusCȢ*KK', 'ar-DZ', '[[regtime_]]', NULL),
('\nusCȢ*Kߩ', 'ar-EG', '[[regtime_]]', NULL),
('\nusCȢ*Kw', 'ar-IQ', '[[regtime_]]', NULL),
('\nvr\\Ȼ', 'ar-JO', '[[regtime_]]', NULL),
('\nvr\\ȻD', 'ar-KW', '[[regtime_]]', NULL),
('\nvr\\Ȼ', 'ar-LB', '[[regtime_]]', NULL),
('\nvr\\Ȼ#', 'ar-LY', '[[regtime_]]', NULL),
('\nvr\\Ȼ\r', 'ar-MA', '[[regtime_]]', NULL),
('\nvr\\Ȼ', 'ar-OM', '[[regtime_]]', NULL),
('\nvr\\Ȼ!q', 'ar-QA', '[[regtime_]]', NULL),
('\nvr\\ȻvU', 'ar-SA', '[[regtime_]]', NULL),
('\nvr\\Ȼx#', 'ar-SD', '[[regtime_]]', NULL),
('\nvr\\Ȼ>', 'ar-SY', '[[regtime_]]', NULL),
('\nvr\\ȻLc', 'ar-TN', '[[regtime_]]', NULL),
('\nvr\\Ȼm4', 'ar-YE', '[[regtime_]]', NULL),
('\nvr\\Ȼ', 'as-IN', '[[regtime_]]', NULL),
('\nvr\\ȻU', 'az-AZ', '[[regtime_]]', NULL),
('\nvr\\Ȼk', 'be-BY', '[[regtime_]]', NULL),
('\nvr\\Ȼ	 6', 'bg-BG', '[[regtime_]]', NULL),
('\nvr\\Ȼ	N', 'bn-BD', '[[regtime_]]', NULL),
('\nvr\\Ȼ	/m', 'bn-IN', '[[regtime_]]', NULL),
('\nvr\\Ȼ\nw\0', 'bo-CN', '[[regtime_]]', NULL),
('\nvr\\ȻVk', 'bo-IN', '[[regtime_]]', NULL),
('\nvr\\Ȼ`y', 'bs-BA', '[[regtime_]]', NULL),
('\nvr\\Ȼ|$', 'byn-ER', '[[regtime_]]', NULL),
('\nvr\\Ȼ', 'ca-ES', '[[regtime_]]', NULL),
('\nvr\\Ȼ\r5nB', 'cch-NG', '[[regtime_]]', NULL),
('\nvr\\Ȼ\rmF', 'cs-CZ', '[[regtime_]]', NULL),
('\nvr\\Ȼ\rǻ', 'cy-GB', '[[regtime_]]', NULL),
('\nvr\\Ȼ\r6', 'da-DK', '[[regtime_]]', NULL),
('\nvr\\Ȼ6', 'de-AT', '[[regtime_]]', NULL),
('\nvr\\ȻHb|', 'de-BE', '[[regtime_]]', NULL),
('\nvr\\ȻDPg', 'de-CH', '[[regtime_]]', NULL),
('\nvr\\Ȼ<', 'de-LI', '[[regtime_]]', NULL),
('\nvr\\ȻJR', 'de-LU', '[[regtime_]]', NULL),
('\nvr\\Ȼ\n', 'dv-MV', '[[regtime_]]', NULL),
('\nvr\\Ȼ\ZQ', 'dz-BT', '[[regtime_]]', NULL),
('\nvr\\ȻJ>', 'ee-GH', '[[regtime_]]', NULL),
('\nvr\\Ȼ0^T', 'ee-TG', '[[regtime_]]', NULL),
('\nvr\\ȻP', 'el-CY', '[[regtime_]]', NULL),
('\nvr\\Ȼ', 'el-GR', '[[regtime_]]', NULL),
('\nvr\\ȻE', 'en-AS', '[[regtime_]]', NULL),
('\nvr\\Ȼ', 'en-AU', '[[regtime_]]', NULL),
('\nvr\\Ȼc', 'en-BE', '[[regtime_]]', NULL),
('\nvr\\Ȼ', 'en-BW', '[[regtime_]]', NULL),
('\nvr\\ȻPm', 'en-BZ', '[[regtime_]]', NULL),
('\nvr\\Ȼ', 'en-CA', '[[regtime_]]', NULL),
('\nvr\\Ȼ|v', 'en-GU', '[[regtime_]]', NULL),
('\nvr\\ȻR_', 'en-HK', '[[regtime_]]', NULL),
('\nvr\\Ȼ5[#', 'en-IE', '[[regtime_]]', NULL),
('\nvr\\Ȼa|S', 'en-IN', '[[regtime_]]', NULL),
('\nvr\\Ȼ{', 'en-JM', '[[regtime_]]', NULL),
('\nvr\\Ȼ', 'en-MH', '[[regtime_]]', NULL),
('\nvr\\ȻH', 'en-MP', '[[regtime_]]', NULL),
('\nvr\\Ȼ	', 'en-MT', '[[regtime_]]', NULL),
('\nvr\\Ȼ\Z"', 'en-NA', '[[regtime_]]', NULL),
('\nvr\\Ȼ\Za', 'en-NZ', '[[regtime_]]', NULL),
('\nvr\\ȻJ2', 'en-PH', '[[regtime_]]', NULL),
('\nvr\\Ȼ;', 'en-PK', '[[regtime_]]', NULL),
('\nvr\\Ȼ', 'en-SG', '[[regtime_]]', NULL),
('\nvr\\Ȼ', 'en-TT', '[[regtime_]]', NULL),
('\nvr\\Ȼ+', 'en-UM', '[[regtime_]]', NULL),
('\nvr\\Ȼ_P', 'en-US', '[[regtime_]]', NULL),
('\nvr\\Ȼ', 'en-VI', '[[regtime_]]', NULL),
('\nvr\\Ȼ''', 'en-ZA', '[[regtime_]]', NULL),
('\nvr\\Ȼ#B', 'en-ZW', '[[regtime_]]', NULL),
('\nvr\\ȻJ', 'es-AR', '[[regtime_]]', NULL),
('\nvr\\Ȼ $', 'es-BO', '[[regtime_]]', NULL),
('\nvr\\Ȼ! ', 'es-CL', '[[regtime_]]', NULL),
('\nvr\\Ȼ!]K.', 'es-CO', '[[regtime_]]', NULL),
('\nvr\\Ȼ")', 'es-CR', '[[regtime_]]', NULL),
('\nvr\\Ȼ"Λ4', 'es-DO', '[[regtime_]]', NULL),
('\nvr\\Ȼ"PW', 'es-EC', '[[regtime_]]', NULL),
('\nvr\\Ȼ#75', 'es-ES', '[[regtime_]]', NULL),
('\nvr\\Ȼ#`F', 'es-GT', '[[regtime_]]', NULL),
('\nvr\\Ȼ#k\0', 'es-HN', '[[regtime_]]', NULL),
('\nvr\\Ȼ$=', 'es-MX', '[[regtime_]]', NULL),
('\nvr\\Ȼ%#;', 'es-NI', '[[regtime_]]', NULL),
('\nvr\\Ȼ%6', 'es-PA', '[[regtime_]]', NULL),
('\nvr\\Ȼ%6', 'es-PE', '[[regtime_]]', NULL),
('\nvr\\Ȼ&xgV', 'es-PR', '[[regtime_]]', NULL),
('\nvr\\Ȼ&', 'es-PY', '[[regtime_]]', NULL),
('\nvr\\Ȼ''ve', 'es-SV', '[[regtime_]]', NULL),
('\nvr\\Ȼ(o#', 'es-US', '[[regtime_]]', NULL),
('\nvr\\Ȼ)`6', 'es-UY', '[[regtime_]]', NULL),
('\nvr\\Ȼ)3', 'es-VE', '[[regtime_]]', NULL),
('\nvr\\Ȼ*C[', 'et-EE', '[[regtime_]]', NULL),
('\nvr\\Ȼ*M', 'eu-ES', '[[regtime_]]', NULL),
('\nvr\\Ȼ+!\\L', 'fa-AF', '[[regtime_]]', NULL),
('\nvr\\Ȼ+', 'fa-IR', '[[regtime_]]', NULL),
('\nvr\\Ȼ,7h', 'fi-FI', '[[regtime_]]', NULL),
('\nvr\\Ȼ-w2', 'fil-PH', '[[regtime_]]', NULL),
('\nvr\\Ȼ..', 'fo-FO', '[[regtime_]]', NULL),
('\nvr\\Ȼ.MSG', 'fr-BE', '[[regtime_]]', NULL),
('\nvr\\Ȼ.fIR', 'fr-CA', '[[regtime_]]', NULL),
('\nvr\\Ȼ.', 'fr-CH', '[[regtime_]]', NULL),
('\nvr\\Ȼ/;L', 'fr-FR', '[[regtime_]]', NULL),
('\nvr\\Ȼ0]', 'fr-LU', '[[regtime_]]', NULL),
('\nvr\\Ȼ1', 'fr-MC', '[[regtime_]]', NULL),
('\nvr\\Ȼ2i', 'fr-SN', '[[regtime_]]', NULL),
('\nvr\\Ȼ2v', 'fur-IT', '[[regtime_]]', NULL),
('\nvr\\Ȼ3{-', 'ga-IE', '[[regtime_]]', NULL),
('\nvr\\Ȼ4q', 'gaa-GH', '[[regtime_]]', NULL),
('\nvr\\Ȼ4H', 'gez-ER', '[[regtime_]]', NULL),
('\nvr\\Ȼ5U', 'gez-ET', '[[regtime_]]', NULL),
('\nvr\\Ȼ5]H', 'gl-ES', '[[regtime_]]', NULL),
('\nvr\\Ȼ6K', 'gsw-CH', '[[regtime_]]', NULL),
('\nvr\\Ȼ7', 'gu-IN', '[[regtime_]]', NULL),
('\nvr\\Ȼ7,', 'gv-GB', '[[regtime_]]', NULL),
('\nvr\\Ȼ8', 'ha-GH', '[[regtime_]]', NULL),
('\nvr\\Ȼ8s', 'ha-NE', '[[regtime_]]', NULL),
('\nvr\\Ȼ9`f]', 'ha-NG', '[[regtime_]]', NULL),
('\nvr\\Ȼ9}ϣ', 'ha-SD', '[[regtime_]]', NULL),
('\nvr\\Ȼ96', 'haw-US', '[[regtime_]]', NULL),
('\nvr\\Ȼ:;R', 'he-IL', '[[regtime_]]', NULL),
('\nvr\\Ȼ:oZ', 'hi-IN', '[[regtime_]]', NULL),
('\nvr\\Ȼ;:W', 'hr-HR', '[[regtime_]]', NULL),
('\nvr\\Ȼ<\Zk', 'hu-HU', '[[regtime_]]', NULL),
('\nvr\\Ȼ=\0"(', 'hy-AM', '[[regtime_]]', NULL),
('\nvr\\Ȼ=z', 'id-ID', '[[regtime_]]', NULL),
('\nvr\\Ȼ>*F', 'ig-NG', '[[regtime_]]', NULL),
('\nvr\\Ȼ>E', 'ii-CN', '[[regtime_]]', NULL),
('\nvr\\Ȼ?Ky\\', 'is-IS', '[[regtime_]]', NULL),
('\nvr\\Ȼ@B', 'it-CH', '[[regtime_]]', NULL),
('\nvr\\ȻA\r', 'it-IT', '[[regtime_]]', NULL),
('\nvr\\ȻA', 'ja-JP', '[[regtime_]]', NULL),
('\nvr\\ȻAA', 'ka-GE', '[[regtime_]]', NULL),
('\nvr\\ȻBg', 'kaj-NG', '[[regtime_]]', NULL),
('\nvr\\ȻB&l:', 'kam-KE', '[[regtime_]]', NULL),
('\nvr\\ȻC', 'kcg-NG', '[[regtime_]]', NULL),
('\nvr\\ȻC', 'kfo-CI', '[[regtime_]]', NULL),
('\nvr\\ȻC', 'kk-KZ', '[[regtime_]]', NULL),
('\nvr\\ȻC', 'kl-GL', '[[regtime_]]', NULL),
('\nvr\\ȻC\r', 'km-KH', '[[regtime_]]', NULL),
('\nvr\\ȻDN', 'kn-IN', '[[regtime_]]', NULL),
('\nvr\\ȻE:s', 'ko-KR', '[[regtime_]]', NULL),
('\nvr\\ȻF_', 'kok-IN', '[[regtime_]]', NULL),
('\nvr\\ȻF', 'kpe-GN', '[[regtime_]]', NULL),
('\nvr\\ȻG4*%', 'kpe-LR', '[[regtime_]]', NULL),
('\nvr\\ȻG=', 'ku-IQ', '[[regtime_]]', NULL),
('\nvr\\ȻG', 'ku-IR', '[[regtime_]]', NULL),
('\nvr\\ȻHA', 'ku-SY', '[[regtime_]]', NULL),
('\nvr\\ȻHs-', 'ku-TR', '[[regtime_]]', NULL),
('\nvr\\ȻHe', 'kw-GB', '[[regtime_]]', NULL),
('\nvr\\ȻI\n+', 'ky-KG', '[[regtime_]]', NULL),
('\nvr\\ȻIY', 'ln-CD', '[[regtime_]]', NULL),
('\nvr\\ȻJI4 ', 'ln-CG', '[[regtime_]]', NULL),
('\nvr\\ȻK#', 'lo-LA', '[[regtime_]]', NULL),
('\nvr\\ȻKe%', 'lt-LT', '[[regtime_]]', NULL),
('\nvr\\ȻLb', 'lv-LV', '[[regtime_]]', NULL),
('\nvr\\ȻM/w', 'mk-MK', '[[regtime_]]', NULL),
('\nvr\\ȻMn', 'ml-IN', '[[regtime_]]', NULL),
('\nvr\\ȻNF', 'mn-CN', '[[regtime_]]', NULL),
('\nvr\\ȻN+#', 'mn-MN', '[[regtime_]]', NULL),
('\nvr\\ȻO', 'mr-IN', '[[regtime_]]', NULL),
('\nvr\\ȻOy', 'ms-BN', '[[regtime_]]', NULL),
('\nvr\\ȻP\n', 'ms-MY', '[[regtime_]]', NULL),
('\nvr\\ȻP׌', 'mt-MT', '[[regtime_]]', NULL),
('\nvr\\ȻP', 'my-MM', '[[regtime_]]', NULL),
('\nvr\\ȻQx', 'nb-NO', '[[regtime_]]', NULL),
('\nvr\\ȻQC', 'nds-DE', '[[regtime_]]', NULL),
('\nvr\\ȻR}', 'ne-IN', '[[regtime_]]', NULL),
('\nvr\\ȻR\0', 'ne-NP', '[[regtime_]]', NULL),
('\nvr\\ȻS4F', 'nl-BE', '[[regtime_]]', NULL),
('\nvr\\ȻT!', 'nl-NL', '[[regtime_]]', NULL),
('\nvr\\ȻT >\r', 'nn-NO', '[[regtime_]]', NULL),
('\nwp򡐫', 'nr-ZA', '[[regtime_]]', NULL),
('\nwp򡐫-', 'nso-ZA', '[[regtime_]]', NULL),
('\nwp򡐫0t', 'ny-MW', '[[regtime_]]', NULL),
('\nwp򡐫\Z1', 'oc-FR', '[[regtime_]]', NULL),
('\nwp򡐫\ZqO', 'om-ET', '[[regtime_]]', NULL),
('\nwp򡐫\Zga', 'om-KE', '[[regtime_]]', NULL),
('\nwp򡐫\Zp', 'or-IN', '[[regtime_]]', NULL),
('\nwp򡐫', 'pa-IN', '[[regtime_]]', NULL),
('\nwp򡐫$Jt', 'pa-PK', '[[regtime_]]', NULL),
('\nwp򡐫', 'pl-PL', '[[regtime_]]', NULL),
('\nwp򡐫-r', 'ps-AF', '[[regtime_]]', NULL),
('\nwp򡐫ty', 'pt-BR', '[[regtime_]]', NULL),
('\nwp򡐫ۑ', 'pt-PT', '[[regtime_]]', NULL),
('\nwp򡐫c', 'ro-MD', '[[regtime_]]', NULL),
('\nwp򡐫zm', 'ro-RO', '[[regtime_]]', NULL),
('\nwp򡐫:u', 'ru-RU', '[[regtime_]]', NULL),
('\nwp򡐫޸', 'ru-UA', '[[regtime_]]', NULL),
('\nwp򡐫?', 'rw-RW', '[[regtime_]]', NULL),
('\nwp򡐫m#', 'sa-IN', '[[regtime_]]', NULL),
('\nwp򡐫 ', 'se-FI', '[[regtime_]]', NULL),
('\nwp򡐫 N', 'se-NO', '[[regtime_]]', NULL),
('\nwp򡐫!a', 'sh-BA', '[[regtime_]]', NULL),
('\nwp򡐫!0%', 'sh-CS', '[[regtime_]]', NULL),
('\nwp򡐫"\r', 'si-LK', '[[regtime_]]', NULL),
('\nwp򡐫#\r_', 'sid-ET', '[[regtime_]]', NULL),
('\nwp򡐫#L`', 'sk-SK', '[[regtime_]]', NULL),
('\nwp򡐫#', 'sl-SI', '[[regtime_]]', NULL),
('\nwp򡐫$E', 'so-DJ', '[[regtime_]]', NULL),
('\nwp򡐫%b', 'so-ET', '[[regtime_]]', NULL),
('\nwp򡐫%V(', 'so-KE', '[[regtime_]]', NULL),
('\nwp򡐫%h+', 'so-SO', '[[regtime_]]', NULL),
('\nwp򡐫%', 'sq-AL', '[[regtime_]]', NULL),
('\nwp򡐫&>e', 'sr-BA', '[[regtime_]]', NULL),
('\nwp򡐫&', 'sr-CS', '[[regtime_]]', NULL),
('\nwp򡐫''ۭ', 'sr-ME', '[[regtime_]]', NULL),
('\nwp򡐫''2C', 'sr-RS', '[[regtime_]]', NULL),
('\nwp򡐫''', 'ss-SZ', '[[regtime_]]', NULL),
('\nwp򡐫(9', 'ss-ZA', '[[regtime_]]', NULL),
('\nwp򡐫(', 'st-LS', '[[regtime_]]', NULL),
('\nwp򡐫(', 'st-ZA', '[[regtime_]]', NULL),
('\nwp򡐫)', 'sv-FI', '[[regtime_]]', NULL),
('\nwp򡐫*wi', 'sv-SE', '[[regtime_]]', NULL),
('\nwp򡐫*@', 'sw-KE', '[[regtime_]]', NULL),
('\nwp򡐫+O_', 'sw-TZ', '[[regtime_]]', NULL),
('\nwp򡐫+t', 'syr-SY', '[[regtime_]]', NULL),
('\nwp򡐫,%\n', 'ta-IN', '[[regtime_]]', NULL),
('\nwp򡐫,4D', 'te-IN', '[[regtime_]]', NULL),
('\nwp򡐫,{', 'tg-TJ', '[[regtime_]]', NULL),
('\nwp򡐫-P%z', 'th-TH', '[[regtime_]]', NULL),
('\nwp򡐫-a', 'ti-ER', '[[regtime_]]', NULL),
('\nwp򡐫.v)', 'ti-ET', '[[regtime_]]', NULL),
('\nwp򡐫/Tt', 'tig-ER', '[[regtime_]]', NULL),
('\nwp򡐫0', 'tn-ZA', '[[regtime_]]', NULL),
('\nwp򡐫0`', 'to-TO', '[[regtime_]]', NULL),
('\nwp򡐫15iu', 'tr-TR', '[[regtime_]]', NULL),
('\nwp򡐫2#A', 'ts-ZA', '[[regtime_]]', NULL),
('\nwp򡐫2', 'tt-RU', '[[regtime_]]', NULL),
('\nwp򡐫2N', 'ug-CN', '[[regtime_]]', NULL),
('\nwp򡐫3', 'uk-UA', '[[regtime_]]', NULL),
('\nwp򡐫3rV', 'ur-IN', '[[regtime_]]', NULL),
('\nwp򡐫3}', 'ur-PK', '[[regtime_]]', NULL),
('\nwp򡐫4', 'uz-AF', '[[regtime_]]', NULL),
('\nwp򡐫4{FT', 'uz-UZ', '[[regtime_]]', NULL),
('\nwp򡐫4Y', 've-ZA', '[[regtime_]]', NULL),
('\nwp򡐫5\0', 'vi-VN', '[[regtime_]]', NULL),
('\nwp򡐫5''|', 'wal-ET', '[[regtime_]]', NULL),
('\nwp򡐫5rX', 'wo-SN', '[[regtime_]]', NULL),
('\nwp򡐫6C', 'xh-ZA', '[[regtime_]]', NULL),
('\nwp򡐫6H', 'yo-NG', '[[regtime_]]', NULL),
('\nwp򡐫6dU', 'zh-CN', '[[regtime_]]', NULL),
('\nwp򡐫6Մ+', 'zh-HK', '[[regtime_]]', NULL),
('\nwp򡐫7EG', 'zh-MO', '[[regtime_]]', NULL),
('\nwp򡐫8&', 'zh-SG', '[[regtime_]]', NULL),
('\nwp򡐫84j', 'zh-TW', '[[regtime_]]', NULL),
('\nwp򡐫8ǀ', 'zu-ZA', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `locale_translation`
--

CREATE TABLE `locale_translation` (
  `locale_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `territory` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`locale_id`,`language_id`),
  KEY `fk.locale_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `locale_translation`
--

INSERT INTO `locale_translation` VALUES
('\nPqޙ^', '\nQpppS:', 'Englisch', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('\nPqޙ^', '/_MpXT|', 'English', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('\nQppp4', '\nQpppS:', 'Deutsch', 'Deutschland', NULL, '[[regtime_]]', NULL),
('\nQppp4', '/_MpXT|', 'German', 'Germany', NULL, '[[regtime_]]', NULL),
('\nusCȢ*G.', '\nQpppS:', 'Afar', 'Dschibuti', NULL, '[[regtime_]]', NULL),
('\nusCȢ*G.', '/_MpXT|', 'Afar', 'Djibouti', NULL, '[[regtime_]]', NULL),
('\nusCȢ*Gz', '\nQpppS:', 'Afar', 'Eritrea', NULL, '[[regtime_]]', NULL),
('\nusCȢ*Gz', '/_MpXT|', 'Afar', 'Eritrea', NULL, '[[regtime_]]', NULL),
('\nusCȢ*Hwv', '\nQpppS:', 'Afar', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('\nusCȢ*Hwv', '/_MpXT|', 'Afar', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('\nusCȢ*H', '\nQpppS:', 'Afrikaans', 'Namibia', NULL, '[[regtime_]]', NULL),
('\nusCȢ*H', '/_MpXT|', 'Afrikaans', 'Namibia', NULL, '[[regtime_]]', NULL),
('\nusCȢ*H(', '\nQpppS:', 'Afrikaans', 'Südafrika', NULL, '[[regtime_]]', NULL),
('\nusCȢ*H(', '/_MpXT|', 'Afrikaans', 'South Africa', NULL, '[[regtime_]]', NULL),
('\nusCȢ*I(!', '\nQpppS:', 'Akan', 'Ghana', NULL, '[[regtime_]]', NULL),
('\nusCȢ*I(!', '/_MpXT|', 'Akan', 'Ghana', NULL, '[[regtime_]]', NULL),
('\nusCȢ*I:', '\nQpppS:', 'Amharisch', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('\nusCȢ*I:', '/_MpXT|', 'Amharic', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('\nusCȢ*IS', '\nQpppS:', 'Arabisch', 'Vereinigte Arabische Emirate', NULL, '[[regtime_]]', NULL),
('\nusCȢ*IS', '/_MpXT|', 'Arabic', 'United Arab Emirates', NULL, '[[regtime_]]', NULL),
('\nusCȢ*J|n', '\nQpppS:', 'Arabisch', 'Bahrain', NULL, '[[regtime_]]', NULL),
('\nusCȢ*J|n', '/_MpXT|', 'Arabic', 'Bahrain', NULL, '[[regtime_]]', NULL),
('\nusCȢ*KK', '\nQpppS:', 'Arabisch', 'Algerien', NULL, '[[regtime_]]', NULL),
('\nusCȢ*KK', '/_MpXT|', 'Arabic', 'Algeria', NULL, '[[regtime_]]', NULL),
('\nusCȢ*Kߩ', '\nQpppS:', 'Arabisch', 'Ägypten', NULL, '[[regtime_]]', NULL),
('\nusCȢ*Kߩ', '/_MpXT|', 'Arabic', 'Egypt', NULL, '[[regtime_]]', NULL),
('\nusCȢ*Kw', '\nQpppS:', 'Arabisch', 'Irak', NULL, '[[regtime_]]', NULL),
('\nusCȢ*Kw', '/_MpXT|', 'Arabic', 'Iraq', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '\nQpppS:', 'Arabisch', 'Jordanien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '/_MpXT|', 'Arabic', 'Jordan', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻD', '\nQpppS:', 'Arabisch', 'Kuwait', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻD', '/_MpXT|', 'Arabic', 'Kuwait', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '\nQpppS:', 'Arabisch', 'Libanon', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '/_MpXT|', 'Arabic', 'Lebanon', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ#', '\nQpppS:', 'Arabisch', 'Libyen', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ#', '/_MpXT|', 'Arabic', 'Libya', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\r', '\nQpppS:', 'Arabisch', 'Marokko', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\r', '/_MpXT|', 'Arabic', 'Morocco', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '\nQpppS:', 'Arabisch', 'Oman', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '/_MpXT|', 'Arabic', 'Oman', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ!q', '\nQpppS:', 'Arabisch', 'Katar', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ!q', '/_MpXT|', 'Arabic', 'Qatar', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻvU', '\nQpppS:', 'Arabisch', 'Saudi-Arabien', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻvU', '/_MpXT|', 'Arabic', 'Saudi Arabia', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼx#', '\nQpppS:', 'Arabisch', 'Sudan', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼx#', '/_MpXT|', 'Arabic', 'Sudan', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ>', '\nQpppS:', 'Arabisch', 'Syrien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ>', '/_MpXT|', 'Arabic', 'Syria', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻLc', '\nQpppS:', 'Arabisch', 'Tunesien', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻLc', '/_MpXT|', 'Arabic', 'Tunisia', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼm4', '\nQpppS:', 'Arabisch', 'Jemen', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼm4', '/_MpXT|', 'Arabic', 'Yemen', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '\nQpppS:', 'Assamesisch', 'Indien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '/_MpXT|', 'Assamese', 'India', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻU', '\nQpppS:', 'Aserbaidschanisch', 'Aserbaidschan', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻU', '/_MpXT|', 'Azerbaijani', 'Azerbaijan', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼk', '\nQpppS:', 'Weißrussisch', 'Belarus', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼk', '/_MpXT|', 'Belarusian', 'Belarus', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ	 6', '\nQpppS:', 'Bulgarisch', 'Bulgarien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ	 6', '/_MpXT|', 'Bulgarian', 'Bulgaria', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ	N', '\nQpppS:', 'Bengalisch', 'Bangladesch', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ	N', '/_MpXT|', 'Bengali', 'Bangladesh', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ	/m', '\nQpppS:', 'Bengalisch', 'Indien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ	/m', '/_MpXT|', 'Bengali', 'India', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\nw\0', '\nQpppS:', 'Tibetisch', 'China', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\nw\0', '/_MpXT|', 'Tibetan', 'China', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻVk', '\nQpppS:', 'Tibetisch', 'Indien', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻVk', '/_MpXT|', 'Tibetan', 'India', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ`y', '\nQpppS:', 'Bosnisch', 'Bosnien und Herzegowina', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ`y', '/_MpXT|', 'Bosnian', 'Bosnia and Herzegovina', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ|$', '\nQpppS:', 'Blin', 'Eritrea', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ|$', '/_MpXT|', 'Blin', 'Eritrea', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '\nQpppS:', 'Katalanisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '/_MpXT|', 'Catalan', 'Spain', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\r5nB', '\nQpppS:', 'Atsam', 'Nigeria', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\r5nB', '/_MpXT|', 'Atsam', 'Nigeria', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\rmF', '\nQpppS:', 'Tschechisch', 'Tschechische Republik', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\rmF', '/_MpXT|', 'Czech', 'Czech Republic', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\rǻ', '\nQpppS:', 'Walisisch', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\rǻ', '/_MpXT|', 'Welsh', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\r6', '\nQpppS:', 'Dänisch', 'Dänemark', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\r6', '/_MpXT|', 'Danish', 'Denmark', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ6', '\nQpppS:', 'Deutsch', 'Österreich', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ6', '/_MpXT|', 'German', 'Austria', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻHb|', '\nQpppS:', 'Deutsch', 'Belgien', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻHb|', '/_MpXT|', 'German', 'Belgium', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻDPg', '\nQpppS:', 'Deutsch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻDPg', '/_MpXT|', 'German', 'Switzerland', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ<', '\nQpppS:', 'Deutsch', 'Liechtenstein', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ<', '/_MpXT|', 'German', 'Liechtenstein', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻJR', '\nQpppS:', 'Deutsch', 'Luxemburg', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻJR', '/_MpXT|', 'German', 'Luxemburg', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\n', '\nQpppS:', 'Maledivisch', 'Malediven', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\n', '/_MpXT|', 'Maldivian', 'Maldive Islands', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\ZQ', '\nQpppS:', 'Bhutanisch', 'Bhutan', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\ZQ', '/_MpXT|', 'Bhutanese', 'Bhutan', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻJ>', '\nQpppS:', 'Ewe-Sprache', 'Ghana', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻJ>', '/_MpXT|', 'Ewe', 'Ghana', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ0^T', '\nQpppS:', 'Ewe-Sprache', 'Togo', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ0^T', '/_MpXT|', 'Ewe', 'Togo', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻP', '\nQpppS:', 'Griechisch', 'Zypern', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻP', '/_MpXT|', 'Greek', 'Cyprus', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '\nQpppS:', 'Griechisch', 'Griechenland', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '/_MpXT|', 'Greek', 'Greece', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻE', '\nQpppS:', 'Englisch', 'Amerikanisch-Samoa', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻE', '/_MpXT|', 'English', 'American Samoa', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '\nQpppS:', 'Englisch', 'Australien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '/_MpXT|', 'English', 'Australia', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼc', '\nQpppS:', 'Englisch', 'Belgien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼc', '/_MpXT|', 'English', 'Belgium', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '\nQpppS:', 'Englisch', 'Botsuana', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '/_MpXT|', 'English', 'Botswana', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻPm', '\nQpppS:', 'Englisch', 'Belize', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻPm', '/_MpXT|', 'English', 'Belize', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '\nQpppS:', 'Englisch', 'Kanada', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '/_MpXT|', 'English', 'Canada', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ|v', '\nQpppS:', 'Englisch', 'Guam', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ|v', '/_MpXT|', 'English', 'Guam', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻR_', '\nQpppS:', 'Englisch', 'Sonderverwaltungszone Hongkong', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻR_', '/_MpXT|', 'English', 'Hong Kong', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ5[#', '\nQpppS:', 'Englisch', 'Irland', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ5[#', '/_MpXT|', 'English', 'Ireland', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼa|S', '\nQpppS:', 'Englisch', 'Indien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼa|S', '/_MpXT|', 'English', 'India', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ{', '\nQpppS:', 'Englisch', 'Jamaika', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ{', '/_MpXT|', 'English', 'Jamaica', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '\nQpppS:', 'Englisch', 'Marshallinseln', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '/_MpXT|', 'English', 'Marshall Islands', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻH', '\nQpppS:', 'Englisch', 'Nördliche Marianen', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻH', '/_MpXT|', 'English', 'Northern Mariana Islands', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ	', '\nQpppS:', 'Englisch', 'Malta', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ	', '/_MpXT|', 'English', 'Malta', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\Z"', '\nQpppS:', 'Englisch', 'Namibia', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\Z"', '/_MpXT|', 'English', 'Namibia', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\Za', '\nQpppS:', 'Englisch', 'Neuseeland', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ\Za', '/_MpXT|', 'English', 'New Zealand', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻJ2', '\nQpppS:', 'Englisch', 'Philippinen', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻJ2', '/_MpXT|', 'English', 'Philippines', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ;', '\nQpppS:', 'Englisch', 'Pakistan', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ;', '/_MpXT|', 'English', 'Pakistan', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '\nQpppS:', 'Englisch', 'Singapur', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '/_MpXT|', 'English', 'Singapore', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '\nQpppS:', 'Englisch', 'Trinidad und Tobago', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '/_MpXT|', 'English', 'Trinidad and Tobago', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ+', '\nQpppS:', 'Englisch', 'Amerikanisch-Ozeanien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ+', '/_MpXT|', 'English', 'U.S. Minor Outlying Islands', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ_P', '\nQpppS:', 'Englisch (US)', 'Vereinigte Staaten', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ_P', '/_MpXT|', 'English (US)', 'United States', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '\nQpppS:', 'Englisch', 'Amerikanische Jungferninseln', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ', '/_MpXT|', 'English', 'American Virgin Islands', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ''', '\nQpppS:', 'Englisch', 'Südafrika', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ''', '/_MpXT|', 'English', 'South Africa', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ#B', '\nQpppS:', 'Englisch', 'Simbabwe', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ#B', '/_MpXT|', 'English', 'Zimbabwe', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻJ', '\nQpppS:', 'Spanisch', 'Argentinien', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻJ', '/_MpXT|', 'Spanish', 'Argentina', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ $', '\nQpppS:', 'Spanisch', 'Bolivien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ $', '/_MpXT|', 'Spanish', 'Bolivia', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ! ', '\nQpppS:', 'Spanisch', 'Chile', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ! ', '/_MpXT|', 'Spanish', 'Chile', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ!]K.', '\nQpppS:', 'Spanisch', 'Kolumbien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ!]K.', '/_MpXT|', 'Spanish', 'Colombia', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ")', '\nQpppS:', 'Spanisch', 'Costa Rica', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ")', '/_MpXT|', 'Spanish', 'Costa Rica', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ"Λ4', '\nQpppS:', 'Spanisch', 'Dominikanische Republik', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ"Λ4', '/_MpXT|', 'Spanish', 'Dominican Republic', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ"PW', '\nQpppS:', 'Spanisch', 'Ecuador', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ"PW', '/_MpXT|', 'Spanish', 'Ecuador', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ#75', '\nQpppS:', 'Spanisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ#75', '/_MpXT|', 'Spanish', 'Spain', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ#`F', '\nQpppS:', 'Spanisch', 'Guatemala', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ#`F', '/_MpXT|', 'Spanish', 'Guatemala', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ#k\0', '\nQpppS:', 'Spanisch', 'Honduras', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ#k\0', '/_MpXT|', 'Spanish', 'Honduras', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ$=', '\nQpppS:', 'Spanisch', 'Mexiko', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ$=', '/_MpXT|', 'Spanish', 'Mexico', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ%#;', '\nQpppS:', 'Spanisch', 'Nicaragua', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ%#;', '/_MpXT|', 'Spanish', 'Nicaragua', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ%6', '\nQpppS:', 'Spanisch', 'Panama', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ%6', '/_MpXT|', 'Spanish', 'Panama', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ%6', '\nQpppS:', 'Spanisch', 'Peru', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ%6', '/_MpXT|', 'Spanish', 'Peru', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ&xgV', '\nQpppS:', 'Spanisch', 'Puerto Rico', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ&xgV', '/_MpXT|', 'Spanish', 'Puerto Rico', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ&', '\nQpppS:', 'Spanisch', 'Paraguay', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ&', '/_MpXT|', 'Spanish', 'Paraguay', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ''ve', '\nQpppS:', 'Spanisch', 'El Salvador', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ''ve', '/_MpXT|', 'Spanish', 'El Salvador', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ(o#', '\nQpppS:', 'Spanisch', 'Vereinigte Staaten', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ(o#', '/_MpXT|', 'Spanish', 'United States', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ)`6', '\nQpppS:', 'Spanisch', 'Uruguay', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ)`6', '/_MpXT|', 'Spanish', 'Uruguay', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ)3', '\nQpppS:', 'Spanisch', 'Venezuela', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ)3', '/_MpXT|', 'Spanish', 'Venezuela', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ*C[', '\nQpppS:', 'Estnisch', 'Estland', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ*C[', '/_MpXT|', 'Estonian', 'Estonia', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ*M', '\nQpppS:', 'Baskisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ*M', '/_MpXT|', 'Basque', 'Spain', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ+!\\L', '\nQpppS:', 'Persisch', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ+!\\L', '/_MpXT|', 'Persian', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ+', '\nQpppS:', 'Persisch', 'Iran', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ+', '/_MpXT|', 'Persian', 'Iran', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ,7h', '\nQpppS:', 'Finnisch', 'Finnland', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ,7h', '/_MpXT|', 'Finnish', 'Finland', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ-w2', '\nQpppS:', 'Filipino', 'Philippinen', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ-w2', '/_MpXT|', 'Filipino', 'Philippines', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ..', '\nQpppS:', 'Färöisch', 'Färöer', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ..', '/_MpXT|', 'Faeroese', 'Faeroe Islands', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ.MSG', '\nQpppS:', 'Französisch', 'Belgien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ.MSG', '/_MpXT|', 'French', 'Belgium', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ.fIR', '\nQpppS:', 'Französisch', 'Kanada', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ.fIR', '/_MpXT|', 'French', 'Canada', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ.', '\nQpppS:', 'Französisch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ.', '/_MpXT|', 'French', 'Switzerland', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ/;L', '\nQpppS:', 'Französisch', 'Frankreich', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ/;L', '/_MpXT|', 'French', 'France', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ0]', '\nQpppS:', 'Französisch', 'Luxemburg', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ0]', '/_MpXT|', 'French', 'Luxembourg', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ1', '\nQpppS:', 'Französisch', 'Monaco', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ1', '/_MpXT|', 'French', 'Monaco', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ2i', '\nQpppS:', 'Französisch', 'Senegal', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ2i', '/_MpXT|', 'French', 'Senegal', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ2v', '\nQpppS:', 'Friulisch', 'Italien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ2v', '/_MpXT|', 'Friulian', 'Italy', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ3{-', '\nQpppS:', 'Irisch', 'Irland', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ3{-', '/_MpXT|', 'Irish', 'Ireland', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ4q', '\nQpppS:', 'Ga-Sprache', 'Ghana', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ4q', '/_MpXT|', 'Ga', 'Ghana', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ4H', '\nQpppS:', 'Geez', 'Eritrea', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ4H', '/_MpXT|', 'Geez', 'Eritrea', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ5U', '\nQpppS:', 'Geez', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ5U', '/_MpXT|', 'Geez', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ5]H', '\nQpppS:', 'Galizisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ5]H', '/_MpXT|', 'Galician', 'Spain', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ6K', '\nQpppS:', 'Schweizerdeutsch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ6K', '/_MpXT|', 'Swiss German', 'Switzerland', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ7', '\nQpppS:', 'Gujarati', 'Indien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ7', '/_MpXT|', 'Gujarati', 'India', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ7,', '\nQpppS:', 'Manx', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ7,', '/_MpXT|', 'Manx', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ8', '\nQpppS:', 'Hausa', 'Ghana', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ8', '/_MpXT|', 'Hausa', 'Ghana', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ8s', '\nQpppS:', 'Hausa', 'Niger', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ8s', '/_MpXT|', 'Hausa', 'Niger', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ9`f]', '\nQpppS:', 'Hausa', 'Nigeria', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ9`f]', '/_MpXT|', 'Hausa', 'Nigeria', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ9}ϣ', '\nQpppS:', 'Hausa', 'Sudan', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ9}ϣ', '/_MpXT|', 'Hausa', 'Sudan', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ96', '\nQpppS:', 'Hawaiisch', 'Vereinigte Staaten', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ96', '/_MpXT|', 'Hawaiian', 'United States', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ:;R', '\nQpppS:', 'Hebräisch', 'Israel', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ:;R', '/_MpXT|', 'Hebrew', 'Israel', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ:oZ', '\nQpppS:', 'Hindi', 'Indien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ:oZ', '/_MpXT|', 'Hindi', 'India', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ;:W', '\nQpppS:', 'Kroatisch', 'Kroatien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ;:W', '/_MpXT|', 'Croatian', 'Croatia', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ<\Zk', '\nQpppS:', 'Ungarisch', 'Ungarn', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ<\Zk', '/_MpXT|', 'Hungarian', 'Hungary', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ=\0"(', '\nQpppS:', 'Armenisch', 'Armenien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ=\0"(', '/_MpXT|', 'Armenian', 'Armenia', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ=z', '\nQpppS:', 'Indonesisch', 'Indonesien', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ=z', '/_MpXT|', 'Indonesian', 'Indonesia', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ>*F', '\nQpppS:', 'Igbo-Sprache', 'Nigeria', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ>*F', '/_MpXT|', 'Igbo', 'Nigeria', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ>E', '\nQpppS:', 'Sichuan Yi', 'China', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ>E', '/_MpXT|', 'Sichuan Yi', 'China', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ?Ky\\', '\nQpppS:', 'Isländisch', 'Island', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ?Ky\\', '/_MpXT|', 'Icelandic', 'Iceland', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ@B', '\nQpppS:', 'Italienisch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('\nvr\\Ȼ@B', '/_MpXT|', 'Italian', 'Switzerland', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻA\r', '\nQpppS:', 'Italienisch', 'Italien', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻA\r', '/_MpXT|', 'Italian', 'Italy', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻA', '\nQpppS:', 'Japanisch', 'Japan', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻA', '/_MpXT|', 'Japanese', 'Japan', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻAA', '\nQpppS:', 'Georgisch', 'Georgien', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻAA', '/_MpXT|', 'Georgian', 'Georgia', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻBg', '\nQpppS:', 'Jju', 'Nigeria', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻBg', '/_MpXT|', 'Jju', 'Nigeria', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻB&l:', '\nQpppS:', 'Kamba', 'Kenia', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻB&l:', '/_MpXT|', 'Kamba', 'Kenya', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻC', '\nQpppS:', 'Tyap', 'Nigeria', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻC', '/_MpXT|', 'Tyap', 'Nigeria', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻC', '\nQpppS:', 'Koro', 'Elfenbeinküste', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻC', '/_MpXT|', 'Koro', 'Ivory Coast', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻC', '\nQpppS:', 'Kasachisch', 'Kasachstan', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻC', '/_MpXT|', 'Kazakh', 'Kazakhstan', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻC', '\nQpppS:', 'Grönländisch', 'Grönland', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻC', '/_MpXT|', 'Greenlandic', 'Greenland', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻC\r', '\nQpppS:', 'Kambodschanisch', 'Kambodscha', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻC\r', '/_MpXT|', 'Cambodian', 'Cambodia', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻDN', '\nQpppS:', 'Kannada', 'Indien', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻDN', '/_MpXT|', 'Kannada', 'India', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻE:s', '\nQpppS:', 'Koreanisch', 'Republik Korea', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻE:s', '/_MpXT|', 'Korean', 'Republic of Korea', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻF_', '\nQpppS:', 'Konkani', 'Indien', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻF_', '/_MpXT|', 'Konkani', 'India', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻF', '\nQpppS:', 'Kpelle-Sprache', 'Guinea', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻF', '/_MpXT|', 'Kpelle', 'Guinea', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻG4*%', '\nQpppS:', 'Kpelle-Sprache', 'Liberia', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻG4*%', '/_MpXT|', 'Kpelle', 'Liberia', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻG=', '\nQpppS:', 'Kurdisch', 'Irak', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻG=', '/_MpXT|', 'Kurdish', 'Iraq', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻG', '\nQpppS:', 'Kurdisch', 'Iran', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻG', '/_MpXT|', 'Kurdish', 'Iran', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻHA', '\nQpppS:', 'Kurdisch', 'Syrien', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻHA', '/_MpXT|', 'Kurdish', 'Syria', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻHs-', '\nQpppS:', 'Kurdisch', 'Türkei', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻHs-', '/_MpXT|', 'Kurdish', 'Turkey', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻHe', '\nQpppS:', 'Kornisch', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻHe', '/_MpXT|', 'Cornish', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻI\n+', '\nQpppS:', 'Kirgisisch', 'Kirgisistan', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻI\n+', '/_MpXT|', 'Kirghiz', 'Kyrgyzstan', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻIY', '\nQpppS:', 'Lingala', 'Demokratische Republik Kongo', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻIY', '/_MpXT|', 'Lingala', 'Democratic Republic of the Congo', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻJI4 ', '\nQpppS:', 'Lingala', 'Kongo', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻJI4 ', '/_MpXT|', 'Lingala', 'Congo', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻK#', '\nQpppS:', 'Laotisch', 'Laos', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻK#', '/_MpXT|', 'Lao', 'Laos', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻKe%', '\nQpppS:', 'Litauisch', 'Litauen', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻKe%', '/_MpXT|', 'Lithuanian', 'Lithuania', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻLb', '\nQpppS:', 'Lettisch', 'Lettland', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻLb', '/_MpXT|', 'Latvian', 'Latvia', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻM/w', '\nQpppS:', 'Mazedonisch', 'Mazedonien', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻM/w', '/_MpXT|', 'Macedonian', 'Macedonia', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻMn', '\nQpppS:', 'Malayalam', 'Indien', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻMn', '/_MpXT|', 'Malayalam', 'India', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻNF', '\nQpppS:', 'Mongolisch', 'China', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻNF', '/_MpXT|', 'Mongol', 'China', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻN+#', '\nQpppS:', 'Mongolisch', 'Mongolei', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻN+#', '/_MpXT|', 'Mongol', 'Mongolia', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻO', '\nQpppS:', 'Marathi', 'Indien', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻO', '/_MpXT|', 'Marathi', 'India', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻOy', '\nQpppS:', 'Malaiisch', 'Brunei Darussalam', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻOy', '/_MpXT|', 'Malay', 'Brunei Darussalam', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻP\n', '\nQpppS:', 'Malaiisch', 'Malaysia', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻP\n', '/_MpXT|', 'Malay', 'Malaysia', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻP׌', '\nQpppS:', 'Maltesisch', 'Malta', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻP׌', '/_MpXT|', 'Maltese', 'Malta', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻP', '\nQpppS:', 'Birmanisch', 'Myanmar', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻP', '/_MpXT|', 'Burmese', 'Myanmar', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻQx', '\nQpppS:', 'Norwegisch Bokmål', 'Norwegen', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻQx', '/_MpXT|', 'Norwegian Bokmål', 'Norway', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻQC', '\nQpppS:', 'Niederdeutsch', 'Deutschland', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻQC', '/_MpXT|', 'Low German', 'Germany', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻR}', '\nQpppS:', 'Nepalesisch', 'Indien', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻR}', '/_MpXT|', 'Nepalese', 'India', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻR\0', '\nQpppS:', 'Nepalesisch', 'Nepal', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻR\0', '/_MpXT|', 'Nepalese', 'Nepal', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻS4F', '\nQpppS:', 'Niederländisch', 'Belgien', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻS4F', '/_MpXT|', 'Dutch', 'Belgium', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻT!', '\nQpppS:', 'Niederländisch', 'Niederlande', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻT!', '/_MpXT|', 'Dutch', 'Netherlands', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻT >\r', '\nQpppS:', 'Norwegisch Nynorsk', 'Norwegen', NULL, '[[regtime_]]', NULL),
('\nvr\\ȻT >\r', '/_MpXT|', 'Norwegian Nynorsk', 'Norway', NULL, '[[regtime_]]', NULL),
('\nwp򡐫', '\nQpppS:', 'Süd-Ndebele-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('\nwp򡐫', '/_MpXT|', 'Southern Ndebele', 'South Africa', NULL, '[[regtime_]]', NULL),
('\nwp򡐫-', '\nQpppS:', 'Nord-Sotho-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('\nwp򡐫-', '/_MpXT|', 'Northern Sotho language', 'South Africa', NULL, '[[regtime_]]', NULL),
('\nwp򡐫0t', '\nQpppS:', 'Nyanja-Sprache', 'Malawi', NULL, '[[regtime_]]', NULL),
('\nwp򡐫0t', '/_MpXT|', 'Nyanja', 'Malawi', NULL, '[[regtime_]]', NULL),
('\nwp򡐫\Z1', '\nQpppS:', 'Okzitanisch', 'Frankreich', NULL, '[[regtime_]]', NULL),
('\nwp򡐫\Z1', '/_MpXT|', 'Occitan', 'France', NULL, '[[regtime_]]', NULL),
('\nwp򡐫\ZqO', '\nQpppS:', 'Oromo', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫\ZqO', '/_MpXT|', 'Oromo', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('\nwp򡐫\Zga', '\nQpppS:', 'Oromo', 'Kenia', NULL, '[[regtime_]]', NULL),
('\nwp򡐫\Zga', '/_MpXT|', 'Oromo', 'Kenya', NULL, '[[regtime_]]', NULL),
('\nwp򡐫\Zp', '\nQpppS:', 'Orija', 'Indien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫\Zp', '/_MpXT|', 'Orija', 'India', NULL, '[[regtime_]]', NULL),
('\nwp򡐫', '\nQpppS:', 'Pandschabisch', 'Indien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫', '/_MpXT|', 'Punjabi', 'India', NULL, '[[regtime_]]', NULL),
('\nwp򡐫$Jt', '\nQpppS:', 'Pandschabisch', 'Pakistan', NULL, '[[regtime_]]', NULL),
('\nwp򡐫$Jt', '/_MpXT|', 'Punjabi', 'Pakistan', NULL, '[[regtime_]]', NULL),
('\nwp򡐫', '\nQpppS:', 'Polnisch', 'Polen', NULL, '[[regtime_]]', NULL),
('\nwp򡐫', '/_MpXT|', 'Polish', 'Poland', NULL, '[[regtime_]]', NULL),
('\nwp򡐫-r', '\nQpppS:', 'Paschtu', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('\nwp򡐫-r', '/_MpXT|', 'Pashto', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('\nwp򡐫ty', '\nQpppS:', 'Portugiesisch', 'Brasilien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫ty', '/_MpXT|', 'Portuguese', 'Brazil', NULL, '[[regtime_]]', NULL),
('\nwp򡐫ۑ', '\nQpppS:', 'Portugiesisch', 'Portugal', NULL, '[[regtime_]]', NULL),
('\nwp򡐫ۑ', '/_MpXT|', 'Portuguese', 'Portugal', NULL, '[[regtime_]]', NULL),
('\nwp򡐫c', '\nQpppS:', 'Rumänisch', 'Republik Moldau', NULL, '[[regtime_]]', NULL),
('\nwp򡐫c', '/_MpXT|', 'Romanian', 'Republic of Moldova', NULL, '[[regtime_]]', NULL),
('\nwp򡐫zm', '\nQpppS:', 'Rumänisch', 'Rumänien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫zm', '/_MpXT|', 'Romanian', 'Romania', NULL, '[[regtime_]]', NULL),
('\nwp򡐫:u', '\nQpppS:', 'Russisch', 'Russische Föderation', NULL, '[[regtime_]]', NULL),
('\nwp򡐫:u', '/_MpXT|', 'Russian', 'Russian Federation', NULL, '[[regtime_]]', NULL),
('\nwp򡐫޸', '\nQpppS:', 'Russisch', 'Ukraine', NULL, '[[regtime_]]', NULL),
('\nwp򡐫޸', '/_MpXT|', 'Russian', 'Ukraine', NULL, '[[regtime_]]', NULL),
('\nwp򡐫?', '\nQpppS:', 'Ruandisch', 'Ruanda', NULL, '[[regtime_]]', NULL),
('\nwp򡐫?', '/_MpXT|', 'Rwandan', 'Rwanda', NULL, '[[regtime_]]', NULL),
('\nwp򡐫m#', '\nQpppS:', 'Sanskrit', 'Indien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫m#', '/_MpXT|', 'Sanskrit', 'India', NULL, '[[regtime_]]', NULL),
('\nwp򡐫 ', '\nQpppS:', 'Nord-Samisch', 'Finnland', NULL, '[[regtime_]]', NULL),
('\nwp򡐫 ', '/_MpXT|', 'Northen Samian', 'Finland', NULL, '[[regtime_]]', NULL),
('\nwp򡐫 N', '\nQpppS:', 'Nord-Samisch', 'Norwegen', NULL, '[[regtime_]]', NULL),
('\nwp򡐫 N', '/_MpXT|', 'Northen Samian', 'Norway', NULL, '[[regtime_]]', NULL),
('\nwp򡐫!a', '\nQpppS:', 'Serbo-Kroatisch', 'Bosnien und Herzegowina', NULL, '[[regtime_]]', NULL),
('\nwp򡐫!a', '/_MpXT|', 'Serbo-Croat', 'Bosnia and Herzegovina', NULL, '[[regtime_]]', NULL),
('\nwp򡐫!0%', '\nQpppS:', 'Serbo-Kroatisch', 'Serbien und Montenegro', NULL, '[[regtime_]]', NULL),
('\nwp򡐫!0%', '/_MpXT|', 'Serbo-Croat', 'Serbia and Montenegro', NULL, '[[regtime_]]', NULL),
('\nwp򡐫"\r', '\nQpppS:', 'Singhalesisch', 'Sri Lanka', NULL, '[[regtime_]]', NULL),
('\nwp򡐫"\r', '/_MpXT|', 'Singhalese', 'Sri Lanka', NULL, '[[regtime_]]', NULL),
('\nwp򡐫#\r_', '\nQpppS:', 'Sidamo', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫#\r_', '/_MpXT|', 'Sidamo', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('\nwp򡐫#L`', '\nQpppS:', 'Slowakisch', 'Slowakei', NULL, '[[regtime_]]', NULL),
('\nwp򡐫#L`', '/_MpXT|', 'Slovak', 'Slovakia', NULL, '[[regtime_]]', NULL),
('\nwp򡐫#', '\nQpppS:', 'Slowenisch', 'Slowenien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫#', '/_MpXT|', 'Slovene', 'Slovenia', NULL, '[[regtime_]]', NULL),
('\nwp򡐫$E', '\nQpppS:', 'Somali', 'Dschibuti', NULL, '[[regtime_]]', NULL),
('\nwp򡐫$E', '/_MpXT|', 'Somali', 'Djibouti', NULL, '[[regtime_]]', NULL),
('\nwp򡐫%b', '\nQpppS:', 'Somali', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫%b', '/_MpXT|', 'Somali', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('\nwp򡐫%V(', '\nQpppS:', 'Somali', 'Kenia', NULL, '[[regtime_]]', NULL),
('\nwp򡐫%V(', '/_MpXT|', 'Somali', 'Kenya', NULL, '[[regtime_]]', NULL),
('\nwp򡐫%h+', '\nQpppS:', 'Somali', 'Somalia', NULL, '[[regtime_]]', NULL),
('\nwp򡐫%h+', '/_MpXT|', 'Somali', 'Somalia', NULL, '[[regtime_]]', NULL),
('\nwp򡐫%', '\nQpppS:', 'Albanisch', 'Albanien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫%', '/_MpXT|', 'Albanian', 'Albania', NULL, '[[regtime_]]', NULL),
('\nwp򡐫&>e', '\nQpppS:', 'Serbisch', 'Bosnien und Herzegowina', NULL, '[[regtime_]]', NULL),
('\nwp򡐫&>e', '/_MpXT|', 'Serbian', 'Bosnia and Herzegovina', NULL, '[[regtime_]]', NULL),
('\nwp򡐫&', '\nQpppS:', 'Serbisch', 'Serbien und Montenegro', NULL, '[[regtime_]]', NULL),
('\nwp򡐫&', '/_MpXT|', 'Serbian', 'Serbia and Montenegro', NULL, '[[regtime_]]', NULL),
('\nwp򡐫''ۭ', '\nQpppS:', 'Serbisch', 'Montenegro', NULL, '[[regtime_]]', NULL),
('\nwp򡐫''ۭ', '/_MpXT|', 'Serbian', 'Montenegro', NULL, '[[regtime_]]', NULL),
('\nwp򡐫''2C', '\nQpppS:', 'Serbisch', 'Serbien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫''2C', '/_MpXT|', 'Serbian', 'Serbia', NULL, '[[regtime_]]', NULL),
('\nwp򡐫''', '\nQpppS:', 'Swazi', 'Swasiland', NULL, '[[regtime_]]', NULL),
('\nwp򡐫''', '/_MpXT|', 'Swazi', 'Swaziland', NULL, '[[regtime_]]', NULL),
('\nwp򡐫(9', '\nQpppS:', 'Swazi', 'Südafrika', NULL, '[[regtime_]]', NULL),
('\nwp򡐫(9', '/_MpXT|', 'Swazi', 'South Africa', NULL, '[[regtime_]]', NULL),
('\nwp򡐫(', '\nQpppS:', 'Süd-Sotho-Sprache', 'Lesotho', NULL, '[[regtime_]]', NULL),
('\nwp򡐫(', '/_MpXT|', 'Southern Sotho Language', 'Lesotho', NULL, '[[regtime_]]', NULL),
('\nwp򡐫(', '\nQpppS:', 'Süd-Sotho-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('\nwp򡐫(', '/_MpXT|', 'Southern Sotho Language', 'South Africa', NULL, '[[regtime_]]', NULL),
('\nwp򡐫)', '\nQpppS:', 'Schwedisch', 'Finnland', NULL, '[[regtime_]]', NULL),
('\nwp򡐫)', '/_MpXT|', 'Swedish', 'Finland', NULL, '[[regtime_]]', NULL),
('\nwp򡐫*wi', '\nQpppS:', 'Schwedisch', 'Schweden', NULL, '[[regtime_]]', NULL),
('\nwp򡐫*wi', '/_MpXT|', 'Swedish', 'Sweden', NULL, '[[regtime_]]', NULL),
('\nwp򡐫*@', '\nQpppS:', 'Suaheli', 'Kenia', NULL, '[[regtime_]]', NULL),
('\nwp򡐫*@', '/_MpXT|', 'Swahili', 'Kenya', NULL, '[[regtime_]]', NULL),
('\nwp򡐫+O_', '\nQpppS:', 'Suaheli', 'Tansania', NULL, '[[regtime_]]', NULL),
('\nwp򡐫+O_', '/_MpXT|', 'Swahili', 'Tanzania', NULL, '[[regtime_]]', NULL),
('\nwp򡐫+t', '\nQpppS:', 'Syrisch', 'Syrien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫+t', '/_MpXT|', 'Syriac', 'Syria', NULL, '[[regtime_]]', NULL),
('\nwp򡐫,%\n', '\nQpppS:', 'Tamilisch', 'Indien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫,%\n', '/_MpXT|', 'Tamil', 'India', NULL, '[[regtime_]]', NULL),
('\nwp򡐫,4D', '\nQpppS:', 'Telugu', 'Indien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫,4D', '/_MpXT|', 'Telugu', 'India', NULL, '[[regtime_]]', NULL),
('\nwp򡐫,{', '\nQpppS:', 'Tadschikisch', 'Tadschikistan', NULL, '[[regtime_]]', NULL),
('\nwp򡐫,{', '/_MpXT|', 'Tadjik', 'Tajikistan', NULL, '[[regtime_]]', NULL),
('\nwp򡐫-P%z', '\nQpppS:', 'Thailändisch', 'Thailand', NULL, '[[regtime_]]', NULL),
('\nwp򡐫-P%z', '/_MpXT|', 'Thai', 'Thailand', NULL, '[[regtime_]]', NULL),
('\nwp򡐫-a', '\nQpppS:', 'Tigrinja', 'Eritrea', NULL, '[[regtime_]]', NULL),
('\nwp򡐫-a', '/_MpXT|', 'Tigrinya', 'Eritrea', NULL, '[[regtime_]]', NULL),
('\nwp򡐫.v)', '\nQpppS:', 'Tigrinja', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫.v)', '/_MpXT|', 'Tigrinya', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('\nwp򡐫/Tt', '\nQpppS:', 'Tigre', 'Eritrea', NULL, '[[regtime_]]', NULL),
('\nwp򡐫/Tt', '/_MpXT|', 'Tigre', 'Eritrea', NULL, '[[regtime_]]', NULL),
('\nwp򡐫0', '\nQpppS:', 'Tswana-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('\nwp򡐫0', '/_MpXT|', 'Tswana Language', 'South Africa', NULL, '[[regtime_]]', NULL),
('\nwp򡐫0`', '\nQpppS:', 'Tongaisch', 'Tonga', NULL, '[[regtime_]]', NULL),
('\nwp򡐫0`', '/_MpXT|', 'Tongan', 'Tonga', NULL, '[[regtime_]]', NULL),
('\nwp򡐫15iu', '\nQpppS:', 'Türkisch', 'Türkei', NULL, '[[regtime_]]', NULL),
('\nwp򡐫15iu', '/_MpXT|', 'Turkish', 'Turkey', NULL, '[[regtime_]]', NULL),
('\nwp򡐫2#A', '\nQpppS:', 'Tsonga', 'Südafrika', NULL, '[[regtime_]]', NULL),
('\nwp򡐫2#A', '/_MpXT|', 'Tsonga', 'South Africa', NULL, '[[regtime_]]', NULL),
('\nwp򡐫2', '\nQpppS:', 'Tatarisch', 'Russische Föderation', NULL, '[[regtime_]]', NULL),
('\nwp򡐫2', '/_MpXT|', 'Tartar', 'Russian Federation', NULL, '[[regtime_]]', NULL),
('\nwp򡐫2N', '\nQpppS:', 'Uigurisch', 'China', NULL, '[[regtime_]]', NULL),
('\nwp򡐫2N', '/_MpXT|', 'Uighur', 'China', NULL, '[[regtime_]]', NULL);
INSERT INTO `locale_translation` VALUES
('\nwp򡐫3', '\nQpppS:', 'Ukrainisch', 'Ukraine', NULL, '[[regtime_]]', NULL),
('\nwp򡐫3', '/_MpXT|', 'Ukrainian', 'Ukraine', NULL, '[[regtime_]]', NULL),
('\nwp򡐫3rV', '\nQpppS:', 'Urdu', 'Indien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫3rV', '/_MpXT|', 'Urdu', 'India', NULL, '[[regtime_]]', NULL),
('\nwp򡐫3}', '\nQpppS:', 'Urdu', 'Pakistan', NULL, '[[regtime_]]', NULL),
('\nwp򡐫3}', '/_MpXT|', 'Urdu', 'Pakistan', NULL, '[[regtime_]]', NULL),
('\nwp򡐫4', '\nQpppS:', 'Usbekisch', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('\nwp򡐫4', '/_MpXT|', 'Uzbek', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('\nwp򡐫4{FT', '\nQpppS:', 'Usbekisch', 'Usbekistan', NULL, '[[regtime_]]', NULL),
('\nwp򡐫4{FT', '/_MpXT|', 'Uzbek', 'Uzbekistan', NULL, '[[regtime_]]', NULL),
('\nwp򡐫4Y', '\nQpppS:', 'Venda-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('\nwp򡐫4Y', '/_MpXT|', 'Venda Language', 'South Africa', NULL, '[[regtime_]]', NULL),
('\nwp򡐫5\0', '\nQpppS:', 'Vietnamesisch', 'Vietnam', NULL, '[[regtime_]]', NULL),
('\nwp򡐫5\0', '/_MpXT|', 'Vietnamese', 'Vietnam', NULL, '[[regtime_]]', NULL),
('\nwp򡐫5''|', '\nQpppS:', 'Walamo-Sprache', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('\nwp򡐫5''|', '/_MpXT|', 'Walamo Language', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('\nwp򡐫5rX', '\nQpppS:', 'Wolof', 'Senegal', NULL, '[[regtime_]]', NULL),
('\nwp򡐫5rX', '/_MpXT|', 'Wolof', 'Senegal', NULL, '[[regtime_]]', NULL),
('\nwp򡐫6C', '\nQpppS:', 'Xhosa', 'Südafrika', NULL, '[[regtime_]]', NULL),
('\nwp򡐫6C', '/_MpXT|', 'Xhosa', 'South Africa', NULL, '[[regtime_]]', NULL),
('\nwp򡐫6H', '\nQpppS:', 'Yoruba', 'Nigeria', NULL, '[[regtime_]]', NULL),
('\nwp򡐫6H', '/_MpXT|', 'Yoruba', 'Nigeria', NULL, '[[regtime_]]', NULL),
('\nwp򡐫6dU', '\nQpppS:', 'Chinesisch', 'China', NULL, '[[regtime_]]', NULL),
('\nwp򡐫6dU', '/_MpXT|', 'Chinese', 'China', NULL, '[[regtime_]]', NULL),
('\nwp򡐫6Մ+', '\nQpppS:', 'Chinesisch', 'Sonderverwaltungszone Hongkong', NULL, '[[regtime_]]', NULL),
('\nwp򡐫6Մ+', '/_MpXT|', 'Chinese', 'Hong Kong', NULL, '[[regtime_]]', NULL),
('\nwp򡐫7EG', '\nQpppS:', 'Chinesisch', 'Sonderverwaltungszone Macao', NULL, '[[regtime_]]', NULL),
('\nwp򡐫7EG', '/_MpXT|', 'Chinese', 'Macao', NULL, '[[regtime_]]', NULL),
('\nwp򡐫8&', '\nQpppS:', 'Chinesisch', 'Singapur', NULL, '[[regtime_]]', NULL),
('\nwp򡐫8&', '/_MpXT|', 'Chinese', 'Singapur', NULL, '[[regtime_]]', NULL),
('\nwp򡐫84j', '\nQpppS:', 'Chinesisch', 'Taiwan', NULL, '[[regtime_]]', NULL),
('\nwp򡐫84j', '/_MpXT|', 'Chinese', 'Taiwan', NULL, '[[regtime_]]', NULL),
('\nwp򡐫8ǀ', '\nQpppS:', 'Zulu', 'Südafrika', NULL, '[[regtime_]]', NULL),
('\nwp򡐫8ǀ', '/_MpXT|', 'Zulu', 'South Africa', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `log_entry`
--

CREATE TABLE `log_entry` (
  `id` binary(16) NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `level` smallint NOT NULL,
  `channel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` json DEFAULT NULL,
  `extra` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.log_entry.created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `mail_header_footer`
--

CREATE TABLE `mail_header_footer` (
  `id` binary(16) NOT NULL,
  `system_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_header_footer`
--

INSERT INTO `mail_header_footer` VALUES
('/qF6X|6N', 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_header_footer_translation`
--

CREATE TABLE `mail_header_footer_translation` (
  `mail_header_footer_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `header_html` longtext COLLATE utf8mb4_unicode_ci,
  `header_plain` longtext COLLATE utf8mb4_unicode_ci,
  `footer_html` longtext COLLATE utf8mb4_unicode_ci,
  `footer_plain` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`mail_header_footer_id`,`language_id`),
  KEY `fk.mail_header_footer_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_header_footer_translation`
--

INSERT INTO `mail_header_footer_translation` VALUES
('/qF6X|6N', '\nQpppS:', 'Standard-E-Mail-Fußzeile', 'Standard-E-Mail-Fußzeile basierend auf den Stammdaten', NULL, NULL, '<div style="font-family:arial; font-size:12px;">\n    Adresse:<br>\n    {{ config(''core.basicInformation.address'')|raw }}\n    <br>\n    Bankverbindung:<br>\n    {{ config(''core.basicInformation.bankAccount'')|raw }}\n</div>\n', '\n\n        Adresse:\n        {{ config(''core.basicInformation.address'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n\n        Bankverbindung:\n        {{ config(''core.basicInformation.bankAccount'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n', '[[regtime_]]', NULL),
('/qF6X|6N', '/_MpXT|', 'Default email footer', 'Default email footer derived from basic information', NULL, NULL, '<div style="font-family:arial; font-size:12px;">\n    Address:<br>\n    {{ config(''core.basicInformation.address'')|raw }}\n    <br>\n    Bank account:<br>\n    {{ config(''core.basicInformation.bankAccount'')|raw }}\n</div>\n', '\n\n        Address:\n        {{ config(''core.basicInformation.address'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n\n        Bank account:\n        {{ config(''core.basicInformation.bankAccount'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_template`
--

CREATE TABLE `mail_template` (
  `id` binary(16) NOT NULL,
  `mail_template_type_id` binary(16) DEFAULT NULL,
  `system_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.mail_template.mail_template_type_id` (`mail_template_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_template`
--

INSERT INTO `mail_template` VALUES
('[qBf', 'Vq(y5~', 1, '[[regtime_]]', NULL),
('[q{', 'Vq(y5', 1, '[[regtime_]]', NULL),
('r:^;e_', 'Vq(y5', 1, '[[regtime_]]', NULL),
('\ZpVxmx', 'Vq(y5ٷn', 1, '[[regtime_]]', NULL),
('\Zq+qo', 'Wr.z', 1, '[[regtime_]]', NULL),
('\Z+p<rڱE', 'Wr.|+', 1, '[[regtime_]]', NULL),
('\Z5s0I_', 'Wr.Ol', 1, '[[regtime_]]', NULL),
('#Qqźdww', '#8qᐙsiw#', 1, '[[regtime_]]', NULL),
('-"rB\r8{', '''rKˎ	G', 1, '[[regtime_]]', NULL),
('1<qxI', '13pT', 1, '[[regtime_]]', NULL),
('5ErLɘIL.', 'Wr.0', 1, '[[regtime_]]', NULL),
('5]pj(a', 'Wr.d,', 1, '[[regtime_]]', NULL),
('5or\\cV\\', 'Wr.', 1, '[[regtime_]]', NULL),
('5r\\', 'Wr.$w', 1, '[[regtime_]]', NULL),
('5r\Z', 'Wr.I', 1, '[[regtime_]]', NULL),
('5r', 'Wr.d4', 1, '[[regtime_]]', NULL),
('5s})6m\Z', 'Wr.X', 1, '[[regtime_]]', NULL),
('5q\nm`"Ծp', 'Wr.ii\0', 1, '[[regtime_]]', NULL),
('5rVr', 'Wr.#3', 1, '[[regtime_]]', NULL),
('5r`u', 'Wr.8', 1, '[[regtime_]]', NULL),
('5q=G2*3', 'Wr.|P', 1, '[[regtime_]]', NULL),
('5spvO', 'Wr.թ', 1, '[[regtime_]]', NULL),
('6	q^.Yr ', 'Wr.b)', 1, '[[regtime_]]', NULL),
('6sn+', 'Wr..qG', 1, '[[regtime_]]', NULL),
('6.rF6\0', 'Wr.ԭ\\', 1, '[[regtime_]]', NULL),
('6:s|Y', 'Wr.MR*', 1, '[[regtime_]]', NULL),
('9`rvw', '9`rvۛ', 1, '[[regtime_]]', NULL),
('9q؃Q+', '9q؃QRC', 1, '[[regtime_]]', NULL),
('vpeU!8', 'vsZ}801', 1, '[[regtime_]]', NULL),
('vs2W;?8', 'vqr:K', 1, '[[regtime_]]', NULL),
('q=J', 'q=J({', 1, '[[regtime_]]', NULL),
('q=JNh', 'q=J_', 1, '[[regtime_]]', NULL),
('q=J[h,', 'q=J', 1, '[[regtime_]]', NULL),
('q=J~', 'q=JW', 1, '[[regtime_]]', NULL),
('Bqz=U+x', '''q@)ru', 1, '[[regtime_]]', NULL),
('qE%-f4', 'qE%-m', 1, '[[regtime_]]', NULL),
('q	', 'rǝ5F', 1, '[[regtime_]]', NULL),
('rQX,', '\nq.9', 1, '[[regtime_]]', NULL),
('7rzhoI|', '-sn6Jb', 1, '[[regtime_]]', NULL),
('Lr}m\0*', 'LsQ}a\ZO', 1, '[[regtime_]]', NULL),
('Xr@nx/', 'XrvDNe\r', 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_template_media`
--

CREATE TABLE `mail_template_media` (
  `id` binary(16) NOT NULL,
  `mail_template_id` binary(16) NOT NULL,
  `language_id` binary(16) DEFAULT NULL,
  `media_id` binary(16) NOT NULL,
  `position` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `fk.mail_template_media.mail_template_id` (`mail_template_id`),
  KEY `fk.mail_template_media.media_id` (`media_id`),
  KEY `fk.mail_template_media.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `mail_template_translation`
--

CREATE TABLE `mail_template_translation` (
  `mail_template_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `sender_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `content_html` longtext COLLATE utf8mb4_unicode_ci,
  `content_plain` longtext COLLATE utf8mb4_unicode_ci,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`mail_template_id`,`language_id`),
  KEY `fk.mail_template_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_template_translation`
--

INSERT INTO `mail_template_translation` VALUES
('[qBf', '\nQpppS:', '{{ salesChannel.translated.name }}', 'Newsletter', '', '<h3>Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>Schön, dass Sie sich für unseren Newsletter interessieren!</p>\n                <p>Um einem Missbrauch Ihrer E-Mail-Adresse vorzubeugen, haben wir Ihnen diese Bestätigungsmail gesendet. Bestätigen Sie, dass Sie den Newsletter regelmäßig erhalten wollen, indem Sie <a href="{{ url }}">hier</a> klicken.</p>\n                <p>Sollten Sie den Newsletter nicht angefordert haben, ignorieren Sie diese E-Mail.</p>\n        ', 'Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                Schön, dass Sie sich für unseren Newsletter interessieren!\n\n                Um einem Missbrauch Ihrer E-Mail-Adresse vorzubeugen, haben wir Ihnen diese Bestätigungsmail gesendet. Bestätigen Sie, dass Sie den Newsletter regelmäßig erhalten wollen, indem Sie auf den folgenden Link klicken: {{ url }}\n\n                Sollten Sie den Newsletter nicht angefordert haben, ignorieren Sie diese E-Mail.\n        ', NULL, '[[regtime_]]', NULL),
('[qBf', '/_MpXT|', '{{ salesChannel.translated.name }}', 'Newsletter', '', '<h3>Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>Thank you for your interest in our newsletter!</p>\n                <p>In order to prevent misuse of your email address, we have sent you this confirmation email. Confirm that you wish to receive the newsletter regularly by clicking <a href="{{ url }}">here</a>.</p>\n                <p>If you have not subscribed to the newsletter, please ignore this email.</p>\n        ', 'Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                Thank you for your interest in our newsletter!\n\n                In order to prevent misuse of your email address, we have sent you this confirmation email. Confirm that you wish to receive the newsletter regularly by clicking on the link: {{ url }}\n\n                If you have not subscribed to the newsletter, please ignore this email.\n        ', NULL, '[[regtime_]]', NULL),
('[q{', '\nQpppS:', '{{ salesChannel.translated.name }}', 'Register', '', '<h3>Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>vielen Dank für Ihre Anmeldung.</p>\n                <p>Sie haben sich erfolgreich zu unserem Newsletter angemeldet.</p>\n        ', 'Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                vielen Dank für Ihre Anmeldung.\n\n                Sie haben sich erfolgreich zu unserem Newsletter angemeldet.\n        ', NULL, '[[regtime_]]', NULL),
('[q{', '/_MpXT|', '{{ salesChannel.translated.name }}', 'Register', '', '<h3>Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>thank you very much for your registration.</p>\n                <p>You have successfully subscribed to our newsletter.</p>\n        ', 'Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                thank you very much for your registration.\n\n                You have successfully subscribed to our newsletter.\n        ', NULL, '[[regtime_]]', NULL),
('r:^;e_', '\nQpppS:', '{{ salesChannel.name }}', 'Bestellbestätigung', '', '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n\n    Hallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Ihre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.<br>\n    <br>\n    Bestellnummer: {{ order.orderNumber }}<br>\n    <br>\n    Sobald ein Zahlungseingang erfolgt ist, erhalten Sie eine separate Benachrichtigung und Ihre Bestellung wird verarbeitet.<br>\n    <br>\n    Den aktuellen Status Ihrer Bestellung können Sie jederzeit über diesen Link abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n    Über diesen Link können Sie auch die Bestellung bearbeiten, die Zahlungsart wechseln oder nachträglich eine Zahlung durchführen.<br>\n    <br>\n    <strong>Informationen zu Ihrer Bestellung:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produktbild</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Bezeichnung</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" alt="" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        Gesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Gesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Gesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Gewählte Zahlungsart:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Gewählte Versandart:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Rechnungsadresse:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Lieferadresse:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Ihre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\n            Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\n            bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit. <br>\n        {% endif %}\n        <br>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIhre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.\n\nBestellnummer: {{ order.orderNumber }}\n\nSobald ein Zahlungseingang erfolgt ist, erhalten Sie eine separate Benachrichtigung und Ihre Bestellung wird verarbeitet.\n\nDen aktuellen Status Ihrer Bestellung können Sie jederzeit über diesen Link abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nÜber diesen Link können Sie auch die Bestellung bearbeiten, die Zahlungsart wechseln oder nachträglich eine Zahlung durchführen.\n\nInformationen zu Ihrer Bestellung:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nArtikel-Nr. {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nProduktbild {{ lineItem.cover.alt }},\n{% endif %}\nBeschreibung {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nMenge {{ lineItem.quantity }},\nPreis {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nSumme {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nVersandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nGesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nGewählte Zahlungsart: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nGewählte Versandart: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nRechnungsadresse:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nLieferadresse:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nIhre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n\n{% endif %}\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        deepLinkCode: a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('r:^;e_', '/_MpXT|', '{{ salesChannel.name }}', 'Order confirmation', '', '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    We have received your order from {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.<br>\n    <br>\n    Order number: {{ order.orderNumber }}<br>\n    <br>\n    As soon as your payment has been made, you will receive a separate notification and your order will be processed.<br>\n    <br>\n    You may check the current status of your order with this link: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n    You may use this link to edit your order, change the payment method or make additional payments.<br>\n    <br>\n    <strong>Information on your order:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product image</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Description</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" alt="" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                            <span style="display: inline-block;\n                                position: absolute;\n                                width: 6px;\n                                height: 20px;\n                                top: 0;\n                                border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                margin-left: {{ i * 10 }}px;"></span>\n                        </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n\n        Net total: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Total gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Rounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Selected payment type:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Selected shipping type:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Billing address:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Shipping address:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Your VAT-ID: {{ order.orderCustomer.vatIds|first }}\n            In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.<br>\n        {% endif %}\n        <br>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        If you have any questions, do not hesitate to contact us.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWe have received your order from {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.\n\nOrder number: {{ order.orderNumber }}\n\nAs soon as your payment has been made, you will receive a separate notification and your order will be processed.\n\nYou may check the current status of your order with this link: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nYou may use this link to edit your order, change the payment method or make additional payments.\n\nInformation on your order:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nProduct number {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nImage {{ lineItem.cover.alt }},\n{% endif %}\nDescription {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nQuantity {{ lineItem.quantity }},\nPrice {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nTotal {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nShipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nNet total: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nTotal gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nRounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nSelected payment type: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nSelected shipping type: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nBilling address:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nShipping address:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nYour VAT-ID: {{ order.orderCustomer.vatIds|first }}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.\n\n{% endif %}\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        ''deepLinkCode'': a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('\ZpVxmx', '\nQpppS:', '{{ salesChannel.name }}', 'Deine Registrierung bei {{ salesChannel.name }}', 'Registrierungsbestätigung', '<div style="font-family:arial; font-size:12px;">\n            <p>\n                {{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},<br/>\n                <br/>\n                vielen Dank für Ihre Anmeldung in unserem Shop.<br/>\n                Sie erhalten Zugriff über Ihre E-Mail-Adresse <strong>{{ customer.email }}</strong> und dem von Ihnen gewählten Kennwort.<br/>\n                Sie können Ihr Kennwort jederzeit nachträglich ändern.\n            </p>\n        </div>', '{{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\n                vielen Dank für Ihre Anmeldung in unserem Shop.\n                Sie erhalten Zugriff über Ihre E-Mail-Adresse {{ customer.email }} und dem von Ihnen gewählten Kennwort.\n                Sie können Ihr Kennwort jederzeit nachträglich ändern.\n', NULL, '[[regtime_]]', NULL),
('\ZpVxmx', '/_MpXT|', '{{ salesChannel.name }}', 'Your sign-up with {{ salesChannel.translated.name }}', 'Registration confirmation', '<div style="font-family:arial; font-size:12px;">\n            <p>\n                {{ customer.salutation.translated.letterName }} {{ customer.firstName }} {{ customer.lastName }},<br/>\n                <br/>\n                thank you for your signing up with our Shop.<br/>\n                You will gain access via the email address <strong>{{ customer.email }}</strong> and the password you have chosen.<br/>\n                You can change your password anytime.\n            </p>\n        </div>', '{{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\n                thank you for your signing up with our Shop.\n                You will gain access via the email address {{ customer.email }} and the password you have chosen.\n                You can change your password anytime.\n        ', NULL, '[[regtime_]]', NULL),
('\Zq+qo', '\nQpppS:', '{{ salesChannel.name }}', 'Password zurücksetzen - {{ salesChannel.name }}', 'Anfrage zum Zurücksetzen des Passworts', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},<br/>\n        <br/>\n        im Shop {{ salesChannel.translated.name }} wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\n        Bitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Passwort zurücksetzen</a><br/>\n        <br/>\n        Dieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.\n    </p>\n</div>', 'Hallo {{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\nim Shop {{ salesChannel.translated.name }} wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\nBitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.\n\nPasswort zurücksetzen: {{ resetUrl }}\n\nDieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\nFalls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.', NULL, '[[regtime_]]', NULL),
('\Zq+qo', '/_MpXT|', '{{ salesChannel.name }}', 'Password reset - {{ salesChannel.name }}', 'Password reset request', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.firstName }} {{ customer.lastName }},<br/>\n        <br/>\n        there has been a request to reset you Password in the Shop {{ salesChannel.translated.name }}\n        Please confirm the link below to specify a new password.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Reset password</a><br/>\n        <br/>\n        This link is valid for the next 2 hours. After that you have to request a new confirmation link.<br/>\n        If you do not want to reset your password, please ignore this email. No changes will be made.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\nthere has been a request to reset you Password in the Shop {{ salesChannel.translated.name }}\nPlease confirm the link below to specify a new password.\n\nReset password: {{ resetUrl }}\n\nThis link is valid for the next 2 hours. After that you have to request a new confirmation link.\nIf you do not want to reset your password, please ignore this email. No changes will be made.', NULL, '[[regtime_]]', NULL),
('\Z+p<rڱE', '\nQpppS:', '{{ salesChannel.name }}', 'Ihr Händleraccount wurde freigeschaltet - {{ salesChannel.name }}', 'Kundengruppenwechsel freigeschaltet', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo,<br/>\n        <br/>\n        ihr Händlerkonto bei {{ salesChannel.translated.name }} wurde freigeschaltet.<br/>\n        Von nun an werden wir Ihnen den Netto-Preis berechnen.\n    </p>\n</div>\n', 'Hallo,\n\nihr Händlerkonto bei {{ salesChannel.translated.name }} wurde freigeschaltet.\nVon nun an werden wir Ihnen den Netto-Preis berechnen.\n', NULL, '[[regtime_]]', NULL),
('\Z+p<rڱE', '/_MpXT|', '{{ salesChannel.name }}', 'Your merchant account has been unlocked - {{ salesChannel.name }}', 'Customer Group Change accepted', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello,<br/>\n        <br/>\n        your merchant account at {{ salesChannel.translated.name }} has been unlocked.<br/>\n        From now on, we will charge you the net purchase price.\n    </p>\n</div>\n', 'Hello,\n\nyour merchant account at {{ salesChannel.translated.name }} has been unlocked.\nFrom now on, we will charge you the net purchase price.\n', NULL, '[[regtime_]]', NULL),
('\Z5s0I_', '\nQpppS:', '{{ salesChannel.name }}', 'Ihr Händleraccountantrag wurde abgelehnt - {{ salesChannel.name }}', 'Kundengruppenwechsel abgelehnt', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo,<br/>\n        <br/>\n        vielen Dank für ihr Interesse an unseren Großhandelspreisen. Leider liegt uns bisher keine <br/>\n        Händlerauthentifizierung vor, und daher können wir Ihre Anfrage nicht bestätigen. <br/>\n        Bei weiteren Fragen kontaktieren Sie uns gerne per Telefon, Fax oder E-Mail. <br/>\n    </p>\n</div>\n', 'Hallo,\n\nvielen Dank für ihr Interesse an unseren Großhandelspreisen. Leider liegt uns bisher keine\nHändlerauthentifizierung vor, und daher können wir Ihre Anfrage nicht bestätigen.\nBei weiteren Fragen kontaktieren Sie uns gerne per Telefon, Fax oder E-Mail.\n', NULL, '[[regtime_]]', NULL),
('\Z5s0I_', '/_MpXT|', '{{ salesChannel.name }}', 'Your trader account has not been accepted - {{ salesChannel.name }}', 'Customer Group Change rejected', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello,<br/>\n        <br/>\n        thank you for your interest in our trade prices.\n        Unfortunately, we do not have a trading license yet so that we cannot accept you as a merchant.<br/>\n        In case of further questions please do not hesitate to contact us via telephone, fax or email.\n    </p>\n</div>\n', 'Hello,\n\nthank you for your interest in our trade prices. Unfortunately,\nwe do not have a trading license yet so that we cannot accept you as a merchant.\nIn case of further questions please do not hesitate to contact us via telephone, fax or email.\n', NULL, '[[regtime_]]', NULL),
('#Qqźdww', '\nQpppS:', 'Shopware Administration', 'Password-Wiederherstellung', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},<br/>\n        <br/>\n        es wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\n        Bitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Passwort zurücksetzen</a><br/>\n        <br/>\n        Dieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.\n    </p>\n</div>', '        Hallo {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},\n\n        es wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\n        Bitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.\n\n        Passwort zurücksetzen: {{ resetUrl }}\n\n        Dieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.', NULL, '[[regtime_]]', NULL),
('#Qqźdww', '/_MpXT|', 'Shopware Administration', 'Password recovery', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Dear {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},<br/>\n        <br/>\n        there has been a request to reset your password.\n        Please confirm the link below to specify a new password.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Reset password</a><br/>\n        <br/>\n        This link is valid for the next 2 hours. After that you have to request a new confirmation link.<br/>\n        If you do not want to reset your password, please ignore this email. No changes will be made.\n    </p>\n</div>', '        Dear {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},\n\n        there has been a request to reset your password.\n        Please confirm the link below to specify a new password.\n\n        Reset password: {{ resetUrl }}\n\n        This link is valid for the next 2 hours. After that you have to request a new confirmation link.\n        If you do not want to reset your password, please ignore this email. No changes will be made.', NULL, '[[regtime_]]', NULL),
('-"rB\r8{', '\nQpppS:', '{{ salesChannel.name }}', 'Kontaktanfrage erhalten - {{ salesChannel.name }}', 'Kontaktanfrage erhalten', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Folgende Nachricht wurde an Sie via Kontakt-Formular gesendet.<br/>\n        <br/>\n        Name: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\n        <br/>\n        Kontakt E-Mail: {{ contactFormData.email }}<br/>\n        <br>\n        Telefonnummer: {{ contactFormData.phone }}<br/>\n        <br/>\n        Betreff: {{ contactFormData.subject }}<br/>\n        <br/>\n        Message:<br/>\n        {{ contactFormData.comment|nl2br }}<br/>\n    </p>\n</div>\n', 'Folgende Nachricht wurde an Sie via Kontakt-Formular gesendet.\n\nName: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\nKontakt E-Mail: {{ contactFormData.email }}\n\nTelefonnummer: {{ contactFormData.phone }}\n\nBetreff: {{ contactFormData.subject }}\n\nNachricht:\n{{ contactFormData.comment }}\n', NULL, '[[regtime_]]', NULL),
('-"rB\r8{', '/_MpXT|', '{{ salesChannel.name }}', 'Contact form received - {{ salesChannel.name }}', 'Contact form received', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        The following Message was sent to you via the contact form.<br/>\n        <br/>\n        Contact name: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\n        <br/>\n        Contact email address: {{ contactFormData.email }}\n        <br/>\n        Phone: {{ contactFormData.phone }}<br/>\n        <br/>\n        Subject: {{ contactFormData.subject }}<br/>\n        <br/>\n        Message:<br/>\n        {{ contactFormData.comment|nl2br }}<br/>\n    </p>\n</div>\n', 'The following Message was sent to you via the contact form.\n\nContact name: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\nContact email address: {{ contactFormData.email }}\nPhone: {{ contactFormData.phone }}\n\nSubject: {{ contactFormData.subject }}\n\nMessage:\n{{ contactFormData.comment }}\n', NULL, '[[regtime_]]', NULL),
('1<qxI', '\nQpppS:', '{{ shopName }}', 'Password-Wiederherstellung', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},<br/>\n        <br/>\n        Sie haben ein neues Passwort für Ihren {{ shopName }}-Account angefordert.\n        Klicken Sie auf folgenden Link, um Ihr Passwort zurückzusetzen:<br/>\n        <br/>\n        <a href="{{ resetUrl }}">{{ resetUrl }}</a><br/>\n        <br/>\n        Dieser Link ist für die nächsten 2 Stunden gültig.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.<br/>\n        <br/>\n        Mit freundlichen Grüßen\n        Ihr {{ shopName }}-Team\n    </p>\n</div>', '        Hallo {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},\n\n        Sie haben ein neues Passwort für Ihren {{ shopName }}-Account angefordert.\n        Klicken Sie auf folgenden Link, um Ihr Passwort zurückzusetzen:\n\n        {{ resetUrl }}\n\n        Dieser Link ist für die nächsten 2 Stunden gültig.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.\n\n        Mit freundlichen Grüßen\n        Ihr {{ shopName }}-Team', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('1<qxI', '/_MpXT|', '{{ shopName }}', 'Password recovery', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},<br/>\n        <br/>\n        You have requested a new password for your {{ shopName }} account.\n        Click on the following link to reset your password:<br/>\n        <br/>\n        <a href="{{ resetUrl }}">{{ resetUrl }}</a><br/>\n        <br/>\n        This link is valid for the next 2 hours.\n        If you don''t want to reset your password, ignore this email and no changes will be made.<br/>\n        <br/>\n        Yours sincerely\n        Your {{ shopName }} team\n    </p>\n</div>', '        Hello {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},\n\n        You have requested a new password for your {{ shopName }} account.\n        Click on the following link to reset your password:\n\n        {{ resetUrl }}\n\n        This link is valid for the next 2 hours.\n        If you don''t want to reset your password, ignore this email and no changes will be made.\n\n        Yours sincerely\n        Your {{ shopName }}-Team', NULL, '[[regtime_]]', NULL),
('5ErLɘIL.', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5ErLɘIL.', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5]pj(a', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5]pj(a', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5or\\cV\\', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5or\\cV\\', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5r\\', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5r\\', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5r\Z', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5r\Z', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5r', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5r', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('5s})6m\Z', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5s})6m\Z', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n    <br/>\n    the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n    <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n    <br/>\n    You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n    </br>\n    However, in case you have purchased without a registration or a customer account, you do not have this option.\n    <br><br>\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your email address and postal code of the billing address.<br>\n    {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5q\nm`"Ծp', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5q\nm`"Ծp', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5rVr', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5rVr', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5r`u', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5r`u', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5q=G2*3', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5q=G2*3', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5spvO', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('5spvO', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('6	q^.Yr ', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    Hallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Wir haben Ihre Zahlung erhalten und werden die Bestellung nun weiter verarbeiten.<br>\n    <br>\n    Bestellnummer: {{ order.orderNumber }}<br>\n    <br>\n    <strong>Informationen zu Ihrer Bestellung:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produktbild</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Bezeichnung</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" alt="" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        Gesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Gesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Gesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Gewählte Zahlungsart:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Gewählte Versandart:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Rechnungsadresse:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Lieferadresse:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Ihre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\n            Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\n            bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit. <br>\n        {% endif %}\n        <br>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWir haben Ihre Zahlung erhalten und werden die Bestellung nun weiter verarbeiten.\n\nBestellnummer: {{ order.orderNumber }}\n\nInformationen zu Ihrer Bestellung:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nArtikel-Nr. {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nProduktbild {{ lineItem.cover.alt }},\n{% endif %}\nBeschreibung {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nMenge {{ lineItem.quantity }},\nPreis {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nSumme {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nVersandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nGesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nGewählte Zahlungsart: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nGewählte Versandart: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nRechnungsadresse:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nLieferadresse:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nIhre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n\n{% endif %}\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        deepLinkCode: a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('6	q^.Yr ', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    We received your payment and will now start processing the order.<br>\n    Order number: {{ order.orderNumber }}<br>\n    <br>\n\n    <strong>Information on your order:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product image</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Description</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" alt="" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                            <span style="display: inline-block;\n                                position: absolute;\n                                width: 6px;\n                                height: 20px;\n                                top: 0;\n                                border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                margin-left: {{ i * 10 }}px;"></span>\n                        </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n\n        Net total: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Total gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Rounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Selected payment type:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Selected shipping type:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Billing address:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Shipping address:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Your VAT-ID: {{ order.orderCustomer.vatIds|first }}\n            In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.<br>\n        {% endif %}\n        <br>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        If you have any questions, do not hesitate to contact us.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWe received your payment and will now start processing the order.\n\nOrder number: {{ order.orderNumber }}\n\n\nInformation on your order:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nProduct number {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nImage {{ lineItem.cover.alt }},\n{% endif %}\nDescription {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nQuantity {{ lineItem.quantity }},\nPrice {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nTotal {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nShipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nNet total: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nTotal gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nRounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nSelected payment type: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nSelected shipping type: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nBilling address:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nShipping address:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nYour VAT-ID: {{ order.orderCustomer.vatIds|first }}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.\n\n{% endif %}\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        ''deepLinkCode'': a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('6sn+', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    Hallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Ihre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.<br>\n    <br>\n    Bestellnummer: {{ order.orderNumber }}\n    <br>\n    Der Zahlungsprozess mit {{ order.transactions.first.paymentMethod.translated.name }} ist noch nicht abgeschlossen. Sie können den Zahlungsprozess über die folgende URL wieder aufnehmen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n    <br>\n    <strong>Informationen zu Ihrer Bestellung:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produktbild</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Bezeichnung</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" alt="" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        Gesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Gesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Gesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Gewählte Zahlungsart:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Gewählte Versandart:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Rechnungsadresse:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Lieferadresse:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Ihre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\n            Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\n            bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit. <br>\n        {% endif %}\n        <br>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIhre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.\n\nBestellnummer: {{ order.orderNumber }}\n\nDer Zahlungsprozess mit {{ order.transactions.first.paymentMethod.translated.name }} ist noch nicht abgeschlossen. Sie können den Zahlungsprozess über die folgende URL wieder aufnehmen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n\nInformationen zu Ihrer Bestellung:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nArtikel-Nr. {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nProduktbild {{ lineItem.cover.alt }},\n{% endif %}\nBeschreibung {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nMenge {{ lineItem.quantity }},\nPreis {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nSumme {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nVersandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nGesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nGewählte Zahlungsart: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nGewählte Versandart: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nRechnungsadresse:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nLieferadresse:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nIhre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n\n{% endif %}\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        deepLinkCode: a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('6sn+', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    We have received your order on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.<br>\n    <br>\n    Order number: {{ order.orderNumber }}.<br>\n    <br>\n    You have not completed your payment with {{ order.transactions.first.paymentMethod.translated.name }} yet. You can resume the payment process by using the following URL: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n    <br>\n    <strong>Information on your order:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product image</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Description</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" alt="" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                            <span style="display: inline-block;\n                                position: absolute;\n                                width: 6px;\n                                height: 20px;\n                                top: 0;\n                                border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                margin-left: {{ i * 10 }}px;"></span>\n                        </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n\n        Net total: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Total gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Rounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Selected payment type:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Selected shipping type:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Billing address:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Shipping address:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Your VAT-ID: {{ order.orderCustomer.vatIds|first }}\n            In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.<br>\n        {% endif %}\n        <br>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        If you have any questions, do not hesitate to contact us.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWe have received your order on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.\n\nOrder number: {{ order.orderNumber }}.\n\nYou have not completed your payment with {{ order.transactions.first.paymentMethod.translated.name }} yet. You can resume the payment process by using the following URL: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n\nInformation on your order:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nProduct number {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nImage {{ lineItem.cover.alt }},\n{% endif %}\nDescription {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nQuantity {{ lineItem.quantity }},\nPrice {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nTotal {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nShipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nNet total: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nTotal gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nRounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nSelected payment type: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nSelected shipping type: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nBilling address:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nShipping address:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nYour VAT-ID: {{ order.orderCustomer.vatIds|first }}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.\n\n{% endif %}\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        ''deepLinkCode'': a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('6.rF6\0', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('6.rF6\0', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('6:s|Y', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('6:s|Y', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('9`rvw', '\nQpppS:', '{{ salesChannel.translated.name }}', 'Bitte bestätigen Sie Ihre Anmeldung bei {{ salesChannel.translated.name }}', 'Anmeldebestätigung', '\n            <div style="font-family:arial; font-size:12px;">\n                <p>\n                    Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n                    <br/>\n                    vielen Dank für Ihre Anmeldung bei {{ salesChannel.translated.name }}.<br/>\n                    Bitte bestätigen Sie die Registrierung über den nachfolgenden Link:<br/>\n                    <br/>\n                    <a href="{{ confirmUrl }}">Anmeldung abschließen</a><br/>\n                    <br/>\n                    Durch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n                </p>\n            </div>\n        ', '\n            Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\n            vielen Dank für Ihre Anmeldung bei {{ salesChannel.translated.name }}.\n            Bitte bestätigen Sie die Registrierung über den nachfolgenden Link:\n\n            {{ confirmUrl }}\n\n            Durch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n        ', NULL, '[[regtime_]]', NULL),
('9`rvw', '/_MpXT|', '{{ salesChannel.translated.name }}', 'Please confirm your sign-up with {{ salesChannel.translated.name }}', 'Registration confirmation', '\n            <div style="font-family:arial; font-size:12px;">\n                <p>\n                    Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n                    <br/>\n                    thank you for your signing up with {{ salesChannel.translated.name }}.<br/>\n                    Please confirm the sign-up via the following link:<br/>\n                    <br/>\n                    <a href="{{ confirmUrl }}">Completing sign-up</a><br/>\n                    <br/>\n                    By this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n                </p>\n            </div>\n        ', '\n            Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\n            thank you for your signing up with {{ salesChannel.translated.name }}.\n            Please confirm the sign-up via the following link:\n\n            {{ confirmUrl }}\n\n            By this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n        ', NULL, '[[regtime_]]', NULL),
('9q؃Q+', '\nQpppS:', '{{ salesChannel.name }}', 'Bitte bestätigen Sie Ihre E-Mail-Adresse bei {{ salesChannel.name }}', 'Anmeldebestätigung bei Gastbestellungen', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n        <br/>\n        Bitte bestätigen Sie Ihre E-Mail-Adresse über den nachfolgenden Link:<br/>\n        <br/>\n        <a href="{{ confirmUrl }}">E-Mail bestätigen</a><br/>\n        <br/>\n        Nach der Bestätigung werden Sie in den Bestellabschluss geleitet, dort können Sie Ihre Bestellung nochmals überprüfen und abschließen.<br/>\n        Durch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n    </p>\n</div>\n', 'Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\nBitte bestätigen Sie Ihre E-Mail-Adresse über den nachfolgenden Link:\n\n{{ confirmUrl }}\n\nNach der Bestätigung werden Sie in den Bestellabschluss geleitet, dort können Sie Ihre Bestellung nochmals überprüfen und abschließen.\nDurch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n', NULL, '[[regtime_]]', NULL),
('9q؃Q+', '/_MpXT|', '{{ salesChannel.name }}', 'Please confirm your email address at {{ salesChannel.name }}', 'Email confirmation at guest orders', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n        <br/>\n        Please confirm your email address via the following link:<br/>\n        <br/>\n        <a href="{{ confirmUrl }}">Confirm email</a><br/>\n        <br/>\n        After the confirmation, you will be directed to the checkout, where you can check and complete your order again.<br/>\n        By this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n    </p>\n</div>\n', 'Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\nPlease confirm your email address via the following link:\n\n{{ confirmUrl }}\n\nAfter the confirmation, you will be directed to the checkout, where you can check and complete your order again.\nBy this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n', NULL, '[[regtime_]]', NULL),
('vpeU!8', '\nQpppS:', 'Shop', 'Kunden Gruppen Registrierung Akzeptiert', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Ihr Account wurde für die Kundengruppe {{ customerGroup.translated.name }} freigeschaltet.<br/>\n        Ab sofort kaufen Sie zu den neuen Konditionen dieser Kundengruppe ein.<br/>\n\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{ customer.lastName }},\nIhr Account wurde für die Kundengruppe {{ customerGroup.translated.name }} freigeschaltet.\nAb sofort kaufen Sie zu den neuen Konditionen dieser Kundengruppe ein.\n\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n', NULL, '[[regtime_]]', NULL),
('vpeU!8', '/_MpXT|', 'Shop', 'Customer Group Registration Accepted', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Your account has been activated for the customer group {{ customerGroup.translated.name }}.<br/>\n        From now on you can shop at the new conditions of this customer group.<br/><br/>\n\n        Please do not hesitate to contact us at any time if you have any questions.\n    </p>\n</div>\n', 'Hello {{ customer.salutation.translated.letterName }} {{ customer.lastName }},\nYour account has been activated for the customer group {{ customerGroup.translated.name }}.\nFrom now on you can shop at the new conditions of this customer group.\n\nPlease do not hesitate to contact us at any time if you have any questions.\n', NULL, '[[regtime_]]', NULL),
('vs2W;?8', '\nQpppS:', 'Shop', 'Kunden Gruppen Registrierung Abgelehnt', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Vielen Dank für Ihr Interesse an den Konditionen für Kundengruppe {{ customerGroup.translated.name }}.<br/>\n        Leider können wir sie nicht für diese Kundengruppe freischalten.<br/>\n\n        Bei Rückfragen aller Art können Sie uns gerne telefonisch oder per Mail diesbezüglich erreichen.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{ customer.lastName }},\nVielen Dank für Ihr Interesse an den Konditionen für Kundengruppe  {{ customerGroup.translated.name }}.\nLeider können wir sie nicht für diese Kundengruppe freischalten.\n\nBei Rückfragen aller Art können Sie uns gerne telefonisch oder per Mail diesbezüglich erreichen.\n', NULL, '[[regtime_]]', NULL),
('vs2W;?8', '/_MpXT|', 'Shop', 'Customer Group Registration Declined', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Thank you for your interest in the conditions for customer group {{ customerGroup.translated.name }}.<br/>\n        Unfortunately we cannot activate your account for this customer group.<br/><br/>\n\n        If you have any questions, please feel free to contact us by phone or mail.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{ customer.lastName }},\nThank you for your interest in the conditions for customer group {{ customerGroup.translated.name }}.\nUnfortunately we cannot activate your account for this customer group.\n\nIf you have any questions, please feel free to contact us by phone or mail.\n', NULL, '[[regtime_]]', NULL),
('q=J', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie die Rechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie die Rechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('q=J', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the invoice for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your email address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the invoice for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            ''deepLinkCode'': a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('q=JNh', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie den Lieferschein für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie den Lieferschein für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('q=JNh', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the delivery note for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your email address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the delivery note for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('q=J[h,', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie die Gutschrift für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie die Gutschrift für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('q=J[h,', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the credit note for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your email address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the credit note for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('q=J~', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie die Stornorechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie die Stornorechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('q=J~', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the cancellation invoice for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your email address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the cancellation invoice for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Bqz=U+x', '\nQpppS:', '{{ salesChannel.name }}', 'Ihre Dateien von {{ salesChannel.name }} stehen bereit', 'Shopware Default Template', '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Mit dieser E-Mail erhalten Sie die Dateien zu der Bestellung: {{ order.orderNumber }}.\n    <br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Downloads</strong></td>\n        </tr>\n\n        {% for lineItem in order.lineItems %}\n            {% if lineItem.downloads is defined and lineItem.downloads|length %}\n                {% block lineItem %}\n                    <tr>\n                        <td>{% if lineItem.payload.productNumber is defined %}{{ lineItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                        <td>{{ lineItem.label|u.wordwrap(80) }}</td>\n                        <td>\n                            {% for download in lineItem.downloads %}\n                                {% if download.accessGranted %}\n                                    {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}\n                                    <a href="{{ downloadLink }}" target="_blank">\n                                        {{ download.media.fileName }}.{{ download.media.fileExtension }}\n                                    </a><br>\n                                {% endif %}\n                            {% endfor %}\n                        </td>\n                    </tr>\n                {% endblock %}\n            {% endif %}\n        {% endfor %}\n    </table>\n\n    <br>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nMit dieser E-Mail erhalten Sie die Dateien zu der Bestellung: {{ order.orderNumber }}.\n\n{% for lineItem in order.lineItems %}{% if lineItem.downloads is defined and lineItem.downloads|length %}\n{{ lineItem.label|u.wordwrap(80) }} {% if lineItem.payload.productNumber is defined %}({{ lineItem.payload.productNumber|u.wordwrap(80) }}){% endif %}\n\n-------------------------------------\n{% for download in lineItem.downloads %}{% if download.accessGranted %}\n{{ download.media.fileName }}.{{ download.media.fileExtension }} - {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}{{ downloadLink }}\n{% endif %}{% endfor %}\n\n{% endif %}{% endfor %}\n', NULL, '[[regtime_]]', NULL),
('Bqz=U+x', '/_MpXT|', '{{ salesChannel.name }}', 'Your downloads from {{ salesChannel.name }} are ready', 'Shopware Default Template', '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the files to the order: {{ order.orderNumber }}\n    <br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Downloads</strong></td>\n        </tr>\n\n        {% for lineItem in order.lineItems %}\n            {% if lineItem.downloads is defined and lineItem.downloads|length %}\n                {% block lineItem %}\n                    <tr>\n                        <td>{% if lineItem.payload.productNumber is defined %}{{ lineItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                        <td>{{ lineItem.label|u.wordwrap(80) }}</td>\n                        <td>\n                            {% for download in lineItem.downloads %}\n                                {% if download.accessGranted %}\n                                    {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}\n                                    <a href="{{ downloadLink }}" target="_blank">\n                                        {{ download.media.fileName }}.{{ download.media.fileExtension }}\n                                    </a><br>\n                                {% endif %}\n                            {% endfor %}\n                        </td>\n                    </tr>\n                {% endblock %}\n            {% endif %}\n        {% endfor %}\n    </table>\n\n    <br>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the files to the order: {{ order.orderNumber }}\n\n{% for lineItem in order.lineItems %}{% if lineItem.downloads is defined and lineItem.downloads|length %}\n{{ lineItem.label|u.wordwrap(80) }} {% if lineItem.payload.productNumber is defined %}({{ lineItem.payload.productNumber|u.wordwrap(80) }}){% endif %}\n\n-------------------------------------\n{% for download in lineItem.downloads %}{% if download.accessGranted %}\n{{ download.media.fileName }}.{{ download.media.fileExtension }} - {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}{{ downloadLink }}\n{% endif %}{% endfor %}\n\n{% endif %}{% endfor %}\n', NULL, '[[regtime_]]', NULL),
('qE%-f4', '\nQpppS:', '{{ salesChannel.name }}', 'Neue Produktbewertung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Eine Produktbewertung wurde soeben {% if reviewFormData.id is defined %}bearbeitet{% else %}abgegeben{% endif %}.<br/>\n        <br/>\n        {% if reviewFormData.name is defined %}\n            Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}\n            <br/>\n        {% endif %}\n        {% if reviewFormData.email is defined %}\n            E-Mail-Adresse: {{ reviewFormData.email }}<br/>\n            <br>\n        {% endif %}\n        {% if product.translated.name is defined %}\n            Produkt: {{ product.translated.name }}<br/>\n            <br>\n        {% endif %}\n        Bewertung: {{ reviewFormData.points }}<br/>\n        <br/>\n        Titel: {{ reviewFormData.title }}<br/>\n        <br/>\n        Inhalt:<br/>\n        {{ reviewFormData.content|nl2br }}<br/>\n    </p>\n</div>\n', 'Eine Produktbewertung wurde soeben {% if reviewFormData.id is defined %}bearbeitet{% else %}abgegeben{% endif %}.\n\n{% if reviewFormData.name is defined %}Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}{% endif %}\n\n{% if reviewFormData.email is defined %}E-Mail-Adresse: {{ reviewFormData.email }}{% endif %}\n\n{% if product.translated.name is defined %}Produkt: {{ product.translated.name }}{% endif %}\n\nBewertung: {{ reviewFormData.points }}\n\nTitel: {{ reviewFormData.title }}\n\nInhalt:\n{{ reviewFormData.content }}\n', NULL, '[[regtime_]]', NULL),
('qE%-f4', '/_MpXT|', '{{ salesChannel.name }}', 'New product review', NULL, '<div style="font-family:arial; font-size:12px;">\n    <p>\n        A product review has just been {% if reviewFormData.id is defined %}edited{% else %}sent{% endif %}.<br/>\n        <br/>\n        {% if reviewFormData.name is defined %}\n            Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}\n            <br/>\n        {% endif %}\n        {% if reviewFormData.email is defined %}\n            Email address: {{ reviewFormData.email }}<br/>\n            <br>\n        {% endif %}\n        {% if product.translated.name is defined %}\n            Product: {{ product.translated.name }}<br/>\n            <br>\n        {% endif %}\n        Rating: {{ reviewFormData.points }}<br/>\n        <br/>\n        Title: {{ reviewFormData.title }}<br/>\n        <br/>\n        Content:<br/>\n        {{ reviewFormData.content|nl2br }}<br/>\n    </p>\n</div>\n', 'A product review has just been {% if reviewFormData.id is defined %}edited{% else %}sent{% endif %}.\n\n{% if reviewFormData.name is defined %}Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}{% endif %}\n\n{% if reviewFormData.email is defined %}Email address: {{ reviewFormData.email }}{% endif %}\n\n{% if product.translated.name is defined %}Product: {{ product.translated.name }}{% endif %}\n\nRating: {{ reviewFormData.points }}\n\nTitle: {{ reviewFormData.title }}\n\nContent:\n{{ reviewFormData.content }}\n', NULL, '[[regtime_]]', NULL),
('q	', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('q	', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('rQX,', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('rQX,', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('7rzhoI|', '\nQpppS:', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('7rzhoI|', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('Lr}m\0*', '\nQpppS:', 'Admin', '{{ nameOfInviter }} hat dich eingeladen, {{ storeName }} beizutreten', 'Shopware Sso Admin Einladung', '<html lang="de">\n<head>\n    <title>Einladung</title>\n</head>\n<body style="font-family: Inter, Arial, Helvetica, sans-serif; font-weight: 500; line-height: 1.5;">\n<div style="width: 400px; padding: 50px;">\n    <div style="padding-bottom: 25px">\n        <svg width="186" height="40" viewBox="0 0 186 40" fill="none" xmlns="http://www.w3.org/2000/svg">\n            <path d="M54.5636 20.1837C52.8632 19.4458 51.4643 18.777 51.4643 17.6684C51.4643 16.8906 52.3436 16.1528 53.826 16.1528C55.1559 16.1528 56.304 16.4872 57.4849 17.0033C57.8192 17.1523 58.3351 17.1886 58.5931 16.6689L59.1854 15.484C59.407 15.0405 59.2217 14.5208 58.8148 14.2264C57.9645 13.6703 56.1914 12.9688 53.8224 12.9688C49.6803 12.9688 47.9871 15.484 47.9871 17.6284C47.9871 20.4381 50.1635 21.8447 52.7869 23.0296C55.1522 24.1019 56.4457 24.8397 56.4457 25.9883C56.4457 26.9515 55.6319 27.653 54.1894 27.653C52.1546 27.653 50.9374 26.9515 49.9382 26.3954C49.495 26.1373 49.0153 26.2463 48.83 26.6171L48.0525 28.2091C47.8672 28.5798 48.0888 28.9106 48.3468 29.096C49.3097 29.7611 51.2681 30.8334 53.9677 30.8334C57.7756 30.8334 60.0683 28.5035 60.0683 25.8393C60.0719 22.6625 57.7065 21.5176 54.5636 20.1837Z" fill="#189EFF"/>\n            <path d="M31.8908 35.6202C30.154 34.3117 27.5924 33.3158 24.8819 32.2653C21.6554 31.015 17.9965 29.5938 15.2496 27.4094C12.1394 24.9305 10.6242 21.8046 10.6242 17.8537C10.6242 14.3062 12.0958 11.2749 14.879 9.08314C18.0001 6.62608 22.7309 5.32485 28.5553 5.32485C30.1649 5.32485 31.7019 5.42299 33.1262 5.61926C33.2533 5.63744 33.3733 5.56838 33.4241 5.4557C33.4786 5.33939 33.4496 5.20491 33.3551 5.12131C29.6853 1.81736 24.94 0 19.9985 0C14.6573 0 9.63591 2.07905 5.85712 5.85915C2.08197 9.63562 0 14.6588 0 19.9982C0 25.3412 2.07833 30.3644 5.85712 34.1408C9.63228 37.9173 14.6537 40 19.9985 40C24.3151 40 28.4245 38.6443 31.8872 36.0818C31.9598 36.0273 32.0034 35.9437 32.0034 35.8528C32.0034 35.7619 31.9635 35.6747 31.8908 35.6202Z" fill="#189EFF"/>\n            <path d="M39.9062 18.1512C39.8989 18.0749 39.8626 18.0022 39.8044 17.9549C35.6332 14.4911 32.2578 13.0771 28.1556 13.0771C25.9683 13.0771 24.2896 13.5169 23.1705 14.382C22.2004 15.1308 21.688 16.1776 21.688 17.4025C21.688 20.8373 25.8847 22.4038 30.7462 24.2175C33.2497 25.1517 35.8403 26.1185 38.2166 27.4379C38.2602 27.4633 38.3075 27.4742 38.3547 27.4742C38.3874 27.4742 38.4201 27.467 38.4528 27.4561C38.5291 27.427 38.5945 27.3688 38.6236 27.2889C39.5319 24.9627 39.9934 22.5092 39.9934 19.9976C39.9897 19.4088 39.9643 18.7873 39.9062 18.1512Z" fill="#189EFF"/>\n            <path d="M154.829 30.626C155.341 30.5679 155.693 30.1935 155.693 29.7283V21.0522C155.693 16.6142 155.152 13.1758 149.44 13.1758C146.159 13.1758 143.612 14.0627 143.303 14.179C142.878 14.3316 142.609 14.6042 142.726 15.2221L143.074 16.6905C143.191 17.1921 143.536 17.5411 144.077 17.4248C145.004 17.1558 147.009 16.5742 149.055 16.5742C151.293 16.5742 151.987 17.85 151.911 20.6669C151.911 20.6669 150.174 20.1253 148.321 20.1253C143.728 20.1253 141.181 22.597 141.181 25.8791C141.181 29.5865 143.532 30.8405 146.89 30.8405C149.629 30.8405 152.449 30.8078 153.622 30.7314L154.829 30.626ZM151.871 27.4784C151.33 28.3652 149.4 28.1435 147.743 28.1108C145.89 28.0708 144.964 27.4239 144.964 25.8391C144.964 23.9854 146.544 22.9059 148.63 22.9059C150.25 22.9059 151.642 23.3711 151.871 23.5238V27.4784Z" fill="#189EFF"/>\n            <path d="M183.969 12.9719C185.092 12.9719 186 12.0669 186 10.9474C186 9.82789 185.092 8.92285 183.969 8.92285C182.846 8.92285 181.938 9.82789 181.938 10.9474C181.938 12.0669 182.846 12.9719 183.969 12.9719ZM183.969 9.2209C184.91 9.2209 185.68 9.99873 185.68 10.9474C185.68 11.896 184.914 12.6739 183.969 12.6739C183.028 12.6739 182.261 11.896 182.261 10.9474C182.261 9.99873 183.028 9.2209 183.969 9.2209Z" fill="#189EFF"/>\n            <path d="M183.279 11.9731H183.468C183.497 11.9731 183.522 11.9477 183.522 11.9186V11.1735H183.965L184.347 11.9368C184.358 11.9622 184.376 11.9731 184.409 11.9731H184.627C184.677 11.9731 184.696 11.9258 184.677 11.8895L184.278 11.1444C184.532 11.0426 184.71 10.8209 184.71 10.5519C184.71 10.203 184.423 9.92676 184.074 9.92676H183.279C183.246 9.92676 183.224 9.9522 183.224 9.98128V11.9186C183.224 11.9477 183.246 11.9731 183.279 11.9731ZM183.529 10.2103H184.049C184.238 10.2103 184.405 10.3666 184.405 10.5592C184.405 10.7627 184.238 10.9227 184.049 10.9227H183.529V10.2103Z" fill="#189EFF"/>\n            <path d="M71.4301 12.9727C68.7304 12.9727 66.881 14.452 66.4777 14.7501V7.12082C66.4777 6.71373 66.0707 6.30664 65.6638 6.30664H63.5927C63.1494 6.30664 62.7788 6.71373 62.7788 7.12082V30.0231C62.7788 30.4666 63.1494 30.8373 63.5927 30.8373H65.6274C66.147 30.8373 66.4777 30.5029 66.4777 30.0231V18.9663C66.8483 18.2285 68.3271 16.4875 70.9504 16.4875C73.1705 16.4875 74.3514 18.1522 74.3514 20.9618V30.0268C74.3514 30.4702 74.722 30.8409 75.1653 30.8409H77.2363C77.6433 30.8409 78.0502 30.4702 78.0502 30.0268V21.0381C78.0466 16.3784 76.2735 12.9727 71.4301 12.9727Z" fill="#189EFF"/>\n            <path d="M114.73 21.2162C114.526 15.4115 112.096 12.9727 106.496 12.9727C103.808 12.9727 100.599 13.7796 100.127 13.9867C99.5457 14.2375 99.1169 14.5356 99.1169 14.9427V15.2807V16.5201V20.5329V21.0781V36.6892C99.1169 37.1326 99.4876 37.5033 99.9308 37.5033H101.646C102.202 37.5033 102.532 37.1689 102.532 36.6892L102.529 30.5429C103.048 30.6773 105.704 30.9027 107.921 30.8336C111.874 30.71 114.526 27.8386 114.748 22.9899C114.781 22.332 114.73 21.2162 114.73 21.2162ZM111.158 22.9863C111.082 26.2757 110.126 27.7296 107.358 27.8822C105.988 27.9586 102.754 27.5769 102.754 27.5769C102.62 27.5333 102.529 27.4752 102.529 27.3516L102.525 20.6855V16.9054C102.525 16.8036 102.601 16.72 102.703 16.7091C103.085 16.6692 104.484 16.2185 106.496 16.2185C109.868 16.2185 111.056 16.7128 111.165 20.9836C111.173 21.5469 111.176 22.3357 111.158 22.9863Z" fill="#189EFF"/>\n            <path d="M139.223 13.3434H137.672C137.228 13.3434 136.6 13.3434 136.378 13.8632L133.642 23.6987H133.569L128.984 13.3797C128.911 13.158 128.65 12.9727 128.246 12.9727H127.988C127.654 12.9727 127.396 13.158 127.287 13.3797L122.662 23.6623H122.589L119.78 13.8632C119.708 13.5288 119.337 13.3434 119.043 13.3434H116.823C116.231 13.3434 115.973 13.7868 116.231 14.3066L121.223 30.3938C121.296 30.6519 121.557 30.8373 121.924 30.8373H122.146C122.516 30.8373 122.738 30.6519 122.811 30.4302L128.061 18.8173H128.134L133.348 30.4302C133.46 30.6519 133.718 30.8373 134.085 30.8373H134.234C134.605 30.8373 134.936 30.6519 135.012 30.3938L139.892 14.3066C140.15 13.7868 139.815 13.3434 139.223 13.3434Z" fill="#189EFF"/>\n            <path d="M166.496 13.1758C166.405 13.1758 166.321 13.1831 166.23 13.1867C166.081 13.1831 165.936 13.1758 165.78 13.1758C164.893 13.1758 164.043 13.2049 163.247 13.2448C161.714 13.3066 160.806 13.4229 160.159 13.4956C160.159 13.4956 159.745 13.5356 159.261 13.5974C158.938 13.6374 158.702 13.7719 158.557 13.9572C158.458 14.0626 158.397 14.1971 158.397 14.3607V14.4189V14.7569V15.9963V19.4348V30.019C158.397 30.4625 158.767 30.8332 159.211 30.8332H160.911C161.612 30.8332 162.096 30.7605 162.096 30.019V19.4348V17.0068C162.096 16.905 162.255 16.7778 162.343 16.7233C162.76 16.4725 163.763 16.2907 165.78 16.2907C165.976 16.2907 166.103 16.2944 166.249 16.298C166.71 16.3416 167.44 16.4834 167.677 16.6179C168.047 16.8032 168.49 16.6905 168.712 16.2108L169.599 14.7605C170.155 13.6192 168.123 13.1758 166.496 13.1758Z" fill="#189EFF"/>\n            <path d="M178.199 12.9727C173.061 12.9727 169.697 17.0799 169.697 21.885C169.697 26.7664 173.061 30.8336 178.235 30.8336C181.08 30.8336 183.337 29.7977 184.557 28.7255C185.073 28.2821 184.928 27.9477 184.63 27.5806L183.631 26.0285C183.337 25.5851 183.002 25.6941 182.632 25.9558C181.596 26.6937 180.412 27.3988 178.453 27.3988C175.459 27.3988 173.388 25.0326 173.352 22.7391H185.146C185.517 22.7391 185.884 22.4411 185.924 21.9976C185.96 21.7032 185.996 21.1108 185.996 20.8127C185.996 16.2657 182.635 12.9727 178.199 12.9727ZM173.541 19.9986C173.799 17.8541 175.427 16.1167 178.126 16.1167C180.641 16.1167 182.268 17.9304 182.341 19.9986H173.541V19.9986Z" fill="#189EFF"/>\n            <path d="M96.1556 18.2573C95.7704 17.1559 95.229 16.2109 94.5351 15.4258C93.8411 14.6407 93.009 14.0337 92.0461 13.6085C91.0833 13.1832 89.7171 12.9688 88.5835 12.9688C87.4498 12.9688 86.0873 13.1832 85.1244 13.6085C84.1615 14.0337 83.3331 14.6407 82.6355 15.4258C81.9415 16.2109 81.4001 17.1559 81.015 18.2573C80.6298 19.3586 80.4373 20.5762 80.4373 21.9065C80.4373 23.2586 80.6298 24.4799 81.015 25.5703C81.4001 26.6607 81.9415 27.5985 82.6355 28.3836C83.3295 29.1687 84.1615 29.7757 85.1244 30.2009C86.0873 30.6262 87.4498 30.837 88.5835 30.837C89.7171 30.837 91.0833 30.6262 92.0461 30.2009C93.009 29.7757 93.8374 29.1687 94.5351 28.3836C95.229 27.5985 95.7704 26.6607 96.1556 25.5703C96.5407 24.4799 96.7333 23.2586 96.7333 21.9065C96.7333 20.5762 96.5407 19.3586 96.1556 18.2573ZM88.489 27.8929C85.4042 27.8929 83.8491 25.2795 83.8491 22.0555C83.8491 18.8315 85.4005 16.2182 88.489 16.2182C91.5774 16.2182 93.1289 18.8315 93.1289 22.0555C93.1289 25.2795 91.5738 27.8929 88.489 27.8929Z" fill="#189EFF"/>\n        </svg>\n    </div>\n    <div>\n        <p><span style="font-weight: bold">{{ nameOfInviter }}</span> hat Dich eingeladen, am Shopware-Store <span style="font-weight: bold">{{ storeName }}</span> mitzuarbeiten.</p>\n        <p>Um Zugriff auf den Shop zu erhalten, logge Dich bitte entweder ein oder registriere Dich mit der E-Mail-Adresse <span style="font-weight: bold">{{ invitedEmailAddress }}</span>.</p>\n    </div>\n    <div style="padding-top: 25px;">\n        <a href="{{ signupUrl }}" style="border: 1px solid; border-radius: 5px; background: #0870FF; color: #fff; padding:10px 15px; text-decoration: none; font-size: 0.9em; font-weight:bold;">Loslegen</a>\n    </div>\n</div>\n</body>\n</html>\n', '{{ nameOfInviter }} hat Dich eingeladen, am Shopware-Store {{ storeName }} mitzuarbeiten.\n\nUm Zugriff auf den Shop zu erhalten, logge Dich bitte entweder ein oder registriere Dich mit der E-Mail-Adresse {{ invitedEmailAddress }}.\n\n{{ signupUrl }}\n', NULL, '[[regtime_]]', NULL),
('Lr}m\0*', '/_MpXT|', 'Admin', '{{ nameOfInviter }} invited you to join {{ storeName }}', 'Shopware Sso admin Invitation', '<html lang="en">\n<head>\n    <title>Invitation</title>\n</head>\n<body style="font-family: Inter, Arial, Helvetica, sans-serif; font-weight: 500; line-height: 1.5;">\n<div style="width: 400px; padding: 50px;">\n    <div style="padding-bottom: 25px">\n        <svg width="186" height="40" viewBox="0 0 186 40" fill="none" xmlns="http://www.w3.org/2000/svg">\n            <path d="M54.5636 20.1837C52.8632 19.4458 51.4643 18.777 51.4643 17.6684C51.4643 16.8906 52.3436 16.1528 53.826 16.1528C55.1559 16.1528 56.304 16.4872 57.4849 17.0033C57.8192 17.1523 58.3351 17.1886 58.5931 16.6689L59.1854 15.484C59.407 15.0405 59.2217 14.5208 58.8148 14.2264C57.9645 13.6703 56.1914 12.9688 53.8224 12.9688C49.6803 12.9688 47.9871 15.484 47.9871 17.6284C47.9871 20.4381 50.1635 21.8447 52.7869 23.0296C55.1522 24.1019 56.4457 24.8397 56.4457 25.9883C56.4457 26.9515 55.6319 27.653 54.1894 27.653C52.1546 27.653 50.9374 26.9515 49.9382 26.3954C49.495 26.1373 49.0153 26.2463 48.83 26.6171L48.0525 28.2091C47.8672 28.5798 48.0888 28.9106 48.3468 29.096C49.3097 29.7611 51.2681 30.8334 53.9677 30.8334C57.7756 30.8334 60.0683 28.5035 60.0683 25.8393C60.0719 22.6625 57.7065 21.5176 54.5636 20.1837Z" fill="#189EFF"/>\n            <path d="M31.8908 35.6202C30.154 34.3117 27.5924 33.3158 24.8819 32.2653C21.6554 31.015 17.9965 29.5938 15.2496 27.4094C12.1394 24.9305 10.6242 21.8046 10.6242 17.8537C10.6242 14.3062 12.0958 11.2749 14.879 9.08314C18.0001 6.62608 22.7309 5.32485 28.5553 5.32485C30.1649 5.32485 31.7019 5.42299 33.1262 5.61926C33.2533 5.63744 33.3733 5.56838 33.4241 5.4557C33.4786 5.33939 33.4496 5.20491 33.3551 5.12131C29.6853 1.81736 24.94 0 19.9985 0C14.6573 0 9.63591 2.07905 5.85712 5.85915C2.08197 9.63562 0 14.6588 0 19.9982C0 25.3412 2.07833 30.3644 5.85712 34.1408C9.63228 37.9173 14.6537 40 19.9985 40C24.3151 40 28.4245 38.6443 31.8872 36.0818C31.9598 36.0273 32.0034 35.9437 32.0034 35.8528C32.0034 35.7619 31.9635 35.6747 31.8908 35.6202Z" fill="#189EFF"/>\n            <path d="M39.9062 18.1512C39.8989 18.0749 39.8626 18.0022 39.8044 17.9549C35.6332 14.4911 32.2578 13.0771 28.1556 13.0771C25.9683 13.0771 24.2896 13.5169 23.1705 14.382C22.2004 15.1308 21.688 16.1776 21.688 17.4025C21.688 20.8373 25.8847 22.4038 30.7462 24.2175C33.2497 25.1517 35.8403 26.1185 38.2166 27.4379C38.2602 27.4633 38.3075 27.4742 38.3547 27.4742C38.3874 27.4742 38.4201 27.467 38.4528 27.4561C38.5291 27.427 38.5945 27.3688 38.6236 27.2889C39.5319 24.9627 39.9934 22.5092 39.9934 19.9976C39.9897 19.4088 39.9643 18.7873 39.9062 18.1512Z" fill="#189EFF"/>\n            <path d="M154.829 30.626C155.341 30.5679 155.693 30.1935 155.693 29.7283V21.0522C155.693 16.6142 155.152 13.1758 149.44 13.1758C146.159 13.1758 143.612 14.0627 143.303 14.179C142.878 14.3316 142.609 14.6042 142.726 15.2221L143.074 16.6905C143.191 17.1921 143.536 17.5411 144.077 17.4248C145.004 17.1558 147.009 16.5742 149.055 16.5742C151.293 16.5742 151.987 17.85 151.911 20.6669C151.911 20.6669 150.174 20.1253 148.321 20.1253C143.728 20.1253 141.181 22.597 141.181 25.8791C141.181 29.5865 143.532 30.8405 146.89 30.8405C149.629 30.8405 152.449 30.8078 153.622 30.7314L154.829 30.626ZM151.871 27.4784C151.33 28.3652 149.4 28.1435 147.743 28.1108C145.89 28.0708 144.964 27.4239 144.964 25.8391C144.964 23.9854 146.544 22.9059 148.63 22.9059C150.25 22.9059 151.642 23.3711 151.871 23.5238V27.4784Z" fill="#189EFF"/>\n            <path d="M183.969 12.9719C185.092 12.9719 186 12.0669 186 10.9474C186 9.82789 185.092 8.92285 183.969 8.92285C182.846 8.92285 181.938 9.82789 181.938 10.9474C181.938 12.0669 182.846 12.9719 183.969 12.9719ZM183.969 9.2209C184.91 9.2209 185.68 9.99873 185.68 10.9474C185.68 11.896 184.914 12.6739 183.969 12.6739C183.028 12.6739 182.261 11.896 182.261 10.9474C182.261 9.99873 183.028 9.2209 183.969 9.2209Z" fill="#189EFF"/>\n            <path d="M183.279 11.9731H183.468C183.497 11.9731 183.522 11.9477 183.522 11.9186V11.1735H183.965L184.347 11.9368C184.358 11.9622 184.376 11.9731 184.409 11.9731H184.627C184.677 11.9731 184.696 11.9258 184.677 11.8895L184.278 11.1444C184.532 11.0426 184.71 10.8209 184.71 10.5519C184.71 10.203 184.423 9.92676 184.074 9.92676H183.279C183.246 9.92676 183.224 9.9522 183.224 9.98128V11.9186C183.224 11.9477 183.246 11.9731 183.279 11.9731ZM183.529 10.2103H184.049C184.238 10.2103 184.405 10.3666 184.405 10.5592C184.405 10.7627 184.238 10.9227 184.049 10.9227H183.529V10.2103Z" fill="#189EFF"/>\n            <path d="M71.4301 12.9727C68.7304 12.9727 66.881 14.452 66.4777 14.7501V7.12082C66.4777 6.71373 66.0707 6.30664 65.6638 6.30664H63.5927C63.1494 6.30664 62.7788 6.71373 62.7788 7.12082V30.0231C62.7788 30.4666 63.1494 30.8373 63.5927 30.8373H65.6274C66.147 30.8373 66.4777 30.5029 66.4777 30.0231V18.9663C66.8483 18.2285 68.3271 16.4875 70.9504 16.4875C73.1705 16.4875 74.3514 18.1522 74.3514 20.9618V30.0268C74.3514 30.4702 74.722 30.8409 75.1653 30.8409H77.2363C77.6433 30.8409 78.0502 30.4702 78.0502 30.0268V21.0381C78.0466 16.3784 76.2735 12.9727 71.4301 12.9727Z" fill="#189EFF"/>\n            <path d="M114.73 21.2162C114.526 15.4115 112.096 12.9727 106.496 12.9727C103.808 12.9727 100.599 13.7796 100.127 13.9867C99.5457 14.2375 99.1169 14.5356 99.1169 14.9427V15.2807V16.5201V20.5329V21.0781V36.6892C99.1169 37.1326 99.4876 37.5033 99.9308 37.5033H101.646C102.202 37.5033 102.532 37.1689 102.532 36.6892L102.529 30.5429C103.048 30.6773 105.704 30.9027 107.921 30.8336C111.874 30.71 114.526 27.8386 114.748 22.9899C114.781 22.332 114.73 21.2162 114.73 21.2162ZM111.158 22.9863C111.082 26.2757 110.126 27.7296 107.358 27.8822C105.988 27.9586 102.754 27.5769 102.754 27.5769C102.62 27.5333 102.529 27.4752 102.529 27.3516L102.525 20.6855V16.9054C102.525 16.8036 102.601 16.72 102.703 16.7091C103.085 16.6692 104.484 16.2185 106.496 16.2185C109.868 16.2185 111.056 16.7128 111.165 20.9836C111.173 21.5469 111.176 22.3357 111.158 22.9863Z" fill="#189EFF"/>\n            <path d="M139.223 13.3434H137.672C137.228 13.3434 136.6 13.3434 136.378 13.8632L133.642 23.6987H133.569L128.984 13.3797C128.911 13.158 128.65 12.9727 128.246 12.9727H127.988C127.654 12.9727 127.396 13.158 127.287 13.3797L122.662 23.6623H122.589L119.78 13.8632C119.708 13.5288 119.337 13.3434 119.043 13.3434H116.823C116.231 13.3434 115.973 13.7868 116.231 14.3066L121.223 30.3938C121.296 30.6519 121.557 30.8373 121.924 30.8373H122.146C122.516 30.8373 122.738 30.6519 122.811 30.4302L128.061 18.8173H128.134L133.348 30.4302C133.46 30.6519 133.718 30.8373 134.085 30.8373H134.234C134.605 30.8373 134.936 30.6519 135.012 30.3938L139.892 14.3066C140.15 13.7868 139.815 13.3434 139.223 13.3434Z" fill="#189EFF"/>\n            <path d="M166.496 13.1758C166.405 13.1758 166.321 13.1831 166.23 13.1867C166.081 13.1831 165.936 13.1758 165.78 13.1758C164.893 13.1758 164.043 13.2049 163.247 13.2448C161.714 13.3066 160.806 13.4229 160.159 13.4956C160.159 13.4956 159.745 13.5356 159.261 13.5974C158.938 13.6374 158.702 13.7719 158.557 13.9572C158.458 14.0626 158.397 14.1971 158.397 14.3607V14.4189V14.7569V15.9963V19.4348V30.019C158.397 30.4625 158.767 30.8332 159.211 30.8332H160.911C161.612 30.8332 162.096 30.7605 162.096 30.019V19.4348V17.0068C162.096 16.905 162.255 16.7778 162.343 16.7233C162.76 16.4725 163.763 16.2907 165.78 16.2907C165.976 16.2907 166.103 16.2944 166.249 16.298C166.71 16.3416 167.44 16.4834 167.677 16.6179C168.047 16.8032 168.49 16.6905 168.712 16.2108L169.599 14.7605C170.155 13.6192 168.123 13.1758 166.496 13.1758Z" fill="#189EFF"/>\n            <path d="M178.199 12.9727C173.061 12.9727 169.697 17.0799 169.697 21.885C169.697 26.7664 173.061 30.8336 178.235 30.8336C181.08 30.8336 183.337 29.7977 184.557 28.7255C185.073 28.2821 184.928 27.9477 184.63 27.5806L183.631 26.0285C183.337 25.5851 183.002 25.6941 182.632 25.9558C181.596 26.6937 180.412 27.3988 178.453 27.3988C175.459 27.3988 173.388 25.0326 173.352 22.7391H185.146C185.517 22.7391 185.884 22.4411 185.924 21.9976C185.96 21.7032 185.996 21.1108 185.996 20.8127C185.996 16.2657 182.635 12.9727 178.199 12.9727ZM173.541 19.9986C173.799 17.8541 175.427 16.1167 178.126 16.1167C180.641 16.1167 182.268 17.9304 182.341 19.9986H173.541V19.9986Z" fill="#189EFF"/>\n            <path d="M96.1556 18.2573C95.7704 17.1559 95.229 16.2109 94.5351 15.4258C93.8411 14.6407 93.009 14.0337 92.0461 13.6085C91.0833 13.1832 89.7171 12.9688 88.5835 12.9688C87.4498 12.9688 86.0873 13.1832 85.1244 13.6085C84.1615 14.0337 83.3331 14.6407 82.6355 15.4258C81.9415 16.2109 81.4001 17.1559 81.015 18.2573C80.6298 19.3586 80.4373 20.5762 80.4373 21.9065C80.4373 23.2586 80.6298 24.4799 81.015 25.5703C81.4001 26.6607 81.9415 27.5985 82.6355 28.3836C83.3295 29.1687 84.1615 29.7757 85.1244 30.2009C86.0873 30.6262 87.4498 30.837 88.5835 30.837C89.7171 30.837 91.0833 30.6262 92.0461 30.2009C93.009 29.7757 93.8374 29.1687 94.5351 28.3836C95.229 27.5985 95.7704 26.6607 96.1556 25.5703C96.5407 24.4799 96.7333 23.2586 96.7333 21.9065C96.7333 20.5762 96.5407 19.3586 96.1556 18.2573ZM88.489 27.8929C85.4042 27.8929 83.8491 25.2795 83.8491 22.0555C83.8491 18.8315 85.4005 16.2182 88.489 16.2182C91.5774 16.2182 93.1289 18.8315 93.1289 22.0555C93.1289 25.2795 91.5738 27.8929 88.489 27.8929Z" fill="#189EFF"/>\n        </svg>\n    </div>\n    <div>\n        <p><span style="font-weight: bold">{{ nameOfInviter }}</span> has invited you to collaborate on the Shopware store <span style="font-weight: bold">{{ storeName }}</span>.</p>\n        <p>To get access to the store, please either log in or sign up using the email address <span style="font-weight: bold">{{ invitedEmailAddress }}</span>.</p>\n    </div>\n    <div style="padding-top: 25px;">\n        <a href="{{ signupUrl }}" style="border: 1px solid; border-radius: 5px; background: #0870FF; color: #fff; padding:10px 15px; text-decoration: none; font-size: 0.9em; font-weight:bold;">Get started</a>\n    </div>\n</div>\n</body>\n</html>\n', '{{ nameOfInviter }} has invited you to collaborate on the Shopware store {{ storeName }}.\n\nTo get access to the store, please either log in or sign up using the email address {{ invitedEmailAddress }}.\n\n{{ signupUrl }}\n', NULL, '[[regtime_]]', NULL),
('Xr@nx/', '\nQpppS:', '{{ salesChannel.name }}', 'Kunden-Password geändert', NULL, '<div style="font-family:arial; font-size:12px;">\n    Hallo {{ customer.firstName }} {{ customer.lastName }},<br/>\n    <br/>\n    Das Passwort für Ihr {{ shopName }}-Konto wurde erfolgreich geändert. <br/>\n</div>\n', 'Hallo {{ customer.firstName }} {{ customer.lastName }},\n\nDas Passwort für Ihr {{ shopName }}-Konto wurde erfolgreich geändert.\n', NULL, '[[regtime_]]', NULL),
('Xr@nx/', '/_MpXT|', '{{ salesChannel.name }}', 'Customer password changed', NULL, '<div style="font-family:arial; font-size:12px;">\n    Hello {{ customer.firstName }} {{ customer.lastName }},<br/>\n    <br/>\n    Your {{ shopName }} account password has been changed successfully. <br/>\n</div>\n', 'Hello {{ customer.firstName }} {{ customer.lastName }},\n\nYour {{ shopName }} account password has been changed successfully.\n', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_template_type`
--

CREATE TABLE `mail_template_type` (
  `id` binary(16) NOT NULL,
  `technical_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `available_entities` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `template_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.mail_template_type.technical_name` (`technical_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_template_type`
--

INSERT INTO `mail_template_type` VALUES
('Vq(y5ٷn', 'customer_register', '{"customer":"customer","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"cf7892d60b794b65b7badae58462715b","salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"b8794be7a6d840e99ffc76f17320df2b","defaultShippingAddressId":"b8794be7a6d840e99ffc76f17320df2b","customerNumber":"10060","salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","company":null,"email":"testing@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":"2021-03-29T12:53:05.736+00:00","lastLogin":null,"newsletter":false,"birthday":null,"lastOrderDate":null,"orderCount":0,"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":{"salutationKey":"mr","displayName":"Mr.","letterName":"Dear Mr.","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"bd3fd9c43c754e02a11d92b7f7cedc4f","versionId":null,"translated":{"displayName":"Mr.","letterName":"Dear Mr."},"createdAt":"2021-03-09T09:43:59.659+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bd3fd9c43c754e02a11d92b7f7cedc4f"},"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":[{"customerId":"c3445cbcbcec4678b3f15639a892afd1","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","countryStateId":null,"salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","zipcode":"12345","city":"Musterstadt","company":null,"department":null,"title":null,"street":"Musterstr. 2","phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":null,"countryState":null,"salutation":null,"customer":null,"customFields":null,"_uniqueIdentifier":"b8794be7a6d840e99ffc76f17320df2b","versionId":null,"translated":[],"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b8794be7a6d840e99ffc76f17320df2b"}],"orderCustomers":null,"autoIncrement":62,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":null,"requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"c3445cbcbcec4678b3f15639a892afd1","versionId":null,"translated":[],"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c3445cbcbcec4678b3f15639a892afd1"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('Vq(y5~', 'newsletterDoubleOptIn', '{"newsletterRecipient":"newsletter_recipient","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"newsletterRecipient":{"email":"test@example.com","title":null,"firstName":"Max","lastName":"Mustermann","zipCode":"48624","city":"Sch\\u00f6ppingen","street":null,"status":"direct","hash":"7ee7a7cb1fb741f387b07f4b86a67124","salutationId":"44706b43d8bd4b34a4582185c3fd07f1","salutation":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"customFields":null,"confirmedAt":null,"tags":null,"_uniqueIdentifier":"e622fb2224fc4baa9125e0bfd0f2a927","versionId":null,"translated":[],"createdAt":"2021-03-29T15:10:10.880+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e622fb2224fc4baa9125e0bfd0f2a927"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('Vq(y5', 'newsletterRegister', '{"newsletterRecipient":"newsletter_recipient","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"newsletterRecipient":{"email":"test@example.com","title":null,"firstName":"Max","lastName":"Mustermann","zipCode":"48624","city":"Sch\\u00f6ppingen","street":null,"status":"direct","hash":"7ee7a7cb1fb741f387b07f4b86a67124","salutationId":"44706b43d8bd4b34a4582185c3fd07f1","salutation":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"customFields":null,"confirmedAt":null,"tags":null,"_uniqueIdentifier":"e622fb2224fc4baa9125e0bfd0f2a927","versionId":null,"translated":[],"createdAt":"2021-03-29T15:10:10.880+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e622fb2224fc4baa9125e0bfd0f2a927"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('Vq(y5', 'order_confirmation_mail', '{"order":"order","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","billingAddressId":"3e112279819f4c1d8f5d7107f6b33a25","orderDateTime":"2021-04-12T08:39:51.371+00:00","orderDate":"2021-04-12T00:00:00.000+00:00","price":{"netPrice":799.0700000000000500222085975110530853271484375,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"positionPrice":855,"taxStatus":"gross","rawTotal":855,"extensions":[]},"amountTotal":855,"amountNet":799.0700000000000500222085975110530853271484375,"positionPrice":855,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"e96e47f99c844f1b9997e613bc621f65","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"7f0eef7a233a41f886a2fc69b0ca79df","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"69867b98038e4d41bde2382bbb5810fc","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"c9036a6e1bf84f769f06d0ba6490d75b","defaultShippingAddressId":"3fc4a0d7787c466daeb6fade1b51c4fd","customerNumber":"1337","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","company":null,"password":"$2y$10$9xvO2tM3dEfcOG4lO9CA3eogJD1wkYhW7erQv0d14AAUA9u0V5Dpy","email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-12T08:39:36.376+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-12T08:39:51.371+00:00","orderCount":4,"createdAt":"2021-04-12T07:54:30.118+00:00","updatedAt":"2021-04-12T08:39:51.671+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"7f0eef7a233a41f886a2fc69b0ca79df","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7f0eef7a233a41f886a2fc69b0ca79df"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"4f602c9cb4994a7a96a06630d9f62cee","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-12T07:52:38.207+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4f602c9cb4994a7a96a06630d9f62cee"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"e61b6f06cbe5421ebb41d428ce457ac2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.542+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e61b6f06cbe5421ebb41d428ce457ac2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-12T07:52:38.772+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":null,"addresses":[{"countryId":"f68b900afd7644dfb8b7f5392183efd9","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Saint Barth\\u00e9lemy","iso":"BL","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"BLM","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"f68b900afd7644dfb8b7f5392183efd9","versionId":null,"translated":{"name":"Saint Barth\\u00e9lemy","customFields":[]},"createdAt":"2021-04-12T07:52:46.949+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"f68b900afd7644dfb8b7f5392183efd9"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"3e112279819f4c1d8f5d7107f6b33a25","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.556+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"3e112279819f4c1d8f5d7107f6b33a25","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","shippingOrderAddressId":"7796bf226130426fb71bef6270dcf8e3","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","trackingCodes":[],"shippingDateEarliest":"2021-04-13T00:00:00.000+00:00","shippingDateLatest":"2021-04-15T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"4753bf682a1640d8a89ca672f3982b1b","stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"2669c221e38a477980f8bef5e9cccdaf","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"4753bf682a1640d8a89ca672f3982b1b","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.108+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4753bf682a1640d8a89ca672f3982b1b"},"shippingMethod":{"name":"Standard","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"d5352c5bdd10417db10125050af38b64","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"d5352c5bdd10417db10125050af38b64","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-12T07:52:38.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"d5352c5bdd10417db10125050af38b64"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"132058274b4c4ba5b292e78b79e7fd90","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"7ab645770dbb4a648268248492ed5f0a","versionId":null,"translated":{"name":"Standard","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-12T07:52:38.814+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ab645770dbb4a648268248492ed5f0a"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"35bf2776cc6c4857980ed8a651bf6060","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.565+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"35bf2776cc6c4857980ed8a651bf6060","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","identifier":"f47e72bf6d0e40c4aa290330a7ffd44d","referencedId":"f47e72bf6d0e40c4aa290330a7ffd44d","productId":"f47e72bf6d0e40c4aa290330a7ffd44d","quantity":1,"unitPrice":855,"totalPrice":855,"label":"Aerodynamic Cotton Brand Muffin","description":null,"good":true,"removable":true,"coverId":"5f3c1ac1ce3744009cc8613f1524fc80","stackable":true,"position":1,"price":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":855,"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"40afe75845934469b3528a06573bd395","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-12 07:54:39.961","optionIds":null,"isCloseout":false,"categoryIds":["e38a91bb89b94313acd546bb813c9bde","f5fd0ad1b7904012adeab43c5571249f","1f232fdf7e744a6188e70373c64059ec"],"propertyIds":["08342bf3c949475081380d7f18ac3013","1f4a747cd9084a91b5b3354483f64d5c","242c6322e09642db9a6dd34e4945563b","2f8fdf5146e3495b93f1477a13b30a70","33443da934024d7d9a4e949f2dbade33","38414ab339ae45e8a34c742f74ca951c","517fa1113cc749cb82acca7a7a911f51","5db7f83261c746818e2cb119d7b690e3","6b463dcccdcf44b69c1d64aaa99f465a","7b0924b10e6c4e7c8cebb21f779014fe","95746abcc9fe46cc93277210e7184e38","98a65897b93440e7b5f848e51efa53df","ad24e8a73b0f4018827e267346c08254","af8b23072130451b8a80b1a94af2a529","c021d77e23eb44568bd321158519b807","e4a316f3eaf64983a6af02654f7d2fc7","fdfb81dcdbb2400aab7ac18e9c967350","fe4960c9a2df4bfd9e977b473983bd86"],"releaseDate":null,"customFields":[],"productNumber":"dc0f18c1a31f4f189e7ef7d921052fe6","manufacturerId":"0f721bed5f054043a2b5d0986f55757c","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":31.570093457943923,\\"gross\\":33.78,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"2095623819c546a2893afe2db1557bec","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.572+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"2095623819c546a2893afe2db1557bec","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","amount":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"69867b98038e4d41bde2382bbb5810fc","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-12T07:52:38.793+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"69867b98038e4d41bde2382bbb5810fc"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"3e52d2ea8045489bbc13528a1cd68170","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"db5897dec897426985f29b105875e6a8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.129+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"db5897dec897426985f29b105875e6a8"},"stateId":"db5897dec897426985f29b105875e6a8","customFields":null,"_uniqueIdentifier":"a57d8d1c18f64f55bfb48b39ceec660f","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.575+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"a57d8d1c18f64f55bfb48b39ceec660f","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"s2i1jbau4LeH0R7RUDrzHo8Y7KglbZ_D","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"040ddecd833d4c98a1935f19b5617e8c","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"ed244ea9e52c4497ab57c4a12b10d962","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"ed244ea9e52c4497ab57c4a12b10d962"},"stateId":"ed244ea9e52c4497ab57c4a12b10d962","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["132058274b4c4ba5b292e78b79e7fd90","5bbbd6951e8f4c91a8de6544a5fb8ea2","b3963d2ae9f04c8ebd7ea09304f6294f","8583f4c0d9254ea091c8354a180a3a6d"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"e96e47f99c844f1b9997e613bc621f65","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.578+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e96e47f99c844f1b9997e613bc621f65","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","countryId":"77304b7727794e1c9460f192a55d66cf","navigationCategoryId":"e38a91bb89b94313acd546bb813c9bde","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCOGFIOGDVTJLZOVZ5WLEWEA","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"c6dd40a58bfd4c54979eaf1c6be56cb1","snippetSet":null,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"46d268ec94c5430295ec21fa5952ca53","versionId":null,"translated":[],"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"46d268ec94c5430295ec21fa5952ca53"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["69867b98038e4d41bde2382bbb5810fc","81fcce6eda1e4ee994281cf6c41e1208","8b9ed316d2da4756ab995bd0fa46ef87","9c8bb5aa0c974f87b44b4a61a9d61d0a"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"08757990bf314633b5d0fa55efc5e63d","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"08757990bf314633b5d0fa55efc5e63d","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('Wr.|+', 'customer_group_change_accept', '{"customer":"customer","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"cf7892d60b794b65b7badae58462715b","salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"b8794be7a6d840e99ffc76f17320df2b","defaultShippingAddressId":"b8794be7a6d840e99ffc76f17320df2b","customerNumber":"10060","salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","company":null,"email":"testing@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":"2021-03-29T12:53:05.736+00:00","lastLogin":null,"newsletter":false,"birthday":null,"lastOrderDate":null,"orderCount":0,"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":{"salutationKey":"mr","displayName":"Mr.","letterName":"Dear Mr.","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"bd3fd9c43c754e02a11d92b7f7cedc4f","versionId":null,"translated":{"displayName":"Mr.","letterName":"Dear Mr."},"createdAt":"2021-03-09T09:43:59.659+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bd3fd9c43c754e02a11d92b7f7cedc4f"},"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":[{"customerId":"c3445cbcbcec4678b3f15639a892afd1","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","countryStateId":null,"salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","zipcode":"12345","city":"Musterstadt","company":null,"department":null,"title":null,"street":"Musterstr. 2","phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":null,"countryState":null,"salutation":null,"customer":null,"customFields":null,"_uniqueIdentifier":"b8794be7a6d840e99ffc76f17320df2b","versionId":null,"translated":[],"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b8794be7a6d840e99ffc76f17320df2b"}],"orderCustomers":null,"autoIncrement":62,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":null,"requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"c3445cbcbcec4678b3f15639a892afd1","versionId":null,"translated":[],"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c3445cbcbcec4678b3f15639a892afd1"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('Wr.Ol', 'customer_group_change_reject', '{"customer":"customer","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"cf7892d60b794b65b7badae58462715b","salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"b8794be7a6d840e99ffc76f17320df2b","defaultShippingAddressId":"b8794be7a6d840e99ffc76f17320df2b","customerNumber":"10060","salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","company":null,"email":"testing@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":"2021-03-29T12:53:05.736+00:00","lastLogin":null,"newsletter":false,"birthday":null,"lastOrderDate":null,"orderCount":0,"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":{"salutationKey":"mr","displayName":"Mr.","letterName":"Dear Mr.","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"bd3fd9c43c754e02a11d92b7f7cedc4f","versionId":null,"translated":{"displayName":"Mr.","letterName":"Dear Mr."},"createdAt":"2021-03-09T09:43:59.659+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bd3fd9c43c754e02a11d92b7f7cedc4f"},"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":[{"customerId":"c3445cbcbcec4678b3f15639a892afd1","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","countryStateId":null,"salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","zipcode":"12345","city":"Musterstadt","company":null,"department":null,"title":null,"street":"Musterstr. 2","phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":null,"countryState":null,"salutation":null,"customer":null,"customFields":null,"_uniqueIdentifier":"b8794be7a6d840e99ffc76f17320df2b","versionId":null,"translated":[],"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b8794be7a6d840e99ffc76f17320df2b"}],"orderCustomers":null,"autoIncrement":62,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":null,"requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"c3445cbcbcec4678b3f15639a892afd1","versionId":null,"translated":[],"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c3445cbcbcec4678b3f15639a892afd1"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('Wr.z', 'password_change', '{"customer":"customer","resetUrl":null,"salesChannel":"sales_channel"}', '[[regtime_]]', NULL, NULL),
('Wr.C%M', 'sepa_confirmation', '{"order":"order","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","billingAddressId":"3e112279819f4c1d8f5d7107f6b33a25","orderDateTime":"2021-04-12T08:39:51.371+00:00","orderDate":"2021-04-12T00:00:00.000+00:00","price":{"netPrice":799.0700000000000500222085975110530853271484375,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"positionPrice":855,"taxStatus":"gross","rawTotal":855,"extensions":[]},"amountTotal":855,"amountNet":799.0700000000000500222085975110530853271484375,"positionPrice":855,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"e96e47f99c844f1b9997e613bc621f65","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"7f0eef7a233a41f886a2fc69b0ca79df","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"69867b98038e4d41bde2382bbb5810fc","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"c9036a6e1bf84f769f06d0ba6490d75b","defaultShippingAddressId":"3fc4a0d7787c466daeb6fade1b51c4fd","customerNumber":"1337","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","company":null,"password":"$2y$10$9xvO2tM3dEfcOG4lO9CA3eogJD1wkYhW7erQv0d14AAUA9u0V5Dpy","email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-12T08:39:36.376+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-12T08:39:51.371+00:00","orderCount":4,"createdAt":"2021-04-12T07:54:30.118+00:00","updatedAt":"2021-04-12T08:39:51.671+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"7f0eef7a233a41f886a2fc69b0ca79df","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7f0eef7a233a41f886a2fc69b0ca79df"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"4f602c9cb4994a7a96a06630d9f62cee","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-12T07:52:38.207+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4f602c9cb4994a7a96a06630d9f62cee"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"e61b6f06cbe5421ebb41d428ce457ac2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.542+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e61b6f06cbe5421ebb41d428ce457ac2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-12T07:52:38.772+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":null,"addresses":[{"countryId":"f68b900afd7644dfb8b7f5392183efd9","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Saint Barth\\u00e9lemy","iso":"BL","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"BLM","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"f68b900afd7644dfb8b7f5392183efd9","versionId":null,"translated":{"name":"Saint Barth\\u00e9lemy","customFields":[]},"createdAt":"2021-04-12T07:52:46.949+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"f68b900afd7644dfb8b7f5392183efd9"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"3e112279819f4c1d8f5d7107f6b33a25","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.556+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"3e112279819f4c1d8f5d7107f6b33a25","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","shippingOrderAddressId":"7796bf226130426fb71bef6270dcf8e3","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","trackingCodes":[],"shippingDateEarliest":"2021-04-13T00:00:00.000+00:00","shippingDateLatest":"2021-04-15T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"4753bf682a1640d8a89ca672f3982b1b","stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"2669c221e38a477980f8bef5e9cccdaf","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"4753bf682a1640d8a89ca672f3982b1b","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.108+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4753bf682a1640d8a89ca672f3982b1b"},"shippingMethod":{"name":"Standard","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"d5352c5bdd10417db10125050af38b64","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"d5352c5bdd10417db10125050af38b64","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-12T07:52:38.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"d5352c5bdd10417db10125050af38b64"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"132058274b4c4ba5b292e78b79e7fd90","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"7ab645770dbb4a648268248492ed5f0a","versionId":null,"translated":{"name":"Standard","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-12T07:52:38.814+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ab645770dbb4a648268248492ed5f0a"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"35bf2776cc6c4857980ed8a651bf6060","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.565+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"35bf2776cc6c4857980ed8a651bf6060","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","identifier":"f47e72bf6d0e40c4aa290330a7ffd44d","referencedId":"f47e72bf6d0e40c4aa290330a7ffd44d","productId":"f47e72bf6d0e40c4aa290330a7ffd44d","quantity":1,"unitPrice":855,"totalPrice":855,"label":"Aerodynamic Cotton Brand Muffin","description":null,"good":true,"removable":true,"coverId":"5f3c1ac1ce3744009cc8613f1524fc80","stackable":true,"position":1,"price":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":855,"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"40afe75845934469b3528a06573bd395","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-12 07:54:39.961","optionIds":null,"isCloseout":false,"categoryIds":["e38a91bb89b94313acd546bb813c9bde","f5fd0ad1b7904012adeab43c5571249f","1f232fdf7e744a6188e70373c64059ec"],"propertyIds":["08342bf3c949475081380d7f18ac3013","1f4a747cd9084a91b5b3354483f64d5c","242c6322e09642db9a6dd34e4945563b","2f8fdf5146e3495b93f1477a13b30a70","33443da934024d7d9a4e949f2dbade33","38414ab339ae45e8a34c742f74ca951c","517fa1113cc749cb82acca7a7a911f51","5db7f83261c746818e2cb119d7b690e3","6b463dcccdcf44b69c1d64aaa99f465a","7b0924b10e6c4e7c8cebb21f779014fe","95746abcc9fe46cc93277210e7184e38","98a65897b93440e7b5f848e51efa53df","ad24e8a73b0f4018827e267346c08254","af8b23072130451b8a80b1a94af2a529","c021d77e23eb44568bd321158519b807","e4a316f3eaf64983a6af02654f7d2fc7","fdfb81dcdbb2400aab7ac18e9c967350","fe4960c9a2df4bfd9e977b473983bd86"],"releaseDate":null,"customFields":[],"productNumber":"dc0f18c1a31f4f189e7ef7d921052fe6","manufacturerId":"0f721bed5f054043a2b5d0986f55757c","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":31.570093457943923,\\"gross\\":33.78,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"2095623819c546a2893afe2db1557bec","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.572+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"2095623819c546a2893afe2db1557bec","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","amount":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"69867b98038e4d41bde2382bbb5810fc","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-12T07:52:38.793+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"69867b98038e4d41bde2382bbb5810fc"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"3e52d2ea8045489bbc13528a1cd68170","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"db5897dec897426985f29b105875e6a8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.129+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"db5897dec897426985f29b105875e6a8"},"stateId":"db5897dec897426985f29b105875e6a8","customFields":null,"_uniqueIdentifier":"a57d8d1c18f64f55bfb48b39ceec660f","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.575+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"a57d8d1c18f64f55bfb48b39ceec660f","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"s2i1jbau4LeH0R7RUDrzHo8Y7KglbZ_D","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"040ddecd833d4c98a1935f19b5617e8c","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"ed244ea9e52c4497ab57c4a12b10d962","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"ed244ea9e52c4497ab57c4a12b10d962"},"stateId":"ed244ea9e52c4497ab57c4a12b10d962","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["132058274b4c4ba5b292e78b79e7fd90","5bbbd6951e8f4c91a8de6544a5fb8ea2","b3963d2ae9f04c8ebd7ea09304f6294f","8583f4c0d9254ea091c8354a180a3a6d"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"e96e47f99c844f1b9997e613bc621f65","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.578+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e96e47f99c844f1b9997e613bc621f65","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","countryId":"77304b7727794e1c9460f192a55d66cf","navigationCategoryId":"e38a91bb89b94313acd546bb813c9bde","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCOGFIOGDVTJLZOVZ5WLEWEA","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"c6dd40a58bfd4c54979eaf1c6be56cb1","snippetSet":null,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"46d268ec94c5430295ec21fa5952ca53","versionId":null,"translated":[],"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"46d268ec94c5430295ec21fa5952ca53"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["69867b98038e4d41bde2382bbb5810fc","81fcce6eda1e4ee994281cf6c41e1208","8b9ed316d2da4756ab995bd0fa46ef87","9c8bb5aa0c974f87b44b4a61a9d61d0a"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"08757990bf314633b5d0fa55efc5e63d","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"08757990bf314633b5d0fa55efc5e63d","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('Wr.ΰ', 'product_stock_warning', '{"product":"product","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, NULL);
INSERT INTO `mail_template_type` VALUES
('Wr.d,', 'order_delivery.state.returned_partially', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('Wr.0', 'order_delivery.state.shipped_partially', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('Wr.', 'order_delivery.state.returned', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('Wr.I', 'order_delivery.state.shipped', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('Wr.$w', 'order_delivery.state.cancelled', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('Wr.|P', 'order_transaction.state.reminded', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('Wr.8', 'order_transaction.state.refunded_partially', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('Wr..qG', 'order_transaction.state.cancelled', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb4632960