const i=`{% block sw_settings_country_detail %} <sw-page class="sw-settings-country-detail"> {% block sw_settings_country_detail_header %} <template #smart-bar-header> <h2>{{ placeholder(country, 'name', $tc('sw-settings-country.detail.textHeadline')) }}</h2> </template> {% endblock %} {% block sw_settings_country_detail_actions %} <template #smart-bar-actions> {% block sw_settings_country_detail_actions_abort %} <mt-button v-tooltip.bottom="{ message: 'ESC', appearance: 'light' }" :disabled="isLoading" variant="secondary" size="default" @click="onCancel" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_settings_country_detail_actions_save %} <sw-button-process v-tooltip.bottom="tooltipSave" class="sw-settings-country-detail__save-action" :is-loading="isLoading" :process-success="isSaveSuccessful" :disabled="!country || !allowSave || undefined" variant="primary" @update:process-success="saveFinish" @click.prevent="onSave" > {{ $tc('sw-settings-country.detail.buttonSave') }} </sw-button-process> {% endblock %} </template> {% endblock %} {% block sw_settings_country_detail_language_switch %} <template #language-switch> <sw-language-switch :save-changes-function="saveOnLanguageChange" :abort-change-function="abortOnLanguageChange" @on-change="onChangeLanguage" /> </template> {% endblock %} {% block sw_settings_country_detail_content %} <template #content> <sw-card-view> {% block sw_settings_country_detail_content_language_info %} <sw-language-info :entity-description="placeholder(country, 'name', $tc('sw-settings-country.detail.textHeadline'))" /> {% endblock %} {% block sw_settings_country_tabs_header %} <sw-tabs position-identifier="sw-settings-country-detail-header"> {% block sw_setting_country_tabs_setting %} <sw-tabs-item v-bind="$props" class="sw-settings-country__setting-tab" :route="{ name: isNewCountry ? 'sw.settings.country.create.general' : 'sw.settings.country.detail.general' }" > {{ $tc('sw-settings-country.page.generalTab') }} </sw-tabs-item> {% endblock %} {% block sw_setting_country_tabs_state %} <sw-tabs-item v-bind="$props" class="sw-settings-country__state-tab" :route="{ name: isNewCountry ? 'sw.settings.country.create.state' : 'sw.settings.country.detail.state' }" > {{ $tc('sw-settings-country.page.stateTab') }} </sw-tabs-item> {% endblock %} {% block sw_setting_country_tabs_address_handling %} <sw-tabs-item v-bind="$props" class="sw-settings-country__address-handling-tab" :route="{ name: isNewCountry ? 'sw.settings.country.create.address-handling' : 'sw.settings.country.detail.address-handling' }" > {{ $tc('sw-settings-country.page.addressHandlingTab') }} </sw-tabs-item> {% endblock %} {% block sw_setting_country_tabs_extension %}{% endblock %} </sw-tabs> {% endblock %} <template v-if="isLoading"> <sw-skeleton /> <sw-skeleton /> </template> <template v-else> {% block sw_settings_country_tabs_content %} <router-view v-slot="{ Component }" > <component :is="Component" :country="country" :country-state-repository="countryStateRepository" :is-loading="isLoading" :user-config="userConfig" :user-config-values="userConfigValues" @modal-save="onSaveModal" @update:country="onUpdateCountry" /> </router-view> {% endblock %} {% block sw_settings_country_detail_custom_field_sets %} <mt-card v-if="showCustomFields" position-identifier="sw-settings-country-detail-custom-field-sets" :title="$tc('sw-settings-custom-field.general.mainMenuItemGeneral')" :is-loading="isLoading" > <sw-custom-field-set-renderer :entity="country" :disabled="!acl.can('country.editor')" :sets="customFieldSets" /> </mt-card> {% endblock %} </template> </sw-card-view> </template> {% endblock %} </sw-page> {% endblock %}`,{Component:o,Mixin:s}=Shopware,{mapPropertyErrors:a}=o.getComponentHelper(),{Criteria:e}=Shopware.Data,r={template:i,inject:["repositoryFactory","acl","customFieldDataProviderService"],mixins:[s.getByName("notification"),s.getByName("placeholder"),s.getByName("discard-detail-page-changes")("country")],shortcuts:{"SYSTEMKEY+S":{active(){return this.allowSave},method:"onSave"},ESCAPE:"onCancel"},data(){return{country:{customerTax:{enabled:!1},companyTax:{enabled:!1}},countryId:null,isLoading:!1,countryStateRepository:null,isSaveSuccessful:!1,customFieldSets:null,userConfig:{value:{}},userConfigValues:{},showPreviewModal:!1,previewData:null}},metaInfo(){return{title:this.$createTitle(this.identifier)}},computed:{currentUserId(){return Shopware.Store.get("session").currentUser.id},countryRepository(){return this.repositoryFactory.create("country")},userConfigRepository(){return this.repositoryFactory.create("user_config")},identifier(){return this.placeholder(this.country,"name")},stateColumns(){return this.getStateColumns()},isNewCountry(){return typeof this.country.isNew=="function"?this.country.isNew():!1},allowSave(){return this.isNewCountry?this.acl.can("country.creator"):this.acl.can("country.editor")},tooltipSave(){return this.allowSave?{message:`${this.$device.getSystemKey()} + S`,appearance:"light"}:{message:this.$tc("sw-privileges.tooltip.warning"),disabled:this.allowSave,showOnDisabledElements:!0}},userConfigCriteria(){return new e(1,25).addFilter(e.multi("AND",[e.equals("userId",this.currentUserId),e.equals("key","setting-country")]))},...a("country",["name"]),showCustomFields(){return this.customFieldSets&&this.customFieldSets.length>0}},created(){this.createdComponent()},methods:{createdComponent(){this.$route.params.id&&(this.countryId=this.$route.params.id.toLowerCase(),Promise.all([this.loadEntityData(),this.loadCustomFieldSets(),this.loadUserConfig()]))},loadEntityData(){return typeof this.country.isNew=="function"&&this.country.isNew()?!1:(this.isLoading=!0,this.countryRepository.get(this.countryId).then(t=>{this.country=t,this.isLoading=!1,this.countryStateRepository=this.repositoryFactory.create(this.country.states.entity,this.country.states.source)}).catch(()=>{this.isLoading=!1}))},loadCustomFieldSets(){this.customFieldDataProviderService.getCustomFieldSets("country").then(t=>{this.customFieldSets=t})},loadUserConfig(){return this.userConfigRepository.search(this.userConfigCriteria,Shopware.Context.api).then(t=>{if(t.length===0){this.userConfig=this.userConfigRepository.create(Shopware.Context.api),this.userConfig.userId=this.currentUserId,this.userConfig.key="setting-country",this.userConfig.value=[];return}this.userConfig=t.first(),this.userConfigValues=this.userConfig.value[this.countryId],this.userConfigValues||(this.userConfig.value[this.countryId]={},this.userConfigValues=this.userConfig.value[this.countryId])})},saveFinish(){this.isSaveSuccessful=!1},onSave(){this.isSaveSuccessful=!1,this.isLoading=!0;const t=this.userConfig.value[this.countryId];return this.countryRepository.save(this.country,Shopware.Context.api).then(()=>{t&&Object.keys(t).length>0&&this.userConfigRepository.save(this.userConfig,Shopware.Context.api).then(()=>{this.loadUserConfig()}),this.loadEntityData(),this.isLoading=!1,this.isSaveSuccessful=!0}).catch(()=>{this.isLoading=!1})},onCancel(){this.$router.push({name:"sw.settings.country.index"})},abortOnLanguageChange(){return this.countryRepository.hasChanges(this.country)},saveOnLanguageChange(){return this.onSave()},onChangeLanguage(){this.loadEntityData()},getStateColumns(){return[{property:"name",label:this.$tc("sw-settings-country.detail.columnStateNameLabel"),inlineEdit:"string",primary:!0},{property:"shortCode",label:this.$tc("sw-settings-country.detail.columnStateShortCodeLabel"),inlineEdit:"string"}]},onSaveModal(){return this.onSave()},onUpdateCountry(t,n){Shopware.Utils.object.set(this.country,t,n)}}};export{r as default};
