const l=`{% block sw_review_list %} <sw-page class="sw-review-list"> {% block sw_review_list_search_bar %} <template #search-bar> <sw-search-bar initial-search-type="product_review" :initial-search="term" :placeholder="$tc('sw-review.list.placeholderSearchBar')" @search="onSearch" /> </template> {% endblock %} {% block sw_review_list_smart_bar_header %} <template #smart-bar-header> {% block sw_review_list_smart_bar_header_title %} <h2> {% block sw_review_list_smart_bar_header_title_text %} {{ $tc('sw-review.list.textReviewOverview') }} {% endblock %} {% block sw_review_list_smart_bar_header_amount %} <span v-if="!isLoading" class="sw-page__smart-bar-amount" > ({{ items.total }}) </span> {% endblock %} </h2> {% endblock %} </template> {% endblock %} {% block sw_review_list_content %} <template #content> {% block sw_review_list_content %} <div class="sw_review_list__content"> {% block sw_review_list_empty_state %} <mt-empty-state v-if="!isLoading && !total" icon="solid-file-text" :centered="true" :headline="$t('sw-review.list.messageEmpty')" :description="$t('sw-review.list.messageEmptySubline')" /> {% endblock %} {% block sw_review_list_content_list %} <sw-entity-listing v-else-if="isLoading || items" ref="listing" detail-route="sw.review.detail" :repository="repository" :columns="columns" :items="items" :allow-edit="acl.can('review.editor')" :allow-delete="acl.can('review.deleter')" :show-selection="acl.can('review.deleter')" :disable-data-fetching="true" :sort-by="sortBy" :sort-direction="sortDirection" identifier="sw-review-list" :is-loading="isLoading" @page-change="onPageChange" @column-sort="onSortColumn" > {% block sw_review_list_content_list_status %} <template #column-status="{ item }"> <sw-data-grid-column-boolean v-model:value="item.status" :is-inline-edit="false" /> </template> {% endblock %} {% block sw_review_list_content_list_title %} <template #column-title="{ item }"> <div class="sw-review-text_ellipsis"> <router-link :to="{ name: 'sw.review.detail', params: { id: item.id } }"> {{ item.title }} </router-link> </div> </template> {% endblock %} {% block sw_review_list_content_list_created_at %} <template #column-createdAt="{ item }"> <sw-time-ago :date="item.createdAt" /> </template> {% endblock %} {% block sw_review_list_content_list_user %} <template #column-user="{ item }"> <router-link v-if="item.customer" :to="{ name: 'sw.customer.detail', params: { id: item.customerId } }" > {{ item.customer.lastName }}, {{ item.customer.firstName }} </router-link> </template> {% endblock %} {% block sw_review_list_content_list_product %} <template #column-product="{ item }"> <template v-if="item.productId"> <router-link :to="{ name: 'sw.product.detail', params: { id: item.productId } }"> {{ item.product.translated.name }} </router-link> </template> </template> {% endblock %} {% block sw_review_list_content_list_points %} <template #column-points="{ item }"> <sw-rating-stars :value="item.points" /> </template> {% endblock %} {% block sw_review_list_content_list_comment %} <template #column-comment="{ item }"> <sw-data-grid-column-boolean :value="item.comment && item.comment.length > 0" :is-inline-edit="false" /> </template> {% endblock %} </sw-entity-listing> {% endblock %} </div> {% endblock %} </template> {% endblock %} {% block sw_review_list_sidebar %} <template #sidebar> <sw-sidebar> {% block sw_review_list_sidebar_refresh %} <sw-sidebar-item icon="regular-undo" :title="$tc('sw-review.list.titleSidebarItemRefresh')" @click="onRefresh" /> {% endblock %} {% block sw_review_list_sidebar_filter %} <sw-sidebar-filter-panel entity="product_review" :store-key="storeKey" :filters="listFilters" :defaults="defaultFilters" :active-filter-number="activeFilterNumber" @criteria-changed="updateCriteria" /> {% endblock %} </sw-sidebar> </template> {% endblock %} </sw-page> {% endblock %}`,{Mixin:s}=Shopware,{Criteria:t}=Shopware.Data,a=Object.freeze(["sales-channel-filter","status-filter","language-filter","customer-filter","product-filter","points-filter"]),o={template:l,inject:["repositoryFactory","acl","filterFactory"],mixins:[s.getByName("listing")],data(){return{items:null,isLoading:!1,sortBy:"status,createdAt",defaultFilters:a,storeKey:"grid.filter.product_review",activeFilterNumber:0}},metaInfo(){return{title:this.$createTitle()}},computed:{listFilterOptions(){return{"sales-channel-filter":{property:"salesChannel",label:this.$t("sw-review.filters.salesChannelFilter.label"),placeholder:this.$t("sw-review.filters.salesChannelFilter.placeholder"),criteria:this.salesChannelCriteria},"status-filter":{property:"status",type:"boolean-filter",label:this.$t("sw-review.filters.statusFilter.label"),optionTrue:this.$t("global.default.yes"),optionFalse:this.$t("global.default.no")},"language-filter":{property:"language",label:this.$t("sw-review.filters.languageFilter.label"),placeholder:this.$t("sw-review.filters.languageFilter.placeholder"),criteria:this.languageCriteria},"customer-filter":{property:"customer",label:this.$t("sw-review.filters.customerFilter.label"),placeholder:this.$t("sw-review.filters.customerFilter.placeholder"),criteria:this.customerCriteria,labelProperty:"email"},"product-filter":{property:"product",label:this.$t("sw-review.filters.productFilter.label"),placeholder:this.$t("sw-review.filters.productFilter.placeholder"),criteria:this.productCriteria},"points-filter":{property:"points",type:"number-filter",label:this.$t("sw-review.filters.pointsFilter.label"),fromFieldLabel:null,toFieldLabel:null,fromPlaceholder:this.$t("global.default.from"),toPlaceholder:this.$t("global.default.to")}}},listFilters(){return this.filterFactory.create("product_review",this.listFilterOptions)},salesChannelCriteria(){const e=new t(1,25);return e.addSorting(t.sort("name")),e},languageCriteria(){const e=new t(1,25);return e.addSorting(t.sort("name")),e},customerCriteria(){return new t(1,25)},productCriteria(){const e=new t(1,25);return e.addSorting(t.sort("name")),e},columns(){return[{property:"title",dataIndex:"title",label:"sw-review.list.columnTitle"},{property:"points",dataIndex:"points",label:"sw-review.list.columnPoints"},{property:"product",dataIndex:"product.name",label:"sw-review.list.columnProduct",routerLink:"sw.review.detail",primary:!0},{property:"user",dataIndex:"customer.lastName,customer.firstName",label:"sw-review.list.columnUser"},{property:"createdAt",dataIndex:"createdAt",label:"sw-review.list.columnCreatedAt"},{property:"status",dataIndex:"status",label:"sw-review.list.columnStatus",align:"center"},{property:"comment",dataIndex:"comment",label:"sw-review.list.columnComment",align:"center"}]},repository(){return this.repositoryFactory.create("product_review")},criteria(){const e=new t(this.page,this.limit);return e.setTerm(this.term),e.addAssociation("customer"),e.addAssociation("product"),e.addAssociation("salesChannel"),e.addAssociation("language"),this.sortBy.split(",").forEach(i=>{e.addSorting(t.sort(i,this.sortDirection,this.naturalSorting))}),e},dateFilter(){return Shopware.Filter.getByName("date")}},created(){this.createdComponent()},methods:{createdComponent(){this.getList()},async getList(){this.isLoading=!0;const e=await Shopware.Service("filterService").mergeWithStoredFilters(this.storeKey,this.criteria);this.activeFilterNumber=e.filters.length;const i={...Shopware.Context.api,inheritance:!0};return this.repository.search(e,i).then(r=>{this.total=r.total,this.items=r}).finally(()=>{this.isLoading=!1})},updateCriteria(e){this.page=1,this.criteria.filters=e,this.getList()},onDelete(e){this.$refs.listing.deleteItem(e),this.repository.search(this.criteria,{...Shopware.Context.api,inheritance:!0}).then(i=>{this.total=i.total,this.items=i})}}};export{o as default};
