const c=`{% block sw_advanced_selection_rule %} <sw-entity-advanced-selection-modal class="sw-advanced-selection-rule" entity-name="rule" :entity-display-text="$tc('global.sw-entity-advanced-selection-modal.entity.rule')" store-key="advancedSelection.rule" :entity-context="context" :entity-columns="columns" :entity-filters="filters" :criteria-aggregations="aggregations" :entity-associations="associations" :is-record-selectable-callback="isRecordSelectable" :disable-previews="true" empty-icon="solid-products" v-bind="$attrs" @selection-submit="$emit('selection-submit', $event)" @modal-close="$emit('modal-close', $event)" > {% block sw_advanced_selection_rule__list_grid_columns_name %} <template #column-name="{ item }"> {% block sw_advanced_selection_rule__list_grid_columns_name_content %} <span :class="getColumnClass(item)"> {{ item.name }} </span> {% endblock %} </template> {% endblock %} {% block sw_advanced_selection_rule__list_grid_columns_priority %} <template #column-priority="{ item }"> {% block sw_advanced_selection_rule__list_grid_columns_priority_content %} <span :class="getColumnClass(item)"> {{ item.priority }} </span> {% endblock %} </template> {% endblock %} {% block sw_advanced_selection_rule__list_grid_columns_description %} <template #column-description="{ item }"> {% block sw_advanced_selection_rule__list_grid_columns_description_content %} <span :class="getColumnClass(item)"> {{ item.description }} </span> {% endblock %} </template> {% endblock %} {% block sw_advanced_selection_rule_list_grid_columns_invalid %} <template #column-invalid="{item}"> {% block sw_advanced_selection_rule_list_grid_columns_invalid_content %} <span :class="getColumnClass(item)"> <template v-if="item.invalid"> {{ $tc('sw-settings-rule.list.invalid') }} </template> <template v-else> {{ $tc('sw-settings-rule.list.valid') }} </template> </span> {% endblock %} </template> {% endblock %} {% block sw_advanced_selection_rule_list_grid_columns_create_date %} <template #column-updatedAt="{item}"> {% block sw_advanced_selection_rule_list_grid_columns_create_date_content %} <span :class="getColumnClass(item)"> <template v-if="item.updatedAt"> <sw-time-ago :date="item.updatedAt" :date-time-format="{ month: '2-digit', day: '2-digit' }" /> </template> <template v-else> <sw-time-ago :date="item.createdAt" :date-time-format="{ month: '2-digit', day: '2-digit' }" /> </template> </span> {% endblock %} </template> {% endblock %} {% block sw_advanced_selection_rule_list_grid_columns_tags %} <template #column-tags="{ item }"> <span :class="getColumnClass(item)"> <span class="sw-data-grid__cell-value"> <template v-if="item.tags.length > 0"> <sw-label v-for="tag in item.tags" :key="tag.id" size="medium" > {% block sw_advanced_selection_rule_list_grid_columns_tags_content %} {{ tag.name }} {% endblock %} </sw-label> </template> <template v-else> - </template> </span> </span> </template> {% endblock %} {% block sw_advanced_selection_rule_list_grid_columns_assignments %} <template v-for="(propertyName, index) in assignmentProperties" #[\`column-\${propertyName}\`]="{ item, aggregations }" :key="index" > <span class="sw-data-grid__cell-value" > {{ getCounts(item.id, aggregations)[propertyName] }} {{ $tc(\`sw-settings-rule.list.assignments.\${propertyName}\`, getCounts(item.id, aggregations)[propertyName]) }} </span> </template> {% endblock %} </sw-entity-advanced-selection-modal> {% endblock %}`,{Criteria:n}=Shopware.Data,d={template:c,inject:["ruleConditionDataProviderService","feature"],emits:["selection-submit","modal-close"],props:{ruleAwareGroupKey:{type:String,required:!0},restrictedRuleIds:{type:Array,required:!1,default(){return[]}},restrictedRuleIdsTooltipLabel:{type:String,required:!1,default(){return""}}},computed:{getRuleDefinition(){return Shopware.EntityDefinition.get("rule")},assignmentProperties(){const t=[];return Object.keys(this.getRuleDefinition.properties).forEach(e=>{if(e==="conditions"||e==="tags")return;const i=this.getRuleDefinition.properties[e];(i.relation==="many_to_many"||i.relation==="one_to_many")&&t.push(e)}),t},context(){return Shopware.Context.api},columns(){const t=[{property:"name",dataIndex:"name",inlineEdit:"string",label:"sw-settings-rule.list.columnName",routerLink:"sw.settings.rule.detail",width:"250px",allowResize:!0,primary:!0},{property:"priority",label:"sw-settings-rule.list.columnPriority",inlineEdit:"number",allowResize:!0},{property:"description",label:"sw-settings-rule.list.columnDescription",width:"250px",allowResize:!0},{property:"updatedAt",label:"sw-settings-rule.list.columnDateCreated",align:"right",allowResize:!0},{property:"invalid",label:"sw-product-stream.list.columnStatus",allowResize:!0},{property:"tags",label:"sw-settings-rule.list.columnTags",width:"250px",allowResize:!0,sortable:!1,visible:!1}];return this.assignmentProperties.forEach(e=>{const i=e.charAt(0).toUpperCase()+e.slice(1);t.push({property:`${e}`,label:`sw-settings-rule.list.column${i}`,width:"250px",allowResize:!0,sortable:!0,visible:!1})}),t},filters(){return{conditionGroups:{property:"conditions.type",label:this.$tc("sw-settings-rule.filter.groupFilter.label"),placeholder:this.$tc("sw-settings-rule.filter.groupFilter.placeholder"),type:"multi-select-filter",options:this.groupFilterOptions},conditions:{property:"conditions.type",label:this.$tc("sw-settings-rule.filter.conditionFilter.label"),placeholder:this.$tc("sw-settings-rule.filter.conditionFilter.placeholder"),type:"multi-select-filter",options:this.conditionFilterOptions},assignments:{existingType:!0,property:"conditions",label:this.$tc("sw-settings-rule.filter.assignmentFilter.label"),placeholder:this.$tc("sw-settings-rule.filter.assignmentFilter.placeholder"),type:"multi-select-filter",options:this.associationFilterOptions},tags:{property:"tags",label:this.$tc("sw-settings-rule.filter.tagFilter.label"),placeholder:this.$tc("sw-settings-rule.filter.tagFilter.placeholder"),criteria:new n(1,25).addSorting(n.sort("name"))}}},conditionFilterOptions(){const t=this.ruleConditionDataProviderService.getConditions().map(e=>({value:e.type,label:this.$tc(e.label)}));return t.sort((e,i)=>e.label.localeCompare(i.label)),t},groupFilterOptions(){const t=[];return Object.values(this.ruleConditionDataProviderService.getGroups()).forEach(e=>{const i=this.ruleConditionDataProviderService.getByGroup(e.id).map(s=>s.type).join("|");t.push({value:i,label:this.$tc(e.name)})}),t.sort((e,i)=>e.label.localeCompare(i.label)),t},associationFilterOptions(){const t=[];return Object.entries(this.getRuleDefinition.properties).forEach(([e,i])=>{i.type==="association"&&e!=="conditions"&&e!=="tags"&&t.push({value:e,label:this.$tc(`sw-settings-rule.filter.assignmentFilter.values.${e}`)})}),t.sort((e,i)=>e.label.localeCompare(i.label)),t},associations(){const t=["tags"];return t.push("conditions"),t},aggregations(){const t=[];return Object.keys(this.getRuleDefinition.properties).forEach(e=>{if(e==="conditions"||e==="tags")return;const i=this.getRuleDefinition.properties[e];(i.relation==="many_to_many"||i.relation==="one_to_many")&&t.push(n.terms(e,"id",null,null,n.count(e,`rule.${e}.id`)))}),t},dateFilter(){return Shopware.Filter.getByName("date")}},methods:{getColumnClass(t){return this.isRestricted(t)?"sw-advanced-selection-rule-disabled":""},tooltipConfig(t){return this.restrictedRuleIds.includes(t.id)?{message:this.restrictedRuleIdsTooltipLabel,disabled:!1}:this.ruleConditionDataProviderService.getRestrictedRuleTooltipConfig(t.conditions,this.ruleAwareGroupKey)},isRestricted(t){const e=this.restrictedRuleIds.includes(t.id);return this.ruleConditionDataProviderService.isRuleRestricted(t.conditions,this.ruleAwareGroupKey)||e},isRecordSelectable(t){const e=this.isRestricted(t);return e?{isSelectable:!e,tooltip:this.tooltipConfig(t)}:{}},getCounts(t,e){const i={};return e===void 0||Object.keys(this.getRuleDefinition.properties).forEach(s=>{var r;if(s==="conditions"||s==="tags")return;const o=this.getRuleDefinition.properties[s];if(o.relation==="many_to_many"||o.relation==="one_to_many"){const l=(r=e[s])==null?void 0:r.buckets.filter(a=>a.key===t)[0];if(!l||!l[s]||!l[s].count){i[s]=0;return}i[s]=l[s].count}}),i}}};export{d as default};
