const n=`{% block sw_promotion_v2_settings_discount_type %} <div class="sw-promotion-v2-settings-discount-type"> <sw-container columns="1fr 1fr" gap="20px" > {% block sw_promotion_v2_settings_discount_type_type %} <mt-select v-model="discount.type" class="sw-promotion-v2-settings-discount-type__field-select-discount-type" :label="$tc('sw-promotion-v2.detail.discounts.settings.discountType.labelDiscountType')" :disabled="!acl.can('promotion.editor')" :options="discountTypeOptions" /> {% endblock %} {% block sw_promotion_v2_settings_discount_type_price %} <mt-number-field v-model="discount.value" class="sw-promotion-v2-settings-discount-type__field-price" :id-suffix="discount.id" :min="0" :max="discount.type === 'percentage' ? 100 : null" :label="labelValue" :disabled="discount.type === 'free' || !acl.can('promotion.editor')" > {% block sw_promotion_v2_settings_discount_type_price_suffix %} <template #suffix> <span v-if="isPercentageType">%</span> <span v-else>{{ currencySymbol }}</span> </template> {% endblock %} </mt-number-field> {% endblock %} </sw-container> <sw-container columns="1fr 1fr" gap="20px" > {% block sw_promotion_v2_settings_discount_type_apply_discount_to %} <mt-select v-model="discount.applierKey" class="sw-promotion-v2-settings-discount-type__field-apply-discount-to" :label="$tc('sw-promotion-v2.detail.discounts.settings.discountType.labelApplyDiscountTo')" :disabled="discount.type === 'free' || !acl.can('promotion.editor')" :options="applierOptions" /> {% endblock %} {% block sw_promotion_v2_settings_discount_type_max_discount_value %} <mt-number-field v-model="discount.maxValue" class="sw-promotion-v2-settings-discount-type__field-max-discount" :id-suffix="discount.id" :label="$tc('sw-promotion-v2.detail.discounts.settings.discountType.labelMaxDiscountValue')" :disabled="discount.type !== 'percentage' || !acl.can('promotion.editor')" allow-empty @update:model-value="onMaxValueChanged" > {% block sw_promotion_v2_settings_discount_type_max_discount_value_suffix %} <template #suffix> <span>{{ currencySymbol }}</span> </template> {% endblock %} </mt-number-field> {% endblock %} </sw-container> {% block sw_promotion_v2_settings_discount_type_advanced_prices_link %} <a v-if="showAdvancedPricesLink" class="sw-promotion-v2-settings-discount-type__advanced-prices" role="button" tabindex="0" @click="onClickAdvancedPrices" @keydown.enter="onClickAdvancedPrices" > {{ $tc('sw-promotion-v2.detail.discounts.pricesModal.linkAdvancedPrices') }} <mt-icon name="regular-long-arrow-right" size="16px" /> </a> {% endblock %} {% block sw_promotion_v2_settings_discount_type_advanced_prices_modal %} <sw-modal v-if="displayAdvancedPricesModal" :title="$tc('sw-promotion-v2.detail.discounts.pricesModal.advancedPricesHeader')" class="sw-promotion-v2-settings-discounts-type__advanced-prices-modal" @modal-close="onCloseAdvancedPricesModal" > {% block sw_promotion_v2_settings_discount_type_advanced_prices_modal_grid %} <sw-one-to-many-grid :collection="discount.promotionDiscountPrices" :local-mode="true" :columns="currencyPriceColumns" :show-selection="false" :show-actions="!acl.can('promotion.editor')" > {% block sw_promotion_v2_settings_discount_type_advanced_prices_modal_grid_column_name %} <template #column-currency.translated.name="{ item }"> <p class="sw-promotion-v2-settings-discounts-type__advances-prices-column-name"> {{ item.currency.translated.name }} </p> </template> {% endblock %} {% block sw_promotion_v2_settings_discount_type_advanced_prices_modal_grid_column_price %} <template #column-price="{ item }"> <mt-number-field v-model="item.price" class="sw-promotion-v2-settings-discounts-type__advanced-prices-column-price" type="text" size="small" :disabled="!acl.can('promotion.editor')" > {% block sw_promotion_v2_settings_discount_type_advanced_prices_modal_grid_column_price_suffix %} <template #suffix> {{ item.currency.symbol }} </template> {% endblock %} </mt-number-field> </template> {% endblock %} </sw-one-to-many-grid> {% endblock %} {% block sw_promotion_v2_settings_discount_type_advanced_prices_modal_footer %} <template #modal-footer> {% block sw_promotion_v2_settings_discount_type_advanced_prices_modal_footer_button_close %} <mt-button variant="primary" size="small" @click="onCloseAdvancedPricesModal" > {{ $tc('sw-promotion-v2.detail.discounts.pricesModal.closeModal') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} </div> {% endblock %}`,{Criteria:o}=Shopware.Data,c={template:n,inject:["acl","repositoryFactory"],props:{discount:{type:Object,required:!0},discountScope:{type:String,required:!0,validator(e){return["basic","buy-x-get-y","shipping-discount"].includes(e)}},preselectedDiscountType:{type:String,required:!1,validator(e){return["fixed","fixed_unit","percentage","free"].includes(e)},default(){return"fixed"}},preselectedApplyDiscountTo:{type:String,required:!1,validator(e){return["ALL","SELECT"].includes(e)},default(){return"ALL"}}},data(){return{displayAdvancedPricesModal:!1,currencies:[],defaultCurrency:null,currencySymbol:null}},computed:{isPercentageType(){return["percentage","free"].includes(this.discount.type)},labelValue(){return this.$tc("sw-promotion-v2.detail.discounts.settings.discountType.labelValue",{},!this.isPercentageType)},showAdvancedPricesLink(){return["absolute","fixed","fixed_unit"].includes(this.discount.type)},currencyPriceColumns(){return[{property:"currency.translated.name",label:this.$tc("sw-promotion-v2.detail.discounts.pricesModal.labelCurrency")},{property:"price",dataIndex:"price",label:this.$tc("sw-promotion-v2.detail.discounts.pricesModal.labelPrice")}]},currencyRepository(){return this.repositoryFactory.create("currency")},advancedPricesRepo(){return this.repositoryFactory.create("promotion_discount_prices")},currencyCriteria(){return new o(1,25).addSorting(o.sort("name","ASC"))},showMaxValueAdvancedPrices(){return this.discount.type==="percentage"&&this.discount.maxValue!==null},discountTypeOptions(){return this.getApplyDiscountToSelection().map(e=>({id:e.value,value:e.value,label:e.display}))},applierOptions(){return this.getApplyDiscountToSelection().map(e=>({id:e.value,value:e.value,label:e.display}))}},watch:{"discount.type"(e,t){if(t==="percentage"&&(this.discount.maxValue=null),e==="free"){this.discount.applierKey="SELECT",this.discount.value=100;return}e==="absolute"?(this.discount.applierKey="SELECT",this.discount.usageKey="ALL"):e==="percentage"&&(this.discount.value=Math.min(this.discount.value,100))}},created(){this.createdComponent()},methods:{createdComponent(){if(this.currencyRepository.search(this.currencyCriteria).then(t=>{this.currencies=t,this.defaultCurrency=this.currencies.find(i=>i.isSystemDefault),this.currencySymbol=this.defaultCurrency.symbol}),!this.discount.isNew)return;let e={type:this.discount.type||this.preselectedDiscountType,applierKey:this.discount.applierKey||this.preselectedApplyDiscountTo};this.discountScope==="basic"?e={...e,scope:"cart"}:this.discountScope==="buy-x-get-y"?e={...e,scope:"set"}:this.discountScope==="shipping-discount"&&(e={...e,scope:"delivery"}),Object.assign(this.discount,e)},getDiscountTypeSelection(){const e="sw-promotion-v2.detail.discounts.settings.discountType.discountTypeSelection";return[{value:"percentage",display:this.$tc(`${e}.displayPercentage`)},{value:this.discount.scope==="delivery"?"absolute":"fixed",display:this.$tc(`${e}.displayFixedDiscount`)},{value:"fixed_unit",display:this.$tc(`${e}.displayFixedPrice`)},{value:"free",display:this.$tc(`${e}.displayFree`)}]},getApplyDiscountToSelection(){const e="sw-promotion-v2.detail.discounts.settings.discountType.applyDiscountTo";return[{value:"ALL",display:this.$tc(`${e}.displayTotalPrice`)},{value:"SELECT",display:this.$tc(`${e}.displayProductPrice`)}]},onClickAdvancedPrices(){this.currencies.forEach(e=>{this.setCurrencyForDiscountPrices(e)||(this.showMaxValueAdvancedPrices?this.prepareAdvancedPrices(e,this.discount.maxValue):this.prepareAdvancedPrices(e,this.discount.value))}),this.displayAdvancedPricesModal=!0},clearAdvancedPrices(){this.discount.promotionDiscountPrices.getIds().forEach(t=>{this.discount.promotionDiscountPrices.remove(t)})},setCurrencyForDiscountPrices(e){const t=e.id;return this.discount.promotionDiscountPrices.some(i=>i.currencyId===t?(i.currency=e,!0):!1)},prepareAdvancedPrices(e,t=0){const i=Math.max(t*e.factor,0),s=this.advancedPricesRepo.create();Object.assign(s,{discountId:this.discount.id,price:i,currencyId:e.id,currency:e}),this.discount.promotionDiscountPrices.add(s)},onMaxValueChanged(e){e!==null&&e!==0||(e===0&&(this.discount.maxValue=null),this.clearAdvancedPrices())},onCloseAdvancedPricesModal(){if(this.discount.type==="percentage"&&this.discount.maxValue===null){this.clearAdvancedPrices(),this.displayAdvancedPricesModal=!1;return}this.discount.promotionDiscountPrices.forEach(e=>{this.discount.type==="percentage"&&(e.price=e.price>100?this.getMaxValue(this.discount.type):e.price),e.price<=0&&(e.price=0),e.price=Math.max(e.price,0)}),this.displayAdvancedPricesModal=!1}}};export{c as default};
