const p=`{% block sw_product_variant_modal %} <sw-modal class="sw-product-variant-modal" :title="modalTitle" variant="full" @modal-close="$emit('modal-close')" > {% block sw_product_variant_modal_body %} {% block sw_product_variant_modal_toolbar %} <div class="sw-configuration-option-list__toolbar"> {% block sw_product_variant_modal_toolbar_container %} <sw-container columns="1fr minmax(50px, max-content)" gap="0 16px" > {% block sw_product_variant_modal_body_label_search %} <sw-simple-search-field v-model:value="searchTerm" class="sw-product-variant-modal__search" size="small" variant="form" @search-term-change="onSearchTermChange" /> {% endblock %} {% block sw_product_variant_modal_option_list_toolbar_container_filter_list %} <div class="sw-product-variant-modal__filter-list-button"> {% block sw_product_variant_modal_option_list_toolbar_container_filter_list_button %} <mt-button class="sw-product-variant-modal__button-filter" variant="secondary" @click="toggleFilterMenu" > {{ $tc('sw-product.variations.generatedFilterList') }} <mt-icon name="regular-filter" size="16" /> </mt-button> {% endblock %} {% block sw_product_variant_modal_option_list_toolbar_container_filter_context_menu %} <sw-context-menu v-show="filterWindowOpen" class="sw-product-variant-modal__filter-context-menu" > <sw-container columns="1fr" gap="5px" > {% block sw_product_variant_modal_option_list_toolbar_container_filter_tree %} <sw-tree v-show="filterOptions.length" :sortable="false" :items="filterOptions" :searchable="false" disable-context-menu bind-items-to-folder > <template #items="{ treeItems, sortable, draggedItem, disableContextMenu, onChangeRoute, checkItem}"> <sw-tree-item v-for="(item, index) in treeItems" :key="item.id" :sortable="false" :item="item" disable-context-menu @check-item="filterOptionChecked" /> </template> </sw-tree> {% endblock %} {% block sw_product_variant_modal_option_list_toolbar_container_filter_buttons %} <div class="sw-product-variant-modal__filter-buttons"> {% block sw_product_variant_modal_option_list_toolbar_container_button_filter_reset %} <mt-button class="sw-product-variant-modal__reset-filter" variant="secondary" @click="resetFilterOptions" > {{ $tc('sw-product.variations.overview.filterReset') }} </mt-button> {% endblock %} {% block sw_product_variant_modal_option_list_toolbar_container_button_update_list %} <mt-button variant="primary" @click="fetchProductVariants" > {{ $tc('sw-product.variations.overview.filter') }} </mt-button> {% endblock %} </div> {% endblock %} </sw-container> </sw-context-menu> {% endblock %} </div> {% endblock %} </sw-container> {% endblock %} </div> {% endblock %} {% block sw_product_variant_modal_body_grid %} <sw-data-grid v-if="productVariants.length > 0" ref="variantGrid" :is-loading="isLoading" :columns="gridColumns" :data-source="productVariants" :sort-by="sortBy" :sort-direction="sortDirection" :allow-inline-edit="acl.can('product.editor')" show-settings @column-sort="onSortColumn" @inline-edit-save="onInlineEditSave" @inline-edit-cancel="onInlineEditCancel" > {% block sw_product_variant_modal_body_grid_bulk %} <template #bulk> {% block sw_product_variant_modal_body_grid_bulk_edit %} <span v-if="acl.can('product.editor')" class="link link-primary sw-product-variant-modal__bulk-edit-action" role="link" tabindex="0" @click="toggleBulkEditModal" > {{ $tc('global.default.bulkEdit') }} </span> {% endblock %} {% block sw_product_variant_modal_body_grid_bulk_delete %} <span v-if="acl.can('product.deleter')" class="link link-danger sw-product-variant-modal__bulk-delete-action" role="link" tabindex="0" @click="onClickBulkDelete" > {{ $tc('global.default.delete') }} </span> {% endblock %} </template> {% endblock %} {% block sw_product_variant_modal_bulk_edit_modal %} <template #bulk-modals="{ selection }"> <sw-bulk-edit-modal v-if="showBulkEditModal" class="sw-product-variant-modal__bulk-edit-modal" :selection="selection" :bulk-grid-edit-columns="gridColumns" @edit-items="onEditItems" @modal-close="toggleBulkEditModal" > {% block sw_product_variant_modal_bulk_edit_modal_column_name %} <template #column-name="{ item }"> <sw-media-preview-v2 :source="getItemMedia(item)" /> <router-link :to="{ name: 'sw.product.detail', params: { id: item.id } }"> <span v-if="item.translated.name" class="sw-product-variant-modal__variant-name" > {{ item.translated.name }} </span> <sw-product-variant-info v-else class="sw-product-variant-modal__variant-options" :variations="item.variation" :show-tooltip="false" :ommit-parenthesis="true" seperator=", " /> </router-link> <sw-product-variant-info v-if="item.translated.name" :variations="item.variation" :show-tooltip="false" /> <sw-label v-if="variantIsDigital(item)" class="sw-product-variant-modal__digital-indicator" > {{ $tc('sw-product.variations.generatedListColumnContentProductState.is-download') }} </sw-label> </template> {% endblock %} {% block sw_product_variant_modal_bulk_edit_modal_column_price %} <template #column-price="{ item }"> <sw-inheritance-switch class="sw-product-variant-modal__price-inheritance-switch" :is-inherited="item.price === null" disabled /> <sw-price-preview :value="item.price ? item.price : []" :default-price="productEntity.price[0]" :tax-rate="productEntity.tax" :currency="currency" /> </template> {% endblock %} {% block sw_product_variant_modal_bulk_edit_modal_column_stock %} <template #column-stock="{ item }"> {{ item.stock }} <sw-color-badge :variant="stockColorVariantFilter(item.stock)" /> </template> {% endblock %} {% block sw_product_variant_modal_bulk_edit_modal_column_active %} <template #column-active="{ item }"> <mt-icon v-if="item.active === true" class="mt-icon--product-status is--active" name="regular-checkmark-xs" size="16px" /> <mt-icon v-else-if="item.active === false" class="mt-icon--product-status is--inactive" name="regular-times-s" size="16px" /> <mt-icon v-else key="inherit-icon" name="regular-link-horizontal" size="16" /> </template> {% endblock %} {% block sw_product_variant_modal_bulk_edit_modal_column_media %} <template #column-media="{ item }"> <sw-inheritance-switch class="sw-product-variant-modal__media-inherited-icon" :is-inherited="isMediaFieldInherited(item)" disabled /> <sw-product-variants-media-upload :source="item" :upload-tag="item.id" :is-inherited="isMediaFieldInherited(item)" :parent-product="productEntity" disabled /> </template> {% endblock %} </sw-bulk-edit-modal> </template> {% endblock %} {% block sw_product_variant_modal_body_grid_column_name %} <template #column-name="{item, isInlineEdit}"> {% block sw_product_variant_modal_body_grid_column_name_inline_edit %} <mt-text-field v-if="isInlineEdit" v-model="item.name" :placeholder="$tc('sw-product.list.variantModalInlineEditProductNamePlaceholder')" size="small" /> {% endblock %} {% block sw_product_variant_modal_body_grid_column_name_content %} <template v-else> {% block sw_product_variant_modal_body_grid_column_name_content_media_preview %} <sw-media-preview-v2 :source="getItemMedia(item)" /> {% endblock %} {% block sw_product_variant_modal_body_grid_column_name_content_name %} <router-link :to="{ name: 'sw.product.detail', params: { id: item.id } }"> <span v-if="item.translated.name" class="sw-product-variant-modal__variant-name" > {{ item.translated.name }} </span> <sw-product-variant-info v-else class="sw-product-variant-modal__variant-options" :variations="item.variation" :show-tooltip="false" :ommit-parenthesis="true" seperator=", " /> </router-link> {% endblock %} {% block sw_product_variant_modal_body_grid_column_name_content_options %} <sw-product-variant-info v-if="item.translated.name" :variations="item.variation" :show-tooltip="false" /> {% endblock %} <sw-label v-if="variantIsDigital(item)" class="sw-product-variant-modal__digital-indicator" > {{ $tc('sw-product.variations.generatedListColumnContentProductState.is-download') }} </sw-label> </template> {% endblock %} </template> {% endblock %} {% block sw_product_variant_modal_body_grid_column_price %} <template #column-price="{item, isInlineEdit}"> <template v-if="isInlineEdit"> <sw-inheritance-switch :is-inherited="item.price === null" class="sw-product-variant-modal__price-inheritance-switch" @inheritance-restore="onInheritanceRestore(item, currency)" @inheritance-remove="onInheritanceRemove(item, currency)" /> <sw-price-field :value="item.price ? item.price : []" :default-price="productEntity.price[0]" :tax-rate="productEntity.tax" :label="false" :compact="true" :disable-suffix="true" enable-inheritance :currency="currency" /> </template> <template v-else> <sw-inheritance-switch :is-inherited="item.price === null" class="sw-product-variant-modal__price-inheritance-switch" disabled /> <sw-price-preview :value="item.price ? item.price : []" :default-price="productEntity.price[0]" :tax-rate="productEntity.tax" :currency="currency" /> </template> </template> {% endblock %} {% block sw_product_variant_modal_body_grid_column_stock %} <template #column-stock="{item, isInlineEdit}"> {% block sw_product_variant_modal_body_grid_column_stock_inline_edit %} <mt-number-field v-if="isInlineEdit" v-model="item.stock" :placeholder="$tc('sw-product.list.variantModalInlineEditStockPlaceholder')" size="small" /> {% endblock %} {% block sw_product_variant_modal_body_grid_column_stock_content %} <template v-else> {{ item.stock }} <sw-color-badge :variant="stockColorVariantFilter(item.stock)" /> </template> {% endblock %} </template> {% endblock %} {% block sw_product_variant_modal_body_grid_column_active %} <template #column-active="{item, isInlineEdit}"> {% block sw_product_variant_modal_body_grid_column_active_inline_edit %} <template v-if="isInlineEdit"> <mt-checkbox v-model:checked="item.active" :disabled="item.active === null" /> <sw-inheritance-switch :is-inherited="item.active === null" class="sw-product-variant-modal__active-inheritance-switch" @inheritance-restore="item.active = null" @inheritance-remove="item.active = true" /> </template> {% endblock %} {% block sw_product_variant_modal_body_grid_column_active_content %} <template v-else> {% block sw_product_variant_modal_body_grid_column_active_content_icon_active %} <mt-icon v-if="item.active === true" name="regular-checkmark-xs" size="16px" class="mt-icon--product-status is--active" /> {% endblock %} {% block sw_product_variant_modal_body_grid_column_active_content_icon_not_active %} <mt-icon v-else-if="item.active === false" name="regular-times-s" size="16px" class="mt-icon--product-status is--inactive" /> {% endblock %} <mt-icon v-else key="inherit-icon" name="regular-link-horizontal" size="16" /> </template> {% endblock %} </template> {% endblock %} {% block sw_product_variant_modal_body_grid_column_media %} <template #column-media="{ item, isInlineEdit, compact }" > {% block sw_product_variant_modal_body_grid_column_media_inline_edit %} {% block sw_product_variant_modal_body_grid_column_media_inherit %} <sw-inheritance-switch :is-inherited="isMediaFieldInherited(item)" :disabled="!isInlineEdit" class="sw-product-variant-modal__media-inherited-icon" @inheritance-restore="onMediaInheritanceRestore(item, isInlineEdit)" @inheritance-remove="onMediaInheritanceRemove(item, isInlineEdit)" /> {% endblock %} {% block sw_product_variant_modal_body_grid_column_media_content %} <sw-product-variants-media-upload :source="item" :upload-tag="item.id" :is-inherited="isMediaFieldInherited(item)" :disabled="isInlineEdit ? isMediaFieldInherited(item) : true" :parent-product="productEntity" /> {% endblock %} {% endblock %} </template> {% endblock %} {% block sw_product_variant_modal_body_grid_actions %} <template #actions="{item}"> {% block sw_product_variant_modal_body_grid_actions_edit %} <sw-context-menu-item @click="visitProduct(item.id)"> {{ contextMenuEditText }} </sw-context-menu-item> {% endblock %} {% block sw_product_variant_modal_body_grid_actions_delete %} <sw-context-menu-item v-tooltip.left="getNoPermissionsTooltip('product.deleter')" variant="danger" :disabled="!acl.can('product.deleter')" @click="onDeleteVariant(item)" > {{ $tc('global.default.delete') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} {% block sw_product_variant_modal_body_grid_pagination %} <template #pagination> <sw-pagination v-if="productVariants.length !== 0" ref="pagination" :page="paginationPage" :limit="paginationLimit" :total="productVariants.total" @page-change="onPageChange" /> </template> {% endblock %} </sw-data-grid> {% endblock %} {% block sw_product_variant_modal_body_empty_state %} <mt-empty-state v-else :icon="$route.meta.$module.icon" :headline="$tc('sw-product.list.variantGridEmptyStateSubline')" /> {% endblock %} {% block sw_product_variant_modal_body_delete_modal %} <sw-modal v-if="showDeleteModal" class="sw-product-variant-modal__delete-modal" :title="$tc('sw-product.list.variantDeleteModalTitle')" variant="small" @modal-close="closeDeleteModal" > {% block sw_product_variant_modal_body_delete_modal_body_multiple %} <template v-if="toBeDeletedVariants.length > 1"> {% block sw_product_variant_modal_body_delete_modal_body_multiple_text %} <p>{{ $t('sw-product.list.multipleVariantsDeleteModalText', { amount: toBeDeletedVariants.length }) }}</p> {% endblock %} {% block sw_product_variant_modal_body_delete_modal_body_multiple_subline %} <p class="sw-product-variant-modal__delete-modal-subline"> ({{ $tc('sw-product.list.multipleVariantsDeleteModalSubline') }}) </p> {% endblock %} </template> {% endblock %} {% block sw_product_variant_modal_body_delete_modal_body_single %} <p v-else> {{ $t('sw-product.list.variantDeleteModalText', { variantName: buildVariantName(toBeDeletedVariants[0]) }) }} </p> {% endblock %} {% block sw_product_variant_modal_body_delete_modal_footer %} <template #modal-footer> {% block sw_product_variant_modal_body_delete_modal_footer_close %} <mt-button size="small" variant="secondary" @click="closeDeleteModal" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_product_variant_modal_body_delete_modal_footer_confirm %} <sw-button-process variant="danger" size="small" :animation-timeout="750" :process-success="isDeletionOver" :is-loading="isDeleteButtonLoading" @click="deleteVariants" @update:process-success="closeDeleteModal" > {{ $tc('global.default.delete') }} </sw-button-process> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} {% endblock %} {% block sw_product_variant_modal_footer %} <template #modal-footer> {% block sw_product_variant_modal_footer_visit_main_product %} <div class="sw-product-variant-modal__main-product-link" role="button" tabindex="0" @click="visitProduct(productEntity.id)" > {{ openMainProductText }} </div> {% endblock %} {% block sw_product_variant_modal_footer_close_button %} <mt-button size="small" variant="secondary" @click="$emit('modal-close')" > {{ $tc('global.sw-modal.labelClose') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %}`,{Mixin:m,Context:_}=Shopware,{Criteria:r}=Shopware.Data,h={template:p,inject:["repositoryFactory","acl"],emits:["modal-close"],mixins:[m.getByName("notification")],props:{productEntity:{type:Object,required:!0}},data(){return{productVariants:[],currency:null,paginationLimit:25,paginationPage:1,toBeDeletedVariants:[],showDeleteModal:!1,searchTerm:"",isDeleteButtonLoading:!1,isDeletionOver:!1,sortDirection:"ASC",sortBy:"productNumber",isLoading:!1,groups:[],filterOptions:[],includeOptions:[],filterWindowOpen:!1,showBulkEditModal:!1}},computed:{modalTitle(){return this.$t("sw-product.list.variantModalTitle",{productName:this.productEntity.translated.name})},openMainProductText(){return this.$t("sw-product.list.openMainProduct",{productName:this.productEntity.translated.name})},productRepository(){return this.repositoryFactory.create("product")},productMediaRepository(){return this.repositoryFactory.create("product_media")},productConfigurationRepository(){return this.repositoryFactory.create("product_configurator_setting")},currencyRepository(){return this.repositoryFactory.create("currency")},groupRepository(){return this.repositoryFactory.create("property_group")},contextMenuEditText(){return this.acl.can("product.editor")?this.$tc("global.default.edit"):this.$tc("global.default.view")},filterCriteria(){return this.includeOptions.length<=0?[]:this.includeOptions.reduce((e,i)=>{const o=e.find(a=>a.id===i.groupId);return o?o.options.push(i.id):e.push({id:i.groupId,options:[i.id]}),e},[]).map(e=>r.equalsAny("product.optionIds",e.options))},productVariantCriteria(){const t=new r(this.paginationPage,this.paginationLimit),e=this.productEntity.id;return t.addFilter(r.equals("parentId",e)),this.searchTerm&&t.setTerm(this.searchTerm),t.getAssociation("options").addAssociation("group"),t.addAssociation("cover.media"),t.addAssociation("media.media"),t.addAssociation("tax"),this.searchTerm&&this.searchTerm.split(" ").forEach(o=>{t.addQuery(r.equals("product.options.name",o),3500),t.addQuery(r.contains("product.options.name",o),500)}),this.filterCriteria&&this.filterCriteria.forEach(i=>{t.addFilter(i)}),t.addSorting(r.sort(this.sortBy,this.sortDirection,!0)),t},gridColumns(){var t;return[{property:"name",dataIndex:"name",label:this.$tc("sw-product.list.columnName"),routerLink:"sw.product.detail",inlineEdit:"string",allowResize:!0},{property:"sales",dataIndex:"sales",label:this.$tc("sw-product.list.columnSales"),allowResize:!0,align:"right"},{property:"price",dataIndex:`price.${((t=this.currency)==null?void 0:t.id)||""}.net`,label:"sw-product.list.columnPrice",allowResize:!0,width:"250px",inlineEdit:"number",align:"right"},{property:"stock",dataIndex:"stock",label:"sw-product.list.columnInStock",allowResize:!0,inlineEdit:"number",align:"right"},{property:"active",dataIndex:"active",label:"sw-product.list.columnActive",allowResize:!0,inlineEdit:"boolean",align:"center"},{property:"productNumber",dataIndex:"productNumber",label:"sw-product.list.columnProductNumber",allowResize:!0,align:"right"},{property:"media",dataIndex:"media",label:this.$tc("sw-product.list.columnMedia"),allowResize:!0,inlineEdit:!0,sortable:!1}]},canBeDeletedCriteria(){const t=new r(1,25),e=this.toBeDeletedVariants.map(i=>i.id);return t.addFilter(r.equalsAny("canonicalProductId",e)),t},groupCriteria(){return new r(1,100)},selectedGroups(){var e,i;const t=(e=this.productEntity)==null?void 0:e.configuratorSettings.reduce((o,a)=>(o.indexOf(a.option.groupId)<0&&o.push(a.option.groupId),o),[]);return(i=this.groups)==null?void 0:i.filter(o=>t.indexOf(o.id)>=0)},filterOptionsListing(){const t=[...this.selectedGroups].sort((i,o)=>i.position-o.position).map((i,o)=>{const a=this.getOptionsForGroup(i.id);return{id:i.id,name:i.name,childCount:a.length,parentId:null,afterId:o>0?this.selectedGroups[o-1].id:null,storeObject:i}}),e=t.reduce((i,o)=>{const a=this.getOptionsForGroup(o.id),d=a.sort((n,s)=>n.position-s.position).map((n,s)=>{const l=n.option;let c=null;return s>0&&(c=a[s-1].option.id),{id:l.id,name:l.name,childCount:0,parentId:l.groupId,afterId:c,storeObject:n}});return[...i,...d]},[]);return[...t,...e]},stockColorVariantFilter(){return Shopware.Filter.getByName("stockColorVariant")}},watch:{selectedGroups(){this.filterOptions=this.filterOptionsListing}},created(){this.createdComponent()},methods:{createdComponent(){return this.isLoading=!0,Promise.all([this.fetchProductMedias(),this.fetchProductConfiguration(),this.fetchProductVariants(),this.fetchSystemCurrency(),this.loadGroups()]).finally(()=>{this.isLoading=!1})},fetchProductMedias(){const t=new r;return t.addFilter(r.equals("productId",this.productEntity.id)),this.productMediaRepository.search(t).then(e=>{this.productEntity.media=e})},fetchProductConfiguration(){const t=new r;return t.addAssociation("option"),t.addFilter(r.equals("productId",this.productEntity.id)),this.productConfigurationRepository.search(t).then(e=>{this.productEntity.configuratorSettings=e})},fetchSystemCurrency(){const t=Shopware.Context.app.systemCurrencyId;return this.currencyRepository.get(t).then(e=>{this.currency=e})},fetchProductVariants(){return this.isLoading=!0,this.productRepository.search(this.productVariantCriteria).then(t=>{this.productVariants=t}).finally(()=>{this.isLoading=!1})},getDefaultPriceForVariant(t){return t.price?t.price.find(i=>i.currencyId===this.defaultCurrency.id)||this.defaultPrice:this.defaultPrice},onInheritanceRestore(t,e){if(!t.price)return;const i=t.price.findIndex(o=>o.currencyId===e.id);i>=0&&delete t.price[i],t.price.length<=0&&(t.price=null)},onInheritanceRemove(t,e){t.price||(t.price=[]);const i=this.productEntity.price[0],o={currencyId:e.id,gross:i.gross*e.factor,linked:i.linked,net:i.net*e.factor};t.price.push(o)},sortOptions(t){return[...t].sort((i,o)=>i.position===o.position?i.name>o.name?1:-1:i.position>o.position?1:-1)},buildVariantOptions(t,e=", ",i=!1,o=!1){const a=t.options,n=this.sortOptions(a).reduce((s,l)=>{const c=l.translated.name,u=l.group.translated.name;return s.concat(o?"":u,o?"":": ",c,e)},"").slice(0,-e.length);return i?n:`(${n})`},buildVariantName(t){const e=this.buildVariantOptions(t);return`${t.translated.name||this.productEntity.translated.name} ${e}`},getVariantPrice(t){const e=t.price;return e?e[0]:this.productEntity.price[0]},onPageChange({limit:t=25,page:e=1}){this.paginationLimit=t,this.paginationPage=e,this.fetchProductVariants()},visitProduct(t){this.$emit("modal-close"),this.$nextTick().then(()=>{this.$router.push({name:"sw.product.detail",params:{id:t}})})},getItemMedia(t){return t.cover?t.cover.media:this.productEntity.cover?this.productEntity.cover.media:null},deleteVariants(){this.isDeleteButtonLoading=!0;const t=this.toBeDeletedVariants.map(o=>o.id),e=this.toBeDeletedVariants[0].translated.name||this.productEntity.translated.name,i=t.length;this.canVariantsBeDeleted().then(o=>{if(!o){this.isDeleteButtonLoading=!1,this.isDeletionOver=!0,this.createNotificationError({message:this.$tc("sw-product.list.notificationVariantDeleteErrorCanonicalUrl",{variantName:e},i)});return}this.productRepository.syncDeleted(t).then(()=>{this.createNotificationSuccess({message:this.$tc("sw-product.list.notificationVariantDeleteSuccess",{variantName:e,amount:i},i)}),this.$refs.variantGrid.resetSelection(),this.fetchProductVariants()}).catch(()=>{this.createNotificationError({message:this.$tc("sw-product.list.notificationVariantDeleteError",{variantName:e,amount:i},i)})}).finally(()=>{this.isDeleteButtonLoading=!1,this.isDeletionOver=!0})})},async canVariantsBeDeleted(){return(await this.productRepository.search(this.canBeDeletedCriteria)).length===0},onInlineEditSave(t){const e=this.buildVariantName(t);this.productRepository.save(t).then(()=>{this.createNotificationSuccess({message:this.$t("sw-product.list.notificationVariantSaveSuccess",{variantName:e})}),this.fetchProductVariants()})},onInlineEditCancel(){this.fetchProductVariants()},onClickBulkDelete(){const t=this.$refs.variantGrid.selection;this.toBeDeletedVariants=Object.values(t),this.showDeleteModal=!0},closeDeleteModal(){this.showDeleteModal=!1,this.toBeDeletedVariants=[],this.isDeletionOver=!1},onDeleteVariant(t){this.toBeDeletedVariants.push(t),this.showDeleteModal=!0},onSearchTermChange(){this.fetchProductVariants()},onSortColumn(t){this.sortBy===t.dataIndex?this.sortDirection=this.sortDirection==="ASC"?"DESC":"ASC":this.sortBy=t.dataIndex,this.fetchProductVariants()},getNoPermissionsTooltip(t,e=!0){return{showDelay:300,message:this.$tc("sw-privileges.tooltip.warning"),appearance:"dark",showOnDisabledElements:e,disabled:this.acl.can(t)}},isMediaFieldInherited(t){return t.forceMediaInheritanceRemove?!1:t.media?t.media.length<=0:!!t.media},onMediaInheritanceRestore(t,e){e&&(t.forceMediaInheritanceRemove=!1,t.coverId=null,t.media.getIds().forEach(i=>{t.media.remove(i)}))},onMediaInheritanceRemove(t,e){e&&(t.forceMediaInheritanceRemove=!0,this.productEntity.media.forEach(({id:i,mediaId:o,position:a,media:d})=>{const n=this.productMediaRepository.create(_.api);Object.assign(n,{mediaId:o,position:a,productId:this.productEntity.id,media:d}),this.productEntity.coverId===i&&(t.coverId=n.id),t.media.push(n)}))},loadGroups(){return this.groupRepository.search(this.groupCriteria).then(t=>{this.groups=t})},resetFilterOptions(){this.filterOptions=[],this.includeOptions=[],this.$nextTick(()=>{this.filterOptions=this.filterOptionsListing,this.fetchProductVariants()})},filterOptionChecked(t){if(t.checked){this.includeOptions.push({id:t.id,groupId:t.parentId});return}this.includeOptions=this.includeOptions.filter(e=>e.id!==t.id)},getOptionsForGroup(t){var e;return(e=this.productEntity)==null?void 0:e.configuratorSettings.filter(i=>!i.isDeleted&&i.option.groupId===t)},toggleFilterMenu(){this.filterWindowOpen=!this.filterWindowOpen},toggleBulkEditModal(){this.showBulkEditModal=!this.showBulkEditModal},async onEditItems(){await this.$nextTick();let t="0";const e=Object.values(this.$refs.variantGrid.selection).filter(i=>i.states.includes("is-download"));e.length>0&&(t=e.filter(i=>i.isCloseout).length!==e.length?"1":"2"),this.$router.push({name:"sw.bulk.edit.product",params:{parentId:this.productEntity.id,includesDigital:t}})},variantIsDigital(t){return t.states&&t.states.includes("is-download")}}};export{h as default};
