const l='{% block sw_category_tree %} <div class="sw-category-tree"> <sw-tree v-if="!isLoadingInitialData" ref="categoryTree" class="sw-category-tree__inner" after-id-property="afterCategoryId" :items="categories" :sortable="sortable" :searchable="false" :active-tree-item-id="categoryId" :translation-context="translationContext" :on-change-route="changeCategory" :disable-context-menu="disableContextMenu" :allow-delete-categories="allowDelete || undefined" initially-expanded-root @batch-delete="deleteCheckedItems" @delete-element="onDeleteCategory" @drag-end="onUpdatePositions" @get-tree-items="onGetTreeItems" @editing-end="syncSiblings" @checked-elements-count="checkedElementsCount" > <template #headline> <span></span> </template> {% block sw_category_tree_items %} <template #items="{ treeItems, sortable, draggedItem, newElementId, checkItem, translationContext, onChangeRoute, disableContextMenu, selectedItemsPathIds, checkedItemIds, }" > <sw-tree-item v-for="item in treeItems" :key="item.id" :item="item" :should-show-active-state="true" :allow-duplicate="false" :allow-new-categories="allowCreate || undefined" :allow-delete-categories="allowDelete || undefined" :active="item.active" :translation-context="translationContext" :on-change-route="onChangeRoute" :sortable="sortable" :dragged-item="draggedItem" :disable-context-menu="disableContextMenu" :display-checkbox="allowEdit || undefined" :context-menu-tooltip-text="contextMenuTooltipText" :new-element-id="newElementId" :get-item-url="getCategoryUrl" :get-is-highlighted="isHighlighted" :active-parent-ids="selectedItemsPathIds" :active-item-ids="checkedItemIds" @check-item="checkItem" /> </template> {% endblock %} </sw-tree> <div v-else> <sw-skeleton variant="tree-item" /> <sw-skeleton variant="tree-item-nested" /> <sw-skeleton variant="tree-item-nested" /> <sw-skeleton variant="tree-item-nested" /> <sw-skeleton variant="tree-item" /> <sw-skeleton variant="tree-item-nested" /> <sw-skeleton variant="tree-item-nested" /> </div> </div> {% endblock %}',{Criteria:s}=Shopware.Data,d={template:l,inject:["repositoryFactory","syncService"],emits:["category-checked-elements-count","unsaved-changes"],mixins:["notification"],props:{categoryId:{type:String,required:!1,default:null},currentLanguageId:{type:String,required:!0},allowEdit:{type:Boolean,required:!1,default:!0},allowCreate:{type:Boolean,required:!1,default:!0},allowDelete:{type:Boolean,required:!1,default:!0}},data(){return{loadedCategories:{},translationContext:"sw-category",linkContext:"sw.category.detail",isLoadingInitialData:!0,loadedParentIds:[],sortable:this.allowEdit}},computed:{categoriesToDelete(){return Shopware.Store.get("swCategoryDetail").categoriesToDelete},categoryRepository(){return this.repositoryFactory.create("category")},category(){return Shopware.Store.get("swCategoryDetail").category},categories(){return Object.values(this.loadedCategories)},disableContextMenu(){return this.allowEdit?this.currentLanguageId!==Shopware.Context.api.systemLanguageId:!0},contextMenuTooltipText(){return this.allowEdit?null:this.$tc("sw-privileges.tooltip.warning")},criteria(){return new s(1,500).addAssociation("navigationSalesChannels").addAssociation("footerSalesChannels").addAssociation("serviceSalesChannels")},criteriaWithChildren(){const e=s.fromCriteria(this.criteria).setLimit(1);return e.associations.push({association:"children",criteria:s.fromCriteria(this.criteria)}),e},cmsPageRepository(){return this.repositoryFactory.create("cms_page")},productRepository(){return this.repositoryFactory.create("product")}},watch:{categoriesToDelete(e){e!==void 0&&(this.$refs.categoryTree.onDeleteElements(e),Shopware.Store.get("swCategoryDetail").categoriesToDelete=void 0)},allowEdit(e){this.sortable=e},category(e,t){if(!t&&this.isLoadingInitialData){this.openInitialTree();return}if(e!==null){if(t&&e.id===t.id){const i=[e.id,...t.navigationSalesChannels.map(r=>r.navigationCategoryId),...t.footerSalesChannels.map(r=>r.footerCategoryId),...t.serviceSalesChannels.map(r=>r.serviceCategoryId)],a=s.fromCriteria(this.criteria).setIds(i.filter((r,o,n)=>r!==null&&n.indexOf(r)===o));this.categoryRepository.search(a).then(r=>{this.addCategories(r)});return}this.loadActiveCategory().then(()=>{this.$refs.categoryTree.openTreeById()})}},currentLanguageId(){this.openInitialTree()}},created(){this.createdComponent()},methods:{createdComponent(){this.category!==null&&this.openInitialTree(),this.categoryId||this.loadRootCategories().finally(()=>{this.isLoadingInitialData=!1})},openInitialTree(){this.isLoadingInitialData=!0,this.loadedCategories={},this.loadedParentIds=[],this.loadRootCategories().then(()=>!this.category||this.category.path===null?(this.isLoadingInitialData=!1,Promise.resolve()):this.loadActiveCategory().then(()=>{this.isLoadingInitialData=!1}))},loadActiveCategory(){if(!this.category||this.category.path===null||this.category.id in this.loadedCategories)return Promise.resolve();const e=this.category.path.split("|").filter(i=>!!i),t=[];return e.forEach(i=>{const a=this.categoryRepository.get(i,Shopware.Context.api,this.criteriaWithChildren).then(r=>{this.addCategories([r,...r.children])});t.push(a)}),Promise.all(t)},onUpdatePositions:Shopware.Utils.debounce(function({draggedItem:t,oldParentId:i,newParentId:a}){t.children.length>0&&(t.children.forEach(r=>{this.removeFromStore(r.id)}),this.loadedParentIds=this.loadedParentIds.filter(r=>r!==t.id)),this.syncSiblings({parentId:a}).then(()=>{i!==a&&this.syncSiblings({parentId:i}).then(()=>{this.syncProducts(t.id)}),this.sortable=this.allowEdit})},400),syncProducts(e){const t=new s(1,50);return t.addFilter(s.multi("or",[s.equals("categoriesRo.id",e),s.equals("categories.id",e)])),this.productRepository.iterateIds(t,this.indexProducts)},indexProducts(e){const t=this.productRepository.buildHeaders();return Shopware.Application.getContainer("init").httpClient.post("/_action/index-products",{ids:e},{headers:t})},checkedElementsCount(e){this.$emit("category-checked-elements-count",e)},async deleteCheckedItems(e){const t=Object.keys(e);if(t.some(r=>{var o,n;return((o=this.loadedCategories[r])==null?void 0:o.navigationSalesChannels)!==null&&((n=this.loadedCategories[r])==null?void 0:n.navigationSalesChannels.length)>0})){this.createNotificationError({message:this.$tc("sw-category.general.errorNavigationEntryPointMultiple")});const r=t.map(o=>this.loadedCategories[o]);t.forEach(o=>{delete this.loadedCategories[o]}),this.$nextTick(()=>{this.addCategories(r)});return}await this.categoryRepository.syncDeleted(t,Shopware.Context.api);const a=t.map(r=>this.loadedCategories[r]);await this.fixSortingForCategories(a),t.forEach(r=>{this.removeFromStore(r)})},onDeleteCategory({data:e,children:t,checked:i}){if(e.isNew())return delete this.loadedCategories[e.id],Promise.resolve();if(this.isErrorNavigationEntryPoint(e)){e.isDeleted=!1,t.length>0&&t.forEach(r=>{r.data.isDeleted=!1});const a=this.getNextCategory(e);return a&&(a.afterCategoryId=e.id),this.loadedCategories={...this.loadedCategories},this.createNotificationError({message:this.entryPointWarningMessage(e)}),Promise.resolve()}return this.categoryRepository.delete(e.id).then(async()=>{if(this.removeFromStore(e.id),e.parentId!==null){const a=await this.categoryRepository.get(e.parentId,Shopware.Context.api,this.criteria);this.addCategory(a)}await this.fixSortingForCategories([e],!0),e.id===this.categoryId&&this.$router.push({name:"sw.category.index"}),i===!0&&(this.$refs.categoryTree.checkedElementsCount-=1,this.$emit("category-checked-elements-count",this.$refs.categoryTree.checkedElementsCount))})},fixSortingForCategories(e,t=!1){const i=[];return e.forEach(a=>{const r=this.getNextCategory(a,t?"afterCategoryId":"id");r&&(r.afterCategoryId=a.afterCategoryId,!e.find(o=>o.id===r.id)&&i.push(r))}),this.categoryRepository.saveAll(i)},getNextCategory(e,t="id"){return Object.values(this.loadedCategories).find(i=>i.parentId===e.parentId&&i.afterCategoryId===e[t])},changeCategory(e){const t={name:"sw.category.detail",params:{id:e.id}};this.category&&this.categoryRepository.hasChanges(this.category)?this.$emit("unsaved-changes",t):this.$router.push(t)},onGetTreeItems(e){if(this.loadedParentIds.includes(e))return Promise.resolve();const t=s.fromCriteria(this.criteria);return t.addFilter(s.equals("parentId",e)),t.setIds([]),this.categoryRepository.search(t).then(i=>{this.addCategories(i),this.loadedParentIds.push(e)})},getChildrenFromParent(e){return this.onGetTreeItems(e)},loadRootCategories(){const e=s.fromCriteria(this.criteria).addFilter(s.equals("parentId",null));return this.categoryRepository.search(e).then(t=>{this.addCategories(t)})},createNewElement(e,t,i=""){this.sortable=!1,!t&&e&&(t=e.parentId);const a=this.createNewCategory(i,t);return this.addCategory(a),a},createNewCategory(e,t){const i=this.categoryRepository.create();return i.name=e,i.parentId=t,i.childCount=0,i.active=!1,i.visible=!0,i.save=()=>this.categoryRepository.save(i).then(()=>{const a=s.fromCriteria(this.criteria).setIds([i.id,t].filter(r=>r!==null));this.categoryRepository.search(a).then(r=>{this.addCategories(r),this.sortable=this.allowEdit})}),i},syncSiblings({parentId:e}){const t=this.categories.filter(i=>i.parentId===e);return this.categoryRepository.sync(t).then(()=>(this.loadedParentIds=this.loadedParentIds.filter(i=>i!==e),this.getChildrenFromParent(e))).then(()=>{this.categoryRepository.get(e,Shopware.Context.api,this.criteria).then(i=>{this.addCategory(i)})})},addCategory(e){e&&(this.loadedCategories[e.id]=e)},addCategories(e){e.forEach(t=>{this.loadedCategories[t.id]=t})},removeFromStore(e){const t=this.getDeletedIds(e);this.loadedParentIds=this.loadedParentIds.filter(i=>!t.includes(i)),t.forEach(i=>{delete this.loadedCategories[i]})},getDeletedIds(e){const t=[e];return Object.keys(this.loadedCategories).forEach(i=>{this.loadedCategories[i].parentId===e&&t.push(...this.getDeletedIds(i))}),t},getCategoryUrl(e){return this.$router.resolve({name:this.linkContext,params:{id:e.id}}).href},isHighlighted({data:e}){return e.navigationSalesChannels!==null&&e.navigationSalesChannels.length>0||e.serviceSalesChannels!==null&&e.serviceSalesChannels.length>0||e.footerSalesChannels!==null&&e.footerSalesChannels.length>0},isErrorNavigationEntryPoint(e){const{navigationSalesChannels:t,serviceSalesChannels:i,footerSalesChannels:a}=e;return[t,i,a].some(r=>r!==null&&(r==null?void 0:r.length)>0)},entryPointWarningMessage(e){const{serviceSalesChannels:t,footerSalesChannels:i}=e;return t!==null&&(t==null?void 0:t.length)>0?this.$tc("sw-category.general.errorNavigationEntryPoint",{entryPointLabel:this.$tc("sw-category.base.entry-point-card.types.labelServiceNavigation")},0):i!==null&&(i==null?void 0:i.length)>0?this.$tc("sw-category.general.errorNavigationEntryPoint",{entryPointLabel:this.$tc("sw-category.base.entry-point-card.types.labelFooterNavigation")},0):this.$tc("sw-category.general.errorNavigationEntryPoint",{entryPointLabel:this.$tc("sw-category.base.entry-point-card.types.labelMainNavigation")},0)}}};export{d as default};
