const s=`{% block sw_settings_list %} {% block sw_settings_tax_index %} <sw-page class="sw-settings-tax-list"> {% block sw_settings_tax_list_search_bar %} <template #search-bar> <sw-search-bar initial-search-type="tax" :placeholder="$tc('sw-settings-tax.general.placeholderSearchBar')" :initial-search="term" @search="onSearch" /> </template> {% endblock %} {% block sw_settings_tax_list_smart_bar_header %} <template #smart-bar-header> {% block sw_settings_tax_list_smart_bar_header_title %} <h2> {% block sw_settings_tax_list_smart_bar_header_title_text %} {{ $tc('sw-settings.index.title') }} <mt-icon name="regular-chevron-right-xs" size="12px" /> {{ $tc('sw-settings-tax.list.textHeadline') }} {% endblock %} {% block sw_settings_tax_list_smart_bar_header_amount %} <span v-if="!isLoading" class="sw-page__smart-bar-amount" > ({{ total }}) </span> {% endblock %} </h2> {% endblock %} </template> {% endblock %} {% block sw_settings_tax_list_smart_bar_actions %} <template #smart-bar-actions> {% block sw_settings_tax_list_smart_bar_actions_add %} <mt-button v-tooltip.bottom="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('tax.creator'), showOnDisabledElements: true }" class="sw-settings-tax-list__button-create" variant="primary" :disabled="!acl.can('tax.creator') || undefined" size="default" @click="$router.push({ name: 'sw.settings.tax.create' })" > {{ $tc('sw-settings-tax.list.buttonAddTax') }} </mt-button> {% endblock %} </template> {% endblock %} <template #language-switch> <sw-language-switch @on-change="onChangeLanguage" /> </template> {% block sw_settings_tax_list_content %} <template #content> <sw-card-view> {% block sw_settings_tax_list_content_card %} <mt-card position-identifier="sw-settings-tax-list-content" class="sw-tax-card" :title="$tc('sw-settings-tax.list.taxCardTitle')" :is-loading="isLoading" > <template #grid> {% block sw_settings_tax_list_grid %} <sw-entity-listing ref="swSettingsTaxGrid" class="sw-settings-tax-list-grid" detail-route="sw.settings.tax.detail" :items="tax" :columns="getTaxColumns()" :repository="taxRepository" :full-page="false" :show-selection="false" :is-loading="isLoading" :allow-view="acl.can('tax.viewer') || undefined" :allow-edit="acl.can('tax.editor') || undefined" :allow-inline-edit="acl.can('tax.editor') || undefined" :allow-delete="acl.can('tax.deleter') || undefined" :disable-data-fetching="true" :sort-by="sortBy" :sort-direction="sortDirection" @column-sort="onSortColumn" @page-change="onPageChange" @inline-edit-save="onInlineEditSave" @inline-edit-cancel="onInlineEditCancel" > {% block sw_settings_tax_list_grid_column_default_name %} <template #column-name="{ item, column, isInlineEdit, compact }"> {# if it is not a default tax, the default slot content will be rendered #} <router-link v-if="isShopwareDefaultTax(item)" class="sw-data-grid__cell-value" :to="{ name: column.routerLink, params: { id: item.id } }" > {{ getLabel(item) }} </router-link> </template> {% endblock %} {% block sw_settings_tax_list_grid_column_default_tax_rate %} <template #column-taxRate="{ item, isInlineEdit, compact }"> <template v-if="isInlineEdit"> <mt-number-field v-model="item.taxRate" :digits="3" :size="compact ? 'small' : 'default'" > <template #suffix> <span> <span v-html="$sanitize($tc('sw-settings-tax.general.taxRateSymbol'))"></span> </span> </template> </mt-number-field> </template> <template v-else> {{ item.taxRate }}% </template> </template> {% endblock %} {% block sw_settings_tax_list_grid_column_default %} <template #column-default="{ item, isInlineEdit }"> <template v-if="isInlineEdit"> {% block sw_settings_tax_list_grid_column_default_editor %} <mt-checkbox :checked="isSelectedDefaultRate(item)" @update:checked="value => setSelectedDefaultRate(value, item.id)" /> {% endblock %} </template> <template v-else> {% block sw_settings_tax_list_grid_column_default_label %} <mt-icon v-if="isSelectedDefaultRate(item)" name="regular-checkmark-xs" size="16px" class="is--active" /> <div v-else></div> {% endblock %} </template> </template> {% endblock %} {% block sw_settings_tax_list_grid_columns_actions %} <template #actions="{ item }"> {% block sw_settings_tax_list_grid_columns_actions_edit %} <sw-context-menu-item class="sw-tax-list__edit-action" :disabled="!acl.can('tax.editor') || undefined" :router-link="{ name: 'sw.settings.tax.detail', params: { id: item.id, edit: 'edit' } }" > {{ $tc('sw-settings-tax.list.contextMenuEdit') }} </sw-context-menu-item> {% endblock %} {% block sw_settings_tax_list_grid_columns_actions_delete %} <sw-context-menu-item class="sw-tax-list__delete-action" variant="danger" :disabled="!acl.can('tax.deleter') || undefined" @click="onDelete(item.id)" > {{ $tc('sw-settings-tax.list.contextMenuDelete') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} {% block sw_settings_tax_list_grid_action_modals %} <template #action-modals="{ item }"> {% block sw_settings_tax_list_delete_modal %} <sw-modal v-if="showDeleteModal === item.id" :title="$tc('global.default.warning')" variant="small" @modal-close="onCloseDeleteModal" > {% block sw_settings_tax_list_delete_modal_confirm_delete_text %} <p class="sw-settings-tax-list__confirm-delete-text"> {{ $tc('sw-settings-tax.list.textDeleteConfirm', { name: item.name }, 0) }} </p> {% endblock %} {% block sw_settings_tax_list_delete_modal_footer %} <template #modal-footer> {% block sw_settings_tax_list_delete_modal_cancel %} <mt-button size="small" variant="secondary" @click="onCloseDeleteModal" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_settings_tax_list_delete_modal_confirm %} <mt-button variant="critical" size="small" @click="onConfirmDelete(item.id)" > {{ $tc('sw-settings-tax.list.buttonDelete') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} </template> {% endblock %} </sw-entity-listing> {% endblock %} </template> </mt-card> {% endblock %} <mt-card position-identifier="sw-settings-tax-provider-list-content" class="sw-settings-tax-provider-list-content" :title="$tc('sw-settings-tax.list.taxProvider.cardTitle')" :is-loading="isLoading" > <template #grid> <template v-if="showChangePriority"> <div class="sw-settings-tax-provider-list-content__bg"> <sw-button-process class="sw-settings-tax-provider-list-button__change-priority" :disabled="isLoading" :is-loading="isLoading" :process-success="false" variant="primary" ghost @click="showSortingModal = true" > {{ $tc('sw-settings-tax.list.taxProvider.changePriorityButton') }} </sw-button-process> </div> </template> <template v-if="!isLoading"> <mt-empty-state v-if="noTaxProvidersFound" :icon="$route.meta.$module.icon" :headline="$tc('sw-settings-tax.list.taxProvider.messageEmptyTitle')" /> <div v-else class="sw-tax-provider-items" > <template v-for="taxProvider in taxProviders" :key="taxProvider.id" > <div class="sw-tax-provider-item" > <div class="sw-tax-provider__name"> {{ taxProvider.translated.name }} </div> <div class="sw-tax-provider__link"> <router-link class="sw-tax-provider__show-detail-link" :to="editLink(taxProvider.id)" :disabled="!acl.can('tax.editor') || undefined" > {{ $tc('sw-settings-tax.list.taxProvider.editDetailsLink') }} </router-link> </div> <mt-switch :label="$tc('sw-settings-tax.list.taxProvider.labelActive')" :disabled="!acl.can('tax.editor') || undefined" :model-value="taxProvider.active" @update:model-value="onChangeTaxProviderActive(taxProvider)" /> </div> </template> </div> </template> <template v-else> <sw-skeleton /> </template> </template> </mt-card> <sw-settings-tax-provider-sorting-modal v-if="showSortingModal" :tax-providers="taxProviders" @modal-close="showSortingModal = false" @modal-save="loadTaxProviders" /> </sw-card-view> </template> {% endblock %} </sw-page> {% endblock %} {% endblock %}`,{Mixin:i}=Shopware,{Criteria:a}=Shopware.Data,l={template:s,inject:["repositoryFactory","acl","systemConfigApiService"],mixins:[i.getByName("listing"),i.getByName("notification")],data(){return{tax:null,taxProviders:null,sortBy:"position",isLoading:!1,sortDirection:"ASC",naturalSorting:!1,showDeleteModal:!1,defaultTaxRateId:null,selectedDefaultTaxRateId:null,showSortingModal:!1}},metaInfo(){return{title:this.$createTitle()}},computed:{taxRepository(){return this.repositoryFactory.create("tax")},taxProviderRepository(){return this.repositoryFactory.create("tax_provider")},taxProviderCriteria(){const t=new a(this.page,this.limit);return t.addSorting(a.sort("priority","DESC")),t},showChangePriority(){var t;return((t=this.taxProviders)==null?void 0:t.length)>1},noTaxProvidersFound(){var t;return((t=this.taxProviders)==null?void 0:t.length)<1}},methods:{getList(){const t=new a(this.page,this.limit);this.isLoading=!0,this.naturalSorting=this.sortBy==="name",t.setTerm(this.term),t.addSorting(a.sort(this.sortBy,this.sortDirection,this.naturalSorting)),this.sortBy!=="name"&&t.addSorting(a.sort("name","ASC",!0)),this.getDefaultTaxRate().then(e=>{this.defaultTaxRateId=e,this.selectedDefaultRate=e}),this.taxRepository.search(t).then(e=>(this.total=e.total,this.tax=e,this.isLoading=!1,e)).catch(()=>{this.isLoading=!1}),this.loadTaxProviders()},editLink(t){return{name:"sw.settings.tax.tax_provider.detail",params:{id:t}}},onChangeLanguage(t){Shopware.Store.get("context").api.languageId=t,this.getList()},async onInlineEditSave(t,e){t.then(()=>{if(this.selectedDefaultTaxRateId===this.defaultTaxRateId){this.createNotificationSuccess({message:this.$tc("sw-settings-tax.detail.messageSaveSuccess",{name:e.name},0)});return}this.systemConfigApiService.saveValues({"core.tax.defaultTaxRate":this.selectedDefaultTaxRateId}).then(()=>{this.defaultTaxRateId=this.selectedDefaultTaxRateId,this.createNotificationSuccess({message:this.$tc("sw-settings-tax.detail.messageSaveSuccess",{name:e.name},0)})}).catch(()=>{this.getList(),this.createNotificationError({message:this.$tc("sw-settings-tax.detail.messageSaveError")})})}).catch(()=>{this.createNotificationError({message:this.$tc("sw-settings-tax.detail.messageSaveError")})})},async onInlineEditCancel(t){await t,this.selectedDefaultTaxRateId=null,this.getDefaultTaxRate().then(e=>{this.defaultTaxRateId=e})},onDelete(t){this.showDeleteModal=t},onCloseDeleteModal(){this.showDeleteModal=!1},onConfirmDelete(t){return this.showDeleteModal=!1,this.taxRepository.delete(t).then(()=>{this.getList()})},getTaxColumns(){return[{property:"name",dataIndex:"name",inlineEdit:"string",label:"sw-settings-tax.list.columnName",routerLink:"sw.settings.tax.detail",width:"250px",primary:!0},{property:"taxRate",inlineEdit:"number",label:"sw-settings-tax.list.columnDefaultTaxRate"},{property:"default",inlineEdit:"boolean",label:"sw-settings-tax.list.columnDefault"}]},isShopwareDefaultTax(t){return this.$te(`global.tax-rates.${t.name}`,"en-GB")},getLabel(t){return this.isShopwareDefaultTax(t)?this.$tc(`global.tax-rates.${t.name}`):t.name},isSelectedDefaultRate(t){return this.defaultTaxRateId===t.id},setSelectedDefaultRate(t,e){this.selectedDefaultTaxRateId=t?e:null},getDefaultTaxRate(){return this.systemConfigApiService.getValues("core.tax").then(t=>t["core.tax.defaultTaxRate"]??null).catch(()=>null)},loadTaxProviders(){this.isLoading=!0,this.taxProviderRepository.search(this.taxProviderCriteria).then(t=>{this.taxProviders=t}).finally(()=>{this.isLoading=!1})},onChangeTaxProviderActive(t){t.active=!t.active,this.taxProviderRepository.save(t,Shopware.Context.api).then(()=>{const e=t.active?"active":"inactive";this.createNotificationSuccess({message:this.$tc(`sw-settings-tax.list.taxProvider.statusChangedSuccess.${e}`,0,{name:t.translated.name})})})}}};export{l as default};
