const a=`{% block sw_settings_shopware_updates_wizard %} <sw-page class="sw-settings-shopware-updates-wizard"> {% block sw_settings_shopware_updates_wizard_smart_bar_header %} <template #smart-bar-header> <h2 v-if="updateInfo.version"> {{ $t('sw-settings-shopware-updates.general.title', {version: updateInfo.version }) }} </h2> <h2 v-if="!updateInfo.version"> {{ $t('sw-settings-shopware-updates.general.emptyTitle') }} </h2> </template> {% endblock %} {% block sw_settings_shopware_updates_wizard_smart_bar_actions %} <template #smart-bar-actions> <div :key="updatePossible" v-tooltip="updateButtonTooltip" > <mt-button v-if="updateInfo.version" :disabled="!updatePossible" :is-loading="updaterIsRunning" variant="primary" class="sw-settings-shopware-updates-wizard__start-update" size="default" @click="updateModalShown = true" > {{ $t('sw-settings-shopware-updates.infos.startUpdate') }} </mt-button> </div> </template> {% endblock %} <template #content> <div class="sw-settings-shopware-updates-wizard__content"> {% block sw_settings_shopware_updates_wizard_content %} <sw-card-view v-if="isLoading || updateInfo.version"> <sw-settings-shopware-updates-info v-if="updateInfo" :is-loading="isLoading" :changelog="updateInfo.body" /> <sw-settings-shopware-updates-requirements :is-loading="isLoading" :update-info="updateInfo" :requirements="requirements" /> <sw-settings-shopware-updates-plugins :plugins="plugins" :is-loading="isLoading" /> </sw-card-view> <mt-empty-state v-if="!isLoading && !updateInfo.version" :centered="true" :icon="$route.meta.$module.icon" :headline="$tc('sw-settings-shopware-updates.general.emptyState')" /> <sw-modal v-if="updaterIsRunning" :title="$t('sw-settings-shopware-updates.cards.updating')" variant="small" class="sw-shopware-updates-progressbar" > <div class="progress-wrapper"> <mt-progress-bar :model-value="progressbarValue" :max-value="100" /> <span class="progress-title"> <p v-if="step === 'download'">{{ $t('sw-settings-shopware-updates.infos.progress.download') }}</p> <p v-if="step === 'unpack'">{{ $t('sw-settings-shopware-updates.infos.progress.unpack') }}</p> <p v-if="step === 'deactivate'">{{ $t('sw-settings-shopware-updates.infos.progress.deactivate') }}</p> </span> </div> </sw-modal> <sw-modal v-if="updateModalShown" class="sw-settings-shopware-updates-check__start-update" :title="$t('sw-settings-shopware-updates.general.emptyTitle')" variant="small" @modal-close="updateModalShown = false" > <mt-banner v-if="displayUnknownPluginsWarning" variant="attention" > {{ $tc('sw-settings-shopware-updates.updateModal.messageNotInStore') }} </mt-banner> <mt-banner v-if="displayIncompatiblePluginsWarning" variant="attention" > {{ $tc('sw-settings-shopware-updates.updateModal.messageIncompatible') }} </mt-banner> <sw-radio-field v-if="displayIncompatiblePluginsWarning" v-model:value="chosenPluginBehaviour" :options="[ {'value': 'all', 'name': optionDeactivateAllTranslation }, {'value': 'notCompatible', 'name': optionDeactivateIncompatibleTranslation }, {'value': '', 'name': $tc('sw-settings-shopware-updates.plugins.actions.deactivateNone')}]" /> <template v-if="displayAllPluginsOkayInfo"> {{ $tc('sw-settings-shopware-updates.updateModal.messageOkay') }} </template> <template #modal-footer> <mt-checkbox v-model:checked="checkedBackupCheckbox" class="sw-settings-shopware-updates-check__start-update-backup-checkbox" :label="$tc('sw-settings-shopware-updates.updateModal.backupLabel')" /> <div class="sw-settings-shopware-updates-check__start-update-actions"> <mt-button size="small" variant="secondary" @click="updateModalShown = false" > {{ $tc('global.default.cancel') }} </mt-button> <mt-button :disabled="!checkedBackupCheckbox" variant="primary" size="small" class="sw-settings-shopware-updates-check__start-update-button" @click="startUpdateProcess()" > {{ $tc('sw-settings-shopware-updates.updateModal.actions.install') }} </mt-button> </div> </template> </sw-modal> {% endblock %} </div> </template> </sw-page> {% endblock %}`,{Component:i,Mixin:n}=Shopware,o=i.wrapComponentConfig({template:a,inject:["updateService"],emits:["update-started","update-stopped"],mixins:[n.getByName("notification")],data(){return{updateInfo:{version:null,changelog:null},requirements:[],plugins:[],isLoading:!0,checkedBackupCheckbox:!1,updateRunning:!1,progressbarValue:0,step:"download",updaterIsRunning:!1,updateModalShown:!1,chosenPluginBehaviour:""}},metaInfo(){return{title:this.$createTitle()}},computed:{updatePossible(){return this.requirements.every(e=>e.result===!0)},updateButtonTooltip(){return this.updatePossible?{message:"",disabled:!0}:{message:this.$tc("sw-settings-shopware-updates.infos.requirementsNotMet"),position:"bottom"}},displayIncompatiblePluginsWarning(){return this.plugins.some(e=>e.statusName!=="compatible"&&e.statusName!=="notInStore")},displayUnknownPluginsWarning(){return this.plugins.some(e=>e.statusName==="notInStore")},displayAllPluginsOkayInfo(){return!(this.displayIncompatiblePluginsWarning||this.displayUnknownPluginsWarning)},optionDeactivateIncompatibleTranslation(){const e=this.$tc("sw-settings-shopware-updates.plugins.actions.deactivateIncompatible"),t=this.displayIncompatiblePluginsWarning&&!this.displayUnknownPluginsWarning?this.$tc("sw-settings-shopware-updates.plugins.actions.recommended"):"";return`${e} ${t}`},optionDeactivateAllTranslation(){const e=this.$tc("sw-settings-shopware-updates.plugins.actions.deactivateAll"),t=this.displayIncompatiblePluginsWarning&&this.displayUnknownPluginsWarning?this.$tc("sw-settings-shopware-updates.plugins.actions.recommended"):"";return`${e} ${t}`}},created(){this.createdComponent()},methods:{createdComponent(){this.updateService.checkForUpdates().then(e=>{this.updateInfo=e,e.version?this.updateService.checkRequirements().then(t=>{this.onRequirementsResponse(t)}):this.isLoading=!1})},onRequirementsResponse(e){this.requirements=e,this.updateService.extensionCompatibility().then(t=>{this.plugins=t,this.displayUnknownPluginsWarning&&this.displayIncompatiblePluginsWarning?this.chosenPluginBehaviour="all":this.displayIncompatiblePluginsWarning&&(this.chosenPluginBehaviour="notCompatible"),this.isLoading=!1})},startUpdateProcess(){this.updateModalShown=!1,this.$emit("update-started"),this.updaterIsRunning=!0,this.createNotificationSuccess({message:this.$tc("sw-settings-shopware-updates.notifications.updateStarted")}),this.downloadRecovery()},stopUpdateProcess(){this.updateModalShown=!1,this.$emit("update-stopped"),this.updaterIsRunning=!1,this.createNotificationInfo({message:this.$tc("sw-settings-shopware-updates.notifications.updateStopped")})},downloadRecovery(){this.updateService.downloadRecovery().then(()=>{this.progressbarValue=0,this.deactivatePlugins(0)}).catch(()=>{this.createNotificationError({message:this.$tc("sw-settings-shopware-updates.notifications.downloadFailed")})})},deactivatePlugins(e){this.step="deactivate",this.updateService.deactivatePlugins(e,this.chosenPluginBehaviour).then(t=>{this.progressbarValue=Math.floor(t.offset/t.total*100),t.offset===t.total?this.redirectToPage(`${Shopware.Context.api.basePath}/shopware-installer.phar.php`):this.deactivatePlugins(t.offset)}).catch(t=>{this.stopUpdateProcess();const s={code:t.response.data.errors[0].code,meta:t.response.data.errors[0].meta};s.code==="FRAMEWORK__PLUGIN_HAS_DEPENDANTS"?this.createNotificationWarning({message:this.$t("sw-extension.errors.messageDeactivationFailedDependencies",null,null,{dependency:s.meta.parameters.dependency,dependantNames:s.meta.parameters.dependantNames})}):s.code==="THEME__THEME_ASSIGNMENT"?this.createNotificationWarning({message:this.$tc("sw-extension.errors.messageDeactivationFailedThemeAssignment",null,null,{themeName:s.meta.parameters.themeName,assignments:s.meta.parameters.assignments})}):this.createNotificationError({message:this.$tc("sw-settings-shopware-updates.notifications.deactivationFailed")})})},redirectToPage(e){window.location.href=e}}});export{o as default};
