const e=`{% block sw_settings_tax_detail %} <sw-page class="sw-settings-tax-detail"> {% block sw_settings_tax_detail_header %} <template #smart-bar-header> <h2 v-if="label"> {{ label }} </h2> <h2 v-else> {{ $tc('sw-settings-tax.detail.textHeadline') }} </h2> </template> {% endblock %} {% block sw_settings_tax_detail_actions %} <template #smart-bar-actions> {% block sw_settings_tax_detail_actions_abort %} <mt-button v-tooltip.bottom="{ message: 'ESC', appearance: 'light' }" :disabled="isLoading" variant="secondary" size="default" @click="onCancel" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_settings_tax_detail_actions_save %} <sw-button-process v-model:process-success="isSaveSuccessful" v-tooltip.bottom="tooltipSave" class="sw-settings-tax-detail__save-action" variant="primary" :is-loading="isLoading" :disabled="isLoading || !allowSave || undefined" @click.prevent="onSave" > {{ $tc('sw-settings-tax.detail.buttonSave') }} </sw-button-process> {% endblock %} </template> {% endblock %} <template #language-switch> <sw-language-switch :save-changes-function="saveOnLanguageChange" :abort-change-function="abortOnLanguageChange" @on-change="onChangeLanguage" /> </template> {% block sw_settings_tax_detail_content %} <template #content> <sw-card-view> <template v-if="isLoading"> <sw-skeleton /> <sw-skeleton /> </template> <template v-else> {% block sw_settings_tax_detail_content_card %} <mt-card :title="$tc('sw-settings-tax.detail.titleCard')" position-identifier="sw-settings-tax-detail-content" > <sw-container columns="repeat(auto-fit, minmax(250px, 1fr))" gap="0px 30px" > {% block sw_settings_tax_detail_content_field_name %} <mt-text-field id="sw-field--tax-name" :model-value="label" required name="sw-field--tax-name" :disabled="!acl.can('tax.editor') || isShopwareDefaultTax || undefined" :label="$tc('sw-settings-tax.detail.labelName')" :placeholder="$tc('sw-settings-tax.detail.placeholderName')" :error="taxNameError" @update:model-value="changeName" /> {% endblock %} {% block sw_settings_tax_detail_content_field_tax_rate %} <mt-number-field v-model="tax.taxRate" name="sw-field--tax-taxRate" required :digits="3" :disabled="!acl.can('tax.editor') || undefined" :label="$tc('sw-settings-tax.detail.labelDefaultTaxRate')" :placeholder="$tc('sw-settings-tax.detail.placeholderDefaultTaxRate')" :error="taxTaxRateError" > <template #suffix> <span> <span v-html="$sanitize($tc('sw-settings-tax.general.taxRateSymbol'))"></span> </span> </template> </mt-number-field> {% endblock %} <div class="sw-settings-tax-detail__switches"> {% block sw_settings_tax_detail_content_field_default_tax_rate %} <mt-switch :key="isDefault" class="sw-settings-tax-detail__default-tax-rate" :label="$tc('sw-settings-tax.detail.defaultTaxLabel')" :help-text="$tc('sw-settings-tax.detail.defaultTaxHelpText')" :model-value="isDefault" name="sw-field--isDefault" @update:model-value="onChangeDefaultTaxRate" /> {% endblock %} </div> </sw-container> </mt-card> {% endblock %} {% block sw_settings_tax_detail_rule_card %} <sw-tax-rule-card v-if="tax.id" :disabled="!taxId" class="sw-settings-tax-detail__tax-rule-grid" :tax="tax" :is-loading="isLoading" /> {% endblock %} {% block sw_settings_tax_detail_custom_field_sets %} <mt-card v-if="showCustomFields" position-identifier="sw-settings-tax-detail-custom-field-sets" :title="$tc('sw-settings-custom-field.general.mainMenuItemGeneral')" :is-loading="isLoading" > <sw-custom-field-set-renderer :entity="tax" :disabled="!acl.can('tax.editor')" :sets="customFieldSets" /> </mt-card> {% endblock %} </template> </sw-card-view> </template> {% endblock %} </sw-page> {% endblock %}`,{Mixin:a}=Shopware,{mapPropertyErrors:s}=Shopware.Component.getComponentHelper(),i={template:e,inject:["repositoryFactory","acl","customFieldDataProviderService","systemConfigApiService"],mixins:[a.getByName("notification")],shortcuts:{"SYSTEMKEY+S":{active(){return this.allowSave},method:"onSave"},ESCAPE:"onCancel"},props:{taxId:{type:String,required:!1,default:null}},data(){return{tax:{},isLoading:!1,isSaveSuccessful:!1,customFieldSets:null,defaultTaxRateId:null,changeDefaultTaxRate:!1,formerDefaultTaxName:"",config:{},isDefault:!1}},metaInfo(){return{title:this.$createTitle(this.identifier)}},computed:{identifier(){return this.tax.name||""},taxRepository(){return this.repositoryFactory.create("tax")},...s("tax",["name","taxRate"]),isNewTax(){return this.tax.isNew==="function"?this.tax.isNew():!1},allowSave(){return this.isNewTax?this.acl.can("tax.creator"):this.acl.can("tax.editor")},tooltipSave(){return this.allowSave?{message:`${this.$device.getSystemKey()} + S`,appearance:"light"}:{message:this.$tc("sw-privileges.tooltip.warning"),disabled:this.allowSave,showOnDisabledElements:!0}},isShopwareDefaultTax(){return this.$te(`global.tax-rates.${this.tax.name}`,"en-GB")},label(){return this.isShopwareDefaultTax?this.$tc(`global.tax-rates.${this.tax.name}`):this.tax.name},showCustomFields(){return this.customFieldSets&&this.customFieldSets.length>0},isDefaultTaxRate(){return this.defaultTaxRateId?this.taxId===this.defaultTaxRateId:!1}},watch:{taxId(){this.taxId||this.createdComponent()},isDefaultTaxRate(){this.isDefault=this.isDefaultTaxRate}},created(){this.createdComponent()},methods:{createdComponent(){if(this.isLoading=!0,this.taxId){this.taxRepository.get(this.taxId).then(t=>{this.tax=t,this.isLoading=!1}),this.loadCustomFieldSets(),this.reloadDefaultTaxRate();return}this.tax=this.taxRepository.create(),this.isLoading=!1},loadCustomFieldSets(){this.customFieldDataProviderService.getCustomFieldSets("tax").then(t=>{this.customFieldSets=t})},onSave(){return this.isSaveSuccessful=!1,this.isLoading=!0,this.taxRepository.save(this.tax).then(()=>{this.isSaveSuccessful=!0,this.taxId||this.$router.push({name:"sw.settings.tax.detail",params:{id:this.tax.id}}),this.taxRepository.get(this.tax.id).then(t=>{this.tax=t}).then(()=>this.systemConfigApiService.saveValues(this.config).then(()=>{this.defaultTaxRateId=this.tax.id,this.reloadDefaultTaxRate(),this.isLoading=!1}))}).catch(()=>{this.createNotificationError({message:this.$tc("sw-settings-tax.detail.messageSaveError")}),this.isLoading=!1})},onCancel(){this.$router.push({name:"sw.settings.tax.index"})},abortOnLanguageChange(){return this.taxRepository.hasChanges(this.tax)},saveOnLanguageChange(){return this.onSave()},onChangeLanguage(t){Shopware.Store.get("context").api.languageId=t,this.createdComponent()},changeName(t){this.tax.name=t},reloadDefaultTaxRate(){this.systemConfigApiService.getValues("core.tax").then(t=>{this.defaultTaxRateId=t["core.tax.defaultTaxRate"]??null}).then(()=>{this.defaultTaxRateId&&this.taxRepository.get(this.defaultTaxRateId).then(t=>{this.formerDefaultTaxName=t.name})}).catch(()=>{this.defaultTaxRateId=null})},onChangeDefaultTaxRate(){const t=this.isDefaultTaxRate?"":this.taxId;this.config["core.tax.defaultTaxRate"]=t,this.changeDefaultTaxRate=!1}}};export{i as default};
