const u=`{% block sw_flow_detail %} <sw-page class="sw-flow-detail"> {% block sw_flow_detail_header %} <template #smart-bar-header> <h2>{{ placeholder(flow, 'name', $tc('sw-flow.detail.textHeadline')) }}</h2> </template> {% endblock %} {% block sw_flow_detail_smart_bar_actions %} <template #smart-bar-actions> {% block sw_flow_detail_smart_bar_actions_save %} <sw-button-process v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('flow.editor'), position: 'bottom', showOnDisabledElements: true }" class="sw-flow-detail__save" variant="primary" :is-loading="isLoading" :process-success="isSaveSuccessful" :disabled="!acl.can('flow.editor')" @update:process-success="saveFinish" @click.prevent="onSave" > {{ $tc('global.default.save') }} </sw-button-process> {% endblock %} </template> {% endblock %} {% block sw_flow_content %} <template #content> {% block sw_flow_leave_page_modal %} <sw-flow-leave-page-modal v-if="showLeavePageWarningModal" @page-leave-cancel="onLeaveModalClose" @page-leave-confirm="onLeaveModalConfirm" /> {% endblock %} <sw-card-view :class="{'sw-flow-detail__template': isTemplate }"> {% block sw_flow_tabs_header %} <sw-tabs position-identifier="sw-flow-detail"> {% block sw_flow_tabs_header_general %} <sw-tabs-item class="sw-flow-detail__tab-general" :route="routeDetailTab('general')" > {{ $tc('sw-flow.page.tabGeneral') }} </sw-tabs-item> {% endblock %} {% block sw_flow_tabs_header_builder %} <sw-tabs-item class="sw-flow-detail__tab-flow" :route="routeDetailTab('flow')" > {{ $tc('sw-flow.page.tabFlow') }} </sw-tabs-item> {% endblock %} {% block sw_flow_tabs_header_extension %}{% endblock %} </sw-tabs> {% endblock %} <mt-banner v-if="isTemplate" variant="attention" class="sw-flow-detail__warning" > {{ $tc('sw-flow.flowNotification.messageWarningSave') }} </mt-banner> {% block sw_flow_tabs_content %} <template v-if="isLoading"> <sw-skeleton /> <sw-skeleton /> </template> <template v-else> <router-view v-slot="{ Component }" > <component :is="Component" :is-loading="isLoading" :is-new-flow="isNewFlow" :is-template="isTemplate" :is-unknown-trigger="isUnknownTrigger" /> </router-view> </template> {% endblock %} </sw-card-view> {% block sw_flow_detail_modal_extension %}{% endblock %} </template> {% endblock %} </sw-page> {% endblock %}`,{Component:p,Mixin:d,Context:n,Store:a,Utils:h,Service:f}=Shopware,{Criteria:s,EntityCollection:m}=Shopware.Data,{cloneDeep:c}=Shopware.Utils.object,{mapState:g,mapPropertyErrors:S}=p.getComponentHelper(),y={template:u,inject:["acl","repositoryFactory","feature","flowBuilderService"],mixins:[d.getByName("placeholder"),d.getByName("notification")],props:{flowId:{type:String,required:!1,default:null}},data(){return{isLoading:!1,isSaveSuccessful:!1,showLeavePageWarningModal:!1,nextRoute:null}},metaInfo(){return{title:this.$createTitle(this.identifier)}},computed:{identifier(){var e;return(e=this.flow)==null?void 0:e.name},flowRepository(){return this.repositoryFactory.create("flow")},flowTemplateRepository(){return this.repositoryFactory.create("flow_template")},flowSequenceRepository(){return this.repositoryFactory.create("flow_sequence")},appFlowActionRepository(){return this.repositoryFactory.create("app_flow_action")},isNewFlow(){return!this.flowId},flowCriteria(){const e=new s(1,25);return e.addAssociation("sequences.rule"),e.getAssociation("sequences").addSorting(s.sort("displayGroup","ASC")).addSorting(s.sort("parentId","ASC")).addSorting(s.sort("trueCase","ASC")).addSorting(s.sort("position","ASC")),e},flowTemplateCriteria(){return new s(1,25)},documentTypeRepository(){return this.repositoryFactory.create("document_type")},documentTypeCriteria(){const e=new s(1,100);return e.addSorting(s.sort("name","ASC")),e},mailTemplateRepository(){return this.repositoryFactory.create("mail_template")},customFieldSetRepository(){return this.repositoryFactory.create("custom_field_set")},customFieldRepository(){return this.repositoryFactory.create("custom_field")},mailTemplateIdsCriteria(){const e=new s(1,25);return e.addAssociation("mailTemplateType"),e.addFilter(s.equalsAny("id",this.mailTemplateIds)),e},customerGroupRepository(){return this.repositoryFactory.create("customer_group")},customerGroupCriteria(){const e=new s(1,100);return e.addSorting(s.sort("name","ASC")),e},appFlowActionCriteria(){const e=new s(1,25);return e.addAssociation("app"),e},stateMachineStateRepository(){return this.repositoryFactory.create("state_machine_state")},stateMachineStateCriteria(){const e=new s(1,null);return e.addSorting({field:"name",order:"ASC"}),e.addAssociation("stateMachine"),e.addFilter(s.equalsAny("state_machine_state.stateMachine.technicalName",["order.state","order_transaction.state","order_delivery.state"])),e},customFieldSetCriteria(){const e=new s(1,25);return e.addFilter(s.equalsAny("id",this.customFieldSetIds)),e},customFieldCriteria(){const e=new s(1,25);return e.addFilter(s.equalsAny("id",this.customFieldIds)),e},ruleRepository(){return this.repositoryFactory.create("rule")},isTemplate(){var e;return((e=this.$route.query)==null?void 0:e.type)==="template"},isUnknownTrigger(){return!this.flowId||this.isLoading?!1:!this.triggerEvents.some(e=>e.name===this.flow.eventName)},...g(()=>a.get("swFlow"),["flow","triggerEvents","sequences","mailTemplateIds","customFieldSetIds","customFieldIds","hasFlowChanged"]),...S("flow",["name","eventName"])},watch:{flowId(){this.$route.params.flowTemplateId||this.getDetailFlow()}},created(){this.createdComponent()},beforeRouteLeave(e,i,t){if(this.flow._isNew){t();return}this.hasFlowChanged?(this.nextRoute=t,this.showLeavePageWarningModal=!0):t()},beforeUnmount(){this.beforeDestroyComponent()},methods:{createdComponent(){if(f("flowBuilderService").addLabels({entity:"sw-flow.labelDescription.labelEntity",tagIds:"sw-flow.labelDescription.labelTag"}),Shopware.ExtensionAPI.publishData({id:"sw-flow-detail__flow",path:"flow",scope:this}),this.getAppFlowAction(),this.isTemplate){this.getDetailFlowTemplate();return}if(this.flowId){this.getDetailFlow();return}this.createNewFlow()},beforeDestroyComponent(){a.get("swFlow").resetFlowState()},routeDetailTab(e){return e?this.isNewFlow?this.$route.params.flowTemplateId?{name:`sw.flow.create.${e}`,params:{flowTemplateId:this.$route.params.flowTemplateId}}:{name:`sw.flow.create.${e}`}:this.isTemplate?{name:`sw.flow.detail.${e}`,query:{type:"template"}}:{name:`sw.flow.detail.${e}`}:{}},createNewFlow(){if(this.$route.params.flowTemplateId)return this.createFromFlowTemplate();const e=this.flowRepository.create();return e.id=h.createId(),e.priority=0,e.eventName="",e.sequences=[],a.get("swFlow").setFlow(e)},async getDetailFlow(){this.isLoading=!0;const e=a.get("swFlow");try{await e.fetchTriggerActions();const i=await this.flowRepository.get(this.flowId,n.api,this.flowCriteria);e.setFlow(i),e.setOriginFlow(c(i)),await this.getDataForActionDescription()}catch{this.createNotificationError({message:this.$tc("sw-flow.flowNotification.messageError")})}finally{this.isLoading=!1}},getAppFlowAction(){return this.appFlowActionRepository.search(this.appFlowActionCriteria,Shopware.Context.api).then(e=>{a.get("swFlow").setAppActions(e)})},getDetailFlowTemplate(){return this.isLoading=!0,this.flowTemplateRepository.get(this.flowId,n.api,this.flowTemplateCriteria).then(e=>{a.get("swFlow").setFlow(e),a.get("swFlow").setOriginFlow(c(e)),this.getDataForActionDescription(),this.getRuleDataForFlowTemplate()}).catch(()=>{this.createNotificationError({message:this.$tc("sw-flow.flowNotification.messageError")})}).finally(()=>{this.isLoading=!1})},async onSave(){var i,t;if(this.removeAllSelectors(),!((i=this.flow)!=null&&i.name)||!((t=this.flow)!=null&&t.eventName)){this.createNotificationWarning({message:this.$tc("sw-flow.flowNotification.emptyFields.general")});return}if(this.validateEmptySequence().length){this.createNotificationWarning({message:this.$tc("sw-flow.flowNotification.emptyFields.sequences")});return}if(this.isSaveSuccessful=!1,this.isLoading=!0,this.isTemplate){this.createNotificationError({message:this.$tc("sw-flow.flowNotification.messageWarningSave")}),this.isLoading=!1;return}!(typeof this.flow.isNew=="function"&&this.flow.isNew())&&!this.isTemplate&&await this.updateSequences(),this.flowRepository.save(this.flow).then(()=>{if(typeof this.flow.isNew=="function"&&this.flow.isNew()||this.$route.params.flowTemplateId){this.createNotificationSuccess({message:this.$tc("sw-flow.flowNotification.messageCreateSuccess")}),this.$router.push({name:"sw.flow.detail",params:{id:this.flow.id}});return}this.getDetailFlow(),this.isSaveSuccessful=!0}).catch(()=>{this.createNotificationError({message:this.$tc("sw-flow.flowNotification.messageSaveError")}),this.handleFieldValiationError()}).finally(()=>{this.isLoading=!1})},async updateSequences(){const e=this.sequences.map(r=>(r.flowId=this.flow.id,r));await this.flowSequenceRepository.sync(e);const i=this.getDeletedSequenceIds();i.length>0&&await this.flowSequenceRepository.syncDeleted(i);const t=await this.flowRepository.get(this.flowId,n.api);Object.keys(t).forEach(r=>{r!=="sequences"&&(t[r]=this.flow[r])}),a.get("swFlow").setFlow(t)},getDeletedSequenceIds(){const e=this.sequences.map(t=>t.id);return this.flow.getOrigin().sequences.filter(t=>!e.includes(t.id)).map(t=>t.id)},handleFieldValiationError(){if(!this.flowNameError&&!this.flowEventNameError)return;const e=this.$router.history.current.name,i=(e==="sw.flow.create.flow"||e==="sw.flow.detail.flow")&&this.flowEventNameError,t=(e==="sw.flow.create.general"||e==="sw.flow.detail.general")&&this.flowNameError;if(!(i||t)){if(this.flowId){this.$router.push({name:this.flowNameError?"sw.flow.detail.general":"sw.flow.detail.flow",params:{flowId:this.flowId}});return}this.$router.push({name:this.flowNameError?"sw.flow.create.general":"sw.flow.create.flow"})}},saveFinish(){this.isLoading=!1,this.isSaveSuccessful=!1},onLeaveModalClose(){this.nextRoute(!1),this.nextRoute=null,this.showLeavePageWarningModal=!1},onLeaveModalConfirm(){this.showLeavePageWarningModal=!1,this.$nextTick(()=>{this.nextRoute()})},removeAllSelectors(){const e=this.sequences.filter(i=>i.ruleId!==null||i.actionName!==null);a.get("swFlow").setSequences(e)},validateEmptySequence(){const e=this.sequences.reduce((i,t)=>t.ruleId===""||t.actionName===""?[...i,t.id]:i,[]);return a.get("swFlow").invalidSequences=e,e},getDataForActionDescription(){if(!this.sequences)return null;const e=[];this.sequences.some(o=>o.actionName===this.flowBuilderService.getActionName("SET_ORDER_STATE"))&&e.push(this.stateMachineStateRepository.search(this.stateMachineStateCriteria).then(o=>{a.get("swFlow").stateMachineState=o})),this.sequences.some(o=>o.actionName===this.flowBuilderService.getActionName("GENERATE_DOCUMENT"))&&e.push(this.documentTypeRepository.search(this.documentTypeCriteria).then(o=>{Shopware.Store.get("swFlow").documentTypes=o})),this.sequences.some(o=>o.actionName===this.flowBuilderService.getActionName("MAIL_SEND"))&&e.push(this.mailTemplateRepository.search(this.mailTemplateIdsCriteria).then(o=>{Shopware.Store.get("swFlow").mailTemplates=o})),this.sequences.some(o=>o.actionName===this.flowBuilderService.getActionName("CHANGE_CUSTOMER_GROUP"))&&e.push(this.customerGroupRepository.search(this.customerGroupCriteria).then(o=>{Shopware.Store.get("swFlow").customerGroups=o}));const w=[this.flowBuilderService.getActionName("SET_ORDER_CUSTOM_FIELD"),this.flowBuilderService.getActionName("SET_CUSTOMER_CUSTOM_FIELD"),this.flowBuilderService.getActionName("SET_CUSTOMER_GROUP_CUSTOM_FIELD")];return this.sequences.some(o=>w.includes(o.actionName))&&(e.push(this.customFieldSetRepository.search(this.customFieldSetCriteria).then(o=>{Shopware.Store.get("swFlow").customFieldSets=o})),e.push(this.customFieldRepository.search(this.customFieldCriteria).then(o=>{Shopware.Store.get("swFlow").customFields=o}))),Promise.all(e)},createFromFlowTemplate(){const e=this.flowRepository.create();return e.id=h.createId(),e.priority=0,this.flowTemplateRepository.get(this.$route.params.flowTemplateId,n.api,this.flowTemplateCriteria).then(i=>{var t,r,l;e.name=i.name,e.eventName=(t=i.config)==null?void 0:t.eventName,e.description=(r=i.config)==null?void 0:r.description,e.sequences=this.buildSequencesFromConfig(((l=i.config)==null?void 0:l.sequences)??[]),a.get("swFlow").setFlow(e),a.get("swFlow").setOriginFlow(c(e)),this.getDataForActionDescription(),this.getRuleDataForFlowTemplate()}).catch(()=>{this.createNotificationError({message:this.$tc("sw-flow.flowNotification.messageError")})}).finally(()=>{this.isLoading=!1})},createSequenceEntity(e){const i=this.flowSequenceRepository.create();return Object.keys(e).forEach(t=>{if(t==="trueCase"){i[t]=!!e[t];return}if(t==="config"){i[t]={...e[t]};return}i[t]=e[t]}),i},buildSequencesFromConfig(e){const i={};e=e.map(t=>(t=this.createSequenceEntity(t),i[t.id]=h.createId(),t.id=i[t.id],t));for(let t=0;t<e.length;t+=1)e[t].parentId!==null&&(e[t].parentId=i[e[t].parentId]);return e=f("flowBuilderService").rearrangeArrayObjects(e),new m(this.flowSequenceRepository.source,this.flowSequenceRepository.entityName,n.api,null,e)},getRuleDataForFlowTemplate(){const e=this.sequences.filter(t=>t.ruleId!==null).map(t=>t.ruleId);if(!e.length)return;const i=new s(1,25);i.addFilter(s.equalsAny("id",e)),this.ruleRepository.search(i).then(t=>{const r=this.sequences.map(l=>(l.ruleId&&(l.rule=t.find(w=>w.id===l.ruleId)),l));a.get("swFlow").setSequences(r),a.get("swFlow").setOriginFlow(c(this.flow))})}}};export{y as default};
