// The trick to keep the editor in the sample quite small
// unless user specified own height.

/* 
 * Copyright (C) 2016 SCHLIX WEB INC.
 *
 * This software is licensed under GPLv3
*  
 *
 * Please read the LICENSE.html for details
 */
/******************************/
/****__insert_config_here__****/
/******************************/
        
SCHLIX.CMS.WysiwygHelper = {
    onDOMReady: function ()
    {
        var selector = '.wysiwyg';
        var editor_els = SCHLIX.Dom.get('{' + selector + '}');
        if (editor_els && editor_els.length > 0)        
        {
            SCHLIX.CMS.WysiwygHelper.loadJavascriptFile();
        }
    },
    initCodeMirror: function ()
    {
        __initCodeMirror();
        return; 
    },
    
    onWywiwygLoaded: function ()
    {
        SCHLIX.CMS.WysiwygHelper.initCodeMirror();
        
    },
    
    fixCodeMirror: function(cm)
    {
        SCHLIX.Dom.get(cm.schlix_text_area_id).value = cm.getValue();
    },
    
    loadJavascriptFile: function ()
    {
        
        SCHLIX.CMS.WysiwygHelper.EditorLoader = new SCHLIX.Core.JSLoader({
            onSuccess: SCHLIX.CMS.WysiwygHelper.onWywiwygLoaded
        });
        
        var code_mirror_modules = [
            { name: 'codemirror-base', type: 'js', varName: "codemirror-base", fullpath: site_httpbase + '/system/wysiwygeditors/codemirror/codemirror.min.js' },
            { name: 'codemirror-addons', type: 'js', varName: "codemirror-addons", fullpath: site_httpbase + '/system/wysiwygeditors/codemirror/codemirror.addons.min.js'},
            { name: 'codemirror-mode', type: 'js', varName: "codemirror-mode", fullpath: site_httpbase + '/system/wysiwygeditors/codemirror/codemirror.mode.scriptphp.min.js'},
            { name: 'codemirror-css', type: 'css', varName: "codemirror-css", fullpath: site_httpbase + '/system/wysiwygeditors/codemirror/css/codemirror.min.css' }
        
        ];
        
        for (var i = 0; i < code_mirror_modules.length; i++)
        {
            SCHLIX.CMS.WysiwygHelper.EditorLoader.addModule(code_mirror_modules[i]);
            SCHLIX.CMS.WysiwygHelper.EditorLoader.require(code_mirror_modules[i].name);             
        }
        if (__codemirror_config.config_theme_css !== '')
        {
            SCHLIX.CMS.WysiwygHelper.EditorLoader.addModule({name: 'theme-css', type: 'css', varName: "theme-css", fullpath: __codemirror_config.config_theme_css});
            SCHLIX.CMS.WysiwygHelper.EditorLoader.require("theme-css"); 
        }         
        SCHLIX.CMS.WysiwygHelper.EditorLoader.insert(); 
        
    }
 
};

/***************************************/
/****__insert_extra_function_ setup__****/
/***************************************/

function __initCodeMirror()
{
    
    /**************************************/
    /****__insert_extra_function_ini t__****/
    /**************************************/
    
    var myCodeMirror = [];
    var all_text_areas = SCHLIX.Dom.get('{.' + __codemirror_config.schlix_selector +  '}');
    if (all_text_areas.length > 0)
    {
        for (var i = 0;i < all_text_areas.length;i++)
        {
            var elem = SCHLIX.Dom.get(all_text_areas[i]);
            var elem_id = elem.id;
            if (!elem_id)
                elem.id =  SCHLIX.Dom.generateId(); 
            console.log ('##  codemirror for ' + elem_id);
            // __codemirror_config.height);
            elem.rows = '50';
            myCodeMirror[i] = CodeMirror.fromTextArea(elem, __codemirror_config);
            myCodeMirror[i].schlix_text_area_id = elem.id;
            myCodeMirror[i].on('change', SCHLIX.CMS.WysiwygHelper.fixCodeMirror);
            /*myCodeMirror[i].on('change', function()
            {
                 SCHLIX.Dom.get(this.schlix_text_area_id).value = this.getCode();
                 console.log('receive change' + this.schlix_text_area_id);
            });*/
        }
    }
}

SCHLIX.Event.onDOMReady(SCHLIX.CMS.WysiwygHelper.onDOMReady);


