<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

global $HTMLHeader;

$HTMLHeader->CSS(get_system_or_user_url_path('/wysiwygeditors/ckeditor4/skins/moono-lisa/editor.css'));
$HTMLHeader->CSS(get_system_or_user_url_path('/wysiwygeditors/ckeditor4/config.css'));
$HTMLHeader->JAVASCRIPT(get_system_or_user_url_path('/wysiwygeditors/ckeditor4/config.js'));

$ckeditor4 = new \WysiwygEditor\CKEditor4($id);
$array_config = $ckeditor4->generateConfigurationArrayFromConfig();

$possible_css_files = $ckeditor4->getPossibleContentCSSFiles();
$system_langs = $ckeditor4->getListOfFileBasedExtensions('system', 'lang','js');
$system_plugins = $ckeditor4->getCKEditorSystemPlugins();

$system_extra_plugins = $ckeditor4->getListOfDirBasedExtensions('system', 'plugins','plugin.js');
$system_skins = $ckeditor4->getListOfDirBasedExtensions('system', 'skins','editor.css');


$user_plugins = $ckeditor4->getListOfDirBasedExtensions('user', 'plugins','plugin.js');
$user_skins = $ckeditor4->getListOfDirBasedExtensions('user', 'skins','editor.css');

$url_user_plugins = $ckeditor4->getExtensionURLPath('user', 'plugins');
$url_user_skins = $ckeditor4->getExtensionURLPath('user', 'skins');

$extra_buttons = $ckeditor4->getExtraExtensionButtons();

$system_buttons = ['|', 'Source','Save', 'NewPage', 'Preview', 'Print','Templates','Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord','Undo', 'Redo','Find', 'Replace','SelectAll','Scayt','Form', 'Checkbox', 'Radio', 'TextField', 'Textarea', 'Select', 'Button', 'ImageButton', 'HiddenField','Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript','CopyFormatting', 'RemoveFormat','NumberedList', 'BulletedList','Outdent', 'Indent','Blockquote', 'CreateDiv','JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock','BidiLtr', 'BidiRtl', 'Language','Link', 'Unlink', 'Anchor','Image', 'Flash', 'Table', 'HorizontalRule', 'Smiley', 'SpecialChar', 'PageBreak', 'Iframe','Styles', 'Format', 'Font', 'FontSize','TextColor', 'BGColor','Maximize', 'ShowBlocks','About', 'CodeMirror','CodeSnippet','A11ychecker','EmojiPanel'];
/*if ($extra_buttons)
    $system_buttons = array_merge($system_buttons, $extra_buttons); */
$unused_buttons = ['|'];
$used_buttons = [];

$editor_text_buttons = ['Styles', 'Format', 'Font', 'FontSize'];

$default_toolbars =  $arr_toolbars = [];
 
$default_toolbars[1] = ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '|',  'Find', 'Replace', 'Undo', 'Redo' , '|','Format', 'Styles',  'TextColor', 'BGColor' , '|', 'CreateDiv', 'Table', '|', 'SpecialChar', 'FontAwesome', '|',  'ShowBlocks','|','CodeSnippet'  ];
$default_toolbars[2] = ['Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', '|', 'RemoveFormat' , '|','JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock', '|','NumberedList', 'BulletedList', '|', 'Outdent', 'Indent',  'Blockquote', 'HorizontalRule', '|',  'Link', 'Unlink', 'Anchor' , 'Image', '|', 'Source'];
$default_toolbars[3] =  $default_toolbars[4] = [];
for ($i = 1; $i <= 4; $i++) {
    $arr_toolbars[$i] = $wysiwyg_config->get($item['virtual_filename'], "array_toolbar{$i}");
    //if (empty($arr_toolbars[$i])) $arr_toolbars[$i] = $default_toolbars[$i];
    if ($arr_toolbars[$i]) foreach ($arr_toolbars[$i] as $button) if (!in_array($button, $used_buttons) && ($button != '|'))  $used_buttons[] = $button;
}
foreach ($system_buttons as $button) if (!in_array($button, $unused_buttons) && !in_array($button, $used_buttons) && ($button != '|')) $unused_buttons[] = $button;
foreach ($extra_buttons as $button) if (!in_array($button, $unused_buttons) && !in_array($button, $used_buttons) && ($button != '|')) $unused_buttons[] = $button;
?>
<schlix-config:textbox config-key="str_config_schlix_selector"   label="<?= ___('Text Area Selector (CSS Class) - set it to wysiwyg for backend editing') ?>" config-default-value="wysiwyg" placeholder="<?= ___('e.g.') ?> wysiwyg ~ <?= ___('This option allows you to specify a CSS selector for the areas that CKEditor should make editable') ?>" />
<br />
<!-- begin tabs -->
<x-ui:schlix-tab-container>
    <!-- tab -->
    <x-ui:schlix-tab id="tab_extensions" fonticon="fas fa-puzzle-piece" label="<?= ___('Extensions') ?>"> 
        <!-- tab content -->
        <x-ui:row>
            <!-- col -->
            <x-ui:column sm="6" md="4">
                <!-- ext -->
                <schlix-config:checkboxgroup  config-key="array_plugins" label="<?= ___('System Plugins') ?>" config-default-value="basicstyles,blockquote,clipboard,colorbutton,codesnippet,colordialog,contextmenu,copyformatting,dialogadvtab,div,elementspath,enterkey,entities,filebrowser,find,floatingspace,font,format,horizontalrule,htmlwriter,iframe,iframedialog,image,indentblock,indentlist,justify,language,link,list,liststyle,magicline,maximize,onchange,pagebreak,pastefromword,pastetext,preview,removeformat,resize,save,selectall,showblocks,showborders,sourcearea,specialchar,stylescombo,tab,table,tabletools,toolbar,undo,widget,wysiwygarea" >
                    <!-- system -->
                    <?php if ($system_plugins): ?>
                        <?php foreach ($system_plugins as $ext): ?>
                            <schlix-config:option value="<?= ___h($ext) ?>"><?= ___h($ext) ?></schlix-config:option>
                        <?php endforeach ?>
                    <?php else: ?>
                        <?= ___('Error: no system plugin') ?>
                    <?php endif ?>
                </schlix-config:checkboxgroup>                     

                <!-- ext -->
                <schlix-config:checkboxgroup  config-key="array_extra_plugins" label="<?= ___('Extra Plugins') ?>" config-default-value="codemirror,schlixcmsbrowser,fontawesome">
                    <!-- system -->
                    <?php if ($system_extra_plugins): ?>
                        <?php foreach ($system_extra_plugins as $ext): ?>
                            <schlix-config:option value="<?= ___h($ext) ?>"><?= ___h($ext) ?></schlix-config:option>
                        <?php endforeach ?>
                    <?php else: ?>
                        <?= ___('Error: no extra system plugin') ?>
                    <?php endif ?>
                    <!-- user -->
                    <?php if ($user_plugins): ?>
                        <?php foreach ($user_plugins as $ext): ?>
                            <schlix-config:option value="||<?= ___h($ext) ?>"><?= ___h($ext) ?> (<?= ___('addon') ?>)</schlix-config:option>
                        <?php endforeach ?>
                    <?php else: ?>
                        <?= sprintf(___('No additional plugin in %s'), $url_user_plugins) ?>
                    <?php endif ?>

                </schlix-config:checkboxgroup>                     
                <!-- end ext -->
                <p><em><?= sprintf(___('Additional plugins can be installed to %s'), $url_user_plugins) ?></em></p>
                <schlix-config:textbox config-key="str_config_removePlugins" label="<?= ___('Disable the following plugins (comma separated)') ?>" config-default-value="" placeholder="<?= ___('e.g.') ?> filebrowser,save,font ~ <?= ___('This option will override the loaded plugins from above if specified') ?>" />
            </x-ui:column>
            <!-- col -->
            <x-ui:column sm="6" md="4">
                <!-- ext -->
                <schlix-config:radiogroup  config-key="str_config_language" label="<?= ___('Language') ?>" >
                    <!-- system -->
                    <schlix-config:option value=""><?= ___('English (default)') ?></schlix-config:option>
                    <?php if ($system_langs): ?>
                        <?php foreach ($system_langs as $ext): ?>
                            <schlix-config:option value="<?= ___h($ext) ?>"><?= ___h($ext) ?></schlix-config:option>
                        <?php endforeach ?>
                    <?php else: ?>
                        <?= ___('Error: no system theme') ?>
                    <?php endif ?>
                </schlix-config:radiogroup>  
                <!-- dir -->

                <schlix-config:radiogroup  config-key="str_config_contentsLangDirection" label="<?= ___('Language Direction') ?>" config-default-value="" >
                    <schlix-config:option value="ltr"><?= ___('LTR (Left-to-Right) - default') ?></schlix-config:option>
                    <schlix-config:option value="rtl"><?= ___('RTL (Right-to-Left)') ?></schlix-config:option>
                    <?php /* <schlix-config:option value="custom"><?= ___('Custom function') ?></schlix-config:option> */ ?>
                </schlix-config:radiogroup> 

                <!-- end ext -->        

            </x-ui:column>
            <!-- col -->
            <x-ui:column sm="6" md="4">
                <!-- ext -->
                <schlix-config:radiogroup  config-key="str_config_skin" label="<?= ___('Skins') ?>" config-default-value="lightgray"  >
                    <!-- system -->
                    <?php if ($system_skins): ?>
                        <?php foreach ($system_skins as $ext): ?>
                            <schlix-config:option value="<?= ___h($ext) ?>"><?= ___h($ext) ?></schlix-config:option>
                        <?php endforeach ?>
                    <?php else: ?>
                        <?= ___('Error: no system skin') ?>
                    <?php endif ?>
                    <!-- user -->
                    <?php if ($user_skins): ?>
                        <?php foreach ($user_skins as $ext): ?>
                            <schlix-config:option value="||<?= ___h($ext) ?>"><?= ___h($ext) ?> (<?= ___('addon') ?>)</schlix-config:option>
                        <?php endforeach ?>
                    <?php else: ?>
                        <?= sprintf(___('No additional skin in %s'), $url_user_skins) ?>
                    <?php endif ?>
                </schlix-config:radiogroup>                     
                <!-- end ext -->  
                <p><em><?= sprintf(___('Additional skins can be installed to %s'), $url_user_skins) ?></em></p>

            </x-ui:column>

        </x-ui:row>
        <!-- end tab content -->
    </x-ui:schlix-tab>
    <!-- tab -->
    <x-ui:schlix-tab id="tab_basic" fonticon="fas fa-stream" label="<?= ___('Basic Setup') ?>"> 
        <x-ui:row>
            <!-- col -->
            <x-ui:column md="6">
                <!-- col content -->
                <schlix-config:radiogroup  config-key="str_media_permission" label="<?= ___('SCHLIX CMS Media Manager File Permission') ?>" config-default-value="full" >
                    <schlix-config:option value=""><?= ___('None - will disable all other media options below') ?></schlix-config:option>
                    <schlix-config:option value="full"><?= ___('Full access (backend)') ?></schlix-config:option>
                    <schlix-config:option value="limiteduser"><?= ___('User directory only') ?></schlix-config:option>
                </schlix-config:radiogroup> 

                <schlix-config:radiogroup  config-key="str_file_browser" label="<?= ___('Media Manager (files)') ?>" config-default-value="schlix" >
                    <schlix-config:option value="none"><?= ___('None') ?></schlix-config:option>
                    <schlix-config:option value="schlix"><?= ___('Use the default from SCHLIX CMS') ?></schlix-config:option>
                    <?php /* <schlix-config:option value="custom"><?= ___('Custom function') ?></schlix-config:option> */ ?>
                </schlix-config:radiogroup> 

                <schlix-config:radiogroup  config-key="str_image_browser" label="<?= ___('Media Manager (images)') ?>" config-default-value="schlix" >
                    <schlix-config:option value="none"><?= ___('None') ?></schlix-config:option>
                    <schlix-config:option value="schlix"><?= ___('Use the default from SCHLIX CMS') ?></schlix-config:option>
                    <?php /* <schlix-config:option value="custom"><?= ___('Custom function') ?></schlix-config:option> */ ?>
                </schlix-config:radiogroup>             

                <!-- end col content -->
            </x-ui:column>
            <!-- col -->
        </x-ui:row>
        <!-- end row -->        
    </x-ui:schlix-tab>
    <!-- tab -->
    <x-ui:schlix-tab id="tab_editor_appearance" fonticon="far fa-window-restore" label="<?= ___('Appearance') ?>"> 
        <!-- used buttons -->
        <h3><?= ___('Buttons') ?></h3>
        <!-- show used buttons -->
        <?php for ($i = 1; $i <= 4; $i++): ?>
            <ul id="toolbar_<?= $i ?>" class="ckeditor-toolbars button-target cke_ltr">
                <?php if ($arr_toolbars[$i]): ?>               
                    <!-- now show the buttons -->
                    <?php $j = 1 ?>
                    <?php foreach ($arr_toolbars[$i] as $button): ?>
                        <?php if ($button == '|'): ?>
                            <li class="editor-toolbar-button_separator" id="ckeditor-separator-<?= $i * $j ?>">
                                |                                
                                <input type="hidden" name="array_toolbar<?= $i; ?>[]" value="<?= $button ?>" />
                            </li>
                        <?php elseif (in_array($button, $editor_text_buttons)): ?>
                            <li class="editor-toolbar-button_dropdown" id="ckeditor-button-<?= $button ?>">
                                <?= $button; ?> <i class="fa fa-caret-down"></i>
                                <input type="hidden"  name="array_toolbar<?= $i; ?>[]" value="<?= $button ?>" />
                            </li>                   
                        <?php else: ?>
                            <?php
                            $is_addon_button = !in_array($button, $system_buttons);
                            $lcase_btn = strtolower($button);
                            $icon = !$is_addon_button ? "cke_button_icon cke_button__{$lcase_btn} cke_button__{$lcase_btn}_icon" : 'fa fa-puzzle-piece';
                            //$icon = 'cke_button cke_button__source';
                            ?>
                            <li class="editor-toolbar-button" id="ckeditor-button-<?= $button ?>">
                                <span class="<?= $icon ?>" title="<?= $button; ?>" style="display:inline !important"></span> <?= $is_addon_button ? $button : '' ?>
                                <input type="hidden" name="array_toolbar<?= $i; ?>[]" value="<?= $button ?>" />
                            </li>                        
                        <?php endif ?>
                        <?php $j++ ?>
                    <?php endforeach ?>
                    <!-- end show the buttons -->
                <?php endif ?>
            </ul>
        <?php endfor ?>                 
        <h3><?= ___('Unused buttons') ?></h3>
        <ul id="toolbar_unused" class="ckeditor-unused-buttons button-target cke_ltr">
            <!-- now show the buttons -->
            <?php foreach ($unused_buttons as $button): ?>
                <?php if ($button == '|'): ?>
                    <li class="editor-toolbar-button_separator" id="editor_unused_separator" data-clone="1">
                        |                                
                        <input type="hidden" name="array_unused_buttons[]" value="<?= $button ?>" />
                    </li>
                <?php elseif (in_array($button, $editor_text_buttons)): ?>
                    <li class="editor-toolbar-button_dropdown" id="ckeditor-button-<?= $button ?>">
                        <?= $button; ?> <i class="fa fa-caret-down"></i>
                        <input type="hidden"  name="array_unused_buttons[]" value="<?= $button ?>" />
                    </li>                   
                <?php else: ?>
                    <?php
                    $is_addon_button = !in_array($button, $system_buttons);
                    $lcase_btn = strtolower($button);
                    $icon = !$is_addon_button ? "cke_button_icon cke_button__{$lcase_btn} cke_button__{$lcase_btn}_icon" : 'fa fa-puzzle-piece';
                    ?>
                    <li class="editor-toolbar-button" id="ckeditor-button-<?= $button ?>">
                        <span class="<?= $icon ?>" title="<?= $button; ?>" style="display:inline !important"></span> <?= $button ?>
                        <input type="hidden" name="array_toolbar<?= $i; ?>[]" value="<?= $button ?>" />
                    </li>                        

                <?php endif ?>
            <?php endforeach ?>
            <!-- end show the buttons -->
        </ul> 

        <!-- end toolbar config -->
        <h3><?= ___('Advanced appearance options') ?></h3>
        <p><?= ___('You can leave these values to the default') ?></p>
        <schlix-config:checkbox config-key="bool_config_toolbarCanCollapse" label="<?= ___('Collapsible toolbar') ?>" config-default-value="0" />
        <schlix-config:checkbox config-key="bool_config_toolbarStartupExpanded" label="<?= ___('Toolbar should be expanded on startup') ?>" config-default-value="1" />
        <schlix-config:checkbox config-key="bool_config_autoGrow_onStartup" label="<?= ___('Auto grow on init') ?>" config-default-value="1" />
        <schlix-config:checkbox config-key="bool_config_disableNativeTableHandles" label="<?= ___('Disables the table tools offered natively by the browser (currently Firefox only) to perform quick table editing operations, like adding or deleting rows and columns.') ?>" config-default-value="1" />

        <x-ui:row>
            <!-- col -->
            <x-ui:column md="6">

                <schlix-config:textbox config-key="str_config_removeDialogTabs" label="<?= ___('Remove the following dialog tabs') ?>" config-default-value='link:upload;image:upload' />

                <div class="form-inline">
                    <span class="editor_size_label"><?= ___('Editor Min Size') ?></span>
                    <schlix-config:textbox config-key="str_config_resize_minWidth" style="width:100px" />
                    x                            
                    <schlix-config:textbox config-key="str_config_resize_minHeight" style="width:100px" />
                </div>

                <div class="form-inline">
                    <span class="editor_size_label"><?= ___('Editor Max Size') ?></span>
                    <schlix-config:textbox config-key="str_config_resize_maxWidth" style="width:100px" />
                    x                            
                    <schlix-config:textbox config-key="str_config_resize_maxHeight" style="width:100px" />
                </div>


                <div class="form-inline">
                    <span class="editor_size_label"><?= ___('Editor Size') ?></span>
                    <schlix-config:textbox config-key="str_config_width" style="width:100px" config-default-value="100%" />
                    x                            
                    <schlix-config:textbox config-key="str_config_height" style="width:100px" config-default-value='200' />

                    <schlix-config:checkbox config-key="bool_config_resizeEnabled" label="<?= ___('Enable resize') ?>" config-default-value="1" style="margin-left:1em" />

                </div>

                <div class="form-inline">
                    <span class="editor_size_label"><?= ___('Auto Grow') ?></span>
                    <schlix-config:textbox config-key="str_config_autoGrow_minHeight" style="width:100px" config-default-value="400" label="<?= ___('Min. height') ?>" />
                    <schlix-config:textbox config-key="str_config_autoGrow_maxHeight" style="width:100px" config-default-value="800" label="<?= ___('Max. height') ?>" />
                    <schlix-config:textbox config-key="str_config_autoGrow_bottomSpace" style="width:100px" label="<?= ___('Bottom space') ?>" />

                </div>

                <div class="form-inline">
                    <span class="editor_size_label"><?= ___('File Browser Size') ?></span>
                    <schlix-config:textbox config-key="str_config_filebrowserWindowWidth" style="width:100px" config-default-value="800" />
                    x                            
                    <schlix-config:textbox config-key="str_config_filebrowserWindowHeight" style="width:100px" config-default-value="500" />
                </div>


                <schlix-config:textbox config-key="str_config_bodyId" label="<?= ___('Custom editor body CSS ID') ?>" placeholder="<?= ___('e.g.') ?> my_id ~ <?= ___('specify an id for the body of each editor instance') ?>" />
                <schlix-config:textbox config-key="str_config_bodyClass" label="<?= ___('Custom editor body CSS class') ?>" placeholder="<?= ___('e.g.') ?> my-custom-class ~ <?= ___('specify a class for the body of each editor instance') ?>" />



            </x-ui:column>
            <!-- col -->
            <x-ui:column md="6">

                <!-- col content -->
                <schlix-config:textbox config-key="str_config_format_tags" class="monospaced" label="<?= ___('List of formats tags (semicolon ; separated)') ?>" placeholder="p;h1;h2;h3;h4;h5;h6;pre;address;div" />
                <schlix-config:textarea config-key="str_config_font_names" class="monospaced" label="<?= ___('List of fonts names to be displayed in the Font combo (semicolon ; separated)') ?>" placeholder="Arial/Arial, Helvetica, sans-serif;Times New Roman/Times New Roman, Times, serif;Verdana;Open Sans" />
                <schlix-config:textbox config-key="str_config_fontSize_sizes" label="<?= ___('List of fonts size to be displayed in the Font Size combo  (semicolon ; separated)') ?>" placeholder="12 Pixels/12px;Big/2.3em;30 Percent More/130%;Bigger/larger;Very Small/x-small" />


                <!-- end col content -->
            </x-ui:column>
        </x-ui:row>
        <!-- row -->
        <x-ui:row>
            <!-- col -->
            <x-ui:column md="12">

                <!-- col -->
                <h3><?= ___('Style Formats') ?></h3>
                <schlix-config:textarea config-key="str_config_stylesSet" class="monospaced" label="<?= ___('StyleSet: Styles definition set (array/string)') ?>" placeholder="{ name: 'Strong Emphasis', element: 'strong' }, { name: 'Emphasis', element: 'em' }" />
                <em><?= sprintf(___('<a href="%s" target="_blank">This option</a> enables you to override and add custom formats to the editor.'), 'http://docs.ckeditor.com/#!/api/CKEDITOR.config-cfg-stylesSet') ?></em>             
                <hr />
                <schlix-config:textarea config-key="str_config_stylesheetParser_skipSelectors" class="monospaced" label="<?= ___('Stylesheet Parser Plugin: skip selectors regular expressions') ?>" placeholder="/(^body\.|^caption\.|\.high|^\.)/i"  />
                <em><?= sprintf(___('<a href="%s" target="_blank">A regular expression</a> that defines whether a CSS rule will be skipped by the Stylesheet Parser plugin'), 'http://docs.ckeditor.com/#!/api/CKEDITOR.config-cfg-stylesheetParser_skipSelectors') ?></em>
                <hr />
                <schlix-config:textarea config-key="str_config_stylesheetParser_validSelectors" class="monospaced" label="<?= ___('Stylesheet Parser Plugin: skip selectors regular expressions') ?>" placeholder="/\^(p|span)\.\w+/"  />
                <em><?= sprintf(___('<a href="%s" target="_blank">A regular expression</a> that defines which CSS rules will be used by the Stylesheet Parser plugin'), 'http://docs.ckeditor.com/#!/api/CKEDITOR.config-cfg-stylesheetParser_validSelectors') ?></em> 



                <!-- end col -->
            </x-ui:column>
        </x-ui:row>
        <!-- end row -->

    </x-ui:schlix-tab>
    <!-- tab -->
    <x-ui:schlix-tab id="tab_content_filtering" fonticon="fas fa-filter" label="<?= ___('Content Filtering') ?>"> 

        <!-- row -->
        <x-ui:row>
            <!-- col -->
            <x-ui:column md="6">
                <!-- col content -->
                <schlix-config:dropdownlist  config-key="str_config_doctype" label="<?= ___('Document type') ?>" >
                    <schlix-config:option value=""><?= ___('Default DocType') ?></schlix-config:option>
                    <schlix-config:option value="<?= ___h('<!DOCTYPE html>') ?>">HTML5 (<?= ___('preferred') ?>)</schlix-config:option>
                    <schlix-config:option value="<?= ___h('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd"> ') ?>">HTML 4.01 Strict</schlix-config:option>
                    <schlix-config:option value="<?= ___h('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd"> ') ?>">HTML 4.01 Transitional</schlix-config:option>
                    <schlix-config:option value="<?= ___h('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd"> ') ?>">HTML 4.01 Frameset</schlix-config:option>
                    <schlix-config:option value="<?= ___h('<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"> ') ?>">XHTML 1.1</schlix-config:option>
                    <schlix-config:option value="<?= ___h('<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"> ') ?>">XHTML 1.0 Strict</schlix-config:option>
                    <schlix-config:option value="<?= ___h('<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"> ') ?>">XHTML 1.0 Transitional</schlix-config:option>
                    <schlix-config:option value="<?= ___h('<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Frameset//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd"> ') ?>">XHTML 1.0 Frameset</schlix-config:option>
                </schlix-config:dropdownlist> 

                <schlix-config:checkbox config-key="bool_config_htmlEncodeOutput" label="<?= ___('Escape HTML when the editor updates the original input element.') ?>" config-default-value="0" />


                <schlix-config:textbox config-key="str_config_entities" label="<?= ___('Comma separated list of entity names that is used instead of characters.') ?>" placeholder="<?= ___('e.g.') ?> 160,nbsp,162,cent,8364,euro,163,pound." />
                <schlix-config:checkbox config-key="bool_config_basicEntities" label="<?= sprintf(___('Escape basic HTML entities in the document, including %s'), ___h(' &nbsp;, &gt; &lt; &amp;')) ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_entities" label="<?= ___('Use HTML entities in the editor output') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_entities_greek" label="<?= ___('Convert some symbols, mathematical symbols, and Greek letters to HTML entities') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_entities_latin" label="<?= ___('Convert some Latin characters (Latin alphabet No. 1, ISO 8859-1) to HTML entities') ?>" config-default-value="1" />

                <schlix-config:radiogroup  config-key="str_ProcessNumericalEntities" label="<?= ___('Process Numerical Entities') ?>" config-default-value="false" >
                    <schlix-config:option value="false"><?= ___('False') ?></schlix-config:option>
                    <schlix-config:option value="true"><?= ___('True') ?></schlix-config:option>
                    <schlix-config:option value="force"><?= ___('Force (convert all entities into hex format)') ?></schlix-config:option>
                </schlix-config:radiogroup> 
                <em><?= sprintf(___('<a href="%s" target="_blank">This option</a> convert all remaining characters not included in the ASCII character table to their relative decimal numeric representation of HTML entity. When set to force, it will convert all entities into this format.'), 'http://docs.ckeditor.com/#!/api/CKEDITOR.config-cfg-entities_processNumerical') ?></em> 


                <!-- end col content -->
            </x-ui:column>
            <!-- col -->
            <x-ui:column md="6">
                <!-- col content -->

                <schlix-config:checkbox config-key="bool_config_image_prefillDimensions" label="<?= ___('Enable custom image dimension (uncheck this box for responsive theme)') ?>" config-default-value="0" />                    
                <schlix-config:checkbox config-key="bool_config_image_removeLinkByEmptyURL" label="<?= ___('Remove links when emptying the link URL field in the Image dialog window') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_wrapTable" label="<?= sprintf(___('Wrap the entire table instead of individual cells when creating a %s in a table cell'), ___h('<div>')) ?>" config-default-value="0" />

                <schlix-config:checkbox config-key="bool_emailProtection" label="<?= ___('Enable email address javascript obfuscation to prevent spam') ?>" />
                <schlix-config:checkbox config-key="bool_config_fillEmptyBlocks" label="<?= sprintf(___('Add a filler %s to empty block tags like %s or %s'), ___h('&nbsp;'), ___h('<p>'), ___h('<div>')) ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_forceSimpleAmpersand" label="<?= sprintf(___("Force using %s instead of %s in element attributes values."), ___h("'&'"), ___h("'&amp;'")) ?>" config-default-value="0" />
                <schlix-config:checkbox config-key="bool_config_ignoreEmptyParagraph" label="<?= ___('Ignore empty paragraph') ?>" config-default-value="1" />

                <h4><?= ___('Advanced Editing Options') ?></h4>
                <schlix-config:checkbox config-key="bool_config_forceEnterMode" label="<?= ___('Forces the use of enterMode as line break regardless of the context (not recommended!)') ?>" config-default-value="0" />                    
                <schlix-config:dropdownlist config-key="str_behaviour_enter_key" label="<?= ___('ENTER key behaviour') ?>" config-default-value="" >
                    <schlix-config:option value=""><?= ___('Default') ?></schlix-config:option>
                    <schlix-config:option value="1"><?= sprintf(___('New %s paragraphs are created'), ___h('<p>')) ?></schlix-config:option>
                    <schlix-config:option value="2"><?= sprintf(___('Lines are broken with %s elements'), ___h('<br>')) ?></schlix-config:option>
                    <schlix-config:option value="3"><?= sprintf(___('New %s blocks are created'), ___h('<div>')) ?></schlix-config:option>
                </schlix-config:dropdownlist> 

                <schlix-config:dropdownlist config-key="str_behaviour_shiftenter_key" label="<?= ___('SHIFT+ENTER key behaviour') ?>" config-default-value="" >
                    <schlix-config:option value=""><?= ___('Default') ?></schlix-config:option>
                    <schlix-config:option value="1"><?= sprintf(___('New %s paragraphs are created'), ___h('<p>')) ?></schlix-config:option>
                    <schlix-config:option value="2"><?= sprintf(___('Lines are broken with %s elements'), ___h('<br>')) ?></schlix-config:option>
                    <schlix-config:option value="3"><?= sprintf(___('New %s blocks are created'), ___h('<div>')) ?></schlix-config:option>
                </schlix-config:dropdownlist> 





                <!-- end col content -->
            </x-ui:column>
        </x-ui:row>

        <!-- row -->
        <h3><?= ___('Advanced element and style options') ?></h3>
        <x-ui:row>
            <!-- col -->
            <x-ui:column md="6">

                <!-- col content -->
                <schlix-config:checkbox config-key="bool_config_forcePasteAsPlainText" label="<?= ___("Force all pasting operations to insert on plain text into the editor") ?>" config-default-value="0" />
                <schlix-config:checkbox config-key="bool_config_fullPage" label="<?= ___("This profile is being used to edit full HTML page, including html, head and body elements") ?>" config-default-value="0" />
                <schlix-config:textbox config-key="str_config_extraAllowedContent" label="<?= ___('Extra allowed contents (important - only change as necessary)') ?>" placeholder="<?= ___('e.g.') ?> p(*)[*]{*};div(*)[*]{*};li(*)[*]{*};ul(*)[*]{*}" />

                <em><?= sprintf(___('<a href="%s" target="_blank">This option</a> allows you to control what contents should be protected from editing'), 'http://docs.ckeditor.com/#!/api/CKEDITOR.config-cfg-extraAllowedContent') ?></em> 
                <schlix-config:textbox config-key="str_donot_remove_these_elements" label="<?= ___('Prevent the following empty elements from being removed') ?>" config-default-value="strike,span,b,i,div,script" placeholder="<?= ___('e.g.') ?> strike,span,i,div,script" />

                <schlix-config:textbox config-key="str_config_custom_elements" label="<?= ___('Specify non-HTML elements for the editor') ?>" placeholder="<?= ___('e.g.') ?> mycustomblock,~mycustominline ~ <?= ___('You can prefix the element names with a ~ if you want the element to behave as a span element and not a div element.') ?>" />


                <schlix-config:textbox config-key="str_allowedContent" label="<?= ___('Limit valid elements to (space separated list)') ?>" placeholder="<?= ___('e.g.') ?> em p br" />
                <em><?= sprintf(___('<a href="%s" target="_blank">This option</a> allows you to control which elements that should be allowed'), 'http://docs.ckeditor.com/#!/guide/dev_allowed_content_rules') ?></em> 
                <schlix-config:textbox config-key="str_disallowedContent" label="<?= ___('Space separated list of elements that will be removed.') ?>" placeholder="<?= ___('e.g.') ?> strong em" />            
                <em><?= sprintf(___('<a href="%s" target="_blank">This option</a> allows you to control which elements that should be disallowed'), 'http://docs.ckeditor.com/#!/guide/dev_disallowed_content') ?></em> 
                <schlix-config:textarea config-key="str_protectedSource" class="monospaced" label="<?= ___('Protect the following code from cleanup (one regex pattern per line)') ?>" placeholder="<?= ___h(' /(<asp:[^\>]+>[\s|\S]*?<\/asp:[^\>]+>)|(<asp:[^\>]+\/>)/gi') ?>" />
                <em><?= sprintf(___('<a href="%s" target="_blank">This option</a> allows you to control what contents should be protected from editing'), 'http://docs.ckeditor.com/#!/api/CKEDITOR.config-cfg-protectedSource') ?></em> 

                <!-- end col content -->
            </x-ui:column>
            <!-- col -->
            <x-ui:column md="6">
                <!-- col content -->
                <schlix-config:textarea config-key="str_config_removeFormatTags" class="monospaced" label="<?= ___('Remove format: List of inline elements to be removed when executing the remove format command. (comma , separated)') ?>" placeholder="b,big,cite,code,del,dfn,em,font,i,ins,kbd,q,s,samp,small,span,strike,strong,sub,sup,tt,u,var" />
                <em><?= sprintf(___('<a href="%s" target="_blank">The list</a> must be inline elements only'), 'http://docs.ckeditor.com/#!/api/CKEDITOR.config-cfg-removeFormatTags') ?></em> 
                <schlix-config:textarea config-key="str_config_removeFormatAttributes" class="monospaced" label="<?= ___('Remove format: List of attributes to be removed when executing the remove format command. (comma , separated)') ?>" placeholder="class,style,lang,width,height,align,hspace,valign" />
                <em><?= sprintf(___('<a href="%s" target="_blank">The list</a> must be inline elements only'), 'http://docs.ckeditor.com/#!/api/CKEDITOR.config-cfg-removeFormatTags') ?></em> 

                <!-- end col content -->
            </x-ui:column>
        </x-ui:row>

    </x-ui:schlix-tab>
    <!-- tab -->
    <x-ui:schlix-tab id="tab_scripts" fonticon="fas fa-code" label="<?= ___('Custom Scripts') ?>"> 
        <p><?= ___('The following is generated script from the previously saved configuration values') ?></p>
        <pre class="config"><?= ___h($ckeditor4->getUncachedConfigurationScript()); ?>,
// <?= ___('You can insert additional configuration options here (optional)') ?>
            <schlix-config:textarea config-key="str_additional_config" />
}

   <schlix-config:textarea config-key="str_schlix_function_setup" class="monospaced" label="<?= ___('// Additional setup code') ?>" placeholder="function(editor) {.......}"  />

function __initCKEditor4()
{
    SCHLIX.Util.augmentObject(CKEDITOR.config, __ckeditor4_config,true);
        
    CKEDITOR.replaceClass = __ckeditor4_config.schlix_selector;
    // <?= ___('For example') ?>:
    // for (var instance in CKEDITOR.instances )
    // {           
    //     CKEDITOR.instances[instance].on( 'change', SCHLIX.CMS.WysiwygHelper.fixAutoUpdateForm);
    // }
   
   <schlix-config:textarea config-key="str_schlix_function_init" class="monospaced" label="<?= ___('// Custom code that will be excuted for all instances') ?>" placeholder="function(editor) {.......}" 
config-default-value="// please keep this function so you can save with Apply button
for (var instance in CKEDITOR.instances )
{  
    CKEDITOR.instances[instance].on( 'change', SCHLIX.CMS.WysiwygHelper.fixAutoUpdateForm);
}" />

}
            
        </pre>
        <hr />
        <h4><?= ___('Alternative configuration script') ?></h4>
        <p><?= ___('Replace the entire configuration script above with your own (caution!)') ?></p>
        <strong>// <?= ___('Javascript - free style ') ?></strong>
        <schlix-config:textarea config-key="str_replacement_config"   style="min-height:400px" placeholder="function __initCKEditor4() {...}" />


    </x-ui:schlix-tab>
</x-ui:schlix-tab-container>



<schlix-config:checkbox config-key="reset_to_default" label="<?= ___('Reset to default settings') ?>"  />
<x-ui:row id="alert-reset-option" style="display:none">
    <x-ui:column md="6" class="alert alert-warning">
        <schlix-config:dropdownlist  config-key="reset_to_default_profile" label="<?= ___('Reset the configuration to the following profile') ?>" config-default-value="<?= $possible_css_files[0] ?>" >
            <schlix-config:option value=""><?= ___('Please select') ?></schlix-config:option>
            <schlix-config:option value="full"><?= ___('Full') ?></schlix-config:option>
            <schlix-config:option value="simple"><?= ___('Simple') ?></schlix-config:option>
            <schlix-config:option value="simple-nomediamanager"><?= ___('Simple - No Media') ?></schlix-config:option>
        </schlix-config:dropdownlist> 
    </x-ui:column>
</x-ui:row>  