<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION'))
    die();

global $Blocks;

$fieldnames= array('email_address', 'display_name', 'firstname','lastname','email_address','date_of_birth','gender','summary','description');
$chk_userinfo = [];
foreach ($fieldnames as $field)
{
    $chk_userinfo[$field] = isset($_POST[$field]) ? $_POST[$field] : $userinfo[$field];
}

//print_r($userinfo);

if (fpost_int('dob_year') && fpost_int('dob_month') && fpost_int('dob_day'))
{
    $user_input_date = fpost_int('dob_year').'-'.str_pad(fpost_int('dob_month'),2,'0',STR_PAD_LEFT).'-'.str_pad(fpost_int('dob_day'),2,'0',STR_PAD_LEFT);
    $chk_userinfo['date_of_birth'] = $user_input_date;
} 
?>

<h1 class="title"><i class="fa fa-user"></i> <?= ___('Edit Profile') ?></h1>
<hr />

<x-ui:row>
    <x-ui:column sm="2" md="2">
        
       <?php 
       /* example on how to call SCHLIX\cmsPageOutput::BlockCategory('menu_members') from application template file. If you want to do it this way then you will have to  */
       $Blocks->displayBlockByCategoryNameRerun('sidebar_members');
       ?>
    </x-ui:column>
    
    <x-ui:column sm="10">
        
        <?php if (___c($error_list) > 0): ?>
            <!-- errors -->
            <div class="alert alert-danger">
                <?php foreach ($error_list as $error_str): ?>
                    <i class="fa fa-times"></i> <?= $error_str ?><br />
                <?php endforeach ?>
            </div>
        <?php endif; ?>            
        <?php if ($_SESSION['user_profile_update_status']): ?>
            <div class="alert alert-success">
                    <i class="fa fa-check"></i> <?= $_SESSION['user_profile_update_status'] ?><br />
            </div>
        <?php $_SESSION['user_profile_update_status'] = '' ?>
        <?php endif ?>
        <!-- content -->
        <?= $this->getConfig('str_myprofile_text') ?>
        <!-- end content -->
        
<!-- output -->

<div class="schlix-ajax-output"></div>
<!-- end output -->
<x-ui:form-simple-ajax method="post" data-action="<?= $this->createFriendlyURL('action=userupdateprofile'); ?>" name="editprofile" id="editprofile" enctype="multipart/form-data" autocomplete="off">

<!-- row -->
<x-ui:row>
    <!-- col -->
    <x-ui:column sm="6" md="4">
        <!-- col content -->

                    <x-ui:csrf />

                    <div class="main-profile">


                            <x-ui:textbox name="username" id="username" required="required" fonticon="fa fa-user" label="<?= ___('Username') ?>" placeholder="<?= ___('Username') ?>" data-field="username" readonly="readonly" />                      
                            <x-ui:textbox name="email_address" id="email_address" required="required" fonticon="fa fa-envelope" label="<?= ___('Email') ?>" placeholder="<?= ___('Enter your Email') ?>" data-field="email_address"  />                             
                              

                            <x-ui:form-group>
                                <label for="firstname" class="control-label"><?= ___S('First & Last Name') ?></label>
                                <x-ui:input-group>
                                <x-ui:input-addon>
                                    <i class="fa fa-users"></i>
                                </x-ui:input-addon>                                    
                                <x-ui:textbox name="firstname" id="firstname" required="required" placeholder="<?= ___('Enter your first name') ?>" data-field="firstname" />
                                
                                <x-ui:textbox name="lastname" id="lastname" required="required" placeholder="<?= ___('Enter your last name') ?>" data-field="lastname"  />
                                </x-ui:input-group>
                            </x-ui:form-group>

                        
                        <!-- field -->
                        <x-ui:textbox name="display_name" id="display_name" required="required" fonticon="fa fa-user" label="<?= ___('Display Name') ?>" placeholder="<?= ___('Optional display name') ?>" data-field="display_name" />                        <!-- field -->
    

                        <?php if ($this->getConfig('bool_require_dob')) : ?>
                        
                        <x-ui:form-group>
                            <label for="dob_year" class=" control-label"><?= ___('Date of Birth') ?></label>
                            <?= \INPUT::DatePicker('dob', $userinfo['date_of_birth'], 1900, date('Y')) ?>
                        </x-ui:form-group>
                        <?php endif ?>
                        
                        <?php if ($this->getConfig('bool_require_gender')) : ?>
                        <x-ui:form-group>
                            <label class=" control-label"><?= ___('Gender') ?></label><x-ui:clearfix />
                        <x-ui:radio-group name="gender" data-field="gender" inline="1">
                            <x-ui:option value="1"><i class="fa fa-male"></i>&nbsp;<?= ___('Male') ?></x-ui:option>
                            <x-ui:option value="2"><i class="fa fa-female"></i>&nbsp;<?= ___('Female') ?></x-ui:option>
                            <x-ui:option value="0"><?= ___('Unspecified') ?></x-ui:option>
                        </x-ui:radio-group>
                        </x-ui:form-group>
                        <?php endif ?>
                        <!-- pic -->
                        <?php /*
                        <x-ui:form-group>
                            <label><?= ___('Avatar') ?></label>
                            <br />

                            <p><x-ui:file-upload name="user_avatar" id="user_avatar" fonticon="far fa-folder-open" label="<?= ___("Change avatar/picture") ?>"  max-file-size="<?= min(get_real_max_upload_size(), 200000) ?>" /></p>
                            <p><img src="<?= $this->getUserAvatarURLByExistingUserInfo($userinfo, 'medium') ?>" id="preview_avatar"  style="max-width:256px;border:none" /></p>
                        </x-ui:form-group> */ ?>
                        <x-ui:schlix-document-image-uploader label="<?= ___("Change avatar/picture") ?>" accept="image/png, image/jpeg, image/gif" fonticon="far fa-folder-open" name="user_avatar" id="user_avatar" data-field="avatar" data-dir-key="avatar_medium" data-no-del="1" />
                        <!-- end pic -->
                        <x-ui:button button-type="ok"  type="submit" name="submit" data-form-submit="1" id="btn-register" value="Submit" label="<?= ___('Update') ?>" fonticon="fas fa-user" block="1" size="large" />                        
                    </div>               

                <!-- end form -->
        <!-- end col content -->
    </x-ui:column>
    <!-- col -->
    <x-ui:column sm="6" md="8">
        <!-- pic and bio -->
        <!-- bio -->
        <x-ui:wysiwyg label="<?= ___('User Bio - Intro') ?>" name="summary" id="summary" data-field="summary" />
        <x-ui:wysiwyg label="<?= ___('User Bio - Details') ?>" name="description" id="summary" data-field="description" />

        <!-- end pic and bio -->
    </x-ui:column>
</x-ui:row>     

</x-ui:form-simple-ajax>
        
    </x-ui:column>
</x-ui:row>
