<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * Company Profile - theme
 * 
 * This is an example of company profile theme for SCHLIX CMS v2.2.x.

The view templates inside the apps and blocks  folder in this theme provide  you with ample amount of customization.
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package companyprofile
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */

// this will retrieve the custom header image
$header_img = \App\Core_MediaHeader::getDefaultCustomHeader($this);
?>
<div class="app-page-category app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-category-<?= $category[$this->field_category_id]; ?>" >   
        <!-- Page Title with custom background image -->
        <div class="media-header-full-width " style="background-image: url('<?= $header_img ?>');">
            <div class="media-header-title container d-flex h-100">
                <div class="row align-self-center w-100">
                    <div class="col-8 mx-auto">
                        <div class="text-center">
                            <h1 class="item title" itemprop="name"><?= ___h($this->getConfig('str_mainpage_title')) ?></h1>
                        </div>
                    </div>
                </div>                
            </div>
        </div>
        <!-- End Page Title -->
        <!-- breadcrumb -->
        <!-- the breadcrumb has been moved from the main theme template file to the individual app's as an example of different variation -->
        <div class="breadcrumb-bg">
            <div class="container">
                <?= \SCHLIX\cmsPageOutput::BreadCrumbs(); ?>
            </div>
        </div>
        <!-- end breadcrumb -->
    
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~# -->
    <!-- ~~~~~~~~~~~# main info of this category -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~# -->
    
    <article class="main category">
        <?= $this->getConfig('str_mainpage_text') ?>
    </article>
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~# -->
    <!-- ~~~~~~~~~~~~ end info of this category -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~# -->
    <?php if ($categories): ?>
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~# -->
    <!-- ~~~~~~~~~ child categories / subfolder -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~# -->
        <div class="main categories">
            <?php foreach ($categories as $category): ?>
                <?php if ($category['status'] > 0): ?>            
                <section class="child-category"> 
                    <?= isset($category['macro_processed_text_outside_article_top']) ? $category['macro_processed_text_outside_article_top'] : null ?>                    
                    <?php 
                    
                        $category_id = $category[$this->getFieldCategoryID()];
                        $this->processDataOutputWithMacro($category, 'viewChildCategory', array('parent_category_meta_options' => $category_meta_options));
                        $link = $this->createFriendlyURL("action=viewcategory&cid={$category_id}");
                        $category_title = ___h($category['title']);
                        $category_title_text = ($category_meta_options['display_child_category_read_more_link']==false || $category_meta_options['display_link_title']==true) ? 
                            \__HTML::A($category_title,$link) : $category_title;
                        
                    ?>
                    <h2 class="category title"><i class="fa fa-folder"></i> <?= $category_title_text; ?></h2>

                    <?php if ($category_meta_options['display_child_category_read_more_link']): ?>
                        <a class="child category" href="<?= $link; ?>"><?= ___('Read More'); ?></a>
                    <?php endif; ?>
                    <!-- Macro - Pre -->
                    <?php if ($category['macro_processed_text_before_article']): ?>        
                        <div class="meta before-article">        
                            <?= $category['macro_processed_text_before_article'] ?>            
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->

                    <!-- text -->
                    <?php if ($category_meta_options['display_item_summary']): ?>
                        <div class="text">
                            <?= $category['summary'] ?>
                        </div>
                    <?php endif; ?>
                    <!-- end text -->

                    <!-- Macro - Post -->   
                    <?php if (isset($category['macro_processed_text_after_article'])): ?>                
                        <div class="meta after-article">
                            <?= $category['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post -->                
                    <?= $category['macro_processed_text_outside_article_bottom'] ?> 
                </section>
                <?php endif ?>
            <?php endforeach ?>       
        </div>
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~# -->
    <!-- ~~~~~~~~~ end child categories / subfolder ~~~~~~~~~~~# -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~# -->
    <?php endif; ?>
    <?php if ($items):  ?>
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~# -->
    <!-- ~~~~~~~~~~~~~ child items ~~~~~~~~~~~~~~~~~~ -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~# -->
       <div class="main items">
            <?php foreach ($items as $child_item): ?>
                <?php if ($child_item['status'] > 0): ?>            
                <section class="child-item">    
                    <?= isset($child_item['macro_processed_text_outside_article_top']) ? $child_item['macro_processed_text_outside_article_top'] : null ?> 
                    <?php 
                        $this->processDataOutputWithMacro($child_item, 'viewChildItem', array('parent_category_meta_options' => $category_meta_options));
                        $link = $this->createFriendlyURL("action=viewitem&id={$child_item['id']}");
                        $child_item_title = ___h($child_item['title']);
                        $child_item_title_text = ($category_meta_options['display_child_item_read_more_link']==false || $category_meta_options['display_link_title']==true) ? 
                            \__HTML::A($child_item_title,$link) : $child_item_title;
                        
                    ?>
                    <h2 class="item title"><i class="fa fa-map"></i> <?= $child_item_title_text; ?></h2>

                    <?php if ($category_meta_options['display_child_item_read_more_link']): ?>
                        <a class="child category" href="<?= $link; ?>"><?= ___('Read More'); ?></a>
                    <?php endif; ?>
                    <!-- Macro - Pre -->
                    <?php if ($child_item['macro_processed_text_before_article']): ?>        
                        <div class="meta before-article">        
                            <?= $child_item['macro_processed_text_before_article'] ?>            
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->

                    <!-- text -->
                    <?php if ($category_meta_options['display_item_summary']): ?>
                        <div class="text">
                            <?= $child_item['summary'] ?>
                        </div>
                    <?php endif; ?>
                    <!-- end text -->

                    <!-- Macro - Post -->   
                    <?php if (isset($child_item['macro_processed_text_after_article'])): ?>                
                        <div class="meta after-article">
                            <?= $child_item['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post --> 
                    <?= $child_item['macro_processed_text_outside_article_bottom'] ?> 
                </section>
                <?php endif ?>
            <?php endforeach ?>       
        </div>     
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~# -->
    <!-- ~~~~~~~~~~~# end child items ~~~~~~~~~~~~~~~~~# -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~# -->
    <?php endif ?>
    <!-- pagination -->
    <?php $pagination_str = $this->displayItemPagination($pg,$pagination['total'],"action=viewcategory&cid={$category['cid']}"); ?>
    <?php if ($pagination_str && ($category_meta_options['display_child_categories'] || $category_meta_options['display_items'])): ?>
        <div class="pagination"><?= $pagination_str; ?></div>
    <?php endif ?>
    <!-- end pagination -->
    <?= $category['macro_processed_text_outside_article_bottom'] ?>
</div>