<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * beritanews - theme for SCHLIX CMS
 *
 * License: MIT
 *  
 * @copyright 2020 SCHLIX Web Inc
 * @license MIT
 * @version 1.0
 * @link    https://www.schlix.com
 */

/**********************************************************************
 * Custom header image needs to be placed in the THEME template file
 * if the template has 1 or more sidebar (2 or 3 column)
 * Otherwise the header image will not be displayed properly.
 * To do this, you will need to specify 2 global variables inside your
 * APP template file: $_custom_header_image and $_custom_header_title.
 * The name is arbitrary but must be the same declaration
 *
 * In this example, the blog will be set to using the regular template
 * if it's displayed on the main page, but on subsequent page it will
 * switch to 2 column (two-column-right-sidebar.template.php)
 * because on its MENU item, the inner pages subtemplate is set to
 * two-column-right-sidebar.template.php.
 *
 * You can change this behaviour if you prefer to use a single column
 * template
 **********************************************************************/

$field_cid = $this->getFieldCategoryID();
$field_id = $this->getFieldID();
$default_header_image =  \App\Core_MediaHeader::getDefaultCustomHeader($this);
$category_header_image = \App\Core_MediaHeader::getCustomHeaderByGUID($this, $category['guid']);

$header_image = $category_header_image ? $category_header_image : $default_header_image;

global $_custom_header_image, $_custom_header_title;
$_custom_header_image = $header_image;
$_custom_header_title = ___h($category['title']); // $this->getConfig('str_mainpage_title');

$current_time = sanitize_string(get_current_datetime());
$invalid_date = sanitize_string(NULL_DATE);

?>
<div class="app-page-category app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-category-<?= $category[$field_cid]; ?>" >
    <?= isset($category['macro_processed_text_outside_article_top']) ? $category['macro_processed_text_outside_article_top'] : null ?>
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~ main info of this category  ~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <article class="main category">
	<?php if ($category_meta_options['display_pagetitle']): ?>
            <h1 class="category title"><?= ___h($category['title']); ?></h1>
        <?php endif; ?>
        <?php if ($category['macro_processed_text_before_article']): ?>
        <!-- Macro - Pre -->
            <div class="meta before-article">
            <?= $category['macro_processed_text_before_article'] ?>
            </div>
        <!-- End Macro - Pre -->
        <?php endif ?>
        <div class="text">
            <?= $category['summary'].$category['description'] ?>
        </div>
        <?php if (isset($category['macro_processed_text_after_article'])): ?>
        <!-- Macro - Post -->
            <div class="meta after-article">
                <?= $category['macro_processed_text_after_article'] ?>
            </div>
        <?php endif ?>
        <!-- End Macro - Post -->
    </article>
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~ end info of this category  ~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->

    <?php if ($child_categories && $category_meta_options['display_child_categories']): ?>
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!-- ~~~~~~~~~~~~~~~~~~ child categories / subfolder ~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
        <div class="category child categories">
            <?php foreach ($child_categories as $child_category): ?>
                <?php if ($child_category['status'] > 0): ?>
                <section class="child-category">
                    <?= $child_category['macro_processed_text_outside_article_top'] ?>
                    <?php
                        $child_category_id = $child_category[$field_cid];
                        $this->processDataOutputWithMacro($child_category, 'viewChildCategory', array('parent_category_meta_options' => $category_meta_options));
                        $link = $this->createFriendlyURL("action=viewcategory&cid={$child_category_id}");
                        $child_category_title = ___h($child_category['title']);
                        $child_category_title_text = ($child_category!= null) && ($category_meta_options['display_child_category_read_more_link']==false || $category_meta_options['display_link_title']==true) ?
                            \__HTML::A($child_category_title,$link) : $child_category_title;

                        $sql_criteria = "status > 0  AND  ((date_expiry IS NULL OR date_expiry = {$invalid_date}) OR date_expiry >= {$current_time})";

                        $items_in_blog_category = $this->getItemsByCategoryID($child_category_id, '*', $sql_criteria, 0, 3, 'date_created', 'desc');

                        $image_size = $category_meta_options['image_display_size'] ? 'image_medium' : 'image_small';
                    ?>
                    <?php if ($child_category_title_text): ?>
                        <h2 class="category title"><?= $child_category_title_text; ?></h2>
                    <?php endif ?>
                    <!-- Macro - Pre -->
                    <?php if ($child_category['macro_processed_text_before_article']): ?>
                        <div class="meta before-article">
                            <?= $child_category['macro_processed_text_before_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->

                    <!-- text -->
                    <?php if ($category_meta_options['display_child_category_summary']): ?>
                        <div class="text">
                            <?= $child_category['summary'] ?>
                        </div>
                    <?php endif; ?>
                    <!-- end text -->

                    <?php // only display this in the frontpage
                          if ($items_in_blog_category && $pg <= 1): ?>
                    <div class="blog-sub-category">
                        <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
                        <!-- child items for sub-category -->

                        <div class="row">
                        <?php foreach ($items_in_blog_category as $blog_item): ?>
                            <?php
                            $link = $this->createFriendlyURL("action=viewitem&id={$blog_item['id']}");
                            $child_item_title = $blog_item['title'];
                            $child_item_title_text =  \__HTML::A($child_item_title,$link) ;
                            ?>

                            <div class="col-sm-4">
                                <!-- intro image -->
                                <?php $intro_img_src = $this->getBlogImage($image_size, $blog_item['summary_intro_image']); ?>
                                <?php if ($category_meta_options['display_summary_intro_image'] && $intro_img_src): ?>
                                    <div class="intro-image">
                                        <figure>
                                          <a href="<?= $link ?>"><img class="intro-image thumbnail" src="<?= $intro_img_src  ?>" alt="<?= ___h($blog_item['summary_intro_image_caption']) ?>"></a>
                                          <?php if ($category_meta_options['display_item_summary_intro_image_caption'] && $blog_item['summary_intro_image_caption']): ?>
                                          <div class="intro-image"><?= $blog_item['summary_intro_image_caption'] ?></div>
                                          <?php endif ?>
                                        </figure>
                                    </div>
                                <h3 class="item title" itemprop="headline"><?= $child_item_title_text; ?></h3>
                                <?php endif ?>
                                <!-- end intro image -->
                            </div>

                        <?php endforeach ?>
                        </div>
                        <!-- end child items for sub-category -->
                        <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->

                    </div>
                    <!-- end child category items -->
                    <?php endif ?>

                    <!-- Macro - Post -->
                    <?php if ($child_category['macro_processed_text_after_article']): ?>
                        <div class="meta after-article">
                            <?= $child_category['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post -->
                    <?= $child_category['macro_processed_text_outside_article_bottom'] ?>
                </section>
                <?php endif ?>
            <?php endforeach ?>
        </div>
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!-- ~~~~~~~~~~~~~~~~~~ end child categories / subfolder ~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <?php endif; ?>


    <?php if ($items && $category_meta_options['display_items']):  ?>
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~ child items ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <?php if (___c($child_categories) > 0): ?>
    <h2><?= ___h(sprintf(___('Latest %s news'), strtolower($category['title']))) ?></h2>
    <?php endif ?>
       <div class="category child items">
            <?php foreach ($items as $child_item): ?>
                <?php if ($child_item['status'] > 0): ?>
                <section class="child-item" itemscope="1" itemtype="http://schema.org/<?= $this->schema_org_type_item; ?>">
                    <?= isset($child_item['macro_processed_text_outside_article_top']) ? $child_item['macro_processed_text_outside_article_top'] : null ?>
                    <?php
                        $child_item_id = $child_item[$field_id];
                        $this->processDataOutputWithMacro($child_item, 'viewChildItem', array('parent_category_meta_options' => $category_meta_options));
                        // force CID
                        $link = $this->createFriendlyURL("action=viewitem&id={$child_item_id}&cid={$category[$this->field_category_id]}");
                        $child_item_title = ___h($child_item['title']);
                        $child_item_title_text = ($child_item != null) && ($category_meta_options['display_child_item_read_more_link']==false || $category_meta_options['display_link_title']==true) ?
                            \__HTML::A($child_item_title,$link) : $child_item_title;

                        $image_size = $category_meta_options['image_display_size'] ? 'image_medium' : 'image_small';


                        $continue_reading = ' <i class="fa fa-arrow-circle-right"></i> '.___('Continue Reading');
                        $continue_reading_link = __HTML::A($continue_reading,$link)

                    ?>

                    <div class="row">
                        <div class="col-sm-12">
                            <?php if ($child_item_title_text): ?>
                                <h3 class="item title" itemprop="headline"><?= $child_item_title_text; ?></h3>
                            <?php endif ?>
                        </div>
                    </div>
                    <?php 
                        $intro_img_src = $this->getBlogImage($image_size, $child_item['summary_intro_image']); 
                        $right_col_size = 8;
                    ?>
                    <div class="row">
                        <?php if ($category_meta_options['display_summary_intro_image'] && $intro_img_src): ?>
                        <div class="col-sm-4">
                            <!-- intro image -->
                            
                                <div class="intro-image">
                                    <figure>
                                      <a href="<?= $link ?>"><img class="intro-image thumbnail" src="<?= $intro_img_src  ?>" alt="<?= ___h($child_item['summary_intro_image_caption']) ?>"></a>
                                      <?php if ($category_meta_options['display_item_summary_intro_image_caption'] && $child_item['summary_intro_image_caption']): ?>
                                      <div class="intro-image"><?= $child_item['summary_intro_image_caption'] ?></div>
                                      <?php endif ?>
                                    </figure>
                                </div>
                            
                            <!-- end intro image -->
                        </div>
                        <?php else: ?>
                            <?php $right_col_size = 12; ?>
                        <?php endif ?>
                        <!-- columns -->
                        <div class="col-sm-<?= $right_col_size ?>">
                            <?php if ($category_meta_options['display_summary_secondary_headline'] && $child_item['summary_secondary_headline']): ?>
                                <div class="secondary-headline">
                                    <?=  $child_item['summary_secondary_headline'] ?>
                                </div>
                            <?php endif; ?>

                            <!-- summary -->
                            <?php if ($category_meta_options['display_item_summary'] && $child_item['summary']): ?>
                                <div class="secondary-headline">
                                    <?=  $child_item['summary'].$continue_reading_link ?>
                                </div>
                            <?php endif; ?>


                        </div>
                    </div>
                    <!-- move it to below summary -->
                    <!-- Macro - Pre -->
                    <?php if ($child_item['macro_processed_text_before_article']): ?>
                        <div class="meta before-article">
                            <?= $child_item['macro_processed_text_before_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->

                    <!-- Macro - Post -->
                    <?php if (isset($child_item['macro_processed_text_after_article'])): ?>
                        <div class="meta after-article">
                            <?= $child_item['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post -->
                    <?= $child_item['macro_processed_text_outside_article_bottom'] ?>
                </section>

                <?php endif ?>
            <?php endforeach ?>
        </div>
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~ end child items ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <?php endif; ?>
    <!-- pagination -->



    <?php $pagination_str = $this->displayItemPagination($pg,$pagination['total'],"action=viewcategory&cid={$category['cid']}"); ?>
    <?php if ($pagination_str && ($category_meta_options['display_child_categories'] || $category_meta_options['display_items'])): ?>
        <div class="pagination"><?= $pagination_str; ?></div>
    <?php endif?>
    <!-- end pagination -->
    <?= $category['macro_processed_text_outside_article_bottom'] ?>
</div>
