<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');

$___initial_memory = memory_get_usage();
$___initial_memory_peak = memory_get_peak_usage();
$third_party_apps = \App\Admin::get3rdPartyApplicationList();
global $CurrentUser, $Application, $CurrentAdminAppName;

$last_10_logs = \App\Core_LogViewer::getLastLog(10);
$log_count = ___c($last_10_logs);

$current_user_info = $CurrentUser->getCurrentUserInfo();
if (!defined ('SCHLIX_THEME_SKIN'))
define('SCHLIX_THEME_SKIN','bootstrap3');
global $SystemConfig;

$colour_theme = $SystemConfig->get('system','str_admin_colors','bg-default');
if (empty($colour_theme))
    $colour_theme =  'bg-schlix-default';
?>
<!DOCTYPE html>
<html>
    <head>
        <?php include('header.template.php'); ?>
    </head>   
    <body>    

        <div class="schlix-wrapper <?= ___h($colour_theme) ?>">

            <!-- Main Header -->
            <header class="main-header schlix-navbar-shade">

                <!-- Logo -->
                <a href="<?= SCHLIX_SITE_HTTPBASE ?>/admin/" class="schlix-tll">
                    <!-- mini logo for sidebar mini 50x50 pixels -->
                    <img src="<?= ADMIN_THEME_URL_PATH; ?>/images/schlix_darkbg_logo_v2_32.png" alt="SCHLIX CMS" title="Main" id="schlix-admin-logo" />
                </a>

                <!-- Header Navbar -->
                <nav class="navbar navbar-static-top schlix-navbar-transparent" role="navigation">
                    <h3 class="navbar-text" id="main-app-description"></h3>


                    <!-- Navbar Right Menu -->
                    <div class="navbar-custom-menu">
                        <ul class="nav navbar-nav">

                            <!-- Notifications Menu -->
                            <li class="dropdown notifications-menu">
                                <!-- Menu toggle button -->
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                    <i class="fas fa-tv"></i>
                                    <span class="label label-warning"><?= $log_count ?></span>
                                </a>
                                <ul class="dropdown-menu">
                                    <li class="header"><?= sprintf(___('Last %s log entries'), $log_count) ?></li>
                                    <li>
                                        <!-- Inner Menu: contains the notifications -->
                                        <ul class="menu">
                                            <?php foreach ($last_10_logs as $log): ?>
                                                <li><!-- start notification -->
                                                    <a href="javascript:void(0)">
                                                        <i class="fas fa-tv text-aqua"></i>&nbsp;<span><?= ___h($log['description']) ?></span>
                                                        <div class="small pull-right"><i class="far fa-clock"></i>&nbsp;<span><?= $log['date_created'] ?></span></div>
                                                    </a>
                                                </li><!-- end notification -->
                                            <?php endforeach; ?>
                                        </ul>
                                    </li>
                                    <li class="footer"><a href="<?= \App\Admin::getAdminApp('core.logviewer') ?>"><?= ___('View all') ?></a></li>
                                </ul>
                            </li>




                            <!-- User Account Menu -->
                            <li class="dropdown user user-menu">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown">

                                    <span class="hidden-xs">
                                        <?php if (isset($current_user_info['avatar']) && !empty(($current_user_info['avatar']))): ?>
                                            <?php
                                            $avatar_small = $CurrentUser->getDataFileURLPath('avatar_small', $current_user_info['avatar']);
                                            ?>
                                            <img src="<?= $avatar_small ?>" id="user_avatar_img_tiny" class="current-user-avatar-tiny" alt="<?= ___h($current_user_info['username']) ?>"  />
                                        <?php else: ?>
                                            <i class="fa fa-user"></i>
                                        <?php endif ?>
                                        <?php if (isset($current_user_info['username'])): ?>
                                        <?= ___h($current_user_info['username']) ?>&nbsp;</span>
                                        <?php endif ?>
                                </a>
                                <ul class="dropdown-menu">
                                    <!-- User image -->
                                    <li class="user-header">
                                        <?php if ($current_user_info['avatar']): ?>
                                            <?php
                                            $avatar_small = $CurrentUser->getDataFileURLPath('avatar_medium', $current_user_info['avatar']);
                                            ?>
                                            <img src="<?= $avatar_small ?>" id="user_avatar_img_small" class="current-user-avatar-small"   alt="<?= ___h($current_user_info['username']) ?>" />
                                        <?php else: ?>

                                            <span class="fa-stack fa-4x">
                                                <i class="far fa-circle fa-stack-2x"></i>
                                                <i class="fa fa-user fa-stack-1x"></i>
                                            </span>                                        
                                        <?php endif ?>
                                        <p>
                                            <?= ___h($current_user_info['username']) ?>
                                            <small><?= ___('Logged in') ?>&nbsp;<?= time_since($_SESSION['logged_in_since']) ?>&nbsp;<?= ___('ago') ?></small>
                                        </p>
                                    </li>
                                    <!-- Menu Body -->
                                    <!-- Menu Footer-->
                                    <li class="user-footer">
                                        <div class="pull-left">
                                            <a href="<?= \App\Admin::getAdminApp('users') . "?action=edititem&id=" . $CurrentUser->getCurrentUserID() ?>" class="btn btn-white"><i class="fa fa-user"></i> <?= ___('Profile') ?></a>
                                        </div>
                                        <div class="pull-right">
                                            <a href="<?= SCHLIX_SITE_HTTPBASE . '/' . get_application_alias('admin') ?>/logout" class="btn btn-default"><i class="fa fa-power-off"></i> <?= ___('Logout') ?></a>
                                        </div>
                                    </li>
                                </ul>
                            </li> 
                        </ul>
                    </div>
                </nav>
            </header>

            <div class="schlix-outer-app-wrapper">
                <div class="schlix-admin-main-content" >
                    <!-- ######################################### -->
                    <!-- ######################################### -->
                    <!-- ######################################### -->
                    <?= \SCHLIX\cmsPageOutput::ApplicationBody(); ?>
                    <!-- ######################################### -->
                    <!-- ######################################### -->
                    <!-- ######################################### -->
                </div>


            </div>
            <?php if (empty($CurrentAdminAppName)): ?>            
                <footer class="schlix-footer">

                    <?= ___('Powered by') ?> <a href="https://www.schlix.com" target="_blank"><img src="<?= SCHLIX_SITE_HTTPBASE; ?>/system/themes/admindefault/images/schlix_darkbg_logo_v2_16.png" alt="SCHLIX CMS" title="SCHLIX CMS" id="schlix-admin-logo" /></a>.<?= ___('Copyright') ?> &copy; 2012 - <?= date('Y') ?> <a href="https://www.schlix.com" target="_blank">SCHLIX Web Inc</a>. <?= ___('All rights reserved') ?>.

                </footer>
            <?php endif ?>
        </div><!-- ./wrapper -->

        <div class="schlix-launcher-dock schlix-launcher-left schlix-launcher-48">
            <div id="schlix-launcher-bar">
                <?= \App\Admin::renderBackendMenuV2(); ?>

            </div>
        </div> 
        <?php include('footer.template.php'); ?>
    </body>
</html>
