<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC, Inc.
// http://www.schlix.com
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

namespace Macro;
/**
 * Inserts block by name. Syntax: {insertblockbyname blockname}
 */
class InsertBlockByName extends \SCHLIX\cmsMacro {

    
    private function processText($text)
    {
        global $Blocks;

        $regex = '/{insertblockbyname\s*.*?}/i';
        // PHP 8.2 compatibility
        if (is_null($text))
            return '';
        preg_match_all($regex, $text, $matches);
        $references = $matches[0];
        $count = ___c($references);
        if ($count > 0) {
            for ($i = 0; $i < $count; $i++) {
                $reference = $references[$i];
                // find the block name
                $block_to_load = trim(str_replace('}', '', str_replace('{', '', str_replace('insertblockbyname', '', $reference))));
                // display block
                ob_start();
                $Blocks->displaySingleBlock($block_to_load);
                $block_output = ob_get_contents();
                ob_end_clean();
                // replace references with output
                $text = str_replace($reference, $block_output, $text);
            }
        }
        return $text;
    }
    //----------------------------------------------------------------------//
    /*
     * Run the macro
     * @global type $HTMLHeader
     * @param array|string $data
     * @param object $caller_object
     * @param string $caller_function
     * @param array $extra_info
     * @return string
     */
    public function Run(&$data, $caller_object, $caller_function, $extra_info = NULL) {
        
        if (is_array($data)) // don't enable it for block (string)
        {
            if (array_key_exists('summary', $data))
                $data['summary'] = $this->processText ($data['summary']);
            if (array_key_exists('description', $data))
                $data['description'] = $this->processText ($data['description']);            
        }
    }

}

?>