<?php
namespace Macro;
/**
 * Gallery - macro class
 * 
 * Gallery to display your work. Similar to image gallery but has the capability to display additional media (image, video) inside each item
 * 
 * @copyright SCHLIX Web Inc
 *
 * @license MIT
 *
 * @package gallery
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    https://www.schlix.com
 */

class Gallery extends \SCHLIX\cmsMacro {

    
    /**
     * ImageGallery app
     * @var \App\ImageGallery
     */
    protected $app_image_gallery = NULL;
    /**
     * To limit 1 instance of this macro per page
     * @var bool 
     */
    protected static $has_this_macro_been_called;
    
    private function processText($text) {
        $album_called = false;
        $latest_called = false;

        if ($this->app_image_gallery === NULL)
            $this->app_image_gallery = new \App\Gallery();

        $macros = $this->getGenericAttributesFromText($text, 'gallery-album');
        if ($macros)
        {
            foreach ($macros as $gallery_macro)
            {
                $attrs = $gallery_macro['attributes'];
                $macro = $gallery_macro['macro'];

                $id = (int) $attrs['id'];
                $max = (int) $attrs['max'];
                if ($id > 0)
                {
                    $category = $this->app_image_gallery->getCategoryByID($id);
                    if ($category && $category['status'] > 0)
                    {
                        start_output_buffer();
                        /////
                        if ($max == 0)
                            $max = 999;
                        $album_images = $this->app_image_gallery->getItemsByCategoryID($category['cid'], '*', 'status > 0', 0, $max, 'sort_order', 'ASC');
                        $this->loadTemplateFile('view.gallery', ['image_gallery_app' => $this->app_image_gallery, 'image_gallery_id' => $id , 'album_images' => $album_images]);
                        /////
                        $replacement_text = end_output_buffer();
                    }
                    if (empty ($replacement_text))                        
                        $replacement_text = sprintf(___('Image Gallery Album ID# %d cannot be found'), $id);
                    $text = str_replace($macro, $replacement_text, $text);
                    // there can only be 1 contact form per page
                    $album_called = true;
                   
                }
            } 
        }
        $macros = $this->getGenericAttributesFromText($text, 'gallery-latest');
        if ($macros)
        {
            foreach ($macros as $gallery_macro)
            {
                $attrs = $gallery_macro['attributes'];
                $macro = $gallery_macro['macro'];

                $count = (int) $attrs['count'];
                if ($count == 0)
                    $count = 10;
            // create an instance
                start_output_buffer();
                /////

                $album_images = $this->app_image_gallery->getAllItems('*', 'status > 0', 0, $count, 'date_created', 'DESC'); // $this->app_image_gallery->getItemsByCategoryID($category['cid'], '*', 'status > 0', 0, 999, 'sort_order', 'ASC');
                $this->loadTemplateFile('view.imagegallery', ['image_gallery_app' => $this->app_image_gallery, 'image_gallery_id' => 'latest' , 'album_images' => $album_images]);
                /////
                $replacement_text = end_output_buffer();
                if (empty ($replacement_text))                        
                    $replacement_text = sprintf(___('Image Gallery Album ID# %d cannot be found'), $id);
                $text = str_replace($macro, $replacement_text, $text);
                // there can only be 1 contact form per page
                $latest_called = true;
            } 
        }
        
        
        if ($album_called || $latest_called)
             static::$has_this_macro_been_called = 'yes';
        return $text;
    }
    /*
     * Run the macro
     * @global \SCHLIX\cmsHTMLPageHeader $HTMLHeader
     * @param array|string $data
     * @param object $caller_object
     * @param string $caller_function
     * @param array $extra_info
     * @return bool
     */
    public function Run(&$data, $caller_object, $caller_function, $extra_info = NULL) {
        global $HTMLHeader;
        if (static::$has_this_macro_been_called != 'yes'){

            if (is_array($data)) { // don't enable it for block (string)
                //$this->app_media->loadAssetHeaders();
                if (array_key_exists('summary', $data))
                    $data['summary'] = $this->processText($data['summary']);
                if (array_key_exists('description', $data))
                    $data['description'] = $this->processText($data['description']);
            } else{
                $data = $this->processText($data);
            }

            return true;
        }
    }
}
            