<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC, Inc.
// http://www.schlix.com
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

global $HTMLHeader;

try
{
    $obj_class = get_class($caller_object);
    $obj_admin_class = $obj_class.'_Admin';
    $obj_admin_class_instance = new $obj_admin_class();
    
    $obj_display_class = str_replace('App\\','', $obj_class);
    $app_description = $caller_object->getApplicationDescription();
    $app_display = (strtolower($obj_display_class) != strtolower($app_description)) ? $app_description.' ('.$obj_display_class.')' : $app_description;
    $edit_main_id = $data[$edit_pk];
    $link = $obj_admin_class_instance->createFriendlyAdminURL("action={$edit_action}&id={$edit_main_id}");
}
catch (Exception $exc)
{
    return false;
}
$data_guid = isset($data['guid']) ? $data['guid'] : '';
?>
<x-ui:row class="frontendeditcontrol-doc-container">
    <!-- col -->
    <x-ui:column xs="9">
        <i class="<?= $edit_icon ?>"></i>&nbsp;<?= $app_display ?>,&nbsp;<?= ___('ID') ?>: <?= $edit_main_id ?>, <?= ___('GUID') ?>: <?= ___h($data_guid) ?>, <?= ___('version') ?>: <?= $data['version'] ?><br />
        <i class="fas fa-calendar-alt"></i>&nbsp;<?= ___('Created') ?>: <?= $data['date_created']?><br />
        <i class="fas fa-calendar-alt"></i>&nbsp;<?= ___('Last Updated') ?>: <?= $data['date_modified']?>
    </x-ui:column>
    <!-- col -->
    <x-ui:column xs="3" class="text-right"><a class="frontendeditcontrol-button" target="_blank" href="<?= $link ?>"><i class="fas fa-pencil-alt"></i> <?= ___('Edit') ?></a></x-ui:column>
    <!-- end col -->
</x-ui:row>

<x-ui:clearboth />
