<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC, Inc.
// http://www.schlix.com
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

namespace Macro;

/**
 * Displays article's original author 
 */
class DisplayArticleMeta extends \SCHLIX\cmsMacro {


    //_______________________________________________________________________________________________________________//
    public function getPagePublishingReadinessErrorArray($data)
    {
        global $CurrentUser;

        $error_list = array();

        // PHP8 fixes
        $dt_expiry = isset($data['date_expiry']) ? $data['date_expiry'] : null;
        $dt_available = isset($data['date_available']) ? $data['date_available'] : null;
        // 2. Is item expired?
        if (!($dt_expiry == NULL) && !( $dt_expiry == NULL_DATE || days_difference_from_today($dt_expiry) > 0 ))
            $error_list[] = ___('This page is no longer published');
        // 3. Is publish date in the future?
        if (days_difference_from_today($dt_available) > 0)
            $error_list[] = ___('This page will be published in the future and not available at this time');
        // 4. Does current user have permission to read this item?
        //	if (!$CurrentUser->hasReadPermission($item['permission_read'])) { displayMessage('No Access','This page is not available for your user group.');return false;}
        if (array_key_exists('permission_read', $data))
        {
            $can_read = $CurrentUser->hasReadPermission($data['permission_read']);
            if (!$can_read)
                $error_list[] = ___('No read access');
        }
        return $error_list;
    }
    
    //----------------------------------------------------------------------//
    /*
     * Run the macro
     * @global type $HTMLHeader
     * @param array|string $data
     * @param object $caller_object
     * @param string $caller_function
     * @param array $extra_info
     * @return bool
     */
    public function validateArticleBeforeView(&$data, $caller_object, $caller_function, $extra_info = NULL) {
        
        if (is_array($data) ) {
            $error_list = $this->getPagePublishingReadinessErrorArray($data);
            if (is_array($error_list) && ___c($error_list) > 0) {
                $local_variables = compact(array_keys(get_defined_vars()));
                start_output_buffer();
                $this->loadTemplateFile('view.errors', $local_variables);
                $error_text = end_output_buffer();
                
                switch ($caller_function)
                {
                    case 'viewCategoryByID':
                        if ($extra_info['item_meta_options']['display_category_summary_noread'])
                        {
                            $data['description'] = $error_text;
                        }  else                            
                        if ($extra_info['category_meta_options']['display_error_no_access'])
                        {
                            $data['summary'] = $error_text;
                            $this->clearAllMacroOutputs($data);
                        } else
                        {
                            $data = null;
                            $data['title'] = ___('Error - No Access');
                            $data['summary'] = $error_text;
                        }
                        break;                        
                    case 'viewChildCategory': 
                    case 'viewChildItem':                         
                        if ($extra_info['parent_category_meta_options']['display_error_no_access'])
                        {
                            $data['summary'] = $error_text;                            
                            $this->clearAllMacroOutputs($data);
                        } else
                        {
                            $data = null;
                        }
                        break;
                    case 'viewMainPageCategory':                     
                    case 'viewMainPageItem':                     
                        $data['summary'] = $error_text;
                        break;
                    case 'viewItemByID':
                        if (isset($extra_info['item_meta_options']['display_item_summary_noread']))
                        {
                            if (!($data['date_expiry'] == NULL) && !( $data['date_expiry'] == NULL_DATE || days_difference_from_today($data['date_expiry']) > 0 ))
                            {
                                $data['summary'] = NULL;
                            }
                            $data['description'] = $error_text;
                        } else
                        {
                            $data['summary'] = $error_text;
                            $data['description'] = '';
                        }
                        break;
                    default: return false;
                }
            }
        }
    }    
    //----------------------------------------------------------------------//
    /*
     * Run the macro
     * @global type $HTMLHeader
     * @param array|string $data
     * @param object $caller_object
     * @param string $caller_function
     * @param array $extra_info
     * @return bool
     */
    public function displayDateCreated(&$data, $caller_object, $caller_function, $extra_info = NULL) {

        if ($this->config['bool_date_created_enabled'] && is_array($data) && array_key_exists('date_created', $data)) { // don't enable it for block (string)
            
            switch ($caller_function)
            {
                case 'viewItemByID': $visible = isset($extra_info['item_meta_options']['display_item_date_created']) &&  $data['date_created'] != NULL_DATE; break;
                case 'viewCategoryByID': $visible = isset($extra_info['category_meta_options']['display_category_date_created']) &&  $data['date_created'] != NULL_DATE; break;
                case 'viewChildCategory': $visible = isset($extra_info['parent_category_meta_options']['display_child_category_date_created']) &&  $data['date_created'] != NULL_DATE; break;
                case 'viewChildItem': $visible = isset($extra_info['parent_category_meta_options']['display_item_date_created']) &&  $data['date_created'] != NULL_DATE; break;
                case 'viewMainPageCategory': $visible = isset($extra_info['main_meta_options']['display_category_date_created']) && $data['date_created'] != NULL_DATE; break;
                case 'viewMainPageItem': $visible = isset($extra_info['main_meta_options']['display_item_date_created']) && $data['date_created'] != NULL_DATE; break;
                default: $visible = ($data['date_created'] != NULL_DATE);break;
            }
            
            if ($visible)
            {
                $local_variables = compact(array_keys(get_defined_vars()));
                start_output_buffer();
                $this->loadTemplateFile('view.date.created', $local_variables);
                $text = end_output_buffer();
                if ($this->config['int_date_created_output_position'] == 1) 
                    $this->appendAfterArticleOuput($data, $text);
                else
                    $this->appendBeforeArticleOuput($data, $text);
            }
        }
    }
    
    protected function clearAllMacroOutputs(&$data)
    {
        $data['macro_processed_text_after_article'] = '';
        $data['macro_processed_text_before_article'] = '';
        $data['macro_processed_text_outside_article_top'] = '';
        $data['macro_processed_text_outside_article_bottom'] = '';
    }
    //----------------------------------------------------------------------//
    /*
     * Run the macro
     * @global type $HTMLHeader
     * @param array|string $data
     * @param object $caller_object
     * @param string $caller_function
     * @param array $extra_info
     * @return bool
     */
    public function displayCreatedBy(&$data, $caller_object, $caller_function, $extra_info = NULL) {
        global $CurrentUser;
        
        if ($this->config['bool_created_by_enabled'] && isset($data['created_by_id']) ) {
            switch ($caller_function)
            {
                case 'viewItemByID': $visible = isset($extra_info['item_meta_options']['display_item_created_by']) && ((int) $data['created_by_id'] > 0); break;
                case 'viewCategoryByID': $visible = isset($extra_info['category_meta_options']['display_category_created_by']) && ((int) $data['created_by_id'] > 0); break;
                case 'viewChildCategory': $visible = isset($extra_info['parent_category_meta_options']['display_child_category_created_by']) && ((int) $data['created_by_id'] > 0); break;
                case 'viewChildItem': $visible = isset($extra_info['parent_category_meta_options']['display_item_created_by']) && ((int) $data['created_by_id'] > 0); break;
                case 'viewMainPageCategory': $visible =  isset($extra_info['main_meta_options']['display_category_created_by']) && ((int) $data['created_by_id'] > 0); break;
                case 'viewMainPageItem': $visible = isset($extra_info['main_meta_options']['display_item_created_by']) && ((int) $data['created_by_id'] > 0); break;
                default: $visible = ((int) $data['created_by_id'] > 0);break;
            }
            if ($visible) {
                $user = \SCHLIX\cmsContextCache::get('user', $data['created_by_id']);
                if (!$user)
                {
                    $user = $CurrentUser->getItemByID($data['created_by_id'], USE_CACHE);
                    \SCHLIX\cmsContextCache::set('user', $data['created_by_id'], $user);
                }
                $local_variables = compact(array_keys(get_defined_vars()));
                start_output_buffer();
                $this->loadTemplateFile('view.created.by', $local_variables);
                $text = end_output_buffer();
                if ($this->config['int_created_by_output_position'] == 1)
                    $this->appendAfterArticleOuput($data, $text);
                else
                    $this->appendBeforeArticleOuput($data, $text);
            }
        }
    }
    
    //----------------------------------------------------------------------//
    /*
     * Run the macro
     * @global type $HTMLHeader
     * @param array|string $data
     * @param object $caller_object
     * @param string $caller_function
     * @param array $extra_info
     * @return bool
     */
    public function displayDateModified(&$data, $caller_object, $caller_function, $extra_info = NULL) {

        if ($this->config['bool_date_modified_enabled'] && isset($data['date_modified'])) { // don't enable it for block (string)
            switch ($caller_function)
            {
                case 'viewItemByID': $visible = isset($extra_info['item_meta_options']['display_item_date_modified']) &&  $data['date_modified'] != NULL_DATE; break;
                case 'viewCategoryByID': $visible = isset($extra_info['category_meta_options']['display_category_date_modified']) &&  $data['date_modified'] != NULL_DATE; break;
                case 'viewChildCategory': $visible = isset($extra_info['parent_category_meta_options']['display_child_category_date_modified']) &&  $data['date_modified'] != NULL_DATE; break;
                case 'viewChildItem': $visible = isset($extra_info['parent_category_meta_options']['display_item_date_modified']) &&  $data['date_modified'] != NULL_DATE; break;
                case 'viewMainPageCategory': $visible = isset($extra_info['main_meta_options']['display_category_date_modified']) && $data['date_modified'] != NULL_DATE; break;
                case 'viewMainPageItem': $visible = isset($extra_info['main_meta_options']['display_item_date_modified'])  && $data['date_modified'] != NULL_DATE; break;
                default: $visible = ($data['date_modified'] != NULL_DATE);break;
            }
            
            if ($visible)
            {
                $local_variables = compact(array_keys(get_defined_vars()));
                start_output_buffer();
                $this->loadTemplateFile('view.date.modified', $local_variables);
                $text = end_output_buffer();
                if ($this->config['int_date_modified_output_position'] == 1) 
                    $this->appendAfterArticleOuput($data, $text);
                else
                    $this->appendBeforeArticleOuput($data, $text);
            }
        }
    }

    //----------------------------------------------------------------------//
    /*
     * Run the macro
     * @global type $HTMLHeader
     * @param array|string $data
     * @param object $caller_object
     * @param string $caller_function
     * @param array $extra_info
     * @return bool
     */
    public function displayModifiedBy(&$data, $caller_object, $caller_function, $extra_info = NULL) {
        global $CurrentUser;
        
        if ($this->config['bool_modified_by_enabled'] && isset($data['modified_by_id']) ) {
            switch ($caller_function)
            {
                case 'viewItemByID': $visible = isset($extra_info['item_meta_options']['display_item_modified_by']) && ((int) $data['modified_by_id'] > 0); break;
                case 'viewCategoryByID': $visible = isset($extra_info['category_meta_options']['display_category_modified_by']) && ((int) $data['modified_by_id'] > 0); break;
                case 'viewChildCategory': $visible = isset($extra_info['parent_category_meta_options']['display_child_category_modified_by']) && ((int) $data['modified_by_id'] > 0); break;
                case 'viewChildItem': $visible = isset($extra_info['parent_category_meta_options']['display_item_modified_by']) && ((int) $data['modified_by_id'] > 0); break;
                case 'viewMainPageCategory': $visible = isset($extra_info['main_meta_options']['display_category_modified_by'])  && ((int) $data['modified_by_id'] > 0); break;
                case 'viewMainPageItem': $visible =  isset($extra_info['main_meta_options']['display_item_modified_by'])  && ((int) $data['modified_by_id'] > 0); break;
                default: $visible = ((int) $data['created_by_id'] > 0);break;
            }
            if ($visible) {
                $user = \SCHLIX\cmsContextCache::get('user', $data['modified_by_id']);
                if (!$user)
                {
                    $user = $CurrentUser->getItemByID($data['modified_by_id'], USE_CACHE);
                    \SCHLIX\cmsContextCache::set('user', $data['modified_by_id'], $user);
                }
                $local_variables = compact(array_keys(get_defined_vars()));
                start_output_buffer();
                $this->loadTemplateFile('view.macro', $local_variables);
                $text = end_output_buffer();
                if ($this->config['int_modified_by_output_position'] == 1)
                    $this->appendAfterArticleOuput($data, $text);
                else
                    $this->appendBeforeArticleOuput($data, $text);
            }
        }
    }    
    //----------------------------------------------------------------------//
    /*
     * Run the macro
     * @global type $HTMLHeader
     * @param array|string $data
     * @param object $caller_object
     * @param string $caller_function
     * @param array $extra_info
     * @return bool
     */
    public function displayViewCount(&$data, $caller_object, $caller_function, $extra_info = NULL) {
        global $CurrentUser;
        
        
        if ($this->config['bool_view_count_enabled'] && is_array($data) && array_key_exists('pageview', $data)) {
            
            switch ($caller_function)
            {
                case 'viewItemByID': $visible = isset($extra_info['item_meta_options']['display_item_view_count']) && ((int) $data['pageview'] > 0); break;
                case 'viewCategoryByID': $visible = isset($extra_info['category_meta_options']['display_category_view_count']) && ((int) $data['pageview'] > 0); break;
                case 'viewChildCategory': $visible = isset($extra_info['parent_category_meta_options']['display_child_category_view_count']) && ((int) $data['pageview'] > 0); break;
                case 'viewChildItem': $visible = isset($extra_info['parent_category_meta_options']['display_item_view_count']) && ((int) $data['pageview'] > 0); break;
                case 'viewMainPageCategory': $visible = isset($extra_info['main_meta_options']['display_category_view_count']) && ((int) $data['pageview'] > 0); break;                
                case 'viewMainPageItem': $visible =  isset($extra_info['main_meta_options']['display_item_view_count']) && ((int) $data['pageview'] > 0); break;                
                default: $visible = ((int) $data['created_by_id'] > 0);break;
            }
            
            if ($visible) {
                $local_variables = compact(array_keys(get_defined_vars()));
                start_output_buffer();
                $this->loadTemplateFile('view.count', $local_variables);
                $text = end_output_buffer();
                switch ($this->config['int_output_position'])
                {
                    case 0: $this->appendBeforeArticleOuput($data, $text); break;
                    case 1: $this->appendAfterArticleOuput($data, $text); break;
                    case 2: $this->appendAtTheTopOfArticleOuput($data, $text); break;
                    case 3: $this->appendAtTheBottomOfArticleOuput($data, $text); break;
                } 
                    
            }
        }
    }
    //----------------------------------------------------------------------//
    /*
     * Run the macro
     * @global type $HTMLHeader
     * @param array|string $data
     * @param object $caller_object
     * @param string $caller_function
     * @param array $extra_info
     * @return bool
     */
    public function displayReadMoreButton(&$data, $caller_object, $caller_function, $extra_info = NULL) {
        global $CurrentUser;
        
        
        if ($this->config['bool_readmore_enabled'] && is_array($data)) {
            
            //$has_description = !empty(trim(strip_tags($data['description'])));
            switch ($caller_function)
            {
                case 'viewChildCategory': 
                    $visible = $extra_info['parent_category_meta_options']['display_child_category_read_more_link']; 
                    $cid =$data[$caller_object->getFieldCategoryID()];
                    if ($visible) $link = $caller_object->createFriendlyURL("action=viewcategory&cid={$cid}");
                    break;
                case 'viewChildItem': 
                    $visible = $extra_info['parent_category_meta_options']['display_item_read_more_link']; 
                    $id =$data[$caller_object->getFieldID()];
                    if ($visible) $link = $caller_object->createFriendlyURL("action=viewitem&id={$id}");
                    break;
                case 'viewMainPageItem':               
                    $id =$data[$caller_object->getFieldID()];
                    $visible = $extra_info['main_meta_options']['display_item_read_more_link']; 
                    if ($visible) $link = $caller_object->createFriendlyURL("action=viewitem&id={$id}");             
                    break;
                default: return false;
            }
            
            if ($visible) {
                $local_variables = compact(array_keys(get_defined_vars()));
                start_output_buffer();
                $this->loadTemplateFile('view.readmore', $local_variables);
                $text = end_output_buffer();
                $this->appendAfterArticleOuput($data, $text);
            }
        }
    }
    
    //----------------------------------------------------------------------//
    /*
     * Run the macro
     * @global type $HTMLHeader
     * @param array|string $data
     * @param object $caller_object
     * @param string $caller_function
     * @param array $extra_info
     * @return bool
     */
    public function Run(&$data, $caller_object, $caller_function, $extra_info = NULL) {
        
        // Only for apps
        if (!is_array($data))
            return false;
        $methods = array ( 
          array ('function'=> 'displayDateCreated', 'sort_order' => $this->config['int_date_created_sort_order']),
          array ('function'=> 'displayCreatedBy', 'sort_order' => $this->config['int_created_by_sort_order']),
          array ('function'=> 'displayDateModified', 'sort_order' => $this->config['int_date_modified_sort_order']),
          array ('function'=> 'displayModifiedBy', 'sort_order' => $this->config['int_modified_by_sort_order']),
          array ('function'=> 'displayViewCount', 'sort_order' => $this->config['int_view_count_sort_order']),
          array ('function'=> 'displayReadMoreButton', 'sort_order' => $this->config['int_read_more_sort_order'])
          );
        sort_associative_array_by_key($methods, 'sort_order');
        
        foreach ($methods as $method)
        {
            $method_name = $method['function'];
            $this->$method_name($data, $caller_object, $caller_function, $extra_info);
        }
        
        $this->validateArticleBeforeView($data, $caller_object, $caller_function, $extra_info);
        return true;
    }
    
}

