<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

if (!defined('SCHLIX_VERSION'))
    die('No Access');
?>
<?php
$icon = \App\Core_ApplicationManager::getApplicationIcon($this->full_app_name);
$package_info = \App\Core_ApplicationManager::getPackageInfo('app', $this->app_name);

$app_admin = new \App\Core_ApplicationManager_Admin();

$icon_exists = \__HTML::I('', ['class' => 'fas fa-check text-green']);
?>
<div class="content">
    <x-ui:row>
        <?php if ($icon): ?>
            <x-ui:column xs="5" sm="4" md="2">            
                <img src="<?= \App\Core_ApplicationManager::getApplicationIcon($this->full_app_name) ?>" alt="<?= ___h($this->full_app_name) ?>" />
            </x-ui:column>
        <?php endif ?>
        <x-ui:column xs="7" sm="8" md="10">                    
            <h1><?= $this->app->getOriginalApplicationDescription() ?></h1>        
        </x-ui:column>
    </x-ui:row>
        <?php if ($package_info): ?>
        <table class="table table-condensed">
        <?php foreach ($package_info as $key => $value): ?>
        <tr>
            <td><?= ___h($key) ?></td>
            <td><?= ___h($value) ?></td>
        </tr>
        <?php endforeach ?>
        </table>
    <?php endif ?>
    
    <?php 
        $class_file_info = $this->getCustomizableClassInfo();
    ?>
    <?php /*
    <h3><?= ___('Customizable file(s)') ?></h3>
    <table class="table table-condensed">
    <?php foreach ($class_file_info['main_files'] as $c): ?>
    <tr>
        <td><?= $c['text'] ?> </td>
    </tr>
    <?php endforeach ?>
    </table>*/ ?>
    <?php if (___c($class_file_info['view_files']) > 0): ?>
    <?php 
        $total_in_system = 0;
        $total_in_subsite = 0;
        foreach ($class_file_info['view_files'] as $vf)
        {
            $total_in_system += (int) $vf['is_in_system'];
            $total_in_subsite += (int) $vf['is_in_web'];
        }
    ?>
    <h3><?= ___('Customizable view file(s)') ?></h3>
    <p><?= ___('The following is a list of view template files currently in use in sub-directory') ?>: <strong><?= '/'.___h($this->app_relative_directory) ?></strong></p>
    <table class="table table-condensed">
        <th><?= ___('File') ?></th>
        <?php if ($total_in_system > 0): ?>
        <th><?= SCHLIX_SYSTEM_URL_PATH.'/'.___h($this->app_relative_directory) ?></th>
        <?php endif ?>
        <?php if ($total_in_subsite > 0): ?>
        <th><?= CURRENT_SUBSITE_URL_PATH.'/'.___h($this->app_relative_directory) ?></th>
        <?php endif ?>
        <th><?= CURRENT_THEME_URL_PATH.'/'.___h($this->app_relative_directory) ?></th>
    <?php foreach ($class_file_info['view_files'] as $vf): ?>
    <tr>
        <td><?= ___h($vf['filename']) ?> </td>
        <?php if ($total_in_system > 0): ?>
        <td><?= $vf['is_in_system'] && !$vf['is_in_web'] && !$vf['is_in_theme'] ? $icon_exists : null ?> </td>
        <?php endif ?>
        <?php if ($total_in_subsite > 0): ?>
        <td><?= $vf['is_in_web'] && !$vf['is_in_theme']? $icon_exists : null ?> </td>
        <?php endif ?>
        <td><?= $vf['is_in_theme'] ? $icon_exists : null ?> </td>
    </tr>
    <?php endforeach ?>
    </table>
    <?php endif ?>
    <?php if (!$app_admin->isSystem($this->app_name)): ?>
        <p><a href="<?= $app_admin->createFriendlyAdminURL('action=uninstall&name=' . convert_into_sef_friendly_title($this->app_name)); ?>">
                <i class="fa fa-times-circle"></i> <?= ___('Uninstall') ?></a></p>
    <?php endif ?>    
</div>