<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

const JS_SCHLIX_DEBUG = 1;
const JS_SCHLIX_MIN_ONLY = 2;
const JS_SCHLIX_GZIP = 3;



define('RETURN_AS_AJAX', FALSE);
define('RETURN_FULLPAGE', TRUE);

define('AJAX_REPLY_OK', 200);
define('AJAX_REPLY_ERROR', 400);


define('FROM_CACHE', true);
define('NO_CACHE', false);

define ('EMPTY_STRING','');
// deprecated
define('DEFAULT_DATE_FORMAT','Y-m-d H:i:s');
define('SCHLIX_DATE_FORMAT_READABLE',  'D, Y-M-d @ H:i');
define('SCHLIX_DATE_FORMAT_ISO8601',  'Y-m-d H:i:s');
define('SCHLIX_DATE_FORMAT_JS_ISO8601',  'Y-m-d\TH:i:s');
define('SCHLIX_DATE_FORMAT_YMDHI',  'Y-M-d @ H:i');
define('SCHLIX_FORMAT_MDY',  'M d, Y');
define('SCHLIX_FORMAT_MDYD',  'M d, Y (D)');
define('SCHLIX_FORMAT_TIME',  'H:i');

define ('SAVE_OK',"Save_OK");
define ('SAVE_INVALID_DATA',"Save_Invalid_Data");

define ('BLANK_GUID','00000000-0000-0000-0000-000000000000');

define ('TXT_PAGINATION_STRING','Page %10d of %10d');
define ('TXT_PAGINATION_FIRST','&laquo;&laquo;');
define ('TXT_PAGINATION_PREV','&laquo;');
define ('TXT_PAGINATION_LAST','&raquo;&raquo;');
define ('TXT_PAGINATION_NEXT','&raquo;');
define ('NULL_DATE','0000-00-00 00:00:00');
define ('DEFAULT_FRONTEND_ITEMS_PERPAGE',10);
define ('HARDCODE_MAX_EMAILS_PER_HOUR', 180);
define ('HARDCODE_MAX_EMAILS_PER_BATCH', 10);
define ('HARDCODE_MAX_MUTEX_LOCKTIME',600); // Max lock per process: 10 minutes (600 seconds)
define ('HARDCODE_MAX_ROWLIMIT',10000); // generous for small servers - 10,000 rows max
define ('DATATABLE_DEFAULT_ROWS_PERPAGE',15);
define ('DATATABLE_MAX_ROWS_PERPAGE',100);

define ('USE_CACHE','true');
define ('USE_NO_CACHE','false');

define ('OPT_REDIRECT_DEFAULT',0);
define ('OPT_REDIRECT_HTTPS',1);
define ('OPT_REDIRECT_HTTP',2);

define ('SCHLIX_DEPRECATED_AJAX_TREENODEID_PREFIX','gwp_leftfolder_');
define ('SCHLIX_SESSION_NAME', 'scx'.md5($_SERVER['REMOTE_ADDR'].$_SERVER['HTTP_USER_AGENT']));
define ('SCHLIX_SYSTEM_MSFTWIN', strtoupper(substr(PHP_OS, 0, 3)) == 'WIN');

// fix for PHP8
define('EMAIL_PRIORITY_NORMAL', 0);
define('EMAIL_PRIORITY_HIGH', 1);
define('EMAIL_PRIORITY_LOW',-1);


// In case someone forgets to put the settings in config.inc.php
if (!defined('SCHLIX_DEFAULT_ADMIN_GROUP')) define ('SCHLIX_DEFAULT_ADMIN_GROUP','Administrators');
//2017-09-01
global $SchlixSupportedLanguages;

$SchlixSupportedLanguages =
    [
    'be'=> 'Belarusian (Беларуская мова)',
    'bg'=> 'Bulgarian (Български)',
    'zh_cn'=> 'Chinese Simplified (简体中文)',
    'zh_tw'=> 'Chinese Traditional (繁體中文)',
    'hr'=> 'Croatian (Hrvatski)',
    'cs'=> 'Czech (Čeština)',
    'da'=> 'Danish (Dansk)',
    'nl'=> 'Dutch (Nederlands)',
    'et'=> 'Estonian (Eesti)',
    'tl'=> 'Filipino (Tagalog)',
    'fi'=> 'Finnish (Suomi)',
    'fr'=> 'French (Français)',
    'ka'=> 'Georgian (ქართული)',        
    'de'=> 'German (Deutsch)',        
    'el'=> 'Greek (Ελληνικά)',
    'hi'=> 'Hindi (हिन्दी)',
    'hu'=> 'Hungarian (Magyar)',
    'id'=> 'Indonesian (Indonesia)',    
    'it'=> 'Italian (Italiano)',
    'ja'=> 'Japanese (日本語)',
    'kk' => 'Kazakh (Қазақ Tілі)',        
    'ko'=> 'Korean (한국어)',
    'mk'=> 'Macedonian (Mакедонски)',
    'mn'=> 'Mongolian (Монгол Хэл)',
    'ms'=> 'Malay (Melayu)',
    'no'=> 'Norwegian (Norsk)',
    'pl'=> 'Polish (Język polski)',
    'pt'=> 'Portuguese (Português)',
    'ro'=> 'Romanian (Română)',
    'ru'=> 'Russian (Русский)',
  
    'sk'=> 'Slovak (Slovenčina)',
    'sl'=> 'Slovenian (Slovenščina)',
    'es'=> 'Spanish (Español)',
    'sv'=> 'Swedish (Svenska)',
    'th'=> 'Thai (ไทย)',
    'tr'=> 'Turkish (Türkçe)',
    'uk'=> 'Ukrainian (Українська)',
    'vi'=> 'Vietnamese (Tiếng Việt)',
    'ar' => 'Arabic (عربى) - BETA',
    'iw' => 'Hebrew (עברית) - BETA',
    'fa' => 'Persian (فارسی) - BETA'
    
    ];
 
